/*
*********************************************************************
  Copyright(c) 2015 Imagine Communications Corp. All Rights Reserved.

  THIS IS AN UNPUBLISHED PROPRIETARY SOURCE CODE OF IMAGINE
  COMMUNICATIONS CORP.

  The copyright notice above does not evidence any actual or intended
  publication of such source code.

********************************************************************

 FMM Database

this file is intended for updating schema on an existing database without
touching its old data

ver 0.5 fme table changes 2/12/2016
*********************************************************************
*/

/*********************************************************************
 *
 * check system tables integrity
 *
 *********************************************************************/



CREATE DATABASE IF NOT EXISTS FMM;

GRANT ALL ON FMM.* TO'';
FLUSH PRIVILEGES;

use FMM;

create table IF NOT EXISTS dbver(
 ver int not null primary key,
 install_date TIMESTAMP not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);


 /*********************************************************************
  *
  * following is for updating schema
  *
  *********************************************************************/
 repair table mysql.proc;

 DROP PROCEDURE IF EXISTS schema_change;

 delimiter ';;'
 CREATE PROCEDURE schema_change()
 begin
  if not exists( select 1 from dbver limit 1) THEN

   CREATE TABLE IF NOT EXISTS fmm_config
   (
    ldalp_server varchar(64),
    ntp_server varchar(32),         -- NTP Server IP
    ntp_port int DEFAULT 123,       -- NTP Server Port
    license_server varchar(32),     -- License Server IP
    license_port int DEFAULT 15000, -- License Server Port
    license_systemId bigint DEFAULT 0,        -- License Server SystemID
    available_services int DEFAULT 0,
    managed_services int DEFAULT 0
   ) CHARACTER SET latin1;

   SET FOREIGN_KEY_CHECKS = 0;
   CREATE TABLE IF NOT EXISTS element_type
   (
    fme_type varchar(64),
    PRIMARY KEY (fme_type)
   ) CHARACTER SET latin1;
   SET FOREIGN_KEY_CHECKS = 1;

   CREATE TABLE IF NOT EXISTS fme_trans
   (
    fme_ip_address varchar(32),
    next_trans_id int,
    last_trans_id int,
    last_trans_result ENUM('success', 'failure'),
    last_trans_error varchar(1024),
    PRIMARY KEY (fme_ip_address)
   ) CHARACTER SET latin1;

   /* Table structure for FME common system configuration 'fme' */
   SET FOREIGN_KEY_CHECKS = 0;
   CREATE TABLE IF NOT EXISTS fme
   (
    fme_ip_address varchar(32),
    fme_type varchar(64),
    state  ENUM('connected', 'not-connected', 'failed', 'busy') DEFAULT 'not-connected',
    cfg_cnt  int DEFAULT 0,
    version varchar(256),
    interfaces varchar(2048),
    properties varchar(2048),
    alarm_threshold int DEFAULT 10,
    lic_systemId varchar(256),
    manager_ip varchar(32),
    managed_svc_cnt int DEFAULT 0,
    interface_version varchar(64) NOT NULL default '',
    remote_user varchar(64),
    remote_pass varchar(64),
    preset_timestamp datetime NOT NULL default '0000-00-00 00:00:00',
    PRIMARY KEY (fme_ip_address),
    FOREIGN KEY (fme_type) REFERENCES element_type (fme_type)
   ) CHARACTER SET latin1;

   CREATE TABLE IF NOT EXISTS fme_redundancy_pair
   (
    primary_ip_address varchar(32),
    secondary_ip_address varchar(32),
    primary_state  ENUM('active', 'standby', 'none'),
    pair_state ENUM('fail', 'end', 'begin'),
    fail_reason varchar(256),
    PRIMARY KEY (primary_ip_address, secondary_ip_address),
    FOREIGN KEY (primary_ip_address) REFERENCES fme (fme_ip_address),
    FOREIGN KEY (secondary_ip_address) REFERENCES fme (fme_ip_address)
   ) CHARACTER SET latin1;
   SET FOREIGN_KEY_CHECKS = 1;

   /*
    * create fme_redundancy_groups table
    */
   CREATE TABLE IF NOT EXISTS fme_redundancy_groups
   (
    name varchar(32) NOT NULL,
    object_id int NOT NULL AUTO_INCREMENT,
    failover_threshold int DEFAULT 10,
    PRIMARY KEY (object_id)
   ) CHARACTER SET latin1
    AUTO_INCREMENT = 1;

   /*
    * create fme_redundnacy_members table
    */
   SET FOREIGN_KEY_CHECKS = 0;
   CREATE TABLE IF NOT EXISTS fme_redundancy_members
   (
    fme_ip varchar(32) NOT NULL,
    group_id int NOT NULL,
    role ENUM('primary', 'backup'),
    state ENUM('active', 'standby', 'fail'),
    pair_ip varchar(32),
    pair_state ENUM('fail', 'end', 'begin'),
    fail_reason varchar(256),
    PRIMARY KEY (fme_ip),
    FOREIGN KEY (fme_ip) REFERENCES fme (fme_ip_address),
    FOREIGN KEY (group_id) REFERENCES fme_redundancy_groups (object_id)
   ) CHARACTER SET latin1;
   SET FOREIGN_KEY_CHECKS = 1;

   CREATE TABLE IF NOT EXISTS fme_cfg_json_id
   (
    fme_ip_address varchar(32),
    next_cfg_json_id int,
    PRIMARY KEY (fme_ip_address)
   ) CHARACTER SET latin1;

   /* Table structure for configuration object 'cfg_obj' */

   CREATE TABLE IF NOT EXISTS cfg_obj
   (
    fme_ip_address varchar(32),
    obj_type varchar(64),
    obj_name varchar(64),
    obj_id varchar(64),
    obj_index int,
    parent_obj_id varchar(64),
    json_id int NOT NULL AUTO_INCREMENT,
    cfg_cnt int,
    accepted int,
    PRIMARY KEY (json_id),
    KEY (fme_ip_address, obj_type, obj_name, obj_id)
   ) CHARACTER SET latin1;

   /* Table structure for object json file 'json_obj' */
   CREATE TABLE IF NOT EXISTS json_obj
   (
   json_id int,           -- index for this json object
   cont_idx int,           -- continuation index for long json
   json_obj varchar(18432)
   ) CHARACTER SET latin1;


   CREATE TABLE IF NOT EXISTS alarms
   (
    fme_ip_address varchar(32),
    id int,
    identifier varchar(128),
    description varchar(256),
    priority int,
    enable int,
    raise_delay int,
    clear_delay int,
    count int default 0,
    PRIMARY KEY (fme_ip_address, id)
   ) CHARACTER SET latin1;

   CREATE TABLE IF NOT EXISTS active_alarms
   (
    fme_ip_address varchar(32),
    id int,
    reason varchar(256),
    time_stamp datetime,
    object_id varchar(64),
    PRIMARY KEY (fme_ip_address, id, object_id)
   ) CHARACTER SET latin1;

   CREATE TABLE IF NOT EXISTS alarm_log
   (
    fme_ip_address varchar(32) not null,
    id int not null,
    time_stamp datetime not null,
    reason varchar(256),
    object_type varchar(64),                -- object type of alarm
    object_id varchar(64),                  -- object id of alarm
    raised boolean not null
   ) CHARACTER SET latin1;

   SET FOREIGN_KEY_CHECKS = 0;
   CREATE TABLE IF NOT EXISTS presets
   (
    fme_ip_address varchar(32),
    name varchar(32),
    fme_type varchar(64),
    interface_version varchar(64) NOT NULL default '',
    PRIMARY KEY (name),
    FOREIGN KEY (fme_type) REFERENCES element_type (fme_type)
   ) CHARACTER SET latin1;

   CREATE TABLE IF NOT EXISTS templates
   (
    name varchar(64) NOT NULL default '',
    fme_type varchar(64) NOT NULL default '',
    obj_type varchar(64) NOT NULL default '',
    sub_type varchar(64) NOT NULL default '',
    interface_version varchar(64) NOT NULL default '',
    set_as_default boolean NOT NULL DEFAULT false,
    PRIMARY KEY (name),
    FOREIGN KEY (fme_type) REFERENCES element_type (fme_type)
   ) CHARACTER SET latin1;
   SET FOREIGN_KEY_CHECKS = 1;

   CREATE TABLE IF NOT EXISTS fme_objects
   (
    fme_ip_address varchar(32),
    objects_type varchar(32)
   ) CHARACTER SET latin1;

   /* Table structure for request result */
   CREATE TABLE IF NOT EXISTS results
   (
    fme_ip_address varchar(32) not null,
    msg_type varchar(32) not null,
    obj_type varchar(64) not null,
    obj_name varchar(64) not null,
    session_id varchar(64) not null,
    result   varchar(32),
    reason   varchar(256),
    time_stamp datetime not null
   ) CHARACTER SET latin1;

   /* Table structure for licenses object 'licenses' */

   CREATE TABLE IF NOT EXISTS licenses
   (
    fme_ip_address varchar(32) NOT NULL,
    feature_id varchar(128) NOT NULL,
    name varchar(128),
    max_instances int,
    used_instances int,
    end_date varchar(64),
    PRIMARY KEY (fme_ip_address, feature_id)
   ) CHARACTER SET latin1;

   /* Table structure for SNMP trap destinations 'snmp_destinations' */
   CREATE TABLE IF NOT EXISTS snmp_destinations
   (
    id int NOT NULL AUTO_INCREMENT,
    server_ip_address varchar(32),        -- SNMP destination IP
    server_ip_port int DEFAULT 162,       -- SNMP destination Port
    PRIMARY KEY (id)
   ) CHARACTER SET latin1;
 /* sample of adding new columns

  if not exists (select * from information_schema.columns where table_name = 'fmm_config' and column_name = 'ntp_server') then
   alter table fmm_config add column `ntp_server` varchar(32) NULL;
  end if;

 */

 /*
  * added fail_reason in fme_redundancy_pair table
  */
  if not exists (select * from information_schema.columns where table_name = 'fme_redundancy_pair' and column_name = 'fail_reason') then
   alter table fme_redundancy_pair add column `fail_reason` varchar(256);
  end if;

 /*
  * add fme systemID for local license server
  */
  if not exists (select * from information_schema.columns where table_name = 'fme' and column_name = 'lic_systemId') then
   alter table fme add column `lic_systemId` varchar(256);
  end if;

 /*
  * add fme state
  */
  if not exists (select COLUMN_TYPE from information_schema.columns where table_name = 'fme' and column_name = 'state' and column_type='enum(''connected'',''not-connected'',''failed'',''managed'',''unmanaged'')') then
   alter table fme modify column state  ENUM('connected', 'not-connected', 'failed', 'managed', 'unmanaged') DEFAULT 'not-connected';
  end if;

 /*
  * add fme manager_ip
  */
  if not exists (select * from information_schema.columns where table_name = 'fme' and column_name = 'manager_ip') then
   alter table fme add column `manager_ip` varchar(32);
  end if;

 /*
  * add fme interface_version
  */
  if not exists (select * from information_schema.columns where table_name = 'fme' and column_name = 'interface_version') then
   alter table fme add column `interface_version` varchar(64) NOT NULL default '';
  end if;

 /*
  * add fme preset_timestamp
  */
  if not exists (select * from information_schema.columns where table_name = 'fme' and column_name = 'preset_timestamp') then
   alter table fme add column `preset_timestamp` datetime NOT NULL default '0000-00-00 00:00:00';
  end if;

 /*
  * add fme discovery_timestamp
  */
  if not exists (select * from information_schema.columns where table_name = 'fme' and column_name = 'discovery_timestamp') then
   alter table fme add column `discovery_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;
  end if;

 /*
  * add presets fme_type
  */
  if not exists (select * from information_schema.columns where table_name = 'presets' and column_name = 'fme_type') then
   alter table presets add column `fme_type` varchar(64);
  end if;

 /*
  * add presets interface_version
  */
  if not exists (select * from information_schema.columns where table_name = 'presets' and column_name = 'interface_version') then
   alter table presets add column `interface_version` varchar(64) NOT NULL default '';
  end if;

 /*
  * add ntp server port for fmm
  */
  if not exists (select * from information_schema.columns where table_name = 'fmm_config' and column_name = 'ntp_port') then
   alter table fmm_config add column `ntp_port` int default 123;
  end if;

 /*
  * add license server ip for fmm
  */
  if not exists (select * from information_schema.columns where table_name = 'fmm_config' and column_name = 'license_server') then
   alter table fmm_config add column `license_server` varchar(32);
  end if;

 /*
  * add license server port for fmm
  */
  if not exists (select * from information_schema.columns where table_name = 'fmm_config' and column_name = 'license_port') then
   alter table fmm_config add column `license_port` int default 15000;
  end if;

 /*
  * add fme managed_svc_cnt
  */
  if not exists (select * from information_schema.columns where table_name = 'fme' and column_name = 'managed_svc_cnt') then
   alter table fme add column `managed_svc_cnt` int default 0;
  end if;

 /*
  * add fmm available_services
  */
  if not exists (select * from information_schema.columns where table_name = 'fmm_config' and column_name = 'available_services') then
   alter table fmm_config add column `available_services` int default 0;
  end if;

 /*
  * add fmm managed_services for remote managed services
  */
  if not exists (select * from information_schema.columns where table_name = 'fmm_config' and column_name = 'managed_services') then
   alter table fmm_config add column `managed_services` int default 0;
  end if;

 /*
  * add fmm license_systemID for central license server
  */
  if not exists (select * from information_schema.columns where table_name = 'fmm_config' and column_name = 'license_systemId') then
   alter table fmm_config add column `license_systemId` bigint default 0;
  end if;

 /*
  * change alarm_threshold default value in fme table
  */
  if exists (select * from information_schema.columns where table_name = 'fme' and column_name = 'alarm_threshold') then
   alter table fme alter alarm_threshold set default 10;
  end if;

 /*
  * change failover_threshold default value in fme_redundancy_groups table
  */
  if exists (select * from information_schema.columns where table_name = 'fme_redundancy_groups' and column_name = 'failover_threshold') then
   alter table fme_redundancy_groups alter failover_threshold set default 10;
  end if;

 /*
  * change identifier size in alarms table
  */
  if exists (select * from information_schema.columns where table_name = 'alarms' and column_name = 'identifier') then
   alter table alarms modify identifier varchar(128);
  end if;

  if not exists( select * from information_schema.columns where table_name='cfg_obj' and column_name='json') THEN
   alter table cfg_obj add column json longtext;
   create table json_temp( id int(11) primary key, json longtext);
   set GROUP_CONCAT_MAX_LEN =999999999999;
   insert into json_temp(id,json) select json_id, GROUP_CONCAT(json_obj SEPARATOR '') as json from json_obj group by json_id;
   set GROUP_CONCAT_MAX_LEN =1024;
   update cfg_obj set json=(select json from json_temp where id=cfg_obj.json_id);
   drop table json_temp;
   drop table json_obj;
  END IF;
  insert into dbver(ver) values(1);

end if;

 if 1=(select max(ver) from dbver) then
  alter table snmp_destinations drop column id;
  alter table snmp_destinations add primary key (server_ip_address,server_ip_port);
  alter table cfg_obj add constraint unique (fme_ip_address,obj_id);
  insert into dbver(ver) values(2);
 end if;
  if 2=(select max(ver) from dbver) then
   alter table fme_redundancy_groups add constraint unique (name);
   insert into dbver(ver) values(3);
  end if;

  if 3=(select max(ver) from dbver) then
   alter table fme_trans MODIFY column last_trans_error LONGTEXT;
   alter table fme MODIFY column interfaces LONGTEXT;
   alter table fme MODIFY column properties LONGTEXT;
   alter table fme_redundancy_pair MODIFY column fail_reason LONGTEXT;
   alter table fme_redundancy_members MODIFY column fail_reason LONGTEXT;
   alter table alarms MODIFY column description LONGTEXT;
   alter table active_alarms MODIFY column reason LONGTEXT;
   alter table alarm_log MODIFY column reason LONGTEXT;
   alter table results MODIFY column reason LONGTEXT;
   insert into dbver(ver) values(4);
  end if;

  if 4=(select max(ver) from dbver) then
   alter table fme add column compatible ENUM('no', 'yes', 'limited') NOT NULL default 'yes';
   alter table fme add column compatible_msg longtext;
   insert into dbver(ver) values(5);
  end if;

  if 5=(select max(ver) from dbver) then
   alter table alarms add column `location` varchar(256) default '[]' not null;
   alter table alarms drop primary key;
   alter table alarms add primary key (fme_ip_address,id,location);
   insert into dbver(ver) values(6);
  end if;

  if 6=(select max(ver) from dbver) then
   alter table active_alarms add column `location` varchar(256) default '' not null;
   alter table active_alarms drop primary key;
   alter table active_alarms add primary key (fme_ip_address,id,object_id,location);
   alter table alarm_log add column `location` varchar(256) default '' not null;
   insert into dbver(ver) values(7);
  end if;

  if 7=(select max(ver) from dbver) then
    if not exists (select * from information_schema.columns where table_name = 'fme' and column_name = 'fme_name') then
      alter table fme add column `fme_name` varchar(256);
    end if;
    insert into dbver(ver) values(8);
  end if;

  if 8=(select max(ver) from dbver) then
    -- DB to utf8mb4
    ALTER DATABASE FMM CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci;
    -- Columns to utf8mb4
    ALTER TABLE active_alarms CHANGE reason reason LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
    ALTER TABLE alarm_log CHANGE reason reason LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
    ALTER TABLE alarms CHANGE description description LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
    ALTER TABLE cfg_obj CHANGE json json LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
    ALTER TABLE fme CHANGE interfaces interfaces LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
    ALTER TABLE fme CHANGE properties properties LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
    ALTER TABLE fme CHANGE fme_name fme_name VARCHAR(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
    ALTER TABLE fme CHANGE compatible_msg compatible_msg LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
    ALTER TABLE fme_redundancy_groups CHANGE name name VARCHAR(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL;
    ALTER TABLE fme_redundancy_members CHANGE fail_reason fail_reason LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
    ALTER TABLE fme_redundancy_pair CHANGE fail_reason fail_reason LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
    ALTER TABLE fme_trans CHANGE last_trans_error last_trans_error LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
    ALTER TABLE licenses CHANGE name name VARCHAR(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
    ALTER TABLE presets CHANGE name name VARCHAR(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL;
    ALTER TABLE results CHANGE reason reason LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
    ALTER TABLE templates CHANGE name name VARCHAR(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '';
    -- Recalibrate DB
    REPAIR TABLE active_alarms;
    REPAIR TABLE alarm_log;
    REPAIR TABLE alarms;
    REPAIR TABLE cfg_obj;
    REPAIR TABLE fme;
    REPAIR TABLE fme_redundancy_groups;
    REPAIR TABLE fme_redundancy_members;
    REPAIR TABLE fme_redundancy_pair;
    REPAIR TABLE fme_trans;
    REPAIR TABLE licenses;
    REPAIR TABLE presets;
    REPAIR TABLE results;
    REPAIR TABLE templates;
    OPTIMIZE TABLE active_alarms;
    OPTIMIZE TABLE alarm_log;
    OPTIMIZE TABLE alarms;
    OPTIMIZE TABLE cfg_obj;
    OPTIMIZE TABLE fme;
    OPTIMIZE TABLE fme_redundancy_groups;
    OPTIMIZE TABLE fme_redundancy_members;
    OPTIMIZE TABLE fme_redundancy_pair;
    OPTIMIZE TABLE fme_trans;
    OPTIMIZE TABLE licenses;
    OPTIMIZE TABLE presets;
    OPTIMIZE TABLE results;
    OPTIMIZE TABLE templates;
    insert into dbver(ver) values(9);
  end if;

  if 9=(select max(ver) from dbver) then
    -- SNP-8143 make preset names case sensitive
    ALTER TABLE presets CHANGE name name VARCHAR(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL;
    OPTIMIZE TABLE presets;
    insert into dbver(ver) values(10);
  end if;

 -- ML: Hi, please check the DB version and insert a new larger version rather than
 -- checking the existence of the column you want or whatever. See above for an example.
 -- You need at minimum a new version per release of the software. Ideally you increase
 -- the version for every changeset.
 -- Basically, if you push this file the next change needs a new dbver.
 -- This is more maintainable long term, as it allows you to re-add columns, and know when each change was applied.

if 10=(select max(ver) from dbver) then
    create table IF NOT EXISTS `groups` (
      `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
      `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
      `permissions` text COLLATE utf8_unicode_ci,
      `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
      `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
      PRIMARY KEY (`id`),
      UNIQUE KEY `groups_name_unique` (`name`)
    ) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


    if not exists (select * from groups where id = 1) then
      INSERT INTO `groups` VALUES (1,'Administrator','{\"administrator\":1}','0000-00-00 00:00:00','0000-00-00 00:00:00');
    end if;

    if not exists (select * from groups where id = 2) then
      INSERT INTO `groups` VALUES (2,'Operator','{\"operator\":1,\"viewer\":1}','0000-00-00 00:00:00','0000-00-00 00:00:00');
    end if;

    if not exists (select * from groups where id = 3) then
      INSERT INTO `groups` VALUES (3,'Viewer','{\"viewer\":1}','0000-00-00 00:00:00','0000-00-00 00:00:00');
    end if;

    if not exists (select * from groups where id = 4) then
      INSERT INTO `groups` VALUES (4,'RemoteFmm','remoteFmm','0000-00-00 00:00:00','0000-00-00 00:00:00');
    end if;

    if not exists (select * from element_type where fme_type = 'Selenio Network Processor') then
      INSERT INTO `element_type` VALUES ('Selenio Network Processor');
    end if;

    create table IF NOT EXISTS `migrations` (
      `migration` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
      `batch` int(11) NOT NULL
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


    if not exists (select * from migrations where batch = 1) then
      INSERT INTO `migrations` VALUES ('2012_12_06_225921_migration_cartalyst_sentry_install_users',1),
        ('2012_12_06_225929_migration_cartalyst_sentry_install_groups',1),
        ('2012_12_06_225945_migration_cartalyst_sentry_install_users_groups_pivot',1),
        ('2012_12_06_225988_migration_cartalyst_sentry_install_throttle',1);
    end if;

    if not exists (select * from migrations where batch = 2) then
      INSERT INTO `migrations` VALUES ('2013_07_16_172358_alter_user_table',2),
        ('2013_09_02_072804_create_permission_table',2),
        ('2013_09_08_191339_update_admin_group_permission',2);
    end if;

    if not exists (select * from migrations where batch = 3) then
      INSERT INTO `migrations` VALUES ('2016_01_11_195212_create_sessions_table',3);
    end if;

    create table IF NOT EXISTS permissions (
      `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
      `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
      `value` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
      `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
      `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
      `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
      PRIMARY KEY (`id`),
      UNIQUE KEY `permissions_value_unique` (`value`)
    ) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

    if not exists (select * from permissions where id = 1) then
      INSERT INTO `permissions` VALUES (1,'Administrator','administrator','All permissions','0000-00-00 00:00:00','0000-00-00 00:00:00');
    end if;

    if not exists (select * from permissions where id = 2) then
      INSERT INTO `permissions` VALUES (2,'Operator','operator','Read and edit permissions','0000-00-00 00:00:00','0000-00-00 00:00:00');
    end if;

    if not exists (select * from permissions where id = 3) then
      INSERT INTO `permissions` VALUES (3,'Viewer','viewer','Read permissions','0000-00-00 00:00:00','0000-00-00 00:00:00');
    end if;

    create table IF NOT EXISTS sessions
    (
      `id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
      `payload` text COLLATE utf8_unicode_ci NOT NULL,
      `last_activity` int(11) NOT NULL,
      UNIQUE KEY `sessions_id_unique` (`id`)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


    create table IF NOT EXISTS throttle (
      `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
      `user_id` int(10) unsigned DEFAULT NULL,
      `ip_address` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
      `attempts` int(11) NOT NULL DEFAULT '0',
      `suspended` tinyint(1) NOT NULL DEFAULT '0',
      `banned` tinyint(1) NOT NULL DEFAULT '0',
      `last_attempt_at` timestamp NULL DEFAULT NULL,
      `suspended_at` timestamp NULL DEFAULT NULL,
      `banned_at` timestamp NULL DEFAULT NULL,
      PRIMARY KEY (`id`),
      KEY `throttle_user_id_index` (`user_id`)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


    create table IF NOT EXISTS users (
      `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
      `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
      `username` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
      `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
      `permissions` text COLLATE utf8_unicode_ci,
      `activated` tinyint(1) NOT NULL DEFAULT '0',
      `activation_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
      `activated_at` timestamp NULL DEFAULT NULL,
      `last_login` timestamp NULL DEFAULT NULL,
      `persist_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
      `reset_password_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
      `first_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
      `last_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
      `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
      `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
      PRIMARY KEY (`id`),
      UNIQUE KEY `users_username_unique` (`username`),
      KEY `users_activation_code_index` (`activation_code`),
      KEY `users_reset_password_code_index` (`reset_password_code`)
    ) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

    if not exists (select * from users where id = 1) then
      INSERT INTO `users` VALUES (1,'root@localhost','admin','$2y$10$FaMOCmi8UvtOCbWbxYQfSuwdIqR5YNqz4FtJ01afZ85SlNVLi.taq',NULL,1,NULL,'2019-12-04 21:05:38',NULL,NULL,NULL,NULL,NULL,'2019-12-04 21:05:38','2019-12-04 21:05:38');
    end if;

    if not exists (select * from users where id = 2) then
      INSERT INTO `users` VALUES (2,NULL,'snp','$2a$10$3yckvR9jNn6c5UOOwySAV.jwbiDr2CUJ4HQdljw9dd/54KmMPWcqW',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0000-00-00 00:00:00','0000-00-00 00:00:00');
    end if;

    create table IF NOT EXISTS users_groups (
      `user_id` int(10) unsigned NOT NULL,
      `group_id` int(10) unsigned NOT NULL,
      PRIMARY KEY (`user_id`,`group_id`)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

    if not exists (select * from users_groups where user_id = 1 and group_id = 1) then
      INSERT INTO `users_groups` VALUES (1, 1);
    end if;

    if not exists (select * from users_groups where user_id = 2 and group_id = 4) then
      INSERT INTO `users_groups` VALUES (2, 4);
    end if;

    insert into dbver(ver) values(11);
end if;

if (select max(ver) from dbver) in (11,12) then

    if not exists (select * from users where id = 3) then
      INSERT INTO `users` VALUES (3,NULL,'LMmonitor','$2a$10$XvmXAKN.22peEKkbF79Tme8rK9ldPBBREn7GfbECH.aSqF2.50gk2',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0000-00-00 00:00:00','0000-00-00 00:00:00');
    else
        if exists (select * from users where id = 3 and username <>  'LMmonitor') then
          set @MAX_ID = ( select max(id) from users );
          update `users` SET id = ( @MAX_ID  + 1 ) where id = 3;
          update `users_groups` SET user_id =  ( @MAX_ID + 1 )  where user_id = 3;
          INSERT INTO `users` VALUES (3,NULL,'LMmonitor','$2a$10$XvmXAKN.22peEKkbF79Tme8rK9ldPBBREn7GfbECH.aSqF2.50gk2',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0000-00-00 00:00:00','0000-00-00 00:00:00');
        end if;
     end if;
     if not exists (select * from users_groups where user_id = 3 and group_id = 3) then
        INSERT INTO `users_groups` VALUES (3, 3);
     end if;
     if 11=(select max(ver) from dbver) then
         insert into dbver(ver) values(12);
     end if;
end if;

end;;


delimiter ';'
call schema_change();

DROP PROCEDURE if exists schema_change;


