@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  FlexMediaManager startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and FLEX_MEDIA_MANAGER_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\FlexMediaManager-3.2.0.33.jar;%APP_HOME%\lib\mariadb-java-client-2.2.5.jar;%APP_HOME%\lib\jopt-simple-4.8.jar;%APP_HOME%\lib\spring-context-5.0.3.RELEASE.jar;%APP_HOME%\lib\commons-io-2.6.jar;%APP_HOME%\lib\log4j-api-2.17.1.jar;%APP_HOME%\lib\log4j-1.2-api-2.17.1.jar;%APP_HOME%\lib\log4j-core-2.17.1.jar;%APP_HOME%\lib\log4j-slf4j-impl-2.17.1.jar;%APP_HOME%\lib\license-client-2.2.16.jar;%APP_HOME%\lib\guava-23.2-jre.jar;%APP_HOME%\lib\maven-artifact-3.5.2.jar;%APP_HOME%\lib\javax.websocket-api-1.1.jar;%APP_HOME%\lib\javax-websocket-server-impl-9.4.6.v20170531.jar;%APP_HOME%\lib\websocket-client-9.4.6.v20170531.jar;%APP_HOME%\lib\ifc-2.1.jar;%APP_HOME%\lib\hibernate-core-5.2.11.Final.jar;%APP_HOME%\lib\jersey-container-jetty-servlet-2.26.jar;%APP_HOME%\lib\jersey-hk2-2.26.jar;%APP_HOME%\lib\jersey-media-json-jackson-2.26.jar;%APP_HOME%\lib\jersey-media-multipart-2.26.jar;%APP_HOME%\lib\jackson-databind-2.9.5.jar;%APP_HOME%\lib\jackson-datatype-jsr310-2.9.5.jar;%APP_HOME%\lib\java-jwt-3.2.0.jar;%APP_HOME%\lib\jbcrypt-0.4.jar;%APP_HOME%\lib\httpclient-4.5.6.jar;%APP_HOME%\lib\c3p0-0.9.5.2.jar;%APP_HOME%\lib\json-20171018.jar;%APP_HOME%\lib\gson-2.3.1.jar;%APP_HOME%\lib\log4j-jul-2.17.1.jar;%APP_HOME%\lib\hibernate-c3p0-5.2.11.Final.jar;%APP_HOME%\lib\spring-aop-5.0.3.RELEASE.jar;%APP_HOME%\lib\spring-beans-5.0.3.RELEASE.jar;%APP_HOME%\lib\spring-core-5.0.3.RELEASE.jar;%APP_HOME%\lib\spring-expression-5.0.3.RELEASE.jar;%APP_HOME%\lib\slf4j-api-1.7.25.jar;%APP_HOME%\lib\license-common-2.2.16.jar;%APP_HOME%\lib\commons-lang-2.6.jar;%APP_HOME%\lib\featureservice-1.0.27.jar;%APP_HOME%\lib\jsr305-1.3.9.jar;%APP_HOME%\lib\error_prone_annotations-2.0.18.jar;%APP_HOME%\lib\j2objc-annotations-1.1.jar;%APP_HOME%\lib\animal-sniffer-annotations-1.14.jar;%APP_HOME%\lib\plexus-utils-3.1.0.jar;%APP_HOME%\lib\commons-lang3-3.5.jar;%APP_HOME%\lib\jetty-annotations-9.4.6.v20170531.jar;%APP_HOME%\lib\javax-websocket-client-impl-9.4.6.v20170531.jar;%APP_HOME%\lib\websocket-server-9.4.6.v20170531.jar;%APP_HOME%\lib\jetty-util-9.4.6.v20170531.jar;%APP_HOME%\lib\jetty-io-9.4.6.v20170531.jar;%APP_HOME%\lib\jetty-client-9.4.6.v20170531.jar;%APP_HOME%\lib\websocket-common-9.4.6.v20170531.jar;%APP_HOME%\lib\jboss-logging-3.3.0.Final.jar;%APP_HOME%\lib\hibernate-jpa-2.1-api-1.0.0.Final.jar;%APP_HOME%\lib\antlr-2.7.7.jar;%APP_HOME%\lib\jboss-transaction-api_1.2_spec-1.0.1.Final.jar;%APP_HOME%\lib\jandex-2.0.3.Final.jar;%APP_HOME%\lib\classmate-1.3.0.jar;%APP_HOME%\lib\dom4j-1.6.1.jar;%APP_HOME%\lib\hibernate-commons-annotations-5.0.1.Final.jar;%APP_HOME%\lib\jersey-container-servlet-2.26.jar;%APP_HOME%\lib\jersey-container-jetty-http-2.26.jar;%APP_HOME%\lib\jersey-common-2.26.jar;%APP_HOME%\lib\jersey-server-2.26.jar;%APP_HOME%\lib\javax.ws.rs-api-2.1.jar;%APP_HOME%\lib\hk2-locator-2.5.0-b42.jar;%APP_HOME%\lib\jersey-entity-filtering-2.26.jar;%APP_HOME%\lib\jackson-module-jaxb-annotations-2.8.4.jar;%APP_HOME%\lib\mimepull-1.9.6.jar;%APP_HOME%\lib\jackson-core-2.9.5.jar;%APP_HOME%\lib\commons-codec-1.10.jar;%APP_HOME%\lib\bcprov-jdk15on-1.55.jar;%APP_HOME%\lib\httpcore-4.4.10.jar;%APP_HOME%\lib\commons-logging-1.2.jar;%APP_HOME%\lib\mchange-commons-java-0.2.11.jar;%APP_HOME%\lib\spring-jcl-5.0.3.RELEASE.jar;%APP_HOME%\lib\jdom-1.1.jar;%APP_HOME%\lib\commons-collections-3.1.jar;%APP_HOME%\lib\jetty-plus-9.4.6.v20170531.jar;%APP_HOME%\lib\javax.annotation-api-1.2.jar;%APP_HOME%\lib\asm-5.1.jar;%APP_HOME%\lib\asm-commons-5.1.jar;%APP_HOME%\lib\websocket-servlet-9.4.6.v20170531.jar;%APP_HOME%\lib\jetty-servlet-9.4.6.v20170531.jar;%APP_HOME%\lib\jetty-http-9.4.6.v20170531.jar;%APP_HOME%\lib\websocket-api-9.4.6.v20170531.jar;%APP_HOME%\lib\jersey-container-servlet-core-2.26.jar;%APP_HOME%\lib\javax.inject-2.5.0-b42.jar;%APP_HOME%\lib\jetty-continuation-9.4.3.v20170317.jar;%APP_HOME%\lib\osgi-resource-locator-1.0.1.jar;%APP_HOME%\lib\jersey-client-2.26.jar;%APP_HOME%\lib\jersey-media-jaxb-2.26.jar;%APP_HOME%\lib\validation-api-1.1.0.Final.jar;%APP_HOME%\lib\aopalliance-repackaged-2.5.0-b42.jar;%APP_HOME%\lib\hk2-api-2.5.0-b42.jar;%APP_HOME%\lib\hk2-utils-2.5.0-b42.jar;%APP_HOME%\lib\jetty-jndi-9.4.6.v20170531.jar;%APP_HOME%\lib\asm-tree-5.1.jar;%APP_HOME%\lib\javax.servlet-api-3.1.0.jar;%APP_HOME%\lib\jetty-security-9.4.6.v20170531.jar;%APP_HOME%\lib\javax.inject-1.jar;%APP_HOME%\lib\jackson-annotations-2.9.0.jar;%APP_HOME%\lib\jetty-webapp-9.4.6.v20170531.jar;%APP_HOME%\lib\jetty-xml-9.4.6.v20170531.jar;%APP_HOME%\lib\javassist-3.22.0-CR2.jar;%APP_HOME%\lib\jetty-server-9.4.6.v20170531.jar

@rem Execute FlexMediaManager
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %FLEX_MEDIA_MANAGER_OPTS%  -classpath "%CLASSPATH%" com.imaginecommunications.flexmediamanager.main.Main %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable FLEX_MEDIA_MANAGER_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%FLEX_MEDIA_MANAGER_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
