/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "packages/uifmm/dist/";
/******/
/******/ 	// __webpack_hash__
/******/ 	__webpack_require__.h = "47a5d2aa4a6182e7bd56";
/******/
/******/ 	// __webpack_chunkname__
/******/ 	__webpack_require__.cn = "main";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./main.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./app/app.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var templateUrl = __webpack_require__("./app/app.template.html");
var AppController = (function () {
    function AppController(uiModalsSrv) {
        // uiModalsSrv.openConfirmModal({
        //     title: `Confirm Applying`,
        //     msg: 'Text         Text',
        //     // msg: '<p>Text</p><p class="footnote">Text</p>',
        //     buttons: [
        //       {
        //         label: "Yes",
        //         callback: () => {
        //           const hostname = window.location.hostname
        //           const requester = encodeURIComponent(window.location.href);
        //           const link = `https://${hostname}/access?requester=${requester}`
        //           // https://192.168.14.83/access?requester='https%3A%2F%2F192.168.14.83%2F%23%2Fconfig'
        //           window.open(link, "_blank")
        //         },
        //       },
        //       {
        //         label: "No",
        //       },
        //     ],
        //   })
    }
    return AppController;
}());
exports.AppComponent = {
    templateUrl: templateUrl,
    controller: AppController,
};


/***/ }),

/***/ "./app/app.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
// main place for imports
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
// MODULES
var routing_module_1 = __webpack_require__("./app/routes/routing.module.ts");
var auth_module_1 = __webpack_require__("./app/auth/auth.module.ts");
var header_module_1 = __webpack_require__("./app/header/header.module.ts");
var snp_list_module_1 = __webpack_require__("./app/view-menu/snp-list.module.ts");
var processor_module_1 = __webpack_require__("./app/view-menu/processor/processor.module.ts");
var fme_module_1 = __webpack_require__("./app/fme/fme.module.ts");
var common_module_1 = __webpack_require__("./app/common/common.module.ts");
var console_module_1 = __webpack_require__("./app/view-menu/console/console.module.ts");
var alarm_module_1 = __webpack_require__("./app/view-menu/alarm/alarm.module.ts");
var dashboard_module_1 = __webpack_require__("./app/view-menu/remote/dashboard/dashboard.module.ts");
var app_component_1 = __webpack_require__("./app/app.component.ts");
var _a = window.location, protocol = _a.protocol, hostname = _a.hostname;
exports.AppModule = angular_1.module("app", [
    routing_module_1.RoutingModule.name,
    auth_module_1.AuthModule.name,
    header_module_1.HeaderModule.name,
    common_module_1.CommonModule.name,
    fme_module_1.FmeModule.name,
    snp_list_module_1.SnpListModule.name,
    dashboard_module_1.DashboardModule.name,
    processor_module_1.ProcessorModule.name,
    console_module_1.ConsoleModule.name,
    alarm_module_1.AlarmModule.name,
])
    .constant("VIEW_NAMES", {
    DASHBOARD: "Dashboard",
    ALARM: "Alarms",
    PHYSICAL: "Element Information",
    ABOUT: "About",
    CONFIG: "Dashboard",
    USERS: "User Management",
    GROUPS: "Group Management",
    LOGIN: "Login",
    CONSOLE: "Console",
})
    .constant("REST_ENDPOINT", {
    URI: protocol + "//" + hostname + "/api/",
    URI_ACCESS: protocol + "//" + hostname + "/access",
})
    .component("indexComponent", app_component_1.AppComponent);
// .component("appRoot", AppComponent) // TDL:


/***/ }),

/***/ "./app/app.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/app.template.html?eb59c6139ac1a11ab423a69f021bed1d";

/***/ }),

/***/ "./app/auth/auth-interceptor.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthInterceptorService = function (REST_ENDPOINT, commonUtils) {
    this.request = function (config) {
        var isRequestToRestapi = config.url.indexOf(REST_ENDPOINT.URI) !== -1;
        var token = commonUtils.smm_restapi_token();
        if (isRequestToRestapi && token) {
            config.headers["Authorization"] = token;
        }
        return config;
    };
};


/***/ }),

/***/ "./app/auth/auth.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var user_management_module_1 = __webpack_require__("./app/auth/user-management/user-management.module.ts");
var login_service_1 = __webpack_require__("./app/auth/login.service.ts");
var html_filter_1 = __webpack_require__("./app/auth/html.filter.ts");
exports.AuthModule = angular_1.module("AuthModule", [
    user_management_module_1.UserManagementModule.name,
])
    .factory("loginSrv", login_service_1.LoginService)
    .filter("html", html_filter_1.HtmlFilter);


/***/ }),

/***/ "./app/auth/html.filter.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.HtmlFilter = function ($sce) {
    return function (input) {
        return $sce.trustAsHtml(input);
    };
};


/***/ }),

/***/ "./app/auth/login.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.LoginService = function () {
    var myFactory = {};
    var successCount = 0;
    var lastAccessFailed = false;
    var _scope = null;
    myFactory.setScope = function (scope) {
        _scope = scope;
    };
    myFactory.snpOn = function () {
        if (_scope) {
            successCount++;
            if (successCount < 2) {
                return;
            }
            if (lastAccessFailed) {
                lastAccessFailed = false;
                _scope.statusMessage = "";
                _scope.submitDisabled = false;
            }
        }
    };
    myFactory.snpOff = function () {
        if (_scope) {
            lastAccessFailed = true;
            successCount = 0;
            _scope.submitDisabled = true;
            _scope.statusMessage = "SNP is starting up, please wait!";
        }
    };
    myFactory.snpLost = function () {
        if (_scope) {
            if (lastAccessFailed) {
                return;
            }
            else {
                successCount = 0;
                lastAccessFailed = true;
            }
            _scope.submitDisabled = true;
            _scope.statusMessage = _scope.selfHost ?
                "Connection to SNP lost." :
                "Connection to SNP Manager lost";
        }
    };
    return myFactory;
};


/***/ }),

/***/ "./app/auth/user-management/modals/user-details/user-details-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var user_details_modal_window_controller_1 = __webpack_require__("./app/auth/user-management/modals/user-details/user-details-modal-window.controller.ts");
var templateUrl = __webpack_require__("./app/auth/user-management/modals/user-details/user-details-modal-window.template.html");
exports.createUserDetailsModalWindowComponent = function (library, name, ownProfile) {
    return library.open({
        animation: true,
        backdrop: "static",
        templateUrl: templateUrl,
        controller: user_details_modal_window_controller_1.createUserDetailsDialogController,
        // controllerAs: "$ctrl", // not required here. attached to scope
        resolve: {
            receivedProps: {
                name: name,
                ownProfile: ownProfile,
            },
        },
    });
};


/***/ }),

/***/ "./app/auth/user-management/modals/user-details/user-details-modal-window.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.createUserDetailsDialogController = function ($scope, $http, commonUtils, REST_ENDPOINT, $uibModalInstance, userManagerSrv, receivedProps) {
    $scope.userName = receivedProps.name;
    $scope.isOwnProfile = receivedProps.ownProfile;
    $scope.groups = [];
    $scope.user = {};
    $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
    $scope.userGroup = userManagerSrv.getCurUserGroup();
    if ($scope.userGroup.name !== "Administrator" && !$scope.isOwnProfile) {
        $scope.freeze = true;
        $scope.save_error = "You do not have permission to edit users";
    }
    var getGroups = function () {
        $http.get(REST_ENDPOINT.URI + 'users/groups')
            .success(function (response) {
            $scope.groups = response;
        })
            .error(function (response) { });
    };
    var getUser = function () {
        $http.get(REST_ENDPOINT.URI + 'users/' + $scope.userName)
            .success(function (response) {
            $scope.user = response;
        })
            .error(function (response) { });
    };
    var clear = function (ms, cb) { return setTimeout(function () {
        $scope.save_error = "";
        $scope.save_success = "";
        $scope.error = "";
        $scope.freeze = false;
        $scope.user.password = null;
        $scope.user.password2 = null;
        cb();
    }, ms); };
    $scope.groupFilter = function (group) {
        if ($scope.selfHost || group.name !== "RemoteFmm")
            return group;
    };
    $scope.submitUser = function () {
        $scope.error = {};
        $scope.save_success = "";
        $scope.save_error = "";
        // validations
        if (!$scope.user.username) {
            $scope.error.username = "Please fill required fields";
        }
        else if ($scope.user.username.length < 3) {
            $scope.error.username = "Username must be at least 3 characters long";
        }
        else if ($scope.user.username.length > 20) {
            $scope.error.username = "Username too long (max. 20)";
        }
        else if ($scope.user.username.indexOf(' ') !== -1) {
            $scope.error.username = "The username must not contain spaces";
        }
        else if (/^[0-9]/.test($scope.user.username)) {
            $scope.error.username = "The username can't start with a number";
        }
        else if (/[^\w-]/g.test($scope.user.username)) {
            $scope.error.username = "The username can only contain alphanumeric characters and dashes";
        }
        if (!$scope.user.group_id) {
            $scope.error.group = "Please fill required fields";
        }
        if (!$scope.userName && (!$scope.user.password || !$scope.user.password2)) {
            $scope.error.password = "Please fill required fields";
        }
        else if ($scope.user.password !== $scope.user.password2) {
            $scope.error.password = "Passwords don't match";
        }
        else if ((!$scope.userName || ($scope.userName && $scope.user.password)) && $scope.user.password.length < 6) {
            $scope.error.password = "Password must be at least 6 characters long";
        }
        else if ((!$scope.userName || ($scope.userName && $scope.user.password)) && $scope.user.password.length > 128) {
            $scope.error.password = "Password length too long (max. 128)";
        }
        if (!($scope.error.username || $scope.error.password || $scope.error.group)) {
            $scope.freeze = true;
            var call = "post";
            var url = REST_ENDPOINT.URI + 'users';
            var successMsg_1 = "The user was created successfully";
            var cb_1 = $scope.closeModal;
            var data = {
                username: $scope.user.username,
                group_id: $scope.user.group_id,
                activated: true
            };
            if ($scope.user.password)
                data['password'] = $scope.user.password;
            if ($scope.user.first_name)
                data['first_name'] = $scope.user.first_name;
            if ($scope.user.last_name)
                data['last_name'] = $scope.user.last_name;
            if ($scope.userName) {
                call = "put";
                url += "/" + $scope.user.id;
                successMsg_1 = "The user was updated successfully";
                cb_1 = function () { };
            }
            $http({
                url: url,
                data: data,
                method: call,
                transformResponse: [
                    commonUtils.plainResponse,
                ]
            })
                .then(function () {
                $scope.save_success = successMsg_1;
                if ($scope.userName)
                    $scope.userName = $scope.user.username;
                clear(3000, cb_1);
            }, function (res) {
                if (res.status == 406) {
                    $scope.save_error = "User already exists";
                }
                else {
                    if (!!res.data) {
                        $scope.save_error = res.data;
                    }
                    else
                        $scope.save_error = "Unknown user error!";
                }
                $scope.freeze = false;
                clear(5000, function () { });
            });
        }
    };
    $scope.closeModal = function () {
        $uibModalInstance.close();
    };
    getGroups();
    if ($scope.userName)
        getUser();
};


/***/ }),

/***/ "./app/auth/user-management/modals/user-details/user-details-modal-window.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/auth/user-management/modals/user-details/user-details-modal-window.template.html?52c750ad5c9e5d0071e9a65c1441a64e";

/***/ }),

/***/ "./app/auth/user-management/modals/user-modals.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var user_details_modal_window_component_1 = __webpack_require__("./app/auth/user-management/modals/user-details/user-details-modal-window.component.ts");
exports.UserModalsService = function ($uibModal) {
    var srv = {};
    srv.openUserDetailsModal = function (name, ownProfile) {
        return user_details_modal_window_component_1.createUserDetailsModalWindowComponent($uibModal, name, ownProfile);
    };
    return srv;
};


/***/ }),

/***/ "./app/auth/user-management/user-management.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var user_management_service_1 = __webpack_require__("./app/auth/user-management/user-management.service.ts");
var user_modals_service_1 = __webpack_require__("./app/auth/user-management/modals/user-modals.service.ts");
var user_management_directive_1 = __webpack_require__("./app/auth/user-management/user-management/user-management.directive.ts");
exports.UserManagementModule = angular_1.module("userManagementModule", [])
    .service("userModalsSrv", user_modals_service_1.UserModalsService)
    .factory("userManagerSrv", user_management_service_1.UserManagementService)
    .directive("userManagement", [user_management_directive_1.UserManagementCompiledDirective]); // passed in [] because contains compile func


/***/ }),

/***/ "./app/auth/user-management/user-management.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.UserManagementService = function ($http, $interval, fmmStateSrv) {
    var myFactory = {};
    var currentUser = {};
    var userGroup = {};
    var userInfo = {};
    myFactory.update = function (data) {
        if (data.logged !== undefined && data.logged === false) {
            window.location.href = data.redirect;
        }
        currentUser.username = data.currentUser.username || "undefined";
        userGroup.name = data.userGroup.name || "";
        userInfo = {
            user: currentUser.username,
            group: userGroup.name
        };
    };
    myFactory.getCurrentUser = function () {
        return currentUser;
    };
    myFactory.getCurUserGroup = function () {
        return userGroup;
    };
    myFactory.IsAllowOper = function () {
        return !!userGroup.name && userGroup.name !== "Viewer";
    };
    myFactory.getCurrentUserInfo = function () {
        return userInfo;
    };
    return myFactory;
};


/***/ }),

/***/ "./app/auth/user-management/user-management/user-management.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// https://code.angularjs.org/1.5.11/docs/guide/directive
// https://code.angularjs.org/1.5.11/docs/guide/compiler
// import { IDirectiveFactory } from "angular";
Object.defineProperty(exports, "__esModule", { value: true });
// export const UserManagementDirective: IDirectiveFactory = function ($compile) {
exports.UserManagementCompiledDirective = function ($compile) {
    return {
        restrict: "A",
        compile: function (element) {
            element.removeAttr("user-management"); // necessary to avoid infinite compile loop
            element.attr("ng-disabled", "userGroup.name == 'Viewer' || userGroup.name == 'Operator'");
            var fn = $compile(element);
            return function (scope) {
                fn(scope);
            };
        },
    };
};


/***/ }),

/***/ "./app/common/base-tab.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var AbstractBaseTabController = (function () {
    function AbstractBaseTabController($scope) {
        var _this = this;
        this.$scope = $scope;
        this.data = {
            requests: undefined,
            response: undefined
        }; // top nested props init to prevent undefined error after setting inner objects // TDL: redactor if needed
        this.timeoutPromise = null;
        this.controllerHandlers = {};
        this.templateHandlers = {};
        // common tab utils
        this.aliasInTemplate = function (alias, prop) {
            _this.$scope[alias] = prop; // TDL: refactor if needed
        };
    }
    return AbstractBaseTabController;
}());
exports.AbstractBaseTabController = AbstractBaseTabController;


/***/ }),

/***/ "./app/common/common-utils.factory.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {
Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
exports.commonUtilsFactory = function ($q) {
    var myFactory = {};
    myFactory.SNP_PRODUCT_ID = 'snp';
    myFactory.SNP_PRODUCT_NAME = 'Selenio&trade; Network Processor Manager';
    myFactory.smm_restapi_token = function () {
        var cookieName = 'smm_restapi_token=';
        var startIdx = document.cookie.indexOf(cookieName);
        if (startIdx < 0) {
            return undefined;
        }
        startIdx += cookieName.length;
        var endIdx = document.cookie.indexOf(';', startIdx);
        if (endIdx < 0) {
            endIdx = document.cookie.length;
        }
        return decodeURIComponent(document.cookie.substring(startIdx, endIdx));
    };
    myFactory.smm_restapi_token_refresh = function () {
        var xhr = new XMLHttpRequest();
        xhr.onreadystatechange = function () {
            if (xhr.readyState === xhr.DONE) {
                if (xhr.status === 200) {
                    document.cookie = 'smm_restapi_token=' + encodeURIComponent(xhr.responseText) + '; path=/; secure';
                }
                else {
                    document.cookie = 'smm_restapi_token=; expires=' + new Date(0).toUTCString() + '; path=/; secure';
                    document.location.replace(window.location.protocol + "//" + window.location.hostname + (!!window.location.port ? ":" : "") + window.location.port + '/#/login');
                }
            }
        };
        xhr.open('POST', window.location.protocol.toString() + '//' + window.location.hostname + '/api/auth');
        xhr.responseType = 'text';
        xhr.setRequestHeader('Authorization', myFactory.smm_restapi_token());
        xhr.send();
    };
    myFactory.validateIPaddress = function (ipaddress) {
        if (/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/.test(ipaddress)) {
            return true;
        }
        return false;
    };
    myFactory.smmParam = function (paramName, defaultValue) {
        var value = undefined;
        if (typeof SMM_PARAMS !== 'undefined') {
            value = SMM_PARAMS[paramName];
        }
        if (typeof value !== 'undefined') {
            return value;
        }
        else {
            return defaultValue;
        }
    };
    myFactory.plainResponse = function (data) { return data; };
    myFactory.getAudioInputPid = function (audioPids, pid) {
        for (var item in audioPids) {
            if (!!audioPids[item].pid && audioPids[item].pid === pid) {
                return audioPids[item];
            }
        }
        return null;
    };
    myFactory.getDataInputPid = function (dataPids, pid) {
        for (var item in dataPids) {
            if (!!dataPids[item].pid && dataPids[item].pid === pid) {
                return dataPids[item];
            }
        }
        return null;
    };
    //calculates total audio rate based on transcoding audio
    myFactory.totalAudioTranscodeRate = function (audio) {
        var total_rate = 0;
        for (var i in audio) {
            if (angular_1.isDefined(audio[i].output) && angular_1.isDefined(audio[i].output.passthrough)) {
                if (audio[i].output.passthrough === 'transcode') {
                    total_rate += parseInt(audio[i].output.bitrate, 10);
                }
            }
        }
        return total_rate;
    };
    //calculates total audio rate based on transcoding and passthrough audio
    myFactory.totalAudioRate = function (audioPids, audio) {
        var total_rate = 0;
        for (var i in audio) {
            if (angular_1.isDefined(audio[i].output) && angular_1.isDefined(audio[i].output.passthrough)) {
                if (audio[i].output.passthrough === 'transcode') {
                    total_rate += parseInt(audio[i].output.bitrate, 10);
                }
                else if (audio[i].output.passthrough == 'passthrough') {
                    var input = myFactory.getAudioInputPid(audioPids, audio[i].input.pid);
                    if (!!input) {
                        total_rate += parseInt(input.bit_rate, 10);
                    }
                }
            }
        }
        return total_rate;
    };
    //calculates total data rate
    myFactory.totalDataRate = function (dataPids, data) {
        var total_rate = 0;
        for (var i in data) {
            if (angular_1.isDefined(data[i].output) && angular_1.isDefined(data[i].output.passthrough)) {
                if (data[i].output.passthrough === 'passthrough') {
                    var input = myFactory.getDataInputPid(dataPids, data[i].input.pid);
                    if (!!input) {
                        total_rate += Math.max(parseInt(input.bit_rate, 10), 100000);
                    }
                }
            }
        }
        return total_rate;
    };
    myFactory.getAudioCodec = function (streamType) {
        var codec = '';
        switch (streamType) {
            case 3:
                codec = 'MPEG'; // MPEG1
                break;
            case 4:
                codec = 'MPEG'; //MPEG2
                break;
            case 15:
                codec = 'AAC'; // AAC
                break;
            case 17:
                codec = 'AAC'; // AAC4
                break;
            case 129:
                codec = 'Dolby Digital'; // Dolby Digital
                break;
            case 6:
                codec = 'Dolby Digital'; // Dolby Digital
                break;
        }
        return codec;
    };
    myFactory.resizeWindow = function (isAlarmOverlay) {
        var tempAlarmOverlay = isAlarmOverlay || false;
        var bodyHeight = $("body").height();
        // var alarmHeight = $('#activeAlarmPage').css('display') == 'block' ? 300 : 30;
        var alarmHeight = tempAlarmOverlay ? $('#activeAlarmPage').height() : 0;
        var headerHeight = $('.header-container').height();
        var contentMargin = parseInt($('.ContentArea').css('margin-top'), 10) + parseInt($('.ContentArea').css('margin-bottom'), 10);
        var contentHeight = bodyHeight - alarmHeight - headerHeight - contentMargin;
        var tabHeaderHeight = $('.tab-links').height() || 0;
        $('#alertStack').css("bottom", alarmHeight);
        $('#loadingDlg').css("bottom", alarmHeight);
        $('.ContentArea').css("height", contentHeight + tabHeaderHeight - 5);
        //code to make the SMM dashboard panel height match
        $('#dashboard').find('.panel-body-dashboard').css("height", contentHeight - 45);
        // code to update alarm overlay height
        var alarmHeaderHeight = $('#activeAlarmPage div.activeFaults').height();
        $("#showAlarmPanel").find('table.smartTable').css("max-height", alarmHeight - alarmHeaderHeight);
    };
    // remove all empty values / object from recieved object
    myFactory.removeEmpty = function (obj) {
        Object.keys(obj).forEach(function (key) {
            if (obj[key] === '' || obj[key] === null || obj[key] === undefined || obj[key].length === 0 || (typeof obj[key] === 'object' && Object.getOwnPropertyNames(obj[key]).length === 0)) {
                delete obj[key];
            }
            else if (obj[key] && typeof obj[key] === 'object') {
                myFactory.removeEmpty(obj[key]);
                if (Object.getOwnPropertyNames(obj[key]).length === 0) {
                    if (Array.isArray(obj)) {
                        obj.splice(Number(key), 1);
                    }
                    else {
                        delete obj[key];
                    }
                }
            }
        });
        return obj;
    };
    // copied from https://stackoverflow.com/questions/105034/create-guid-uuid-in-javascript
    // marked as public domain
    myFactory.generateUUID = function () {
        var d = new Date().getTime();
        if (typeof performance !== 'undefined' && typeof performance.now === 'function') {
            d += performance.now(); //use high-precision timer if available
        }
        return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
            var r = (d + Math.random() * 16) % 16 | 0;
            d = Math.floor(d / 16);
            return (c === 'x' ? r : (r & 0x3 | 0x8)).toString(16);
        });
    };
    // For a given array of promises, returns an overall promise which waits for
    // all promises in the array to complete (in parallel) and which resolves to
    // an array of results (one result per promise). The overall promise resolves
    // successfully if and only if all promises in the array resolve successfully.
    // The result or rejection reason for the overall promise have the same form
    // (i.e., an array with one result per promise). Each result has the form
    //     { failed: true/false, value: result/reason of the corresponding promise }
    // where the 'failed' attribute indicates if the corresponding promise resolved
    // successfully, and the 'value' attribute contains the corresponding result
    // (if 'failed' is false) or rejection reason (if 'failed' is true).
    myFactory.allCompletePromise = function (promises) {
        if (!angular_1.isArray(promises)) {
            return $q.reject('allCompletePromise supports only arrays of promises');
        }
        return $q.all(promises.map(function (promise) {
            return $q.when(promise).then(function (value) {
                return {
                    failed: false,
                    value: value
                };
            }, function (error) {
                return {
                    failed: true,
                    value: error
                };
            });
        })).then(function (results) {
            for (var i = 0; i < results.length; ++i) {
                if (results[i].failed) {
                    return $q.reject(results);
                }
            }
            return $q.resolve(results);
        }, function (error) {
            return $q.reject(error);
        });
    };
    myFactory.sortedUniqueNumbers = function (numberArray) {
        return numberArray.sort(function (a, b) {
            return a - b;
        }).filter(function (idx, i, array) {
            // get only unique indexes
            return i == 0 || idx !== array[i - 1];
        });
    };
    myFactory.endsWith = function (str, subStr) {
        return angular_1.isString(str) && angular_1.isString(subStr) && str.length >= subStr.length && str.substr(str.length - subStr.length, subStr.length) === subStr;
    };
    return myFactory;
};

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__("./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./app/common/common.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var error_module_1 = __webpack_require__("./app/common/error/error.module.js");
var gui_module_1 = __webpack_require__("./app/common/gui/gui.module.js");
var live_params_module_1 = __webpack_require__("./app/common/live-params/live-params.module.ts");
var logs_module_1 = __webpack_require__("./app/common/logs/logs.module.ts");
var metadata_module_1 = __webpack_require__("./app/common/metadata/metadata.module.js");
var modals_module_1 = __webpack_require__("./app/common/modals/modals.module.ts");
var request_status_module_1 = __webpack_require__("./app/common/request-status/request-status.module.ts");
var common_utils_factory_1 = __webpack_require__("./app/common/common-utils.factory.ts");
var param_def_service_1 = __webpack_require__("./app/common/flx-help-tooltip/param-def.service.ts");
var flx_file_input_directive_1 = __webpack_require__("./app/common/flx-file-input/flx-file-input.directive.ts");
var flx_help_link_directive_1 = __webpack_require__("./app/common/flx-help-link/flx-help-link.directive.ts");
var flx_confirm_directive_1 = __webpack_require__("./app/common/flx-confirm/flx-confirm.directive.ts");
var flx_help_tooltip_directive_1 = __webpack_require__("./app/common/flx-help-tooltip/flx-help-tooltip.directive.ts");
var flx_menu_directive_1 = __webpack_require__("./app/common/flx-menu/flx-menu.directive.ts");
var flx_title_directive_1 = __webpack_require__("./app/common/flx-title/flx-title.directive.ts");
var flx_lazy_load_directive_1 = __webpack_require__("./app/common/flx-lazy-load---to-be-depricated/flx-lazy-load.directive.ts");
var admin_menu_item_directive_1 = __webpack_require__("./app/common/flx-menu-item/admin-menu-item.directive.ts");
var operation_menu_item_directive_1 = __webpack_require__("./app/common/flx-menu-item/operation-menu-item.directive.ts");
exports.CommonModule = angular_1.module("commonModule", [
    error_module_1.ErrorModule.name,
    gui_module_1.GuiModule.name,
    live_params_module_1.LiveParamsModule.name,
    logs_module_1.LogsModule.name,
    metadata_module_1.MetadataModule.name,
    modals_module_1.ModalsModule.name,
    request_status_module_1.RequestStatusModule.name,
])
    .factory("commonUtils", common_utils_factory_1.commonUtilsFactory)
    .factory("paramDefSrv", param_def_service_1.paramDefService)
    .directive("flxFileInput", flx_file_input_directive_1.flxFileInputDirective) // flx-file-input
    .directive("flxHelpLink", flx_help_link_directive_1.flxHelpLinkDirective) // flx-help-link
    .directive("flxHelpTooltip", flx_help_tooltip_directive_1.flxHelpTooltipDirective) // flx-help-tooltip
    .directive("flxConfirm", flx_confirm_directive_1.flxConfirmDirective) // flx-confirm
    .directive("flxMenu", flx_menu_directive_1.flxMenuDirective) // flx-menu
    .directive("flxTitle", flx_title_directive_1.flxTitleDirective) // flx-title
    .directive("flxLazyLoad", [flx_lazy_load_directive_1.flxLazyLoadDirective]) // flx-lazy-load="loadRequestPopups"
    .directive("flxAdminMenuItem", admin_menu_item_directive_1.flxAdminMenuItemDirective)
    .directive("flxOperatorMenuItem", operation_menu_item_directive_1.flxOperationMenuItemDirective);


/***/ }),

/***/ "./app/common/error/error.module.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular__ = __webpack_require__("./node_modules/angular/index.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_angular__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__error_service__ = __webpack_require__("./app/common/error/error.service.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__report_field_report_field_directive__ = __webpack_require__("./app/common/error/report-field/report-field.directive.js");





const ErrorModule = Object(__WEBPACK_IMPORTED_MODULE_0_angular__["module"])('errorModule', [])
  .service('errorSrv', [__WEBPACK_IMPORTED_MODULE_1__error_service__["a" /* ErrorService */]])
  .directive('reportField', [__WEBPACK_IMPORTED_MODULE_2__report_field_report_field_directive__["a" /* ReportFieldDirective */]])
/* harmony export (immutable) */ __webpack_exports__["ErrorModule"] = ErrorModule;



/***/ }),

/***/ "./app/common/error/error.service.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
const ErrorService = function ()
{
  this.MSG_ERROR = 'error';
  this.MSG_WARN = 'warn';
  this.MSG_INFO = 'info';

  this.normalize = function (report)
  {
    var ret = {};
    if (typeof report === 'undefined' || report === null)
    {
      return {
        hasErrorMsg: false,
        msgs:
        {},
      };
    }
    if (typeof report !== 'object')
    {
      return {
        hasErrorMsg: true,
        msgs:
        {
          '': [
          {
            type: "error",
            msg: String(report),
          }, ]
        },
      }
    }
    if (typeof report.msgs === 'undefined')
    {
      return {
        hasErrorMsg: false,
        msgs:
        {},
      }
    }
    return {
      hasErrorMsg: !!report.hasErrorMsg,
      msgs: report.msgs,
    }
  }

  this.msgsErrorLevel = function (msgs)
  {
    var ret = undefined;
    if (typeof (msgs) !== 'undefined' && typeof (msgs.constructor) !== 'undefined' &&
      msgs.constructor == Array)
    {
      for (var i = 0; i < msgs.length; ++i)
      {
        if (typeof msgs[i].type !== 'undefined')
        {
          switch (msgs[i].type)
          {
            case this.MSG_ERROR:
              return this.MSG_ERROR;
            case this.MSG_WARN:
              ret = (ret === this.MSG_ERROR ? ret : this.MSG_WARN);
              break;
            case this.MSG_INFO:
              ret = (ret === this.MSG_ERROR || ret === this.MSG_WARN ? ret : this.MSG_INFO);
              break;
          }
        }
      }
    }
    return ret;
  }

  this.getMsgs = function (report, ptr)
  {
    if (typeof report === 'undefined' || typeof report.msgs === 'undefined' || typeof report.msgs[ptr] === 'undefined')
    {
      return [];
    }
    else
    {
      return report.msgs[ptr];
    }
  }

  this.setMsgs = function (report, ptr, msgs)
  {
    if (typeof report === 'undefined' || report === null)
    {
      report = {
        hasErrorMsg: false,
        msgs:
        {},
      }
    }
    report.msgs[ptr] = msgs;
    var self = this;
    report.hasErrorMsg = Object.keys(report.msgs).filter(function (ptr)
    {
      return self.msgsErrorLevel(report.msgs[ptr]) === self.MSG_ERROR;
    }).length > 0;
    return report;
  }

  this.sortedUniqueMsgs = function (msgs)
  {
    var msgMap = {};
    for (var i = 0; i < msgs.length; ++i)
    {
      if (typeof msgMap[msgs[i].msg] === 'undefined' || msgs[i].type === this.MSG_ERROR || (msgs[i].type ===
          this.MSG_WARN && msgMap[msgs[i].msg].type === this.MSG_INFO))
      {
        msgMap[msgs[i].msg] = msgs[i];
      }
    }
    var keys = Object.keys(msgMap);
    var ret = [];
    for (var i = 0; i < keys.length; ++i)
    {
      if (msgMap[keys[i]].type === this.MSG_ERROR)
      {
        ret.push(msgMap[keys[i]]);
      }
    }
    for (var i = 0; i < keys.length; ++i)
    {
      if (msgMap[keys[i]].type === this.MSG_WARN)
      {
        ret.push(msgMap[keys[i]]);
      }
    }
    for (var i = 0; i < keys.length; ++i)
    {
      if (msgMap[keys[i]].type !== this.MSG_ERROR && msgMap[keys[i]].type !== this.MSG_WARN)
      {
        ret.push(msgMap[keys[i]]);
      }
    }
    return ret;
  }

  this.remapArrayPtrs = function (report, arrayPtr, originalArrayIndexes)
  {
    if (report === null || typeof report !== 'object' || report.msgs === null || typeof report.msgs !== 'object')
    {
      return;
    }
    var remappedMsgs = {};
    var head = arrayPtr + '/';
    Object.keys(report.msgs).forEach(function (key)
    {
      if (key.startsWith(head))
      {
        var tailStart = key.indexOf('/', head.length);
        tailStart = (tailStart < 0 ? key.length : tailStart);
        var arrayIndex = Number.parseInt(key.substring(head.length, tailStart));
        if (Number.isInteger(arrayIndex) && typeof originalArrayIndexes[arrayIndex] !== 'undefined')
        {
          remappedMsgs[head + String(originalArrayIndexes[arrayIndex]) + key.substring(tailStart)] = report.msgs[key];
          return;
        }
      }
      remappedMsgs[key] = report.msgs[key];
    });
    report.msgs = remappedMsgs;
  }

  this.getIndexesWithError = function (report, arrayPtr)
  {
    if (report === null || typeof report !== 'object' || report.msgs === null || typeof report.msgs !== 'object')
    {
      return [];
    }
    var errorSrv = this;
    var head = arrayPtr + '/';
    return Object.keys(report.msgs).filter(function (key)
    {
      // select relevant report keys
      return key.startsWith(head) && errorSrv.msgsErrorLevel(report.msgs[key]) === errorSrv.MSG_ERROR;
    }).map(function (key)
    {
      // extract the item indexes out of the keys
      var tailStart = key.indexOf('/', head.length);
      tailStart = (tailStart < 0 ? key.length : tailStart);
      return Number.parseInt(key.substring(head.length, tailStart));
    }).filter(function (idx)
    {
      // filter out non-integer indexes
      return Number.isInteger(idx);
    }).sort().filter(function (idx, i, array)
    {
      // get only unique indexes
      return i == 0 || idx !== array[i - 1];
    });
  }
}
/* harmony export (immutable) */ __webpack_exports__["a"] = ErrorService;



/***/ }),

/***/ "./app/common/error/report-field/report-field.controller.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
const ReportFieldController = function ($scope, errorSrv)
{
  if (!$scope.property)
  {
    $scope.property = "";
  }
  $scope.msgs = [];
  $scope.errors = false;
  if (typeof $scope.hasError !== 'undefined')
  {
    $scope.hasError = $scope.errors;
  }

  function refreshMsgs ()
  {
    $scope.msgs = errorSrv.sortedUniqueMsgs(errorSrv.getMsgs($scope.report, $scope.property));
    $scope.errors = errorSrv.msgsErrorLevel($scope.msgs) === errorSrv.MSG_ERROR;
    if (typeof $scope.hasError !== 'undefined')
    {
      $scope.hasError = $scope.errors;
    }
  }

  refreshMsgs();

  $scope.$on('$destroy', function ()
  {
    // delete watchers on exit
    watchReportChange();
  })

  var watchReportChange = $scope.$watch(
    function ()
    {
      return $scope.report;
    },
    function ()
    {
      refreshMsgs();
    }
  );
}
/* harmony export (immutable) */ __webpack_exports__["a"] = ReportFieldController;



/***/ }),

/***/ "./app/common/error/report-field/report-field.directive.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__report_field_controller__ = __webpack_require__("./app/common/error/report-field/report-field.controller.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__report_field_template_html__ = __webpack_require__("./app/common/error/report-field/report-field.template.html");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__report_field_template_html___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1__report_field_template_html__);



const ReportFieldDirective = function ()
{
  return {
    restrict: 'E',
    controller: __WEBPACK_IMPORTED_MODULE_0__report_field_controller__["a" /* ReportFieldController */],
    templateUrl: __WEBPACK_IMPORTED_MODULE_1__report_field_template_html__,
    scope:
    {
      report: '=',
      property: '@',
      hasError: '=',
    },
  }
}
/* harmony export (immutable) */ __webpack_exports__["a"] = ReportFieldDirective;



/***/ }),

/***/ "./app/common/error/report-field/report-field.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/error/report-field/report-field.template.html?43a4bd1de5945c9b129b85bb6556ff87";

/***/ }),

/***/ "./app/common/flx-confirm/flx-confirm.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var templateUrl = __webpack_require__("./app/common/flx-confirm/flx-confirm.template.html");
exports.flxConfirmDirective = function ($timeout, $uibModal, $parse) {
    return {
        link: function (scope, el, attr) {
            // open confirm dialog with button click
            el.bind('click', function (event) {
                openConfirmModal();
                event.stopPropagation();
            });
            // SNP-7702 open confirm dialog when closing if set to true
            if (attr.confirmClose === "true") {
                scope.$on('modal.closing', function (event, reason, closed) {
                    if (typeof reason !== 'undefined') {
                        // this check is required to properly close the confirmation dialog
                        event.preventDefault();
                        openConfirmModal();
                    }
                });
            }
            function openConfirmModal() {
                var instance = $uibModal.open({
                    backdrop: 'static',
                    templateUrl: templateUrl,
                    controller: ['$scope', '$uibModalInstance', function ($scope, $uibModalInstance) {
                            $scope.ok = function () {
                                $uibModalInstance.close();
                            };
                            $scope.cancel = function () {
                                $uibModalInstance.dismiss();
                            };
                            $scope.content = attr.flxConfirm;
                            $scope.customContent = attr.customContent;
                        }]
                });
                instance.result.then(function () {
                    // close - action!
                    $parse(attr.onConfirm)(scope);
                }, function () {
                    $timeout(function () {
                        // needs to be in a timeout because we wait for BG to leave
                        // keep class modal-open to body so users can scroll
                        // $('body').addClass('modal-open');
                    }, 10);
                });
            }
        }
    };
};


/***/ }),

/***/ "./app/common/flx-confirm/flx-confirm.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/flx-confirm/flx-confirm.template.html?f7f36c941be18e7b3f8f8c8016fcc431";

/***/ }),

/***/ "./app/common/flx-file-input/flx-file-input.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.flxFileInputDirective = function () {
    return {
        restrict: "A",
        scope: {
            flxFileInput: "=",
        },
        link: function (scope, elm, attrs) {
            elm.bind("change", function (event) {
                var file = event.target.files[0];
                var notAllowedExtention = file.name.includes("tgz") || file.name.includes("mg3");
                if (!!file && notAllowedExtention) {
                    return;
                }
                var reader = new FileReader();
                if (!!file) {
                    reader.readAsText(file);
                }
                else {
                    scope.flxFileInput.jsonfile = null;
                    scope.flxFileInput.name = "";
                }
                reader.onload = function () {
                    scope.flxFileInput.name = file.name;
                    scope.flxFileInput.jsonfile = reader.result;
                    scope.$apply();
                };
                reader.onerror = function () {
                    console.error("-", reader.result);
                };
            });
        },
    };
};


/***/ }),

/***/ "./app/common/flx-help-link/flx-help-link.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var templateUrl = __webpack_require__("./app/common/flx-help-link/flx-help-link.template.html");
exports.flxHelpLinkDirective = function (commonUtils) {
    return {
        restrict: "E",
        scope: {},
        templateUrl: templateUrl,
        link: function (scope) {
            var currentProduct = commonUtils.SNP_PRODUCT_ID;
            var selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
            scope.showHelp = true;
            if (!selfHost || currentProduct !== "snp") {
                scope.showHelp = false;
            }
        },
    };
};


/***/ }),

/***/ "./app/common/flx-help-link/flx-help-link.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/flx-help-link/flx-help-link.template.html?68cc24800e3562280bd9ea430b39f345";

/***/ }),

/***/ "./app/common/flx-help-tooltip/flx-help-tooltip.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
exports.flxHelpTooltipDirective = function (paramDefSrv) {
    // directive used to generate popup tooltips from defined list
    return {
        restrict: "A",
        link: function (scope, elem, attr) {
            if (!angular_1.isDefined(attr.title)) {
                elem.bind("mouseover", function (e) {
                    // if not defined, use label text to search for definition
                    var topicName = attr.flxHelpTooltip || elem.text().replace(/(\r\n|\n|\r)/gm, "");
                    var topicDef = paramDefSrv.getDef(topicName);
                    // if min and max are defined in sibling, attach the range
                    var sib = elem.next();
                    if (!!sib[0] && (!!sib[0].min || !!sib[0].max)) {
                        topicDef += " [";
                        if (!!sib[0].min) {
                            topicDef += "min: " + sib[0].min;
                            if (!!sib[0].max)
                                topicDef += ", ";
                        }
                        if (!!sib[0].max)
                            topicDef += "max: " + sib[0].max;
                        topicDef += "]";
                    }
                    // add title attribute
                    elem.attr("title", topicDef);
                });
            }
        },
    };
};


/***/ }),

/***/ "./app/common/flx-help-tooltip/param-def.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
// REQUIRE IS FINE HERE BECAUSE COMPLILED ON NODEJS SIDE
var params = __webpack_require__("./app/common/flx-help-tooltip/param-definition.json");
exports.paramDefService = function () {
    return {
        getDef: function (param) {
            return params[param] || param;
        }
    };
};
//// kept as reference for future needs
//// SIDE EFFECT: extra get request
//// NOTE: json path starts from public folder as "root" on server
// export const ParamDefService = function($http) {
//     var defs = {};
//     $http.get('packages/uifmm/app/fmeList/flx-help-tooltip/param-definition.json')
//         .then(function(response) {
//             defs = response.data || {};
//         });
//     return {
//         'getDef': function(param) {
//             return defs[param] || param;
//         }
//     };
// }


/***/ }),

/***/ "./app/common/flx-help-tooltip/param-definition.json":
/***/ (function(module, exports) {

module.exports = {"8x8 Transform":"Allow the use of 8x8 transforms when encoding. Only applies to H264 High Profile encoding.","AFD Default":"AFD value to be used when no AFD can be found in the input. \n2-Box 16:9 (top)\n3-Box 14:9 (top)\n4-Box > 16:9 (center)\n8-Active format is same as coded picture\n9-4:3 (center)\n10-16:9 (center)\n11-14:9 (center)\n13-4:3 (with shoot and protect 14:9 center)\n14-16:9 (with shoot and protect 14:9 center)\n15-16:9 (with shoot and protect 4:3 center)","AFD/BAR Transformation":"Determines how the input AFD/BAR data will be interpreted during the transcode process.","Adaptive Quantization":"Adaptively adjust the per macroblock quantization parameter based on the video content to improve video quality.","Alternate Scan":"MPEG-2 alternate block scan type to be used while encoding. Auto setting means it will adapt.","Apply DC High Pass Filter":"Indicates whether a DC-blocking 3 Hz highpass filter is applied to the main input channels of a Dolby Digital encoder prior to encoding","Apply LFE Low Pass Filter":"Indicates whether a 120 Hz eighth-order lowpass filter is applied to the LFE channel input of a Dolby Digital encoder prior to encoding","Apply Low Pass Filter":"Indicates whether a lowpass filter is applied to the main input channels of a Dolby Digital encoder prior to encoding","Apply Surround Channel Attenuation":"Indicates whether the Surround channel(s) are attenuated 3 dB before encoding","Apply Surround Channel Phase Shift":"Causes the Dolby Digital encoder to apply a 90-degree phase shift to the Surround channels","Audio Channel":"Select audio channels to edit. Click on + to add more channels or hover over the channels for options","Audio Channel Mode":"Specifies the number and kind of channels to produce from the encoded audio stream\nIf input audio is 5.1 and output channel mode is stereo, the 5.1 audio will be downmixed before encoding","Audio Codec":"Selects the type of encoding to be applied to this audio stream","Audio Delay":"Shifts the audio timing relative to the video timing by a specified amount","Audio Processing":"'Drop' drop all incoming data on this audio pid.\n'Passthrough' pass through this audio pid with a possible remapping of the pid. (If selected, user must allocate expected pass-through bandwidth for all pass through audios and data in the mux tab)\n'Transcode' transcode the incoming audio stream - may involve a change in codec type, number of channels, or bitrate.","Audio Production Info":"Indicates whether the mixing level and room type values are valid","Audio Rate":"Audio elementary stream output rate","Audio Source":"Select source PID for selected audio channel","Backup Elements":"Create a backup file for all current elements.","Backward Compatibility Mode":"When set to 'Enabled' the DVB-S2 Delivery System Descriptor will be added to the NIT along with Satellite Delivery Descriptor","Bandwidth (MHz)":"Specifies the the channel bandwidth","Bitstream Mode":"Describes the service carried in the audio stream","CBR":"Enable/disable constant bit rate","CC Translate":"This setting controls the translation of EIA-608 caption into EIA-708.\nWhen set to 'never', no translation in performed.\nIn the 'as-needed' setting, translation is only performed if the input does not have EIA-708.\nIn the 'always' setting, EIA-708 captions are always generated by translating from the input EIA-608 captions, whether or not the input already has EIA-708 present.","Center Frequency (MHz)":"Specifies the center frequency","Center Mix Level (dB)":"Indicates the nominal downmix level for the Center channel with respect to the Left and Right channels","Channel Coding Mode":"Indicates the configuration of the audio channels","Continuity Count Error Second(s)":"Threshold for CC Error before switching to secondary input","DSCP + ECN":"DiffServ Code Points(6bits) + Explicit Congestion Notification(2bits)","DVB-C Frequency":"Modulator Frequency","DVB-S Frequency":"Satellite's transponder frequency","Data Channel":"Select data channels to edit. Click on + to add more channels or hover over the channels for options","Data Delay":"Shifts the output PID timing relative to the output video timing by a specified amount","Data Ethernet Interface":"Data Ethernet Interface's logic name","Data Force I Frame":"Force output video stream to have I frame when splice point is triggered","Data Function":"'Passthrough' input stream is passed through from input to output\n'Drop' input stream is dropped\n'Splice' input stream is a splice point and is passedthrough as such","Data Source":"Select source PID for selected data channel","De-blocking Filter":"Strength of deblocking filter to be used during the preprocessing step of the encoder","Default Event Name":"Used to set the name of the default event name for this channel","Delivery System Descriptor":"Each byte is a pair of ascii coded hex character separated by ':' in between bytes.\nie: '01:0a:02:01:01'","Delivery System Type":"Specify Delivery System Type","Descriptors":"A string of two digit hex characters in tag, length value format representing the encoded value of an MPEG descriptor. This replaces the program descriptors in the PMT. No value means pass the input descriptors to the output.","Dialog Normalization (dB)":"Dialog Normalization Level","Dolby Surround Mode":"Indicates to a Dolby Digital decoder that also contains a Dolby Pro Logic decoder (for example a 5.1-channel amplifier), whether or not the two-channel encoded bitstream contains a Dolby Surround (Lt/Rt) program that requires Pro Logic decoding","EIT Enable":"Disable EIT Output","EIT Source":"Specify EIT Source","ESAM Acquisition Point Identity":"Unique ID for communication with the POIS server","ESAM Enable":"Note: by enabling this please make sure that you have at least 2 SCTE35 PIDs per program","ESAM Enable XC 3.1":"Enable out-of-band ESAM support","ESAM Offset From Cue":"Offset the inserted cue point by this amount, relative to the video PID","ESAM Output PID":"Associated output PID for asynchronous SCTE35 cue insertion","ESAM POIS URL":"The URL used by the SelenioOne server when communicating with the POIS server","ESAM Timeout":"The number of attempts before timing out","Element":"Select Element/IP Address","Element IP":"Element IP Address","Enable Input":"Enables the input to the service","Enable Output":"Enable/disable transport stream output","Entropy Coding":"Entropy coding mode when encoding in H264.\nCABAC (context-adaptive binary arithmetic coding) is generally more efficient than CAVLC (context adaptive variable length coding).\nCABAC cannot be used in H264 Baseline profile.","Ext: Dolby Digital Surround EX Mode":"Used to identify the encoded audio as material encoded in Surround EXTM","Ext: Lo/Ro Center Mix Level (dB)":"Indicates the level shift applied to the Center channel when adding to the left and right outputs as a result of downmixing to an Lo/Ro output","Ext: Lo/Ro Surround Mix Level (dB)":"Indicates the level shift applied to the Surround channels when downmixing to an Lo/Ro output","Ext: Lt/Rt Center Mix Level (dB)":"Indicates the level shift applied to the Center channel when adding to the left and right outputs as a result of downmixing to an Lt/Rt output","Ext: Lt/Rt Surround Mix Level (dB)":"Indicates the level shift applied to the Surround channels when downmixing to an Lt/Rt output","Ext: Preferred Stereo Downmix":"Allows the producer to select either the Lt/Rt or the Lo/Ro downmix in a consumer decoder that has stereo outputs","Film Mode Detection":"When enabled, the transcoder will attempt to detect 3-2 pulldown, and when found, it will transcode film more efficiently by dropping the repeated fields or frames.","GOP Length (s)":"Nominal length of a GOP. This is the nominal spacing between I frames. In the presence of scene changes the actual GOP length may deviate from this value.","GOP Max M":"In 'Dynamic' GOP mode, this is the maximum number of B frames between successive P frames. In 'Static' Gop mode, this parameter has no effect","GOP Min M":"In 'Dynamic' GOP mode, this is the minimum number of B frames between successive P frames. In 'Static' Gop mode, this parameter has no effect","GOP Mode":"'Dynamic' sets the number of B frames between successive P frames will be changed to improve video quality at a given rate.\n'Static' sets the number B frames between successive P frames to be fixed.","GOP Structure":"In 'Static' GOP mode, this parameter describes the GOP structure to be used.","Gain(dB)":"Audio output gain","Guard Interval":"Specifies the guard interval used for this modulation scheme","H264 IDR Frequency":"If set to 0 only I pictures are used in the output.\nFor values of 1, 2, and 3, an IDR is inserted for every I, every second I, or every 3rd I picture.\nIf set to follow input, closed input GOPs will result in closed output GOPs.","HP Code Rate":"Specifies the code rate for the low-priority level of hierarchical modulation. This is ignored/disabled for non-hierarchical modulation","Hierarchy":"Specifies whether the transmission is hierarchical. Alpha = 1 for Hierachy A, 2 for B, and 4 for C","IP Encapsulation":"Indicates whether the IP packet uses User Datagram Protocol or is encapsulated in a Real Time protocol packet","Inner FEC":"Specifies the inner FEC scheme","Input Language":"3 letter ISO language code (read-only)","Input PID":"Input PID in the input transport stream","Input Redundancy Mode":"Input Redundancy Mode:\nRevertive - If the primary input fails and the secondary is OK, a switch will be made to secondary. Once the primary is restored, control will revert to primary only if the secondary input fails.\nNonRevertive - If the primary input fails and the secondary is OK, a switch will be made to secondary.  User has to initiate failback to primary once it is restored.","Input Source":"Manually select which input to use","Input Stream Type":"Read from the input PMT (read-only)","Interface Name":"Select recieving data ethernet interface","Intra DC Precision":"MPEG-2 Intra precision dc value to be used while coding. Auto setting (4) means it will adapt","Intra VLC Format":"MPEG-2 Intra VLC format value to be used while coding. Auto setting means it will adapt.","LFE Channel":"Is LFE Channel present within the bitstream. Channel mode determines whether the LFE Channel parameter can be set. You must have at least three channels to be able to add an LFE channel","LP Code Rate":"Specifies the code rate for non-hierarchical modulation and the code rate for the high-priority level of hierarchical modulation","Level":"Level to be used for output video stream - recommended that this be left as auto, unless there is an explicit need to signal a specific level to a downstream device.","Line Mode Dynamic Range Profile":"Specifies the line mode dynamic range control processing","Loop Filter Alpha":"Loop Filter Alpha offset. Only applies to H264 encoding.","Loop Filter Beta":"Loop Filter Beta offset. Only applies to H264 encoding.","Loop Filter Mode":"Mode to be used for output deblocking filter. Only applies to H264 encoding.","MPEG2 Closed GOP":"Determines whether GOPs are open or closed. In follow input is selected, then every closed input GOP produces a closed output GOP.","Mix Level (dB)":"Describes the peak sound pressure level (SPL) used during the final mixing session at the studio or on the dubbing stage","Modulation":"Specifies modulation scheme","Motion Compensated Temporal Filtering Mode":"Type of motion-compensated temporal filtering to be applied:\nTemporal+Spatial\nTemporal\nSpatial\nAuto(use internal default mode for configuration)","Motion Compensated Temporal Filtering Strength":"Strength of MCTF filter","Multicast Group":"Multicast Group IP address leave as 0.0.0.0 if using unicast","Multiple Streams":"Only applicable if backward compatibility mode is enabled. Specifies if the transport has multiple streams.","Mux Group Statmux Enable":"Enable/disable Statmux on the transport stream","Mux Service Function":"Function for this service.\n'Program' adds a service from the input source into the output transport stream\n'PID' adds a PID from the input source into the output transport stream.","NIT Enable":"Disable NIT Output","NIT Source":"Specify NIT Source","Name":"Enter Name","Network ID":"The network identifier for this transport stream","Network Name":"The network name for this delivery system","Orbital Position (Degrees)":"Satellite's orbital position","Original Network ID":"The network identifier of the originating delivery system","Outer FEC":"Specifies outer FEC scheme","Output Language":"3 letter ISO language code. By default input ISO language code will be used.","Output PCR PID":"PID to be used for Program Clock Reference in output transport stream","Output PID":"Sets the output PID for in the output PMT and transport stream","Output PMT PID":"PID to be used for Program Map Table in output transport stream","Output Program Number":"Sets the program number associated with this service in the output PAT","Output Rate (bps)":"Transport stream output rate in bits per second","Output Resolution":"If different from input resolution, the input will be scaled to match the output resolution. In some cases, interlace to progressive conversion may be part of this scaling process","Output Stream Type":"Sets the stream type in the PMT to describe this PID's stream type","PES Packing":"Note that audio PES packets should be frame aligned","PID Map Function":"The function for this remap entry. Remap will remap the input PID to the output PID. Drop will drop this PID from the output","PID Map Input PID":"The input PID from the source program","PID Map Mode":"The mode for this PID map entry.\n'Auto' remaps the input PIDs to a set of output PIDs based on the program number.\n'Passthrough' passes the input PIDs through to the output unchanged","PID Map Output PCR PID":"The PID used for the output PCR. If blank it follows the PID map mode setting","PID Map Output PMT PID":"The PID used for the output PMT. If blank it follows the PID Map mode setting","PSI Loss Timeout(ms)":"Threshold for PSI Loss event before switching to secondary input","Passthrough Rate (bps)":"Rate to be reserved for passthrough data. This should be chosen to accommodate all passthrough data. When in automatic 'Video Bitrate Mode', this is automatically subtracted from the total transport stream rate to compute the video stream rate","Picture Structure":"Picture Structure to be used during encoding process. If output is progressive, this parameter is not used. PAFF mode is only available in H264 and not in MPEG2","Polarization":"Satellite's transponder polarization","Policing Rate (bps)":"The policing rate for this service. The input stream will be limited to this rate when set. '0' means no policing is set","Ports":"UDP/RTP port, avoid using value smaller than 1000 for potential conflict with standard ports","Primary Data Ethernet Interface":"Used to designate the primary transmit interface","Primary Destination IP Address":"Indicates the primary IP destination address","Primary Destination Port":"Indicates the primary destination port number","Primary Source":"Primary Input Source","Priority":"Specifies the priority of the transport stream","QPBOffset":"Qp offset to apply to B frames","QPChromaOffset":"Qp offset relative to luma for chroma encoding.","QPIOffset":"Qp offset to apply to I frames","RF Mode Dynamic Range Profile":"Indicates RF mode dynamic range control processing","Reference B Frames":"Allow the use of reference B frames when encoding. Only applies to H264 encoding.","Referenced PID":"PID will be referenced in the PMT","Require All Elements":"When selected only restore if elements in restore file match current element list.","Restore Elements":"Restore all elements from the selected backup file.","Rolloff Factor":"Specifies the DVB-S2 rolloff factor","Room Type":"Describes the equalization used during the final mixing session at the studio or on the dubbing stage","SCTE 35 Splice Point Trigger":"Sets the trigger for the SCTE-35 splice point in the output transport stream","SDT Enable":"Disable SDT Output","SDT Source":"Specify SDT Source","SI Mode":"Service Information mode (MPEG or DVB)","Scaling Matrix":"Allow the use of scaling matrices when encoding. Only applies to H264 High Profile encoding.","Scene Change Detection":"Enable/Disable scene change detection. When enabled, I/IDR frames will be inserted at scene changes resulting in deviations from the nominal GOP length.","Scrambling Sequence Index":"Only applicable if backward compatibility mode is set to 'Enabled'. Specifies scrambling sequence index","Secondary Data Ethernet Interface":"Used to designate the secondary transmit interface","Secondary Destination IP Address":"Indicates the secondary IP destination address","Secondary Destination Port":"Indicates the secondary destination port number","Secondary Interface Name":"Select seconday recieving data ethernet interface","Secondary Source":"Secondary Input Source (need to have the same program number)","Secondary Source Element":"Select secondary source Element/IP address","Select Template":"Select from available templates","Service Name":"The service name in the DVB Service Description table","Service Provider":"Used to set the service provider name in the DVB Service Description table","Skin Tone Detection Delta QP Max":"Maximum decrease in quantizer value for macroblocks detected to be of skin tone type.","Skin Tone Detection Strength":"Strength of skin tone detection (0=Weakest, 7=Strongest)","Source Element":"Select source Element/IP address","Source IP Address":"Multicast Source Specific IP Address for IGMPv3, leave as 0.0.0.0 if not using source specific multicast","Source Service":"Program Number in Input MPTS/SPTS","Statmux":"Enable or disable Statmux on this service","Statmux Default Rate (bps)":"The default rate for this service when enabled for Statmux.  The sum of the service default rates must not exceed the pool rate","Statmux Max Rate (bps)":"The maximum rate for this service when enabled for Statmux","Statmux Min Rate (bps)":"The minimum rate for this service when enabled for Statmux","Statmux Pool Rate (bps)":"Statmux pool bitrate.  Should be less than or equal to the output rate.  The sum of the service default Statmux rates should not exceed this rate","Statmux Priority":"Sets a priority level for this service within the Statmux pool. Higher values have higher priority","Stream ID":"Only applicable if backward compatibility mode and multiple streams are both enabled. Specifies the transport stream ID.","Surround Mix Level (dB)":"Indicates the nominal downmix level for the Surround channel(s) with respect to the Left and Right front channels","Symbol Rate (Mbaud)":"Specifies the symbol rate in Mbaud","TS ID":"Uniquely Identifies the transport stream within the delivery system","TS Loss Timeout(ms)":"Threshold for TS Loss event before switching to secondary input","TS per IP":"Indicates the number of transport packets inside each IP packet","Time to Live":"Indicates the Time to Live count.  This count is decremented for each hop the IP packet takes as it traverses the network","Transcode Rate Mode":"'Statmux' used when in statmux pool or prepared for statmux pool\n'CBR' used to output at constant bitrate","Transcode SI Mode":"Service Information Compatible with: MPEG, ATSC, DVB","Transcode Service":"Select a transcode service","Transmission Mode":"Specifiesthe transmission mode","Transport":"In Auto mode, ADTS is used for AAC-LC and LOAS/LATM is used for AAC-HE and AAC-HEv2 audio","Transport Stream":"The specific transport stream this service will be assigned to","Video Bitrate (bps)":"This value is automatically computed when video_bitrate_mode is set to 'auto. In 'manual' mode, the user must specify a video bitrate.","Video Bitrate Mode":"When this parameter is in 'auto' mode, the video bitrate for the transcoder is computed automatically, by subtracting audio, passthrough, and PSI overhead from the total multiplex rate.\nIn 'manual' mode it is up to the user to specify the video bitrate. A video bitrate should be specified so that the sum of the video, audio, passthrough and PSI rate is less than the total multiplex rate.","Video Passthrough":"Transcode: normal operation\nPassthrough: pass incoming video ES through without transcoding","Video Profile":"Codec profile to be used for output video stream","Video Rate Control Mode":"In 'CBR' rate control mode, the output is a constant bit rate transport stream.\nIn 'Statmux CBR' mode, the output is expected to be statistically multiplexed with other streams using the Selenio One multiplexer.","Weighted Prediction":"Enable/Disable Weighted Prediction for H264 encoding. When enabled, in MPEG-2 mode it is used to improve fade detection.","West/East":"Satellite's position"}

/***/ }),

/***/ "./app/common/flx-lazy-load---to-be-depricated/flx-lazy-load.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.flxLazyLoadDirective = function () {
    return {
        restrict: "A",
        transclude: "element",
        priority: 1200,
        terminal: true,
        // Use the compile function to add DOM elements after link time
        compile: function (element, attributes, linker) {
            return function (scope, iterStartElement, attributes) {
                var hasBeenShown = false;
                var unwatchFn = scope.$watch(attributes.llLazyLoad, function (value) {
                    if (value && !hasBeenShown) {
                        hasBeenShown = true;
                        linker(scope, function (clone) {
                            iterStartElement.after(clone);
                        });
                        unwatchFn();
                    }
                });
            };
        },
    };
};


/***/ }),

/***/ "./app/common/flx-menu-item/admin-menu-item.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.flxAdminMenuItemDirective = function () {
    return {
        restrict: "A",
        scope: {
            userGroup: "=flxAdminMenuItem",
            href: "@",
        },
        link: function (scope, element, attrs) {
            scope.$watch(function () {
                return scope.userGroup.name;
            }, function (value) {
                if (value == "Administrator") {
                    element.removeClass("disabled-link");
                }
                else {
                    element.addClass("disabled-link");
                }
            });
        },
    };
};


/***/ }),

/***/ "./app/common/flx-menu-item/operation-menu-item.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.flxOperationMenuItemDirective = function () {
    return {
        restrict: "A",
        scope: {
            userGroup: "=flxOperatorMenuItem",
            href: "@",
        },
        link: function (scope, element, attrs) {
            scope.$watch(function () {
                return scope.userGroup.name;
            }, function (value) {
                if (value === "Administrator" || value === "Operator") {
                    element.removeClass("disabled-link");
                }
                else {
                    element.addClass("disabled-link");
                }
            });
        },
    };
};


/***/ }),

/***/ "./app/common/flx-menu/flx-menu.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.flxMenuDirective = function ($rootScope, $route, VIEW_NAMES) {
    return {
        restrict: "A",
        scope: {
            flxMenu: "=",
            viewName: "@",
        },
        link: function (scope, iElement, iAttrs) {
            var el = "<span class='glyphicon glyphicon-ok' style='margin-left: 0.5rem'></span>";
            function _viewNameCheck() {
                // adds a mark beside current view
                if (!!scope.viewName) {
                    var child = iElement.context.children[0];
                    child.innerHTML = child.innerText;
                    if (!!VIEW_NAMES[scope.viewName]) {
                        var text = !!$route.current &&
                            $route.current.$$route &&
                            $route.current.$$route.viewName ?
                            $route.current.$$route.viewName :
                            "";
                        if (text === VIEW_NAMES[scope.viewName]) {
                            child.innerHTML = child.innerHTML + el;
                        }
                    }
                }
            }
            _viewNameCheck();
            $rootScope.$on("$routeChangeSuccess", function () {
                _viewNameCheck();
            });
        },
    };
};


/***/ }),

/***/ "./app/common/flx-title/flx-title.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var common_1 = __webpack_require__("./app/view-menu/common.js");
exports.flxTitleDirective = function ($timeout, commonUtils, snpListSrv, fmeListSrv) {
    return {
        restrict: "A",
        link: function (scope, iElement, iAttrs) {
            var selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
            var productName = commonUtils.SNP_PRODUCT_NAME;
            var releaseState = "";
            var titleText = productName;
            var tabTitle = productName;
            var snpNameTag = "";
            var fmeIp = window.location.hostname;
            function refreshTitle() {
                snpListSrv.getObjects(fmeIp, [
                    {
                        type: common_1.SNP_OBJTYPE_SYSTEM,
                        object_ID: common_1.SNP_OBJTYPE_SYSTEM,
                        getConfig: true,
                        getStatus: true
                    }
                ]).then(function (objects) {
                    snpNameTag = objects[common_1.SNP_OBJTYPE_SYSTEM].config.Global_Control.unit_name;
                    releaseState = objects[common_1.SNP_OBJTYPE_SYSTEM].status.General.productReleaseState;
                    updateTitle();
                }, function (error) {
                    // if getObjects failed reload
                    fmeIp = snpListSrv.getFirstElementIp();
                    $timeout(loadObject, 1000);
                });
            }
            // load system object
            function loadObject() {
                if (!selfHost && !commonUtils.validateIPaddress(fmeIp)) {
                    fmeIp = snpListSrv.getFirstElementIp();
                    $timeout(loadObject, 1000);
                    return;
                }
                var headers = [
                    {
                        fme_ip: fmeIp,
                        type: common_1.SNP_OBJTYPE_SYSTEM,
                        object_ID: common_1.SNP_OBJTYPE_SYSTEM,
                    },
                ];
                refreshTitle();
                // subscribe to the value changes
                fmeListSrv.msgObjectSubscribe(onUpdate, headers);
            }
            // on value change update the title
            function onUpdate(object) {
                setTimeout(function () {
                    refreshTitle();
                }, 5000);
            }
            // if this is a selfHost system then load the name tag
            if (selfHost) {
                loadObject();
            }
            function updateTitle() {
                if (angular_1.isDefined(releaseState)) {
                    if (angular_1.isDefined(snpNameTag) && snpNameTag !== "") {
                        titleText = productName + releaseState + " - " + snpNameTag;
                        tabTitle = snpNameTag;
                    }
                    else if (commonUtils.validateIPaddress(fmeIp)) {
                        titleText = productName + releaseState + " - " + fmeIp;
                        tabTitle = fmeIp;
                    }
                }
                if (iElement[0].tagName.toLowerCase() === "title") {
                    // this updates the browser tab title
                    iElement.html(tabTitle);
                }
                else {
                    // this updates the UI page title
                    iElement.html(titleText);
                }
            }
            updateTitle();
        },
    };
};


/***/ }),

/***/ "./app/common/gui/basic-elements/cell/cell.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var readonly_controller_1 = __webpack_require__("./app/common/gui/basic-elements/shared/readonly.controller.ts");
var templateUrl = __webpack_require__("./app/common/gui/basic-elements/cell/cell.template.html");
exports.CellDirective = function () {
    return {
        restrict: "E",
        controller: readonly_controller_1.ReadonlyController,
        templateUrl: templateUrl,
        scope: {
            object: "=",
            property: "=",
            metadata: "=",
        },
    };
};


/***/ }),

/***/ "./app/common/gui/basic-elements/cell/cell.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/gui/basic-elements/cell/cell.template.html?e9128dd400ee8c90f3b9c9d053b53818";

/***/ }),

/***/ "./app/common/gui/basic-elements/collapsible/collapsible.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.CollapsibleController = function ($scope) {
    $scope.isCollapsed = $scope.collapsed;
    $scope.toggle = function () {
        $scope.isCollapsed = !$scope.isCollapsed;
    };
};


/***/ }),

/***/ "./app/common/gui/basic-elements/collapsible/collapsible.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var collapsible_controller_1 = __webpack_require__("./app/common/gui/basic-elements/collapsible/collapsible.controller.ts");
var templateUrl = __webpack_require__("./app/common/gui/basic-elements/collapsible/collapsible.template.html");
exports.CollapsibleDirective = function () {
    return {
        restrict: "E",
        controller: collapsible_controller_1.CollapsibleController,
        templateUrl: templateUrl,
        transclude: true,
        scope: {
            title: "@",
            collapsed: "="
        }
    };
};


/***/ }),

/***/ "./app/common/gui/basic-elements/collapsible/collapsible.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/gui/basic-elements/collapsible/collapsible.template.html?65768cb8dc9927d434b470de6e8dcc24";

/***/ }),

/***/ "./app/common/gui/basic-elements/control-indexed/control-indexed.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var templateUrl = __webpack_require__("./app/common/gui/basic-elements/control-indexed/control-indexed.template.html");
exports.ControlIndexedDirective = function () {
    return {
        restrict: "E",
        templateUrl: templateUrl,
        scope: {
            object: "=",
            array: "@",
            itemProperty: "@",
            index: "=",
            liveObject: "=",
            metadata: "=",
            report: "=",
            validatorFunc: "=",
            changeFunc: "=",
            liveCallback: "=",
            grouping: "@",
            itemAction: "@",
            isReadonly: "=",
            isDisabled: "=",
            licenseCheck: "=",
            indexLabel: "=",
        },
    };
};


/***/ }),

/***/ "./app/common/gui/basic-elements/control-indexed/control-indexed.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/gui/basic-elements/control-indexed/control-indexed.template.html?facfdbc11940f4451b89ea0d67bc0e21";

/***/ }),

/***/ "./app/common/gui/basic-elements/control/control.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.guiFieldController = function ($scope, metadataSrv, errorSrv, liveParamsSrv, guiSrv) {
    $scope.MSG_ERROR = errorSrv.MSG_ERROR;
    $scope.MSG_WARN = errorSrv.MSG_WARN;
    $scope.MSG_INFO = errorSrv.MSG_INFO;
    var propMetadata;
    var fieldValidationMsgs;
    var actionValidationMsgs;
    var fieldErrors;
    var actionError;
    var groupSize;
    function onAdjustedMetadata() {
        if (!$scope.metadata) {
            console.log('Looks like there is missing metadata for ' + $scope.property);
        }
        propMetadata = metadataSrv.metadataFor($scope.metadata, $scope.property);
        if (!propMetadata) {
            console.log('Looks like metadata is incomplete for property ' + $scope.property, $scope.metadata);
        }
        fieldValidationMsgs = [];
        actionValidationMsgs = [];
        fieldErrors = [];
        actionError = false;
        $scope.isArray = metadataSrv.isArray(propMetadata);
        $scope.items = [];
        if ($scope.isArray) {
            var numItems = metadataSrv.numItems(propMetadata);
            for (var i = 0; i < numItems; ++i) {
                $scope.items.push(i);
            }
            propMetadata = metadataSrv.metadataForArrayItems(propMetadata);
        }
        groupSize = Math.max(1, (typeof $scope.grouping !== 'undefined') ? Number($scope.grouping) : $scope.items.length);
        $scope.widthClass = 'width-' + ($scope.isArray ? $scope.items.length : 1) + '-' + groupSize;
        $scope.name = guiSrv.name(propMetadata);
        if (typeof $scope.indexLabel !== "undefined") {
            $scope.name = $scope.name + " " + $scope.indexLabel;
        }
        $scope.description = guiSrv.description(propMetadata);
        $scope.showLabel = $scope.isReadonly || guiSrv.guiType(propMetadata) !== guiSrv.CTRL_BUTTON;
        $scope.live = !$scope.isReadonly && liveParamsSrv.isLive(propMetadata);
        $scope.displayUnit = guiSrv.displayUnit(propMetadata);
    }
    onAdjustedMetadata();
    $scope.showGroupSpace = function (idx) {
        return (typeof idx === 'undefined' ? false : (idx + 1) % groupSize == 0 && (idx + 1) < $scope.items.length);
    };
    $scope.setFieldValidationMsgs = function (idx, msgs) {
        fieldValidationMsgs[(typeof idx === 'undefined' ? 0 : idx)] = msgs;
        $scope.refreshMsgs();
    };
    $scope.setActionValidationMsgs = function (idx, msgs) {
        actionValidationMsgs = msgs;
        $scope.refreshMsgs();
    };
    $scope.hasFieldError = function (idx) {
        return fieldErrors[(typeof idx === 'undefined' ? 0 : idx)] === true;
    };
    $scope.hasActionError = function (idx) {
        return actionError === true;
    };
    $scope.refreshMsgs = function () {
        $scope.msgs = errorSrv.getMsgs($scope.report, $scope.property);
        if (typeof $scope.action !== 'undefined' && $scope.action !== "") {
            $scope.msgs = $scope.msgs.concat(errorSrv.getMsgs($scope.report, $scope.action));
        }
        $scope.hasError = errorSrv.msgsErrorLevel($scope.msgs) === $scope.MSG_ERROR;
        if ($scope.isArray) {
            for (var i = 0; i < $scope.items.length; ++i) {
                var fieldMsgs = errorSrv.getMsgs($scope.report, $scope.property + '/' + i);
                if (typeof fieldValidationMsgs[i] !== 'undefined') {
                    fieldMsgs = fieldMsgs.concat(fieldValidationMsgs[i]);
                }
                fieldErrors[i] = errorSrv.msgsErrorLevel(fieldMsgs) === $scope.MSG_ERROR;
                $scope.msgs = $scope.msgs.concat(fieldMsgs);
                $scope.hasError = $scope.hasError || fieldErrors[i];
            }
        }
        else {
            if (typeof fieldValidationMsgs[0] !== 'undefined') {
                $scope.msgs = $scope.msgs.concat(fieldValidationMsgs[0]);
            }
            fieldErrors[0] = errorSrv.msgsErrorLevel($scope.msgs) === $scope.MSG_ERROR;
            $scope.hasError = $scope.hasError || fieldErrors[0];
        }
        if (typeof actionValidationMsgs !== 'undefined') {
            $scope.msgs = $scope.msgs.concat(actionValidationMsgs);
            actionError = errorSrv.msgsErrorLevel(actionValidationMsgs) === $scope.MSG_ERROR;
            $scope.hasError = $scope.hasError || actionError;
        }
        $scope.msgs = errorSrv.sortedUniqueMsgs($scope.msgs);
    };
    $scope.$on('$destroy', function () {
        // delete watchers on exit
        watchReportChange();
        watchAdjustMetadata();
    });
    var watchReportChange = $scope.$watch(function () {
        return $scope.report;
    }, function () {
        $scope.refreshMsgs();
        $scope.$broadcast('updatedReport');
    });
    var watchAdjustMetadata = $scope.$on('adjustedMetadata', function (event, update) {
        if ($scope.property === update.property) {
            onAdjustedMetadata();
            $scope.$broadcast('adjustedFieldMetadata', update);
        }
    });
};


/***/ }),

/***/ "./app/common/gui/basic-elements/control/control.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var control_controller_1 = __webpack_require__("./app/common/gui/basic-elements/control/control.controller.ts");
var templateUrl = __webpack_require__("./app/common/gui/basic-elements/control/control.template.html");
exports.ControlDirective = function () {
    return {
        restrict: "E",
        controller: control_controller_1.guiFieldController,
        // controller: "guiFieldCtrl",
        templateUrl: templateUrl,
        scope: {
            object: "=",
            property: "@",
            liveObject: "=",
            metadata: "=",
            report: "=",
            validatorFunc: "=",
            liveCallback: "=",
            grouping: "@",
            action: "@",
            isReadonly: "=",
            isDisabled: "=",
            licenseCheck: "=",
            index: "=",
            changeFunc: "=",
            indexLabel: "=",
            controlValue: "=",
        },
    };
};


/***/ }),

/***/ "./app/common/gui/basic-elements/control/control.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/gui/basic-elements/control/control.template.html?74087615ac9e2e6f6d68b149f1803d68";

/***/ }),

/***/ "./app/common/gui/basic-elements/editable/editable.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var templateUrl = __webpack_require__("./app/common/gui/basic-elements/editable/editable.template.html");
exports.EditableDirective = function () {
    return {
        restrict: "E",
        controller: "editableCtrl",
        templateUrl: templateUrl,
        scope: {
            object: "=",
            idx: "=",
            property: "=",
            liveObject: "=",
            metadata: "=",
            isDisabled: "=",
            validatorFunc: "=",
            validationCallbackFunc: "=",
            isInvalidFunc: "=",
            liveCallback: "=",
            groupSpace: "=",
            widthClass: "=",
            licenseCheck: "=",
            index: "=",
            changeFunc: "=",
            indexLabel: "=",
        },
    };
};


/***/ }),

/***/ "./app/common/gui/basic-elements/editable/editable.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/gui/basic-elements/editable/editable.template.html?b224b5d6368578584f8440ef01d137c3";

/***/ }),

/***/ "./app/common/gui/basic-elements/exclude-form/exclude-form.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ExcludeFormDirective = function () {
    return {
        restrict: 'A',
        require: '^ngModel',
        scope: {
            excludeForm: '=?'
        },
        link: function (scope, elem, attrs, ctrl) {
            // exclude from forms if true
            if (typeof scope.excludeForm === 'undefined') {
                scope.excludeForm = true;
            }
            if (!ctrl) {
                return;
            }
            if (scope.excludeForm === true) {
                ctrl.$pristine = false;
                var parent = elem.parent().controller('form');
                parent.$removeControl(ctrl);
            }
        }
    };
};


/***/ }),

/***/ "./app/common/gui/basic-elements/index-selector-no-meta/index-selector-no-meta.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
exports.IndexSelectorNoMetaController = function ($scope, metadataSrv, errorSrv, guiSrv) {
    $scope.MSG_ERROR = errorSrv.MSG_ERROR;
    $scope.MSG_WARN = errorSrv.MSG_WARN;
    $scope.MSG_INFO = errorSrv.MSG_INFO;
    $scope.hasError = false;
    $scope.msg = undefined;
    // scope object is an array of options
    $scope.items = $scope.object;
    // select first option
    if ($scope.items.length > 0) {
        $scope.index = $scope.items[0].value;
    }
    function updateErrorMsg() {
        if (angular_1.isArray($scope.errorIndexes) && $scope.errorIndexes.length > 0) {
            $scope.hasError = true;
            $scope.msg = {
                type: $scope.MSG_ERROR,
                msg: "Errors in items with positions: " + $scope.errorIndexes.join(', '),
            };
        }
        else {
            $scope.hasError = false;
            $scope.msg = undefined;
        }
    }
    $scope.$on('$destroy', function () {
        watchErrorIndexes();
    });
    var watchErrorIndexes = $scope.$watch('errorIndexes', updateErrorMsg);
};


/***/ }),

/***/ "./app/common/gui/basic-elements/index-selector-no-meta/index-selector-no-meta.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var index_selector_no_meta_controller_1 = __webpack_require__("./app/common/gui/basic-elements/index-selector-no-meta/index-selector-no-meta.controller.ts");
var templateUrl = __webpack_require__("./app/common/gui/basic-elements/shared/index-selector.template.html");
exports.IndexSelectorNoMetaDirective = function () {
    return {
        restrict: "E",
        controller: index_selector_no_meta_controller_1.IndexSelectorNoMetaController,
        templateUrl: templateUrl,
        scope: {
            index: "=",
            object: "=",
            name: "@?label",
            description: "@?",
            changeFunc: "=",
            errorIndexes: "<",
        },
    };
};


/***/ }),

/***/ "./app/common/gui/basic-elements/index-selector/index-selector.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var JsonPointer = __webpack_require__("./node_modules/json-ptr/releases/json-ptr-1.0.1.min.js");
exports.IndexSelectorController = function ($scope, metadataSrv, errorSrv, guiSrv) {
    $scope.MSG_ERROR = errorSrv.MSG_ERROR;
    $scope.MSG_WARN = errorSrv.MSG_WARN;
    $scope.MSG_INFO = errorSrv.MSG_INFO;
    var propMetadata = metadataSrv.metadataFor($scope.metadata, $scope.array);
    $scope.hasError = false;
    $scope.msg = undefined;
    $scope.items = [];
    if (metadataSrv.isArray(propMetadata)) {
        var objects = JsonPointer.get($scope.object, $scope.array);
        var numItems = metadataSrv.numItems(propMetadata);
        for (var i = 0; i < numItems; ++i) {
            if (typeof objects !== 'undefined' && typeof objects[i] !== 'undefined' && typeof objects[i].idx !== 'undefined') {
                $scope.items.push({
                    value: i,
                    label: objects[i].labelIdx ? objects[i].labelIdx : objects[i].idx,
                });
            }
        }
    }
    if ($scope.items.length > 0) {
        $scope.index = $scope.items[0].value;
    }
    $scope.name = guiSrv.name(propMetadata);
    $scope.description = guiSrv.description(propMetadata);
    function updateErrorMsg() {
        if (angular_1.isArray($scope.errorIndexes) && $scope.errorIndexes.length > 0) {
            $scope.hasError = true;
            $scope.msg = {
                type: $scope.MSG_ERROR,
                msg: "Errors in items with positions: " + $scope.errorIndexes.join(', '),
            };
        }
        else {
            $scope.hasError = false;
            $scope.msg = undefined;
        }
    }
    $scope.$on('$destroy', function () {
        watchErrorIndexes();
    });
    var watchErrorIndexes = $scope.$watch('errorIndexes', updateErrorMsg);
};


/***/ }),

/***/ "./app/common/gui/basic-elements/index-selector/index-selector.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var index_selector_controller_1 = __webpack_require__("./app/common/gui/basic-elements/index-selector/index-selector.controller.ts");
var templateUrl = __webpack_require__("./app/common/gui/basic-elements/shared/index-selector.template.html");
exports.IndexSelectorDirective = function () {
    return {
        restrict: "E",
        controller: index_selector_controller_1.IndexSelectorController,
        templateUrl: templateUrl,
        scope: {
            index: "=",
            object: "=",
            array: "@",
            metadata: "=",
            isDisabled: "=",
            changeFunc: "=",
            errorIndexes: "<",
        },
    };
};


/***/ }),

/***/ "./app/common/gui/basic-elements/no-field-error/no-field-error.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.NoFieldErrorDirective = function () {
    return {
        restrict: 'A',
        require: 'ngModel',
        link: function (scope, elm, attrs, ctrl) {
            scope.$parent.controller$validate = ctrl.$validate;
            ctrl.$validators.noFieldError = function (modelValue, viewValue) {
                scope.validate(modelValue);
                return !scope.hasError();
            };
        },
    };
};


/***/ }),

/***/ "./app/common/gui/basic-elements/object-table/object-table.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular = __webpack_require__("./node_modules/angular/index.js");
var JsonPointer = __webpack_require__("./node_modules/json-ptr/releases/json-ptr-1.0.1.min.js");
exports.objectTableController = function ($scope, metadataSrv, errorSrv, guiSrv, uiModalsSrv) {
    var propMetadata;
    var ptr;
    $scope.isColumnDisplayed = function (property) {
        if ($scope.displayColumns === undefined) {
            return (property !== 'idx' && property !== 'delete');
        }
        else {
            return $scope.displayColumns.filter(function (p) { return p === property; }).length > 0;
        }
    };
    $scope.getObjectName = function (data) {
        if (!!$scope.nameProperty) {
            return data[$scope.nameProperty];
        }
        else {
            return "";
        }
    };
    $scope.getPropertyValueFromMeta = function (propValue, propMetadata) {
        if (!!propMetadata.enum && !!propMetadata.enumLabels) {
            var propIdx = propMetadata.enum.indexOf(propValue);
            if (propIdx >= 0 && propIdx <= propMetadata.enumLabels.length) {
                return propMetadata.enumLabels[propIdx];
            }
            else {
                return propValue;
            }
        }
        else {
            return propValue;
        }
    };
    $scope.getObjectPropertyValue = function (data, property) {
        //console.log(data, property);
        if (!!propMetadata.items.properties[property]) {
            if (!!data[property]) {
                return $scope.getPropertyValueFromMeta(data[property], propMetadata.items.properties[property]);
            }
            else {
                return $scope.getPropertyValueFromMeta(propMetadata.items.properties[property].default, propMetadata.items.properties[property]);
            }
        }
        else {
            return "";
        }
    };
    $scope.getItems = function () {
        return ptr.get($scope.object);
    };
    function compareByIdx(a, b) {
        return a.idx - b.idx;
    }
    function getFreeIdx(objectArr) {
        var idxArray = [];
        objectArr.forEach(function (item) {
            if (!!item.idx) {
                idxArray.push(item.idx);
            }
        });
        idxArray.sort(function (a, b) {
            return a - b;
        });
        var freeIdx = 1;
        idxArray.forEach(function (i) {
            if (i == freeIdx) {
                freeIdx += 1;
            }
        });
        return freeIdx;
    }
    function onAdjustedMetadata() {
        if (!$scope.metadata) {
            return;
        }
        propMetadata = metadataSrv.metadataFor($scope.metadata, $scope.property);
        if (!propMetadata) {
            return;
        }
        $scope.title = propMetadata.title;
        $scope.maxItems = propMetadata.maxItems;
        $scope.itemProperties = propMetadata.items.properties;
    }
    $scope.editItem = function (data) {
        if (data === void 0) { data = null; }
        var oldData = data ? angular.copy(data) : null;
        var type = "";
        var meta = propMetadata;
        var devices = $scope.getItems();
        var validationFunc = $scope.validatorFunc;
        var showFieldFunc = $scope.showFieldFunc;
        var cfg = $scope.object;
        uiModalsSrv.openAddExternalDeviceModal({
            type: type,
            meta: meta,
            data: data,
            devices: devices,
            validationFunc: validationFunc,
            showFieldFunc: showFieldFunc,
            cfg: cfg
        })
            .result.then(function (result) {
            if (result) {
                if (result.idx) {
                    devices.forEach(function (item, i, arr) {
                        if (item.idx == result.idx) {
                            arr[i] = result;
                        }
                    });
                }
                else {
                    result.idx = getFreeIdx(devices);
                    devices.push(result);
                    devices.sort(compareByIdx);
                }
                ptr.set($scope.object, devices, true);
                if ($scope.itemChangeFunc) {
                    $scope.itemChangeFunc(oldData, result);
                }
            }
        });
    };
    $scope.deleteItem = function (data) {
        var devices = $scope.getItems();
        var oldData = angular.copy(data);
        data.delete = true;
        devices.forEach(function (item, i, arr) {
            if (item.idx == data.idx) {
                item.delete = true;
            }
        });
        ptr.set($scope.object, devices, true);
        if ($scope.itemChangeFunc) {
            $scope.itemChangeFunc(oldData, data);
        }
    };
    function onPropertyChange() {
        ptr = JsonPointer.create($scope.property);
    }
    onPropertyChange();
    onAdjustedMetadata();
    $scope.$on('$destroy', function () {
        watchAdjustMetadata();
        watchPropertyChange();
    });
    var watchPropertyChange = $scope.$watch(function () {
        return $scope.property;
    }, onPropertyChange);
    var watchAdjustMetadata = $scope.$on('adjustedMetadata', function (event, update) {
        if ($scope.property === update.property) {
            onAdjustedMetadata();
        }
    });
};


/***/ }),

/***/ "./app/common/gui/basic-elements/object-table/object-table.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var object_table_controller_1 = __webpack_require__("./app/common/gui/basic-elements/object-table/object-table.controller.ts");
var templateUrl = __webpack_require__("./app/common/gui/basic-elements/object-table/object-table.template.html");
exports.ObjectTableDirective = function () {
    return {
        restrict: "E",
        controller: object_table_controller_1.objectTableController,
        templateUrl: templateUrl,
        scope: {
            object: "=",
            property: "@",
            metadata: "=",
            displayColumns: "=",
            itemChangeFunc: "=",
            nameProperty: "=",
            validatorFunc: "=",
            showFieldFunc: "="
        },
    };
};


/***/ }),

/***/ "./app/common/gui/basic-elements/object-table/object-table.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/gui/basic-elements/object-table/object-table.template.html?a4a516596dd2db1f5a8c91eaa4df7758";

/***/ }),

/***/ "./app/common/gui/basic-elements/readonly/readonly.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var readonly_controller_1 = __webpack_require__("./app/common/gui/basic-elements/shared/readonly.controller.ts");
var templateUrl = __webpack_require__("./app/common/gui/basic-elements/readonly/readonly.template.html");
exports.ReadonlyDirective = function () {
    return {
        restrict: "E",
        controller: readonly_controller_1.ReadonlyController,
        templateUrl: templateUrl,
        scope: {
            object: "=",
            idx: "=",
            property: "=",
            metadata: "=",
            groupSpace: "=",
            widthClass: "=",
        },
    };
};


/***/ }),

/***/ "./app/common/gui/basic-elements/readonly/readonly.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/gui/basic-elements/readonly/readonly.template.html?f1d7b47877cb127ecc05c3197e6f5f2d";

/***/ }),

/***/ "./app/common/gui/basic-elements/shared/index-selector.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/gui/basic-elements/shared/index-selector.template.html?74c729af47ce2a96bad8637d13ccd9da";

/***/ }),

/***/ "./app/common/gui/basic-elements/shared/readonly.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var JsonPointer = __webpack_require__("./node_modules/json-ptr/releases/json-ptr-1.0.1.min.js");
exports.ReadonlyController = function ($scope, metadataSrv, guiSrv) {
    var prop, ptr;
    function onPropertyChange() {
        prop = $scope.property;
        if (typeof $scope.idx !== 'undefined') {
            prop = prop + '/' + $scope.idx;
        }
        ptr = JsonPointer.create(prop);
    }
    onPropertyChange();
    var propMetadata = metadataSrv.metadataFor($scope.metadata, prop);
    var decimalShiftLeft = guiSrv.decimalShiftLeft(propMetadata);
    var displayCoefficient = guiSrv.displayCoefficient(propMetadata);
    var displayPrecision = guiSrv.displayPrecision(propMetadata);
    var isHexFormat = guiSrv.displayFormat(propMetadata) === "hex";
    function internalModel() {
        var ret = ptr.get($scope.object);
        if (typeof propMetadata.enum !== 'undefined' && typeof propMetadata.enumLabels !== 'undefined') {
            var enumIdx = propMetadata.enum.indexOf(ret);
            if (enumIdx >= 0 && enumIdx < propMetadata.enumLabels.length) {
                ret = propMetadata.enumLabels[enumIdx];
            }
        }
        if (typeof ret === "object" && typeof ret.valueOf() === "boolean") {
            ret = ret.valueOf();
        }
        if (ret === true) {
            return 'Yes';
        }
        else if (ret === false) {
            return 'No';
        }
        else {
            return ret;
        }
    }
    $scope.description = function () {
        return guiSrv.description(propMetadata);
    };
    $scope.model = function (value) {
        if (arguments.length) {
            throw "Attempting to set new value to read-only property.";
        }
        else {
            return guiSrv.numericToDisplay(internalModel(), decimalShiftLeft, displayCoefficient, displayPrecision, isHexFormat);
        }
    };
    $scope.$on('$destroy', function () {
        watchPropertychange();
    });
    var watchPropertychange = $scope.$watch(function () {
        return $scope.property;
    }, onPropertyChange);
};
// angular.module('guiMod').controller('readonlyCtrl', ReadonlyController)
// angular.module('guiMod').controller('readonlyCtrl', ['$scope', 'metadataSrv', 'guiSrv', ])


/***/ }),

/***/ "./app/common/gui/basic-elements/status-indexed/status-indexed.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var templateUrl = __webpack_require__("./app/common/gui/basic-elements/status-indexed/status-indexed.template.html");
exports.StatusIndexedDirective = function () {
    return {
        restrict: "E",
        templateUrl: templateUrl,
        scope: {
            object: "=",
            array: "@",
            itemProperty: "@",
            index: "=",
            metadata: "=",
            isDisabled: "=",
            report: "=",
            grouping: "@",
            itemAction: "@",
        },
    };
};


/***/ }),

/***/ "./app/common/gui/basic-elements/status-indexed/status-indexed.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/gui/basic-elements/status-indexed/status-indexed.template.html?aa1b5600e4628516812a3b665cfc1794";

/***/ }),

/***/ "./app/common/gui/basic-elements/status/status.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var templateUrl = __webpack_require__("./app/common/gui/basic-elements/status/status.template.html");
exports.StatusDirective = function () {
    return {
        restrict: 'E',
        templateUrl: templateUrl,
        scope: {
            object: '=',
            property: '@',
            metadata: '=',
            report: '=',
            grouping: '@',
            action: '@',
        },
    };
};


/***/ }),

/***/ "./app/common/gui/basic-elements/status/status.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/gui/basic-elements/status/status.template.html?3bb394f8a37a512bbd84fe44d54de944";

/***/ }),

/***/ "./app/common/gui/gui.controller.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular__ = __webpack_require__("./node_modules/angular/index.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_angular__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_json_ptr__ = __webpack_require__("./node_modules/json-ptr/releases/json-ptr-1.0.1.min.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_json_ptr___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_json_ptr__);



const GuiController = function ($scope, metadataSrv, errorSrv, liveParamsSrv, guiSrv, modalsSrv, commonUtils)
{
  $scope.MSG_ERROR = errorSrv.MSG_ERROR;
  $scope.MSG_WARN = errorSrv.MSG_WARN;
  $scope.MSG_INFO = errorSrv.MSG_INFO;
  $scope.CTRL_UNKNOWN = guiSrv.CTRL_UNKNOWN;
  $scope.CTRL_TEXT = guiSrv.CTRL_TEXT;
  $scope.CTRL_CHECKBOX = guiSrv.CTRL_CHECKBOX;
  $scope.CTRL_SELECT = guiSrv.CTRL_SELECT;
  $scope.CTRL_BUTTON = guiSrv.CTRL_BUTTON;
  $scope.CTRL_ROLLOVER = guiSrv.CTRL_ROLLOVER;
  $scope.CTRL_RANGE = guiSrv.CTRL_RANGE;
  $scope.CTRL_IPV4 = guiSrv.CTRL_IPV4;
  $scope.CTRL_CHECKLIST = guiSrv.CTRL_CHECKLIST;

  var ipv4Regex =
    /^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;

  var unknownTypeErrorMsg = {
    type: $scope.MSG_ERROR,
    msg: 'Unsupported parameter type.'
  };

  var invalidIPv4ErrorMsg = {
    type: $scope.MSG_ERROR,
    msg: 'Invalid IP address.'
  };

  var notANumberErrorMsg = {
    type: $scope.MSG_ERROR,
    msg: 'Not a number.'
  }

  var outOfRangeErrorMsg = {
    type: $scope.MSG_ERROR,
    msg: 'Out of range.'
  }

  var notEnoughItemsErrorMsg = {
    type: $scope.MSG_ERROR,
    msg: 'Not enough items selected.'
  }

  var tooManyItemsErrorMsg = {
    type: $scope.MSG_ERROR,
    msg: 'Too many items selected.'
  }

  var prop, ptr, propMetadata;

  function displayToInternal (value)
  {
    // attempt to coerce input (always a string) into a number
    // note: skip null and empty string because it gets converted to 0
    // note: if hex formatted, then conversion will be done by displayToNumeric
    if (!isHexFormat && isNumberProperty && value !== '' && value !== null && !commonUtils.endsWith(value, '.') && !commonUtils.endsWith(value, ','))
    {
      var n = Number(value);
      if (Number.isFinite(n))
      {
        value = n;
      }
    }
    return guiSrv.displayToNumeric(value, decimalShiftLeft, displayCoefficient, guiSrv.isInteger(propMetadata), isHexFormat);
  }

  function internalModel (value)
  {
    if (arguments.length)
    {
      ptr.set($scope.object, value, true);
    }
    else
    {
      return ptr.get($scope.object);
    }
  }

  function formatValueListFromOptions (options)
  {
    var output = "";

    for (var i = 0; i < options.length; ++i)
    {
      if (options[i].selected)
      {
        if (output !== "")
        {
          output += ";";
        }
        output += options[i].value;
      }
    }

    //console.log(output);

    return output;
  }

  function setOptionsFromValueList (value)
  {
    var selectedOptions = value.split(";");
    //console.log(selectedOptions);

    for (var i = 0; i < $scope.options.length; ++i)
    {
      $scope.options[i].selected = selectedOptions.includes($scope.options[i].value.toString());
    }
  }

  function internalValidate (value)
  {
    var msgs = [];

    if (isNumberProperty && !Number.isFinite(value))
    {
      msgs.push(notANumberErrorMsg);
    }
    if (__WEBPACK_IMPORTED_MODULE_0_angular__["isDefined"](internalMax) && value > internalMax)
    {
      msgs.push(outOfRangeErrorMsg);
    }
    if (__WEBPACK_IMPORTED_MODULE_0_angular__["isDefined"](internalMin) && value < internalMin)
    {
      msgs.push(outOfRangeErrorMsg);
    }
    if (ctrlType == guiSrv.CTRL_UNKNOWN)
    {
      msgs.push(unknownTypeErrorMsg);
    }
    if (ctrlType == guiSrv.CTRL_IPV4 && value && !value.match(ipv4Regex))
    {
      msgs.push(invalidIPv4ErrorMsg);
    }
    if (ctrlType == guiSrv.CTRL_CHECKLIST && __WEBPACK_IMPORTED_MODULE_0_angular__["isDefined"](internalMinItems) && value.split(";").length < internalMinItems)
    {
      msgs.push(notEnoughItemsErrorMsg);
    }
    if (ctrlType == guiSrv.CTRL_CHECKLIST && __WEBPACK_IMPORTED_MODULE_0_angular__["isDefined"](internalMaxItems) && value.split(";").length > internalMaxItems)
    {
      msgs.push(tooManyItemsErrorMsg);
    }
    if (typeof $scope.validatorFunc !== 'undefined')
    {
      msgs = msgs.concat($scope.validatorFunc(value));
    }
    $scope.validationCallbackFunc($scope.idx, msgs);
  }

  $scope.validate = function (value)
  {
    return internalValidate(displayToInternal(value));
  }

  function onPropertyChange ()
  {
    prop = $scope.property;
    if (typeof $scope.idx !== 'undefined')
    {
      prop = prop + '/' + $scope.idx;
    }
    ptr = __WEBPACK_IMPORTED_MODULE_1_json_ptr__["create"](prop); // TDL: replace JsonPointer library if needed for new Angular
    if ($scope.controller$validate)
    {
      $scope.controller$validate();
    }
    else
    {
      internalValidate(internalModel());
    }
  }

  function onValueChangeByUser ()
  {
    internalValidate(internalModel());
    if (typeof $scope.liveCallback !== 'undefined')
    {
      $scope.liveCallback(prop, internalModel());
    }
  }

  var isNumberProperty;
  var ctrlType;
  var decimalShiftLeft;
  var displayCoefficient;
  var displayPrecision;
  var internalStep;
  var internalMin;
  var internalMax;
  var isHexFormat;
  var internalMinItems;
  var internalMaxItems;

  function onAdjustedMetadata ()
  {
    propMetadata = metadataSrv.metadataFor($scope.metadata, prop);

    isNumberProperty = guiSrv.isNumber(propMetadata);
    ctrlType = guiSrv.guiType(propMetadata);
    decimalShiftLeft = guiSrv.decimalShiftLeft(propMetadata);
    displayCoefficient = guiSrv.displayCoefficient(propMetadata);
    displayPrecision = guiSrv.displayPrecision(propMetadata);
    internalStep = guiSrv.multipleOf(propMetadata);
    internalMin = guiSrv.minimum(propMetadata);
    internalMax = guiSrv.maximum(propMetadata);
    isHexFormat = guiSrv.displayFormat(propMetadata) === "hex";
    internalMinItems = guiSrv.minItems(propMetadata);
    internalMaxItems = guiSrv.maxItems(propMetadata);

    $scope.name = guiSrv.name(propMetadata);
    $scope.options = guiSrv.enumOptions(propMetadata);
    $scope.min = guiSrv.numericToDisplay(internalMin, decimalShiftLeft, displayCoefficient, displayPrecision);
    $scope.max = guiSrv.numericToDisplay(internalMax, decimalShiftLeft, displayCoefficient, displayPrecision);
    outOfRangeErrorMsg.msg = "Out of range (Min:" + $scope.min + ", Max:" + $scope.max + ").";
    // for the step, browsers seem to support only powers of 10
    var stepExponent = undefined;
    if (Number.isFinite(decimalShiftLeft))
    {
      stepExponent = decimalShiftLeft;
    }
    else if (Number.isFinite(displayPrecision))
    {
      stepExponent = displayPrecision;
    }

    if (ctrlType === guiSrv.CTRL_CHECKLIST)
    {
      setOptionsFromValueList(internalModel());
    }

    $scope.step = guiSrv.numericToDisplay(internalStep, stepExponent);
    $scope.live = liveParamsSrv.isLive(propMetadata);
    internalValidate(internalModel());
  }

  onPropertyChange();
  onAdjustedMetadata();

  $scope.model = function (value)
  {
    if (arguments.length)
    {
      value = displayToInternal(value);
      if (value !== internalModel())
      {
        internalModel(value);
        onValueChangeByUser();
      }
    }
    else
    {
      return guiSrv.numericToDisplay(internalModel(), decimalShiftLeft, displayCoefficient, displayPrecision, isHexFormat);
    }
  }

  $scope.rangeModel = function (value)
  {
    if (arguments.length)
    {
      if (isNumberProperty)
      {
        value = Number(value);
      }

      $scope.model(value);
    }
    else
    {
      return $scope.model();
    }
  }

  $scope.checklistModel = function (option)
  {
    return function (value)
    {
      if (arguments.length)
      {
        option.selected = value;
        //console.log($scope.options);

        $scope.model(formatValueListFromOptions($scope.options));
      }
      else
      {
        return option.selected;
      }
    };
  }

  $scope.rangeModalInput = function (value)
  {
    if (arguments.length)
    {
      value = displayToInternal(value);
      if (value !== internalModel())
      {
        internalModel(value);
        onValueChangeByUser();
      }
    }
    else
    {
      return guiSrv.numericToDisplay(internalModel(), decimalShiftLeft, displayCoefficient, displayPrecision, isHexFormat);
    }
  }

  $scope.selectText = function ($event)
  {
    $event.target.select();
  }

  $scope.deselectText = function ($event)
  {
    $event.target.blur();
  }

  $scope.isType = function (type)
  {
    return type === ctrlType;
  }

  $scope.command = function ()
  {
    if ($scope.isType(guiSrv.CTRL_BUTTON))
    {
      if (typeof $scope.liveCallback !== 'undefined')
      {
        $scope.liveCallback(prop, true);
      }
    }
  }

  $scope.optionLabel = function ()
  {
    return guiSrv.currentOptionLabel($scope.options, internalModel());
  }

  $scope.rollover = function ()
  {
    if ($scope.isType(guiSrv.CTRL_ROLLOVER))
    {
      internalModel(guiSrv.rolloverOption($scope.options, internalModel()));
    }
  }

  $scope.hasError = function ()
  {
    return $scope.isInvalidFunc($scope.idx);
  }

  $scope.$on('$destroy', function ()
  {
    // delete all watchers on exit
    watchPropertyChange();
    watchInternalModelChange();
    watchAdjustMetadata();
    watchUpdatedReport();
  });

  var watchPropertyChange = $scope.$watch(function ()
    {
      return $scope.property;
    },
    onPropertyChange
  );

  var watchInternalModelChange = $scope.$watch(function ()
    {
      return internalModel();
    },
    function (newValue, oldValue)
    {
      internalValidate(internalModel());
    }
  );

  var watchUpdatedReport = $scope.$on('updatedReport', function (event)
  {
    // we need to re-run field validation because the validity of the field depends also on the report
    if ($scope.controller$validate)
    {
      $scope.controller$validate();
    }
  });

  var watchAdjustMetadata = $scope.$on('adjustedFieldMetadata', function (event, update)
  {
    if ($scope.property === update.property)
    {
      onAdjustedMetadata();
    }
  });
}
/* harmony export (immutable) */ __webpack_exports__["a"] = GuiController;



/***/ }),

/***/ "./app/common/gui/gui.module.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular__ = __webpack_require__("./node_modules/angular/index.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_angular__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__gui_service__ = __webpack_require__("./app/common/gui/gui.service.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__gui_controller__ = __webpack_require__("./app/common/gui/gui.controller.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__basic_elements_cell_cell_directive__ = __webpack_require__("./app/common/gui/basic-elements/cell/cell.directive.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__basic_elements_cell_cell_directive___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3__basic_elements_cell_cell_directive__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__basic_elements_control_control_directive__ = __webpack_require__("./app/common/gui/basic-elements/control/control.directive.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__basic_elements_control_control_directive___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4__basic_elements_control_control_directive__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__basic_elements_control_indexed_control_indexed_directive__ = __webpack_require__("./app/common/gui/basic-elements/control-indexed/control-indexed.directive.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__basic_elements_control_indexed_control_indexed_directive___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5__basic_elements_control_indexed_control_indexed_directive__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__basic_elements_editable_editable_directive__ = __webpack_require__("./app/common/gui/basic-elements/editable/editable.directive.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__basic_elements_editable_editable_directive___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_6__basic_elements_editable_editable_directive__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__basic_elements_exclude_form_exclude_form_directive__ = __webpack_require__("./app/common/gui/basic-elements/exclude-form/exclude-form.directive.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__basic_elements_exclude_form_exclude_form_directive___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7__basic_elements_exclude_form_exclude_form_directive__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__basic_elements_index_selector_index_selector_directive__ = __webpack_require__("./app/common/gui/basic-elements/index-selector/index-selector.directive.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__basic_elements_index_selector_index_selector_directive___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_8__basic_elements_index_selector_index_selector_directive__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__basic_elements_index_selector_no_meta_index_selector_no_meta_directive__ = __webpack_require__("./app/common/gui/basic-elements/index-selector-no-meta/index-selector-no-meta.directive.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__basic_elements_index_selector_no_meta_index_selector_no_meta_directive___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_9__basic_elements_index_selector_no_meta_index_selector_no_meta_directive__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__basic_elements_no_field_error_no_field_error_directive__ = __webpack_require__("./app/common/gui/basic-elements/no-field-error/no-field-error.directive.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__basic_elements_no_field_error_no_field_error_directive___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_10__basic_elements_no_field_error_no_field_error_directive__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__basic_elements_readonly_readonly_directive__ = __webpack_require__("./app/common/gui/basic-elements/readonly/readonly.directive.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__basic_elements_readonly_readonly_directive___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_11__basic_elements_readonly_readonly_directive__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__basic_elements_status_status_directive__ = __webpack_require__("./app/common/gui/basic-elements/status/status.directive.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__basic_elements_status_status_directive___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_12__basic_elements_status_status_directive__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__basic_elements_status_indexed_status_indexed_directive__ = __webpack_require__("./app/common/gui/basic-elements/status-indexed/status-indexed.directive.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__basic_elements_status_indexed_status_indexed_directive___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_13__basic_elements_status_indexed_status_indexed_directive__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__basic_elements_object_table_object_table_directive__ = __webpack_require__("./app/common/gui/basic-elements/object-table/object-table.directive.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__basic_elements_object_table_object_table_directive___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_14__basic_elements_object_table_object_table_directive__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15__basic_elements_collapsible_collapsible_directive__ = __webpack_require__("./app/common/gui/basic-elements/collapsible/collapsible.directive.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15__basic_elements_collapsible_collapsible_directive___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_15__basic_elements_collapsible_collapsible_directive__);



















const GuiModule = Object(__WEBPACK_IMPORTED_MODULE_0_angular__["module"])('guiModule', [])
  .service('guiSrv', __WEBPACK_IMPORTED_MODULE_1__gui_service__["a" /* GuiService */])
  .controller('editableCtrl', __WEBPACK_IMPORTED_MODULE_2__gui_controller__["a" /* GuiController */])
  .directive('cell', __WEBPACK_IMPORTED_MODULE_3__basic_elements_cell_cell_directive__["CellDirective"])
  .directive('control', __WEBPACK_IMPORTED_MODULE_4__basic_elements_control_control_directive__["ControlDirective"])
  .directive('controlIndexed', __WEBPACK_IMPORTED_MODULE_5__basic_elements_control_indexed_control_indexed_directive__["ControlIndexedDirective"])
  .directive('editable', __WEBPACK_IMPORTED_MODULE_6__basic_elements_editable_editable_directive__["EditableDirective"])
  .directive('excludeForm', __WEBPACK_IMPORTED_MODULE_7__basic_elements_exclude_form_exclude_form_directive__["ExcludeFormDirective"])
  .directive('indexSelector', __WEBPACK_IMPORTED_MODULE_8__basic_elements_index_selector_index_selector_directive__["IndexSelectorDirective"])
  .directive('indexSelectorNoMeta', __WEBPACK_IMPORTED_MODULE_9__basic_elements_index_selector_no_meta_index_selector_no_meta_directive__["IndexSelectorNoMetaDirective"])
  .directive('noFieldError', __WEBPACK_IMPORTED_MODULE_10__basic_elements_no_field_error_no_field_error_directive__["NoFieldErrorDirective"])
  .directive('readonly', __WEBPACK_IMPORTED_MODULE_11__basic_elements_readonly_readonly_directive__["ReadonlyDirective"])
  .directive('status', __WEBPACK_IMPORTED_MODULE_12__basic_elements_status_status_directive__["StatusDirective"])
  .directive('statusIndexed', __WEBPACK_IMPORTED_MODULE_13__basic_elements_status_indexed_status_indexed_directive__["StatusIndexedDirective"])
  .directive('objectTable', __WEBPACK_IMPORTED_MODULE_14__basic_elements_object_table_object_table_directive__["ObjectTableDirective"])
  .directive('collapsible', __WEBPACK_IMPORTED_MODULE_15__basic_elements_collapsible_collapsible_directive__["CollapsibleDirective"])
/* harmony export (immutable) */ __webpack_exports__["GuiModule"] = GuiModule;



/***/ }),

/***/ "./app/common/gui/gui.service.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_big_js__ = __webpack_require__("./node_modules/big.js/big.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_big_js___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_big_js__);


const GuiService = function ()
{
  this.CTRL_UNKNOWN = 'CTRL_UNKNOWN';
  this.CTRL_TEXT = 'CTRL_TEXT';
  this.CTRL_CHECKBOX = 'CTRL_CHECKBOX';
  this.CTRL_SELECT = 'CTRL_SELECT';
  this.CTRL_BUTTON = 'CTRL_BUTTON';
  this.CTRL_ROLLOVER = 'CTRL_ROLLOVER';
  this.CTRL_RANGE = 'CTRL_RANGE';
  this.CTRL_IPV4 = 'CTRL_IPV4';
  this.CTRL_CHECKLIST = 'CTRL_CHECKLIST';

  this.isNumber = function (metadata)
  {
    return (typeof metadata.dataType !== 'undefined' && (metadata.dataType === 'integer' || metadata.dataType ===
      'number'));
  }

  this.isInteger = function (metadata)
  {
    return (typeof metadata.dataType !== 'undefined' && metadata.dataType === 'integer');
  }

  this.guiType = function (metadata)
  {
    var type = (typeof metadata.dataType === 'undefined' ? null : metadata.dataType);
    var subType = (typeof metadata.subType === 'undefined' ? null : metadata.subType);
    if (typeof metadata.enum !== 'undefined')
    {
      if (type === 'string' && subType === 'list')
      {
        return this.CTRL_CHECKLIST;
      }
      else if (subType === 'condensed')
      {
        return this.CTRL_ROLLOVER;
      }
      else
      {
        return this.CTRL_SELECT;
      }
    }
    else if (type === 'string')
    {
      if (typeof metadata.format !== 'undefined' && metadata.format === "ipv4")
      {
        return this.CTRL_IPV4;
      }
      else
      {
        return this.CTRL_TEXT;
      }
    }
    else if (type === 'integer' || type === 'number')
    {
      if (subType === 'range')
      {
        return this.CTRL_RANGE;
      }
      else
      {
        return this.CTRL_TEXT;
      }
    }
    else if (type === 'boolean')
    {
      if (subType === 'command')
      {
        return this.CTRL_BUTTON;
      }
      else
      {
        return this.CTRL_CHECKBOX;
      }
    }
    else
    {
      return this.CTRL_UNKNOWN;
    }
  }
  this.name = function (metadata)
  {
    return (typeof metadata.title === 'undefined' ? undefined : metadata.title);
  }
  this.description = function (metadata)
  {
    return (typeof metadata.description === 'undefined' ? undefined : metadata.description);
  }

  this.enumOptions = function (metadata)
  {
    var options = [];
    if (typeof (metadata.enum) !== 'undefined' && typeof (metadata.enum.constructor) !== 'undefined' && metadata.enum.constructor == Array)
    {
      for (var i = 0; i < metadata.enum.length; ++i)
      {
        if (!!metadata.enum[i].label && !!metadata.enum[i].value)
        {
          options.push(metadata.enum[i]);
        }
        else
        {
          options.push(
          {
            label: metadata.enum[i],
            value: metadata.enum[i]
          });
        }
      }
    }
    if (typeof (metadata.enumLabels) !== 'undefined' && typeof (metadata.enumLabels.constructor) !== 'undefined' && metadata.enumLabels.constructor == Array)
    {
      for (var i = 0; i < Math.min(options.length, metadata.enumLabels.length); ++i)
      {
        options[i].label = metadata.enumLabels[i];
      }
    }
    if (typeof (metadata.disabledIndexes) !== 'undefined' && typeof (metadata.disabledIndexes.constructor) !== 'undefined' && metadata.disabledIndexes.constructor == Array)
    {
      for (var i = 0; i < metadata.disabledIndexes.length; ++i)
      {
        if (metadata.disabledIndexes[i] < options.length)
        {
          options[metadata.disabledIndexes[i]].disabled = true;
        }
      }
    }
    for (var i = 0; i < options.length; ++i)
    {
      options[i].selected = false;
    }
    return options;
  }

  this.currentOptionLabel = function (options, model)
  {
    var label = model;
    for (var i = 0; i < options.length; ++i)
    {
      if (options[i].value === model)
      {
        label = options[i].label;
        break;
      }
    }
    return label;
  }

  this.rolloverOption = function (options, model)
  {
    var idx = -1;
    for (var i = 0; i < options.length; ++i)
    {
      if (options[i].value === model)
      {
        idx = i;
        break;
      }
    }
    if (idx >= 0)
    {
      model = options[(idx + 1) % options.length].value;
    }
    return model;
  }

  this.multipleOf = function (metadata)
  {
    var type = (typeof metadata.dataType === 'undefined' ? null : metadata.dataType);
    if (type === 'integer')
    {
      return 1;
    }
    if (typeof metadata.multipleOf !== 'undefined')
    {
      var mult = Number(metadata.multipleOf);
      return (mult <= 0 ? undefined : mult);
    }
    else
    {
      return undefined;
    }
  }

  this.minimum = function (metadata)
  {
    var min = (typeof metadata.minimum === 'undefined' ? undefined : Number(metadata.minimum));
    if (min !== undefined && typeof metadata.exclusiveMinimum !== 'undefined' && metadata.exclusiveMinimum)
    {
      var mult = this.multipleOf(metadata);
      if (mult !== undefined)
      {
        min += mult;
      }
    }
    return min;
  }

  this.maximum = function (metadata)
  {
    var max = (typeof metadata.maximum === 'undefined' ? undefined : Number(metadata.maximum));
    if (max !== undefined && typeof metadata.exclusiveMaximum !== 'undefined' && metadata.exclusiveMaximum)
    {
      var mult = this.multipleOf(metadata);
      if (mult !== undefined)
      {
        max -= mult;
      }
    }
    return max;
  }

  this.minItems = function (metadata)
  {
    return (typeof metadata.minItems === 'undefined' ? undefined : Number(metadata.minItems));
  }

  this.maxItems = function (metadata)
  {
    return (typeof metadata.maxItems === 'undefined' ? undefined : Number(metadata.maxItems));
  }

  this.displayUnit = function (metadata)
  {
    return (typeof metadata.displayUnit === 'undefined' ? (typeof metadata.unit === 'undefined' ? undefined : metadata.unit) : metadata.displayUnit);
  }

  this.decimalShiftLeft = function (metadata)
  {
    return (typeof metadata.decimalShiftLeft === 'undefined' || !this.isInteger(metadata) ? undefined : Number(
      metadata.decimalShiftLeft));
  }

  this.displayCoefficient = function (metadata)
  {
    return (typeof metadata.displayCoefficient === 'undefined' || !this.isNumber(metadata) ? undefined : Number(
      metadata.displayCoefficient));
  }

  this.displayPrecision = function (metadata)
  {
    return (typeof metadata.displayPrecision === 'undefined' || !this.isNumber(metadata) ? undefined : Number(
      metadata.displayPrecision));
  }

  this.displayFormat = function (metadata)
  {
    return (typeof metadata.displayFormat === 'undefined' || !this.isInteger(metadata) ? undefined : metadata.displayFormat);
  }

  this.numericToDisplay = function (model, decimalShiftLeft, displayCoefficient, displayPrecision, isHexFormat)
  {
    if (Number.isFinite(model))
    {
      if (Number.isFinite(displayCoefficient))
      {
        model = Number(__WEBPACK_IMPORTED_MODULE_0_big_js__(model).div(displayCoefficient));
      }
      if (decimalShiftLeft)
      {
        var precision = (decimalShiftLeft > 0 ? decimalShiftLeft : 0);
        model = Number(__WEBPACK_IMPORTED_MODULE_0_big_js__(model).times(__WEBPACK_IMPORTED_MODULE_0_big_js__(10).pow(-decimalShiftLeft, precision), precision));
      }
      if (Number.isFinite(displayPrecision))
      {
        model = Number(__WEBPACK_IMPORTED_MODULE_0_big_js__(model).round(displayPrecision));
      }
      if (isHexFormat && Number.isInteger(model))
      {
        model = (model < 0 ? "-0x" : "0x") + Math.abs(model).toString(16).toUpperCase();
      }
    }
    return model;
  }

  this.displayToNumeric = function (model, decimalShiftLeft, displayCoefficient, toInteger, isHexFormat)
  {
    if (isHexFormat)
    {
      var hexModel = parseInt(model, 16);
      if (!isNaN(hexModel))
      {
        model = hexModel;
      }
    }
    if (Number.isFinite(model))
    {
      if (Number.isFinite(displayCoefficient))
      {
        model = Number(__WEBPACK_IMPORTED_MODULE_0_big_js__(model).times(displayCoefficient));
      }
      if (decimalShiftLeft)
      {
        var precision = (decimalShiftLeft < 0 ? -decimalShiftLeft : 0);
        model = Number(__WEBPACK_IMPORTED_MODULE_0_big_js__(model).times(__WEBPACK_IMPORTED_MODULE_0_big_js__(10).pow(decimalShiftLeft, precision), precision));
      }
      if (toInteger === true)
      {
        model = Number(__WEBPACK_IMPORTED_MODULE_0_big_js__(model).round())
      }
    }
    return model;
  }
}
/* harmony export (immutable) */ __webpack_exports__["a"] = GuiService;



/***/ }),

/***/ "./app/common/live-params/live-params.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var live_params_service_1 = __webpack_require__("./app/common/live-params/live-params.service.ts");
exports.LiveParamsModule = angular_1.module('LiveParamsModule', [])
    .service('liveParamsSrv', live_params_service_1.LiveParamsService);


/***/ }),

/***/ "./app/common/live-params/live-params.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var JsonPointer = __webpack_require__("./node_modules/json-ptr/releases/json-ptr-1.0.1.min.js");
var LiveParamTracking = (function () {
    function LiveParamTracking(ptr) {
        this.lastInteraction = 0;
        this.compiledPtr = JsonPointer.create(ptr);
    }
    return LiveParamTracking;
}());
var LiveParamsUpdater = (function () {
    function LiveParamsUpdater(fmeListSrv, errorSrv, calmDown, reportCallback, configObject, liveParams) {
        var _this = this;
        this.fmeListSrv = fmeListSrv;
        this.errorSrv = errorSrv;
        this.calmDown = calmDown;
        this.reportCallback = reportCallback;
        this.configObject = configObject;
        this.liveParams = {};
        this.liveUpdateQueue = [];
        this.isLiveUpdateScheduled = false;
        this.release = function () {
            _this.fmeListSrv.msgObjectUnsubscribe(_this.onObjectUpdate, [_this.objectHeader]);
            if (_this.scheduledRefreshConfig) {
                clearTimeout(_this.scheduledRefreshConfig);
            }
        };
        this.onObjectUpdate = function (object) {
            if (object.object_ID !== _this.configObject.object_ID) {
                return;
            }
            _this.liveObject = angular_1.copy(object);
            _this.refreshConfig();
        };
        this.onUserInteraction = function (ptr, value) {
            if (!_this.liveParams.hasOwnProperty(ptr)) {
                return;
            }
            var update = {
                ptr: ptr,
                object: angular_1.copy(_this.objectHeader),
            };
            _this.liveParams[ptr].compiledPtr.set(update.object, value, true);
            _this.liveUpdateQueue.push(update);
            if (!_this.isLiveUpdateScheduled) {
                _this.processLiveUpdate();
            }
            _this.liveParams[ptr].lastInteraction = Date.now();
        };
        this.processLiveUpdate = function () {
            if (_this.liveUpdateQueue.length > 0) {
                _this.isLiveUpdateScheduled = true;
                var update = _this.liveUpdateQueue.splice(0, 1)[0];
                _this.fmeListSrv.updatePartialObjectUntilComplete(update.object, _this.processLiveUpdate).then(function () {
                    if (_this.reportCallback) {
                        _this.reportCallback(update.ptr, undefined);
                    }
                }, function (report) {
                    if (_this.reportCallback) {
                        _this.reportCallback(update.ptr, _this.errorSrv.normalize(report));
                    }
                });
            }
            else {
                _this.isLiveUpdateScheduled = false;
            }
        };
        this.refreshConfig = function () {
            if (_this.scheduledRefreshConfig) {
                clearTimeout(_this.scheduledRefreshConfig);
            }
            var now = Date.now();
            var repeatInMS; // TDL: fix any
            Object.keys(_this.liveParams).forEach(function (key) {
                var remainingCalmDown = Math.max(0, _this.calmDown - (now - _this.liveParams[key].lastInteraction));
                if (!remainingCalmDown) {
                    var val = _this.liveParams[key].compiledPtr.get(_this.liveObject);
                    if (val !== undefined) {
                        _this.liveParams[key].compiledPtr.set(_this.configObject, val);
                    }
                }
                else {
                    if (typeof repeatInMS === "undefined" || repeatInMS > remainingCalmDown) {
                        repeatInMS = remainingCalmDown;
                    }
                }
            });
            if (repeatInMS) {
                _this.scheduledRefreshConfig = setTimeout(_this.refreshConfig, repeatInMS);
            }
        };
        this.objectHeader = {
            fme_ip: configObject.fme_ip,
            type: configObject.type,
            object_ID: configObject.object_ID,
            name: configObject.name,
        };
        this.liveObject = angular_1.copy(configObject);
        liveParams.forEach(function (liveParam) {
            _this.liveParams[liveParam] = new LiveParamTracking(liveParam);
        });
        this.fmeListSrv.msgObjectSubscribe(this.onObjectUpdate, [this.objectHeader]);
    }
    return LiveParamsUpdater;
}());
var LiveParamsService = (function () {
    function LiveParamsService(fmeListSrv, metadataSrv, errorSrv) {
        var _this = this;
        this.fmeListSrv = fmeListSrv;
        this.metadataSrv = metadataSrv;
        this.errorSrv = errorSrv;
        this.isLive = function (schema) {
            return (typeof schema.live === 'undefined' || schema.live == 'false' || schema.live == 'False' || schema.live == 'FALSE' ? false : schema.live);
        };
        this.liveParamsRecursive = function (schema, ptr) {
            var liveParams = [];
            var metadata = _this.metadataSrv.metadataFor(schema, ptr);
            if (_this.metadataSrv.isObject(metadata)) {
                _this.metadataSrv.getProperties(metadata).forEach(function (property) {
                    _this.liveParamsRecursive(metadata, "/" + property).forEach(function (liveParam) {
                        liveParams.push(ptr + liveParam);
                    });
                });
            }
            else if (_this.metadataSrv.isArray(metadata)) {
                var ptrFirstItem = "/0";
                var liveParamsPerItem = _this.liveParamsRecursive(metadata, ptrFirstItem);
                liveParamsPerItem.forEach(function (liveParam) {
                    for (var i = 0; i < _this.metadataSrv.numItems(metadata); ++i) {
                        liveParams.push(ptr + "/" + i + liveParam.substring(ptrFirstItem.length));
                    }
                });
            }
            else if (_this.isLive(metadata)) {
                liveParams.push(ptr);
            }
            return liveParams;
        };
        this.liveParams = function (schema) {
            return _this.liveParamsRecursive(schema, "");
        };
        this.liveParamsUpdater = function (object, metadata, reportCallback, calmDown) {
            if (typeof calmDown === "undefined") {
                // 1 sec of calming by default
                calmDown = 1000;
            }
            return new LiveParamsUpdater(_this.fmeListSrv, _this.errorSrv, calmDown, reportCallback, object, _this.liveParams(metadata));
        };
    }
    return LiveParamsService;
}());
exports.LiveParamsService = LiveParamsService;


/***/ }),

/***/ "./app/common/logs/logs.factory.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
exports.logsFactory = function () {
    var srv = {
        logs: {},
        subscribers: [],
    };
    srv.update = function (logsStateMsg) {
        angular_1.merge(srv.logs, logsStateMsg.logs);
        srv.subscribers.forEach(function (callback) { return callback(); });
    };
    srv.subscribe = function (callback) {
        if (srv.subscribers.indexOf(callback) < 0) {
            srv.subscribers.push(callback);
        }
    };
    srv.unsubscribe = function (callback) {
        var idx = srv.subscribers.indexOf(callback);
        if (idx >= 0) {
            srv.subscribers.splice(idx);
        }
    };
    return srv;
};


/***/ }),

/***/ "./app/common/logs/logs.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var logs_factory_1 = __webpack_require__("./app/common/logs/logs.factory.ts");
exports.LogsModule = angular_1.module("LogsModule", [])
    .factory("logsSrv", logs_factory_1.logsFactory);


/***/ }),

/***/ "./app/common/metadata/metadata.module.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular__ = __webpack_require__("./node_modules/angular/index.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_angular__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__metadata_service__ = __webpack_require__("./app/common/metadata/metadata.service.js");




const MetadataModule = Object(__WEBPACK_IMPORTED_MODULE_0_angular__["module"])('MetadataModule', [])
  .service('metadataSrv', __WEBPACK_IMPORTED_MODULE_1__metadata_service__["a" /* MetadataService */])
/* harmony export (immutable) */ __webpack_exports__["MetadataModule"] = MetadataModule;



/***/ }),

/***/ "./app/common/metadata/metadata.service.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
const MetadataService = function ()
{
  this.METADATA_OBJECT_TYPE = "MetaData";

  this.metadataFor = function (schema, ptr)
  {
    if (ptr === "")
    {
      return schema;
    }
    if (ptr.charAt(0) !== '/')
    {
      return undefined;
    }
    var property = ptr.substring(1);
    var nextSlash = ptr.indexOf('/', 1);
    if (nextSlash >= 0)
    {
      property = ptr.substring(1, nextSlash);
    }

    if (!schema)
    {
      console.log("Malformed metadata, no schema for " + ptr);
      return undefined;
    }

    if (schema.dataType === 'array')
    {
      return this.metadataFor(schema.items, ptr.substring(property.length + 1));
    }
    else
    {
      if (!schema.properties)
      {
        console.log("Malformed metadata, no properties description for " + property);
      }
      var decodedProperty = property.split('~1').join('/').split('~0').join('~');
      return this.metadataFor(schema.properties[decodedProperty], ptr.substring(property.length + 1));
    }
  }

  this.isArray = function (schema)
  {
    return (typeof schema.dataType !== 'undefined' && schema.dataType === 'array');
  }

  this.numItems = function (schema)
  {
    return (typeof schema.maxItems !== 'undefined' ? Number(schema.maxItems) : undefined);
  }

  this.isObject = function (schema)
  {
    return (typeof schema.dataType !== 'undefined' && schema.dataType === 'object');
  }

  this.metadataForArrayItems = function (schema)
  {
    if (this.isArray(schema))
    {
      return schema['items'];
    }
    else
    {
      return undefined;
    }
  }

  this.getProperties = function (schema)
  {
    if (!this.isObject(schema))
    {
      return undefined;
    }
    return Object.keys(schema.properties);
  }
}
/* harmony export (immutable) */ __webpack_exports__["a"] = MetadataService;



/***/ }),

/***/ "./app/common/modals/add-external-device/add-external-device-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var add_external_device_modal_window_controller_1 = __webpack_require__("./app/common/modals/add-external-device/add-external-device-modal-window.controller.ts");
var templateUrl = __webpack_require__("./app/common/modals/add-external-device/add-external-device-modal-window.template.html");
exports.createAddExternalDeviceModalWindowComponent = function (library, passedProps) {
    return library.open({
        animation: true,
        backdrop: "static",
        size: 'md',
        templateUrl: templateUrl,
        controller: add_external_device_modal_window_controller_1.AddExternalDeviceModalWindowController,
        // controllerAs: "$ctrl", // not required here. attached to scope
        resolve: {
            receivedProps: passedProps,
        },
    });
};


/***/ }),

/***/ "./app/common/modals/add-external-device/add-external-device-modal-window.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var AddExternalDeviceModalWindowController = (function () {
    function AddExternalDeviceModalWindowController($scope, $uibModalInstance, receivedProps) {
        $scope.deviceType = receivedProps.type;
        $scope.meta = receivedProps.meta;
        $scope.properties = $scope.meta.items.properties;
        $scope.validationFunc = receivedProps.validationFunc;
        $scope.showFieldFunc = receivedProps.showFieldFunc;
        $scope.cfg = receivedProps.cfg;
        $scope.data = {};
        function initialize() {
            //console.log($scope.deviceType, $scope.meta, $scope.properties);
            $scope.devices = receivedProps.devices ? angular_1.copy(receivedProps.devices) : [];
            if (receivedProps.data) {
                $scope.data = angular_1.copy(receivedProps.data);
                Object.keys($scope.properties).forEach(function (key) {
                    if ($scope.data[key] === undefined && typeof $scope.properties[key].default !== undefined) {
                        $scope.data[key] = $scope.properties[key].default;
                    }
                });
            }
            else {
                $scope.data = {};
                Object.keys($scope.properties).forEach(function (key) {
                    if (typeof $scope.properties[key].default !== undefined) {
                        $scope.data[key] = $scope.properties[key].default;
                    }
                });
                //console.log($scope.data);
            }
        }
        //function to rename FME
        $scope.submitChanges = function () {
            var data = $scope.data;
            if ($scope.validationFunc) {
                var result = $scope.validationFunc($scope.data, $scope.devices, $scope.cfg);
                if (result !== undefined) {
                    alert(result);
                    return;
                }
            }
            $uibModalInstance.close(data);
        };
        $scope.closeModal = function () {
            $uibModalInstance.close(false);
        };
        $scope.showField = function (property) {
            if (property === "idx" || property === "delete") {
                return false;
            }
            else if ($scope.showFieldFunc) {
                return $scope.showFieldFunc(property, $scope.data);
            }
            else {
                return true;
            }
        };
        initialize();
    }
    return AddExternalDeviceModalWindowController;
}());
exports.AddExternalDeviceModalWindowController = AddExternalDeviceModalWindowController;


/***/ }),

/***/ "./app/common/modals/add-external-device/add-external-device-modal-window.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/modals/add-external-device/add-external-device-modal-window.template.html?0403ccaa58f4df89a4e8fe7e8de01b76";

/***/ }),

/***/ "./app/common/modals/confirm-modal-window/confirm-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var confirm_modal_window_controller_1 = __webpack_require__("./app/common/modals/confirm-modal-window/confirm-modal-window.controller.ts");
var templateUrl = __webpack_require__("./app/common/modals/confirm-modal-window/confirm-modal-window.template.html");
exports.createConfirmModalWindowComponent = function (library, passedProps) {
    return library.open({
        animation: true,
        backdrop: 'static',
        size: 'md',
        templateUrl: templateUrl,
        controller: confirm_modal_window_controller_1.ConfirmModalWindowController,
        controllerAs: '$ctrl',
        resolve: {
            receivedProps: passedProps
        }
    });
};


/***/ }),

/***/ "./app/common/modals/confirm-modal-window/confirm-modal-window.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var ConfirmModalWindowController = (function () {
    function ConfirmModalWindowController($uibModalInstance, receivedProps) {
        this.config = receivedProps;
        this.onClick = function (button) {
            $uibModalInstance.close();
            if (angular_1.isDefined(button) && angular_1.isDefined(button.callback)) {
                button.callback(button.label);
            }
        };
    }
    return ConfirmModalWindowController;
}());
exports.ConfirmModalWindowController = ConfirmModalWindowController;


/***/ }),

/***/ "./app/common/modals/confirm-modal-window/confirm-modal-window.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/modals/confirm-modal-window/confirm-modal-window.template.html?820cdf76c6b69c61fedb491c2f019049";

/***/ }),

/***/ "./app/common/modals/info-modal-window/info-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var info_modal_window_controller_1 = __webpack_require__("./app/common/modals/info-modal-window/info-modal-window.controller.ts");
var templateUrl = __webpack_require__("./app/common/modals/info-modal-window/info-modal-window.template.html");
exports.createInfoModalWindowComponent = function (library, passedProps) {
    return library.open({
        animation: true,
        backdrop: "static",
        // size:'wide',
        templateUrl: templateUrl,
        controller: info_modal_window_controller_1.InfoModalWindowController,
        controllerAs: "$ctrl",
        resolve: {
            receivedProps: passedProps,
        },
    });
};


/***/ }),

/***/ "./app/common/modals/info-modal-window/info-modal-window.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var InfoModalWindowController = (function () {
    function InfoModalWindowController($uibModalInstance, receivedProps) {
        this.config = receivedProps;
        this.closeInfoModalWindow = function () {
            $uibModalInstance.close();
        };
    }
    return InfoModalWindowController;
}());
exports.InfoModalWindowController = InfoModalWindowController;


/***/ }),

/***/ "./app/common/modals/info-modal-window/info-modal-window.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/modals/info-modal-window/info-modal-window.template.html?d1456352a57778379d4ff8837892a51f";

/***/ }),

/***/ "./app/common/modals/modals.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var modals_service_1 = __webpack_require__("./app/common/modals/modals.service.ts");
var ui_modals_service_1 = __webpack_require__("./app/common/modals/ui-modals.service.ts");
exports.ModalsModule = angular_1.module("ModalsModule", [])
    .factory("modalsSrv", modals_service_1.ModalsService)
    .service("uiModalsSrv", ui_modals_service_1.UiModalsService);


/***/ }),

/***/ "./app/common/modals/modals.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
// add hash suffix to bust cache
var program_modal_window_component_1 = __webpack_require__("./app/view-menu/processor/program/program-modal-window/program-modal-window.component.ts");
var processor_modal_window_component_1 = __webpack_require__("./app/view-menu/processor/processor-modal-window/processor-modal-window.component.ts");
exports.ModalsService = function ($uibModal, $uibModalStack) {
    var srv = {};
    var modalOpen = false;
    srv.openSnpProgramConfigModal = function (data) {
        modalOpen = true;
        return program_modal_window_component_1.createProgramModalWindowComponent($uibModal, data);
    };
    srv.openSnpProcessorConfigModal = function (data) {
        modalOpen = true;
        return processor_modal_window_component_1.createProcessorModalWindowComponent($uibModal, data);
    };
    srv.isOpen = function () {
        return modalOpen;
    };
    srv.setOpen = function (openState) {
        modalOpen = (openState === true);
    };
    srv.closeDialog = function () {
        modalOpen = false;
    };
    srv.dismissAllModals = function () {
        $uibModalStack.dismissAll();
        modalOpen = false;
    };
    return srv;
};


/***/ }),

/***/ "./app/common/modals/ui-modals.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var confirm_modal_window_component_1 = __webpack_require__("./app/common/modals/confirm-modal-window/confirm-modal-window.component.ts");
var info_modal_window_component_1 = __webpack_require__("./app/common/modals/info-modal-window/info-modal-window.component.ts");
var wait_modal_window_component_1 = __webpack_require__("./app/common/modals/wait-modal-window/wait-modal-window.component.ts");
var add_external_device_modal_window_component_1 = __webpack_require__("./app/common/modals/add-external-device/add-external-device-modal-window.component.ts");
exports.UiModalsService = function ($uibModal) {
    this.openConfirmModal = function (passedProps) {
        confirm_modal_window_component_1.createConfirmModalWindowComponent($uibModal, passedProps);
    };
    this.openInfoModal = function (passedProps) {
        info_modal_window_component_1.createInfoModalWindowComponent($uibModal, passedProps);
    };
    this.openWaitModal = function (passedProps) {
        wait_modal_window_component_1.createWaitModalWindowComponent($uibModal, passedProps);
    };
    this.openAddExternalDeviceModal = function (passedProps) {
        return add_external_device_modal_window_component_1.createAddExternalDeviceModalWindowComponent($uibModal, passedProps);
    };
};


/***/ }),

/***/ "./app/common/modals/wait-modal-window/wait-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var wait_modal_window_controller_1 = __webpack_require__("./app/common/modals/wait-modal-window/wait-modal-window.controller.ts");
var templateUrl = __webpack_require__("./app/common/modals/wait-modal-window/wait-modal-window.template.html");
exports.createWaitModalWindowComponent = function (library, passedProps) {
    return library.open({
        animation: true,
        backdrop: 'static',
        size: 'md',
        templateUrl: templateUrl,
        controller: wait_modal_window_controller_1.WaitModalWindowController,
        controllerAs: '$ctrl',
        resolve: {
            receivedProps: passedProps
        }
    });
};


/***/ }),

/***/ "./app/common/modals/wait-modal-window/wait-modal-window.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var WaitModalWindowController = (function () {
    function WaitModalWindowController($uibModalInstance, receivedProps) {
        this.config = receivedProps;
        this.onClick = function (button) {
            $uibModalInstance.close();
            if (angular_1.isDefined(button) && angular_1.isDefined(button.callback)) {
                button.callback(button.label);
            }
        };
    }
    return WaitModalWindowController;
}());
exports.WaitModalWindowController = WaitModalWindowController;


/***/ }),

/***/ "./app/common/modals/wait-modal-window/wait-modal-window.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/modals/wait-modal-window/wait-modal-window.template.html?486a22e613ff328afaad764bc351fb3e";

/***/ }),

/***/ "./app/common/request-status/flx-show-all-requests/flx-show-all-requests.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var templateUrl = __webpack_require__("./app/common/request-status/flx-show-all-requests/flx-show-all-requests.template.html");
exports.FlxShowAllRequestsDirective = function (requestStatusSrv) {
    return {
        scope: {},
        restrict: "E",
        templateUrl: templateUrl,
        controller: [
            "$scope",
            "requestStatusSrv",
            function ($scope, requestStatusSrv) {
                $scope.resultList = requestStatusSrv.getRequestList();
            },
        ],
    };
};


/***/ }),

/***/ "./app/common/request-status/flx-show-all-requests/flx-show-all-requests.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/request-status/flx-show-all-requests/flx-show-all-requests.template.html?01b25bd118fbdfcedb8e43cf8c42a3ca";

/***/ }),

/***/ "./app/common/request-status/flx-show-all-requests/flx-show-request/flx-show-request.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {
Object.defineProperty(exports, "__esModule", { value: true });
var templateUrl = __webpack_require__("./app/common/request-status/flx-show-all-requests/flx-show-request/flx-show-request.template.html");
exports.FlxShowRequestDirective = function (requestStatusSrv) {
    return {
        scope: {
            result: '=',
        },
        restrict: 'E',
        templateUrl: templateUrl,
        controller: ['$scope', '$location', '$element', '$attrs', function ($scope, $location, $element, $attrs) {
                $scope.display = true;
                $scope.filterIp = function (ip) { return ip === "127.0.0.1" ? $location.$$host : ip; };
                setBottom();
                function setBottom() {
                    if ($('#activeAlarmPage').css('display') == 'block') {
                        var alarmHeight = $('#activeAlarmPage').height();
                        $('#alertStack').css("bottom", alarmHeight);
                    }
                    else {
                        $('#alertStack').css("bottom", 30);
                    }
                }
                ;
                $scope.close = function () {
                    $scope.display = false;
                    requestStatusSrv.rmvRequest($scope.result);
                };
            }],
    };
};

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__("./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./app/common/request-status/flx-show-all-requests/flx-show-request/flx-show-request.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/common/request-status/flx-show-all-requests/flx-show-request/flx-show-request.template.html?bfeea872acca227e62628d3db157aca2";

/***/ }),

/***/ "./app/common/request-status/request-status.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var request_status_service_1 = __webpack_require__("./app/common/request-status/request-status.service.ts");
var flx_show_all_requests_directive_1 = __webpack_require__("./app/common/request-status/flx-show-all-requests/flx-show-all-requests.directive.ts");
var flx_show_request_directive_1 = __webpack_require__("./app/common/request-status/flx-show-all-requests/flx-show-request/flx-show-request.directive.ts");
exports.RequestStatusModule = angular_1.module("RequestStatusModule", [])
    .factory("requestStatusSrv", request_status_service_1.RequestStatusService)
    .directive("flxShowAllRequests", flx_show_all_requests_directive_1.FlxShowAllRequestsDirective)
    .directive("flxShowRequest", flx_show_request_directive_1.FlxShowRequestDirective);


/***/ }),

/***/ "./app/common/request-status/request-status.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
exports.RequestStatusService = function ($http, $interval, fmmStateSrv, commonUtils, $timeout, REST_ENDPOINT) {
    var myFactory = {};
    var resultList = [];
    var websocketRequests = {};
    var selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
    function getReq() {
        //get related result list from db
        for (var req in resultList) {
            var url = REST_ENDPOINT.URI + "presets/getReqResult";
            if (resultList[req].result == '') {
                $http({
                    method: 'POST',
                    url: url,
                    data: resultList[req],
                })
                    .success(function (response) {
                    if (response.length > 0) {
                        //use the last result entry in the array that's newer than the initial time
                        for (var req in resultList) {
                            if (resultList[req].result !== "FAIL" &&
                                resultList[req].result !== "SUCCESS") {
                                if (resultList[req].msg_type == "AddFme") {
                                    if ((response[response.length - 1].fme_ip_address == resultList[req].fme_ip || (selfHost && response[response.length - 1].fme_ip_address === "127.0.0.1")) &&
                                        response[response.length - 1].msg_type == resultList[req].msg_type) {
                                        var responseTime = Date.parse(response[response.length - 1].time_stamp);
                                        var resultTime = Date.parse(resultList[req].time_stamp);
                                        // make sure both times are of the same type
                                        responseTime = responseTime.valueOf();
                                        resultTime = resultTime.valueOf();
                                        if (responseTime > (resultTime - 5000)) {
                                            //the 5s offset accounts for the polling window for SMM time
                                            angular_1.merge(resultList[req], response[response.length - 1]);
                                            resultList[req].time_stamp = responseTime; //properly mark response time for UTC
                                        }
                                    }
                                }
                                else if (resultList[req].msg_type.substr(0, 8) !== "Database") {
                                    if ((response[response.length - 1].fme_ip_address == resultList[req].fme_ip || (selfHost && response[response.length - 1].fme_ip_address === "127.0.0.1")) &&
                                        response[response.length - 1].obj_name == resultList[req].name &&
                                        response[response.length - 1].msg_type == resultList[req].msg_type) {
                                        var responseTime = Date.parse(response[response.length - 1].time_stamp);
                                        var resultTime = Date.parse(resultList[req].time_stamp);
                                        // make sure both times are of the same type
                                        responseTime = responseTime.valueOf();
                                        resultTime = resultTime.valueOf();
                                        if (responseTime > (resultTime - 5000)) {
                                            //the 5s offset accounts for the polling window for SMM time
                                            angular_1.merge(resultList[req], response[response.length - 1]);
                                            resultList[req].time_stamp = responseTime; //properly mark response time for UTC
                                        }
                                    }
                                }
                                else {
                                    if (response[response.length - 1].obj_name == resultList[req].name &&
                                        response[response.length - 1].msg_type == resultList[req].msg_type &&
                                        response[response.length - 1].session_id == resultList[req].session_id) {
                                        var responseTime = Date.parse(response[response.length - 1].time_stamp);
                                        angular_1.merge(resultList[req], response[response.length - 1]);
                                        resultList[req].time_stamp = responseTime;
                                    }
                                }
                            }
                        }
                    }
                })
                    .error(function (error) {
                    console.log("getResultList error:" + error);
                });
            }
        }
    }
    function clean() {
        //remove success entries older than 3mins
        var currTime;
        if (resultList.length > 0) {
            getReq();
            currTime = Number(new Date()) - fmmStateSrv.getDeltaTime(); //convert browser time to server time
        }
        for (var i = 0; i < resultList.length; i++) {
            var element = resultList[i];
            if (!!element.time_stamp) {
                // var resultTime = currTime - new Date(element.time_stamp);
                var resultTime = currTime - (element.time_stamp);
                if ((element.result == 'SUCCESS') && ((resultTime) > 10000)) {
                    //remove any success msg older than 10s
                    resultList.splice(i, 1);
                }
                else if ((element.result == '') && ((resultTime) > 180000)) {
                    if (element.msg_type.indexOf("LoadPreset") < 0) {
                        //mark processing entries fail after 3mins
                        element.result = 'FAIL';
                        element.reason = 'Timed out after 3mins';
                    }
                }
            }
        }
    }
    myFactory.getRequestList = function () {
        return resultList;
    };
    myFactory.addWebsocketRequest = function (successCallback, errorCallback, timeout) {
        var uuid = commonUtils.generateUUID();
        websocketRequests[uuid] = {
            onSuccess: successCallback,
            onError: errorCallback,
            timeout: $timeout(function () {
                delete websocketRequests[uuid];
                if (errorCallback) {
                    errorCallback("Request timed out");
                }
            }, timeout),
        };
        return uuid;
    };
    myFactory.addRequest = function (msg_type, obj) {
        var sessionID = (obj !== null && typeof obj.id !== 'undefined') ? obj.id : "";
        var fme_ip = (obj !== null && typeof obj.fme_ip !== 'undefined') ? obj.fme_ip : "";
        var objType = (obj !== null && typeof obj.type !== 'undefined') ? obj.type : "";
        var objName = (obj !== null && typeof obj.name !== 'undefined') ? obj.name : "";
        var time_stamp = Number(new Date()) - fmmStateSrv.getDeltaTime(); //convert browser time to server time
        //add request into result list
        var newReq = {
            "fme_ip": fme_ip,
            "msg_type": msg_type,
            "type": objType,
            "name": objName,
            "result": '',
            "reason": '',
            "session_id": sessionID,
            "time_stamp": new Date(time_stamp).toString()
        };
        resultList.push(newReq);
    };
    myFactory.successRequest = function (obj) {
        for (var req in resultList) {
            if (obj.fme_ip == resultList[req].fme_ip &&
                obj.name == resultList[req].name &&
                obj.msg_type == resultList[req].msg_type &&
                resultList[req].result.length == 0) {
                resultList[req].result = 'SUCCESS';
            }
        }
    };
    myFactory.failedRequest = function (obj, reason) {
        // resultList.find(function(req) {
        //     if (obj.fme_ip == req.fme_ip &&
        //         obj.name == req.name &&
        //         obj.msg_type == req.msg_type &&
        //         req.result.length == 0) {
        //         req.result = 'FAIL';
        //         //default reason to server connection failure, unless reason is specified
        //         req.reason = !!reason ? reason : 'Could not send request to server, please try again.';
        //     }
        // });
        for (var i = 0; i < resultList.length; i++) {
            var element = resultList[i];
            var isObjMatched = obj.fme_ip == element.fme_ip && obj.name == element.name && obj.msg_type == element.msg_type;
            var isResultEmpty = element.result.length == 0;
            if (isObjMatched && isResultEmpty) {
                element.result = 'FAIL';
                //default reason to server connection failure, unless reason is specified
                element.reason = !!reason ? reason : 'Could not send request to server, please try again.';
            }
        }
    };
    myFactory.addFaildRequest = function (obj, reason) {
        var time_stamp = Number(new Date()) - fmmStateSrv.getDeltaTime();
        var newReq = {
            "fme_ip": obj.fme_ip,
            "msg_type": obj.msg_type,
            "name": obj.name,
            "type": "",
            "result": 'FAIL',
            "reason": !!reason ? reason : 'Could not send request to server, please try again.',
            "session_id": "",
            "time_stamp": new Date(time_stamp).toString()
        };
        resultList.push(newReq);
    };
    myFactory.rmvRequest = function (obj) {
        // for (var req in resultList) {
        //     if (obj.fme_ip == resultList[req].fme_ip &&
        //         obj.name == resultList[req].name &&
        //         obj.msg_type == resultList[req].msg_type &&
        //         obj.time_stamp == resultList[req].time_stamp) {
        //         resultList.splice(req, 1);
        //         break;
        //     }
        // }
        for (var i = 0; i < resultList.length; i++) {
            var element = resultList[i];
            if (obj.fme_ip == element.fme_ip &&
                obj.name == element.name &&
                obj.msg_type == element.msg_type &&
                obj.time_stamp == element.time_stamp) {
                resultList.splice(i, 1); // changed for typescript
                break;
            }
        }
    };
    myFactory.onWebsocketResponse = function (response) {
        var request = websocketRequests[response.requestUuid];
        if (request) {
            $timeout.cancel(request.timeout);
            delete websocketRequests[response.requestUuid];
            if (response.msgType === 'successResponse' && request.onSuccess) {
                request.onSuccess();
            }
            else if (response.msgType === 'errorResponse' && request.onError) {
                try {
                    response.error = JSON.parse(response.error);
                }
                catch (e) {
                    // ignore
                }
                request.onError(response.error);
            }
        }
    };
    $interval(function () {
        //clean list every 5s
        clean();
    }, 5000);
    return myFactory;
};


/***/ }),

/***/ "./app/config-menu/aap/aap-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var aap_modal_window_controller_1 = __webpack_require__("./app/config-menu/aap/aap-modal-window.controller.ts");
var templateUrl = __webpack_require__("./app/config-menu/aap/aap-modal-window.template.html");
exports.createAapModalWindowComponent = function (library) {
    return library.open({
        animation: true,
        backdrop: "static",
        size: "wide",
        templateUrl: templateUrl,
        controller: aap_modal_window_controller_1.AapModalWindowController,
    });
};


/***/ }),

/***/ "./app/config-menu/aap/aap-modal-window.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var common_1 = __webpack_require__("./app/view-menu/common.js");
var base_tab_controller_1 = __webpack_require__("./app/common/base-tab.controller.ts");
var AapModalWindowController = (function (_super) {
    __extends(AapModalWindowController, _super);
    function AapModalWindowController($scope, $uibModalInstance, fmeListSrv, snpListSrv, configMenuModalsSrv, commonUtils) {
        var _this = _super.call(this, $scope) || this;
        _this.$scope = $scope;
        _this.$uibModalInstance = $uibModalInstance;
        _this.fmeListSrv = fmeListSrv;
        _this.snpListSrv = snpListSrv;
        _this.configMenuModalsSrv = configMenuModalsSrv;
        _this.commonUtils = commonUtils;
        _this.newSession = {
            enable: false,
            delete: false,
            algorithm: "0",
            DSP: "0",
            program: "0",
            session: "0",
        };
        _this.type = {
            FRONTEND: "dropdown options",
            BACKEND: "native code"
        };
        // angular lifecycle methods below
        _this.$onInit = function () {
            // placeholder for calling needed init method
            _this.$scope.selfHost =
                _this.commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
            _this.$scope.sessionList = [];
            _this.$scope.fmeIp = _this.fmeListSrv.getElementIp();
            _this.$scope.fmeList = _this.loadFmeList();
            _this.$scope.fmeList = _this.formatFmeList(_this.$scope.fmeList);
            _this.$scope.onElementIpDropdownChange = function () {
                _this.loadData();
                // unsubscribe from previous status worker
                if (_this.statusWorker !== undefined) {
                    _this.statusWorker.unsubscribe();
                }
                // subscribe to new status worker
                _this.statusWorker = _this.statusWorkerFactory();
                _this.statusWorker.subscribe();
            };
            _this.$scope.reports = {};
            _this.statusWorker = _this.statusWorkerFactory();
            _this.statusWorker.subscribe();
            _this.loadData();
            _this.initEventHandlers();
            _this.initApplyButtons();
        };
        _this.$doCheck = function () { };
        _this.$onDestroy = function () {
            _this.statusWorker.unsubscribe();
        };
        _this.loadFmeList = function () {
            var loadedFmeList = _this.fmeListSrv.getAllElements();
            return loadedFmeList;
        };
        _this.formatFmeList = function (fmeList) {
            var formattedFmeList = fmeList.filter(formatFmeLabel);
            function formatFmeLabel(fme) {
                fme.label = "";
                generateLabel(fme);
                return fme;
            }
            return formattedFmeList;
            function generateLabel(fme) {
                var isNotConnected = fme.state !== "connected";
                fme.label = "" + formatNameAndIp(fme);
                if (isNotConnected) {
                    fme.label += " " + formatState(fme, isNotConnected);
                }
            }
            function formatNameAndIp(fme) {
                var wasNameAdded = fme.name !== "";
                var result = "";
                if (wasNameAdded) {
                    result = fme.name + " (" + fme.ip + ")";
                }
                else {
                    result = "" + fme.ip;
                }
                return result;
            }
            function formatState(fme, isNotConnected) {
                var result = "";
                if (isNotConnected) {
                    result = "[" + fme.state + "]";
                }
                else {
                    result = "";
                }
                return result;
            }
        };
        return _this;
    }
    // inherited base methods below
    AapModalWindowController.prototype.loadData = function () {
        var _this = this;
        var requirePropObjs = [
            {
                type: common_1.SNP_OBJTYPE_SYSTEM,
                object_ID: common_1.SNP_OBJTYPE_SYSTEM,
                getStatus: true,
            },
        ];
        this.snpListSrv.getObjects(this.$scope.fmeIp, requirePropObjs).then(function (response) {
            _this.initializeDropdowns(response[common_1.SNP_OBJTYPE_SYSTEM].configMetadata.properties
                .AAP_Algorithms.items.properties);
            var validateProp = _this.snpListSrv.initValidator(response);
            _this.$scope.DSPutilization = validateProp(common_1.propType.STATUS, common_1.SNP_OBJTYPE_SYSTEM, "DSPutilization");
            _this.$scope.AAP_License_Status = validateProp(common_1.propType.STATUS, common_1.SNP_OBJTYPE_SYSTEM, "AAP_License_Status");
            var AAP_Algorithms = validateProp(common_1.propType.CONFIG, common_1.SNP_OBJTYPE_SYSTEM, "AAP_Algorithms");
            AAP_Algorithms = _this.castFor(_this.type.FRONTEND, AAP_Algorithms);
            if (AAP_Algorithms) {
                _this.$scope.sessionList = common_1.sortAapSessionArray(AAP_Algorithms);
            }
        }, function (error) {
            console.error.apply(console, [error].concat(requirePropObjs));
        });
    };
    AapModalWindowController.prototype.initControllerHandlers = function () {
        // placeholder for controller callbacks
    };
    AapModalWindowController.prototype.initApplyButtons = function () {
        var _this = this;
        this.$scope.buttons.applyConfig = function () {
            var aapCfg = {
                AAP_Algorithms: _this.castFor(_this.type.BACKEND, _this.$scope.sessionList),
                fme_ip: _this.$scope.fmeIp,
                name: common_1.SNP_OBJTYPE_SYSTEM,
                object_ID: common_1.SNP_OBJTYPE_SYSTEM,
                type: common_1.SNP_OBJTYPE_SYSTEM,
            };
            _this.snpListSrv.applyPartialUpdate(aapCfg, function (report) {
                var isNoErrorsInRequest = typeof report === "undefined";
                if (isNoErrorsInRequest) {
                    _this.loadData();
                    _this.$scope.floorPlanForm.$setPristine();
                }
                else {
                    _this.$scope.reports.system = report;
                    var msgKey = Object.keys(report.msgs)[0];
                    alert(report.msgs[msgKey][0].msg);
                }
            });
        };
    };
    AapModalWindowController.prototype.initEventHandlers = function () {
        var _this = this;
        // placeholder for template callbacks for clicks, validation, change, etc
        var addSessionHandler = function () {
            _this.newSession.algorithm = _this.newSession.algorithm.toString();
            _this.newSession.DSP = _this.newSession.DSP.toString();
            _this.newSession.program = _this.newSession.program.toString();
            _this.newSession.session = "0";
            var modalWindowData = {
                newSession: _this.newSession,
                algorithmDropdownOptions: _this.$scope.algorithmList,
                dspDropdownOptions: _this.$scope.dspList,
                programDropdownOptions: _this.$scope.programList,
            };
            _this.configMenuModalsSrv.openAddDSPSessionModal(modalWindowData).result.then(function (modalWindowResponse) {
                if (modalWindowResponse !== false) {
                    _this.$scope.sessionList.push(modalWindowResponse);
                    _this.$scope.buttons.applyConfig();
                    // wait 5 seconds for the Zenium side to update the configuration jsons before proceeding
                    setTimeout(function () {
                        _this.handleAudioProcDataFromSNP(modalWindowResponse.program);
                    }, 5000);
                }
            });
        };
        var removeSessionHandler = function (elemIdx) {
            var aapCfg = {
                AAP_Algorithms: [
                    {
                        session: elemIdx,
                        delete: true
                    }
                ],
                fme_ip: _this.$scope.fmeIp,
                name: common_1.SNP_OBJTYPE_SYSTEM,
                object_ID: common_1.SNP_OBJTYPE_SYSTEM,
                type: common_1.SNP_OBJTYPE_SYSTEM,
            };
            _this.snpListSrv.applyPartialUpdate(aapCfg, function (report) {
                var isNoErrorsInRequest = typeof report === "undefined";
                if (isNoErrorsInRequest) {
                    _this.loadData();
                }
                else {
                    _this.$scope.reports.system = report;
                }
            });
        };
        var closeModalHandler = function () {
            _this.$uibModalInstance.close();
        };
        this.$scope.buttons = {
            addSession: addSessionHandler,
            removeSession: removeSessionHandler,
            closeModal: closeModalHandler
        };
    };
    AapModalWindowController.prototype.initVisibilityHandlers = function () {
        // placeholder for template callbacks for ng-if, ng-show, etc
        // hint for passing method to component scope
        // this.$scope.___ = () => {}
    };
    // own tab methods below
    // placeholder
    AapModalWindowController.prototype.statusWorkerFactory = function () {
        var _this = this;
        var statusesToSubscribe = [
            {
                fme_ip: this.$scope.fmeIp,
                type: common_1.SNP_OBJTYPE_SYSTEM,
                object_ID: common_1.SNP_OBJTYPE_SYSTEM,
            },
        ];
        var updateSessionStatuses = function (receivedStatusList) {
            _this.$scope.DSPsessionStatus = receivedStatusList;
            for (var _i = 0, _a = _this.$scope.DSPsessionStatus; _i < _a.length; _i++) {
                var DSPStatus = _a[_i];
                for (var _b = 0, _c = _this.$scope.sessionList; _b < _c.length; _b++) {
                    var session = _c[_b];
                    if (session.session === DSPStatus.session) {
                        session.utilization = DSPStatus.utilization;
                        session.credits = DSPStatus.credits;
                    }
                }
            }
        };
        var updateDSPutilization = function (receivedDSPutilization) {
            _this.$scope.DSPutilization = receivedDSPutilization;
        };
        var updateAAPlicenseStatus = function (receivedLicenseStatus) {
            _this.$scope.AAP_License_Status = receivedLicenseStatus;
        };
        var onReceiveStatusHandler = function (status) {
            if (status.object_ID === common_1.SNP_OBJTYPE_SYSTEM) {
                updateSessionStatuses(status.DSPsessionStatus);
                updateDSPutilization(status.DSPutilization);
                updateAAPlicenseStatus(status.AAP_License_Status);
                var isSessionQuantityChangedOnBackend = status.DSPsessionStatus.length !== _this.$scope.sessionList.length;
                if (isSessionQuantityChangedOnBackend) {
                    _this.loadData();
                }
            }
        };
        return {
            subscribe: function () {
                _this.fmeListSrv.msgStatusSubscribe(onReceiveStatusHandler, statusesToSubscribe);
            },
            unsubscribe: function () {
                _this.fmeListSrv.msgStatusUnsubscribe(onReceiveStatusHandler, statusesToSubscribe);
            },
        };
    };
    ;
    AapModalWindowController.prototype.handleAudioProcDataFromSNP = function (programNumber) {
        var _this = this;
        function findProgramLetter(programNumber) {
            var programLetter = "";
            switch (Math.ceil(programNumber / 8)) {
                case 1:
                    programLetter = "A";
                    break;
                case 2:
                    programLetter = "B";
                    break;
                case 3:
                    programLetter = "C";
                    break;
                case 4:
                    programLetter = "D";
                    break;
            }
            return programLetter;
        }
        function generateProcAudioObjectId(programNumber) {
            return findProgramLetter(programNumber) + "-" + common_1.SNP_OBJTYPE_PROC_AUD;
        }
        function findProcAudioId(programNumber) {
            var audProcMap = {
                1: 1,
                2: 17,
                3: 33,
                4: 49,
                5: 65,
                6: 81,
                7: 97,
                8: 113,
            };
            var programInProcessor = programNumber % 8;
            if (programInProcessor === 0) {
                programInProcessor = 8;
            }
            var firstProcAudioIdForProgram = audProcMap[programInProcessor]; //  programInProcessor * 16 + 1
            return firstProcAudioIdForProgram;
        }
        ///
        var procAudioObjectId = generateProcAudioObjectId(programNumber);
        var firstProcAudioId = findProcAudioId(programNumber);
        var requirePropObjs = [
            {
                type: common_1.SNP_OBJTYPE_PROC_AUD,
                object_ID: procAudioObjectId,
                getStatus: false,
            },
        ];
        this.snpListSrv.getObjects(this.$scope.fmeIp, requirePropObjs).then(function (response) {
            var aapSessionConfigLastIdx = response[procAudioObjectId].config.aapSessionConfig.length - 1;
            for (var i = 0; i < 8 && aapSessionConfigLastIdx >= 0; i++) {
                response[procAudioObjectId].config.aapSessionConfig[aapSessionConfigLastIdx].aapSessionAudInConfig[i].sourceInputChannel = firstProcAudioId + i;
            }
            console.log(response[procAudioObjectId].config.aapSessionConfig);
            var aapCfg = {
                aapSessionConfig: response[procAudioObjectId].config.aapSessionConfig,
                fme_ip: _this.$scope.fmeIp,
                name: procAudioObjectId,
                object_ID: procAudioObjectId,
                type: common_1.SNP_OBJTYPE_PROC_AUD,
            };
            _this.snpListSrv.applyPartialUpdate(aapCfg, function (report) {
                var isNoErrorsInRequest = typeof report === "undefined";
                if (!isNoErrorsInRequest) {
                    console.error("not-adjusted", report);
                }
            });
        }, function (error) {
            console.error.apply(console, [error].concat(requirePropObjs));
        });
    };
    ;
    AapModalWindowController.prototype.initializeDropdowns = function (metadata) {
        function mergeIndicesAndLabelsFor(element) {
            var dropdownOptions = [];
            var mergedOption;
            var src = metadata[element];
            src.enum.forEach(function (enumIdx) {
                mergedOption = {
                    idx: enumIdx,
                    label: src.enumLabels[enumIdx]
                };
                dropdownOptions.push(mergedOption);
            });
            return dropdownOptions;
        }
        this.$scope.algorithmList = mergeIndicesAndLabelsFor("algorithm");
        this.$scope.dspList = mergeIndicesAndLabelsFor("DSP");
        this.$scope.programList = mergeIndicesAndLabelsFor("program");
        function createLabelsDictFor(element) {
            var dict = {};
            var src = metadata[element];
            src.enum.forEach(function (enumIdx) {
                dict[enumIdx] = src.enumLabels[enumIdx];
            });
            return dict;
        }
        this.$scope.algLabelDict = createLabelsDictFor("algorithm");
        this.$scope.dspLabelDict = createLabelsDictFor("DSP");
        this.$scope.progLabelDict = createLabelsDictFor("program");
    };
    ;
    AapModalWindowController.prototype.castFor = function (type, algorithms) {
        if (!Array.isArray(algorithms)) {
            throw Error("Should be passed array");
        }
        var deepCopy = algorithms.slice();
        var isBackendCasting = type === this.type.BACKEND;
        var isFrontendCasting = type === this.type.FRONTEND;
        var castValue = function (value) {
            if (isBackendCasting) {
                return Number(value);
            }
            else if (isFrontendCasting) {
                return String(value);
            }
        };
        for (var i = 0; i < algorithms.length; i++) {
            var algorithm = algorithms[i];
            for (var key in algorithm) {
                switch (key) {
                    case "DSP":
                    case "algorithm":
                    case "program":
                        deepCopy[i][key] = castValue(algorithm[key]);
                        break;
                    default:
                        break;
                }
            }
        }
        return deepCopy;
    };
    ;
    return AapModalWindowController;
}(base_tab_controller_1.AbstractBaseTabController));
exports.AapModalWindowController = AapModalWindowController;


/***/ }),

/***/ "./app/config-menu/aap/aap-modal-window.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/aap/aap-modal-window.template.html?8bd880e88e2898843feb0562e9a1fe53";

/***/ }),

/***/ "./app/config-menu/aap/modals/add-dsp-session/add-dsp-session-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var add_dsp_session_modal_window_contoller_1 = __webpack_require__("./app/config-menu/aap/modals/add-dsp-session/add-dsp-session-modal-window.contoller.ts");
var templateUrl = __webpack_require__("./app/config-menu/aap/modals/add-dsp-session/add-dsp-session-modal-window.template.html");
exports.createAddDspSessionModalWindowComponent = function (library, data) {
    return library.open({
        animation: true,
        backdrop: "static",
        size: "md",
        templateUrl: templateUrl,
        controller: add_dsp_session_modal_window_contoller_1.AddDspSessionModalWindowController,
        resolve: {
            passedProps: data
        }
    });
};


/***/ }),

/***/ "./app/config-menu/aap/modals/add-dsp-session/add-dsp-session-modal-window.contoller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var AddDspSessionModalWindowController = (function () {
    function AddDspSessionModalWindowController($scope, $uibModalInstance, passedProps) {
        $scope.newSession = passedProps.newSession;
        $scope.algorithmList = passedProps.algorithmDropdownOptions;
        $scope.dspList = passedProps.dspDropdownOptions;
        $scope.programList = passedProps.programDropdownOptions;
        $scope.submitChanges = function () {
            $uibModalInstance.close($scope.newSession);
        };
        $scope.closeModal = function () {
            $uibModalInstance.close(false);
        };
        $scope.validSession = function () {
            return ($scope.newSession.program > 0 && $scope.newSession.algorithm > 0);
        };
    }
    return AddDspSessionModalWindowController;
}());
exports.AddDspSessionModalWindowController = AddDspSessionModalWindowController;


/***/ }),

/***/ "./app/config-menu/aap/modals/add-dsp-session/add-dsp-session-modal-window.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/aap/modals/add-dsp-session/add-dsp-session-modal-window.template.html?7d06245a20eafc2bb153f0994ed9d4ae";

/***/ }),

/***/ "./app/config-menu/addFme---to-be-depricated/addFmeController.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular__ = __webpack_require__("./node_modules/angular/index.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_angular__);


Object(__WEBPACK_IMPORTED_MODULE_0_angular__["module"])('addFme', [])
  .controller('addFme', [
    '$scope',
    'fmeListSrv',
    'cfgObjectSrv',
    '$uibModalInstance',
    'configRemoteMenuModalsSrv',
    'commonUtils',
    function ($scope, fmeListSrv, cfgObjectSrv, $uibModalInstance, configRemoteMenuModalsSrv, commonUtils)
    {
      $scope.fmeList = fmeListSrv.getAllElements();
      $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";

      function initialize ()
      {
        $scope.addFme = {
          fme_ip_address: "",
          fme_name: ""
        };
        $scope.renameFme = {
          fme_ip_address: "",
          fme_name: ""
        };

        if (typeof $scope.addFmeForm !== 'undefined')
        {
          $scope.addFmeForm.$setPristine();
        }
      }

      //function to add FME to FMM's database
      $scope.addFME = function ()
      {
        fmeListSrv.addElement($scope.addFme);
        //reset IP to default values
        initialize();
      };

      $scope.reconnectFme = function (fmeJson)
      {
        var parsedJsonObj = {
          fme_ip_address: fmeJson.ip,
          fme_name: fmeJson.name
        };
        fmeListSrv.reconnectElement(parsedJsonObj);
      }

      //function to enable rename dialog
      $scope.openFME = function (fmeJson)
      {
        $scope.renameFme.fme_ip_address = fmeJson.ip;
        $scope.renameFme.fme_name = fmeJson.name;
      };

      //function to rename FME
      $scope.renameFME = function ()
      {
        if ($scope.addFmeForm.renameFme_fme_name.$dirty && $scope.addFmeForm.renameFme_fme_name.$valid)
        {
          fmeListSrv.updateElement($scope.renameFme);
        }
        $scope.resetRename();
      };

      $scope.resetRename = function ()
      {
        $scope.renameFme = {
          fme_ip_address: "",
          fme_name: ""
        };
        $scope.addFmeForm.renameFme_fme_name.$setPristine();
      }

      //function to delete FME from FMM's database
      $scope.removeFME = function (fmeJson)
      {
        fmeListSrv.removeElement(fmeJson);
      };

      $scope.cfgFme = function (fme_ip_address)
      {
        cfgObjectSrv.saveFmeConfig(fme_ip_address);
        configRemoteMenuModalsSrv.openEditElementModal(fme_ip_address);
      };

      $scope.displayNameComparator = function (obj)
      {
        return !!obj.name ? -1 : 1;
      }

      $scope.stateFilter = function (item)
      {
        if (item.state !== 'unmanaged' &&
          item.state !== 'managed')
          return item;
      };

      $scope.closeModal = function ()
      {
        $uibModalInstance.close();
      };

      initialize();
    }
  ]);


/***/ }),

/***/ "./app/config-menu/addFme---to-be-depricated/editFmeController.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular__ = __webpack_require__("./node_modules/angular/index.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_angular__);


__WEBPACK_IMPORTED_MODULE_0_angular__["module"]('editFme', [])
  .controller('editFme', [
    '$scope',
    'fmeListSrv',
    '$uibModalInstance',
    'commonUtils',
    'modalData',
    function ($scope, fmeListSrv, $uibModalInstance, commonUtils, modalData)
    {
      $scope.fmeList = fmeListSrv.getAllElements();
      $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
      $scope.fme_ip_address = modalData;
      $scope.editFme = {};

      function initialize ()
      {
        $scope.editFme = {
          fme_ip_address: modalData,
          fme_name: "",
          remote_user: "",
          remote_pass: ""
        };

        fmeListSrv.getElementByIp($scope.editFme.fme_ip_address).success(response =>
        {
          $scope.editFme.fme_name = response.fme_name;
          $scope.editFme.remote_user = response.remote_user;
          $scope.editFme.remote_pass = response.remote_pass;
        });

        if (typeof $scope.editFmeForm !== 'undefined')
        {
          $scope.editFmeForm.$setPristine();
        }
      }

      //function to rename FME
      $scope.submitChanges = function ()
      {
        fmeListSrv.updateElement($scope.editFme);
      };

      $scope.closeModal = function ()
      {
        $uibModalInstance.close();
      };

      initialize();
    }
  ]);


/***/ }),

/***/ "./app/config-menu/addFme---to-be-depricated/editFmeModal.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/addFme---to-be-depricated/editFmeModal.html?2e01958912e39a20c883af9028c54b1d";

/***/ }),

/***/ "./app/config-menu/addFme---to-be-depricated/flxAddFmeDir.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/addFme---to-be-depricated/flxAddFmeDir.html?cfd87e920b18aa7ff4680f9b59e11af9";

/***/ }),

/***/ "./app/config-menu/cfgSmm---to-be-depricated/cfgSmm.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/cfgSmm---to-be-depricated/cfgSmm.html?99369553813223101fb60256b1c2678e";

/***/ }),

/***/ "./app/config-menu/cfgSmm---to-be-depricated/cfgSmmController.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular__ = __webpack_require__("./node_modules/angular/index.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_angular__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__logs_html__ = __webpack_require__("./app/config-menu/cfgSmm---to-be-depricated/logs.html");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__logs_html___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1__logs_html__);




__WEBPACK_IMPORTED_MODULE_0_angular__["module"]('cfgSmm', [])
  .controller('cfgSmmController', [
    '$scope',
    '$uibModalInstance',
    'fmeListSrv',
    'commonUtils',
    'logsSrv',
    function ($scope, $uibModalInstance, fmeListSrv, commonUtils, logsSrv)
    {
      $scope.fme_ip = "127.0.0.1";

      var initialize = function ()
      {
        $scope.dbg = fmeListSrv.getDbg();
        $scope.fme_ip = "127.0.0.1";
      }

      var prepareModal = function ()
      {
        initialize();
        //stop updating FME status
        fmeListSrv.clearUpdateStatus();
      }

      $scope.closeModal = function ()
      {
        $uibModalInstance.close();
      }

      $scope.$on('$destroy', function ()
      {
        //resume updating FME status
        fmeListSrv.setUpdateStatus();
      });

      prepareModal();
    }
  ])
  .controller('cfgLogsCtrl', ['$http', 'REST_ENDPOINT', 'logsSrv', '$scope', 'commonUtils', function ($http, REST_ENDPOINT, logsSrv, $scope, commonUtils)
  {
    var vm = this;

    vm.logs = logsSrv.logs;

    vm.runDigest = function ()
    {
      $scope.$apply();
    }

    vm.downloadSystemLogs = function ()
    {
      $http.get(REST_ENDPOINT.URI + "singleusetoken")
        .then(function (response)
        {
          //download the selected log file
          var element = document.createElement('a');
          var selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
          element.setAttribute('href', window.location.protocol.toString() + '//' + window.location.hostname + '/api/logs/system?Authorization=' + response.data);
          element.style.display = 'none';
          document.body.appendChild(element);
          element.click();
          document.body.removeChild(element);
        }, function (error)
        {
          console.error("Error obtaining single-use token", error);
        });
    }

    vm.collectSystemLogs = function ()
    {
      $http.post(REST_ENDPOINT.URI + "logs/system/collect");
    }

    logsSrv.subscribe(vm.runDigest);
    $scope.$on('$destroy', () => logsSrv.unsubscribe(vm.runDigest));
  }])
  .component('cfgLogs',
  {
    templateUrl: __WEBPACK_IMPORTED_MODULE_1__logs_html__,
    controller: 'cfgLogsCtrl'
  })


/***/ }),

/***/ "./app/config-menu/cfgSmm---to-be-depricated/logs.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/cfgSmm---to-be-depricated/logs.html?334947859eeb8a0945f9ff3f14a7f72c";

/***/ }),

/***/ "./app/config-menu/config-menu-modals.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var element_modal_window_component_1 = __webpack_require__("./app/config-menu/element/element-modal-window.component.ts");
var presets_modal_window_component_1 = __webpack_require__("./app/config-menu/presets/presets-modal-window.component.ts");
var graphics_modal_window_component_1 = __webpack_require__("./app/config-menu/graphics/graphics-modal-window.component.ts");
var effects_modal_window_component_1 = __webpack_require__("./app/config-menu/effects/effects-modal-window.component.ts");
var luts_modal_window_component_1 = __webpack_require__("./app/config-menu/luts/luts-modal-window.component.ts");
var aap_modal_window_component_1 = __webpack_require__("./app/config-menu/aap/aap-modal-window.component.ts");
var add_dsp_session_modal_window_component_1 = __webpack_require__("./app/config-menu/aap/modals/add-dsp-session/add-dsp-session-modal-window.component.ts");
var license_modal_window_component_1 = __webpack_require__("./app/config-menu/license/license-modal-window.component.ts");
var mcl_panel_component_1 = __webpack_require__("./app/config-menu/mcl-panel/mcl-panel.component.ts");
exports.ConfigMenuModalsService = function ($uibModal, $uibModalStack) {
    var openCfgFmeModal = function () {
        return element_modal_window_component_1.createElementModalWindowComponent($uibModal);
    };
    var openCfgPresetModal = function () {
        return presets_modal_window_component_1.createPresetsModalWindowComponent($uibModal);
    };
    var openCfgLutsModal = function () {
        return luts_modal_window_component_1.creatLutsModalWindowComponent($uibModal);
    };
    var openCfgAapModal = function () {
        return aap_modal_window_component_1.createAapModalWindowComponent($uibModal);
    };
    var openAddDSPSessionModal = function (data) {
        return add_dsp_session_modal_window_component_1.createAddDspSessionModalWindowComponent($uibModal, data);
    };
    var openCfgLicenseModal = function () {
        return license_modal_window_component_1.createLicenseModalWindowComponent($uibModal);
    };
    var openCfgGfxModal = function () {
        return graphics_modal_window_component_1.createGraphicsModalWindowComponent($uibModal);
    };
    var openCfgFxModal = function () {
        return effects_modal_window_component_1.createEffectsModalWindowComponent($uibModal);
    };
    var openCfgPCSModal = function () {
        return mcl_panel_component_1.createPCSModalWindowComponent($uibModal);
    };
    return {
        openCfgFmeModal: openCfgFmeModal,
        openCfgPresetModal: openCfgPresetModal,
        openCfgLutsModal: openCfgLutsModal,
        openCfgAapModal: openCfgAapModal,
        openAddDSPSessionModal: openAddDSPSessionModal,
        openCfgLicenseModal: openCfgLicenseModal,
        openCfgGfxModal: openCfgGfxModal,
        openCfgFxModal: openCfgFxModal,
        openCfgPCSModal: openCfgPCSModal
    }; // ES6 syntax
};


/***/ }),

/***/ "./app/config-menu/config-menu.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var element_modal_window_module_1 = __webpack_require__("./app/config-menu/element/element-modal-window.module.ts");
var presets_module_1 = __webpack_require__("./app/config-menu/presets/presets.module.ts");
var luts_module_1 = __webpack_require__("./app/config-menu/luts/luts.module.ts");
var graphics_module_1 = __webpack_require__("./app/config-menu/graphics/graphics.module.ts");
var effects_module_1 = __webpack_require__("./app/config-menu/effects/effects.module.ts");
var mcl_panel_module_1 = __webpack_require__("./app/config-menu/mcl-panel/mcl-panel.module.ts");
var config_menu_modals_service_1 = __webpack_require__("./app/config-menu/config-menu-modals.service.ts");
var config_remote_menu_modals_service_1 = __webpack_require__("./app/config-menu/config-remote-menu-modals.service.ts");
var config_object_factory_1 = __webpack_require__("./app/config-menu/config-object.factory.ts");
__webpack_require__("./app/config-menu/cfgSmm---to-be-depricated/cfgSmmController.js"); // low priority for remote part
__webpack_require__("./app/config-menu/addFme---to-be-depricated/addFmeController.js"); // low priority for remote part
__webpack_require__("./app/config-menu/addFme---to-be-depricated/editFmeController.js"); // low priority for remote part
exports.ConfigMenuModule = angular_1.module("configMenuModule", [
    element_modal_window_module_1.ElementModule.name,
    presets_module_1.PresetsModule.name,
    luts_module_1.LutsModule.name,
    graphics_module_1.GraphicsModule.name,
    effects_module_1.EffectsModule.name,
    mcl_panel_module_1.PCSModule.name,
    "addFme",
    "editFme",
    "cfgSmm",
])
    .service("configMenuModalsSrv", config_menu_modals_service_1.ConfigMenuModalsService)
    .service("configRemoteMenuModalsSrv", config_remote_menu_modals_service_1.ConfigRemoteMenuModalsService)
    .factory('cfgObjectSrv', config_object_factory_1.configObjectFactory);


/***/ }),

/***/ "./app/config-menu/config-object.factory.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
exports.configObjectFactory = function (fmeListSrv, $q) {
    //this service holds the configurations to be passed between different controllers
    var myFactory = {};
    var fmeConfig = '';
    var inputConfig = {};
    var parentConfig = {};
    var editConfig = {};
    var editConfigReady = false;
    var configReady = false;
    function initialize() {
        fmeConfig = '';
        inputConfig = {};
        parentConfig = {};
        editConfig = {};
        editConfigReady = false;
        configReady = false;
    }
    ;
    myFactory.init = function () {
        initialize();
    };
    myFactory.getConfigReady = function () {
        return configReady;
    };
    myFactory.getEditConfigReady = function () {
        return editConfigReady;
    };
    myFactory.saveEditConfig = function (jsonItem) {
        //saves config JSON object for edit
        return $q(function (resolve, reject) {
            fmeListSrv.getObject(jsonItem, {
                update: true
            })
                .then(function (result) {
                if (fmeListSrv.getDbg()) {
                    console.log('saveEditConfig', result);
                }
                angular_1.copy(result, editConfig);
                editConfigReady = true;
                resolve(result.type);
            }, function (error) {
                console.log('saveEditCofig: failed');
                editConfigReady = false;
                reject('saveEditCofig: failed');
            });
        });
    };
    myFactory.getEditConfig = function () {
        //loads config JSON object for edit
        return editConfig;
    };
    myFactory.saveFmeConfig = function (tempFmeIp) {
        fmeConfig = tempFmeIp;
        configReady = true;
        if (fmeListSrv.getDbg()) {
            console.log('cfgObjec: saveFmeConfig ', tempFmeIp);
        }
        ;
    };
    myFactory.saveLinearConfig = function (tempInput) {
        //saves config JSON object for linear transcoding
        angular_1.copy(tempInput, inputConfig);
        //console.log('input:',inputConfig);
        configReady = true;
    };
    myFactory.saveMuxServiceConfig = function (tempInput, tempParent) {
        //saves config JSON object for mux service
        angular_1.copy(tempInput, inputConfig);
        angular_1.copy(tempParent, parentConfig);
        //console.log('input:',inputConfig);
        //console.log('parent:',parentConfig);
        configReady = true;
    };
    myFactory.getFmeConfig = function () {
        if (fmeListSrv.getDbg()) {
            console.log('cfgObjec: getFmeConfig ', fmeConfig);
        }
        ;
        return fmeConfig;
    };
    myFactory.getInputConfig = function () {
        //returns a JSON object for input object
        return inputConfig;
    };
    myFactory.getParentConfig = function () {
        //returns a JSON object for parent objects
        return parentConfig;
    };
    return myFactory;
};


/***/ }),

/***/ "./app/config-menu/config-remote-menu-modals.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var addFmeTemplateUrl = __webpack_require__("./app/config-menu/addFme---to-be-depricated/flxAddFmeDir.html");
var editFmeTemplateUrl = __webpack_require__("./app/config-menu/addFme---to-be-depricated/editFmeModal.html");
var cfgSmmTemplateUrl = __webpack_require__("./app/config-menu/cfgSmm---to-be-depricated/cfgSmm.html");
exports.ConfigRemoteMenuModalsService = function ($uibModal, $uibModalStack) {
    var openAddElementModal = function () {
        var modalInstance = $uibModal.open({
            animation: true,
            backdrop: 'static',
            size: 'wide',
            templateUrl: addFmeTemplateUrl,
            controller: 'addFme'
        });
        return modalInstance;
    };
    var openEditElementModal = function (data) {
        var modalInstance = $uibModal.open({
            animation: true,
            backdrop: 'static',
            size: 'md',
            templateUrl: editFmeTemplateUrl,
            controller: 'editFme',
            resolve: {
                modalData: function () {
                    return data;
                }
            }
        });
        return modalInstance;
    };
    var openCfgSmmModal = function () {
        var modalInstance = $uibModal.open({
            animation: true,
            backdrop: 'static',
            templateUrl: cfgSmmTemplateUrl,
            controller: 'cfgSmmController'
        });
        return modalInstance;
    };
    return {
        openAddElementModal: openAddElementModal,
        openEditElementModal: openEditElementModal,
        openCfgSmmModal: openCfgSmmModal,
    }; // ES6 syntax
};


/***/ }),

/***/ "./app/config-menu/effects/effects-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var effects_modal_window_controller_1 = __webpack_require__("./app/config-menu/effects/effects-modal-window.controller.ts");
var templateUrl = __webpack_require__("./app/config-menu/effects/effects-modal-window.template.html");
exports.createEffectsModalWindowComponent = function (library) {
    return library.open({
        animation: true,
        backdrop: "static",
        size: "wide",
        templateUrl: templateUrl,
        controller: effects_modal_window_controller_1.EffectsModalWindowController,
    });
};


/***/ }),

/***/ "./app/config-menu/effects/effects-modal-window.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {
Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var EffectsModalWindowController = (function () {
    function EffectsModalWindowController($scope, $location, $uibModalInstance, fmeListSrv, effectsSrv, snpListSrv, commonUtils) {
        $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        var initialize = function () {
            $scope.fme_ip =
                fmeListSrv.getLastUsedElement()["ip"] ||
                    $scope.fmeList.filter($scope.fmeFilter).filter($scope.fmeTypeFilter)[0]["ip"];
            $scope.fmeList = fmeListSrv.getAllElements();
            $scope.fxList = [];
            $scope.fxUsage = [];
            $scope.procMode = [];
            // $scope.dbg = fmeListSrv.getDbg();
            $scope.percentUsage = 0;
            $scope.isUploading = false;
            $("input:file").val("");
            $scope.importFx = {};
            $scope.importName = "";
            $scope.importDisplayName = "";
            $scope.importProcAEnable = false;
            $scope.importProcCEnable = false;
            $scope.getEffects();
            $scope.fxNameExist = false;
            $scope.sort = "name";
            $scope.reverseSort = "+";
            $scope.getEffectsInUse();
            $scope.getEffects();
            $scope.errorText = null;
            //stop updating FME status
            fmeListSrv.clearUpdateStatus();
        };
        $scope.updatePresetList = function () {
            if (!!fmeListSrv.getLastUsedElement()["ip"] ||
                !!$scope.fmeList
                    .filter($scope.fmeFilter)
                    .filter($scope.fmeTypeFilter)[0]) {
                $scope.loadPreset.fme_ip_address =
                    fmeListSrv.getLastUsedElement()["ip"] ||
                        $scope.fmeList
                            .filter($scope.fmeFilter)
                            .filter($scope.fmeTypeFilter)[0]["ip"];
            }
            else {
                $scope.loadPreset.fme_ip_address = "";
            }
        };
        $scope.fmeFilter = function (item) {
            if (!!item.state && item.state == "connected") {
                item.label =
                    item.name.length > 0 ? item.name + " (" + item.ip + ")" : item.ip;
                return item;
            }
        };
        $scope.fmeTypeFilter = function (item) {
            var preset = $scope.presetList.find(function (e) {
                return e.name === $scope.loadPreset.name;
            });
            if (!!preset) {
                if (!preset.element_type) {
                    return item;
                }
                else if (preset.element_type === item.fme_type) {
                    return item;
                }
                return;
            }
            else {
                return item;
            }
        };
        $scope.getEffectsInUse = function () {
            // TODO implement this once we can actually select an effect!
            /*
              var mclCfgs = [
                "MasterControl-A",
                "MasterControl-B",
                "MasterControl-C",
                "MasterControl-D",
              ];
              var mclObjects: requestType = [];
      
              for (var index in mclCfgs)
              {
                var mclId = mclCfgs[index];
                mclObjects[index] = {
                  type: SNP_OBJTYPE_MCL,
                  object_ID: mclId,
                  getStatus: false,
                };
              }
      
              snpListSrv.getObjects($scope.fme_ip, mclObjects).then(
                function (resolve)
                {
                  for (var index in mclCfgs)
                  {
                    var mclId = mclCfgs[index];
                    var procUsage = [];
                    if (resolve[mclId])
                    {
                      for (var keyerIdx in resolve[mclId].config.KeyerControl)
                      {
                        procUsage[keyerIdx] =
                          resolve[mclId].config.KeyerControl[keyerIdx].SrcSelect;
                      }
                    }
                    $scope.gfxUsage[index] = procUsage;
                  }
                },
                function (reject)
                {
                  console.log("getObjects error:", reject);
                }
              );
      
              var procCfgs = ["processorA", "processorB", "processorC", "processorD"];
              var procObjects: requestType = [];
      
              for (var index in procCfgs)
              {
                procObjects[index] = {
                  type: SNP_OBJTYPE_PROCESSOR,
                  object_ID: procCfgs[index],
                  getStatus: false,
                };
              }
      
              snpListSrv.getObjects($scope.fme_ip, procObjects).then(
                function (resolve)
                {
                  for (var index in procCfgs)
                  {
                    var procId = procCfgs[index];
                    if (resolve[procId])
                    {
                      $scope.procMode[index] =
                        resolve[procId].config.general.personality;
                    }
                  }
                },
                function (reject)
                {
                  console.log("getObjects error:", reject);
                }
              );
              */
        };
        $scope.getEffects = function () {
            effectsSrv.getEffects().then(function (resolve) {
                console.log(resolve);
                $scope.fxList = resolve;
                for (var index in $scope.fxList) {
                    if ($scope.fxList[index].last_modified.indexOf("Z") == -1) {
                        $scope.fxList[index].last_modified =
                            $scope.fxList[index].last_modified + "Z";
                    }
                    $scope.fxList[index].last_modified = Date.parse($scope.fxList[index].last_modified);
                    $scope.fxList[index].name = $scope.fxList[index].name
                        .split(".")
                        .slice(0, -1)
                        .join(".");
                    $scope.fxList[index].downloadingInProgress = false;
                }
            }, function (reject) {
                if ($scope.dbg) {
                    console.log("getEffects error:", reject);
                }
            });
            effectsSrv.getEffectsSpaceUsage().then(function (resolve) {
                $scope.percentUsage = resolve;
            }, function (reject) {
                console.log("getEffectsSpaceUsage failed");
                $scope.percentUsage = 0;
            });
        };
        $scope.sortBy = function (sortField) {
            if ($scope.sort === sortField) {
                $scope.reverseSort = $scope.reverseSort === "+" ? "-" : "+";
            }
            else {
                $scope.reverseSort = "+";
                $scope.sort = sortField;
            }
        };
        $scope.getEffectsNameExist = function (type) {
            $scope.fxNameExist = false;
            var fxName;
            if (type === 'save') {
                fxName = $scope.savePreset.name;
            }
            else if (type === 'import') {
                if ($scope.importFx && $scope.importFx.name) {
                    if ($scope.importFx.name.split('.')[1] === "json") {
                        $scope.importName = $scope.importFx.name.split('.')[0];
                        fxName = $scope.importName;
                        $scope.errorText = undefined;
                    }
                    else {
                        $scope.importFx = {};
                        $scope.importName = "";
                        $scope.errorText = "Only accepts json files";
                    }
                }
            }
            else if (type === 'update') {
                fxName = $scope.importName;
            }
            if (angular_1.isDefined($scope.fxList)) {
                $scope.fxNameExist = $scope.fxList.some(function (e) {
                    return e.name === fxName;
                });
            }
        };
        // preset name does not go through ng-change, this is a workaround
        $scope.$watch('importFx.name', function () {
            $scope.getEffectsNameExist('import');
        });
        $scope.$watch('importName', function () {
            $scope.getEffectsNameExist('update');
        });
        $scope.import = function () {
            //import gfx from text file
            $scope.isUploading = true;
            effectsSrv.importEffect($scope.importFx.jsonfile, $scope.importName).then(function (resolve) {
                var metadataObj = {
                    effectDisplayName: $scope.importDisplayName,
                    effectEnableProcA: $scope.importProcAEnable,
                    effectEnableProcC: $scope.importProcCEnable
                };
                var metadataStr = JSON.stringify(metadataObj);
                effectsSrv.importEffectMetadata(metadataStr, $scope.importName).then(function (resolve) {
                    $scope.importName = "";
                    $scope.importDisplayName = "";
                    $scope.importProcAEnable = false;
                    $scope.importProcCEnable = false;
                    $("input:file").val("");
                    $scope.importFx = {};
                    $scope.isUploading = false;
                    $scope.getEffects();
                    $scope.errorText = undefined;
                }, function (reject) {
                    if ($scope.dbg) {
                        console.log("importEffect error:", reject);
                    }
                    $scope.isUploading = false;
                    $scope.errorText = reject;
                });
            }, function (reject) {
                if ($scope.dbg) {
                    console.log("importEffect error:", reject);
                }
                $scope.isUploading = false;
                $scope.errorText = reject;
            });
        };
        $scope.printScope = function () {
            console.log($scope);
        };
        $scope.closeModal = function () {
            $uibModalInstance.close();
        };
        $scope.$on("$destroy", function () {
            //resume update and clear cfgObject service when modal is destroyed
            fmeListSrv.setUpdateStatus();
        });
        function isPresetLoading(fme) {
            return fme.state === "loading-preset" || fme.presetLoaded === false;
        }
        $scope.arePresetsLoading = function () {
            return fmeListSrv.arePresetsLoading();
        };
        $scope.elementsLoadingPresets = function () {
            return $scope.fmeList
                .filter(isPresetLoading)
                .map(function (fme) { return (fme.ip === "127.0.0.1" ? $location.$$host : fme.ip); })
                .join(", ");
        };
        initialize();
    }
    return EffectsModalWindowController;
}());
exports.EffectsModalWindowController = EffectsModalWindowController;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__("./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./app/config-menu/effects/effects-modal-window.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/effects/effects-modal-window.template.html?fffef6bcfc735ca406185c97670622d0";

/***/ }),

/***/ "./app/config-menu/effects/effects-table/effects-table.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var templateUrl = __webpack_require__("./app/config-menu/effects/effects-table/effects-table.template.html");
function effectsTableDirective() {
    //Modal for save/load presets
    return {
        scope: {
            fxList: "=",
            fxUsage: "=",
            procMode: "=",
            errorText: "=",
            sort: "=",
            fxNameExist: "=",
            importName: "=",
            getEffects: "&",
        },
        restrict: "E",
        templateUrl: templateUrl,
        controller: [
            "$scope",
            "$timeout",
            "effectsSrv",
            function ($scope, $timeout, effectsSrv) {
                $scope.exportError = false;
                $scope.exportEffects = function (nameFromTable) {
                    var fx = $scope.fxList.find(function (el) { return el.name === nameFromTable; });
                    function saveFxAs(bytes, fileName) {
                        var url = window.URL.createObjectURL(bytes);
                        var a = document.createElement("a");
                        document.body.appendChild(a);
                        a.href = url;
                        a.download = fileName;
                        a.click();
                        a.remove();
                        window.URL.revokeObjectURL(url);
                    }
                    fx.downloadingInProgress = true;
                    effectsSrv.getEffect(nameFromTable).then(function (data) {
                        var fileName = nameFromTable + ".json";
                        var fxBlob = new Blob([data], {
                            type: "application/octet-stream",
                        });
                        saveFxAs(fxBlob, fileName);
                        fx.downloadingInProgress = false;
                        $scope.errorText = undefined;
                    }, function (reject) {
                        $scope.exportError = true;
                        $timeout(function () { return ($scope.exportError = false); }, 5000);
                        $scope.errorText = reject;
                    });
                };
                $scope.updateFxMetadata = function (fx) {
                    var metadataObj = {
                        effectDisplayName: fx.effectDisplayName,
                        effectEnableProcA: fx.effectEnableProcA,
                        effectEnableProcC: fx.effectEnableProcC
                    };
                    var metadataStr = JSON.stringify(metadataObj);
                    effectsSrv.importEffectMetadata(metadataStr, fx.name).then(function (resolve) {
                        $scope.errorText = null;
                    }, function (reject) {
                        if ($scope.dbg) {
                            console.log("updateFxMetadata error:", reject);
                        }
                        $scope.errorText = reject;
                    });
                };
                $scope.rmvSelectedEffects = function (fxName) {
                    //remove selected preset
                    var fileName = fxName + ".json";
                    effectsSrv.rmvEffect(fxName).then(function (resolve) {
                        $scope.getEffects();
                        if (fxName === $scope.importName) {
                            $scope.fxNameExist = false;
                        }
                        $scope.errorText = null;
                    }, function (reject) {
                        if ($scope.dbg) {
                            console.log("removeEffect error:", reject);
                        }
                        $scope.errorText = reject;
                    });
                };
            },
        ],
    };
}
exports.effectsTableDirective = effectsTableDirective;


/***/ }),

/***/ "./app/config-menu/effects/effects-table/effects-table.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/effects/effects-table/effects-table.template.html?39e14e4b2a49eab4a9f78ddb3ec93935";

/***/ }),

/***/ "./app/config-menu/effects/effects.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var effects_service_1 = __webpack_require__("./app/config-menu/effects/effects.service.ts");
var effects_table_directive_1 = __webpack_require__("./app/config-menu/effects/effects-table/effects-table.directive.ts");
exports.EffectsModule = angular_1.module("EffectsModule", [])
    .service("effectsSrv", effects_service_1.EffectsService)
    .directive("effectsTable", effects_table_directive_1.effectsTableDirective);


/***/ }),

/***/ "./app/config-menu/effects/effects.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
exports.EffectsService = function ($http, $q, REST_ENDPOINT) {
    //// IMPORTANT!!!
    // .mg3 extention guard added to flx-file-input directive
    var dbg = false;
    var getEffectsSpaceUsage = function () {
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/gfx/space",
                method: "GET",
            })
                .success(function (response) {
                if (dbg) {
                    console.log("getGraphicsSpaceUsage response:", response);
                }
                resolve(response);
            })
                .error(function (response) {
                reject("getGraphicsSpaceUsage error:", response);
            });
        });
    };
    var getEffects = function () {
        //get a list of gfx from a particular FME IP
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/fx",
                method: "GET",
            })
                .success(function (response) {
                if (dbg) {
                    console.log("getGraphics, current list from DB:", response);
                }
                resolve(response);
            })
                .error(function (response) {
                reject("getEffects error:", response);
            });
        });
    };
    var getEffect = function (name) {
        //get a specific gfx
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/fx/" + name + ".json",
                method: "GET",
                responseType: "arraybuffer",
            })
                .success(function (response) {
                if (dbg) {
                    console.log("getEffect, current list from DB:", response);
                }
                resolve(response);
            })
                .error(function (response) {
                reject("getEffect error:", response);
            });
        });
    };
    var importEffect = function (fx_data, fx_name) {
        //import gfx file
        //requestStatusSrv.addRequest('AddLut', { "fme_ip": "127.0.0.1", "name": `LUT: ${lut_name}` });
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/fx/" + fx_name + ".json",
                data: fx_data,
                method: "PUT",
                transformResponse: angular_1.identity,
            })
                .success(function (response) {
                //requestStatusSrv.successRequest({ "msg_type": "AddLut", "fme_ip": "127.0.0.1", "name": `LUT: ${lut_name}` });
                //console.log("importGraphic:", response);
                resolve(response);
            })
                .error(function (response) {
                //requestStatusSrv.failedRequest({ "msg_type": "AddLut", "fme_ip": "127.0.0.1", "name": `LUT: ${lut_name}` }, response);
                reject("Error: " + response);
                //console.log("importEffect Error :", response);
            });
        });
    };
    var importEffectMetadata = function (fx_json, fx_name) {
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/fx/" + fx_name + ".json.meta",
                data: fx_json,
                method: "PUT",
                transformResponse: angular_1.identity,
            })
                .success(function (response) {
                //requestStatusSrv.successRequest({ "msg_type": "AddLut", "fme_ip": "127.0.0.1", "name": `LUT: ${lut_name}` });
                //console.log("importEffectMetadata:", response);
                resolve(response);
            })
                .error(function (response) {
                //requestStatusSrv.failedRequest({ "msg_type": "AddLut", "fme_ip": "127.0.0.1", "name": `LUT: ${lut_name}` }, response);
                reject("Error: " + response);
                //console.log("importEffect Error :", response);
            });
        });
    };
    var rmvEffect = function (fx_name) {
        //delet selected gfx
        var jsonObjStatus = {
            fme_ip: "127.0.0.1",
            name: "LUT: " + fx_name
        };
        //requestStatusSrv.addRequest('RmvLut', jsonObjStatus);
        //requestStatusSrv.addRequest('RmvPreset', jsonObjStatus);
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/fx/" + fx_name + ".json",
                method: "DELETE",
            }).then(function (response) {
                // success
                //var parsedJsonObj = {
                //    fme_ip: "127.0.0.1",
                //    name: `LUT: ${gfx_name}`,
                //    msg_type: 'RmvLut',
                //};
                //requestStatusSrv.successRequest(parsedJsonObj);
                if (dbg) {
                    console.log("rmvEffect success:", response);
                }
                resolve(response);
            }, function (response) {
                //failure
                //var failedObject = response.config.data;
                //failedObject.fme_ip = "127.0.0.1";
                //failedObject.msg_type = 'RmvLut';
                //requestStatusSrv.failedRequest(failedObject, (response.statusText + ': ' + response.data));
                reject("rmvEffect error:", response.data);
            });
        });
    };
    return {
        getEffectsSpaceUsage: getEffectsSpaceUsage,
        getEffects: getEffects,
        getEffect: getEffect,
        importEffect: importEffect,
        importEffectMetadata: importEffectMetadata,
        rmvEffect: rmvEffect,
    }; // ES6 syntax
};


/***/ }),

/***/ "./app/config-menu/element/element-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var element_modal_window_controller_1 = __webpack_require__("./app/config-menu/element/element-modal-window.controller.ts");
var templateUrl = __webpack_require__("./app/config-menu/element/element-modal-window.template.html");
exports.createElementModalWindowComponent = function (library) {
    return library.open({
        animation: true,
        backdrop: "static",
        size: 'md',
        templateUrl: templateUrl,
        controller: element_modal_window_controller_1.ElementModalWindowController,
    });
};


/***/ }),

/***/ "./app/config-menu/element/element-modal-window.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular = __webpack_require__("./node_modules/angular/index.js");
var ElementModalWindowController = (function () {
    function ElementModalWindowController($scope, $uibModalInstance, fmeListSrv, cfgObjectSrv, commonUtils) {
        this.$scope = $scope;
        this.$uibModalInstance = $uibModalInstance;
        this.fmeListSrv = fmeListSrv;
        this.cfgObjectSrv = cfgObjectSrv;
        this.commonUtils = commonUtils;
        $scope.availableTabs = [
            {
                text: "Reference",
                id: "reference",
                class: "active",
                applyButtons: []
            },
            {
                text: "IP WAN",
                id: "wan",
                class: "",
                applyButtons: []
            },
            {
                text: "IP Control",
                id: "ipControl",
                class: "",
                applyButtons: []
            },
            {
                text: "System",
                id: "snpSystem",
                class: "",
                applyButtons: []
            },
            {
                text: "SNP Management",
                id: "snp",
                class: "",
                applyButtons: []
            },
        ];
        $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        $scope.activeTab = [];
        $scope.tabState = {
            reference: {
                valid: true,
            },
            wan: {
                valid: true,
            },
            ipControl: {
                valid: true,
            },
            snpSystem: {
                valid: true,
            },
            snp: {
                valid: true,
            },
        };
        $scope.isDirty = {};
        $scope.applyInProgress = false;
        function initialize() {
            $scope.activeTab = $scope.availableTabs[0].id;
            $scope.fme = {};
            $scope.fmeList = fmeListSrv.getAllElements();
            $scope.fw_versions = [];
        }
        function prepareModal() {
            initialize();
            //see if any FME is requested, else use last selected Element, else use the first connected element
            if ($scope.fmeList.filter($scope.fmeFilter).length > 0) {
                var lastUsedElement = fmeListSrv.getLastUsedElement();
                var firstOnlineElement = $scope.fmeList
                    .filter($scope.fmeFilter)
                    .find(function (e) {
                    return e.state === "connected";
                });
                $scope.fme_ip = "";
                if (!!cfgObjectSrv.getFmeConfig()) {
                    $scope.fme_ip = cfgObjectSrv.getFmeConfig();
                }
                else if (lastUsedElement.ip) {
                    $scope.fme_ip = lastUsedElement.ip;
                }
                else if (!!firstOnlineElement) {
                    $scope.fme_ip = firstOnlineElement.ip;
                }
                $scope.getFme();
            }
            cfgObjectSrv.init();
            $scope.dbg = fmeListSrv.getDbg();
        }
        $scope.initialize = function () {
            initialize();
        };
        $scope.$on("$destroy", function () {
            //set last used element
            fmeListSrv.setLastUsedElement($scope.fme_ip);
        });
        this.$scope.activateTab = function (tabId) {
            $scope.activeTab = tabId;
        };
        $scope.fmeFilter = function (item) {
            if (item.state !== "connected") {
                item.label =
                    angular.isObject(item.name) && item.name.length > 0 ?
                        item.name + " (" + item.ip + ")" + " [" + item.state + "]" :
                        item.ip + " [" + item.state + "]";
            }
            else {
                item.label =
                    angular.isObject(item.name) && item.name.length > 0 ?
                        item.name + " (" + item.ip + ")" :
                        item.ip;
            }
            return item;
        };
        $scope.getFme = function () {
            $scope.selectedLog = {};
            if (!!$scope.fme_ip) {
                $scope.fme = fmeListSrv.getElement($scope.fme_ip);
            }
            else {
                $scope.fme = {};
                $scope.fw_versions = [];
            }
        };
        function getTab(tabId) {
            for (var i = 0; i < $scope.availableTabs.length; i++) {
                if ($scope.availableTabs[i].id === tabId) {
                    return $scope.availableTabs[i];
                }
            }
            return {};
        }
        this.$scope.getTabApplyButtons = function (tabId) {
            // console.log(tabId, getTab(tabId).applyButtons);
            return getTab(tabId).applyButtons;
        };
        $scope.getTabClass = function (tabId) {
            return getTab(tabId).class;
        };
        $scope.performApply = function (operation) {
            $scope.applyInProgress = true;
            try {
                operation().finally(function () {
                    $scope.applyInProgress = false;
                });
            }
            catch (e) {
                $scope.applyInProgress = false;
            }
        };
        $scope.checkDirty = function () {
            for (var idx in $scope.isDirty) {
                if ($scope.isDirty[idx] === true) {
                    return true;
                }
            }
            return false;
        };
        $scope.closeModal = function () {
            $uibModalInstance.close();
        };
        prepareModal();
    }
    return ElementModalWindowController;
}());
exports.ElementModalWindowController = ElementModalWindowController;
;


/***/ }),

/***/ "./app/config-menu/element/element-modal-window.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var reference_component_1 = __webpack_require__("./app/config-menu/element/reference/reference.component.ts");
var wan_component_1 = __webpack_require__("./app/config-menu/element/wan/wan.component.ts");
var ip_control_component_1 = __webpack_require__("./app/config-menu/element/ip-control/ip-control.component.ts");
var snp_management_component_1 = __webpack_require__("./app/config-menu/element/snp-management/snp-management.component.ts");
var system_component_1 = __webpack_require__("./app/config-menu/element/system/system.component.ts");
exports.ElementModule = angular_1.module("elementModule", [])
    .component("cfgElementReference", reference_component_1.configElementReferenceComponent)
    .component('cfgElementWan', wan_component_1.configElementWanComponent)
    .component('cfgElementIpControl', ip_control_component_1.cfgElementIpControlComponent)
    .component('cfgElementSnp', snp_management_component_1.CfgElementSNPComponent)
    .component('cfgElementSnpSystem', system_component_1.CfgElementSnpSystemComponent);


/***/ }),

/***/ "./app/config-menu/element/element-modal-window.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/element/element-modal-window.template.html?047693938153379b4cfeb62a405817ad";

/***/ }),

/***/ "./app/config-menu/element/ip-control/ip-control.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ip_control_controller_1 = __webpack_require__("./app/config-menu/element/ip-control/ip-control.controller.ts");
var templateUrl = __webpack_require__("./app/config-menu/element/ip-control/ip-control.template.html");
exports.cfgElementIpControlComponent = {
    bindings: {
        fmeIp: "<",
        tabState: "=",
        applyButtons: "=",
        dbg: "<",
        isDirty: "="
    },
    templateUrl: templateUrl,
    controller: ip_control_controller_1.CfgElementIpControlController
};


/***/ }),

/***/ "./app/config-menu/element/ip-control/ip-control.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var base_tab_controller_1 = __webpack_require__("./app/common/base-tab.controller.ts");
var common_1 = __webpack_require__("./app/view-menu/common.js");
var CfgElementIpControlController = (function (_super) {
    __extends(CfgElementIpControlController, _super);
    function CfgElementIpControlController($scope, $timeout, fmeListSrv, snpListSrv, userManagerSrv, commonUtils) {
        var _this = _super.call(this, $scope) || this;
        _this.$scope = $scope;
        _this.$timeout = $timeout;
        _this.fmeListSrv = fmeListSrv;
        _this.snpListSrv = snpListSrv;
        _this.userManagerSrv = userManagerSrv;
        _this.commonUtils = commonUtils;
        _this.reports = {
            ipRxSetup: undefined,
            ipVidTx: undefined,
            ipAudTx: undefined,
            ipAncTx: undefined,
        };
        _this.reportError = {
            ipRxSetup: false,
            ipVidTx: false,
            ipAudTx: false,
            ipAncTx: false,
        };
        _this.timeoutPromise = null;
        _this.$doCheck = function () {
            _this.isDirty =
                (!!_this.ipTxForm && _this.ipTxForm.$dirty) ||
                    (!!_this.ipVidTxForm && _this.ipVidTxForm.$dirty) ||
                    (!!_this.ipAudTxForm && _this.ipAudTxForm.$dirty) ||
                    (!!_this.ipAncTxForm && _this.ipAncTxForm.$dirty) ||
                    (!!_this.ipRxSetupForm && _this.ipRxSetupForm.$dirty);
            var isFormValid = angular_1.isUndefined(_this.topForm) || _this.topForm.$valid;
            var isReportError = false;
            Object.keys(_this.reportError).forEach(function (key) {
                isReportError = isReportError || _this.reportError[key];
            });
            _this.tabState.valid = isFormValid && !isReportError;
        };
        _this.$onChanges = function (changes) {
            _this.updateTabDataOnRemoteFmm(changes.fmeIp);
        };
        _this.$onDestroy = function () {
            if (_this.data.requests.statuses) {
                _this.fmeListSrv.msgStatusUnsubscribe(_this.controllerHandlers.onStatusUpdate, _this.data.requests.statuses);
            }
            if (_this.timeoutPromise)
                _this.$timeout.cancel(_this.timeoutPromise);
        };
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
        return _this;
    }
    // inherited base methods below
    CfgElementIpControlController.prototype.loadData = function () {
        var _this = this;
        // placeholder for loading data to scope, etc;
        this.data.requests = {
            configs: [
                {
                    type: common_1.SNP_OBJTYPE_IP_TX,
                    object_ID: common_1.SNP_OBJTYPE_IP_TX,
                },
                {
                    type: common_1.SNP_OBJTYPE_IP_AUD_TX,
                    object_ID: common_1.SNP_OBJTYPE_IP_AUD_TX,
                },
                {
                    type: common_1.SNP_OBJTYPE_IP_ANC_TX,
                    object_ID: common_1.SNP_OBJTYPE_IP_ANC_TX,
                },
                {
                    type: common_1.SNP_OBJTYPE_IP_RX_SETUP,
                    object_ID: common_1.SNP_OBJTYPE_IP_RX_SETUP,
                },
            ],
            statuses: [
                {
                    fme_ip: this.fmeIp,
                    type: common_1.SNP_OBJTYPE_IP_TX,
                    object_ID: common_1.SNP_OBJTYPE_IP_TX,
                },
                {
                    fme_ip: this.fmeIp,
                    type: common_1.SNP_OBJTYPE_IP_AUD_TX,
                    object_ID: common_1.SNP_OBJTYPE_IP_AUD_TX,
                },
                {
                    fme_ip: this.fmeIp,
                    type: common_1.SNP_OBJTYPE_IP_ANC_TX,
                    object_ID: common_1.SNP_OBJTYPE_IP_ANC_TX,
                },
                {
                    fme_ip: this.fmeIp,
                    type: common_1.SNP_OBJTYPE_IP_RX_SETUP,
                    object_ID: common_1.SNP_OBJTYPE_IP_RX_SETUP,
                },
            ],
        };
        if (this.data.requests.statuses) {
            this.fmeListSrv.msgStatusUnsubscribe(this.controllerHandlers.onStatusUpdate, this.data.requests.statuses);
        }
        this.snpListSrv.getObjects(this.fmeIp, this.data.requests.configs).then(function (response) {
            _this.data.response = {
                configs: {
                    ipVidTx: {
                        cfg: response[common_1.SNP_OBJTYPE_IP_TX].config,
                        meta: response[common_1.SNP_OBJTYPE_IP_TX].configMetadata,
                    },
                    ipAudTx: {
                        cfg: response[common_1.SNP_OBJTYPE_IP_AUD_TX].config,
                        meta: response[common_1.SNP_OBJTYPE_IP_AUD_TX].configMetadata,
                    },
                    ipAncTx: {
                        cfg: response[common_1.SNP_OBJTYPE_IP_ANC_TX].config,
                        meta: response[common_1.SNP_OBJTYPE_IP_ANC_TX].configMetadata,
                    },
                    ipRxSetup: {
                        cfg: response[common_1.SNP_OBJTYPE_IP_RX_SETUP].config,
                        meta: response[common_1.SNP_OBJTYPE_IP_RX_SETUP].configMetadata,
                    },
                },
                statuses: {
                    ipVidTx: {
                        status: response[common_1.SNP_OBJTYPE_IP_TX].status,
                        meta: response[common_1.SNP_OBJTYPE_IP_TX].statusMetadata,
                    },
                    ipAudTx: {
                        status: response[common_1.SNP_OBJTYPE_IP_AUD_TX].status,
                        meta: response[common_1.SNP_OBJTYPE_IP_AUD_TX].statusMetadata,
                    },
                    ipAncTx: {
                        status: response[common_1.SNP_OBJTYPE_IP_ANC_TX].status,
                        meta: response[common_1.SNP_OBJTYPE_IP_ANC_TX].statusMetadata,
                    },
                    ipRxSetup: {
                        status: response[common_1.SNP_OBJTYPE_IP_RX_SETUP].status,
                        meta: response[common_1.SNP_OBJTYPE_IP_RX_SETUP].statusMetadata,
                    },
                },
            };
            _this.fmeListSrv.msgStatusSubscribe(_this.controllerHandlers.onStatusUpdate, _this.data.requests.statuses);
            _this.aliasInTemplate("configs", _this.data.response.configs);
            _this.aliasInTemplate("status", _this.data.response.statuses);
        }, function (error) {
            // if getObjects failed reload
            _this.timeoutPromise = _this.$timeout(_this.loadData, 1500);
        });
    };
    CfgElementIpControlController.prototype.initControllerHandlers = function () {
        var _this = this;
        // placeholder for controller callbacks
        this.controllerHandlers.onStatusUpdate = function (status) {
            if (status.fme_ip !== _this.fmeIp) {
                // not this element
                return;
            }
            if (common_1.SNP_OBJTYPE_IP_TX === status.object_ID) {
                _this.data.response.statuses.ipVidTx.status = status;
            }
            else if (common_1.SNP_OBJTYPE_IP_AUD_TX === status.object_ID) {
                _this.data.response.statuses.ipAudTx.status = status;
            }
            else if (common_1.SNP_OBJTYPE_IP_ANC_TX === status.object_ID) {
                _this.data.response.statuses.ipAncTx.status = status;
            }
            else if (common_1.SNP_OBJTYPE_IP_RX_SETUP === status.object_ID) {
                _this.data.response.statuses.ipRxSetup.status = status;
            }
        };
    };
    CfgElementIpControlController.prototype.initApplyButtons = function () {
        var _this = this;
        var applyAll = function () {
            var partialVidTx = angular_1.copy(_this.data.response.configs.ipVidTx.cfg);
            delete partialVidTx.ipVidTxCtrl;
            var partialAudTx = angular_1.copy(_this.data.response.configs.ipAudTx.cfg);
            delete partialAudTx.ipAudTxCtrl;
            delete partialAudTx.AudTxRouting;
            var partialAncTx = angular_1.copy(_this.data.response.configs.ipAncTx.cfg);
            delete partialAncTx.ipAncTxCtrl;
            return _this.commonUtils
                .allCompletePromise([
                _this.snpListSrv.applyPartialUpdate(partialVidTx, function (report) {
                    _this.reports.ipVidTx = report;
                }),
                _this.snpListSrv.applyPartialUpdate(partialAudTx, function (report) {
                    _this.reports.ipAudTx = report;
                }),
                _this.snpListSrv.applyPartialUpdate(partialAncTx, function (report) {
                    _this.reports.ipAncTx = report;
                }),
                _this.snpListSrv.applyPartialUpdate(_this.data.response.configs.ipRxSetup.cfg, function (report) {
                    _this.reports.ipRxSetup = report;
                }),
            ])
                .then(function (_) {
                // _ means noname param
                _this.topForm.$setPristine();
            });
        };
        this.applyButtons.push({
            label: "Apply IP Control",
            isDisabled: function () {
                return !_this.topForm || _this.topForm.$pristine;
            },
            click: applyAll,
        });
    };
    CfgElementIpControlController.prototype.initEventHandlers = function () {
        // placeholder for template callbacks for clicks, validation, change, etc
        // placeholder
    };
    CfgElementIpControlController.prototype.initVisibilityHandlers = function () {
        var _this = this;
        // placeholder for template callbacks for ng-if, ng-show, etc
        this.$scope.isIpControlTabContentVisible = function () {
            // refactor if needed
            var result = _this.data.response.configs && _this.data.response.statuses;
            if (!result) {
                console.error("isIpControlTabContentVisible: nothing to show", _this.data.response);
                return;
            }
            return result;
        };
    };
    // angular lifecycle methods below
    CfgElementIpControlController.prototype.$onInit = function () {
        this.loadData();
        this.initControllerHandlers();
        this.initApplyButtons();
        this.initEventHandlers();
        this.initVisibilityHandlers();
    };
    // own tab methods below
    CfgElementIpControlController.prototype.updateTabDataOnRemoteFmm = function (fmeIp) {
        var isFmeIpChanged = fmeIp.previousValue !== fmeIp.currentValue;
        if (!this.selfHost && isFmeIpChanged) {
            this.loadData();
        }
    };
    return CfgElementIpControlController;
}(base_tab_controller_1.AbstractBaseTabController));
exports.CfgElementIpControlController = CfgElementIpControlController;


/***/ }),

/***/ "./app/config-menu/element/ip-control/ip-control.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/element/ip-control/ip-control.template.html?96c55d0add3ac29335a67eec773d2be2";

/***/ }),

/***/ "./app/config-menu/element/reference/reference.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var reference_controller_1 = __webpack_require__("./app/config-menu/element/reference/reference.controller.ts");
var templateUrl = __webpack_require__("./app/config-menu/element/reference/reference.template.html");
exports.configElementReferenceComponent = {
    bindings: {
        fmeIp: "<",
        tabState: "=",
        applyButtons: "=",
        dbg: "<",
        isDirty: "="
    },
    templateUrl: templateUrl,
    controller: reference_controller_1.default
};


/***/ }),

/***/ "./app/config-menu/element/reference/reference.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var base_tab_controller_1 = __webpack_require__("./app/common/base-tab.controller.ts");
var common_1 = __webpack_require__("./app/view-menu/common.js");
var CfgElementReferenceController = (function (_super) {
    __extends(CfgElementReferenceController, _super);
    function CfgElementReferenceController($timeout, fmeListSrv, snpListSrv, userManagerSrv, $scope, liveParamsSrv) {
        var _this = _super.call(this, $scope) || this;
        _this.$timeout = $timeout;
        _this.fmeListSrv = fmeListSrv;
        _this.snpListSrv = snpListSrv;
        _this.userManagerSrv = userManagerSrv;
        _this.$scope = $scope;
        _this.liveParamsSrv = liveParamsSrv;
        _this.reports = {
            genlock: undefined,
            ptp: undefined,
        };
        _this.reportError = {
            genlock: false,
            ptp: false,
        };
        _this.sys_status = {
            SNP_HW_Stats: {
                Chassis: 0
            }
        };
        _this.$doCheck = function () {
            _this.isDirty =
                (!!_this.ptpForm && _this.ptpForm.$dirty) ||
                    (!!_this.genlockForm && _this.genlockForm.$dirty);
            var isFormValid = angular_1.isUndefined(_this.topForm) || _this.topForm.$valid;
            var isReportError = false;
            Object.keys(_this.reportError).forEach(function (key) {
                isReportError = isReportError || _this.reportError[key];
            });
            _this.tabState.valid = isFormValid && !isReportError;
        };
        _this.$onChanges = function (changes) {
            _this.updateTabDataOnRemoteFmm(changes.fmeIp);
        };
        _this.$onDestroy = function () {
            if (_this.data.requests.statuses) {
                _this.fmeListSrv.msgStatusUnsubscribe(_this.controllerHandlers.onStatusUpdate, _this.data.requests.statuses);
            }
            if (_this.liveUpdater) {
                _this.liveUpdater.release();
            }
            if (_this.timeoutPromise)
                _this.$timeout.cancel(_this.timeoutPromise);
        };
        _this.validateUTCTime = function () {
            // --- Expecting 2YYY-MM-DD HH:MM:SS
            var regex = new RegExp('^[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}$');
            var UTCTime = _this.data.response.configs.ptp.cfg.ptpMaster.ptpUtcTime;
            var errMsg = "";
            if (UTCTime == "") {
                // --- Blank UTC Time is okay!
            }
            else if (regex.test(UTCTime)) {
                var YYYY = parseInt(UTCTime.substring(0, 4), 10);
                var MM = parseInt(UTCTime.substring(5, 7), 10);
                var DD = parseInt(UTCTime.substring(8, 10), 10);
                var hh = parseInt(UTCTime.substring(11, 13), 10);
                var mm = parseInt(UTCTime.substring(14, 16), 10);
                var ss = parseInt(UTCTime.substring(17, 19), 10);
                if (YYYY < 1971 || YYYY > 2037) {
                    errMsg = "Year (YYYY) must be from 1971 to 2037.";
                }
                else if (MM < 1 || MM > 12) {
                    errMsg = "Month (MM) must be from 01 to 12.";
                }
                else if (DD < 1 || DD > 31) {
                    errMsg = "Day (DD) must be from 01 to 31.";
                }
                else if (hh < 0 || hh > 23) {
                    errMsg = "Hour (hh) must be from 00 to 23.";
                }
                else if (mm < 0 || mm > 59) {
                    errMsg = "Minutes (mm) must be from 00 to 59.";
                }
                else if (ss < 0 || ss > 59) {
                    errMsg = "Seconds (ss) must be from 00 to 59.";
                }
            }
            else {
                errMsg = "Invalid format for date.  Expecting \"YYYY-MM-DD hh:mm:ss\"";
            }
            if (errMsg == "") {
                return [];
            }
            return [
                {
                    type: "error",
                    msg: errMsg
                }
            ];
        };
        _this.isSNPXL = function () {
            // --- Check chassis === 2 (SNP XL)
            var isChassisXL = _this.sys_status.SNP_HW_Stats.Chassis === common_1.SNP_XL;
            return isChassisXL;
        };
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
        return _this;
    }
    // inherited base methods below
    CfgElementReferenceController.prototype.loadData = function () {
        var _this = this;
        this.data.requests = {
            configs: [
                {
                    type: common_1.SNP_OBJTYPE_GENLOCK,
                    object_ID: common_1.SNP_OBJID_GENLOCK,
                },
                {
                    type: common_1.SNP_OBJTYPE_PTP,
                    object_ID: common_1.SNP_OBJTYPE_PTP,
                },
            ],
            statuses: [
                {
                    fme_ip: this.fmeIp,
                    type: common_1.SNP_OBJTYPE_PTP,
                    object_ID: common_1.SNP_OBJTYPE_PTP,
                },
                {
                    fme_ip: this.fmeIp,
                    type: common_1.SNP_OBJTYPE_GENLOCK,
                    object_ID: common_1.SNP_OBJID_GENLOCK,
                },
                {
                    fme_ip: this.fmeIp,
                    type: common_1.SNP_OBJTYPE_SYSTEM,
                    object_ID: common_1.SNP_OBJTYPE_SYSTEM,
                },
            ],
        };
        if (this.data.requests.statuses) {
            this.fmeListSrv.msgStatusUnsubscribe(this.controllerHandlers.onStatusUpdate, this.data.requests.statuses);
        }
        this.snpListSrv.getObjects(this.fmeIp, this.data.requests.configs).then(function (response) {
            _this.data.response = {
                configs: {
                    genlock: {
                        cfg: response[common_1.SNP_OBJID_GENLOCK].config,
                        meta: response[common_1.SNP_OBJID_GENLOCK].configMetadata,
                    },
                    ptp: {
                        cfg: response[common_1.SNP_OBJTYPE_PTP].config,
                        meta: response[common_1.SNP_OBJTYPE_PTP].configMetadata,
                    },
                },
                statuses: {
                    genlock: {
                        status: response[common_1.SNP_OBJID_GENLOCK].status,
                        meta: response[common_1.SNP_OBJID_GENLOCK].statusMetadata,
                    },
                    ptp: {
                        status: response[common_1.SNP_OBJTYPE_PTP].status,
                        meta: response[common_1.SNP_OBJTYPE_PTP].statusMetadata,
                    },
                },
            };
            _this.liveUpdater = _this.liveParamsSrv.liveParamsUpdater(_this.data.response.configs.ptp.cfg, _this.data.response.configs.ptp.meta);
            _this.aliasInTemplate("configs", _this.data.response.configs);
            _this.aliasInTemplate("status", _this.data.response.statuses);
            _this.fmeListSrv.msgStatusSubscribe(_this.controllerHandlers.onStatusUpdate, _this.data.requests.statuses);
        }, function (error) {
            // if getObjects failed reload
            _this.timeoutPromise = _this.$timeout(_this.loadData, 1500);
        });
    };
    ;
    CfgElementReferenceController.prototype.initControllerHandlers = function () {
        var _this = this;
        this.controllerHandlers.onStatusUpdate = function (status) {
            if (status.fme_ip !== _this.fmeIp) {
                // not this element
                return;
            }
            if (common_1.SNP_OBJTYPE_PTP === status.object_ID) {
                _this.data.response.statuses.ptp.status = status;
            }
            if (common_1.SNP_OBJID_GENLOCK === status.object_ID) {
                _this.data.response.statuses.genlock.status = status;
            }
            if (common_1.SNP_OBJTYPE_SYSTEM === status.object_ID) {
                _this.sys_status = status;
            }
            _this.aliasInTemplate("status", _this.data.response.statuses);
        };
    };
    CfgElementReferenceController.prototype.initApplyButtons = function () {
        var _this = this;
        var applyGenlock = function () {
            return _this.snpListSrv.applyPartialUpdate(_this.data.response.configs.genlock.cfg, function (report) {
                _this.reports.genlock = report;
            }, _this.genlockForm);
        };
        var applyPTP = function () {
            var retVal = _this.snpListSrv.applyPartialUpdate(_this.data.response.configs.ptp.cfg, function (report) {
                _this.reports.ptp = report;
            }, _this.ptpForm);
            // --- Always blank out UTC Time after apply
            _this.data.response.configs.ptp.cfg.ptpMaster.ptpUtcTime = "";
            return retVal;
        };
        this.applyButtons.push({
            label: "Apply Genlock",
            isDisabled: function () {
                return !_this.genlockForm || _this.genlockForm.$pristine;
            },
            click: applyGenlock,
        }, {
            label: "Apply PTP",
            isDisabled: function () {
                return !_this.ptpForm || _this.ptpForm.$pristine;
            },
            click: applyPTP,
        });
    };
    CfgElementReferenceController.prototype.initEventHandlers = function () {
        var _this = this;
        // placeholder for template callbacks for clicks, validation, change, etc
        this.templateHandlers.liveControlCallback = function (param, value) {
            if (_this.liveUpdater) {
                _this.liveUpdater.onUserInteraction(param, value);
            }
        };
        this.templateHandlers.onToggleJamNTPNow = function (param, value) {
            _this.liveUpdater.onUserInteraction(param, true);
        };
    };
    CfgElementReferenceController.prototype.initVisibilityHandlers = function () {
        var _this = this;
        this.$scope.isRefTabContentVisible = function () {
            // refactor if needed
            return _this.data.response.configs && _this.data.response.statuses;
        };
    };
    // angular lifecycle methods below
    CfgElementReferenceController.prototype.$onInit = function () {
        this.loadData();
        this.initControllerHandlers();
        this.initApplyButtons();
        this.initEventHandlers();
        this.initVisibilityHandlers();
    };
    // own tab methods below
    CfgElementReferenceController.prototype.updateTabDataOnRemoteFmm = function (fmeIp) {
        var isFmeIpChanged = fmeIp.previousValue !== fmeIp.currentValue;
        if (!this.selfHost && isFmeIpChanged) {
            this.loadData();
        }
    };
    return CfgElementReferenceController;
}(base_tab_controller_1.AbstractBaseTabController));
exports.default = CfgElementReferenceController;


/***/ }),

/***/ "./app/config-menu/element/reference/reference.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/element/reference/reference.template.html?0b48bd3980166c4d6bebf3437d58c391";

/***/ }),

/***/ "./app/config-menu/element/snp-management/snp-management.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var snp_management_controller_1 = __webpack_require__("./app/config-menu/element/snp-management/snp-management.controller.ts");
var templateUrl = __webpack_require__("./app/config-menu/element/snp-management/snp-management.template.html");
exports.CfgElementSNPComponent = {
    bindings: {
        fmeIp: "<",
        tabState: "=",
        applyButtons: "=",
        dbg: "<",
        isDirty: "="
    },
    templateUrl: templateUrl,
    controller: snp_management_controller_1.CfgElementSnpController
};


/***/ }),

/***/ "./app/config-menu/element/snp-management/snp-management.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var base_tab_controller_1 = __webpack_require__("./app/common/base-tab.controller.ts");
var common_1 = __webpack_require__("./app/view-menu/common.js");
var CfgElementSnpController = (function (_super) {
    __extends(CfgElementSnpController, _super);
    function CfgElementSnpController($scope, $timeout, fmeListSrv, snpListSrv, userManagerSrv, uiModalsSrv, errorSrv) {
        var _this = _super.call(this, $scope) || this;
        _this.$scope = $scope;
        _this.$timeout = $timeout;
        _this.fmeListSrv = fmeListSrv;
        _this.snpListSrv = snpListSrv;
        _this.userManagerSrv = userManagerSrv;
        _this.uiModalsSrv = uiModalsSrv;
        _this.errorSrv = errorSrv;
        _this.reports = {
            nmos: undefined,
            sqm: undefined,
            gpi: undefined,
            system: undefined
        };
        _this.reportError = {
            placeholder: null,
        };
        _this.devicesChanged = false;
        _this.gpiChanged = false;
        _this.$doCheck = function () {
            _this.isDirty =
                (!!_this.ntpForm && _this.ntpForm.$dirty) ||
                    (!!_this.lrcForm && _this.lrcForm.$dirty) ||
                    (!!_this.nmosForm && _this.nmosForm.$dirty) ||
                    _this.devicesChanged ||
                    _this.gpiChanged ?
                    true :
                    false;
            _this.tabState.valid = angular_1.isUndefined(_this.topForm) || _this.topForm.$valid;
        };
        _this.$onChanges = function (changes) {
            _this.updateTabDataOnRemoteFmm(changes.fmeIp);
        };
        _this.$onDestroy = function () {
            if (_this.data.requests.statuses) {
                _this.fmeListSrv.msgStatusUnsubscribe(_this.controllerHandlers.onStatusUpdate, _this.data.requests.statuses);
            }
            if (_this.timeoutPromise)
                _this.$timeout.cancel(_this.timeoutPromise);
        };
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
        return _this;
    }
    // inherited base methods below
    CfgElementSnpController.prototype.loadData = function () {
        var _this = this;
        // placeholder for loading data to scope, etc;
        this.data.requests = {
            configs: [
                {
                    type: common_1.SNP_OBJTYPE_WAN,
                    object_ID: common_1.SNP_OBJTYPE_WAN,
                },
                {
                    type: common_1.SNP_OBJTYPE_SYSTEM,
                    object_ID: common_1.SNP_OBJTYPE_SYSTEM,
                    getStatus: false,
                },
                {
                    type: common_1.SNP_OBJTYPE_SQM,
                    object_ID: common_1.SNP_OBJTYPE_SQM,
                    getStatus: false,
                },
                {
                    type: common_1.SNP_OBJTYPE_GPI,
                    object_ID: common_1.SNP_OBJTYPE_GPI,
                    getStatus: false,
                },
            ],
            statuses: [
                {
                    fme_ip: this.fmeIp,
                    type: common_1.SNP_OBJTYPE_WAN,
                    object_ID: common_1.SNP_OBJTYPE_WAN,
                },
                {
                    fme_ip: this.fmeIp,
                    type: common_1.SNP_OBJTYPE_SQM,
                    object_ID: common_1.SNP_OBJTYPE_SQM,
                },
                {
                    fme_ip: this.fmeIp,
                    type: common_1.SNP_OBJTYPE_GPI,
                    object_ID: common_1.SNP_OBJTYPE_GPI,
                },
            ],
        };
        if (this.data.requests.statuses) {
            this.fmeListSrv.msgStatusUnsubscribe(this.controllerHandlers.onStatusUpdate, this.data.requests.statuses);
        }
        this.snpListSrv.getObjects(this.fmeIp, this.data.requests.configs).then(function (response) {
            _this.data.response = {
                configs: {
                    wan: {
                        cfg: response[common_1.SNP_OBJTYPE_WAN].config,
                        meta: response[common_1.SNP_OBJTYPE_WAN].configMetadata,
                    },
                    sqm: {
                        cfg: response[common_1.SNP_OBJTYPE_SQM].config,
                        meta: response[common_1.SNP_OBJTYPE_SQM].configMetadata,
                    },
                    system: {
                        cfg: response[common_1.SNP_OBJTYPE_SYSTEM].config,
                        meta: response[common_1.SNP_OBJTYPE_SYSTEM].configMetadata,
                    },
                    gpi: {
                        cfg: response[common_1.SNP_OBJTYPE_GPI].config,
                        meta: response[common_1.SNP_OBJTYPE_GPI].configMetadata,
                    },
                },
                statuses: {
                    wan: {
                        status: response[common_1.SNP_OBJTYPE_WAN].status,
                        meta: response[common_1.SNP_OBJTYPE_WAN].statusMetadata,
                    },
                    gpi: {
                        status: response[common_1.SNP_OBJTYPE_GPI].status,
                        meta: response[common_1.SNP_OBJTYPE_GPI].statusMetadata,
                    },
                },
            };
            // console.log("tab data", this.data.response);
            _this.templateHandlers.updateGPIMappingsMetadata();
            _this.fmeListSrv.msgStatusSubscribe(_this.controllerHandlers.onStatusUpdate, _this.data.requests.statuses);
            _this.aliasInTemplate("configs", _this.data.response.configs);
            _this.aliasInTemplate("status", _this.data.response.statuses);
        }, function (error) {
            // if getObjects failed reload
            console.error("tab not data loaded from snp");
            _this.timeoutPromise = _this.$timeout(_this.loadData, 1500);
        });
    };
    CfgElementSnpController.prototype.initControllerHandlers = function () {
        var _this = this;
        this.controllerHandlers.onStatusUpdate = function (status) {
            var isAsyncCheckPassed = _this.$scope.status !== undefined;
            if (!isAsyncCheckPassed)
                return;
            if (status.object_ID === common_1.SNP_OBJTYPE_WAN) {
                var _a = status.ipWanStatus, systemServer = _a.systemServer, registrationServer = _a.registrationServer;
                console.log(systemServer, registrationServer);
                if (typeof systemServer == "string") {
                    status.ipWanStatus.systemServer = systemServer
                        .split(';')
                        .filter(function (server) { return server.length !== 0; });
                }
                else if (Array.isArray(systemServer)) {
                    status.ipWanStatus.systemServer = systemServer;
                }
                if (typeof registrationServer == "string") {
                    status.ipWanStatus.registrationServer = registrationServer
                        .split(';')
                        .filter(function (server) { return server.length !== 0; });
                }
                else if (Array.isArray(registrationServer)) {
                    status.ipWanStatus.registrationServer = registrationServer;
                }
                _this.$scope.status.wan.status = status;
            }
        };
    };
    CfgElementSnpController.prototype.initApplyButtons = function () {
        var _this = this;
        var applyExtDevices = function () {
            var updatePromises = [];
            var partial = angular_1.copy(_this.data.response.configs.wan.cfg);
            delete partial.ipWan;
            _this.snpListSrv.applyPartialUpdate(partial, function (report) {
                if (!report) {
                    _this.lrcForm.$setPristine();
                    _this.ntpForm.$setPristine();
                    _this.nmosForm.$setPristine();
                    _this.devicesChanged = false;
                }
                _this.reports.nmos = report;
            }), _this.nmosForm;
            var partial2 = angular_1.copy(_this.data.response.configs.system.cfg);
            // --- Remove groupings not on this GUI page
            delete partial2.License_Tokens;
            delete partial2.System_Control;
            delete partial2.AAP_Algorithms;
            _this.snpListSrv.applyPartialUpdate(partial2, function (report) {
                if (!report) {
                    _this.devicesChanged = false;
                }
                _this.reports.system = report;
            }), _this.nmosForm;
        };
        var applySQM = function () {
            return _this.snpListSrv.applyPartialUpdate(_this.data.response.configs.sqm.cfg, function (report) {
                _this.reports.sqm = report;
            }, _this.sqmForm);
        };
        var applyGPI = function () {
            var partial = angular_1.copy(_this.data.response.configs.gpi.cfg);
            return _this.snpListSrv.applyPartialUpdate(partial, function (report) {
                if (!report) {
                    _this.gpiChanged = false;
                }
                _this.reports.gpi = report;
            });
        };
        this.applyButtons.push({
            label: "Apply SNP Config",
            isDisabled: function () {
                return ((!_this.nmosForm || _this.nmosForm.$pristine) &&
                    (!_this.lrcForm || _this.lrcForm.$pristine) &&
                    (!_this.ntpForm || _this.ntpForm.$pristine) &&
                    !_this.devicesChanged);
            },
            click: applyExtDevices,
        }, {
            label: "Apply GPI",
            isDisabled: function () {
                return !_this.gpiChanged;
            },
            click: applyGPI,
        }, {
            label: "Apply SQM",
            isDisabled: function () {
                return !_this.sqmForm || _this.sqmForm.$pristine;
            },
            click: applySQM,
        });
    };
    CfgElementSnpController.prototype.validateMasterclock = function (data, devices) {
        var sameClockNumber = devices.filter(function (dev) { return dev.clockNumber == data.clockNumber; });
        var isUnique = true;
        if (sameClockNumber.length) {
            if (data.idx !== undefined) {
                isUnique = sameClockNumber.filter(function (dev) { return dev.idx != data.idx; }).length == 0;
            }
            else {
                isUnique = false;
            }
        }
        if (!isUnique) {
            return "Clock number must be unique";
        }
    };
    CfgElementSnpController.prototype.showGPIField = function (property, data) {
        if (property === "eboxPassword") {
            return data.deviceType === "JLCooper eBOX";
        }
        else if (property === "modbusID" || property === "modbusChAddr" || property === "modbusChCnt") {
            return data.deviceType === "Generic Modbus";
        }
        else {
            return true;
        }
    };
    CfgElementSnpController.prototype.initEventHandlers = function () {
        // placeholder for template callbacks for clicks, validation, change, etc
        var _this = this;
        this.templateHandlers.openAddDeviceModal = function (type, data) {
            if (data === void 0) { data = null; }
            var meta;
            var devices;
            var validationFunc;
            if (type === "tsl") {
                meta = _this.data.response.configs.wan.meta.properties.tslDevice;
                devices = _this.data.response.configs.wan.cfg.tslDevice;
            }
            else if (type === "plura") {
                meta = _this.data.response.configs.wan.meta.properties.pluraDevice;
                devices = _this.data.response.configs.wan.cfg.pluraDevice;
            }
            else if (type === "masterclock") {
                meta = _this.data.response.configs.wan.meta.properties.masterclockDevice;
                devices = _this.data.response.configs.wan.cfg.masterclockDevice;
                validationFunc = _this.validateMasterclock;
            }
            else if (type === "dakrtd") {
                meta = _this.data.response.configs.wan.meta.properties.dakRtdDevice;
                devices = _this.data.response.configs.wan.cfg.dakRtdDevice;
            }
            _this.uiModalsSrv
                .openAddExternalDeviceModal({
                type: type,
                meta: meta,
                data: data,
                devices: devices,
                validationFunc: validationFunc
            })
                .result.then(function (result) {
                if (result) {
                    if (type === "tsl") {
                        if (result.idx || result.idx === 1) {
                            _this.data.response.configs.wan.cfg.tslDevice.forEach(function (item, i, arr) {
                                if (item.idx === result.idx) {
                                    arr[i] = result;
                                }
                            });
                        }
                        else {
                            var freeIdx_1 = 1;
                            _this.data.response.configs.wan.cfg.tslDevice.forEach(function (item) {
                                if (freeIdx_1 >= item.idx) {
                                    freeIdx_1++;
                                }
                            });
                            result.idx = freeIdx_1;
                            _this.data.response.configs.wan.cfg.tslDevice.push(result);
                        }
                    }
                    else if (type === "plura") {
                        if (result.idx || result.idx === 1) {
                            _this.data.response.configs.wan.cfg.pluraDevice.forEach(function (item, i, arr) {
                                if (item.idx === result.idx) {
                                    arr[i] = result;
                                }
                            });
                        }
                        else {
                            var freeIdx_2 = 1;
                            _this.data.response.configs.wan.cfg.pluraDevice.forEach(function (item) {
                                if (freeIdx_2 >= item.idx) {
                                    freeIdx_2++;
                                }
                            });
                            result.idx = freeIdx_2;
                            _this.data.response.configs.wan.cfg.pluraDevice.push(result);
                        }
                    }
                    else if (type === "masterclock") {
                        if (result.idx || result.idx === 1) {
                            _this.data.response.configs.wan.cfg.masterclockDevice.forEach(function (item, i, arr) {
                                if (item.idx === result.idx) {
                                    arr[i] = result;
                                }
                            });
                        }
                        else {
                            var freeIdx_3 = 1;
                            _this.data.response.configs.wan.cfg.masterclockDevice.forEach(function (item) {
                                if (freeIdx_3 >= item.idx) {
                                    freeIdx_3++;
                                }
                            });
                            result.idx = freeIdx_3;
                            _this.data.response.configs.wan.cfg.masterclockDevice.push(result);
                        }
                    }
                    else if (type === "dakrtd") {
                        if (result.idx || result.idx === 1) {
                            _this.data.response.configs.wan.cfg.dakRtdDevice.forEach(function (item, i, arr) {
                                if (item.idx === result.idx) {
                                    arr[i] = result;
                                }
                            });
                        }
                        else {
                            var freeIdx_4 = 1;
                            _this.data.response.configs.wan.cfg.dakRtdDevice.forEach(function (item) {
                                if (freeIdx_4 >= item.idx) {
                                    freeIdx_4++;
                                }
                            });
                            result.idx = freeIdx_4;
                            _this.data.response.configs.wan.cfg.dakRtdDevice.push(result);
                        }
                    }
                    _this.devicesChanged = true;
                }
            });
        };
        this.templateHandlers.removeDevice = function (type, idx) {
            if (type === "tsl") {
                _this.data.response.configs.wan.cfg.tslDevice.forEach(function (item) {
                    if (item.idx == idx) {
                        // Set the table entry 'delete' field to true
                        item.delete = true;
                    }
                });
                _this.devicesChanged = true;
            }
            else if (type === "plura") {
                _this.data.response.configs.wan.cfg.pluraDevice.forEach(function (item) {
                    if (item.idx == idx) {
                        // Set the table entry 'delete' field to true
                        item.delete = true;
                    }
                });
                _this.devicesChanged = true;
            }
            else if (type === "masterclock") {
                _this.data.response.configs.wan.cfg.masterclockDevice.forEach(function (item) {
                    if (item.idx == idx) {
                        // Set the table entry 'delete' field to true
                        item.delete = true;
                    }
                });
                _this.devicesChanged = true;
            }
            else if (type === "dakrtd") {
                _this.data.response.configs.wan.cfg.dakRtdDevice.forEach(function (item) {
                    if (item.idx == idx) {
                        // Set the table entry 'delete' field to true
                        item.delete = true;
                    }
                });
                _this.devicesChanged = true;
            }
        };
        this.templateHandlers.onDeviceChanged = function (oldData, newData, p) {
            if (p === void 0) { p = _this; }
            //console.log(p);
            p.devicesChanged = true;
        };
        this.templateHandlers.updateGPIMappingsMetadata = function (p) {
            if (p === void 0) { p = _this; }
            if (p.data.response.configs.gpi.cfg.hasOwnProperty("gpiDevice")) {
                var devicesEnum_1 = [-1];
                var devicesEnumLabels_1 = ["None"];
                p.data.response.configs.gpi.cfg.gpiDevice.forEach(function (device) {
                    devicesEnum_1.push(device.idx);
                    devicesEnumLabels_1.push(device.name);
                });
                if (p.data.response.configs.gpi.meta.properties.hasOwnProperty("inputMapping")) {
                    p.data.response.configs.gpi.meta.properties.inputMapping.items.properties.gpiDevice.enum = devicesEnum_1;
                    p.data.response.configs.gpi.meta.properties.inputMapping.items.properties.gpiDevice.enumLabels = devicesEnumLabels_1;
                }
                if (p.data.response.configs.gpi.meta.properties.hasOwnProperty("outputMapping")) {
                    p.data.response.configs.gpi.meta.properties.outputMapping.items.properties.gpiDevice.enum = devicesEnum_1;
                    p.data.response.configs.gpi.meta.properties.outputMapping.items.properties.gpiDevice.enumLabels = devicesEnumLabels_1;
                }
            }
        };
        this.templateHandlers.onGPIChanged = function (oldData, newData, p) {
            if (p === void 0) { p = _this; }
            p.gpiChanged = true;
            p.templateHandlers.updateGPIMappingsMetadata();
        };
        // Gets run when the user hits 'Submit' on the GPI I/O mapping modal
        this.templateHandlers.validateGPIMapping = (function (changedValue, devices) {
            var containsDuplicates = _this.data.response.configs.gpi.cfg.inputMapping.some(function (item) {
                // Duplicate if item not deleted, device has been selected and all other fields are the same
                return item.idx !== changedValue.idx &&
                    (item.delete === false || item.delete === undefined) &&
                    (changedValue.gpiDevice !== -1 && item.gpiDevice === changedValue.gpiDevice) &&
                    item.procIndex === changedValue.procIndex &&
                    item.procGpiNumber === changedValue.procGpiNumber &&
                    item.gpiNumber === changedValue.gpiNumber;
            });
            if (containsDuplicates)
                return "GPI mapping already exists for the chosen GPI Device. Update mapping values before submitting.";
        });
        this.templateHandlers.validateGPOMapping = (function (changedValue, devices) {
            var containsDuplicates = _this.data.response.configs.gpi.cfg.outputMapping.some(function (item) {
                // For outputs, only check if device indexes are the same as we can't have multiple logical outputs mapped to the same physcial output
                return item.idx !== changedValue.idx &&
                    (item.delete === false || item.delete === undefined) &&
                    (changedValue.gpiDevice !== -1 && item.gpiDevice === changedValue.gpiDevice) &&
                    item.gpiNumber === changedValue.gpiNumber;
            });
            if (containsDuplicates)
                return "GPO mapping already exists for the chosen GPI Device. Update mapping values before submitting.";
            var gpiDevice = _this.data.response.configs.gpi.cfg.gpiDevice.filter(function (dev) { return dev.idx == changedValue.gpiDevice; });
            var isEBox = false;
            if (gpiDevice.length) {
                isEBox = gpiDevice.filter(function (dev) { return dev.deviceType == "JLCooper eBOX"; }).length > 0;
            }
            if (isEBox && changedValue.gpiNumber > 24) {
                return "JLCooper eBOX only supports up to 24 physical GPI inputs/outputs";
            }
        });
        this.templateHandlers.validateSQM = function (changedValue) {
            var regularExpression = /^(\b[0-9a-f]{1,2}\b)+$/gi; // TDL: simplify regexp if needed
            if (!changedValue) {
                return [
                    {
                        type: _this.errorSrv.MSG_ERROR,
                        msg: "DID/SDID value should not be empty",
                    },
                ];
            }
            if (!regularExpression.test(changedValue)) {
                return [
                    {
                        type: _this.errorSrv.MSG_ERROR,
                        msg: "DID/SDID value should contain no more then 2 characters from range a-f A-F 0-9",
                    },
                ];
            }
            else {
                return [];
            }
        };
    };
    CfgElementSnpController.prototype.initVisibilityHandlers = function () {
        var _this = this;
        // placeholder for template callbacks for ng-if, ng-show, etc
        this.$scope.showIndex = function (first, last) {
            if (first === true && last === true) {
                return false;
            } // don't show here
            else
                return true;
        };
        this.$scope.isSnpTabContentVisible = function () {
            // refactor if needed
            var isVisible = _this.data.response ? true : false;
            return isVisible;
        };
        this.$scope.isExternalDeviceVisible = function (toDelete) {
            var isVisible = toDelete ? false : true;
            return isVisible;
        };
    };
    // angular lifecycle methods below
    CfgElementSnpController.prototype.$onInit = function () {
        this.loadData();
        this.initControllerHandlers();
        this.initApplyButtons();
        this.initEventHandlers();
        this.initVisibilityHandlers();
    };
    // own tab methods below
    CfgElementSnpController.prototype.updateTabDataOnRemoteFmm = function (fmeIp) {
        var isFmeIpChanged = fmeIp.previousValue !== fmeIp.currentValue;
        if (!this.selfHost && isFmeIpChanged) {
            this.loadData();
        }
    };
    return CfgElementSnpController;
}(base_tab_controller_1.AbstractBaseTabController));
exports.CfgElementSnpController = CfgElementSnpController;


/***/ }),

/***/ "./app/config-menu/element/snp-management/snp-management.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/element/snp-management/snp-management.template.html?717f7510ec8b7a882888ee7d8a6acd3b";

/***/ }),

/***/ "./app/config-menu/element/system/system.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var system_controller_1 = __webpack_require__("./app/config-menu/element/system/system.controller.ts");
var templateUrl = __webpack_require__("./app/config-menu/element/system/system.template.html");
exports.CfgElementSnpSystemComponent = {
    bindings: {
        fmeIp: "<",
        tabState: "=",
        applyButtons: "=",
        dbg: "<"
    },
    templateUrl: templateUrl,
    controller: system_controller_1.CfgElementSnpSystemController
};


/***/ }),

/***/ "./app/config-menu/element/system/system.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var base_tab_controller_1 = __webpack_require__("./app/common/base-tab.controller.ts");
var common_1 = __webpack_require__("./app/view-menu/common.js");
var CfgElementSnpSystemController = (function (_super) {
    __extends(CfgElementSnpSystemController, _super);
    function CfgElementSnpSystemController($scope, $timeout, fmeListSrv, snpListSrv, userManagerSrv, liveParamsSrv) {
        var _this = _super.call(this, $scope) || this;
        _this.$scope = $scope;
        _this.$timeout = $timeout;
        _this.fmeListSrv = fmeListSrv;
        _this.snpListSrv = snpListSrv;
        _this.userManagerSrv = userManagerSrv;
        _this.liveParamsSrv = liveParamsSrv;
        _this.report = {
            sys: undefined
        };
        _this.$doCheck = function () { };
        _this.$onChanges = function (changes) {
            _this.updateTabDataOnRemoteFmm(changes.fmeIp);
        };
        _this.$onDestroy = function () {
            if (_this.data.requests.statuses) {
                _this.fmeListSrv.msgStatusUnsubscribe(_this.controllerHandlers.onStatusUpdate, _this.data.requests.statuses);
            }
            if (_this.liveUpdater) {
                _this.liveUpdater.release();
            }
            if (_this.timeoutPromise)
                _this.$timeout.cancel(_this.timeoutPromise);
        };
        _this.isSNPXL = function () {
            // --- Check chassis === 2 (SNP XL)
            var isChassisXL = _this.data.response.statuses.system.status.SNP_HW_Stats.Chassis === common_1.SNP_XL;
            return isChassisXL;
        };
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
        return _this;
    }
    // inherited base methods below
    CfgElementSnpSystemController.prototype.loadData = function () {
        var _this = this;
        // placeholder for loading data to scope, etc;
        this.data.requests = {
            configs: [
                {
                    type: common_1.SNP_OBJTYPE_SYSTEM,
                    object_ID: common_1.SNP_OBJTYPE_SYSTEM,
                    getConfig: true,
                },
            ],
            statuses: [
                {
                    fme_ip: this.fmeIp,
                    type: common_1.SNP_OBJTYPE_SYSTEM,
                    object_ID: common_1.SNP_OBJTYPE_SYSTEM,
                },
            ],
        };
        if (this.data.requests.statuses) {
            this.fmeListSrv.msgStatusUnsubscribe(this.controllerHandlers.onStatusUpdate, this.data.requests.statuses);
        }
        this.snpListSrv.getObjects(this.fmeIp, this.data.requests.configs).then(function (response) {
            _this.data.response = {
                configs: {
                    system: {
                        cfg: response[common_1.SNP_OBJTYPE_SYSTEM].config,
                        meta: response[common_1.SNP_OBJTYPE_SYSTEM].configMetadata,
                    },
                },
                statuses: {
                    system: {
                        status: response[common_1.SNP_OBJTYPE_SYSTEM].status,
                        meta: response[common_1.SNP_OBJTYPE_SYSTEM].statusMetadata,
                    },
                },
            };
            _this.liveUpdater = _this.liveParamsSrv.liveParamsUpdater(_this.data.response.configs.system.cfg, _this.data.response.configs.system.meta);
            _this.fmeListSrv.msgStatusSubscribe(_this.controllerHandlers.onStatusUpdate, _this.data.requests.statuses);
            if (_this.data.response.statuses.system.status.SNP_HW_Stats.Chassis === common_1.SNP_XL) {
                // --- SNP XL Chassis
                // --- Change the Metadata for "I/O Board Temperature" to "RX I/O Board Temperature"
                _this.data.response.statuses.system.meta.properties.Board_Temperatures.properties.IO_Board.title = "Rx I/O Board Ambient Temperature";
            }
            _this.aliasInTemplate("configs", _this.data.response.configs);
            _this.aliasInTemplate("status", _this.data.response.statuses);
        }, function (error) {
            // if getObjects failed reload
            _this.timeoutPromise = _this.$timeout(_this.loadData, 1500);
        });
    };
    CfgElementSnpSystemController.prototype.initControllerHandlers = function () {
        // placeholder for controller callbacks
        var _this = this;
        this.controllerHandlers.onStatusUpdate = function (status) {
            if (status.fme_ip !== _this.fmeIp) {
                // not this element
                return;
            }
            if (common_1.SNP_OBJTYPE_SYSTEM === status.object_ID) {
                _this.data.response.statuses.system.status = status;
            }
        };
    };
    CfgElementSnpSystemController.prototype.initApplyButtons = function () {
        var _this = this;
        var applyJamtime = function () {
            var partial = angular_1.copy(_this.data.response.configs.system.cfg);
            return _this.snpListSrv.applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.jamtimeForm);
        };
        var applyUnitname = function () {
            var partial = angular_1.copy(_this.data.response.configs.system.cfg);
            return _this.snpListSrv.applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.unitnameForm);
        };
        var IPFPGAmodeSelect = function () {
            var partial = angular_1.copy(_this.data.response.configs.system.cfg);
            return _this.snpListSrv.applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.IPFPGAselectForm);
        };
        this.applyButtons.push({
            label: "Apply IP FPGA Mode",
            isDisabled: function () {
                return !_this.IPFPGAselectForm || _this.IPFPGAselectForm.$pristine;
            },
            click: IPFPGAmodeSelect,
        }, {
            label: "Apply Jam Time",
            isDisabled: function () {
                return !_this.jamtimeForm || _this.jamtimeForm.$pristine;
            },
            click: applyJamtime,
        }, {
            label: "Apply Unit Name",
            isDisabled: function () {
                return !_this.unitnameForm || _this.unitnameForm.$pristine;
            },
            click: applyUnitname,
        });
    };
    CfgElementSnpSystemController.prototype.initEventHandlers = function () {
        var _this = this;
        // placeholder for template callbacks for clicks, validation, change, etc
        this.templateHandlers.liveControlCallback = function (param, value) {
            if (_this.liveUpdater) {
                _this.liveUpdater.onUserInteraction(param, value);
            }
        };
        this.templateHandlers.onToggleJamTimecodeButton = function (param, value) {
            _this.liveUpdater.onUserInteraction(param, true);
        };
        this.templateHandlers.onToggleVidMemRstButton = function (param, value) {
            _this.liveUpdater.onUserInteraction(param, true);
        };
    };
    CfgElementSnpSystemController.prototype.initVisibilityHandlers = function () {
        // placeholder for template callbacks for ng-if, ng-show, etc
        // hint for passing method to component scope
        // this.$scope.___ = () => {}
    };
    // angular lifecycle methods below
    CfgElementSnpSystemController.prototype.$onInit = function () {
        this.loadData();
        this.initControllerHandlers();
        this.initApplyButtons();
        this.initEventHandlers();
        this.initVisibilityHandlers();
    };
    // own tab methods below
    CfgElementSnpSystemController.prototype.updateTabDataOnRemoteFmm = function (fmeIp) {
        var isFmeIpChanged = fmeIp.previousValue !== fmeIp.currentValue;
        if (!this.selfHost && isFmeIpChanged) {
            this.loadData();
        }
    };
    return CfgElementSnpSystemController;
}(base_tab_controller_1.AbstractBaseTabController));
exports.CfgElementSnpSystemController = CfgElementSnpSystemController;


/***/ }),

/***/ "./app/config-menu/element/system/system.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/element/system/system.template.html?0d94ef3a03cc466cf152842a9cea176f";

/***/ }),

/***/ "./app/config-menu/element/wan/wan.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var wan_controller_1 = __webpack_require__("./app/config-menu/element/wan/wan.controller.ts");
var templateUrl = __webpack_require__("./app/config-menu/element/wan/wan.template.html");
exports.configElementWanComponent = {
    bindings: {
        fmeIp: "<",
        tabState: "=",
        applyButtons: "=",
        dbg: "<",
        isDirty: "="
    },
    templateUrl: templateUrl,
    controller: wan_controller_1.CfgElementWanController
};


/***/ }),

/***/ "./app/config-menu/element/wan/wan.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var angular = __webpack_require__("./node_modules/angular/index.js");
var JsonPointer = __webpack_require__("./node_modules/json-ptr/releases/json-ptr-1.0.1.min.js");
var common_1 = __webpack_require__("./app/view-menu/common.js");
var base_tab_controller_1 = __webpack_require__("./app/common/base-tab.controller.ts");
var CfgElementWanController = (function (_super) {
    __extends(CfgElementWanController, _super);
    function CfgElementWanController($timeout, fmeListSrv, snpListSrv, errorSrv, userManagerSrv, commonUtils, $scope) {
        var _this = _super.call(this, $scope) || this;
        _this.$timeout = $timeout;
        _this.fmeListSrv = fmeListSrv;
        _this.snpListSrv = snpListSrv;
        _this.errorSrv = errorSrv;
        _this.userManagerSrv = userManagerSrv;
        _this.commonUtils = commonUtils;
        _this.$scope = $scope;
        _this.report = undefined;
        _this.reportError = {
            wan: false,
        };
        _this.errorIndexes = {
            wan: [],
        };
        _this.$doCheck = function () {
            _this.isDirty =
                (!!_this.wanForm && _this.wanForm.$dirty) ||
                    (!!_this.phyForm && _this.phyForm.$dirty) ?
                    true :
                    false;
            if (_this.wanForm &&
                _this.wanSection.valid[_this.wanIdx] != _this.wanForm.$valid) {
                _this.wanSection.valid[_this.wanIdx] = _this.wanForm.$valid;
                _this.updateErrorIndexes();
            }
            var isFormValid = angular.isUndefined(_this.topForm) || _this.topForm.$valid;
            var isReportError = false;
            Object.keys(_this.reportError).forEach(function (key) {
                isReportError = isReportError || _this.reportError[key];
            });
            var isSelectionItemError = false;
            Object.keys(_this.errorIndexes).forEach(function (key) {
                isReportError = isReportError || _this.errorIndexes[key].length > 0;
            });
            _this.tabState.valid =
                isFormValid && !isReportError && !isSelectionItemError;
        };
        _this.$onChanges = function (changes) {
            _this.updateTabDataOnRemoteFmm(changes.fmeIp);
        };
        _this.$onDestroy = function () {
            if (_this.data.requests.statuses) {
                _this.fmeListSrv.msgStatusUnsubscribe(_this.controllerHandlers.onStatusUpdate, _this.data.requests.statuses);
            }
            if (_this.timeoutPromise)
                _this.$timeout.cancel(_this.timeoutPromise);
        };
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
        return _this;
    }
    // inherited base methods below
    CfgElementWanController.prototype.loadData = function () {
        var _this = this;
        this.data.requests = {
            configs: [
                {
                    type: common_1.SNP_OBJTYPE_WAN,
                    object_ID: common_1.SNP_OBJTYPE_WAN,
                },
                {
                    type: common_1.SNP_OBJTYPE_SYSTEM,
                    object_ID: common_1.SNP_OBJTYPE_SYSTEM,
                },
            ],
            statuses: [
                {
                    fme_ip: this.fmeIp,
                    type: common_1.SNP_OBJTYPE_WAN,
                    object_ID: common_1.SNP_OBJTYPE_WAN,
                },
            ],
        };
        if (this.data.requests.statuses) {
            this.fmeListSrv.msgStatusUnsubscribe(this.controllerHandlers.onStatusUpdate, this.data.requests.statuses);
        }
        this.snpListSrv.getObjects(this.fmeIp, this.data.requests.configs).then(function (response) {
            _this.data.response = {
                configs: {
                    wan: {
                        cfg: response[common_1.SNP_OBJTYPE_WAN].config,
                        meta: response[common_1.SNP_OBJTYPE_WAN].configMetadata,
                    },
                    sys: {
                        cfg: response[common_1.SNP_OBJTYPE_SYSTEM].config,
                        meta: response[common_1.SNP_OBJTYPE_SYSTEM].configMetadata,
                    },
                },
                statuses: {
                    wan: {
                        status: response[common_1.SNP_OBJTYPE_WAN].status,
                        meta: response[common_1.SNP_OBJTYPE_WAN].statusMetadata,
                    },
                },
            };
            if (!_this.data.response) {
                console.error("No WAN Tab Data!");
            }
            _this.fmeListSrv.msgStatusSubscribe(_this.controllerHandlers.onStatusUpdate, _this.data.requests.statuses);
            _this.aliasInTemplate("configs", _this.data.response.configs);
            _this.aliasInTemplate("status", _this.data.response.statuses);
        }, function (error) {
            // if getObjects failed reload
            _this.timeoutPromise = _this.$timeout(_this.loadData, 1500);
        });
    };
    CfgElementWanController.prototype.initControllerHandlers = function () {
        var _this = this;
        this.controllerHandlers.onStatusUpdate = function (status) {
            if (status.fme_ip === _this.fmeIp) {
                if (status.type === common_1.SNP_OBJTYPE_WAN) {
                    _this.data.response.statuses.wan.status = status;
                }
                _this.aliasInTemplate("status", _this.data.response.statuses);
            }
        };
    };
    CfgElementWanController.prototype.initApplyButtons = function () {
        var _this = this;
        var applyWan = function () {
            var partial = angular.copy(_this.data.response.configs.wan.cfg);
            var arrayIndex = _this.wanIdx;
            // --- SNP-45399: Do not filter ipWAN to apply (always apply all)
            // --- partial.ipWan = [partial.ipWan[arrayIndex]];
            delete partial.NMOS;
            return _this.snpListSrv.applyPartialUpdate(partial, function (report) {
                _this.errorSrv.remapArrayPtrs(report, "/ipWan", [arrayIndex]);
                _this.report = report;
                // SNP-6261 - reset validity after apply
                _this.wanSection.valid = _this.wanSection.valid.map(function () { return true; });
                _this.updateErrorIndexes();
            }, _this.wanForm);
        };
        var applyPHY = function () {
            var partial = angular.copy(_this.data.response.configs.sys.cfg);
            return _this.snpListSrv.applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.phyForm);
        };
        this.applyButtons.push({
            label: "Apply PHY",
            isDisabled: function () {
                return !_this.phyForm || _this.phyForm.$pristine;
            },
            click: applyPHY,
        }, {
            label: "Apply WAN",
            isDisabled: function () {
                return (!_this.wanForm || _this.wanForm.$pristine || _this.wanForm.$invalid);
            },
            click: applyWan,
        });
    };
    CfgElementWanController.prototype.initEventHandlers = function () {
        var _this = this;
        this.controllerHandlers.validateOsHostName = function () {
            var osHostName = _this.data.response.configs.wan.cfg.netOptions.osHostName;
            var description = "Not valid. Try again with uppercase and lowercase latin letters, digits, _ and -";
            if (!osHostName) {
                return [];
            }
            else if (/[^A-Za-z0-9-_]{1,}/g.test(osHostName)) {
                return [
                    {
                        type: _this.errorSrv.MSG_ERROR,
                        msg: description,
                    },
                ];
            }
            else {
                return [];
            }
        };
        this.controllerHandlers.onSectionChange = function (newIndex) {
            // TDL: refactor ng-form in template. ng-if is replaced by ng-show in section to avoid the JavaScript TypeError caused by undefined value
            var wanFormList = [
                "priDhcpForm",
                "priIpAddressForm",
                "priSubnetMaskForm",
                "priGatewayForm",
                "priVlanIdForm",
                "secDhcpForm",
                "secIpAddressForm",
                "secSubnetMaskForm",
                "secGatewayForm",
                "secVlanIdForm",
            ];
            for (var _i = 0, wanFormList_1 = wanFormList; _i < wanFormList_1.length; _i++) {
                var wanForm = wanFormList_1[_i];
                _this.wanSection.pristine[_this.wanIdx][wanForm] =
                    _this.subForms[wanForm].$pristine;
            }
            _this.wanForm.$setPristine();
            for (var _a = 0, wanFormList_2 = wanFormList; _a < wanFormList_2.length; _a++) {
                var wanForm = wanFormList_2[_a];
                if (!_this.wanSection.pristine[newIndex][wanForm]) {
                    _this.subForms[wanForm].$setDirty();
                }
            }
        };
        this.controllerHandlers.onClearAllCnt = function (param, value) {
            var wan = _this.data.response.configs.wan;
            var partial = {
                fme_ip: wan.cfg.fme_ip,
                type: wan.cfg.type,
                object_ID: wan.cfg.object_ID,
                name: wan.cfg.name,
            };
            JsonPointer.set(partial, param, value, true); // TODO: decrease this dependency
            _this.fmeListSrv.updatePartialObject(partial);
        };
    };
    CfgElementWanController.prototype.initVisibilityHandlers = function () {
        var _this = this;
        this.$scope.isWanTabContentVisible = function () {
            // refactor if needed
            var result = _this.data.response.configs && _this.data.response.statuses;
            if (!result) {
                console.error('isWanTabContentVisible: nothing to show', _this.data.response);
                return;
            }
            return result;
        };
    };
    // angular lifecycle methods below
    CfgElementWanController.prototype.$onInit = function () {
        this.loadData();
        this.initControllerHandlers();
        this.initApplyButtons();
        this.initEventHandlers();
        this.initVisibilityHandlers();
        this.initWanSection();
    };
    // own tab methods below
    CfgElementWanController.prototype.initWanSection = function () {
        this.wanSection = {
            pristine: [],
            valid: [],
        };
        var wanSectionItemControls = {
            priDhcpForm: true,
            priIpAddressForm: true,
            priSubnetMaskForm: true,
            priGatewayForm: true,
            priVlanIdForm: true,
            secDhcpForm: true,
            secIpAddressForm: true,
            secSubnetMaskForm: true,
            secGatewayForm: true,
            secVlanIdForm: true,
        };
        for (var i = 0; i < 4; i++) {
            this.wanSection.pristine.push(wanSectionItemControls);
            this.wanSection.valid.push(true);
        }
    };
    CfgElementWanController.prototype.updateErrorIndexes = function () {
        var _this = this;
        var reportErrors = this.errorSrv.getIndexesWithError(this.report, "/ipWan");
        var validationErrors = [0, 1, 2, 3].filter(function (idx) {
            return !_this.wanSection.valid[idx];
        });
        this.errorIndexes.wan = this.commonUtils
            .sortedUniqueNumbers(reportErrors.concat(validationErrors))
            .map(function (idx) {
            // remap to 1-based indexes for display
            return idx + 1;
        });
    };
    CfgElementWanController.prototype.updateTabDataOnRemoteFmm = function (fmeIp) {
        var isFmeIpChanged = fmeIp.previousValue !== fmeIp.currentValue;
        if (!this.selfHost && isFmeIpChanged) {
            this.loadData();
        }
    };
    return CfgElementWanController;
}(base_tab_controller_1.AbstractBaseTabController));
exports.CfgElementWanController = CfgElementWanController;


/***/ }),

/***/ "./app/config-menu/element/wan/wan.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/element/wan/wan.template.html?64b086fdec0760ed22104eab3be0cfbb";

/***/ }),

/***/ "./app/config-menu/graphics/graphics-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var graphics_modal_window_controller_1 = __webpack_require__("./app/config-menu/graphics/graphics-modal-window.controller.ts");
var templateUrl = __webpack_require__("./app/config-menu/graphics/graphics-modal-window.template.html");
exports.createGraphicsModalWindowComponent = function (library) {
    return library.open({
        animation: true,
        backdrop: "static",
        size: "wide",
        templateUrl: templateUrl,
        controller: graphics_modal_window_controller_1.GraphicsModalWindowController,
    });
};


/***/ }),

/***/ "./app/config-menu/graphics/graphics-modal-window.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {
Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var common_1 = __webpack_require__("./app/view-menu/common.js");
var GraphicsModalWindowController = (function () {
    function GraphicsModalWindowController($scope, $location, $uibModalInstance, fmeListSrv, graphicsSrv, snpListSrv, commonUtils) {
        $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        var initialize = function () {
            $scope.LOGO_STATUS_NONE = 0;
            $scope.LOGO_STATUS_OK = 1;
            $scope.LOGO_STATUS_LOADING = 2;
            $scope.LOGO_STATUS_ERROR = 3;
            $scope.fme_ip =
                fmeListSrv.getLastUsedElement()["ip"] ||
                    $scope.fmeList.filter($scope.fmeFilter).filter($scope.fmeTypeFilter)[0]["ip"];
            $scope.fmeList = fmeListSrv.getAllElements();
            $scope.gfxList = [];
            $scope.gfxUsage = [];
            $scope.procMode = [];
            $scope.ddrUsage = [];
            $scope.logoInProgress = [];
            $scope.logoErrors = [];
            // $scope.dbg = fmeListSrv.getDbg();
            $scope.percentUsage = 0;
            $scope.isUploading = false;
            $("input:file").val("");
            $scope.importGfx = undefined;
            $scope.importName = "";
            $scope.gfxNameExist = false;
            $scope.sort = "name";
            $scope.reverseSort = "+";
            $scope.getGraphics();
            $scope.getGraphicsInUse();
            $scope.getMCLStatus();
            $scope.errorText = null;
            //stop updating FME status
            //fmeListSrv.clearUpdateStatus();
        };
        $scope.updatePresetList = function () {
            if (!!fmeListSrv.getLastUsedElement()["ip"] ||
                !!$scope.fmeList
                    .filter($scope.fmeFilter)
                    .filter($scope.fmeTypeFilter)[0]) {
                $scope.loadPreset.fme_ip_address =
                    fmeListSrv.getLastUsedElement()["ip"] ||
                        $scope.fmeList
                            .filter($scope.fmeFilter)
                            .filter($scope.fmeTypeFilter)[0]["ip"];
            }
            else {
                $scope.loadPreset.fme_ip_address = "";
            }
        };
        $scope.fmeFilter = function (item) {
            if (!!item.state && item.state == "connected") {
                item.label =
                    item.name.length > 0 ? item.name + " (" + item.ip + ")" : item.ip;
                return item;
            }
        };
        $scope.fmeTypeFilter = function (item) {
            var preset = $scope.presetList.find(function (e) {
                return e.name === $scope.loadPreset.name;
            });
            if (!!preset) {
                if (!preset.element_type) {
                    return item;
                }
                else if (preset.element_type === item.fme_type) {
                    return item;
                }
                return;
            }
            else {
                return item;
            }
        };
        $scope.handleStatus = function (status) {
            var bb = common_1.snpProcessorIdx(status.object_ID);
            //console.log(bb);
            if (angular_1.isDefined(status.LogoStatus)) {
                // console.log(status.LogoStatus);
                $scope.ddrUsage[bb] = status.LogoStatus.memoryUsage;
                $scope.logoInProgress[bb] = status.LogoStatus.logoInProgress;
                $scope.logoErrors[bb] = {};
                status.LogoStatus.logoErrors.forEach(function (item) {
                    $scope.logoErrors[bb][item.name] = item.errorDesc;
                });
                //console.log($scope.logoErrors);
            }
        };
        $scope.handleMclConfig = function (config) {
            //console.log(config);
            var bb = common_1.snpProcessorIdx(config.object_ID);
            var procUsage = [];
            for (var keyerIdx in config.KeyerControl) {
                procUsage[keyerIdx] =
                    config.KeyerControl[keyerIdx].SrcSelect;
            }
            $scope.gfxUsage[bb] = procUsage;
        };
        $scope.handleProcessorConfig = function (config) {
            //console.log(config);
            var bb = common_1.snpProcessorIdx(config.object_ID);
            $scope.procMode[bb] = config.general.personality;
        };
        $scope.statusHeaders = [
            {
                type: common_1.SNP_OBJTYPE_MCL,
                object_ID: "MasterControl-A"
            },
            {
                type: common_1.SNP_OBJTYPE_MCL,
                object_ID: "MasterControl-B"
            },
            {
                type: common_1.SNP_OBJTYPE_MCL,
                object_ID: "MasterControl-C"
            },
            {
                type: common_1.SNP_OBJTYPE_MCL,
                object_ID: "MasterControl-D"
            }
        ];
        $scope.getMCLStatus = function () {
            for (var index in $scope.statusHeaders) {
                $scope.statusHeaders[index].fme_ip = $scope.fme_ip;
            }
            if ($scope.statusHeaders) {
                fmeListSrv.msgStatusUnsubscribe($scope.handleStatus, $scope.statusHeaders);
            }
            snpListSrv.getObjects($scope.fme_ip, $scope.statusHeaders).then(function (resolve) {
                for (var index in resolve) {
                    $scope.handleStatus(resolve[index].status);
                }
                fmeListSrv.msgStatusSubscribe($scope.handleStatus, $scope.statusHeaders);
            }, function (reject) {
                console.log("getObjects error:", reject);
            });
        };
        $scope.mclCfgHeaders = [
            {
                type: common_1.SNP_OBJTYPE_MCL,
                object_ID: "MasterControl-A",
                getStatus: false
            },
            {
                type: common_1.SNP_OBJTYPE_MCL,
                object_ID: "MasterControl-B",
                getStatus: false
            },
            {
                type: common_1.SNP_OBJTYPE_MCL,
                object_ID: "MasterControl-C",
                getStatus: false
            },
            {
                type: common_1.SNP_OBJTYPE_MCL,
                object_ID: "MasterControl-D",
                getStatus: false
            }
        ];
        $scope.procCfgHeaders = [
            {
                type: common_1.SNP_OBJTYPE_PROCESSOR,
                object_ID: "processorA",
                getStatus: false
            },
            {
                type: common_1.SNP_OBJTYPE_PROCESSOR,
                object_ID: "processorB",
                getStatus: false
            },
            {
                type: common_1.SNP_OBJTYPE_PROCESSOR,
                object_ID: "processorC",
                getStatus: false
            },
            {
                type: common_1.SNP_OBJTYPE_PROCESSOR,
                object_ID: "processorD",
                getStatus: false
            }
        ];
        $scope.getGraphicsInUse = function () {
            for (var index in $scope.mclCfgHeaders) {
                $scope.mclCfgHeaders[index].fme_ip = $scope.fme_ip;
            }
            for (var index in $scope.procCfgHeaders) {
                $scope.procCfgHeaders[index].fme_ip = $scope.fme_ip;
            }
            fmeListSrv.msgObjectUnsubscribe($scope.handleMclConfig, $scope.mclCfgHeaders);
            fmeListSrv.msgObjectUnsubscribe($scope.handleProcessorConfig, $scope.procCfgHeaders);
            snpListSrv.getObjects($scope.fme_ip, $scope.mclCfgHeaders).then(function (resolve) {
                for (var index in resolve) {
                    $scope.handleMclConfig(resolve[index].config);
                }
                fmeListSrv.msgObjectSubscribe($scope.handleMclConfig, $scope.mclCfgHeaders);
            }, function (reject) {
                console.log("getObjects error:", reject);
            });
            snpListSrv.getObjects($scope.fme_ip, $scope.procCfgHeaders).then(function (resolve) {
                for (var index in resolve) {
                    $scope.handleProcessorConfig(resolve[index].config);
                }
                fmeListSrv.msgObjectSubscribe($scope.handleProcessorConfig, $scope.procCfgHeaders);
            }, function (reject) {
                console.log("getObjects error:", reject);
            });
        };
        $scope.getGraphics = function () {
            graphicsSrv.getGraphics().then(function (resolve) {
                //console.log(resolve);
                $scope.gfxList = resolve;
                for (var index in $scope.gfxList) {
                    if ($scope.gfxList[index].last_modified.indexOf("Z") == -1) {
                        $scope.gfxList[index].last_modified =
                            $scope.gfxList[index].last_modified + "Z";
                    }
                    $scope.gfxList[index].last_modified = Date.parse($scope.gfxList[index].last_modified);
                    $scope.gfxList[index].name = $scope.gfxList[index].name
                        .split(".")
                        .slice(0, -1)
                        .join(".");
                    $scope.gfxList[index].downloadingInProgress = false;
                }
            }, function (reject) {
                if ($scope.dbg) {
                    console.log("getGraphics error:", reject);
                }
            });
            graphicsSrv.getGraphicsSpaceUsage().then(function (resolve) {
                $scope.percentUsage = resolve;
            }, function (reject) {
                console.log("getGraphicsSpaceUsage failed");
                $scope.percentUsage = 0;
            });
        };
        $scope.sortBy = function (sortField) {
            if ($scope.sort === sortField) {
                $scope.reverseSort = $scope.reverseSort === "+" ? "-" : "+";
            }
            else {
                $scope.reverseSort = "+";
                $scope.sort = sortField;
            }
        };
        $scope.getGraphicsNameExist = function (type) {
            $scope.gfxNameExist = false;
            var gfxName;
            if (type === 'save') {
                gfxName = $scope.savePreset.name;
            }
            else if (type === 'import') {
                if ($scope.importGfx && $scope.importGfx.name) {
                    if ($scope.importGfx.name.split('.')[1] === "mg3") {
                        $scope.importName = $scope.importGfx.name.split('.')[0];
                        gfxName = $scope.importName;
                        $scope.errorText = undefined;
                    }
                    else {
                        $scope.importGfx = undefined;
                        $scope.importName = "";
                        $scope.errorText = "Only accepts mg3 files";
                    }
                }
            }
            else if (type === 'update') {
                gfxName = $scope.importName;
            }
            if (angular_1.isDefined($scope.gfxList)) {
                $scope.gfxNameExist = $scope.gfxList.some(function (e) {
                    return e.name === gfxName;
                });
            }
        };
        $scope.getDDRUsage = function (bb) {
            if (angular_1.isDefined($scope.ddrUsage[bb])) {
                return $scope.ddrUsage[bb];
            }
            else {
                return "0%";
            }
        };
        $scope.logoStatus = function (bb, gfx) {
            if (angular_1.isDefined(gfx)) {
                if (angular_1.isDefined($scope.logoInProgress[bb]) && $scope.logoInProgress[bb] == (gfx.name + ".mg3")) {
                    return $scope.LOGO_STATUS_LOADING;
                }
                else if (angular_1.isDefined($scope.logoErrors[bb]) && angular_1.isDefined($scope.logoErrors[bb][gfx.name + ".mg3"])) {
                    return $scope.LOGO_STATUS_ERROR;
                }
                else {
                    return $scope.LOGO_STATUS_NONE;
                }
            }
            else {
                if (angular_1.isDefined($scope.logoInProgress[bb]) && $scope.logoInProgress[bb] != "") {
                    return $scope.LOGO_STATUS_LOADING;
                }
                else if (angular_1.isDefined($scope.logoErrors[bb]) && Object.keys($scope.logoErrors[bb]).length > 0) {
                    return $scope.LOGO_STATUS_ERROR;
                }
                else {
                    return $scope.LOGO_STATUS_OK;
                }
            }
        };
        $scope.logoError = function (bb, gfx) {
            if (angular_1.isDefined(gfx)) {
                if (angular_1.isDefined($scope.logoErrors[bb]) && angular_1.isDefined($scope.logoErrors[bb][gfx.name + ".mg3"])) {
                    return $scope.logoErrors[bb][gfx.name + ".mg3"];
                }
            }
            else {
                var rtnStr = "Logo errors:\n";
                Object.keys($scope.logoErrors[bb]).forEach(function (gfx) {
                    //console.log(gfx);
                    rtnStr = rtnStr + gfx + ": " + $scope.logoErrors[bb][gfx] + "\n";
                });
                return rtnStr;
            }
        };
        // preset name does not go through ng-change, this is a workaround
        $scope.$watch('importGfx.name', function () {
            $scope.getGraphicsNameExist('import');
        });
        $scope.$watch('importName', function () {
            $scope.getGraphicsNameExist('update');
        });
        $scope.import = function () {
            //import gfx from text file
            $scope.isUploading = true;
            graphicsSrv.importGraphic($scope.importGfx, $scope.importName).then(function (resolve) {
                $scope.importName = "";
                $("input:file").val("");
                $scope.importGfx = undefined;
                $scope.isUploading = false;
                $scope.getGraphics();
                $scope.errorText = undefined;
            }, function (reject) {
                if ($scope.dbg) {
                    console.log("importGraphic error:", reject);
                }
                $scope.isUploading = false;
                $scope.errorText = reject;
            });
        };
        $scope.printScope = function () {
            console.log($scope);
        };
        $scope.closeModal = function () {
            $uibModalInstance.close();
        };
        $scope.$on("$destroy", function () {
            //resume update and clear cfgObject service when modal is destroyed
            //fmeListSrv.setUpdateStatus();
            if ($scope.statusHeaders) {
                fmeListSrv.msgStatusUnsubscribe($scope.handleStatus, $scope.statusHeaders);
            }
            if ($scope.mclCfgHeaders) {
                fmeListSrv.msgObjectUnsubscribe($scope.handleMclConfig, $scope.mclCfgHeaders);
            }
            if ($scope.procCfgHeaders) {
                fmeListSrv.msgObjectUnsubscribe($scope.handleProcessorConfig, $scope.procCfgHeaders);
            }
        });
        function isPresetLoading(fme) {
            return fme.state === "loading-preset" || fme.presetLoaded === false;
        }
        $scope.arePresetsLoading = function () {
            return fmeListSrv.arePresetsLoading();
        };
        $scope.elementsLoadingPresets = function () {
            return $scope.fmeList
                .filter(isPresetLoading)
                .map(function (fme) { return (fme.ip === "127.0.0.1" ? $location.$$host : fme.ip); })
                .join(", ");
        };
        initialize();
    }
    return GraphicsModalWindowController;
}());
exports.GraphicsModalWindowController = GraphicsModalWindowController;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__("./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./app/config-menu/graphics/graphics-modal-window.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/graphics/graphics-modal-window.template.html?cd730f33737f214b7b6f93e37f7c6ee6";

/***/ }),

/***/ "./app/config-menu/graphics/graphics-table/graphics-table.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var common_1 = __webpack_require__("./app/view-menu/common.js");
var templateUrl = __webpack_require__("./app/config-menu/graphics/graphics-table/graphics-table.template.html");
function graphicsTableDirective() {
    //Modal for save/load presets
    return {
        scope: {
            gfxList: "=",
            gfxUsage: "=",
            procMode: "=",
            errorText: "=",
            sort: "=",
            gfxNameExist: "=",
            importName: "=",
            getGraphics: "&",
            getDdrUsage: "=",
            logoStatus: "=",
            logoError: "=",
        },
        restrict: "E",
        templateUrl: templateUrl,
        controller: [
            "$scope",
            "$timeout",
            "graphicsSrv",
            function ($scope, $timeout, graphicsSrv) {
                $scope.exportError = false;
                $scope.exportGraphics = function (nameFromTable) {
                    var gfx = $scope.gfxList.find(function (el) { return el.name === nameFromTable; });
                    function saveGfxAs(bytes, fileName) {
                        var url = window.URL.createObjectURL(bytes);
                        var a = document.createElement("a");
                        document.body.appendChild(a);
                        a.href = url;
                        a.download = fileName;
                        a.click();
                        a.remove();
                        window.URL.revokeObjectURL(url);
                    }
                    gfx.downloadingInProgress = true;
                    graphicsSrv.getGraphic(nameFromTable).then(function (data) {
                        var fileName = nameFromTable + ".mg3";
                        var gfxBlob = new Blob([data], {
                            type: "application/octet-stream",
                        });
                        saveGfxAs(gfxBlob, fileName);
                        gfx.downloadingInProgress = false;
                        $scope.errorText = undefined;
                    }, function (reject) {
                        $scope.exportError = true;
                        $timeout(function () { return ($scope.exportError = false); }, 5000);
                        $scope.errorText = reject;
                    });
                };
                $scope.rmvSelectedGraphics = function (gfxName) {
                    //remove selected preset
                    var fileName = gfxName + ".mg3";
                    for (var procIndex in $scope.gfxUsage) {
                        for (var keyerIdx in $scope.gfxUsage[procIndex]) {
                            if ($scope.gfxUsage[procIndex][keyerIdx] === fileName &&
                                $scope.procMode[procIndex] === common_1.SNP_PERSONALITY_MCL) {
                                $scope.errorText = "Cannot delete graphics in use";
                                return;
                            }
                        }
                    }
                    graphicsSrv.rmvGraphic(gfxName).then(function (resolve) {
                        $scope.getGraphics();
                        if (gfxName === $scope.importName) {
                            $scope.gfxNameExist = false;
                        }
                        $scope.errorText = null;
                    }, function (reject) {
                        if ($scope.dbg) {
                            console.log("removeGraphic error:", reject);
                        }
                        $scope.errorText = reject;
                    });
                };
                $scope.updateGfxMetadata = function (gfx) {
                    var metadataObj = {
                        preload: gfx.preload
                    };
                    var metadataStr = JSON.stringify(metadataObj);
                    graphicsSrv.importGraphicMetadata(metadataStr, gfx.name).then(function (resolve) {
                        $scope.errorText = null;
                    }, function (reject) {
                        if ($scope.dbg) {
                            console.log("updateGfxMetadata error:", reject);
                        }
                        $scope.errorText = reject;
                    });
                };
            },
        ],
    };
}
exports.graphicsTableDirective = graphicsTableDirective;


/***/ }),

/***/ "./app/config-menu/graphics/graphics-table/graphics-table.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/graphics/graphics-table/graphics-table.template.html?e73afe53391c9dffba2ab1c35133ea7a";

/***/ }),

/***/ "./app/config-menu/graphics/graphics.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var graphics_service_1 = __webpack_require__("./app/config-menu/graphics/graphics.service.ts");
var graphics_table_directive_1 = __webpack_require__("./app/config-menu/graphics/graphics-table/graphics-table.directive.ts");
var mg3_file_input_directive_1 = __webpack_require__("./app/config-menu/graphics/mg3-file-input.directive.ts");
exports.GraphicsModule = angular_1.module("GraphicsModule", [])
    .service("graphicsSrv", graphics_service_1.GraphicsService)
    .directive("graphicsTable", graphics_table_directive_1.graphicsTableDirective)
    .directive("mg3File", mg3_file_input_directive_1.MG3FileInputDirective);


/***/ }),

/***/ "./app/config-menu/graphics/graphics.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
exports.GraphicsService = function ($http, $q, REST_ENDPOINT) {
    //// IMPORTANT!!!
    // .mg3 extention guard added to flx-file-input directive
    var dbg = false;
    var getGraphicsSpaceUsage = function () {
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/gfx/space",
                method: "GET",
            })
                .success(function (response) {
                if (dbg) {
                    console.log("getGraphicsSpaceUsage response:", response);
                }
                resolve(response);
            })
                .error(function (response) {
                reject("getGraphicsSpaceUsage error:", response);
            });
        });
    };
    var getGraphics = function () {
        //get a list of gfx from a particular FME IP
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/gfx",
                method: "GET",
            })
                .success(function (response) {
                if (dbg) {
                    console.log("getGraphics, current list from DB:", response);
                }
                resolve(response);
            })
                .error(function (response) {
                reject("getGraphics error:", response);
            });
        });
    };
    var getGraphic = function (name) {
        //get a specific gfx
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/gfx/" + name + ".mg3",
                method: "GET",
                responseType: "arraybuffer",
            })
                .success(function (response) {
                if (dbg) {
                    console.log("getGraphic, current list from DB:", response);
                }
                resolve(response);
            })
                .error(function (response) {
                reject("getGraphic error:", response);
            });
        });
    };
    var importGraphic = function (gfx_data, gfx_name) {
        //import gfx file
        //requestStatusSrv.addRequest('AddLut', { "fme_ip": "127.0.0.1", "name": `LUT: ${lut_name}` });
        var fd = new FormData();
        fd.append("graphicData", gfx_data);
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/gfx/" + gfx_name + ".mg3",
                data: fd,
                method: "PUT",
                transformResponse: angular_1.identity,
                headers: {
                    "Content-Type": undefined,
                },
            })
                .success(function (response) {
                //requestStatusSrv.successRequest({ "msg_type": "AddLut", "fme_ip": "127.0.0.1", "name": `LUT: ${lut_name}` });
                //console.log("importGraphic:", response);
                resolve(response);
            })
                .error(function (response) {
                //requestStatusSrv.failedRequest({ "msg_type": "AddLut", "fme_ip": "127.0.0.1", "name": `LUT: ${lut_name}` }, response);
                reject("Error: " + response);
                //console.log("importGraphic Error :", response);
            });
        });
    };
    var importGraphicMetadata = function (gfx_json, gfx_name) {
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/gfx/" + gfx_name + ".mg3.metajson",
                data: gfx_json,
                method: "PUT",
                transformResponse: angular_1.identity,
                headers: {
                    "Content-Type": "text/plain",
                },
            })
                .success(function (response) {
                //requestStatusSrv.successRequest({ "msg_type": "AddLut", "fme_ip": "127.0.0.1", "name": `LUT: ${lut_name}` });
                //console.log("importEffectMetadata:", response);
                resolve(response);
            })
                .error(function (response) {
                //requestStatusSrv.failedRequest({ "msg_type": "AddLut", "fme_ip": "127.0.0.1", "name": `LUT: ${lut_name}` }, response);
                reject("Error: " + response);
                //console.log("importEffect Error :", response);
            });
        });
    };
    var rmvGraphic = function (gfx_name) {
        //delet selected gfx
        var jsonObjStatus = {
            fme_ip: "127.0.0.1",
            name: "LUT: " + gfx_name
        };
        //requestStatusSrv.addRequest('RmvLut', jsonObjStatus);
        //requestStatusSrv.addRequest('RmvPreset', jsonObjStatus);
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/gfx/" + gfx_name + ".mg3",
                method: "DELETE",
            }).then(function (response) {
                // success
                //var parsedJsonObj = {
                //    fme_ip: "127.0.0.1",
                //    name: `LUT: ${gfx_name}`,
                //    msg_type: 'RmvLut',
                //};
                //requestStatusSrv.successRequest(parsedJsonObj);
                if (dbg) {
                    console.log("rmvGraphic success:", response);
                }
                resolve(response);
            }, function (response) {
                //failure
                //var failedObject = response.config.data;
                //failedObject.fme_ip = "127.0.0.1";
                //failedObject.msg_type = 'RmvLut';
                //requestStatusSrv.failedRequest(failedObject, (response.statusText + ': ' + response.data));
                reject("rmvGraphic error:", response.data);
            });
        });
    };
    return {
        getGraphicsSpaceUsage: getGraphicsSpaceUsage,
        getGraphics: getGraphics,
        getGraphic: getGraphic,
        importGraphic: importGraphic,
        importGraphicMetadata: importGraphicMetadata,
        rmvGraphic: rmvGraphic,
    }; // ES6 syntax
};


/***/ }),

/***/ "./app/config-menu/graphics/mg3-file-input.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.MG3FileInputDirective = function ($parse) {
    return {
        restrict: "A",
        link: function (scope, elm, attrs) {
            var getter = $parse(attrs.mg3File);
            var setter = getter.assign;
            elm.bind("change", function (event) {
                scope.$apply(function () {
                    setter(scope, elm[0].files[0]);
                });
            });
        }
    };
};


/***/ }),

/***/ "./app/config-menu/license/license-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var license_modal_window_controller_1 = __webpack_require__("./app/config-menu/license/license-modal-window.controller.ts");
var templateUrl = __webpack_require__("./app/config-menu/license/license-modal-window.template.html");
exports.createLicenseModalWindowComponent = function (library) {
    return library.open({
        animation: true,
        backdrop: "static",
        size: "wide",
        templateUrl: templateUrl,
        controller: license_modal_window_controller_1.LicenseModalWindowController,
    });
};


/***/ }),

/***/ "./app/config-menu/license/license-modal-window.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var common_1 = __webpack_require__("./app/view-menu/common.js");
var LicenseModalWindowController = (function () {
    function LicenseModalWindowController($scope, $uibModalInstance, fmeListSrv, snpListSrv, userManagerSrv, commonUtils) {
        $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        $scope.fmeList = fmeListSrv.getAllElements();
        $scope.procNames = ["procA", "procB", "procC", "procD"];
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
        $scope.l2 = {};
        var initialize = function () {
            $scope.fme_ip = null;
            $scope.serial_num = "";
            $scope.feature_list = [];
            $scope.license_key = "";
            $scope.old_license = "";
            $scope.is_valid = true;
            $scope.edit_mode = false;
            $scope.error = "";
            $scope.success = "";
            $scope.freeze = false;
            $scope.l2.status_list = [];
            $scope.l2.license_key = "N/A";
            $scope.l2.old_license = "";
            $scope.l2.is_valid = true;
            $scope.l2.edit_mode = false;
            $scope.l2.licenseError = "";
            $scope.l2.licenseSuccess = "";
            $scope.l2.freeze = false;
            $scope.dbg = fmeListSrv.getDbg();
        };
        var prepareModal = function () {
            initialize();
            //select last used element
            if ($scope.fmeList.filter($scope.fmeFilter).length > 0) {
                $scope.fme_ip =
                    fmeListSrv.getLastUsedElement()["ip"] ||
                        $scope.fmeList.filter($scope.fmeFilter)[0]["ip"];
                $scope.getLicenseInfo();
                $scope.l2.getLicenseInfo();
            }
        };
        var clearStatus = function () {
            return setTimeout(function () {
                $scope.error = "";
                $scope.success = "";
                $scope.featuresError = "";
                $scope.featuresSuccess = "";
            }, 10000);
        };
        $scope.fmeFilter = function (item) {
            if (!!item.state && item.state == "connected") {
                item.label =
                    item.name.length > 0 ? item.name + " (" + item.ip + ")" : item.ip;
                return item;
            }
        };
        $scope.enableEdit = function () {
            $scope.edit_mode = true;
            $scope.error = "";
            $scope.success = "";
            $scope.old_license = $scope.license_key;
            $scope.license_key = "";
        };
        $scope.closeEdit = function () {
            $scope.edit_mode = false;
            $scope.error = "";
            $scope.success = "";
            $scope.license_key = $scope.old_license;
        };
        $scope.submitLicense = function () {
            $scope.freeze = true;
            $scope.error = "";
            $scope.success = "";
            fmeListSrv.updateCommonLicense($scope.fme_ip, $scope.license_key).then(function (response) {
                if (response && response.is_valid) {
                    //for (var feature in response.licensed_features)
                    response.licensed_features.forEach(function (feature) {
                        var newFeature = feature.name;
                        $scope.sysConfig.License_Tokens.every(function (oldFeature) {
                            if (oldFeature["keyName"] === newFeature) {
                                if ($scope.calcUsed(oldFeature) > feature.tokens) {
                                    Object.keys(oldFeature).map(function (key) {
                                        oldFeature[key] = key.match(/proc/) ? false : oldFeature[key];
                                    });
                                }
                                else if (feature.tokens == 4) {
                                    Object.keys(oldFeature).map(function (key) {
                                        oldFeature[key] = key.match(/proc/) ? true : oldFeature[key];
                                    });
                                }
                                return false;
                            }
                            return true;
                        });
                    });
                    // Disable checkboxes for all processor
                    $scope.saveFeatures();
                    $scope.edit_mode = false;
                    $scope.success = "Common license applied successfully";
                    clearStatus();
                    $scope.getLicenseInfo();
                    $scope.freeze = false;
                }
                else {
                    $scope.edit_mode = true;
                    $scope.error = "Invalid common license";
                    $scope.freeze = false;
                    clearStatus();
                }
            }, function (response) {
                if (response && !response.is_valid) {
                    $scope.error = "Invalid common license";
                    $scope.freeze = false;
                    clearStatus();
                }
                else {
                    $scope.error = "Unknown common license update error!";
                    $scope.freeze = false;
                    clearStatus();
                }
            });
        };
        $scope.getLicenseInfo = function () {
            $scope.error = "";
            $scope.success = "";
            $scope.serial_num = "";
            $scope.freeze = true;
            fmeListSrv.getCommonLicense($scope.fme_ip).then(function (response) {
                console.log("$scope.getCommonLicenseInfo", response);
                if (response) {
                    var data = response;
                    $scope.license_key = data.is_valid ? data.license_key : "";
                    $scope.feature_list = data.licensed_features;
                    $scope.is_valid = data.is_valid;
                    $scope.edit_mode = !data.is_valid;
                    $scope.serial_num = data.serial_num;
                    $scope.getLicenseTokens();
                }
                else
                    $scope.edit_mode = true;
                $scope.freeze = false;
            }, function (response) {
                if ($scope.dbg) {
                    console.log("getCommonLicenseInfo error:", response);
                }
                $scope.error = "Error establishing connection.";
                $scope.freeze = true;
            });
        };
        $scope.getLicenseTokens = function () {
            $scope.configsTouched = false;
            snpListSrv
                .getObjects($scope.fme_ip, [
                {
                    type: common_1.SNP_OBJTYPE_SYSTEM,
                    object_ID: common_1.SNP_OBJTYPE_SYSTEM,
                    getConfig: true,
                    getStatus: true,
                },
            ])
                .then(function (objects) {
                $scope.sysConfig = objects[common_1.SNP_OBJTYPE_SYSTEM].config;
                $scope.status = objects[common_1.SNP_OBJTYPE_SYSTEM].status;
                delete $scope.sysConfig.System_Control;
                delete $scope.sysConfig.Global_Control;
                delete $scope.sysConfig.AAP_Algorithms;
                if (!!$scope.sysConfig.License_Tokens) {
                    var tokens_1 = $scope.sysConfig.License_Tokens;
                    var personalities_1 = [];
                    var features_1 = [];
                    var missing_1 = [];
                    $scope.feature_list = $scope.feature_list.map(function (feature) {
                        var token = tokens_1.filter(function (token) { return token.keyName === feature.name; })[0];
                        if (angular_1.isDefined(token)) {
                            feature.procs = token;
                        }
                        feature.num_consumed = $scope.calcUsed(feature.procs);
                        console.log("license", feature.title);
                        var licenseStatus = $scope.status.License_Info.find(function (element) { return element.keyName == feature.name; });
                        if (angular_1.isDefined(licenseStatus)) {
                            feature.title = licenseStatus.keyTitle; // token.keyTitle;
                        }
                        else {
                            feature.title = "Missing " + feature.name;
                            // --- Hide this from the GUI
                            feature.is_tokenized = -1;
                        }
                        // order personalities first
                        if (feature.title.toLowerCase().indexOf("personality") > -1)
                            personalities_1.push(feature);
                        else if (feature.title.toLowerCase().indexOf("feature") > -1)
                            features_1.push(feature);
                        else
                            missing_1.push(feature);
                        return feature;
                    });
                    $scope.feature_list = personalities_1.concat(features_1, missing_1);
                }
            }, function (error) {
                if ($scope.dbg) {
                    console.log("getLicenseTokens error:", error);
                }
            });
        };
        $scope.calcUsed = function (procs) {
            var n = 0;
            for (var key in procs) {
                if (key === "keyName" || key === "keyTitle")
                    continue;
                n += procs[key] ? 1 : 0;
            }
            return n;
        };
        $scope.selectProc = function (feature, key) {
            feature.num_consumed += feature.procs[key] ? 1 : -1;
            $scope.configsTouched = true;
        };
        $scope.saveInProgress = false;
        //$scope.saveFeatures = () => {
        var allFailAttempt = 15;
        // setTimeout is bad choice because of async.
        $scope.sleep = function (milliseconds) {
            var date = Date.now();
            var currentDate;
            do {
                currentDate = Date.now();
            } while (currentDate - date < milliseconds);
        };
        $scope.saveFeatures = function (currentAttempt) {
            if (currentAttempt === void 0) { currentAttempt = 0; }
            $scope.saveInProgress = true;
            var partial = angular_1.copy($scope.sysConfig);
            snpListSrv.applyPartialUpdate(partial).then(function (success) {
                $scope.getLicenseTokens();
                $scope.saveInProgress = false;
                $scope.featuresSuccess = "Configuration saved!";
                clearStatus();
            }, function (error) {
                if (currentAttempt <= allFailAttempt &&
                    $scope.saveInProgress == true) {
                    $scope.featuresError = "Please wait ...";
                    $scope.sleep(4000);
                    $scope.saveFeatures(currentAttempt + 1);
                }
                else {
                    $scope.featuresError = "Unknown configuration save error!";
                }
                $scope.saveInProgress = false;
                clearStatus();
                if ($scope.dbg) {
                    console.log("saveFeatures error:", error);
                }
            });
        };
        //////////////////////////////////////////////////////////////////////////////////////////////////////
        // HANDLERS FOR LICENSE 2
        //////////////////////////////////////////////////////////////////////////////////////////////////////
        $scope.l2.clearStatus = function () {
            return setTimeout(function () {
                $scope.l2.licenseError = "";
                $scope.l2.licenseSuccess = "";
            }, 5000);
        };
        $scope.l2.enableEdit = function () {
            $scope.l2.edit_mode = true;
            $scope.l2.licenseError = "";
            $scope.l2.licenseSuccess = "";
            $scope.l2.old_license = $scope.l2.license_key;
            $scope.l2.license_key = "";
        };
        $scope.l2.closeEdit = function () {
            $scope.l2.edit_mode = false;
            $scope.l2.licenseError = "";
            $scope.l2.licenseSuccess = "";
            $scope.l2.license_key = $scope.l2.old_license;
        };
        $scope.l2.submitLicense = function () {
            $scope.l2.freeze = true;
            $scope.l2.licenseError = "";
            $scope.l2.licenseSuccess = "";
            fmeListSrv.updateAAPLicense($scope.fme_ip, $scope.l2.license_key).then(function (response) {
                if (response && response.is_valid) {
                    $scope.l2.edit_mode = false;
                    $scope.l2.licenseSuccess = "AAP License applied successfully";
                    $scope.l2.clearStatus();
                    $scope.l2.getLicenseInfo();
                    $scope.l2.freeze = false;
                }
                else {
                    $scope.l2.edit_mode = true;
                    $scope.l2.licenseError = "Invalid AAP license";
                    $scope.l2.freeze = false;
                    $scope.l2.clearStatus();
                }
            }, function (response) {
                if (response && !response.is_valid) {
                    $scope.l2.licenseError = "Invalid APP license";
                    $scope.l2.freeze = false;
                    $scope.l2.clearStatus();
                }
                else {
                    $scope.l2.licenseError = "Unknown APP license update error!";
                    $scope.l2.freeze = false;
                    $scope.l2.clearStatus();
                }
            });
        };
        $scope.l2.getLicenseInfo = function () {
            $scope.l2.freeze = true;
            fmeListSrv.getAAPLicense($scope.fme_ip).then(function (response) {
                console.log("$scope.l2.getAAPLicenseInfo", response);
                if (response) {
                    var data = response;
                    $scope.l2.license_key = data.is_valid ? data.license_key : "";
                    $scope.l2.is_valid = data.is_valid;
                    $scope.l2.edit_mode = !data.is_valid;
                    $scope.l2.formatLicenseTokens(data.licensed_features);
                    $scope.l2.getAapLicenseStatus();
                }
                else
                    $scope.l2.edit_mode = true;
                $scope.l2.freeze = false;
            }, function (response) {
                if ($scope.dbg) {
                    console.log("getAPPLicenseInfo error:", response);
                }
                $scope.l2.error = "Error establishing connection.";
                $scope.l2.freeze = true;
            });
        };
        $scope.l2.formatLicenseTokens = function (features) {
            var titleMap = {
                "SNP-SK-DTS": "DTS Audio",
                "SNP-ASK-DEE": "Dolby E Encoding",
                "SNP-ASK-DED": "Dolby E Decoding",
            };
            $scope.l2.status_list = [];
            $scope.l2.feature_list = features.map(function (feature) {
                var lic = {
                    keyName: "",
                    keyTitle: "",
                    creditsTotal: 0,
                    creditsUsed: 0,
                };
                if (titleMap[feature.name]) {
                    feature.title = titleMap[feature.name];
                    lic.keyName = feature.name;
                    lic.keyTitle = feature.title;
                    lic.creditsTotal = feature.tokens;
                    lic.creditsUsed = feature.num_consumed;
                }
                else {
                    feature.title = "Missing " + feature.name;
                    lic.keyName = feature.title;
                    lic.keyTitle = feature.title;
                }
                $scope.l2.status_list.push(lic);
                return feature;
            });
        };
        $scope.l2.getAapLicenseStatus = function () {
            $scope.configsTouched = false;
            snpListSrv
                .getObjects($scope.fme_ip, [
                {
                    type: common_1.SNP_OBJTYPE_SYSTEM,
                    object_ID: common_1.SNP_OBJTYPE_SYSTEM,
                    getStatus: true,
                },
            ])
                .then(function (objects) {
                var system = {
                    stat: {
                        AAP_License_Status: undefined,
                    },
                };
                system.stat = objects[common_1.SNP_OBJTYPE_SYSTEM].status;
                if (system.stat.AAP_License_Status) {
                    system.stat.AAP_License_Status.forEach(function (lic) {
                        for (var i = 0; i < $scope.l2.status_list.length; i++) {
                            if ($scope.l2.status_list[i].keyName == lic.keyName) {
                                $scope.l2.status_list[i].creditsUsed = lic.creditsUsed;
                            }
                        }
                    });
                }
                else {
                    // For development period ONLY
                    console.log("system.status", objects[common_1.SNP_OBJTYPE_SYSTEM].status, "status.AAP_License_Status", objects[common_1.SNP_OBJTYPE_SYSTEM].status.AAP_License_Status);
                    $scope.l2.status_list = [
                        {
                            keyTitle: "N/A",
                            creditsTotal: "N/A",
                            creditsUsed: "N/A",
                        },
                    ];
                }
            }, function (error) {
                if ($scope.dbg) {
                    console.log("l2.getAapLicenseStatus error:", error);
                }
            });
        };
        //////////////////////////////////////////////////////////////////////////////////////////////////////
        // HANDLERS FOR LICENSE 2 ENDS
        //////////////////////////////////////////////////////////////////////////////////////////////////////
        $scope.closeModal = function () {
            $uibModalInstance.close();
        };
        prepareModal();
    }
    return LicenseModalWindowController;
}());
exports.LicenseModalWindowController = LicenseModalWindowController;


/***/ }),

/***/ "./app/config-menu/license/license-modal-window.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/license/license-modal-window.template.html?8d919daf962c8126f21879412c3b8582";

/***/ }),

/***/ "./app/config-menu/luts/luts-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var luts_modal_window_controller_1 = __webpack_require__("./app/config-menu/luts/luts-modal-window.controller.ts");
var templateUrl = __webpack_require__("./app/config-menu/luts/luts-modal-window.template.html");
exports.creatLutsModalWindowComponent = function (library) {
    return library.open({
        animation: true,
        backdrop: "static",
        size: "wide",
        templateUrl: templateUrl,
        controller: luts_modal_window_controller_1.LutsModalWindowController,
    });
};


/***/ }),

/***/ "./app/config-menu/luts/luts-modal-window.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {
Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var MD5 = __webpack_require__("./node_modules/crypto-js/md5.js");
var LutsModalWindowController = (function () {
    function LutsModalWindowController($scope, $location, $uibModalInstance, fmeListSrv, lutsSrv, commonUtils) {
        $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        var initialize = function () {
            $scope.fmeList = fmeListSrv.getAllElements();
            $scope.lutsList = [];
            $scope.dbg = lutsSrv.getDbg();
            $scope.loadLuts = {};
            $scope.saveLuts = {};
            $("input:file").val("");
            $scope.importLut = {};
            $scope.importName = "";
            $scope.selectedLutInputColandTCS = "";
            $scope.selectedLutOutputColandTCS = "";
            $scope.selectedLutInputRange = "";
            $scope.selectedLutOutputRange = "";
            $scope.InputTCS = "";
            $scope.OutputTCS = "";
            $scope.InputRange = "";
            $scope.OutputRange = "";
            $scope.metadataName = "";
            $scope.metadataFile = "";
            $scope.cubeFile = "";
            $scope.getLuts();
            $scope.lutsNameExist = false;
            $scope.updateMetadata = false;
            $scope.sort = "name";
            $scope.md5 = "";
            $scope.copyError = "";
            $scope.importError = "";
            $scope.reverseSort = "+";
            //stop updating FME status
            fmeListSrv.clearUpdateStatus();
            var tempList = $scope.fmeList.filter($scope.fmeFilter);
            if (tempList.length > 0) {
                $scope.loadLuts.fme_ip_address =
                    fmeListSrv.getLastUsedElement()["ip"] ||
                        tempList.filter($scope.fmeTypeFilter)[0]["ip"];
                $scope.saveLuts.fme_ip_address =
                    fmeListSrv.getLastUsedElement()["ip"] || tempList[0]["ip"];
            }
        };
        $scope.updateLutsList = function () {
            if (!!fmeListSrv.getLastUsedElement()["ip"] ||
                !!$scope.fmeList
                    .filter($scope.fmeFilter)
                    .filter($scope.fmeTypeFilter)[0]) {
                $scope.loadLuts.fme_ip_address =
                    fmeListSrv.getLastUsedElement()["ip"] ||
                        $scope.fmeList
                            .filter($scope.fmeFilter)
                            .filter($scope.fmeTypeFilter)[0]["ip"];
            }
            else {
                $scope.loadLuts.fme_ip_address = "";
            }
        };
        $scope.fmeFilter = function (item) {
            if (!!item.state && item.state == "connected") {
                item.label =
                    item.name.length > 0 ? item.name + " (" + item.ip + ")" : item.ip;
                return item;
            }
        };
        $scope.fmeTypeFilter = function (item) {
            var luts = $scope.lutsList.find(function (e) {
                return e.name === $scope.loadLuts.name;
            });
            if (!!luts) {
                if (!luts.element_type) {
                    return item;
                }
                else if (luts.element_type === item.fme_type) {
                    return item;
                }
                return;
            }
            else {
                return item;
            }
        };
        //gets a list of existing 3D LUTs, excluding the UNITY LUT
        $scope.getLuts = function () {
            lutsSrv.getLuts_().then(function (resolve) {
                $scope.lutsList = resolve.filter(function (lut) { return lut.name != "UNITY.cube" && lut.name != "UNITY"; });
                for (var index in $scope.lutsList) {
                    if ($scope.lutsList[index].last_modified.indexOf("Z") == -1) {
                        $scope.lutsList[index].last_modified =
                            $scope.lutsList[index].last_modified + "Z";
                    }
                    $scope.lutsList[index].last_modified = Date.parse($scope.lutsList[index].last_modified);
                    $scope.lutsList[index].name = $scope.lutsList[index].name.split('.')[0];
                    //$scope.lutsList[index].filename = $scope.lutsList[index].filename.replace(/\.[^/.]+$/, "");
                }
            }, function (reject) {
                if ($scope.dbg) {
                    console.log("getLuts error:", reject);
                }
            });
        };
        $scope.sortBy = function (sortField) {
            if ($scope.sort === sortField) {
                $scope.reverseSort = $scope.reverseSort === "+" ? "-" : "+";
            }
            else {
                $scope.reverseSort = "+";
                $scope.sort = sortField;
            }
        };
        $scope.getLutsNameExist = function (type) {
            $scope.lutsNameExist = false;
            var lutsName;
            if (type === "save") {
                lutsName = $scope.saveLuts.name;
            }
            else if (type === "import") {
                if ($scope.importLut && $scope.importLut.name) {
                    $scope.importName = $scope.importLut.name.split(".")[0];
                    lutsName = $scope.importName;
                    $scope.selectedLutInputColandTCS = "";
                    $scope.selectedLutOutputColandTCS = "";
                    $scope.selectedLutInputRange = "";
                    $scope.selectedLutOutputRange = "";
                }
            }
            else if (type == "update") {
                lutsName = $scope.importName;
            }
            if (angular_1.isDefined($scope.lutsList)) {
                $scope.lutsNameExist = $scope.lutsList.some(function (e) {
                    return e.name === lutsName;
                });
            }
        };
        // luts name does not go through ng-change, this is a workaround
        $scope.$watch("importLut.name", function () {
            $scope.getLutsNameExist("import");
        });
        $scope.$watch("importName", function () {
            $scope.getLutsNameExist("update");
        });
        $scope.addSelectedLuts = function () {
            var tmpFme;
            $scope.fmeList.forEach(function (fme) {
                if ($scope.saveLuts.fme_ip_address === fme.ip)
                    tmpFme = fme;
            });
            if (tmpFme) {
                if (tmpFme.properties && tmpFme.properties.element_type)
                    tmpFme.element_type = tmpFme.properties.element_type;
                if (!tmpFme.interface_version)
                    tmpFme.interface_version = "";
                if (!tmpFme.element_version && !!tmpFme.version)
                    tmpFme.element_version = tmpFme.version;
            }
            else
                tmpFme = {
                    element_type: "",
                    interface_version: "",
                    element_version: "",
                };
            lutsSrv
                .addLuts($scope.saveLuts.fme_ip_address, $scope.saveLuts.name, tmpFme.interface_version, tmpFme.element_type, tmpFme.element_version)
                .then(function (resolve) {
                $scope.lutsNameExist = false;
                $scope.saveLuts.name = "";
                if ($scope.saveLuts.$dirty) {
                    $scope.saveLuts.$setPristine();
                }
                $scope.getLuts();
            }, function (reject) {
                if ($scope.dbg) {
                    console.log("addLuts error:", reject);
                }
            });
        };
        $scope.updateLuts = function () {
            var jsonObj = {
                description: "3dlut.cube metadata",
                filename: $scope.metadataName,
                md5sum: $scope.md5,
                lut_input_colorimetry_tcs: parseInt($scope.lutInputColorTCS),
                lut_output_colorimetry_tcs: parseInt($scope.lutOutputColorTCS),
                lut_input_range: parseInt($scope.lutInputRange),
                lut_output_range: parseInt($scope.lutOutputRange),
            };
            var json_str = JSON.stringify(jsonObj);
            //updates metadata of selected LUT
            lutsSrv.updateLuts(json_str, $scope.lutMetadataName).then(function (resolve) {
                //$scope.lutsNameExist=false;
                $scope.updateMetadata = false;
                $scope.lutMetadataName = "";
                $scope.lutInputColorTCS = "";
                $scope.lutOutputColorTCS = "";
                $scope.lutInputRange = "";
                $scope.lutOutputRange = "";
                $scope.md5 = "";
                $scope.InputTCS = "";
                $scope.OutputTCS = "";
                $scope.InputRange = "";
                $scope.OutputRange = "";
                $scope.metadataName = "";
                if ($scope.saveLutsForm.lutInputColorTCS.$dirty) {
                    $scope.saveLutsForm.lutInputColorTCS.$setPristine();
                }
                if ($scope.saveLutsForm.lutOutputColorTCS.$dirty) {
                    $scope.saveLutsForm.lutOutputColorTCS.$setPristine();
                }
                if ($scope.saveLutsForm.lutInputRange.$dirty) {
                    $scope.saveLutsForm.lutInputRange.$setPristine();
                }
                if ($scope.saveLutsForm.lutOutputRange.$dirty) {
                    $scope.saveLutsForm.lutOutputRange.$setPristine();
                }
                if ($scope.saveLuts.$dirty) {
                    $scope.saveLuts.$setPristine();
                }
                $scope.getLuts();
            }, function (reject) {
                //console.log(reject)
                if ($scope.dbg) {
                    console.log("updateLuts error:", reject);
                }
            });
        };
        $scope.loadSelectedLuts = function () {
            //function copies LUT from remote SMM to selected element (local SMM)
            $scope.copyError = "";
            lutsSrv
                .copyLut($scope.loadLuts.fme_ip_address, $scope.loadLuts.name, $scope.cubeFile)
                .then(function (resolve) {
                $scope.cubeFile = "";
                //$scope.copyError = "";
                if ($scope.loadLuts.$dirty) {
                    $scope.loadLuts.$setPristine();
                }
            }, function (reject) {
                if ($scope.dbg) {
                    console.log("loadLuts error:", reject);
                }
                //$scope.copyError = reject.toString();
            });
            lutsSrv
                .copyLutMetadata($scope.loadLuts.fme_ip_address, $scope.loadLuts.name, $scope.metadataFile)
                .then(function (resolve) {
                $scope.metadataFile = "";
                $scope.loadLuts.name = "";
                $scope.loadLuts.fme_ip_address = "";
                $scope.copyError = "";
                if ($scope.loadLuts.$dirty) {
                    $scope.loadLuts.$setPristine();
                }
            }, function (reject) {
                if ($scope.dbg) {
                    console.log("loadLuts error:", reject);
                }
                $scope.copyError = reject.toString();
            });
        };
        $scope.importMetadata = function (json_str, lut_name) {
            lutsSrv.importLutsMetadata(json_str, lut_name).then(function (resolve) {
                if ($scope.importLut.$dirty) {
                    $scope.importLut.$setPristine();
                }
                $scope.selectedLutInputColandTCS = "";
                $scope.selectedLutOutputColandTCS = "";
                $scope.selectedLutInputRange = "";
                $scope.selectedLutOutputRange = "";
                $scope.getLuts();
            }, function (reject) {
                //console.log("importMetadata error:",reject);
            });
        };
        $scope.invalidExtension = function () {
            return $scope.importName.includes(".");
        };
        $scope.import = function () {
            //import luts from text file
            var luts_str = $scope.importLut.jsonfile;
            $scope.importError = "";
            $scope.importCubeSuccess = false;
            var jsonObj = {
                description: "3dlut.cube metadata",
                filename: $scope.importName + ".cube",
                md5sum: MD5($scope.importLut.jsonfile).toString(),
                lut_input_colorimetry_tcs: parseInt($scope.selectedLutInputColandTCS),
                lut_output_colorimetry_tcs: parseInt($scope.selectedLutOutputColandTCS),
                lut_input_range: parseInt($scope.selectedLutInputRange),
                lut_output_range: parseInt($scope.selectedLutOutputRange),
            };
            var json_str = JSON.stringify(jsonObj);
            //import 3D LUT cube file
            lutsSrv.importLut(luts_str, $scope.importName).then(function (resolve) {
                $scope.importMetadata(json_str, $scope.importName);
                $scope.importName = "";
                $scope.importError = "";
                $("input:file").val("");
                $scope.importLut = {};
                if ($scope.importLut.$dirty) {
                    $scope.importLut.$setPristine();
                }
                $scope.getLuts();
            }, function (reject) {
                $scope.importError = reject.toString();
            });
        };
        $scope.getLutMetadata = function () {
            lutsSrv.getLutMetadata($scope.lutMetadataName).then(function (data) {
                $scope.lutInputColorTCS =
                    data["lut_input_colorimetry_tcs"].toString();
                $scope.lutOutputColorTCS =
                    data["lut_output_colorimetry_tcs"].toString();
                $scope.lutInputRange = data["lut_input_range"].toString();
                $scope.lutOutputRange = data["lut_output_range"].toString();
                $scope.md5 = data["md5sum"];
                $scope.InputTCS = data["lut_input_colorimetry_tcs"].toString();
                $scope.OutputTCS = data["lut_output_colorimetry_tcs"].toString();
                $scope.InputRange = data["lut_input_range"].toString();
                $scope.OutputRange = data["lut_output_range"].toString();
                $scope.metadataName = data["filename"];
                $scope.updateMetadata = false;
                if ($scope.saveLutsForm.lutInputColorTCS.$dirty) {
                    $scope.saveLutsForm.lutInputColorTCS.$setPristine();
                }
                if ($scope.saveLutsForm.lutOutputColorTCS.$dirty) {
                    $scope.saveLutsForm.lutOutputColorTCS.$setPristine();
                }
                if ($scope.saveLutsForm.lutInputRange.$dirty) {
                    $scope.saveLutsForm.lutInputRange.$setPristine();
                }
                if ($scope.saveLutsForm.lutOutputRange.$dirty) {
                    $scope.saveLutsForm.lutOutputRange.$setPristine();
                }
            }, function (reject) {
                if ($scope.dbg) {
                    console.log("getLuts error:", reject);
                }
            });
        };
        $scope.getChange = function () {
            if ($scope.lutInputColorTCS != $scope.InputTCS ||
                $scope.lutOutputColorTCS != $scope.OutputTCS ||
                $scope.lutInputRange != $scope.InputRange ||
                ($scope.lutOutputRange != $scope.OutputRange &&
                    $scope.metadataName != "")) {
                $scope.updateMetadata = true;
            }
            else
                $scope.updateMetadata = false;
        };
        $scope.getFileContents = function () {
            $scope.copyError = "";
            if ($scope.loadLuts.name && $scope.loadLuts.name != "undefined") {
                //get cube file of selected LUt
                lutsSrv.getLut($scope.loadLuts.name).then(function (data) {
                    $scope.cubeFile = data.toString();
                }, function (reject) {
                    if ($scope.dbg) {
                        console.log("getLuts error:", reject);
                    }
                });
                //get metadata of selected LUT
                lutsSrv.getLutMetadata($scope.loadLuts.name).then(function (data) {
                    $scope.metadataFile = JSON.stringify(data);
                }, function (reject) {
                    if ($scope.dbg) {
                        console.log("getLuts error:", reject);
                    }
                });
            }
        };
        $scope.printScope = function () {
            console.log($scope);
        };
        $scope.closeModal = function () {
            $uibModalInstance.close();
        };
        $scope.$on("$destroy", function () {
            //resume update and clear cfgObject service when modal is destroyed
            fmeListSrv.setUpdateStatus();
        });
        function isLutsLoading(fme) {
            return fme.state === "loading-luts" || fme.lutsLoaded === false;
        }
        $scope.elementsLoadingLuts = function () {
            return $scope.fmeList
                .filter(isLutsLoading)
                .map(function (fme) { return (fme.ip === "127.0.0.1" ? $location.$$host : fme.ip); })
                .join(", ");
        };
        initialize();
    }
    return LutsModalWindowController;
}());
exports.LutsModalWindowController = LutsModalWindowController;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__("./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./app/config-menu/luts/luts-modal-window.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/luts/luts-modal-window.template.html?ca3b11e930407c671ad5dda6268a5523";

/***/ }),

/***/ "./app/config-menu/luts/luts-table/luts-table.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var templateUrl = __webpack_require__("./app/config-menu/luts/luts-table/luts-table.template.html");
function lutsTable() {
    //Modal for save/load luts
    return {
        scope: {
            lutsList: "=",
            sort: "=",
            lutMetadataName: "=",
            lutInputColorTCS: "=",
            lutOutputColorTCS: "=",
            lutInputRange: "=",
            lutOutputRange: "=",
            lutsNameExist: "=",
            importName: "=",
            getLuts: "&",
        },
        restrict: "E",
        templateUrl: templateUrl,
        controller: [
            "$scope",
            "$timeout",
            "lutsSrv",
            function ($scope, $timeout, lutsSrv) {
                $scope.exportError = false;
                $scope.exportLuts = function (lutsName) {
                    //export the selected luts as a file via browser (requires HTML5 support)
                    var fileName = lutsName + ".cube";
                    lutsSrv.getLutMetadata(lutsName).then(function (data) {
                        fileName = data["filename"];
                    }, function (reject) {
                        //$scope.exportError = true;
                        //$timeout(() => $scope.exportError = false, 5000);
                        if ($scope.dbg) {
                            console.log("getLuts error:", reject);
                        }
                    });
                    lutsSrv.getLut(lutsName).then(function (data) {
                        if (lutsSrv.getDbg()) {
                            console.log("downloading: /luts/" + lutsName + ".cube");
                        }
                        //const fileName = `${lutsName}.cube`;
                        var lutsBlob = new Blob([data], {
                            type: "text/plain",
                        });
                        var url = window.URL.createObjectURL(lutsBlob);
                        var a = document.createElement("a");
                        document.body.appendChild(a);
                        // a.style = "display: none";
                        a.href = url;
                        a.download = fileName;
                        a.click();
                        window.URL.revokeObjectURL(url);
                        a.remove();
                    }, function (reject) {
                        $scope.exportError = true;
                        $timeout(function () { return ($scope.exportError = false); }, 5000);
                        if ($scope.dbg) {
                            console.log("getLuts error:", reject);
                        }
                    });
                    //When uncommented, this section  of the code  will download metadata file
                    /*lutsSrv.getLutMetadata(lutsName)
                                  .then(
                                          function(data){
                                              //const content = resolve;
                                                  if(lutsSrv.getDbg()){console.log("downloading: /luts/"+lutsName+".json")};
                                                  const fileName = `${lutsName}.json`;
                                                  const lutsBlob = new Blob([JSON.stringify(data)], {
                                                       type: 'application/json',
                                                       name: fileName
                                                  });
                                                  const url  = window.URL.createObjectURL(lutsBlob);
                                                  const a = document.createElement("a");
                                                  document.body.appendChild(a);
                                                  a.style = "display: none";
                                                  a.href = url;
                                                  a.download = fileName;
                                                  a.click();
                                                  window.URL.revokeObjectURL(url);
                                                  a.remove();
                                          },
                                          function(reject){
                                                  $scope.exportError = true;
                                                  $timeout(() => $scope.exportError = false, 5000);
                                                  if($scope.dbg){console.log("getLuts error:",reject)};
                                          }
                                  )*/
                };
                $scope.rmvSelectedLuts = function (lutsName) {
                    var deletedName = lutsName;
                    if (deletedName == $scope.$parent.lutMetadataName) {
                        $scope.$parent.lutInputColorTCS = "";
                        $scope.$parent.lutOutputColorTCS = "";
                        $scope.$parent.lutInputRange = "";
                        $scope.$parent.lutOutputRange = "";
                        $scope.$parent.lutMetadataName = "";
                    }
                    //remove selected luts
                    lutsSrv.rmvLuts(lutsName).then(function (resolve) {
                        $scope.getLuts();
                        if (lutsName === $scope.importName) {
                            $scope.lutsNameExist = false;
                        }
                    }, function (reject) {
                        if ($scope.dbg) {
                            console.log("removeLuts error:", reject);
                        }
                    });
                };
            },
        ],
    };
}
exports.lutsTable = lutsTable;


/***/ }),

/***/ "./app/config-menu/luts/luts-table/luts-table.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/luts/luts-table/luts-table.template.html?fc68498097257a923084465aa1d9c438";

/***/ }),

/***/ "./app/config-menu/luts/luts.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var luts_service_1 = __webpack_require__("./app/config-menu/luts/luts.service.ts");
var luts_table_directive_1 = __webpack_require__("./app/config-menu/luts/luts-table/luts-table.directive.ts");
exports.LutsModule = angular_1.module("lutsModule", [])
    .service("lutsSrv", luts_service_1.LutsService)
    .directive("lutsTable", luts_table_directive_1.lutsTable);


/***/ }),

/***/ "./app/config-menu/luts/luts.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.LutsService = function ($http, $q, requestStatusSrv, commonUtils, REST_ENDPOINT) {
    var dbg = false;
    var selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
    var getLuts = function (fme_ip) {
        return $http({
            url: REST_ENDPOINT.URI + "elements/" + (selfHost ? '127.0.0.1' : fme_ip) + "/luts",
            method: 'GET',
        }).success(function (response) {
            if (dbg) {
                console.log("getLuts:" + response);
            }
            ;
        }).error(function (response) {
            if (dbg) {
                console.log("error:" + response);
            }
            ;
        });
    };
    var getDbg = function () {
        return dbg;
    };
    var copyLut = function (fme_ip, name, cube_content) {
        //copies 3D LUT cube file from remote SMM to (local) SMM with IP = fme_ip
        //requestStatusSrv.addRequest('AddLut', { "fme_ip": "127.0.0.1", "name": `LUT: ${name}` });
        return $q(function (resolve, reject) {
            $http({
                //url: REST_ENDPOINT.URI + "elements/" + "luts/" + lut_name,
                url: REST_ENDPOINT.URI + "elements/" + (selfHost ? '127.0.0.1' : fme_ip) + "/luts/" + name + ".cube",
                data: cube_content,
                method: 'POST',
            })
                .success(function (response) {
                //requestStatusSrv.successRequest({ "msg_type": "AddLut", "fme_ip": "127.0.0.1", "name": `LUT: ${name}` });
                if (dbg) {
                    console.log("copyLut:", response);
                }
                ;
                resolve(response);
            })
                .error(function (response) {
                //requestStatusSrv.failedRequest({ "msg_type": "AddLut", "fme_ip": "127.0.0.1", "name": `LUT: ${name}` }, response);
                console.log("copyLut error: " + response.message);
                reject("Error Copying 3D LUT: " + response.message);
            });
        });
    };
    var copyLutMetadata = function (fme_ip, name, cube_content) {
        //copies 3D LUT metadata from remote SMM to (local) SMM with IP = fme_ip
        //equestStatusSrv.addRequest('AddLut', { "fme_ip": "127.0.0.1", "name": `LUT: ${lut_name}` });
        return $q(function (resolve, reject) {
            $http({
                //url: REST_ENDPOINT.URI + "elements/" + "luts/" + lut_name,
                url: REST_ENDPOINT.URI + "elements/" + (selfHost ? '127.0.0.1' : fme_ip) + "/luts/" + name + ".json",
                data: cube_content,
                method: 'POST',
            })
                .success(function (response) {
                //requestStatusSrv.successRequest({ "msg_type": "AddLut", "fme_ip": "127.0.0.1", "name": `LUT: ${lut_name}` });
                if (dbg) {
                    console.log("copyLut:", response);
                }
                ;
                resolve(response);
            })
                .error(function (response) {
                //requestStatusSrv.failedRequest({ "msg_type": "AddLut", "fme_ip": "127.0.0.1", "name": `LUT: ${lut_name}` }, response);
                if (dbg) {
                    console.log("CopyLutMetadata error: " + response);
                }
                ;
                if (dbg) {
                    console.log("CopyLutMetadata error: " + response.message);
                }
                ;
                reject("Error Copying 3D LUT: " + response.message);
            });
        });
    };
    var getLuts_ = function () {
        //get a list of 3D LUTs from a particular FME IP
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/luts",
                method: 'GET'
            })
                .success(function (response) {
                if (dbg) {
                    console.log("getLuts, current list from DB:", response);
                }
                ;
                resolve(response);
            })
                .error(function (response) {
                reject("getLuts error:", response);
            });
        });
    };
    var getLut = function (name) {
        //get a specific LUT
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/luts/" + name + ".cube",
                method: 'GET'
            })
                .success(function (response) {
                if (dbg) {
                    console.log("getLut, current list from DB:", response);
                }
                ;
                resolve(response);
            })
                .error(function (response) {
                reject("getLut error:", response);
            });
        });
    };
    var getLutMetadata = function (name) {
        //get metadata of specific 3D LUT
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/luts/" + name + ".json",
                method: 'GET'
            })
                .success(function (response) {
                if (dbg) {
                    console.log("getLut, current list from DB:", response);
                }
                ;
                resolve(response);
            })
                .error(function (response) {
                reject("getLut error:", response);
            });
        });
    };
    var importLut = function (lut_json, lut_name) {
        //import cube file of specific 3D LUT
        requestStatusSrv.addRequest('AddLut', {
            "fme_ip": "127.0.0.1",
            "name": "LUT: " + lut_name
        });
        return $q(function (resolve, reject) {
            $http({
                //url: REST_ENDPOINT.URI + "elements/" + "luts/" + lut_name,
                url: REST_ENDPOINT.URI + "elements/luts/" + lut_name + ".cube",
                data: lut_json,
                method: 'PUT',
                transformResponse: [
                    commonUtils.plainResponse,
                ],
            })
                .success(function (response) {
                requestStatusSrv.successRequest({
                    "msg_type": "AddLut",
                    "fme_ip": "127.0.0.1",
                    "name": "LUT: " + lut_name
                });
                //console.log("importLut:", response);
                resolve(response);
            })
                .error(function (response) {
                requestStatusSrv.failedRequest({
                    "msg_type": "AddLut",
                    "fme_ip": "127.0.0.1",
                    "name": "LUT: " + lut_name
                }, response);
                reject("Error: " + response);
                //console.log("importLut Error :", response);
            });
        });
    };
    var importLutsMetadata = function (lut_json, lut_name) {
        //import metadata file of specific 3D LUT
        //requestStatusSrv.addRequest('AddLutMetadata', { "fme_ip": "127.0.0.1", "name": `${lut_name}.json` });
        return $q(function (resolve, reject) {
            $http({
                //url: REST_ENDPOINT.URI + "elements/" + "luts/" + lut_name,
                url: REST_ENDPOINT.URI + "elements/luts/" + lut_name + ".json",
                data: lut_json,
                method: 'PUT',
                transformResponse: [
                    commonUtils.plainResponse,
                ],
            })
                .success(function (response) {
                //requestStatusSrv.successRequest({ "msg_type": "AddLutMetadata", "fme_ip": "127.0.0.1", "name": `${lut_name}.json` });
                //console.log("importLutMetadata:", response);
                resolve(response);
            })
                .error(function (response) {
                //requestStatusSrv.failedRequest({ "msg_type": "AddLutMetadata", "fme_ip": "127.0.0.1", "name": `${lut_name}.json` }, response);
                reject("importLutMetadata error:", response);
                //console.log("importMetadata Error :", response);
            });
        });
    };
    var updateLuts = function (lut_json, lut_name) {
        //update metadata of specific LUT
        //requestStatusSrv.addRequest('UpdateLutMetadata', { "fme_ip": "127.0.0.1", "name": lut_name });
        return $q(function (resolve, reject) {
            $http({
                url: REST_ENDPOINT.URI + "elements/luts/" + lut_name,
                data: lut_json,
                method: 'PUT',
                transformResponse: [
                    commonUtils.plainResponse,
                ],
            })
                .success(function (response) {
                //requestStatusSrv.successRequest({ "msg_type": "UpdateLutMetadata", "fme_ip": "127.0.0.1", "name": lut_name });
                if (dbg) {
                    console.log("updateLutMetadata:", response);
                }
                ;
                resolve(response);
            })
                .error(function (response) {
                //requestStatusSrv.failedRequest({ "msg_type": "UpdateLutMetadata", "fme_ip": "127.0.0.1", "name": lut_name }, response);
                reject("updateLutMetadata error:", response);
            });
        });
    };
    var rmvLuts = function (lut_name) {
        //delet selected 3D LUT
        var jsonObjStatus = {
            "fme_ip": "127.0.0.1",
            "name": "LUT: " + lut_name
        };
        requestStatusSrv.addRequest('RmvLut', jsonObjStatus);
        return $q(function (resolve, reject) {
            var parsedJsonObj = {
                fme_ip: "127.0.0.1",
                name: "LUT: " + lut_name,
                msg_type: 'RmvLut',
            };
            $http({
                url: REST_ENDPOINT.URI + "elements/luts/" + lut_name,
                method: 'DELETE'
            })
                .then(function (response) {
                // success
                requestStatusSrv.successRequest(parsedJsonObj);
                if (dbg) {
                    console.log("rmvLuts success:", response);
                }
                ;
                resolve(response);
            }, function (response) {
                //failure
                requestStatusSrv.failedRequest(parsedJsonObj, (response.statusText + ': ' + response.data));
                reject("rmvLuts error:", response.data);
            });
        });
    };
    return {
        getDbg: getDbg,
        getLuts: getLuts,
        copyLut: copyLut,
        copyLutMetadata: copyLutMetadata,
        getLuts_: getLuts_,
        getLut: getLut,
        getLutMetadata: getLutMetadata,
        importLut: importLut,
        importLutsMetadata: importLutsMetadata,
        updateLuts: updateLuts,
        rmvLuts: rmvLuts,
    }; // ES6 syntax
};


/***/ }),

/***/ "./app/config-menu/mcl-panel/mcl-panel.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var mcl_panel_controller_1 = __webpack_require__("./app/config-menu/mcl-panel/mcl-panel.controller.ts");
var templateUrl = __webpack_require__("./app/config-menu/mcl-panel/mcl-panel.template.html");
exports.createPCSModalWindowComponent = function (library) {
    return library.open({
        animation: true,
        backdrop: "static",
        size: "wide",
        templateUrl: templateUrl,
        controller: mcl_panel_controller_1.PCSModalWindowController,
    });
};


/***/ }),

/***/ "./app/config-menu/mcl-panel/mcl-panel.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {
Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var common_1 = __webpack_require__("./app/view-menu/common.js");
var PCSModalWindowController = (function () {
    function PCSModalWindowController($scope, $location, $uibModalInstance, fmeListSrv, snpListSrv, uiModalsSrv, commonUtils) {
        this.defaultPanelNameEnumLabels = [];
        $scope.selfHost = commonUtils.smmParam("SELF_HOST", "false") === "true";
        $scope.configChanged = false;
        $("input:file").val("");
        $scope.importFile = {};
        $scope.fme_ip = fmeListSrv.getLastUsedElement()["ip"] ||
            $scope.fmeList.filter($scope.fmeFilter).filter($scope.fmeTypeFilter)[0]["ip"];
        $scope.statusHeaders = [
            {
                fme_ip: $scope.fme_ip,
                type: common_1.SNP_OBJTYPE_PCS,
                object_ID: common_1.SNP_OBJTYPE_PCS,
            }
        ];
        $scope.report = undefined;
        $scope.isContentVisible = function () {
            return $scope.config ? true : false;
        };
        var updateChannelList = function () {
            var channelList = [];
            var channelIds = [];
            $scope.config.pcs.config.MclSectionTable.forEach(function (item) {
                if (item.delete == false) {
                    channelList.push(item.channelName);
                    channelIds.push(item.idx);
                }
            });
            //console.log(channelList);
            //console.log(channelIds);
            $scope.config.pcs.meta.properties.GroupTable.items.properties.groupChannels.enum = channelIds;
            $scope.config.pcs.meta.properties.GroupTable.items.properties.groupChannels.enumLabels = channelList;
            $scope.$broadcast('adjustedMetadata', {
                property: "/GroupTable"
            });
        };
        var updateGroupList = function () {
            var groupList = [];
            var groupIds = [];
            $scope.config.pcs.config.GroupTable.forEach(function (item) {
                if (item.delete == false) {
                    groupList.push(item.groupName);
                    groupIds.push(item.idx);
                }
            });
            //console.log(groupList);
            //console.log(groupIds);
            $scope.config.pcs.meta.properties.PanelTable.items.properties.panelGroupsSupported.enum = groupIds;
            $scope.config.pcs.meta.properties.PanelTable.items.properties.panelGroupsSupported.enumLabels = groupList;
            updateButtonMappingEnumList(groupList);
            $scope.$broadcast('adjustedMetadata', {
                property: "/PanelTable"
            });
        };
        var updateButtonMappingEnumList = function (groupList) {
            $scope.config.pcs.meta.properties.PanelLayoutTable.items.properties.buttonMapping.items.enumLabels = angular_1.copy($scope.defaultPanelNameEnumLabels);
            var groupListIdx = 0;
            $scope.config.pcs.meta.properties.PanelLayoutTable.items.properties.buttonMapping.items.enumLabels.forEach(function (label, index) {
                if (label.startsWith("Group") && label.endsWith("Select")) {
                    if (groupListIdx < groupList.length)
                        $scope.config.pcs.meta.properties.PanelLayoutTable.items.properties.buttonMapping.items.enumLabels[index] = "GN" + (groupListIdx + 1) + ": " + groupList[groupListIdx++];
                }
            });
            $scope.$broadcast('adjustedMetadata', {
                property: "/PanelLayoutTable"
            });
        };
        var updateLayoutList = function () {
            var layoutList = ["Default", "Default 16 Channels", "Default 30 Channels"];
            var layoutIds = [0, -1, -2];
            $scope.config.pcs.config.PanelLayoutTable.forEach(function (item) {
                if (item.delete == false) {
                    layoutList.push(item.layoutName);
                    layoutIds.push(item.idx);
                }
            });
            console.log(layoutIds);
            console.log(layoutList);
            $scope.config.pcs.meta.properties.PanelTable.items.properties.panelLayout.enum = layoutIds;
            $scope.config.pcs.meta.properties.PanelTable.items.properties.panelLayout.enumLabels = layoutList;
            $scope.$broadcast('adjustedMetadata', {
                property: "/PanelTable"
            });
        };
        $scope.getMclSectionStatusByIndex = function (idx) {
            for (var i = 0; i < 128; ++i) {
                if ($scope.status.pcs.status.MclSectionTableStatus[i].idx == idx) {
                    return $scope.status.pcs.status.MclSectionTableStatus[i].mclSectionStatus;
                }
            }
            return 'Unknown';
        };
        $scope.getGroupStatusByIndex = function (idx) {
            for (var i = 0; i < 32; ++i) {
                if ($scope.status.pcs.status.GroupTableStatus[i].idx == idx) {
                    return $scope.status.pcs.status.GroupTableStatus[i].groupStatus;
                }
            }
            return 'Unknown';
        };
        $scope.getPanelStatusByIndex = function (idx) {
            for (var i = 0; i < 32; ++i) {
                if ($scope.status.pcs.status.PanelTableStatus[i].idx == idx) {
                    return $scope.status.pcs.status.PanelTableStatus[i].panelStatus;
                }
            }
            return 'Unknown';
        };
        var onReceiveStatusHandler = function (status) {
            if (status.object_ID === common_1.SNP_OBJTYPE_PCS) {
                $scope.status.pcs.status = status;
            }
        };
        var compareByIdx = function (a, b) {
            if (a.idx > b.idx) {
                return 1;
            }
            else if (a.idx < b.idx) {
                return -1;
            }
            else {
                return 0;
            }
        };
        var initialize = function () {
            var requirePropObjs = [
                {
                    type: common_1.SNP_OBJTYPE_PCS,
                    object_ID: common_1.SNP_OBJTYPE_PCS,
                    getConfig: true,
                    getStatus: true,
                }
            ];
            snpListSrv.getObjects($scope.fme_ip, requirePropObjs).then(function (resolve) {
                $scope.config = {
                    pcs: {
                        config: resolve[common_1.SNP_OBJTYPE_PCS].config,
                        meta: resolve[common_1.SNP_OBJTYPE_PCS].configMetadata
                    }
                };
                console.log($scope.config);
                $scope.status = {
                    pcs: {
                        status: resolve[common_1.SNP_OBJTYPE_PCS].status,
                        meta: resolve[common_1.SNP_OBJTYPE_PCS].statusMetadata
                    }
                };
                console.log($scope.status);
                fmeListSrv.msgStatusSubscribe(onReceiveStatusHandler, $scope.statusHeaders);
                $scope.config.pcs.config.MclSectionTable.sort(compareByIdx);
                $scope.config.pcs.config.GroupTable.sort(compareByIdx);
                $scope.config.pcs.config.PanelTable.sort(compareByIdx);
                $scope.config.pcs.config.PanelLayoutTable.sort(compareByIdx);
                $scope.defaultPanelNameEnumLabels = angular_1.copy($scope.config.pcs.meta.properties.PanelLayoutTable.items.properties.buttonMapping.items.enumLabels);
                updateChannelList();
                updateGroupList();
                updateLayoutList();
            }, function (reject) {
                console.log("Failed to get PCS: ", reject);
            });
        };
        var getFreeIdx = function (objectArr) {
            var idxArray = [];
            objectArr.forEach(function (item) {
                if (!!item.idx) {
                    idxArray.push(item.idx);
                }
            });
            idxArray.sort(function (a, b) {
                return a - b;
            });
            //console.log(idxArray);
            var freeIdx = 1;
            idxArray.forEach(function (idx) {
                if (idx == freeIdx) {
                    freeIdx += 1;
                }
            });
            return freeIdx;
        };
        var stripIdFromList = function (id, idlist) {
            var ids = idlist.split(";");
            var newlist = "";
            for (var i = 0; i < ids.length; ++i) {
                if (ids[i] != id.toString()) {
                    if (newlist !== "") {
                        newlist += ";";
                    }
                    newlist += ids[i];
                }
            }
            return newlist;
        };
        var replaceIdInList = function (oldId, newId, idlist) {
            var ids = idlist.split(";");
            var newlist = "";
            for (var i = 0; i < ids.length; ++i) {
                if (newlist !== "") {
                    newlist += ";";
                }
                if (ids[i] != oldId.toString()) {
                    newlist += ids[i];
                }
                else {
                    newlist += newId;
                }
            }
            return newlist;
        };
        $scope.validateChannel = function (data, devices) {
            if (!data.channelName || data.channelName.trim() === "") {
                return "Please enter a name.";
            }
            var proposed = data.channelName.trim().toLowerCase();
            //  Uniqueness among non-deleted channels (exclude the row being edited)
            var isDuplicate = (devices || []).some(function (item) {
                return item.delete !== true &&
                    item.channelName &&
                    item.channelName.trim().toLowerCase() === proposed &&
                    item.idx !== data.idx;
            });
            if (isDuplicate) {
                return "Channel name must be unique.";
            }
            var activeCount = (devices || []).filter(function (item) { return item.delete !== true; }).length;
            if ((!data.idx || data.idx === undefined) && activeCount >= 128) {
                return "Maximum number of channels (128) reached.";
            }
            // valid -> return nothing
        };
        $scope.validateGroup = function (data, devices) {
            // 1) Required
            if (!data.groupName || data.groupName.trim() === "") {
                return "Please enter a name.";
            }
            // Normalize once
            var proposed = data.groupName.trim().toLowerCase();
            // Uniqueness among non-deleted groups (exclude the row being edited)
            var isDuplicate = (devices || []).some(function (item) {
                return item.delete !== true &&
                    item.groupName &&
                    item.groupName.trim().toLowerCase() === proposed &&
                    item.idx !== data.idx;
            });
            if (isDuplicate) {
                return "Group name must be unique.";
            }
            var activeCount = (devices || []).filter(function (item) { return item.delete !== true; }).length;
            if ((!data.idx || data.idx === undefined) && activeCount >= 32) {
                return "Maximum number of groups (32) reached.";
            }
            // valid -> return nothing
        };
        $scope.validatePanel = function (data, devices) {
            if (data.panelName == "") {
                return "Please enter a name.";
            }
            // Normalize once
            var proposed = data.panelName.trim().toLowerCase();
            // Uniqueness among non-deleted groups (exclude the row being edited)
            var isDuplicate = (devices || []).some(function (item) {
                return item.delete !== true &&
                    item.panelName &&
                    item.panelName.trim().toLowerCase() === proposed &&
                    item.idx !== data.idx;
            });
            if (isDuplicate) {
                return "Panel name must be unique.";
            }
        };
        $scope.validateLayout = function (data, devices) {
            if (data.layoutName == "") {
                return "Please enter a name.";
            }
            // Normalize once
            var proposed = data.layoutName.trim().toLowerCase();
            // Uniqueness among non-deleted groups (exclude the row being edited)
            var isDuplicate = (devices || []).some(function (item) {
                return item.delete !== true &&
                    item.layoutName &&
                    item.layoutName.trim().toLowerCase() === proposed &&
                    item.idx !== data.idx;
            });
            if (isDuplicate) {
                return "Layout name must be unique.";
            }
        };
        $scope.onChannelChanged = function (oldData, newData) {
            console.log(oldData, newData);
            if (newData.delete == true) {
                $scope.config.pcs.config.GroupTable.forEach(function (item) {
                    item.groupChannels = stripIdFromList(newData.idx, item.groupChannels);
                });
            }
            $scope.configChanged = true;
            updateChannelList();
        };
        $scope.onGroupChanged = function (oldData, newData) {
            console.log(oldData, newData);
            if (newData.delete == true) {
                $scope.config.pcs.config.PanelTable.forEach(function (item) {
                    item.panelGroupsSupported = stripIdFromList(newData.idx, item.panelGroupsSupported);
                });
            }
            $scope.configChanged = true;
            updateGroupList();
        };
        $scope.onPanelChanged = function (oldData, newData) {
            console.log(oldData, newData);
            $scope.configChanged = true;
        };
        $scope.onLayoutChanged = function (oldData, newData) {
            console.log(oldData, newData);
            if (newData.delete == true) {
                $scope.config.pcs.config.PanelTable.forEach(function (item) {
                    if (item.panelLayout == newData.idx) {
                        item.panelLayout = 0;
                        console.log("Reset mapping on panel idx=" + item.idx);
                    }
                });
            }
            $scope.configChanged = true;
            updateLayoutList();
        };
        $scope.openAddModal = function (type, data) {
            if (data === void 0) { data = null; }
            var meta;
            var devices;
            var validationFunc;
            if (type === "mcl-section") {
                meta = $scope.config.pcs.meta.properties.MclSectionTable;
                devices = $scope.config.pcs.config.MclSectionTable;
                validationFunc = $scope.validateChannel;
            }
            else if (type === "mcl-group") {
                meta = $scope.config.pcs.meta.properties.GroupTable;
                devices = $scope.config.pcs.config.GroupTable;
                validationFunc = $scope.validateGroup;
            }
            else if (type === "mcl-panel") {
                meta = $scope.config.pcs.meta.properties.PanelTable;
                devices = $scope.config.pcs.config.PanelTable;
                validationFunc = $scope.validatePanel;
            }
            uiModalsSrv
                .openAddExternalDeviceModal({
                type: type,
                meta: meta,
                data: data,
                devices: devices,
                validationFunc: validationFunc
            })
                .result.then(function (result) {
                if (result) {
                    if (type === "mcl-section") {
                        if (result.idx || result.idx === 1) {
                            $scope.config.pcs.config.MclSectionTable.forEach(function (item, i, arr) {
                                if (item.idx == result.idx) {
                                    arr[i] = result;
                                }
                            });
                        }
                        else {
                            result.idx = getFreeIdx($scope.config.pcs.config.MclSectionTable);
                            $scope.config.pcs.config.MclSectionTable.push(result);
                            $scope.config.pcs.config.MclSectionTable.sort(compareByIdx);
                        }
                        updateChannelList();
                    }
                    else if (type === "mcl-group") {
                        if (result.idx || result.idx === 1) {
                            $scope.config.pcs.config.GroupTable.forEach(function (item, i, arr) {
                                if (item.idx == result.idx) {
                                    arr[i] = result;
                                }
                            });
                        }
                        else {
                            result.idx = getFreeIdx($scope.config.pcs.config.GroupTable);
                            $scope.config.pcs.config.GroupTable.push(result);
                            $scope.config.pcs.config.GroupTable.sort(compareByIdx);
                        }
                        updateGroupList();
                    }
                    else if (type === "mcl-panel") {
                        if (result.idx || result.idx === 1) {
                            $scope.config.pcs.config.PanelTable.forEach(function (item, i, arr) {
                                if (item.idx == result.idx) {
                                    arr[i] = result;
                                }
                            });
                        }
                        else {
                            result.idx = getFreeIdx($scope.config.pcs.config.PanelTable);
                            $scope.config.pcs.config.PanelTable.push(result);
                            $scope.config.pcs.config.PanelTable.sort(compareByIdx);
                        }
                    }
                    $scope.configChanged = true;
                }
            });
        };
        $scope.removeDevice = function (type, idx) {
            if (type === "mcl-section") {
                $scope.config.pcs.config.MclSectionTable.forEach(function (item) {
                    if (item.idx == idx) {
                        item.delete = true;
                    }
                });
                $scope.config.pcs.config.GroupTable.forEach(function (item) {
                    item.groupChannels = stripIdFromList(idx, item.groupChannels);
                });
                $scope.configChanged = true;
                updateChannelList();
            }
            else if (type === "mcl-group") {
                $scope.config.pcs.config.GroupTable.forEach(function (item) {
                    if (item.idx == idx) {
                        item.delete = true;
                    }
                });
                $scope.config.pcs.config.PanelTable.forEach(function (item) {
                    item.panelGroupsSupported = stripIdFromList(idx, item.panelGroupsSupported);
                });
                $scope.configChanged = true;
                updateGroupList();
            }
            else if (type === "mcl-panel") {
                $scope.config.pcs.config.PanelTable.forEach(function (item) {
                    if (item.idx == idx) {
                        item.delete = true;
                    }
                });
                $scope.configChanged = true;
            }
        };
        $scope.apply = function () {
            var partial = angular_1.copy($scope.config.pcs.config);
            //console.log(partial);
            return snpListSrv.applyPartialUpdate(partial, function (report) {
                //console.log(report);
                if (!report) {
                    $scope.configChanged = false;
                    initialize();
                    $scope.report = undefined;
                }
                else {
                    console.log(report);
                    $scope.report = report;
                }
            });
        };
        var mergeLists = function (dest, source) {
            // console.log(dest, source);
            source.forEach(function (srcItem) {
                var isOverwritten = false;
                dest.forEach(function (dstItem, i, arr) {
                    if (dstItem.idx === srcItem.idx) {
                        arr[i] = srcItem;
                        isOverwritten = true;
                    }
                });
                if (!isOverwritten) {
                    dest.push(srcItem);
                }
            });
        };
        $scope.importConfig = function () {
            if ($scope.importFile.jsonfile != undefined && !!$scope.importFile.jsonfile) {
                var jsonContent = JSON.parse($scope.importFile.jsonfile);
                //console.log(jsonContent);
                if (jsonContent.type != common_1.SNP_OBJTYPE_PCS || jsonContent.object_ID != common_1.SNP_OBJTYPE_PCS) {
                    console.log("Incorrect JSON type");
                    return;
                }
                var partial = angular_1.copy($scope.config.pcs.config);
                partial.MclSectionTable.forEach(function (item) {
                    item.delete = true;
                });
                partial.GroupTable.forEach(function (item) {
                    item.delete = true;
                });
                partial.PanelTable.forEach(function (item) {
                    item.delete = true;
                });
                partial.PanelLayoutTable.forEach(function (item) {
                    item.delete = true;
                });
                mergeLists(partial.MclSectionTable, jsonContent.MclSectionTable);
                mergeLists(partial.GroupTable, jsonContent.GroupTable);
                mergeLists(partial.PanelTable, jsonContent.PanelTable);
                mergeLists(partial.PanelLayoutTable, jsonContent.PanelLayoutTable);
                partial.MclSectionTable.sort(compareByIdx);
                partial.GroupTable.sort(compareByIdx);
                partial.PanelTable.sort(compareByIdx);
                partial.PanelLayoutTable.sort(compareByIdx);
                // console.log(partial);
                $("input:file").val("");
                $scope.importFile = {};
                $scope.config.pcs.config = partial;
                $scope.configChanged = true;
                updateChannelList();
                updateGroupList();
            }
        };
        $scope.exportConfig = function () {
            fmeListSrv
                .getObjectForExport($scope.fme_ip, common_1.SNP_OBJTYPE_PCS)
                .then(function (resolve) {
                //console.log(resolve);
                var jsonForExport = resolve.data;
                //console.log(jsonForExport);
                var fileName = common_1.SNP_OBJTYPE_PCS + ".json";
                var configBlob = new Blob([JSON.stringify(jsonForExport)], {
                    type: 'application/json',
                });
                var url = window.URL.createObjectURL(configBlob);
                var a = document.createElement("a");
                document.body.appendChild(a);
                a.href = url;
                a.download = fileName;
                a.click();
                window.URL.revokeObjectURL(url);
                a.remove();
            }, function (reject) {
                console.log(reject);
            });
        };
        $scope.closeModal = function () {
            $uibModalInstance.close();
        };
        $scope.$on("$destroy", function () {
            fmeListSrv.msgStatusUnsubscribe(onReceiveStatusHandler, $scope.statusHeaders);
        });
        initialize();
    }
    return PCSModalWindowController;
}());
exports.PCSModalWindowController = PCSModalWindowController;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__("./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./app/config-menu/mcl-panel/mcl-panel.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
exports.PCSModule = angular_1.module("PCSModule", []);


/***/ }),

/***/ "./app/config-menu/mcl-panel/mcl-panel.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/mcl-panel/mcl-panel.template.html?3ebb11aa1d80619be91def8ec36bde8e";

/***/ }),

/***/ "./app/config-menu/presets/presets-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var presets_modal_window_controller_1 = __webpack_require__("./app/config-menu/presets/presets-modal-window.controller.ts");
var templateUrl = __webpack_require__("./app/config-menu/presets/presets-modal-window.template.html");
exports.createPresetsModalWindowComponent = function (library) {
    return library.open({
        animation: true,
        backdrop: "static",
        size: "wide",
        templateUrl: templateUrl,
        controller: presets_modal_window_controller_1.PresetsModalWindowController,
    });
};


/***/ }),

/***/ "./app/config-menu/presets/presets-modal-window.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {
Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var PresetsModalWindowController = (function () {
    function PresetsModalWindowController($scope, $location, $uibModalInstance, fmeListSrv, userManagerSrv, commonUtils) {
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
        $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        var initialize = function () {
            $scope.fmeList = fmeListSrv.getAllElements();
            $scope.presetList = [];
            $scope.dbg = fmeListSrv.getDbg();
            $scope.loadPreset = {};
            $scope.savePreset = {};
            $("input:file").val("");
            $scope.importPreset = {};
            $scope.destPresetName = "";
            $scope.getPresets();
            $scope.presetNameExist = false;
            $scope.presetError = false;
            $scope.presetErrorMsg = "No Error";
            $scope.sort = "name";
            $scope.reverseSort = "+";
            $scope.getPresets();
            // stop updating FME status
            fmeListSrv.clearUpdateStatus();
            var tempList = $scope.fmeList.filter($scope.fmeFilter);
            if (tempList.length > 0) {
                $scope.loadPreset.fme_ip_address =
                    fmeListSrv.getLastUsedElement()["ip"] ||
                        tempList.filter($scope.fmeTypeFilter)[0]["ip"];
                $scope.savePreset.fme_ip_address =
                    fmeListSrv.getLastUsedElement()["ip"] || tempList[0]["ip"];
            }
        };
        $scope.updatePresetList = function () {
            if (!!fmeListSrv.getLastUsedElement()["ip"] || !!$scope.fmeList.filter($scope.fmeFilter).filter($scope.fmeTypeFilter)[0]) {
                $scope.loadPreset.fme_ip_address = fmeListSrv.getLastUsedElement()["ip"] ||
                    $scope.fmeList.filter($scope.fmeFilter).filter($scope.fmeTypeFilter)[0]["ip"];
            }
            else {
                $scope.loadPreset.fme_ip_address = "";
            }
        };
        $scope.fmeFilter = function (item) {
            if (!!item.state && item.state == "connected") {
                item.label =
                    item.name.length > 0 ? item.name + " (" + item.ip + ")" : item.ip;
                return item;
            }
        };
        $scope.fmeTypeFilter = function (item) {
            var preset = $scope.presetList.find(function (e) {
                return e.name === $scope.loadPreset.name;
            });
            if (!!preset) {
                if (!preset.element_type || preset.element_type === item.fme_type) {
                    return item;
                }
                return;
            }
            else {
                return item;
            }
        };
        $scope.getPresets = function () {
            fmeListSrv.getPresets().then(function (resolve) {
                $scope.presetList = resolve;
                for (var index in $scope.presetList) {
                    if ($scope.presetList[index].last_modified.indexOf("Z") == -1) {
                        $scope.presetList[index].last_modified =
                            $scope.presetList[index].last_modified + "Z";
                    }
                    $scope.presetList[index].last_modified = Date.parse($scope.presetList[index].last_modified);
                }
            }, function (reject) {
                if ($scope.dbg) {
                    console.log("getPresets error:", reject);
                }
            });
        };
        $scope.sortBy = function (sortField) {
            if ($scope.sort === sortField) {
                $scope.reverseSort = $scope.reverseSort === "+" ? "-" : "+";
            }
            else {
                $scope.reverseSort = "+";
                $scope.sort = sortField;
            }
        };
        $scope.getPresetNameExist = function (type) {
            $scope.presetNameExist = false;
            $scope.presetError = false;
            $scope.presetErrorMsg = "No Error";
            var presetName;
            if (type === "save") {
                presetName = $scope.savePreset.name;
            }
            else if (type === "import") {
                if ($scope.importPreset && $scope.importPreset.name) {
                    $scope.destPresetName = $scope.importPreset.name.split(".")[0];
                    presetName = $scope.destPresetName;
                }
            }
            else if (type === "update") {
                presetName = $scope.destPresetName;
            }
            if (angular_1.isDefined($scope.presetList)) {
                $scope.presetNameExist = $scope.presetError = $scope.presetList.some(function (e) {
                    return e.name === presetName;
                });
                if ($scope.presetError == true) {
                    $scope.presetErrorMsg = "Preset name '" + presetName + "' exists, overwrite it with new configurations?";
                }
            }
        };
        // preset name does not go through ng-change, this is a workaround
        $scope.$watch("importPreset.name", function () {
            $scope.getPresetNameExist("import");
        });
        $scope.$watch("destPresetName", function () {
            $scope.getPresetNameExist("update");
        });
        $scope.addSelectedPreset = function () {
            var tmpFme;
            $scope.fmeList.forEach(function (fme) {
                if ($scope.savePreset.fme_ip_address === fme.ip)
                    tmpFme = fme;
            });
            if (tmpFme) {
                if (tmpFme.properties && tmpFme.properties.element_type) {
                    tmpFme.element_type = tmpFme.properties.element_type;
                }
                if (!tmpFme.interface_version) {
                    tmpFme.interface_version = "";
                }
                if (!tmpFme.element_version && !!tmpFme.version) {
                    tmpFme.element_version = tmpFme.version;
                }
            }
            else {
                tmpFme = {
                    element_type: "",
                    interface_version: "",
                    element_version: "",
                };
            }
            fmeListSrv.addPreset($scope.savePreset.fme_ip_address, $scope.savePreset.name, tmpFme.interface_version, tmpFme.element_type, tmpFme.element_version).then(function (resolve) {
                $scope.presetError = false;
                $scope.presetErrorMsg = "No Error";
                $scope.presetNameExist = false;
                $scope.savePreset.name = "";
                if ($scope.savePreset.$dirty) {
                    $scope.savePreset.$setPristine();
                }
                $scope.getPresets();
            }, function (reject) {
                $scope.presetError = true;
                $scope.presetErrorMsg = "Error: " + reject;
                if ($scope.dbg) {
                    console.log("addPreset error:", reject);
                }
            });
        };
        $scope.loadSelectedPreset = function () {
            startLoadPreset();
        };
        $scope.loadSelectedPresetAndReboot = function () {
            startLoadPreset(true);
        };
        function startLoadPreset(rebootAfter) {
            // load preset to selected FME
            fmeListSrv.loadPreset($scope.loadPreset.fme_ip_address, $scope.loadPreset.name, !!rebootAfter).then(function (resolve) {
                $scope.loadPreset.name = "";
                $scope.loadPreset.fme_ip_address = "";
                if ($scope.loadPreset.$dirty) {
                    $scope.loadPreset.$setPristine();
                }
            }, function (reject) {
                if ($scope.dbg) {
                    console.log("loadPreset error:", reject);
                }
            });
        }
        $scope.import = function () {
            // import preset from text file
            var preset_obj = JSON.parse($scope.importPreset.jsonfile);
            preset_obj["fme_ip_address"] = "127.0.0.1";
            var preset_str = JSON.stringify(preset_obj);
            fmeListSrv.importPreset(preset_str, $scope.destPresetName).then(function (resolve) {
                $scope.presetError = false;
                $scope.presetErrorMsg = "No Error";
                $scope.destPresetName = "";
                $("input:file").val("");
                $scope.importPreset = {};
                if ($scope.importPreset.$dirty) {
                    $scope.importPreset.$setPristine();
                }
                $scope.getPresets();
            }, function (reject) {
                $scope.presetError = true;
                $scope.presetErrorMsg = "Error: " + reject;
                if ($scope.dbg) {
                    console.log("importPreset error:", reject);
                }
            });
        };
        $scope.printScope = function () {
            console.log($scope);
        };
        $scope.closeModal = function () {
            $uibModalInstance.close();
        };
        $scope.$on("$destroy", function () {
            // resume update and clear cfgObject service when modal is destroyed
            fmeListSrv.setUpdateStatus();
        });
        function isPresetLoading(fme) {
            return fme.state === "loading-preset" || fme.presetLoaded === false;
        }
        $scope.arePresetsLoading = function () {
            return fmeListSrv.arePresetsLoading();
        };
        $scope.elementsLoadingPresets = function () {
            return $scope.fmeList.filter(isPresetLoading).map(function (fme) { return (fme.ip === "127.0.0.1" ? $location.$$host : fme.ip); }).join(", ");
        };
        initialize();
    }
    return PresetsModalWindowController;
}());
exports.PresetsModalWindowController = PresetsModalWindowController;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__("./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./app/config-menu/presets/presets-modal-window.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/presets/presets-modal-window.template.html?c2b58127ce64e1e8393ef6291d817992";

/***/ }),

/***/ "./app/config-menu/presets/presets-table/presets-table.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var templateUrl = __webpack_require__("./app/config-menu/presets/presets-table/presets-table.template.html");
exports.PresetsTableDirective = function () {
    //Modal for save/load presets
    return {
        scope: {
            presetList: '=',
            sort: '=',
            presetNameExist: '=',
            importName: '=',
            getPresets: '&',
        },
        restrict: "E",
        templateUrl: templateUrl,
        controller: ['$scope', '$timeout', 'fmeListSrv', function ($scope, $timeout, fmeListSrv) {
                $scope.exportError = false;
                $scope.exportPreset = function (presetName) {
                    //export the selected preset as a file via browser (requires HTML5 support)
                    fmeListSrv.getPreset(presetName)
                        .then(function (data) {
                        if (fmeListSrv.getDbg()) {
                            console.log("downloading: /presets/" + presetName + ".prst");
                        }
                        ;
                        var fileName = presetName + ".prst";
                        var prstBlob = new Blob([JSON.stringify(data)], {
                            type: 'application/json',
                        });
                        var url = window.URL.createObjectURL(prstBlob);
                        var a = document.createElement("a");
                        document.body.appendChild(a);
                        a.href = url;
                        a.download = fileName;
                        a.click();
                        window.URL.revokeObjectURL(url);
                        a.remove();
                    }, function (reject) {
                        $scope.exportError = true;
                        $timeout(function () { return $scope.exportError = false; }, 5000);
                        if ($scope.dbg) {
                            console.log("getPresets error:", reject);
                        }
                        ;
                    });
                };
                $scope.rmvSelectedPreset = function (presetName) {
                    //remove selected preset
                    fmeListSrv.rmvPreset(presetName)
                        .then(function (resolve) {
                        $scope.getPresets();
                        if (presetName === $scope.importName) {
                            $scope.presetNameExist = false;
                        }
                    }, function (reject) {
                        if ($scope.dbg) {
                            console.log("removePreset error:", reject);
                        }
                        ;
                    });
                };
            }]
    };
};


/***/ }),

/***/ "./app/config-menu/presets/presets-table/presets-table.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/config-menu/presets/presets-table/presets-table.template.html?505f5f1b669f7416d4759bf32c80d386";

/***/ }),

/***/ "./app/config-menu/presets/presets.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var presets_table_directive_1 = __webpack_require__("./app/config-menu/presets/presets-table/presets-table.directive.ts");
exports.PresetsModule = angular_1.module("presetsModule", [])
    .directive("presetsTable", presets_table_directive_1.PresetsTableDirective);


/***/ }),

/***/ "./app/external/angular-loadscript.js":
/***/ (function(module, exports) {

/*
 *  Angular LoadScript
 *
 *  Let angular load and execute lazy javascript from partials!
 *
 *  This module is the result of  this issue: "1.2.0rc1 regression: script tags not loaded via ngInclude"
 *  Issue url: https://github.com/angular/angular.js/issues/3756
 *
 *  As of Angular 1.2.0 the ngInclude scripts does not permit execution of javascript from included partials.
 *  This little module execute code inside script tags with "javascript-lazy" attribute after partial loading,
 *  thus re-enabling this feature.
 *
 *  ( please have a look at the issue comments, this angular feature was never planned nor included properly,
 *  was only a drawback of using jQuery for partial inclusion )
 *
 *  This angular module have been created by @endorama (https://github.com/endorama) based upon the code
 *  posted by @olostan (https://github.com/olostan)
 *
 *  Simply add this file, load ngLoadScript module as application dependency and use type="text/javascript-lazy"
 *  as type for script you which to load lazily in partials.
 *
 * License: 2013 - released to the Public Domain.
 */

/*global angular */
(function (ng)
{
  'use strict';

  var app = ng.module('ngLoadScript', []);

  app.directive('script', function ()
  {
    return {
      restrict: 'E',
      scope: false,
      link: function (scope, elem, attr)
      {
        if (attr.type == 'text/javascript-lazy')
        {
          var s = document.createElement("script");
          s.type = "text/javascript";
          var src = elem.attr('src');
          if (src !== undefined)
          {
            s.src = src;
          }
          else
          {
            var code = elem.text();
            s.text = code;
          }
          document.head.appendChild(s);
          elem.remove();
        }
      }
    };
  });

}(angular));


/***/ }),

/***/ "./app/external/draganddrop.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* WEBPACK VAR INJECTION */(function(__webpack_provided_window_dot_jQuery) {/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular__ = __webpack_require__("./node_modules/angular/index.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_angular__);


(function (angular)
{
  'use strict';

  function isDnDsSupported ()
  {
    return 'ondrag' in document.createElement('a');
  }

  function determineEffectAllowed (e)
  {
    // Chrome doesn't set dropEffect, so we have to work it out ourselves
    if (typeof e.dataTransfer !== 'undefined' && e.dataTransfer.dropEffect === 'none')
    {
      if (e.dataTransfer.effectAllowed === 'copy' ||
        e.dataTransfer.effectAllowed === 'move')
      {
        e.dataTransfer.dropEffect = e.dataTransfer.effectAllowed;
      }
      else if (e.dataTransfer.effectAllowed === 'copyMove' || e.dataTransfer.effectAllowed === 'copymove')
      {
        e.dataTransfer.dropEffect = e.ctrlKey ? 'copy' : 'move';
      }
    }
  }

  if (!isDnDsSupported())
  {
    angular.module('ang-drag-drop', []);
    return;
  }

  if (__webpack_provided_window_dot_jQuery && (-1 === __webpack_provided_window_dot_jQuery.event.props.indexOf('dataTransfer')))
  {
    __webpack_provided_window_dot_jQuery.event.props.push('dataTransfer');
  }

  var module = angular.module('ang-drag-drop', []);

  module.directive('uiDraggable', ['$parse', '$rootScope', '$dragImage', function ($parse, $rootScope, $dragImage)
  {
    return function (scope, element, attrs)
    {
      var isDragHandleUsed = false,
        dragHandleClass,
        draggingClass = attrs.draggingClass || 'on-dragging',
        dragTarget;

      element.attr('draggable', false);

      scope.$watch(attrs.uiDraggable, function (newValue)
      {
        if (newValue)
        {
          element.attr('draggable', newValue);
          element.bind('dragend', dragendHandler);
          element.bind('dragstart', dragstartHandler);
        }
        else
        {
          element.removeAttr('draggable');
          element.unbind('dragend', dragendHandler);
          element.unbind('dragstart', dragstartHandler);
        }

      });

      if (angular.isString(attrs.dragHandleClass))
      {
        isDragHandleUsed = true;
        dragHandleClass = attrs.dragHandleClass.trim() || 'drag-handle';

        element.bind('mousedown', function (e)
        {
          dragTarget = e.target;
        });
      }

      function dragendHandler (e)
      {
        setTimeout(function ()
        {
          element.unbind('$destroy', dragendHandler);
        }, 0);
        var sendChannel = attrs.dragChannel || 'defaultchannel';
        $rootScope.$broadcast('ANGULAR_DRAG_END', e, sendChannel);

        determineEffectAllowed(e);

        if (e.dataTransfer && e.dataTransfer.dropEffect !== 'none')
        {
          if (attrs.onDropSuccess)
          {
            var onDropSuccessFn = $parse(attrs.onDropSuccess);
            scope.$evalAsync(function ()
            {
              onDropSuccessFn(scope,
              {
                $event: e
              });
            });
          }
        }
        else if (e.dataTransfer && e.dataTransfer.dropEffect === 'none')
        {
          if (attrs.onDropFailure)
          {
            var onDropFailureFn = $parse(attrs.onDropFailure);
            scope.$evalAsync(function ()
            {
              onDropFailureFn(scope,
              {
                $event: e
              });
            });
          }
        }
        element.removeClass(draggingClass);
      }

      function setDragElement (e, dragImageElementId)
      {
        var dragImageElementFn;

        if (!(e && e.dataTransfer && e.dataTransfer.setDragImage))
        {
          return;
        }

        dragImageElementFn = $parse(dragImageElementId);

        scope.$apply(function ()
        {
          var elementId = dragImageElementFn(scope,
            {
              $event: e
            }),
            dragElement;

          if (!(elementId && angular.isString(elementId)))
          {
            return;
          }

          dragElement = document.getElementById(elementId);

          if (!dragElement)
          {
            return;
          }

          e.dataTransfer.setDragImage(dragElement, 0, 0);
        });
      }

      function dragstartHandler (e)
      {
        var isDragAllowed = !isDragHandleUsed || dragTarget.classList.contains(dragHandleClass);

        if (isDragAllowed)
        {
          var sendChannel = attrs.dragChannel || 'defaultchannel';
          var dragData = '';
          if (attrs.drag)
          {
            dragData = scope.$eval(attrs.drag);
          }

          var dragImage = attrs.dragImage || null;

          element.addClass(draggingClass);
          element.bind('$destroy', dragendHandler);

          //Code to make sure that the setDragImage is available. IE 10, 11, and Opera do not support setDragImage.
          var hasNativeDraggable = !(document.uniqueID || window.opera);

          //If there is a draggable image passed in, then set the image to be dragged.
          if (dragImage && hasNativeDraggable)
          {
            var dragImageFn = $parse(attrs.dragImage);
            scope.$apply(function ()
            {
              var dragImageParameters = dragImageFn(scope,
              {
                $event: e
              });
              if (dragImageParameters)
              {
                if (angular.isString(dragImageParameters))
                {
                  dragImageParameters = $dragImage.generate(dragImageParameters);
                }
                if (dragImageParameters.image)
                {
                  var xOffset = dragImageParameters.xOffset || 0,
                    yOffset = dragImageParameters.yOffset || 0;
                  e.dataTransfer.setDragImage(dragImageParameters.image, xOffset, yOffset);
                }
              }
            });
          }
          else if (attrs.dragImageElementId)
          {
            setDragElement(e, attrs.dragImageElementId);
          }

          var offset = {
            x: e.originalEvent.offsetX,
            y: e.originalEvent.offsetY
          };
          var transferDataObject = {
            data: dragData,
            channel: sendChannel,
            offset: offset
          };
          var transferDataText = angular.toJson(transferDataObject);

          e.dataTransfer.setData('text', transferDataText);
          e.dataTransfer.effectAllowed = 'copyMove';

          $rootScope.$broadcast('ANGULAR_DRAG_START', e, sendChannel, transferDataObject);
        }
        else
        {
          e.preventDefault();
        }
      }
    };
  }]);

  module.directive('uiOnDrop', ['$parse', '$rootScope', function ($parse, $rootScope)
  {
    return function (scope, element, attr)
    {
      var dragging = 0; //Ref. http://stackoverflow.com/a/10906204
      var dropChannel = attr.dropChannel || 'defaultchannel';
      var dragChannel = '';
      var dragEnterClass = attr.dragEnterClass || 'on-drag-enter';
      var dragHoverClass = attr.dragHoverClass || 'on-drag-hover';
      var customDragEnterEvent = $parse(attr.onDragEnter);
      var customDragLeaveEvent = $parse(attr.onDragLeave);

      function calculateDropOffset (e)
      {
        var offset = {
          x: e.originalEvent.offsetX,
          y: e.originalEvent.offsetY
        };
        var target = e.originalEvent.target;

        while (target !== element[0])
        {
          offset.x = offset.x + target.offsetLeft;
          offset.y = offset.y + target.offsetTop;

          target = target.offsetParent;
          if (!target)
          {
            return null;
          }
        }

        return offset;
      }

      function onDragOver (e)
      {
        if (e.preventDefault)
        {
          e.preventDefault(); // Necessary. Allows us to drop.
        }

        if (e.stopPropagation)
        {
          e.stopPropagation();
        }

        var uiOnDragOverFn = $parse(attr.uiOnDragOver);
        scope.$evalAsync(function ()
        {
          uiOnDragOverFn(scope,
          {
            $event: e,
            $channel: dropChannel
          });
        });

        return false;
      }

      function onDragLeave (e)
      {
        if (e.preventDefault)
        {
          e.preventDefault();
        }

        if (e.stopPropagation)
        {
          e.stopPropagation();
        }
        dragging--;

        if (dragging === 0)
        {
          scope.$evalAsync(function ()
          {
            customDragLeaveEvent(scope,
            {
              $event: e,
              $channel: dropChannel
            });
          });
          element.addClass(dragEnterClass);
          element.removeClass(dragHoverClass);
        }

        var uiOnDragLeaveFn = $parse(attr.uiOnDragLeave);
        scope.$evalAsync(function ()
        {
          uiOnDragLeaveFn(scope,
          {
            $event: e,
            $channel: dropChannel
          });
        });
      }

      function onDragEnter (e)
      {
        if (e.preventDefault)
        {
          e.preventDefault();
        }

        if (e.stopPropagation)
        {
          e.stopPropagation();
        }

        if (dragging === 0)
        {
          scope.$evalAsync(function ()
          {
            customDragEnterEvent(scope,
            {
              $event: e,
              $channel: dropChannel
            });
          });
          element.removeClass(dragEnterClass);
          element.addClass(dragHoverClass);
        }
        dragging++;

        var uiOnDragEnterFn = $parse(attr.uiOnDragEnter);
        scope.$evalAsync(function ()
        {
          uiOnDragEnterFn(scope,
          {
            $event: e,
            $channel: dropChannel
          });
        });

        $rootScope.$broadcast('ANGULAR_HOVER', dragChannel);
      }

      function onDrop (e)
      {
        if (e.preventDefault)
        {
          e.preventDefault(); // Necessary. Allows us to drop.
        }
        if (e.stopPropagation)
        {
          e.stopPropagation(); // Necessary. Allows us to drop.
        }

        var sendData = e.dataTransfer.getData('text');
        sendData = angular.fromJson(sendData);

        var dropOffset = calculateDropOffset(e);

        var position = dropOffset ?
        {
          x: dropOffset.x - sendData.offset.x,
          y: dropOffset.y - sendData.offset.y
        } : null;

        determineEffectAllowed(e);

        var uiOnDropFn = $parse(attr.uiOnDrop);
        scope.$evalAsync(function ()
        {
          uiOnDropFn(scope,
          {
            $data: sendData.data,
            $event: e,
            $channel: sendData.channel,
            $position: position
          });
        });
        element.removeClass(dragEnterClass);
        dragging = 0;
      }

      function isDragChannelAccepted (dragChannel, dropChannel)
      {
        if (dropChannel === '*')
        {
          return true;
        }

        var channelMatchPattern = new RegExp('(\\s|[,])+(' + dragChannel + ')(\\s|[,])+', 'i');

        return channelMatchPattern.test(',' + dropChannel + ',');
      }

      function preventNativeDnD (e)
      {
        if (e.preventDefault)
        {
          e.preventDefault();
        }
        if (e.stopPropagation)
        {
          e.stopPropagation();
        }
        e.dataTransfer.dropEffect = 'none';
        return false;
      }

      var deregisterDragStart = $rootScope.$on('ANGULAR_DRAG_START', function (_, e, channel, transferDataObject)
      {
        dragChannel = channel;

        var valid = true;

        if (!isDragChannelAccepted(channel, dropChannel))
        {
          valid = false;
        }

        if (valid && attr.dropValidate)
        {
          var validateFn = $parse(attr.dropValidate);
          valid = validateFn(scope,
          {
            $drop:
            {
              scope: scope,
              element: element
            },
            $event: e,
            $data: transferDataObject.data,
            $channel: transferDataObject.channel
          });
        }

        if (valid)
        {
          element.bind('dragover', onDragOver);
          element.bind('dragenter', onDragEnter);
          element.bind('dragleave', onDragLeave);
          element.bind('drop', onDrop);

          element.addClass(dragEnterClass);
        }
        else
        {
          element.bind('dragover', preventNativeDnD);
          element.bind('dragenter', preventNativeDnD);
          element.bind('dragleave', preventNativeDnD);
          element.bind('drop', preventNativeDnD);

          element.removeClass(dragEnterClass);
        }

      });


      var deregisterDragEnd = $rootScope.$on('ANGULAR_DRAG_END', function ()
      {
        element.unbind('dragover', onDragOver);
        element.unbind('dragenter', onDragEnter);
        element.unbind('dragleave', onDragLeave);

        element.unbind('drop', onDrop);
        element.removeClass(dragHoverClass);
        element.removeClass(dragEnterClass);

        element.unbind('dragover', preventNativeDnD);
        element.unbind('dragenter', preventNativeDnD);
        element.unbind('dragleave', preventNativeDnD);
        element.unbind('drop', preventNativeDnD);
      });

      scope.$on('$destroy', function ()
      {
        deregisterDragStart();
        deregisterDragEnd();
      });


      attr.$observe('dropChannel', function (value)
      {
        if (value)
        {
          dropChannel = value;
        }
      });


    };
  }]);

  module.constant('$dragImageConfig',
  {
    height: 20,
    width: 200,
    padding: 10,
    font: 'bold 11px Arial',
    fontColor: '#eee8d5',
    backgroundColor: '#93a1a1',
    xOffset: 0,
    yOffset: 0
  });

  module.service('$dragImage', ['$dragImageConfig', function (defaultConfig)
  {
    var ELLIPSIS = '…';

    function fitString (canvas, text, config)
    {
      var width = canvas.measureText(text).width;
      if (width < config.width)
      {
        return text;
      }
      while (width + config.padding > config.width)
      {
        text = text.substring(0, text.length - 1);
        width = canvas.measureText(text + ELLIPSIS).width;
      }
      return text + ELLIPSIS;
    }

    this.generate = function (text, options)
    {
      var config = angular.extend(
      {}, defaultConfig, options ||
      {});
      var el = document.createElement('canvas');

      el.height = config.height;
      el.width = config.width;

      var canvas = el.getContext('2d');

      canvas.fillStyle = config.backgroundColor;
      canvas.fillRect(0, 0, config.width, config.height);
      canvas.font = config.font;
      canvas.fillStyle = config.fontColor;

      var title = fitString(canvas, text, config);
      canvas.fillText(title, 4, config.padding + 4);

      var image = new Image();
      image.src = el.toDataURL();

      return {
        image: image,
        xOffset: config.xOffset,
        yOffset: config.yOffset
      };
    };
  }]);

}(__WEBPACK_IMPORTED_MODULE_0_angular__));

/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__("./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./app/fme/fme-list.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular = __webpack_require__("./node_modules/angular/index.js");
var FmeListService = (function () {
    function FmeListService($http, $q, $timeout, $interval, CacheFactory, userManagerSrv, fmmStateSrv, requestStatusSrv, fmeModalsSrv, OBJ_KEY, REST_ENDPOINT, logsSrv, commonUtils) {
        var myFactory = {};
        var currentIp = {};
        var fmeList = []; //status
        var update = true;
        var updateObjectStatus = false;
        var dbg = false;
        var dummyData = false;
        var fmePolling = null;
        var lastUsedElement; //element last used by user
        var pollingScheduledAtInit = false;
        var pollingStarted = false;
        var reconnect = true;
        var pollCallbacks = []; // array for polling callback functions
        var fmeListCallbacks = []; // array for websocket callback functions
        var alarmCallbacks = []; // array of callbacks for active alarms
        var alarmConfigCallbacks = []; // array of callbacks for alarm configuration
        var testCallbacks = []; // array of callbacks for alarm configuration
        var selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        // setup config and status cache
        var configCache, statusCache;
        if (!CacheFactory.get('configCache')) {
            configCache = CacheFactory('configCache', {
                // init config cache, set default expiration to 1mins
                maxAge: 60 * 1000,
                deleteOnExpire: 'aggressive'
            });
        }
        if (!CacheFactory.get('statusCache')) {
            // init status cache, set default expiration to 5s
            statusCache = CacheFactory('statusCache', {
                maxAge: 5 * 1000,
                deleteOnExpire: 'aggressive'
            });
        }
        myFactory.updateObjectID = undefined;
        //to use offline dummy test object, change dummyData=true
        if (dummyData) {
            update = false;
            $http.get("packages/uifmm/app/fme/dummy-data.json")
                .success(function (response) {
                fmeList.push(response);
            })
                .error(function (error) { });
        }
        function configKey(obj) {
            return obj.fme_ip + "/" + obj.object_ID;
        }
        function statusPath(obj) {
            return "../status/" + obj.fme_ip + "/" + obj.type + "/" + obj.object_ID;
        }
        function globalObjId(obj) {
            return {
                elementIP: selfHost ? "127.0.0.1" : obj.fme_ip,
                objectType: obj.type,
                objectId: obj.object_ID,
            };
        }
        var ws;
        var wsConnected = false;
        var wsConnecting = $q.defer();
        wsConnecting.reject("WebSocket connection not initialized");
        var showWSSCertificateRedirect = true;
        var wssCertificateRedirectModal;
        function wsReconnect() {
            if (!!ws)
                ws.close();
            ws = new WebSocket("wss://" + window.location.hostname + "/smm");
            ws.onopen = wsOnOpen;
            ws.onclose = wsOnClose;
            ws.onerror = wsOnError;
            ws.onmessage = wsOnMessage;
            wsConnecting = $q.defer();
        }
        // key: configKey(object), value: {obj: object, callbacks: array of callbacks}
        var objectSubscriptions = {};
        // key: configKey(object), value: {obj: object, callbacks: array of callbacks, frequency: notification interval}
        var statusSubscriptions = {};
        // key: element IP, value: array of promises
        var objectReceivedPromises = {};
        // key: element IP, value: array of promises
        var statusReceivedPromises = {};
        function wsOnOpen() {
            try {
                ws.send(commonUtils.smm_restapi_token());
            }
            catch (e) {
                console.log('WebSocket connection error:', e);
                ws.close();
                return;
            }
            if (dbg) {
                console.log("WebSocket connected.");
            }
            wsConnected = true;
            wsConnecting.resolve();
            ws.send(JSON.stringify({
                msgType: 'syncMe',
            }));
            // renew existing subscriptions
            Object.keys(statusSubscriptions).forEach(function (key) {
                var subscription = statusSubscriptions[key];
                ws.send(JSON.stringify({
                    msgType: 'statusListSubscribe',
                    objectIds: [globalObjId(subscription.obj)],
                    frequency: subscription.frequency,
                }));
            });
            showWSSCertificateRedirect = false;
            if (wssCertificateRedirectModal) {
                wssCertificateRedirectModal.close();
                wssCertificateRedirectModal = null;
            }
        }
        function wsOnClose() {
            if (dbg) {
                console.log("WebSocket closed.");
            }
            wsConnected = false;
            Object.keys(objectReceivedPromises).forEach(function (key) {
                objectReceivedPromises[key].forEach(function (promise) {
                    promise.reject("WebSocket connection closed");
                });
            });
            objectReceivedPromises = {};
            Object.keys(statusReceivedPromises).forEach(function (key) {
                statusReceivedPromises[key].forEach(function (promise) {
                    promise.reject("WebSocket connection closed");
                });
            });
            statusReceivedPromises = {};
            wsConnecting.reject("WebSocket connection closed");
            if (showWSSCertificateRedirect && fmmStateSrv.fmmConnected()) {
                showWSSCertificateRedirect = false;
                wssCertificateRedirectModal = fmeModalsSrv.openWSSCertificateModal();
            }
            if (reconnect)
                wsReconnect();
            reconnect = true;
        }
        function wsOnError(error) {
            if (typeof error === 'string' && error.includes('expired'))
                commonUtils.smm_restapi_token_refresh();
            console.log("WebSocket error: " + error);
        }
        var statusMs = 2000;
        var objectMs = 2000;
        function wsOnMessage(message) {
            var data = JSON.parse(message.data);
            if (data.msgType === 'objectsState') {
                var objects = data.configurations.map(function (o) {
                    return JSON.parse(o);
                });
                refreshObjects(objects, true);
            }
            else if (data.msgType === 'statusState') {
                refreshStatuses(data.statuses.map(function (o) {
                    return JSON.parse(o);
                }));
            }
            else if (data.msgType === 'allObjects') {
                // TODO here we need to first dump all config objects of the element from the cache
                // this is expensive and most likely we'll need some kind of indexing
                if (!data.configurations || data.configurations.length === 0) {
                    for (var i = 0; i < fmeList.length; i++) {
                        if (fmeList[i].ip === data.elementIp) {
                            fmeList[i].loadingConfigs = true;
                        }
                    }
                    regetAllObjects(data.elementIp, statusMs);
                    objectMs += 500;
                }
                else {
                    objectMs = 2000;
                    refreshObjects(data.configurations.map(function (o) {
                        return JSON.parse(o);
                    }));
                    resolveObjectsReceivedPromises(data.elementIp);
                    for (var i = 0; i < fmeList.length; i++) {
                        if (fmeList[i].ip === data.elementIp) {
                            fmeList[i].loadingConfigs = false;
                        }
                    }
                }
            }
            else if (data.msgType === 'allStatuses') {
                // TODO here we need to first dump all status objects of the element from the cache
                // this is expensive and most likely we'll need some kind of indexing
                if (!data.statuses || data.statuses.length === 0) {
                    regetAllStatuses(data.elementIp, statusMs);
                    statusMs += 500;
                }
                else {
                    statusMs = 2000;
                    refreshStatuses(data.statuses.map(function (o) {
                        return JSON.parse(o);
                    }));
                    resolveStatusReceivedPromises(data.elementIp);
                }
            }
            else if (data.msgType === 'elementStatus') {
                updateFmeList(JSON.parse(data.status));
            }
            else if (data.msgType === 'activeAlarmStatus') {
                refreshActiveAlarms(data.activeAlarms);
            }
            else if (data.msgType === 'successResponse' || data.msgType === 'errorResponse') {
                requestStatusSrv.onWebsocketResponse(data);
            }
            else if (data.msgType === 'unexpectedError') {
                wsOnError(data.error);
            }
            else if (data.msgType === 'alarmConfigure') {
                refreshAlarmConfig(data.alarms);
            }
            else if (data.msgType === 'logsState') {
                logsSrv.update(data);
            }
            else if (data.msgType === 'testStatus') {
                notifyTestStatus(data);
            }
            else if (data.msgType === 'availableTests') {
                notifyAvailableTests(data);
            }
            else if (data.msgType === 'fmmStatus') {
                fmmStateSrv.update(data);
            }
            else if (data.msgType === 'permissionsMsg') {
                userManagerSrv.update(data);
            }
        }
        function refreshObjects(objects, blockSub) {
            objects.forEach(function (obj) {
                var key = configKey(obj);
                obj.cacheKey = key;
                configCache.put(key, obj, {
                    maxAge: Number.MAX_VALUE
                });
                // no subscriptions are available for ipVidTx so a corresponding callback for ipVidRx is called instead
                if (!objectSubscriptions.hasOwnProperty(key) && obj.object_ID === 'ipVidTx')
                    key = obj.fme_ip + '/ipVidRx';
                if (objectSubscriptions.hasOwnProperty(key)) {
                    angular.forEach(objectSubscriptions[key].callbacks, function (callback) {
                        try {
                            callback(obj, blockSub);
                        }
                        catch (e) {
                            console.error(e);
                        }
                    });
                }
            });
        }
        function refreshStatuses(statuses) {
            statuses.forEach(function (obj) {
                var statusURL = statusPath(obj);
                statusCache.put(statusURL, obj, {
                    maxAge: Number.MAX_VALUE
                });
                var key = configKey(obj);
                if (statusSubscriptions.hasOwnProperty(key)) {
                    angular.forEach(statusSubscriptions[key].callbacks, function (callback) {
                        try {
                            callback(obj);
                        }
                        catch (e) {
                            console.error(e);
                        }
                    });
                }
            });
        }
        function refreshActiveAlarms(alarms) {
            angular.forEach(alarmCallbacks, function (callback) {
                try {
                    callback.fn(alarms);
                }
                catch (e) {
                    console.error(e);
                }
            });
        }
        function refreshAlarmConfig(config) {
            angular.forEach(alarmConfigCallbacks, function (callback) {
                try {
                    callback.fn(config);
                }
                catch (e) {
                    console.error(e);
                }
            });
        }
        function notifyTestStatus(status) {
            angular.forEach(testCallbacks, function (callback) {
                try {
                    callback.statusUpdate(status);
                }
                catch (e) {
                    console.error(e);
                }
            });
        }
        function notifyAvailableTests(tests) {
            angular.forEach(testCallbacks, function (callback) {
                try {
                    callback.availableTests(tests);
                }
                catch (e) {
                    console.error(e);
                }
            });
        }
        function resolveObjectsReceivedPromises(elementIP) {
            if (objectReceivedPromises.hasOwnProperty(elementIP)) {
                objectReceivedPromises[elementIP].forEach(function (promise) {
                    promise.resolve();
                });
                delete objectReceivedPromises[elementIP];
            }
        }
        function resolveStatusReceivedPromises(elementIP) {
            if (statusReceivedPromises.hasOwnProperty(elementIP)) {
                statusReceivedPromises[elementIP].forEach(function (promise) {
                    promise.resolve();
                });
                delete statusReceivedPromises[elementIP];
            }
        }
        myFactory.closeWS = function () {
            ws.close();
        };
        myFactory.msgRequestAllObjects = function (elementIP) {
            var msg = {
                msgType: 'getAllObjects',
                elementIp: selfHost ? "127.0.0.1" : elementIP,
            };
            return wsConnecting.promise.then(function () {
                if (!objectReceivedPromises.hasOwnProperty(elementIP)) {
                    objectReceivedPromises[elementIP] = [];
                }
                var deferred = $q.defer();
                objectReceivedPromises[elementIP].push(deferred);
                ws.send(JSON.stringify(msg));
                return deferred.promise;
            });
        };
        myFactory.msgRequestAllStatuses = function (elementIP) {
            var msg = {
                msgType: 'getAllStatuses',
                elementIp: selfHost ? "127.0.0.1" : elementIP,
            };
            return wsConnecting.promise.then(function () {
                if (!statusReceivedPromises.hasOwnProperty(elementIP)) {
                    statusReceivedPromises[elementIP] = [];
                }
                var deferred = $q.defer();
                statusReceivedPromises[elementIP].push(deferred);
                ws.send(JSON.stringify(msg));
                return deferred.promise;
            });
        };
        myFactory.msgRequestObjectsState = function (selector) {
            var msg = {
                msgType: 'getObjects',
            };
            if (selector.elementIp) {
                msg.elementIp = selector.elementIp;
            }
            if (selector.objectId) {
                msg.objectId = selector.objectId;
            }
            if (selector.objectType) {
                msg.objectType = selector.objectType;
            }
            return wsConnecting.promise.then(function () {
                ws.send(JSON.stringify(msg));
            });
        };
        myFactory.msgRequestStatusesState = function (selector) {
            var msg = {
                msgType: 'getStatuses',
            };
            if (selector.elementIp) {
                msg.elementIp = selector.elementIp;
            }
            if (selector.objectId) {
                msg.objectId = selector.objectId;
            }
            if (selector.objectType) {
                msg.objectType = selector.objectType;
            }
            return wsConnecting.promise.then(function () {
                ws.send(JSON.stringify(msg));
            });
        };
        myFactory.msgObjectSubscribe = function (callback, objs) {
            objs.forEach(function (obj) {
                var key = configKey(obj);
                if (!objectSubscriptions.hasOwnProperty(key)) {
                    objectSubscriptions[key] = {
                        obj: obj,
                        callbacks: [],
                    };
                }
                if (objectSubscriptions[key].callbacks.indexOf(callback) < 0) {
                    objectSubscriptions[key].callbacks.push(callback);
                }
                // call back with the current object if known because we don't know when there'll be an update
                var config = configCache.get(key);
                if (config) {
                    config.fme_ip = obj.fme_ip;
                    try {
                        callback(config);
                    }
                    catch (e) {
                        console.error(e);
                    }
                }
            });
            return $q.resolve();
        };
        myFactory.msgObjectUnsubscribe = function (callback, objs) {
            objs.forEach(function (obj) {
                var key = configKey(obj);
                if (objectSubscriptions.hasOwnProperty(key)) {
                    var idx = objectSubscriptions[key].callbacks.indexOf(callback);
                    if (idx >= 0) {
                        objectSubscriptions[key].callbacks.splice(idx, 1);
                    }
                    if (objectSubscriptions[key].callbacks.length < 1) {
                        delete objectSubscriptions[key];
                    }
                }
            });
            return $q.resolve();
        };
        myFactory.msgStatusSubscribe = function (callback, objs, frequency) {
            if (!frequency) {
                // default refresh rate of 1 sec.
                frequency = 1000;
            }
            var newSubscriptions = [];
            objs.forEach(function (obj) {
                var key = configKey(obj);
                if (!statusSubscriptions.hasOwnProperty(key) || statusSubscriptions[key].frequency > frequency) {
                    newSubscriptions.push(globalObjId(obj));
                }
                if (!statusSubscriptions.hasOwnProperty(key)) {
                    statusSubscriptions[key] = {
                        obj: obj,
                        callbacks: [],
                        frequency: Number.MAX_VALUE,
                    };
                }
                if (statusSubscriptions[key].frequency > frequency) {
                    statusSubscriptions[key].frequency = frequency;
                }
                if (statusSubscriptions[key].callbacks.indexOf(callback) < 0) {
                    statusSubscriptions[key].callbacks.push(callback);
                }
                // call back with the current status if known because we don't know when there'll be an update
                var status = statusCache.get(statusPath(obj));
                if (status) {
                    if (angular.isObject(status)) {
                        status.fme_ip = obj.fme_ip;
                    }
                    try {
                        callback(status);
                    }
                    catch (e) {
                        console.error(e);
                    }
                }
            });
            if (newSubscriptions.length > 0) {
                return wsConnecting.promise.then(function () {
                    ws.send(JSON.stringify({
                        msgType: 'statusListSubscribe',
                        objectIds: newSubscriptions,
                        frequency: frequency,
                    }));
                });
            }
            else {
                return $q.resolve();
            }
        };
        myFactory.getStatusFromCache = function (statusURL) {
            return statusCache.get(statusURL);
        };
        myFactory.msgStatusUnsubscribe = function (callback, objs) {
            var unsubscriptions = [];
            objs.forEach(function (obj) {
                var key = configKey(obj);
                if (statusSubscriptions.hasOwnProperty(key)) {
                    var idx = statusSubscriptions[key].callbacks.indexOf(callback);
                    if (idx >= 0) {
                        statusSubscriptions[key].callbacks.splice(idx, 1);
                    }
                    if (statusSubscriptions[key].callbacks.length < 1) {
                        delete statusSubscriptions[key];
                        unsubscriptions.push(globalObjId(obj));
                    }
                }
            });
            if (unsubscriptions.length > 0) {
                return wsConnecting.promise.then(function () {
                    ws.send(JSON.stringify({
                        msgType: 'statusListUnsubscribe',
                        objectIds: unsubscriptions,
                    }));
                });
            }
            else {
                return $q.resolve();
            }
        };
        myFactory.msgToggleTestStatus = function (testStatusEnabled) {
            return wsConnecting.promise.then(function () {
                ws.send(JSON.stringify({
                    msgType: 'toggleTestStatus',
                    testStatusEnabled: testStatusEnabled,
                }));
            });
        };
        myFactory.msgRunTest = function (name, params) {
            return wsConnecting.promise.then(function () {
                ws.send(JSON.stringify({
                    msgType: 'runTest',
                    testName: name,
                    params: params,
                }));
            });
        };
        function findElementWithIp(element) {
            if (typeof this !== 'undefined') {
                return (element.ip == this || element.fme_ip_address == this);
            }
            return false;
        }
        function findObjectWithId(object) {
            return object.object_ID == this;
        }
        function parseDate(inDate) {
            var result;
            if (angular.isObject(inDate) && inDate.hasOwnProperty('nanos') &&
                inDate.hasOwnProperty('seconds')) {
                // A java instant object
                result = new Date(inDate.seconds * 1000 + inDate.nanos / 1000000);
            }
            else {
                // ISO Date Fromat // 1970-01-01T00:00:00Z
                // PREV
                // var reg = /^(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2}):(\d{2})$/;
                // var parts = reg.exec(inDate);
                // // reg.exec('') example for readability
                // // /^(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2}):(\d{2})$/.exec('0000-00-00 00:00:00')
                // // 0: "0000-00-00 00:00:00" 1: "0000"   2: "00" 3: "00" 4: "00" 5: "00" 6: "00"
                // // groups: undefined   index: 0    input: "0000-00-00 00:00:00"    length: 7
                // const ms = Date.UTC(parts[1], parts[2] - 1, parts[3], parts[4], parts[5], parts[6])
                // return angular.isObject(parts) ? (new Date(ms)) : null;
                result = new Date(inDate).getMilliseconds();
            }
            return Number(result);
        }
        function updateAllElements(rest) {
            return $q(function (resolve, reject) {
                // changes to the element list are reported via the websocket if it is open
                if (rest || (update && !wsConnected)) {
                    $http.get(REST_ENDPOINT.URI + 'elements').then(function (response) {
                        if (dbg) {
                            console.log('getFme call success', response.data);
                        }
                        ;
                        updateFmeList(response.data);
                        resolve("updated");
                    }, function (response) {
                        console.error("Error with getFme", response);
                        reject(response.data);
                    });
                }
                else {
                    resolve("update disabled or using websocket");
                }
            }).finally(runPollCallbacks);
        }
        var runPollCallbacks = function () {
            // run each callback function in callbacks array
            angular.forEach(pollCallbacks, function (callback) {
                callback.fn.call(callback.scope);
            });
        };
        var runFmeListCallbacks = function () {
            // run each callback function in callbacks array
            angular.forEach(fmeListCallbacks, function (callback) {
                callback.fn.call(callback.scope);
            });
        };
        function updateFmeList(data) {
            if (angular.isArray(data) && data.length > 0) {
                if (angular.isArray(fmeList)) {
                    var currentTime = (Number(new Date()) - fmmStateSrv.getDeltaTime());
                    // remove all the old FMEs from the factory
                    var i = 0;
                    while (i < fmeList.length) {
                        var responseFme = data.find(findElementWithIp, fmeList[i].ip);
                        if (angular.isObject(responseFme)) {
                            fmeList[i].cfg_cnt = angular.isString(responseFme.cfg_cnt) ? parseInt(responseFme.cfg_cnt) : responseFme.cfg_cnt;
                            if (responseFme.state === 'connected') {
                                if (responseFme.state !== fmeList[i].state && fmeList[i].state !== 'syncing') {
                                    // put fme in syncing mode
                                    fmeList[i] = {
                                        ip: responseFme.fme_ip_address,
                                        name: responseFme.fme_name,
                                        fme_type: responseFme.fme_type,
                                        state: "syncing",
                                        alarmThreshold: responseFme.alarm_threshold,
                                        cfg_cnt: -1,
                                        old_cfg_cnt: -1,
                                        compatible: responseFme.compatible,
                                        compatible_msg: responseFme.compatible_msg,
                                        presetLoaded: fmeList[i].presetLoaded,
                                    };
                                }
                            }
                            else {
                                fmeList[i].state = responseFme.state;
                            }
                            // change state loading-preset if preset timestamp is within 10mins
                            if (responseFme.preset_timestamp !== null && typeof responseFme.preset_timestamp !== 'undefined') {
                                if (responseFme.preset_timestamp.toString() != "0000-00-00 00:00:00" && (currentTime - parseDate(responseFme.preset_timestamp)) <= 900000) {
                                    fmeList[i].state = "loading-preset";
                                    myFactory.setLoadingPreset(fmeList[i].ip, false);
                                }
                            }
                            fmeList[i].name = responseFme.fme_name;
                            fmeList[i].manager_ip = responseFme.manager_ip;
                            fmeList[i].fme_type = responseFme.fme_type;
                            fmeList[i].alarmThreshold = responseFme.alarm_threshold;
                            fmeList[i].compatible = responseFme.compatible;
                            fmeList[i].compatible_msg = responseFme.compatible_msg;
                            angular.merge(fmeList[i], getGUILabels(fmeList[i]));
                            if (angular.isObject(responseFme.properties)) {
                                fmeList[i].properties = responseFme.properties;
                            }
                            else if (angular.isString(responseFme.properties)) {
                                try {
                                    fmeList[i].properties = JSON.parse(responseFme.properties);
                                }
                                catch (e) {
                                    // it is safe to ignore, getFmeProperty will be called if properties missing
                                }
                            }
                            i++;
                        }
                        else {
                            if (dbg) {
                                console.log("fme deleted");
                            }
                            ;
                            fmeList.splice(i, 1);
                        }
                    }
                    ;
                    // add the missing FMEs
                    if (fmeList.length < data.length) {
                        for (var responseId in data) {
                            var fme = data[responseId];
                            var properties = void 0;
                            if (angular.isObject(fme.properties)) {
                                properties = fme.properties;
                            }
                            else if (angular.isString(fme.properties)) {
                                try {
                                    properties = JSON.parse(fme.properties);
                                }
                                catch (e) {
                                    // it is safe to ignore, getFmeProperty will be called if properties missing
                                }
                            }
                            if (getFmeIndex(fme.fme_ip_address) == -1) {
                                var tempFme = {
                                    ip: fme.fme_ip_address,
                                    name: fme.fme_name,
                                    fme_type: fme.fme_type,
                                    state: fme.state === "connected" ? "syncing" : fme.state,
                                    alarmThreshold: fme.alarm_threshold,
                                    cfg_cnt: -1,
                                    old_cfg_cnt: -1,
                                    compatible: fme.compatible,
                                    compatible_msg: fme.compatible_msg,
                                    properties: properties,
                                };
                                if (fme.preset_timestamp !== null && typeof fme.preset_timestamp !== 'undefined') {
                                    if (fme.preset_timestamp.toString() != "0000-00-00 00:00:00" && (currentTime - parseDate(fme.preset_timestamp)) <= 1800000) {
                                        tempFme.state = "loading-preset";
                                        myFactory.setLoadingPreset(tempFme.ip, false);
                                    }
                                }
                                angular.merge(tempFme, getGUILabels(tempFme));
                                fmeList.push(tempFme);
                            }
                        }
                        ;
                    }
                    // schedule call to get properties
                    for (i = 0; i < fmeList.length; ++i) {
                        if ((fmeList[i].state === 'syncing' || fmeList[i].state === 'connected') && (!angular.isObject(fmeList[i].properties))) {
                            // load properties from the FME if they're undefined
                            if (fmeList[i].state !== 'syncing') {
                                fmeList[i].state = 'syncing';
                            }
                            ;
                        }
                    }
                }
                else {
                    fmeList = [];
                }
            }
            else {
                // remove all FME from factory
                fmeList.length = 0;
            }
            runFmeListCallbacks();
        }
        function getGUILabels(element) {
            var hasName = typeof element.name !== "undefined" && element.name !== null && element.name.length > 0;
            return {
                guiLabel: (hasName ? element.name : element.ip),
                guiSecondaryLabel: (hasName ? '(' + element.ip + ')' : ''),
            };
        }
        function getFmeIndex(fme_ip) {
            //return index of FME with the IP given, else return -1
            var index = -1;
            if (fmeList.length > 0) {
                for (var i = 0; i < fmeList.length; i++) {
                    if (fmeList[i].ip == fme_ip) {
                        index = i;
                    }
                }
                ;
            }
            return index;
        }
        myFactory.getAllElements = function () {
            //return all the FME in the list
            return fmeList;
        };
        myFactory.getConnectedElements = function () {
            function isConnected(elem) {
                return !!elem.state && elem.state == "connected";
            }
            var fmeFilterCallback = function (item) {
                if (isConnected(item)) {
                    return item;
                }
            };
            var filteredElems = myFactory.getAllElements().filter(fmeFilterCallback);
            if (filteredElems.length === 0) {
                console.error('FME List Is Empty');
            }
            return filteredElems;
        };
        myFactory.getElementIp = function () {
            var connectedElems = myFactory.getConnectedElements();
            var result = '';
            try {
                var lastUsedElementIp = myFactory.getLastUsedElement()["ip"];
                var firstConnectedElementIp = connectedElems[0] && connectedElems[0]["ip"];
                result = lastUsedElementIp || firstConnectedElementIp;
            }
            catch (error) {
                console.error(error, 'FME Ip Is Unknown');
            }
            return result;
        };
        myFactory.getStatus = function (obj, cacheConfig) {
            // returns object status from cache, if not in cache then fetch from server
            // cacheConfig.maxAge = expiration time in msec; cacheConfig.update = force fetch when true, cacheConfig.includIp = append fme_ip to data
            return $q(function (resolve, reject) {
                var statusURL = statusPath(obj);
                var tempStatus = statusCache.get(statusURL);
                if (tempStatus) {
                    resolve(tempStatus);
                }
                else {
                    if (obj.fme_ip) {
                        regetAllStatuses(obj.fme_ip, 2000);
                    }
                    reject("Status not found in cache.");
                }
            });
        };
        var statusRegetInProgress = false;
        function regetAllStatuses(fme_ip, ms) {
            if (ms === void 0) { ms = 1000; }
            if (statusRegetInProgress)
                return;
            statusRegetInProgress = true;
            $timeout(function () {
                myFactory.msgRequestAllStatuses(fme_ip);
                statusRegetInProgress = false;
            }, ms);
        }
        myFactory.getElement = function (fme_ip) {
            //returns the FME with the matching IP
            // just in case // https://www.w3schools.com/jsref/jsref_find.asp //// 1st param - applied func, 2nd param will be used as this
            return fmeList.find(findElementWithIp, fme_ip);
        };
        myFactory.getObject = function (obj, cacheConfig) {
            // returns object config from cache, if not in cache then fetch from server
            // cacheConfig.maxAge = expiration time in msec; cacheConfig.update = force fetch when true
            return $q(function (resolve, reject) {
                obj.cacheKey = configKey(obj);
                cacheConfig = cacheConfig ||
                    {
                        update: false
                    };
                var tmpObj = configCache.get(obj.cacheKey);
                if (tmpObj) {
                    resolve(tmpObj);
                }
                else {
                    if (obj.fme_ip) {
                        regetAllObjects(obj.fme_ip, 2000);
                    }
                    reject("Object not found in cache.");
                }
            });
        };
        myFactory.getObjectForExport = function (ip, id) {
            return $http({
                url: REST_ENDPOINT.URI + 'elements/' + ip + '/config/' + id + '/export',
                method: 'GET',
            }).success(function () { }).error(function (response) {
                console.log(response);
            });
        };
        var objectRegetInProgress = false;
        function regetAllObjects(fme_ip, ms) {
            if (ms === void 0) { ms = 1000; }
            if (objectRegetInProgress)
                return;
            objectRegetInProgress = true;
            $timeout(function () {
                myFactory.msgRequestAllObjects(fme_ip);
                objectRegetInProgress = false;
            }, ms);
        }
        myFactory.addElement = function (jsonObj) {
            //add Fme to db
            addFme(jsonObj);
        };
        myFactory.getElementByIp = function (ip) {
            return $http({
                url: REST_ENDPOINT.URI + 'elements/' + ip,
                method: 'GET',
            }).success(function () { }).error(function (response) {
                console.log(response);
                if (dbg) {
                    console.log("error:" + response);
                }
                ;
            });
        };
        myFactory.reconnectElement = function (jsonObj) {
            // force FMM to reconnect element
            jsonObj.reconnect = true;
            addFme(jsonObj);
        };
        function addFme(jsonObj) {
            var msgType = function (reconnect) { return (reconnect ? 'ReconnectFme' : 'AddFme'); };
            var parsedJsonObj = {
                fme_ip: jsonObj.fme_ip_address,
                name: jsonObj.fme_name,
                remote_user: jsonObj.remote_user,
                remote_pass: jsonObj.remote_pass,
                msg_type: msgType(jsonObj.reconnect)
            };
            requestStatusSrv.addRequest(msgType(jsonObj.reconnect), parsedJsonObj);
            $http({
                url: REST_ENDPOINT.URI + 'elements',
                data: jsonObj,
                method: 'POST',
            }).success(function (response) {
                //success
                if (dbg) {
                    console.log('addElement success: ' + response);
                }
                ;
                if (jsonObj.reconnect) {
                    requestStatusSrv.successRequest(parsedJsonObj);
                }
                ;
                updateAllElements(true);
            }).error(function (response) {
                console.log(response);
                if (dbg) {
                    console.log("error:" + response.message);
                }
                ;
                requestStatusSrv.failedRequest(parsedJsonObj, (response.message));
            });
        }
        myFactory.updateElement = function (jsonObj) {
            var parsedJsonObj = {
                fme_ip: jsonObj.fme_ip_address,
                name: jsonObj.fme_name,
                msg_type: 'RenameFme'
            };
            requestStatusSrv.addRequest('RenameFme', parsedJsonObj);
            $http({
                url: REST_ENDPOINT.URI + 'elements/',
                data: jsonObj,
                method: "PUT",
                transformResponse: [
                    commonUtils.plainResponse,
                ]
            })
                .then(function (response) {
                //success
                requestStatusSrv.successRequest(parsedJsonObj);
                updateAllElements(true);
                if (dbg) {
                    console.log('rename Element success: ' + response);
                }
            }, function (response) {
                //failure
                requestStatusSrv.failedRequest(parsedJsonObj, response.data);
                if (dbg) {
                    console.log("error:" + response.data);
                }
            });
        };
        myFactory.removeElement = function (jsonObj) {
            //remove Fme from db
            var parsedJsonObj = {
                fme_ip: jsonObj.ip,
                name: jsonObj.name,
                msg_type: 'RmvFme'
            };
            requestStatusSrv.addRequest('RmvFme', parsedJsonObj);
            $http.delete(REST_ENDPOINT.URI + 'elements/' + jsonObj.ip)
                .success(function (response) {
                //success
                requestStatusSrv.successRequest(parsedJsonObj);
                updateAllElements(true);
                //read updated list from FMM
                if (dbg) {
                    console.log("rmvFme", response);
                }
            })
                .error(function (response) {
                if (dbg) {
                    console.log("error:" + response.data);
                }
                requestStatusSrv.failedRequest(parsedJsonObj, (response.statusText + ': ' + response.data));
            })
                .finally(updateAllElements);
        };
        myFactory.refreshElement = function (fme_ip) {
            //force resync selected FME to database
            var fme = fmeList.find(findElementWithIp, fme_ip);
            if (angular.isObject(fme)) {
                fme.old_cfg_cnt = -1;
            }
            ;
        };
        myFactory.setUpdateObject = function (l_fme_ip, l_object_ID) {
            if (!!l_fme_ip && !!l_object_ID) {
                // mark object for update override
                myFactory.updateObjectID = {
                    fme_ip: l_fme_ip,
                    object_ID: l_object_ID
                };
            }
            else {
                //clear marked object
                myFactory.updateObjectID = null;
            }
        };
        myFactory._updateObject = function (jsonObj, msgType, URL, promiseWaitsForCompletion, onRequestSentCallback) {
            // update object
            jsonObj.cacheKey = configKey(jsonObj);
            // timeout after 1 min
            var timeout = 60 * 1000;
            myFactory.setObjectChanging(jsonObj.fme_ip, jsonObj.object_ID, jsonObj.type, true);
            //change existing object
            if (wsConnected && msgType === 'ChgPartialObj') {
                return $q(function (resolve, reject) {
                    var uuid;
                    var successFunc = function () {
                        if (dbg) {
                            console.log('update success via websocket', Date.now(), uuid);
                        }
                        myFactory.setObjectChanging(jsonObj.fme_ip, jsonObj.object_ID, jsonObj.type, false);
                        if (promiseWaitsForCompletion) {
                            resolve();
                        }
                    };
                    var errorFunc = function (error) {
                        if (dbg) {
                            console.log('update error via websocket', Date.now(), uuid, error);
                        }
                        myFactory.setObjectChanging(jsonObj.fme_ip, jsonObj.object_ID, jsonObj.type, false);
                        // object was dropped from cache - so load it back
                        myFactory.msgRequestObjectsState({
                            elementIp: selfHost ? "127.0.0.1" : jsonObj.fme_ip,
                            objectId: jsonObj.object_ID,
                            objectType: jsonObj.type,
                        });
                        if (promiseWaitsForCompletion) {
                            reject(error);
                        }
                    };
                    uuid = requestStatusSrv.addWebsocketRequest(successFunc, errorFunc, timeout);
                    if (dbg) {
                        console.log('update request via websocket', Date.now(), uuid);
                    }
                    var msg = {
                        msgType: 'partialUpdate',
                        uuid: uuid,
                        timeout: timeout,
                        elementIp: selfHost ? "127.0.0.1" : jsonObj.fme_ip,
                        objectId: jsonObj.object_ID,
                        configuration: JSON.stringify(jsonObj),
                    };
                    ws.send(JSON.stringify(msg));
                    configCache.remove(jsonObj.cacheKey);
                    if (onRequestSentCallback) {
                        try {
                            onRequestSentCallback();
                        }
                        catch (e) { }
                    }
                    if (!promiseWaitsForCompletion) {
                        resolve();
                    }
                });
            }
            else if (dbg) {
                console.log('websocket connection error:', msgType, Date.now());
            }
        };
        myFactory.updatePartialObject = function (jsonObj) {
            console.log("updatePartialObject", jsonObj);
            var msgType = 'ChgPartialObj';
            var URL = 'mgr/ops/chgPartialObj';
            return myFactory._updateObject(jsonObj, msgType, URL, false);
        };
        myFactory.updatePartialObjectUntilComplete = function (jsonObj, onRequestSentCallback) {
            console.log("updatePartialObjectUntilComplete", jsonObj);
            var msgType = 'ChgPartialObj';
            var URL = 'mgr/ops/chgPartialObj';
            return myFactory._updateObject(jsonObj, msgType, URL, true, onRequestSentCallback);
        };
        myFactory.getObjectType = function (object_ID) {
            return object_ID.split('-')[0];
        };
        myFactory.getObjectName = function (fme_ip, object_ID, obj_type) {
            obj_type = obj_type || OBJ_KEY[myFactory.getObjectType(object_ID)];
            var fme = fmeList.find(findElementWithIp, fme_ip);
            var name = object_ID.split('-')[1];
            // the object name can be modified by the user so we look for the most updated name here
            if (!!fme && !!fme[obj_type]) {
                var obj = fme[obj_type].find(findObjectWithId, object_ID);
                if (!!obj) {
                    name = obj.name;
                }
            }
            return name;
        };
        myFactory.getPresets = function () {
            //get a list of presets from a particular FME IP
            return $q(function (resolve, reject) {
                $http({
                    url: REST_ENDPOINT.URI + "presets/",
                    method: 'GET'
                })
                    .success(function (response) {
                    if (dbg) {
                        console.log("getPresets, current list from DB:", response);
                    }
                    ;
                    resolve(response);
                })
                    .error(function (response) {
                    reject("getPresets error:", response);
                });
            });
        };
        myFactory.getPreset = function (name) {
            //get a specific
            return $q(function (resolve, reject) {
                $http({
                    url: REST_ENDPOINT.URI + "presets/" + name,
                    method: 'GET'
                })
                    .success(function (response) {
                    if (dbg) {
                        console.log("getPreset, current list from DB:", response);
                    }
                    ;
                    resolve(response);
                })
                    .error(function (response) {
                    reject("getPreset error:", response);
                });
            });
        };
        myFactory.addPreset = function (source_fme_ip, preset_name, interface_version, element_type, element_version) {
            //add the current FME configuration as a preset into the DB
            var jsonObj = {
                "fme_ip_address": source_fme_ip,
                "name": preset_name,
                "element_type": element_type,
                "interface_version": interface_version,
                "element_version": element_version,
                "objects": []
            };
            requestStatusSrv.addRequest('AddPreset', {
                "fme_ip": source_fme_ip,
                "name": preset_name
            });
            return $q(function (resolve, reject) {
                var parsedJsonObj = {
                    fme_ip: source_fme_ip,
                    name: preset_name,
                    msg_type: 'AddPreset',
                };
                $http({
                    url: REST_ENDPOINT.URI + "presets/" + preset_name,
                    data: jsonObj,
                    method: 'POST',
                    transformResponse: [
                        commonUtils.plainResponse,
                    ],
                })
                    .success(function (response) {
                    requestStatusSrv.successRequest(parsedJsonObj);
                    if (dbg) {
                        console.log("addPreset:", response);
                    }
                    ;
                    resolve(response);
                })
                    .error(function (response) {
                    requestStatusSrv.failedRequest(parsedJsonObj, response);
                    reject(response);
                });
            });
        };
        myFactory.importPreset = function (preset_json, preset_name) {
            //send preset imported via file to the database
            requestStatusSrv.addRequest('AddPreset', {
                "fme_ip": "127.0.0.1",
                "name": preset_name
            });
            return $q(function (resolve, reject) {
                $http({
                    url: REST_ENDPOINT.URI + "presets/" + preset_name,
                    data: preset_json,
                    method: 'PUT',
                    transformResponse: [
                        commonUtils.plainResponse,
                    ],
                })
                    .success(function (response) {
                    // success
                    requestStatusSrv.successRequest({
                        "msg_type": "AddPreset",
                        "fme_ip": "127.0.0.1",
                        "name": preset_name
                    });
                    if (dbg) {
                        console.log("importPreset:", response);
                    }
                    ;
                    resolve(response);
                })
                    .error(function (response) {
                    //failure
                    requestStatusSrv.failedRequest({
                        "msg_type": "AddPreset",
                        "fme_ip": "127.0.0.1",
                        "name": preset_name
                    }, response);
                    reject(response);
                });
            });
        };
        // remove the current FME configuration as a preset into the DB
        myFactory.rmvPreset = function (preset_name) {
            var jsonObjStatus = {
                "fme_ip": "127.0.0.1",
                "name": preset_name
            };
            requestStatusSrv.addRequest('RmvPreset', jsonObjStatus);
            requestStatusSrv.addRequest('RmvPreset', jsonObjStatus);
            return $q(function (resolve, reject) {
                $http({
                    url: REST_ENDPOINT.URI + "presets/" + preset_name,
                    method: 'DELETE'
                })
                    .then(function (response) {
                    // success
                    var parsedJsonObj = {
                        fme_ip: "127.0.0.1",
                        name: preset_name,
                        msg_type: 'RmvPreset',
                    };
                    requestStatusSrv.successRequest(parsedJsonObj);
                    if (dbg) {
                        console.log("rmvPreset success:", response);
                    }
                    ;
                    resolve(response);
                }, function (response) {
                    //failure
                    var failedObject = response.config.data;
                    failedObject.fme_ip = "127.0.0.1";
                    failedObject.msg_type = 'RmvPreset';
                    requestStatusSrv.failedRequest(failedObject, (response.statusText + ': ' + response.data));
                    reject("rmvPreset error:", response.data);
                });
            });
        };
        myFactory.loadPreset = function (destination_fme_ip, preset_name, rebootAfter) {
            //load a preset configuration into selected FME
            var jsonObj = {
                "fme_ip": destination_fme_ip,
                "preset_file": preset_name,
                "reboot_after": !!rebootAfter
            };
            var parsedJsonObj = {
                fme_ip: destination_fme_ip,
                name: 'LoadPreset',
                msg_type: 'LoadPreset'
            };
            requestStatusSrv.addRequest('LoadPreset', parsedJsonObj);
            return $q(function (resolve, reject) {
                $http({
                    url: REST_ENDPOINT.URI + "presets/loadpreset",
                    data: jsonObj,
                    method: 'POST',
                    transformResponse: [
                        commonUtils.plainResponse,
                    ],
                })
                    .then(function (response) {
                    // success
                    if (dbg) {
                        console.log("loadPreset:", response.data);
                    }
                    ;
                    myFactory.setLoadingPreset(destination_fme_ip, false);
                    resolve(response.data);
                }, function (response) {
                    //failure
                    requestStatusSrv.failedRequest(parsedJsonObj, response.data);
                    reject("loadPreset error:", response.data);
                });
            });
        };
        myFactory.setLoadingPresets = function (presets) {
            presets.forEach(function (preset) {
                if (preset.hasOwnProperty('fme_ip') && preset.hasOwnProperty('presetLoaded')) {
                    myFactory.setLoadingPreset(preset.fme_ip, preset.presetLoaded);
                }
            });
        };
        myFactory.setLoadingPreset = function (fme_ip, presetLoaded) {
            for (var i = 0; i < fmeList.length; i++) {
                if (fmeList[i].ip === fme_ip || selfHost) {
                    fmeList[i].presetLoaded = presetLoaded;
                }
            }
        };
        myFactory.isPresetLoading = function (fme_ip) {
            for (var i = 0; i < fmeList.length; i++) {
                if (fmeList[i].ip === fme_ip || selfHost) {
                    return fmeList[i].presetLoaded === false || fmeList[i].state === 'loading-preset';
                }
            }
        };
        myFactory.arePresetsLoading = function () {
            for (var i = 0; i < fmeList.length; i++) {
                if (fmeList[i].presetLoaded === false || fmeList[i].state === 'loading-preset')
                    return true;
            }
            return false;
        };
        myFactory.getLayouts = function (fme_ip) {
            return $http({
                url: REST_ENDPOINT.URI + "elements/" + (selfHost ? '127.0.0.1' : fme_ip) + "/layouts",
                method: 'GET',
            }).success(function (response) {
                if (dbg) {
                    console.log("getLayouts:" + response);
                }
                ;
            }).error(function (response) {
                if (dbg) {
                    console.log("error:" + response);
                }
                ;
            });
        };
        myFactory.setUpdateStatus = function () {
            updateObjectStatus = true;
        };
        myFactory.clearUpdateStatus = function () {
            updateObjectStatus = false;
        };
        myFactory.getUpdateStatus = function () {
            return updateObjectStatus;
        };
        myFactory.toggleUpdate = function () {
            //turn off when using dummy data
            if (!dummyData) {
                update = !update;
                console.log('update:' + update);
            }
            else {
                update = false;
                console.log('using dummy data, update=false');
            }
        };
        myFactory.setUpdate = function () {
            //turn off when using dummy data
            if (!dummyData) {
                update = true;
                fmmStateSrv.clearDebug();
                if (dbg) {
                    console.log('update:' + update);
                }
                ;
            }
            else {
                update = false;
                fmmStateSrv.setDebug();
                console.log('using dummy data, update=false');
            }
        };
        myFactory.clearUpdate = function () {
            update = false;
            fmmStateSrv.setDebug();
            if (dbg) {
                console.log('update:' + update);
            }
            if (dummyData) {
                console.log('using dummy data, update=false');
            }
        };
        myFactory.toggleDbg = function () {
            dbg = !dbg;
            if (dbg) {
                console.log("debug mode on");
                fmmStateSrv.setDebug();
            }
            else {
                console.log("debug mode off");
                fmmStateSrv.clearDebug();
            }
            ;
        };
        myFactory.getUpdate = function () {
            return update;
        };
        myFactory.getDbg = function () {
            return dbg;
        };
        myFactory.isUsed = function (fmeip, objectID, type) {
            var usedMsg = {
                isUsed: false,
                name: ""
            };
            var fme = myFactory.getElement(fmeip);
            var fmeList = myFactory.getAllElements();
            function _checkSource(item) {
                if ((!!item.input && (item.input.object_ID === objectID || item.input.object_ID_secondary === objectID)) ||
                    (!!item.source && (item.source.input.object_ID === objectID || item.source.input.object_ID_secondary === objectID))) {
                    usedMsg.isUsed = true;
                    usedMsg.name += usedMsg.name.length > 0 ? ", " : '';
                    usedMsg.name += "\"" + item.name + "\"";
                }
            }
            ;
            if (!!fme) {
                if (type === 'Ip Input') {
                    fme.linear.forEach(_checkSource);
                    fme.abr.forEach(_checkSource);
                    fme.muxService.forEach(_checkSource);
                }
                else if (type === 'Ip_Source_Uncompressed') {
                    fme.linear.forEach(_checkSource);
                    fme.abr.forEach(_checkSource);
                }
                else if (type === 'Sdi_Source') {
                    fme.linear.forEach(_checkSource);
                    fme.abr.forEach(_checkSource);
                }
                else if (type == 'Linear') {
                    // check across all connected elements
                    fmeList.forEach(function (element) {
                        if (!!element.muxService) {
                            element.muxService.forEach(_checkSource);
                        }
                    });
                }
            }
            return usedMsg;
        };
        myFactory.checkEnd = function (object_action) {
            var end = true;
            var resultList = angular.copy(requestStatusSrv.getRequestList());
            var result = resultList.reverse().find(function (e) {
                return (e.fme_ip = object_action.fme_ip &&
                    (e.name == object_action.name || e.obj_name == object_action.name) &&
                    e.msg_type == object_action.msg_type) &&
                    (Date.parse(e.time_stamp) > (Date.parse(object_action.time_stamp) - 5000));
            });
            if (angular.isObject(result)) {
                end = result.result.length > 0;
            }
            return end;
        };
        myFactory.getObjectChanging = function (fme_ip, object_ID, type) {
            var changing = false;
            var fme = fmeList.find(findElementWithIp, fme_ip);
            if (!!fme) {
                var obj = fme[OBJ_KEY[type]].find(findObjectWithId, object_ID);
                if (!!obj) {
                    changing = obj.changing || false;
                }
                ;
            }
            return changing;
        };
        myFactory.setObjectChanging = function (fme_ip, object_ID, type, changing) {
            var fme = fmeList.find(findElementWithIp, fme_ip);
            if (!!fme && !!OBJ_KEY[type] && !!fme[OBJ_KEY[type]]) {
                var obj = fme[OBJ_KEY[type]].find(findObjectWithId, object_ID);
                if (!!obj) {
                    obj.changing = changing;
                }
                ;
            }
        };
        myFactory.makeServerRequest = function (jsonObj) {
            return $http(jsonObj);
        };
        myFactory.fmmServiceAvailable = function () {
            return fmmStateSrv.servicesAvailable();
        };
        myFactory.setLastUsedElement = function (elementIp) {
            lastUsedElement = elementIp || '';
        };
        myFactory.getLastUsedElement = function () {
            return myFactory.getElement(lastUsedElement) ||
                {};
        };
        myFactory.registerCallback = function (callback, type) {
            if (type === void 0) { type = 'poll'; }
            // register callback functions to specified array (polling array by default)
            var callbackArray = type === 'fmeList' ? fmeListCallbacks : pollCallbacks;
            var functionExist = callbackArray.some(function (obj) { return (angular.equals(obj, callback)); });
            if (!functionExist) {
                callbackArray.push(callback);
            }
        };
        myFactory.unregisterCallback = function (callback, type) {
            if (type === void 0) { type = 'poll'; }
            // unregister callback function from specified array (polling array by defualt)
            var callbackArray = type === 'fmeList' ? fmeListCallbacks : pollCallbacks;
            for (var i = callbackArray.length - 1; i >= 0; i--) {
                if (angular.equals(callbackArray[i], callback)) {
                    callbackArray.splice(i, 1);
                }
            }
        };
        myFactory.resync = function () {
            // clear both config and status cache
            configCache.removeAll();
            statusCache.removeAll();
            // put connected elements back to syncing mode
            fmeList.forEach(function (fme) {
                if (fme.state === 'connected') {
                    fme.state = 'syncing';
                }
            });
            runFmeListCallbacks();
        };
        myFactory.isPollingStarted = function () {
            return pollingStarted;
        };
        //initialize FME list
        myFactory.startService = function () {
            pollingScheduledAtInit = true;
            $q(function (resolve, reject) {
                if (!wsConnected) {
                    wsReconnect();
                    wsConnecting.promise.finally(resolve);
                }
                else {
                    resolve();
                }
            }).then(function () {
                // check if still supposed to start polling after waiting for the websocket
                if (pollingScheduledAtInit) {
                    myFactory.startPolling();
                }
            });
        };
        myFactory.stopService = function () {
            if (ws) {
                reconnect = false;
                ws.close();
            }
        };
        //set a timer to poll after 3s
        myFactory.startPolling = function () {
            if (pollingStarted) {
                return;
            }
            pollingStarted = true;
            var doPoll = function () {
                // poll using $interval instead of $timeout to work with ProtractorJS
                if (!!fmePolling) {
                    $interval.cancel(fmePolling);
                }
                fmePolling = null;
                updateAllElements().then(function () {
                    if (pollingStarted) {
                        fmePolling = $interval(doPoll, 3000);
                    }
                });
            };
            doPoll();
        };
        myFactory.refreshAllElements = function () {
            updateAllElements();
        };
        myFactory.stopPolling = function () {
            if (angular.isObject(fmePolling)) {
                $interval.cancel(fmePolling);
                fmePolling = null;
            }
            pollingScheduledAtInit = false;
            pollingStarted = false;
        };
        myFactory.registerAlarmCallback = function (callback) {
            alarmCallbacks.push(callback);
        };
        myFactory.registerAlarmConfigCallback = function (callback) {
            alarmConfigCallbacks.push(callback);
        };
        myFactory.registerTestCallback = function (callback) {
            testCallbacks.push(callback);
        };
        myFactory.wsIsConnected = function () {
            return wsConnected;
        };
        myFactory.isUserViewerOnly = function () {
            return !userManagerSrv.IsAllowOper();
        };
        myFactory.getCommonLicense = function (fme_ip) {
            return $q(function (resolve, reject) {
                $http({
                    url: REST_ENDPOINT.URI + "elements/" + fme_ip + "/licenses",
                    method: 'GET'
                })
                    .success(function (response) {
                    if (dbg) {
                        console.log("getCommonLicense: ", response);
                    }
                    ;
                    resolve(response);
                })
                    .error(function (response) {
                    if (dbg) {
                        console.log("getCommonLicense error: ", response);
                    }
                    ;
                    reject(response);
                });
            });
        };
        myFactory.updateCommonLicense = function (fme_ip, license_key) {
            return $q(function (resolve, reject) {
                $http({
                    url: REST_ENDPOINT.URI + "elements/" + fme_ip + "/licenses",
                    data: {
                        license_key: license_key
                    },
                    method: 'POST'
                })
                    .success(function (response) {
                    if (dbg) {
                        console.log("updateCommonLicense: ", response);
                    }
                    ;
                    resolve(response);
                })
                    .error(function (response) {
                    if (dbg) {
                        console.log("updateCommonLicense error:" + response);
                    }
                    ;
                    reject(response);
                });
            });
        };
        myFactory.getAAPLicense = function (fme_ip) {
            return $q(function (resolve, reject) {
                $http({
                    url: REST_ENDPOINT.URI + "elements/" + fme_ip + "/aap_licenses",
                    method: 'GET'
                })
                    .success(function (response) {
                    if (dbg) {
                        console.log("getAAPLicense: ", response);
                    }
                    ;
                    resolve(response);
                })
                    .error(function (response) {
                    if (dbg) {
                        console.log("getAAPLicense error: ", response);
                    }
                    ;
                    reject(response);
                });
            });
        };
        myFactory.updateAAPLicense = function (fme_ip, license_key) {
            return $q(function (resolve, reject) {
                $http({
                    url: REST_ENDPOINT.URI + "elements/" + fme_ip + "/aap_licenses",
                    data: {
                        license_key: license_key
                    },
                    method: 'POST'
                })
                    .success(function (response) {
                    if (dbg) {
                        console.log("updateAAPLicense: ", response);
                    }
                    ;
                    resolve(response);
                })
                    .error(function (response) {
                    if (dbg) {
                        console.log("updateAAPLicense error:" + response);
                    }
                    ;
                    reject(response);
                });
            });
        };
        // myFactory.startService();
        return myFactory;
    }
    return FmeListService;
}());
exports.FmeListService = FmeListService;


/***/ }),

/***/ "./app/fme/fme-state.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var FmmStateService = (function () {
    function FmmStateService($http, $q, $interval, commonUtils, REST_ENDPOINT) {
        var myFactory = {};
        var fmmStatus = {
            status: "error",
            available_services: undefined
        };
        var debugMode = false;
        var delta_time = 0; //used to correct browser and server time
        var status = {
            status: {
                upgrade: {
                    isInProgress: false
                }
            },
            error: false,
            errorMsg: "",
        };
        var pollIntervalId = null;
        myFactory.update = function (data) {
            var isReconnection = !myFactory.fmmConnected();
            if (data.logged !== null && data.logged === false) {
                window.location.href = data.redirect;
            }
            var parsedDateTime, parsedDate;
            var parsedResponse = angular_1.copy(data);
            //conver the date format into UTC
            if (!!parsedResponse.description) {
                parsedDateTime = parsedResponse.description.split(" ");
                parsedDate = parsedDateTime[0].split("-");
                parsedResponse.description =
                    parsedDate[2] +
                        "-" +
                        parsedDate[1] +
                        "-" +
                        parsedDate[0] +
                        "T" +
                        parsedDateTime[1] +
                        "Z";
                setDeltaTime(parsedResponse.description);
            }
            angular_1.merge(fmmStatus, parsedResponse);
            if (isReconnection) {
                commonUtils.smm_restapi_token_refresh();
            }
        };
        //get FMM connection state
        myFactory.readFmmStatus = function () {
            return $q(function (resolve, reject) {
                if (!debugMode) {
                    if (fmmStatus) {
                        resolve(fmmStatus);
                    }
                    else {
                        reject({
                            statusText: "Error",
                            data: fmmStatus
                        });
                    }
                }
                else {
                    resolve({
                        data: {
                            description: new Date()
                        }
                    });
                }
            });
        };
        myFactory.resetFmmStatus = function () { return (fmmStatus.status = "error"); };
        myFactory.setDebug = function () {
            debugMode = true;
        };
        myFactory.clearDebug = function () {
            debugMode = false;
        };
        myFactory.servicesAvailable = function () {
            if (!!fmmStatus.available_services) {
                //return true if fmm can manage more services
                return debugMode || fmmStatus.available_services > 0;
            }
            else {
                //if fmmStatus.available_services does not exist, return false unless in debug mode
                return debugMode;
            }
        };
        myFactory.getFmmStatus = function () {
            return fmmStatus;
        };
        myFactory.fmmConnected = function () {
            return debugMode || fmmStatus.status === "success";
        };
        var setDeltaTime = function (server_time) {
            //takes in server time and sets delta_time in ms
            //delta_time = browser_time - server_time
            var browser_time = new Date().getMilliseconds();
            var server_time_parsed = new Date(server_time).getMilliseconds();
            delta_time = browser_time - server_time_parsed;
            if (typeof delta_time !== "number") {
                delta_time = 0;
            }
        };
        myFactory.getDeltaTime = function () {
            //return browser and server time diff in ms
            //delta_time = browser_time - server_time
            return delta_time;
        };
        function getStatus() {
            $http({
                url: REST_ENDPOINT.URI + "console/status",
                method: "GET",
                transformResponse: [commonUtils.plainResponse],
            }).success(function (response) {
                status.status = JSON.parse(response).data;
                status.error = false;
                status.errorMsg = "";
            }).error(function (response) {
                status.error = true;
                if (typeof response === "string" && response.length < 20)
                    status.errorMsg = response;
            });
        }
        myFactory.startPolling = function () {
            if (!angular_1.isObject(pollIntervalId)) {
                getStatus();
                pollIntervalId = $interval(function () {
                    getStatus();
                }, 5000);
            }
        };
        myFactory.stopPolling = function () {
            if (!!pollIntervalId) {
                $interval.cancel(pollIntervalId);
                pollIntervalId = null;
            }
        };
        myFactory.getConsoleStatus = function () {
            return status;
        };
        return myFactory;
    }
    return FmmStateService;
}());
exports.FmmStateService = FmmStateService;


/***/ }),

/***/ "./app/fme/fme.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var fme_list_service_1 = __webpack_require__("./app/fme/fme-list.service.ts");
var fme_state_service_1 = __webpack_require__("./app/fme/fme-state.service.ts");
var fme_modals_service_1 = __webpack_require__("./app/fme/modals/fme-modals.service.ts");
exports.FmeModule = angular_1.module("FmeModule", [])
    .value("OBJ_KEY", {
    "Ip Input": "inputs",
    "Ip_Source_Uncompressed": "inputs",
    "Sdi_Source": "inputs",
    "Linear": "linear",
    "ABR": "abr",
    "ABR_Encode": "abr",
    "Mux Group": "muxGroup",
    "Mux Service": "muxService"
})
    .factory("fmeListSrv", fme_list_service_1.FmeListService)
    .factory("fmmStateSrv", fme_state_service_1.FmmStateService)
    .service("fmeModalsSrv", fme_modals_service_1.FmeModalsService);


/***/ }),

/***/ "./app/fme/modals/fme-modals.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var fme_state_modal_window_component_1 = __webpack_require__("./app/fme/modals/fme-state-modal-window/fme-state-modal-window.component.ts");
var wss_redirect_modal_window_component_1 = __webpack_require__("./app/fme/modals/wss-redirect-modal-window/wss-redirect-modal-window.component.ts");
exports.FmeModalsService = function ($uibModal) {
    var openFmmStateModal = function () {
        return fme_state_modal_window_component_1.createFmeStateModalWindowComponent($uibModal);
    };
    var openWSSCertificateModal = function () {
        return wss_redirect_modal_window_component_1.createWssRedirectModalWindowComponent($uibModal);
    };
    return {
        openFmmStateModal: openFmmStateModal,
        openWSSCertificateModal: openWSSCertificateModal,
    }; // ES6 syntax
};


/***/ }),

/***/ "./app/fme/modals/fme-state-modal-window/fme-state-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var fme_state_modal_window_controller_1 = __webpack_require__("./app/fme/modals/fme-state-modal-window/fme-state-modal-window.controller.ts");
var templateUrl = __webpack_require__("./app/fme/modals/fme-state-modal-window/fme-state-modal-window.template.html");
exports.createFmeStateModalWindowComponent = function (library) {
    return library.open({
        animation: true,
        backdrop: "static",
        keyboard: false,
        templateUrl: templateUrl,
        controller: fme_state_modal_window_controller_1.FmmStateModalWindowController,
        windowClass: "fmm-state-modal",
    });
};


/***/ }),

/***/ "./app/fme/modals/fme-state-modal-window/fme-state-modal-window.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var FmmStateModalWindowController = (function () {
    function FmmStateModalWindowController($scope, fmmStateSrv, commonUtils) {
        var productName = commonUtils.SNP_PRODUCT_NAME;
        $scope.titleText = "Connecting to " + productName + "...";
        $scope.descrText = "Trying to connect.";
        function checkFmmStatus() {
            $scope.fmmState = fmmStateSrv.getFmmStatus();
            // if (!!$scope.fmmState.description) {
            //     $scope.date = Date.parse($scope.fmmState.description);
            // }
            if (!!$scope.fmmState.status && $scope.fmmState.status === "fmaLost") {
                $scope.descrText = "Trying to reconnect to Flexmedia Agent.";
            }
        }
        checkFmmStatus();
    }
    return FmmStateModalWindowController;
}());
exports.FmmStateModalWindowController = FmmStateModalWindowController;


/***/ }),

/***/ "./app/fme/modals/fme-state-modal-window/fme-state-modal-window.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/fme/modals/fme-state-modal-window/fme-state-modal-window.template.html?5aade6ff8d5c10eafd92d4eeefc26d1f";

/***/ }),

/***/ "./app/fme/modals/wss-redirect-modal-window/wss-redirect-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var wss_redirect_modal_window_controller_1 = __webpack_require__("./app/fme/modals/wss-redirect-modal-window/wss-redirect-modal-window.controller.ts");
var templateUrl = __webpack_require__("./app/fme/modals/wss-redirect-modal-window/wss-redirect-modal-window.template.html");
exports.createWssRedirectModalWindowComponent = function (library) {
    return library.open({
        animation: true,
        backdrop: "static",
        keyboard: false,
        templateUrl: templateUrl,
        controller: wss_redirect_modal_window_controller_1.WssCertificateRedirectModalWindowController,
    });
};


/***/ }),

/***/ "./app/fme/modals/wss-redirect-modal-window/wss-redirect-modal-window.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var WssCertificateRedirectModalWindowController = (function () {
    function WssCertificateRedirectModalWindowController($scope, $uibModalInstance, commonUtils) {
        $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        $scope.requester = encodeURIComponent(window.location.href);
        $scope.hostname = window.location.hostname;
        $scope.onCancel = function () {
            $uibModalInstance.close();
        };
    }
    return WssCertificateRedirectModalWindowController;
}());
exports.WssCertificateRedirectModalWindowController = WssCertificateRedirectModalWindowController;


/***/ }),

/***/ "./app/fme/modals/wss-redirect-modal-window/wss-redirect-modal-window.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/fme/modals/wss-redirect-modal-window/wss-redirect-modal-window.template.html?94f6c62a62faa3934044eb3a3406b772";

/***/ }),

/***/ "./app/header/header.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var header_controller_1 = __webpack_require__("./app/header/header.controller.ts");
var templateUrl = __webpack_require__("./app/header/header.template.html");
exports.HeaderComponent = {
    templateUrl: templateUrl,
    controller: header_controller_1.HeaderController,
};


/***/ }),

/***/ "./app/header/header.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var common_1 = __webpack_require__("./app/view-menu/common.js");
var HeaderController = (function () {
    function HeaderController($scope, $http, $location, $timeout, $interval, $route, fmeModalsSrv, configMenuModalsSrv, configRemoteMenuModalsSrv, uiModalsSrv, userManagerSrv, fmmStateSrv, fmeListSrv, snpListSrv, commonUtils, loginSrv, VIEW_NAMES, REST_ENDPOINT) {
        $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        $scope.consoleUrl = "http://" + window.location.host + "/#/console";
        $scope.currentUser = userManagerSrv.getCurrentUser();
        $scope.userGroup = userManagerSrv.getCurUserGroup();
        $scope.fmmStatus = fmmStateSrv.getFmmStatus();
        $scope.consoleStatus = fmmStateSrv.getConsoleStatus();
        $scope.fmeIp = fmeListSrv.getLastUsedElement().ip;
        $scope.isAdmin = false;
        var fmmStateModal;
        var pollIntervalId = null;
        var readFmmTimerId = null;
        var initialized = false;
        var isCheckingAccess = false;
        var isPresetLoading = false;
        var accessIntervalId = null;
        var statusIntervalId = null;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        var _getIsLogin = function () {
            $scope.isLogin = !!$route.current.$$route ?
                $route.current.$$route.isLogin || false :
                false;
        };
        accessIntervalId = $interval(checkAccess, 5000);
        checkAccess();
        var waitDialogConfig = {};
        var waitDialog;
        function showWaitDialog(config) {
            angular_1.copy(config, waitDialogConfig);
            if (!angular_1.isDefined(waitDialog)) {
                waitDialog = uiModalsSrv.openWaitModal(waitDialogConfig);
            }
        }
        var upgrading = false;
        var rebooting = false;
        $scope.$watch("consoleStatus.status.upgrade.isInProgress", function (newValue, oldValue) {
            if (!oldValue && newValue) {
                upgrading = true;
                initialized = false;
                fmeListSrv.stopService();
                stopPolling();
                fmmStateModal.close();
                if ($scope.isLogin ||
                    ($route.current &&
                        $route.current.$$route &&
                        // TDL:                 check
                        $route.current.$$route.viewName === VIEW_NAMES.CONSOLE))
                    return;
                showWaitDialog({
                    title: "System Upgrade",
                    msg: "Upgrading...",
                    isInProgress: true,
                    isErrorMsg: false,
                });
            }
        });
        $scope.$watch("fmmStatus.status", function (newValue, oldValue) {
            _getIsLogin();
            if (!$scope.isLogin &&
                angular_1.isDefined(newValue) &&
                angular_1.isDefined(oldValue) &&
                newValue !== oldValue &&
                !upgrading) {
                if (newValue === "success" &&
                    (oldValue === "error" || oldValue === "fmaLost")) {
                    // Lenko: note that we need to wait for the dialog to render before closing (a bootstrap issue)
                    fmmStateModal.rendered.finally(fmmStateModal.close);
                    // on restart reinitialize alarm and fmeList services
                    snpListSrv.initSnpListSrv();
                    fmeListSrv.resync();
                    startPolling();
                }
                else if (oldValue === "success" &&
                    (newValue === "error" ||
                        (newValue === "fmaLost" && $scope.selfHost))) {
                    if (!$scope.selfHost || !fmeListSrv.isPresetLoading("127.0.0.1")) {
                        fmmStateModal = fmeModalsSrv.openFmmStateModal();
                    }
                    stopPolling();
                }
            }
        }, true);
        // This code makes sure that the fmm state modal doesn't get stuck after appearing
        // when the network manager window is on inactive tab
        if ($scope.selfHost) {
            statusIntervalId = $interval(function () {
                var status = fmmStateSrv.getFmmStatus();
                if (status.status === "success") {
                    var elem = document.querySelector(".fmm-state-modal");
                    if (!!elem) {
                        fmmStateModal.close();
                        elem.parentNode.removeChild(elem);
                        var backdrop = document.querySelector(".modal-backdrop");
                        var otherModal = document.querySelector(".modal");
                        if (!!backdrop && !!otherModal) {
                            backdrop["style"].setProperty("z-index", otherModal["style"].zIndex - 1, "important");
                        }
                    }
                }
            }, 5000);
        }
        var fmeIpUpdateIntervalId = $interval(function () {
            // Update the fmeIp periodically so the header can poll the reboot required status
            if (fmeListSrv.getLastUsedElement().ip !== undefined &&
                fmeListSrv.getLastUsedElement().ip !== $scope.fmeIp) {
                $scope.system_reboot_required = false; // Reset so it will clear the banner and update later
                fmeListSrv.msgStatusUnsubscribe(onStatusUpdate, statusHeader);
                $scope.fmeIp = fmeListSrv.getLastUsedElement().ip;
                statusHeader[0].fme_ip = $scope.fmeIp;
                fmeListSrv.msgStatusSubscribe(onStatusUpdate, statusHeader);
            }
        }, 500);
        $scope.$on("$routeChangeSuccess", function ($event, next, current) {
            checkAccess();
            if ($scope.isLogin && commonUtils.smm_restapi_token())
                $location.path("/#/dashboard");
            else if ($scope.isLogin)
                stopPolling();
            else if (!initialized && !upgrading)
                initialize();
        });
        function startPolling() {
            fmeListSrv.startPolling();
            if ($scope.selfHost)
                fmmStateSrv.startPolling();
        }
        function stopPolling() {
            fmeListSrv.stopPolling();
            fmmStateSrv.resetFmmStatus();
            if ($scope.selfHost && (!upgrading || rebooting))
                fmmStateSrv.stopPolling();
        }
        function checkAccess() {
            if (isCheckingAccess) {
                return;
            }
            getUserGroup();
            _getIsLogin();
            if (!upgrading && !$scope.isLogin)
                commonUtils.smm_restapi_token_refresh();
            isCheckingAccess = true;
            $http
                .get(REST_ENDPOINT.URI_ACCESS)
                .success(function (response) {
                isCheckingAccess = false;
                if ($scope.isLogin) {
                    if ((typeof response === "string" &&
                        response.substr(0, 2) === "ok") ||
                        (typeof response === "object" && response.status === "ok")) {
                        loginSrv.snpOn();
                    }
                    else {
                        fmeListSrv.stopService();
                        stopPolling();
                        loginSrv.snpOff();
                    }
                }
                if (typeof response === "object" &&
                    response.hasOwnProperty("presets")) {
                    fmeListSrv.setLoadingPresets(response.presets);
                    if ($scope.selfHost && !!fmmStateModal) {
                        if (!response.presets[0].presetLoaded) {
                            fmmStateModal.rendered.finally(fmmStateModal.close);
                            isPresetLoading = true;
                            initialized = false;
                            upgrading = false;
                        }
                        else {
                            isPresetLoading = false;
                        }
                    }
                }
                if (upgrading && rebooting) {
                    upgrading = false;
                    rebooting = false;
                    $location.path("/login");
                }
                if (!initialized && !upgrading && !isPresetLoading)
                    initialize();
            })
                .error(function () {
                if (upgrading && rebooting)
                    return;
                document.cookie =
                    "smm_restapi_token=; expires=" +
                        new Date(0).toUTCString() +
                        "; path=/; secure";
                initialized = false;
                fmeListSrv.stopService();
                if (upgrading) {
                    rebooting = true;
                    stopPolling();
                    showWaitDialog({
                        title: "System Reboot",
                        msg: "Rebooting...",
                        isInProgress: true,
                        isErrorMsg: false,
                    });
                    return;
                }
                stopPolling();
                $location.path("/login");
                loginSrv.snpLost();
            })
                .finally(function () {
                $timeout(function () {
                    isCheckingAccess = false;
                }, 1000);
            });
        }
        function initialize() {
            _getIsLogin();
            if (!$scope.isLogin &&
                commonUtils.smm_restapi_token() &&
                !isCheckingAccess) {
                initialized = true;
                fmmStateModal = fmeModalsSrv.openFmmStateModal();
                fmeListSrv.startService();
                fmmStateSrv
                    .readFmmStatus()
                    .then(function (resp) {
                    startPolling();
                }, function (resp) {
                    console.log("readFmmStatus:" + resp.statusText + ", " + resp.data);
                    stopPolling();
                })
                    .finally(startFmmStatusPolling);
            }
            else if (commonUtils.smm_restapi_token() && !isCheckingAccess) {
                $location.path("/#/dashboard");
            }
        }
        function startFmmStatusPolling() {
            if (!angular_1.isObject(pollIntervalId)) {
                pollIntervalId = $interval(function () {
                    readFmmStatus();
                }, 10000);
            }
        }
        function readFmmStatus(count) {
            count = count || 0;
            if (count < 3) {
                fmmStateSrv.readFmmStatus().then(function (resp) { }, function (resp) {
                    console.log("readFmmStatus:" + resp.statusText, resp.data);
                    if (!angular_1.isObject(readFmmTimerId)) {
                        readFmmTimerId = $timeout(function () {
                            readFmmStatus(count + 1);
                        }, 500);
                    }
                });
            }
        }
        $scope.logout = function () {
            console.log("logout");
            document.cookie =
                "smm_restapi_token=; expires=" +
                    new Date(0).toUTCString() +
                    "; path=/; secure";
            // $interval.cancel(accessIntervalId);
            initialized = false;
            fmeListSrv.stopService();
            stopPolling();
        };
        $scope.SubView = function () {
            var text = !!$route.current && $route.current.$$route ?
                $route.current.$$route.viewName || "" :
                "";
            return text === VIEW_NAMES.ALARM || text === VIEW_NAMES.PHYSICAL;
        };
        //add menu modals
        $scope.cfgElement = function () {
            configMenuModalsSrv.openCfgFmeModal();
        };
        $scope.cfgPreset = function () {
            configMenuModalsSrv.openCfgPresetModal();
        };
        $scope.cfgLuts = function () {
            configMenuModalsSrv.openCfgLutsModal();
        };
        $scope.cfgGfx = function () {
            configMenuModalsSrv.openCfgGfxModal();
        };
        $scope.cfgFx = function () {
            configMenuModalsSrv.openCfgFxModal();
        };
        $scope.cfgPanel = function () {
            configMenuModalsSrv.openCfgPCSModal();
        };
        $scope.cfgAap = function () {
            configMenuModalsSrv.openCfgAapModal();
        };
        $scope.cfgLicense = function () {
            configMenuModalsSrv.openCfgLicenseModal();
        };
        $scope.addElement = function () {
            configRemoteMenuModalsSrv.openAddElementModal();
        };
        $scope.cfgSmm = function () {
            configRemoteMenuModalsSrv.openCfgSmmModal();
        };
        function onStatusUpdate(status) {
            if (status.object_ID === common_1.SNP_OBJTYPE_SYSTEM) {
                $scope.system_reboot_required = $location.$$url.startsWith("/config") && status.General.rebootRequired;
            }
        }
        var statusHeader = [
            {
                fme_ip: $scope.fmeIp,
                type: common_1.SNP_OBJTYPE_SYSTEM,
                object_ID: common_1.SNP_OBJTYPE_SYSTEM
            }
        ];
        $scope.$on("$destroy", function () {
            console.log("navBarController destroyed");
            $interval.cancel(accessIntervalId);
            $interval.cancel(pollIntervalId);
            $timeout.cancel(readFmmTimerId);
            fmeListSrv.msgStatusUnsubscribe(onStatusUpdate, statusHeader);
        });
        fmeListSrv.msgStatusSubscribe(onStatusUpdate, statusHeader);
        $scope.isRebootRequired = function () {
            return $location.$$url.startsWith("/config") && $scope.system_reboot_required;
        };
        initialize();
    }
    return HeaderController;
}());
exports.HeaderController = HeaderController;


/***/ }),

/***/ "./app/header/header.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var config_menu_module_1 = __webpack_require__("./app/config-menu/config-menu.module.ts");
var header_component_1 = __webpack_require__("./app/header/header.component.ts");
var user_menu_component_1 = __webpack_require__("./app/header/user-menu/user-menu.component.ts");
exports.HeaderModule = angular_1.module("headerModule", [
    config_menu_module_1.ConfigMenuModule.name,
])
    .component("appHeader", header_component_1.HeaderComponent) // used 'appHeader' because 'header' tag already exists in html5
    .component("userMenu", user_menu_component_1.UserMenuComponent);


/***/ }),

/***/ "./app/header/header.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/header/header.template.html?5d5846655506c5ad2e103281fb2ed508";

/***/ }),

/***/ "./app/header/user-menu/user-menu.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var user_menu_controller_1 = __webpack_require__("./app/header/user-menu/user-menu.controller.ts");
var templateUrl = __webpack_require__("./app/header/user-menu/user-menu.template.html");
exports.UserMenuComponent = {
    templateUrl: templateUrl,
    controller: user_menu_controller_1.UserMenuController,
    bindings: {
        currentUser: "=user",
        isLogin: "=",
        logout: "=",
        userProfile: "=",
    }
};


/***/ }),

/***/ "./app/header/user-menu/user-menu.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var UserMenuController = (function () {
    function UserMenuController($scope, userModalsSrv, userManagerSrv) {
        var _this = this;
        var boundProps = Object.keys(this); // this OR $scope.$ctrl are here the same
        boundProps.forEach(function (prop) {
            $scope[prop] = _this[prop];
        });
        $scope.userProfile = function (name) {
            userModalsSrv.openUserDetailsModal(name, true);
        };
        $scope.userGroup = userManagerSrv.getCurUserGroup();
    }
    return UserMenuController;
}());
exports.UserMenuController = UserMenuController;


/***/ }),

/***/ "./app/header/user-menu/user-menu.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/header/user-menu/user-menu.template.html?6d40c07433c7f1e9662eebfa12f073ae";

/***/ }),

/***/ "./app/routes/about-page/about-page.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var about_page_controller_1 = __webpack_require__("./app/routes/about-page/about-page.controller.ts");
var templateUrl = __webpack_require__("./app/routes/about-page/about-page.template.html");
exports.AboutPageComponent = {
    controller: about_page_controller_1.AboutPageController,
    templateUrl: templateUrl,
    showAlarmOverlay: false,
};


/***/ }),

/***/ "./app/routes/about-page/about-page.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {
Object.defineProperty(exports, "__esModule", { value: true });
var AboutPageController = (function () {
    function AboutPageController($scope, $http, commonUtils, REST_ENDPOINT) {
        this.$scope = $scope;
        this.$http = $http;
        this.commonUtils = commonUtils;
        this.REST_ENDPOINT = REST_ENDPOINT;
        $scope.fossLicenseUrl = "packages/uifmm/fossLicense.txt";
        $scope.licenseUrl = "packages/uifmm/License.txt";
        function initialize() {
            $scope.Info = {
                product: commonUtils.SNP_PRODUCT_NAME,
                version: "",
                license: {
                    copyright: "2016-2023 Imagine Communications Corp.\nAll rights reserved.",
                    jpegxs: "",
                    dts: "",
                    dolbye: "",
                },
                company: {
                    name: "Imagine Communications Corp.",
                    url: "http://www.imaginecommunications.com",
                },
            };
            $scope.aboutImgPath = "packages/uifmm/images/about_snp.png";
            $scope.aboutIntoPIXImgPath = "packages/uifmm/images/logo_intoPIX.png";
            $scope.aboutJpegxsImgPath = "packages/uifmm/images/logo_JPEGXS.png";
            $scope.aboutDtsImgPath = "packages/uifmm/images/logo_DTS.png";
            $scope.aboutDolbyeImgPath = "packages/uifmm/images/logo_DolbyE_sm.png";
            $scope.aboutCompanyLogo = "packages/uifmm/images/full-logo.png";
        }
        function getInfo() {
            $http.get(REST_ENDPOINT.URI + "logos/about").success(function (response) {
                $scope.Info.product = response.product;
                $scope.Info.component = response.product === "Selenio&trade; One" ? "Media Manager " : "Version: ";
                $scope.Info.version = response.version;
                $scope.Info.company.name = response.company.name;
                $scope.Info.company.url = response.company.url;
                $scope.Info.license.copyright = response.license.copyright;
                $scope.Info.license.jpegxs = response.license.jpegxs;
                $scope.Info.license.dts = response.license.dts;
                $scope.Info.license.dolbye = response.license.dolbye;
            }).error(function (response) { });
        }
        initialize();
        getInfo();
        $("#aboutDlg")
            .on("show.bs.modal", function () {
            getInfo();
        })
            .on("hidden.bs.modal", function () {
            initialize();
        });
    }
    return AboutPageController;
}());
exports.AboutPageController = AboutPageController;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__("./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./app/routes/about-page/about-page.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/routes/about-page/about-page.template.html?d2aad2bbb79e23850d670a887eea1c8b";

/***/ }),

/***/ "./app/routes/alarms-page/alarm-page.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var alarm_page_controller_1 = __webpack_require__("./app/routes/alarms-page/alarm-page.controller.ts");
var templateUrl = __webpack_require__("./app/routes/alarms-page/alarm-page.template.html");
exports.AlarmsPageComponent = {
    controller: alarm_page_controller_1.AlarmPageController,
    templateUrl: templateUrl,
    showAlarmOverlay: false,
};


/***/ }),

/***/ "./app/routes/alarms-page/alarm-page.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var AlarmPageController = (function () {
    function AlarmPageController($scope, fmeListSrv, commonUtils) {
        $scope.fmeList = fmeListSrv.getAllElements();
        $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        $scope.showGroup = "active";
        $scope.showOnly = function (grp) {
            $scope.showGroup = grp;
        };
        $scope.loadRequestPopups = false;
        $scope.setLoadRequestPopups = function () {
            $scope.loadRequestPopups = true;
        };
        $scope.toggleElementsGroup = function () {
            $scope.$broadcast('regroup-alarms');
        };
        $scope.$on('$locationChangeStart', function () {
            //when location URL changes
            fmeListSrv.clearUpdateStatus();
        });
        $scope.$on('$viewContentLoaded', function () {
            // after view finishes loading
            commonUtils.resizeWindow();
            fmeListSrv.clearUpdateStatus();
            $scope.setLoadRequestPopups();
        });
    }
    return AlarmPageController;
}());
exports.AlarmPageController = AlarmPageController;


/***/ }),

/***/ "./app/routes/alarms-page/alarm-page.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/routes/alarms-page/alarm-page.template.html?50b1f880f8b5d971c64f824f994b23e4";

/***/ }),

/***/ "./app/routes/config-page/config-page.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var config_page_controller_1 = __webpack_require__("./app/routes/config-page/config-page.controller.ts");
var templateUrl = __webpack_require__("./app/routes/config-page/config-page.template.html");
var snpCss = __webpack_require__("./app/routes/snp.css");
exports.SnpConfigPageComponent = {
    controller: config_page_controller_1.SnpConfigPageController,
    templateUrl: templateUrl,
    showAlarmOverlay: true,
    // viewName: VIEW_NAMES.CONFIG,
    css: snpCss,
};


/***/ }),

/***/ "./app/routes/config-page/config-page.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var SnpConfigPageController = (function () {
    function SnpConfigPageController($scope, $location, $interval, $routeParams, fmeListSrv, modalsSrv, commonUtils) {
        $scope.processorObjectIds = ["processorA", "processorB", "processorC", "processorD"];
        $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        var pollIntervalId = null;
        var POLL_INTERVAL = 2 * 1000; //in ms
        var selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        var element_ip = $routeParams.element_ip ? $routeParams.element_ip : selfHost ? $location.$$host : null;
        function init() {
            if (!!element_ip) {
                // load element information to view and save to service
                fmeListSrv.setLastUsedElement(element_ip);
                _loadElement(element_ip);
            }
            else {
                $location.url('/');
                alert('Please Specify Element');
            }
        }
        $scope.elementConnected = false;
        $scope.loadingPreset = false;
        function _loadElement(element_ip) {
            // set element for this view and go back to dashboard if element is not available
            $scope.element = fmeListSrv.getElement(element_ip);
            if (!angular_1.isObject($scope.element) || !!$scope.element.loadingConfigs || fmeListSrv.isPresetLoading(element_ip) || (!!$scope.element.state && $scope.element.state != 'connected')) {
                $scope.elementConnected = false;
                if (!$scope.selfHost && angular_1.isObject($scope.element) && !!$scope.element.state && $scope.element.state === 'not_connected') {
                    modalsSrv.dismissAllModals();
                    $location.url('/');
                }
                if (angular_1.isObject($scope.element) && fmeListSrv.isPresetLoading(element_ip)) {
                    $scope.elementConnected = false;
                    $scope.elementSynced = false;
                    $scope.loadingPreset = true;
                    $scope.processorsReady = 0;
                }
                else if (angular_1.isObject($scope.element) && !!$scope.element.loadingConfigs) {
                    $scope.elementConnected = true;
                    $scope.elementSynced = false;
                    $scope.processorsReady = 0;
                }
                else {
                    $scope.loadingPreset = false;
                }
            }
            else {
                $scope.elementConnected = true;
                $scope.loadingPreset = false;
            }
        }
        function _loadSystemStatus(element_ip) {
            var tmpSystemStatus = fmeListSrv.getStatusFromCache("../status/" + element_ip + "/system/system");
            if (tmpSystemStatus) {
                $scope.element.firmwareState = tmpSystemStatus.General.productReleaseState;
            }
            tmpSystemStatus = null;
        }
        $scope.$on("$destroy", function () {
            if (!!pollIntervalId) {
                $interval.cancel(pollIntervalId);
                pollIntervalId = null;
            }
        });
        $scope.elementSynced = false;
        $scope.processorsReady = 0;
        $scope.processorReady = function (procIdx) {
            ++$scope.processorsReady;
            if ($scope.processorsReady >= 4) {
                $scope.elementSynced = true;
            }
        };
        // polling loop for element status
        if (!angular_1.isObject(pollIntervalId)) {
            pollIntervalId = $interval(function () {
                _loadElement(element_ip);
                _loadSystemStatus(element_ip);
            }, POLL_INTERVAL);
        }
        init();
        $scope.$on('$viewContentLoaded', function () {
            $scope.loadRequestPopups = true;
        });
    }
    return SnpConfigPageController;
}());
exports.SnpConfigPageController = SnpConfigPageController;


/***/ }),

/***/ "./app/routes/config-page/config-page.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/routes/config-page/config-page.template.html?299ebf4b4b982ef5fbbb163f0092299f";

/***/ }),

/***/ "./app/routes/console-page/console-page.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var console_page_controller_1 = __webpack_require__("./app/routes/console-page/console-page.controller.ts");
var templateUrl = __webpack_require__("./app/routes/console-page/console-page.template.html");
exports.ConsolePageComponent = {
    controller: console_page_controller_1.ConsoleController,
    templateUrl: templateUrl,
    showAlarmOverlay: false,
};


/***/ }),

/***/ "./app/routes/console-page/console-page.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ConsoleController = (function () {
    function ConsoleController($scope, $http, $interval, userManagerSrv, fmmStateSrv, REST_ENDPOINT) {
        var _this = this;
        this.$scope = $scope;
        this.$http = $http;
        this.$interval = $interval;
        this.userManagerSrv = userManagerSrv;
        this.fmmStateSrv = fmmStateSrv;
        this.REST_ENDPOINT = REST_ENDPOINT;
        // System information scope vars
        this.$scope.status = {
            opMode: "Retrieving...",
            netMode: "Retrieving...",
            logLevel: "Retrieving...",
            remoteLogger: "Retrieving...",
            serialNum: "Retrieving...",
            hardwareRev: "Retrieving...",
            firmwareVer: "Retrieving...",
            interfaces: [
                {
                    id: "ctrl1",
                    ip: "Retrieving...",
                    mask: "Retrieving...",
                    gateway: "Retrieving...",
                    mac: "Retrieving...",
                },
                {
                    id: "ctrl2",
                    ip: "Retrieving...",
                    mask: "Retrieving...",
                    gateway: "Retrieving...",
                    mac: "Retrieving...",
                },
            ],
            upgrade: {
                isInProgress: false,
            },
            configReset: {
                isInProgress: false,
            },
            factoryReset: {
                isInProgress: false,
            },
            services: {
                ssh: {
                    isRunning: true,
                },
                telnet: {
                    isRunning: null,
                },
                inetd: {
                    isRunning: null,
                },
            },
        };
        // Misc. scope vars
        this.$scope.isAdmin = false;
        var isPolling = false;
        var hasPreviousPollConnection = false;
        var pollStatus = function () {
            if (isPolling) {
                return;
            }
            isPolling = true;
            var status = _this.fmmStateSrv.getConsoleStatus();
            if (status && !status.error) {
                if (status.error !== undefined) {
                    _this.$scope.isDisconnected = false;
                    _this.$scope.isReconnected = !hasPreviousPollConnection;
                    hasPreviousPollConnection = true;
                    _this.$scope.status = status.status;
                }
            }
            else {
                _this.$scope.isReconnected = false;
                _this.$scope.isDisconnected = hasPreviousPollConnection;
                hasPreviousPollConnection = false;
                _this.$scope.status.msg =
                    "Cannot reach configuration service" +
                        (!!status.errorMsg ? ": " + status.errorMsg : "");
                _this.$scope.status.isErrorMsg = true;
            }
            isPolling = false;
        };
        var pollConsoleStatusInterval = this.$interval(pollStatus, 1000);
        // Control Link Binding scope vars
        this.$scope.getNetModeLabel = function (mode) {
            if (mode === "bondedActiveBackup") {
                return "Bonded Active/Backup";
            }
            else if (mode === "bondedLACP") {
                return "Bonded LACP";
            }
            else if (mode === "dual") {
                return "Dual Addresses";
            }
            else {
                return mode;
            }
        };
        this.$scope.applyNetMode = function () {
            _this.$scope.netModeApplyInProgress = true;
            _this.$http
                .post(_this.REST_ENDPOINT.URI + "console/setconfig", {
                operation: "set",
                data: {
                    netMode: _this.$scope.selectedNetMode,
                },
            })
                .success(function () { })
                .error(function (err) {
                _this.$scope.netModeMsg =
                    "Applying mode failed" + (err ? ": " + err : "");
                _this.$scope.netModeIsError = true;
            })
                .finally(function () {
                _this.$scope.netModeApplyInProgress = false;
            });
        };
        /*
            #define LOG_EMERG   0   // system is unusable
            #define LOG_ALERT   1   // action must be taken immediately
            #define LOG_CRIT    2   // critical conditions
            #define LOG_ERR     3   // error conditions
            #define LOG_WARNING 4   // warning conditions
            #define LOG_NOTICE  5   // normal but significant condition
            #define LOG_INFO    6   // informational
            #define LOG_DEBUG   7   // debug-level messages
        */
        this.$scope.getLogLevelLabel = function (level) {
            if (level === "1") {
                return "EMERGENCY";
            }
            else if (level === "2") {
                return "ALERT";
            }
            else if (level === "3") {
                return "CRITICAL";
            }
            else if (level === "4") {
                return "ERROR";
            }
            else if (level === "5") {
                return "WARNING";
            }
            else if (level === "6") {
                return "NOTICE";
            }
            else if (level === "7") {
                return "INFORMATION";
            }
            else if (level === "8") {
                return "DEBUG";
            }
            else {
                return level;
            }
        };
        this.$scope.applyLogLevel = function () {
            _this.$scope.logLevelApplyInProgress = true;
            _this.$http
                .post(_this.REST_ENDPOINT.URI + "console/setloglevel", {
                operation: "set",
                data: {
                    logLevel: _this.$scope.selectedLogLevel,
                },
            })
                .success(function () { })
                .error(function (err) {
                _this.$scope.logLevelMsg =
                    "Applying Log Level failed" + (err ? ": " + err : "");
                _this.$scope.logLevelIsError = true;
            })
                .finally(function () {
                _this.$scope.logLevelApplyInProgress = false;
            });
        };
        this.$scope.applyRemoteLogger = function () {
            _this.$scope.remoteLoggerIsError = false;
            var fields = _this.$scope.selectedRemoteLogger.split(':');
            if (fields.length != 2) {
                _this.$scope.remoteLoggerMsg =
                    "Failed: Invalid input";
                _this.$scope.remoteLoggerIsError = true;
                _this.$scope.selectedRemoteLogger = "";
                return;
            }
            var address = fields[0];
            var port = fields[1];
            if (address == "127.0.0.1" || (address == "0.0.0.0" && port != "0")) {
                _this.$scope.remoteLoggerMsg =
                    "Failed: Loopback not allowed";
                _this.$scope.remoteLoggerIsError = true;
                _this.$scope.selectedRemoteLogger = "";
                return;
            }
            _this.$scope.remoteLoggerApplyInProgress = true;
            _this.$http
                .post(_this.REST_ENDPOINT.URI + "console/setremotelogger", {
                operation: "set",
                data: {
                    remoteLogger: _this.$scope.selectedRemoteLogger,
                },
            })
                .success(function () { })
                .error(function (err) {
                _this.$scope.remoteLoggerMsg =
                    "Applying Remote Logger failed" + (err ? ": " + err : "");
                _this.$scope.remoteLoggerIsError = true;
            })
                .finally(function () {
                _this.$scope.remoteLoggerApplyInProgress = false;
            });
        };
        // Misc. functionality
        var getUserGroup = function () {
            var groupName = _this.userManagerSrv.getCurUserGroup().name;
            if (groupName === undefined) {
                setTimeout(getUserGroup, 1000);
            }
            else
                _this.$scope.isAdmin = groupName === "Administrator";
        };
        getUserGroup();
        this.$scope.$on("$viewContentLoaded", function () {
            _this.$scope.loadRequestPopups = true;
        });
        this.$scope.$on("$destroy", function () {
            cancelPollConsoleStatusInterval();
        });
        var cancelPollConsoleStatusInterval = function () {
            if (pollConsoleStatusInterval) {
                _this.$interval.cancel(pollConsoleStatusInterval);
            }
        };
    }
    return ConsoleController;
}());
exports.ConsoleController = ConsoleController;


/***/ }),

/***/ "./app/routes/console-page/console-page.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/routes/console-page/console-page.template.html?800ccf2490c2fdc264c05fe631ca9851";

/***/ }),

/***/ "./app/routes/dashboard-page/dashboard-page.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var dashboard_page_controller_1 = __webpack_require__("./app/routes/dashboard-page/dashboard-page.controller.ts");
var templateUrl = __webpack_require__("./app/routes/dashboard-page/dashboard-page.template.html");
var snpCss = __webpack_require__("./app/routes/snp.css");
exports.SnpDashboardPageComponent = {
    controller: dashboard_page_controller_1.DashboardPageController,
    templateUrl: templateUrl,
    showAlarmOverlay: true,
    // viewName: VIEW_NAMES.DASHBOARD,
    css: snpCss,
};


/***/ }),

/***/ "./app/routes/dashboard-page/dashboard-page.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var DashboardPageController = (function () {
    function DashboardPageController($scope, $location, $interval, fmeListSrv, commonUtils) {
        this.$scope = $scope;
        this.$location = $location;
        this.$interval = $interval;
        this.fmeListSrv = fmeListSrv;
        this.commonUtils = commonUtils;
        this.filters = [];
        this.search = '';
        var selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        $scope.elements = fmeListSrv.getAllElements();
        if (selfHost) {
            var intervalId = $interval(function () {
                if ($scope.elements.length > 0) {
                    var tmpElement;
                    $scope.elements.forEach(function (el) {
                        if (el.ip === $location.$$host) {
                            tmpElement = el;
                        }
                    });
                    if (tmpElement !== undefined && angular_1.isObject(tmpElement) && tmpElement.state && tmpElement.state === 'connected') {
                        $interval.cancel(intervalId);
                        $scope.openConfig(null);
                    }
                }
            }, 20);
        }
        $scope.elementFilter = function (element) {
            return element.state !== 'managed' && element.state !== 'unmanaged';
        };
        $scope.displayNameComparator = function (obj) {
            return !!obj.name ? -1 : 1;
        };
        $scope.openConfig = function (element_ip) {
            // open element config view of given element IP
            var params = element_ip ? '?element_ip=' + element_ip : '';
            $location.url('config' + params);
        };
        $scope.$on("$destroy", function () {
            // add code to stop polling all element status when not in view
        });
        $scope.$on('$viewContentLoaded', function () {
            $scope.loadRequestPopups = true;
        });
    }
    return DashboardPageController;
}());
exports.DashboardPageController = DashboardPageController;


/***/ }),

/***/ "./app/routes/dashboard-page/dashboard-page.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/routes/dashboard-page/dashboard-page.template.html?66ea0e54e791459d3a5ed7451cf8bbe1";

/***/ }),

/***/ "./app/routes/login-page/login-page.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var login_page_controller_1 = __webpack_require__("./app/routes/login-page/login-page.controller.ts");
var templateUrl = __webpack_require__("./app/routes/login-page/login-page.template.html");
exports.LoginPageComponent = {
    controller: login_page_controller_1.LoginPageController,
    templateUrl: templateUrl,
    showAlarmOverlay: false,
    isLogin: true,
};


/***/ }),

/***/ "./app/routes/login-page/login-page.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.LoginPageController = function ($scope, $http, $location, $uibModalStack, fmmStateSrv, fmeListSrv, loginSrv, REST_ENDPOINT, commonUtils) {
    loginSrv.setScope($scope);
    $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
    if (commonUtils.smm_restapi_token() === undefined) {
        fmeListSrv.stopService();
        fmmStateSrv.resetFmmStatus();
    }
    $scope.username = null;
    $scope.password = null;
    $scope.submitDisabled = false;
    $scope.error = {
        username: null,
        password: null,
    };
    $uibModalStack.dismissAll();
    $scope.login = function () {
        console.log('auth/login()');
        if (!$scope.username)
            $scope.error.username = "This field is required";
        else
            $scope.error.username = false;
        if (!$scope.password)
            $scope.error.password = "This field is required";
        else if ($scope.password.length < 6)
            $scope.error.password = "The password must have at least 6 characters";
        else
            $scope.error.password = false;
        if (!$scope.error.username && !$scope.error.password) {
            $http({
                url: REST_ENDPOINT.URI + "auth",
                method: "POST",
                data: {
                    username: $scope.username,
                    password: $scope.password
                },
                transformResponse: [commonUtils.plainResponse],
            }).then(function (response) {
                document.cookie =
                    "smm_restapi_token=" +
                        encodeURIComponent(response.data) +
                        "; path=/; secure";
                /* location.reload(true); */
                fmmStateSrv.readFmmStatus();
                $location.path("/");
            }, function (response) {
                document.cookie =
                    "smm_restapi_token=; expires=" +
                        new Date(0).toUTCString() +
                        "; path=/; secure";
                $scope.statusMessage =
                    response && response.data === "Unauthorized" ?
                        "The username or password you entered is incorrect." :
                        "Unknown login error" +
                            (response && response.status ?
                                ": Code " + response.status :
                                "");
            });
        }
    };
};


/***/ }),

/***/ "./app/routes/login-page/login-page.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/routes/login-page/login-page.template.html?1bc79c59043ba1df4eed1377b4c0ab20";

/***/ }),

/***/ "./app/routes/routing.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var auth_interceptor_service_1 = __webpack_require__("./app/auth/auth-interceptor.service.ts");
var dashboard_page_component_1 = __webpack_require__("./app/routes/dashboard-page/dashboard-page.component.ts");
var config_page_component_1 = __webpack_require__("./app/routes/config-page/config-page.component.ts");
var login_page_component_1 = __webpack_require__("./app/routes/login-page/login-page.component.ts");
var about_page_component_1 = __webpack_require__("./app/routes/about-page/about-page.component.ts");
var users_page_component_1 = __webpack_require__("./app/routes/users-page/users-page.component.ts");
var console_page_component_1 = __webpack_require__("./app/routes/console-page/console-page.component.ts");
var alarm_page_component_1 = __webpack_require__("./app/routes/alarms-page/alarm-page.component.ts");
// declare let SMM_PARAMS;
var selfHost = false;
if (typeof SMM_PARAMS !== "undefined") {
    selfHost = SMM_PARAMS["SMM_SELF_HOST"] === "true";
}
exports.RoutingModule = angular_1.module("RoutingModule", ["ngRoute"])
    .config([
    "$routeProvider",
    function ($routeProvider) {
        $routeProvider
            .when("/alarms", alarm_page_component_1.AlarmsPageComponent)
            .when("/about", about_page_component_1.AboutPageComponent)
            .when("/login", login_page_component_1.LoginPageComponent)
            .when("/users", users_page_component_1.UsersPageComponent)
            .when("/config", config_page_component_1.SnpConfigPageComponent);
        if (selfHost) {
            $routeProvider
                .when("/console", console_page_component_1.ConsolePageComponent)
                .otherwise({
                redirectTo: "/config"
            });
        }
        else {
            $routeProvider
                .when("/dashboard", dashboard_page_component_1.SnpDashboardPageComponent)
                .otherwise({
                redirectTo: "/dashboard"
            });
        }
    },
])
    .service("AuthInterceptor", auth_interceptor_service_1.AuthInterceptorService)
    .config([
    "$httpProvider",
    function ($httpProvider) {
        //uncomment code below to make flexApp work with Request.isAjaxRequest()
        //$httpProvider.defaults.headers.common['X-Requested-With']='XMLHttpRequest';
        $httpProvider.useApplyAsync(true);
        $httpProvider.interceptors.push("AuthInterceptor");
    },
]);


/***/ }),

/***/ "./app/routes/snp.css":
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__("./node_modules/css-loader/index.js!./app/routes/snp.css");
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__("./node_modules/style-loader/lib/addStyles.js")(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {
	// When the styles change, update the <style> tags
	if(!content.locals) {
		module.hot.accept("!!../../node_modules/css-loader/index.js!./snp.css", function() {
			var newContent = require("!!../../node_modules/css-loader/index.js!./snp.css");
			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
			update(newContent);
		});
	}
	// When the module is disposed, remove the <style> tags
	module.hot.dispose(function() { update(); });
}

/***/ }),

/***/ "./app/routes/users-page/users-page.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var users_page_controller_1 = __webpack_require__("./app/routes/users-page/users-page.controller.ts");
var templateUrl = __webpack_require__("./app/routes/users-page/users-page.template.html");
exports.UsersPageComponent = {
    controller: users_page_controller_1.UsersPageController,
    templateUrl: templateUrl,
    showAlarmOverlay: false,
};


/***/ }),

/***/ "./app/routes/users-page/users-page.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {
Object.defineProperty(exports, "__esModule", { value: true });
var UsersPageController = (function () {
    function UsersPageController($scope, $http, $interval, $location, userManagerSrv, userModalsSrv, commonUtils, REST_ENDPOINT) {
        this.$scope = $scope;
        this.$http = $http;
        this.$interval = $interval;
        this.$location = $location;
        this.userManagerSrv = userManagerSrv;
        this.userModalsSrv = userModalsSrv;
        this.commonUtils = commonUtils;
        this.REST_ENDPOINT = REST_ENDPOINT;
        $scope.users = [];
        $scope.allUsers = [];
        $scope.filter = {};
        $scope.groups = [];
        $scope.checkModel = false;
        $scope.opRes = [];
        $scope.isAdmin = false;
        $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
                if (!$scope.isAdmin)
                    $location.path("/dashboard");
            }
        };
        getUserGroup();
        var interval = $interval(getUserGroup, 500);
        var getUsers = function () {
            $http
                .get(REST_ENDPOINT.URI + "users/all")
                .success(function (response) {
                $scope.allUsers = response;
                $scope.users = response;
            })
                .error(function (response) { });
        };
        var getGroups = function () {
            $http
                .get(REST_ENDPOINT.URI + "users/groups")
                .success(function (response) {
                $scope.groups = response;
            })
                .error(function (response) { });
        };
        var clearOpRes = function (i) {
            return setTimeout(function () {
                $scope.opRes[i].class = "p-hide";
            }, 10000);
        };
        $scope.deleteUsers = function () {
            var delPromises = [];
            $scope.opRes = [];
            $scope.users.forEach(function (user) {
                if (user.checked) {
                    delPromises.push($http
                        .delete(REST_ENDPOINT.URI + "users/" + user.username)
                        .success(function () {
                        clearOpRes($scope.opRes.push({
                            class: "p-success",
                            message: "User " + user.username + " deleted successfully.",
                        }) - 1);
                    })
                        .error(function () {
                        clearOpRes($scope.opRes.push({
                            class: "p-error",
                            message: "Couldn't delete user " + user.username + ".",
                        }) - 1);
                    }));
                }
            });
            Promise.all(delPromises).then(getUsers);
        };
        $scope.checkAll = function () {
            $scope.users.map(function (user) {
                if (user.id !== 1 &&
                    user.username !== "admin" &&
                    !(user.username === "snp" && user.group_id === 4) &&
                    user.username !== "LMmonitor")
                    user.checked = $scope.checkModel;
                return user;
            });
        };
        $scope.deleteDisabled = function () {
            return !$scope.users.find(function (user) { return user.checked; });
        };
        $scope.addUser = function () {
            userModalsSrv.openUserDetailsModal(null).closed.then(getUsers);
        };
        $scope.editUser = function (name) {
            userModalsSrv.openUserDetailsModal(name).closed.then(getUsers);
        };
        $scope.activateUser = function (user) {
            $scope.opRes = [];
            var data = {
                username: user.username,
                group_id: user.group_id,
                activated: true,
            };
            if (user.first_name)
                data.first_name = user.first_name;
            if (user.last_name)
                data.last_name = user.last_name;
            $http
                .put(REST_ENDPOINT.URI + "users/" + user.id, data)
                .success(function () {
                clearOpRes($scope.opRes.push({
                    class: "p-success",
                    message: "User " + user.username + " activated successfully.",
                }) - 1);
                getUsers();
            })
                .error(function () {
                clearOpRes($scope.opRes.push({
                    class: "p-error",
                    message: "Failed to activate user " + user.username + ".",
                }) - 1);
            });
        };
        $scope.applyFilter = function () {
            $scope.users = $scope.allUsers.filter(function (user) {
                return (!$scope.filter.id || user.id === $scope.filter.id) &&
                    (!$scope.filter.username ||
                        user.username.includes($scope.filter.username)) &&
                    (!$scope.filter.first_name ||
                        (user.first_name &&
                            user.first_name.includes($scope.filter.first_name))) &&
                    (!$scope.filter.last_name ||
                        (user.last_name &&
                            user.last_name.includes($scope.filter.last_name))) &&
                    (!$scope.filter.group_id ||
                        user.group_id === parseInt($scope.filter.group_id));
            });
        };
        $scope.clearFilter = function () {
            $scope.filter = {};
            $scope.users = $scope.allUsers;
        };
        $scope.groupFilter = function (group) {
            if ($scope.selfHost || group.name !== "RemoteFmm")
                return group;
        };
        getGroups();
        getUsers();
        $scope.$on("$destroy", function () {
            $interval.cancel(interval);
        });
        $("#aboutDlg")
            .on("show.bs.modal", function () {
            getUsers();
        })
            .on("hidden.bs.modal", function () {
            getUsers();
        });
    }
    return UsersPageController;
}());
exports.UsersPageController = UsersPageController;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__("./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./app/routes/users-page/users-page.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/routes/users-page/users-page.template.html?ba743bf085deefd34b2a3ddb44eb3474";

/***/ }),

/***/ "./app/view-menu/alarm/alarm-active/alarm-active.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var alarm_active_controller_1 = __webpack_require__("./app/view-menu/alarm/alarm-active/alarm-active.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/alarm/alarm-active/alarm-active.template.html");
exports.AlarmActiveComponent = {
    controller: alarm_active_controller_1.AlarmActiveController,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/alarm/alarm-active/alarm-active.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var AlarmActiveController = (function () {
    function AlarmActiveController($scope, $interval, $timeout, fmeListSrv, alarmListSrv, commonUtils, AlarmSrv) {
        var flatView = false;
        $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        $scope.my_tree = [];
        $scope.isUserViewer = fmeListSrv.isUserViewerOnly;
        $scope.disableAlarmPerm = !fmeListSrv.isUserViewerOnly();
        $interval(function () { return $scope.disableAlarmPerm = !fmeListSrv.isUserViewerOnly(); }, 5000);
        var w_adder = !$scope.selfHost ? 0 : 3;
        var SNP_COL_DEFS = [
            {
                field: "Time_Issued",
                displayName: "Time Issued",
                sortable: true,
                sortingType: "date",
                filterable: true,
                sorted: true,
                sortDirection: "desc",
                width: 14 + w_adder
            },
            {
                field: "Location",
                sortable: true,
                sortingType: "string",
                width: 16 + w_adder
            },
            {
                field: "Name",
                displayName: "Alarm",
                sortable: true,
                sortingType: "string",
                width: 16 + w_adder
            },
            {
                field: "Reason",
                sortable: true,
                sortingType: "string",
                width: 32 + w_adder
            },
            {
                field: "Priority",
                sortable: true,
                sortingType: "number",
                disable: disableAlarm,
                isViewer: fmeListSrv.isUserViewerOnly,
                width: 10
            }
        ];
        $scope.expanding_property = {
            field: "FMELabel",
            displayName: "Element",
            sortable: true,
            filterable: true,
            width: 12
        };
        $scope.col_defs = SNP_COL_DEFS;
        function _setGroupView() {
            $scope.tree_data = alarmListSrv.allAlarms();
            $scope.countMsg = "";
            flatView = false;
        }
        function _setFlatView() {
            var data = alarmListSrv.allAlarmsFlaten();
            $scope.tree_data = data.alarms;
            $scope.countMsg = data.count;
            flatView = true;
            if (!$scope.countMsg)
                $timeout(_setFlatView, 100);
        }
        $scope.alarmPriority = function (priority) {
            return priority < 5 ? "activeAlarmYellowColor" : "activeAlarmRedColor";
        };
        if ($scope.selfHost || AlarmSrv.grouped) {
            _setFlatView();
        }
        else {
            _setGroupView();
        }
        $scope.$on("regroup-alarms", function () {
            if (flatView) {
                AlarmSrv.grouped = false;
                _setGroupView();
            }
            else {
                AlarmSrv.grouped = true;
                _setFlatView();
            }
        });
        function disableAlarm(alarm) {
            // find the corresponding alarm and disable it
            var cfg = alarmListSrv.getAlarmProperties(alarm.FME, alarm.ID, alarm.Location, true);
            var fme_ip = alarm.FME;
            alarm.disableClicked = true;
            if (!!cfg.Name) {
                var alarm_obj = [
                    {
                        "number": parseInt(alarm.ID, 10),
                        "enable": false,
                        "priority": parseInt(cfg.Priority, 10),
                        "raiseDelay": parseInt(cfg.Raise_delay, 10),
                        "clearDelay": parseInt(cfg.Clear_delay, 10),
                        "location": cfg.Location
                    }
                ];
                alarmListSrv.UpdateAlarmCfg(fme_ip, alarm_obj);
            }
        }
        $scope.disableAlarm = disableAlarm;
        $scope.$watch('col_defs', function (newVal, oldVal, scope) {
            // send sorting criteria to alarmList
            var sortCol = newVal.find(function (e) { return (e.sorted); });
            if (typeof sortCol !== 'undefined') {
                alarmListSrv.setSortCriteria(sortCol);
            }
        }, true);
        alarmListSrv.refreshAlarmLogs();
    }
    return AlarmActiveController;
}());
exports.AlarmActiveController = AlarmActiveController;


/***/ }),

/***/ "./app/view-menu/alarm/alarm-active/alarm-active.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
__webpack_require__("./app/view-menu/alarm/alarm-active/tree-grid/tree-grid.module.ts");
var alarm_active_component_1 = __webpack_require__("./app/view-menu/alarm/alarm-active/alarm-active.component.ts");
exports.AlarmActiveModule = angular_1.module("AlarmActiveModule", [
    "treeGridMod",
])
    .component("alarmActive", alarm_active_component_1.AlarmActiveComponent);


/***/ }),

/***/ "./app/view-menu/alarm/alarm-active/alarm-active.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/alarm/alarm-active/alarm-active.template.html?f7d6633e30c4ce609f612307ba233a50";

/***/ }),

/***/ "./app/view-menu/alarm/alarm-active/tree-grid/search-for.filter.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

//                                  Usage example:
// <tr ng-repeat="row in tree_rows | searchFor:$parent.filterString:expandingProperty:colDefinitions:true track by row.branch.uid"
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchForFilter = function () {
    return function (arr, filterString, expandingProperty, colDefinitions) {
        var filtered = [];
        //only apply filter for strings 3 characters long or more
        if (arr && (!filterString || filterString.length < 3)) {
            for (var i = 0; i < arr.length; i++) {
                var item = arr[i];
                if (item.visible) {
                    filtered.push(item);
                }
            }
        }
        else if (arr) {
            var ancestorStack = [];
            var currentLevel = 0;
            for (var i = 0; i < arr.length; i++) {
                var item = arr[i];
                while (currentLevel >= item.level) {
                    ancestorStack.pop();
                    currentLevel--;
                }
                ancestorStack.push(item);
                currentLevel = item.level;
                if (include(item, filterString, expandingProperty, colDefinitions)) {
                    for (var ancestorIndex = 0; ancestorIndex < ancestorStack.length; ancestorIndex++) {
                        var ancestor = ancestorStack[ancestorIndex];
                        if (ancestor.visible) {
                            filtered.push(ancestor);
                        }
                    }
                    ancestorStack = [];
                }
            }
        }
        return filtered;
    };
    function include(item, filterString, expandingProperty, colDefinitions) {
        var includeItem = false;
        var filterApplied = false;
        //first check the expandingProperty
        if (expandingProperty.filterable) {
            filterApplied = true;
            if (checkItem(item, filterString, expandingProperty)) {
                includeItem = true;
            }
        }
        //then check each of the other columns
        var arraySize = colDefinitions.length;
        for (var i = 0; i < arraySize; i++) {
            var col = colDefinitions[i];
            if (col.filterable) {
                filterApplied = true;
                if (checkItem(item, filterString, col)) {
                    includeItem = true;
                }
            }
        }
        if (filterApplied) {
            return includeItem;
        }
        else {
            return true;
        }
    }
    function checkItem(item, filterString, col) {
        if (col.sortingType === "number") {
            if (item.branch[col.field] != null &&
                parseFloat(item.branch[col.field]) === parseFloat(filterString)) {
                return true;
            }
        }
        else {
            if (item.branch[col.field] != null &&
                item.branch[col.field]
                    .toLowerCase()
                    .indexOf(filterString.toLowerCase()) !== -1) {
                return true;
            }
        }
    }
};


/***/ }),

/***/ "./app/view-menu/alarm/alarm-active/tree-grid/tree-grid-compile.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeGridCompileDirective = function ($compile) {
    return {
        restrict: "A",
        link: function (scope, element, attrs) {
            scope.cellTemplateScope = scope.$eval(attrs.cellTemplateScope);
            // Watch for changes to expression.
            scope.$watch(attrs.compile, function (new_val) {
                /*
                 * Compile creates a linking function
                 * that can be used with any scope.
                 */
                var link = $compile(new_val);
                /*
                 * Executing the linking function
                 * creates a new element.
                 */
                var new_elem = link(scope);
                // Which we can then append to our DOM element.
                element.append(new_elem);
            });
        },
    };
};


/***/ }),

/***/ "./app/view-menu/alarm/alarm-active/tree-grid/tree-grid.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var templateUrl = __webpack_require__("./app/view-menu/alarm/alarm-active/tree-grid/tree-grid.template.html");
exports.TreeGridDirective = function ($timeout, AlarmSrv) {
    return {
        restrict: "E",
        templateUrl: function (tElement, tAttrs) {
            return tAttrs.templateUrl || templateUrl;
        },
        replace: true,
        scope: {
            treeData: "=",
            countMsg: "=",
            colDefs: "=",
            expandOn: "=",
            onSelect: "&",
            onClick: "&",
            initialSelection: "@",
            treeControl: "=",
            selfHost: "=",
        },
        link: function (scope, element, attrs) {
            var error, expandingProperty, expand_all_parents, expand_level, for_all_ancestors, for_each_branch, get_parent, n, on_treeData_change, select_branch, selected_branch, tree;
            var alarmLevel = 5;
            error = function (s) {
                console.log("ERROR:" + s);
                debugger;
                return void 0;
            };
            attrs.iconExpand = attrs.iconExpand ?
                attrs.iconExpand :
                "icon-plus  glyphicon glyphicon-plus  fa fa-plus";
            attrs.iconCollapse = attrs.iconCollapse ?
                attrs.iconCollapse :
                "icon-minus glyphicon glyphicon-minus fa fa-minus";
            //attrs.iconLeaf = attrs.iconLeaf ? attrs.iconLeaf : 'icon-file  glyphicon glyphicon-file  fa fa-file';
            attrs.sortedAsc = attrs.sortedAsc ?
                attrs.sortedAsc :
                "icon-file  glyphicon glyphicon-arrow-up  fa  fa-arrow-up";
            attrs.sortedDesc = attrs.sortedDesc ?
                attrs.sortedDesc :
                "icon-file  glyphicon glyphicon-arrow-down  fa fa-arrow-down";
            attrs.expandLevel = attrs.expandLevel ? attrs.expandLevel : "3";
            expand_level = parseInt(attrs.expandLevel, 10);
            if (!scope.treeData) {
                alert("No data was defined for the tree, please define treeData!");
                return;
            }
            var getExpandingProperty = function getExpandingProperty() {
                if (attrs.expandOn) {
                    expandingProperty = scope.expandOn;
                    scope.expandingProperty = scope.expandOn;
                }
                else {
                    if (scope.treeData.length) {
                        var _firstRow = scope.treeData[0], _keys = Object.keys(_firstRow);
                        for (var i = 0, len = _keys.length; i < len; i++) {
                            if (typeof _firstRow[_keys[i]] === "string") {
                                expandingProperty = _keys[i];
                                break;
                            }
                        }
                        if (!expandingProperty)
                            expandingProperty = _keys[0];
                        scope.expandingProperty = expandingProperty;
                    }
                }
                if (scope.treeData.length > 0) {
                    scope.treeData.forEach(function (b, i) {
                        if (AlarmSrv.branches[b.FME])
                            scope.treeData[i].expanded = AlarmSrv.branches[b.FME];
                    });
                }
            };
            if (!attrs.colDefs) {
                if (scope.treeData.length) {
                    var _col_defs = [], _firstRow = scope.treeData[0], _unwantedColumn = [
                        "children",
                        "level",
                        "expanded",
                        expandingProperty,
                    ];
                    for (var idx in _firstRow) {
                        if (_unwantedColumn.indexOf(idx) === -1) {
                            _col_defs.push({
                                field: idx,
                            });
                        }
                    }
                    scope.colDefinitions = _col_defs;
                }
            }
            else {
                scope.colDefinitions = scope.colDefs;
            }
            for_each_branch = function (f) {
                var do_f, root_branch, _i, _len, _ref, _results;
                do_f = function (branch, level) {
                    var child, _i, _len, _ref, _results;
                    f(branch, level);
                    if (branch.children != null) {
                        _ref = branch.children;
                        _results = [];
                        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                            child = _ref[_i];
                            _results.push(do_f(child, level + 1));
                        }
                        return _results;
                    }
                };
                _ref = scope.treeData;
                _results = [];
                for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                    root_branch = _ref[_i];
                    _results.push(do_f(root_branch, 1));
                }
                return _results;
            };
            selected_branch = null;
            select_branch = function (branch) {
                if (!branch) {
                    if (selected_branch != null) {
                        selected_branch.selected = false;
                    }
                    selected_branch = null;
                    return;
                }
                if (branch !== selected_branch) {
                    if (selected_branch != null) {
                        selected_branch.selected = false;
                    }
                    branch.selected = true;
                    selected_branch = branch;
                    expand_all_parents(branch);
                    if (branch.onSelect != null) {
                        return $timeout(function () {
                            return branch.onSelect(branch);
                        });
                    }
                    else {
                        if (scope.onSelect != null) {
                            return $timeout(function () {
                                return scope.onSelect({
                                    branch: branch,
                                });
                            });
                        }
                    }
                }
            };
            scope.on_user_click = function (branch) {
                if (scope.onClick) {
                    scope.onClick({
                        branch: branch,
                    });
                }
            };
            scope.user_clicks_branch = function (branch) {
                branch.expanded = !branch.expanded;
                AlarmSrv.branches[branch.FME] = branch.expanded;
                if (branch !== selected_branch) {
                    return select_branch(branch);
                }
            };
            scope.activeAlarmColor = function (colDefinitions, row) {
                var i = 0;
                for (i = 0; i < colDefinitions.length; i++) {
                    if (colDefinitions[i].field === "Priority") {
                        if (row.branch[colDefinitions[i].field] > 0 &&
                            row.branch[colDefinitions[i].field] < alarmLevel) {
                            return {
                                activeAlarmYellowColor: true,
                            };
                        }
                        else if (row.branch[colDefinitions[i].field] >= alarmLevel) {
                            return {
                                activeAlarmRedColor: true,
                            };
                        }
                        else {
                            return {
                                alarmColor: true,
                            };
                        }
                    }
                }
                return;
            };
            scope.levelClass = function (row) {
                var tempClass = "level-" + row.level;
                if (row.branch.children.length > 0) {
                    tempClass += " parent-row";
                }
                return tempClass;
            };
            /* sorting methods */
            scope.sortBy = function (col, persistDir) {
                if (persistDir === void 0) { persistDir = false; }
                // if col is not defined then use the current sorting col in scope.colDefinitions
                if (typeof col === "undefined") {
                    col = scope.colDefinitions.find(function (colDef) {
                        return typeof colDef.sorted !== "undefined" && colDef.sorted;
                    });
                }
                // only proceed if col is defined
                if (typeof col !== "undefined") {
                    // if persistDir is true, persist sorting direction
                    if ((persistDir === false && col.sortDirection === "asc") ||
                        (persistDir === true && col.sortDirection === "desc")) {
                        sort_recursive(scope.treeData, col, true);
                        col.sortDirection = "desc";
                        col.sortingIcon = attrs.sortedDesc;
                    }
                    else {
                        sort_recursive(scope.treeData, col, false);
                        col.sortDirection = "asc";
                        col.sortingIcon = attrs.sortedAsc;
                    }
                    col.sorted = true;
                    AlarmSrv.sortCol = col.field;
                    AlarmSrv.sortDir = col.sortDirection;
                    resetSorting(col);
                }
            };
            var sort_recursive = function (elements, col, descending) {
                elements.sort(sort_by(col, descending));
                for (var i = 0; i < elements.length; i++) {
                    if (!!elements[i].children) {
                        sort_recursive(elements[i].children, col, descending);
                    }
                }
            };
            var sort_by = function (col, descending) {
                var direction = !descending ? 1 : -1;
                if (col.sortingType === "custom" &&
                    typeof col.sortingFunc === "function") {
                    return function (a, b) {
                        return col.sortingFunc(a, b) * direction;
                    };
                }
                var key = function (x) {
                    return !x[col.field] ? "" : x[col.field].toLowerCase();
                };
                switch (col.sortingType) {
                    case "number":
                        key = function (x) {
                            return parseFloat(x[col.field]);
                        };
                        break;
                    case "date":
                        key = function (x) {
                            return new Date(x[col.field]);
                        };
                        break;
                    case "boolean":
                        key = function (x) {
                            return x[col.field].toString();
                        };
                        break;
                }
                return function (a, b) {
                    return (a = key(a)), (b = key(b)), direction * (Number(a > b) - Number(b > a));
                };
            };
            var resetSorting = function (sortedCol) {
                var arraySize = scope.colDefinitions.length;
                for (var i = 0; i < arraySize; i++) {
                    var col = scope.colDefinitions[i];
                    if (col.field != sortedCol.field) {
                        col.sorted = false;
                        col.sortDirection = "none";
                    }
                }
            };
            scope.colDefinitions.forEach(function (col, i) {
                if (AlarmSrv.sortCol) {
                    if (AlarmSrv.sortCol === col.field) {
                        scope.colDefinitions[i].sorted = true;
                        scope.colDefinitions[i].sortDirection = AlarmSrv.sortDir;
                        scope.sortBy(scope.colDefinitions[i], true);
                        resetSorting(scope.colDefinitions[i]);
                    }
                }
                else if (col.sorted)
                    scope.sortBy(col, true);
            });
            /* end of sorting methods */
            get_parent = function (child) {
                var parent;
                parent = void 0;
                if (child.parent_uid) {
                    for_each_branch(function (b) {
                        if (b.uid === child.parent_uid) {
                            return (parent = b);
                        }
                    });
                }
                return parent;
            };
            for_all_ancestors = function (child, fn) {
                var parent;
                parent = get_parent(child);
                if (parent != null) {
                    fn(parent);
                    return for_all_ancestors(parent, fn);
                }
            };
            expand_all_parents = function (child) {
                return for_all_ancestors(child, function (b) {
                    return (b.expanded = true);
                });
            };
            scope.tree_rows = [];
            on_treeData_change = function () {
                getExpandingProperty();
                var add_branch_to_list, root_branch, _i, _len, _ref, _results;
                for_each_branch(function (b, level) {
                    if (!b.uid) {
                        return (b.uid = "" + Math.random());
                    }
                });
                for_each_branch(function (b) {
                    var child, _i, _len, _ref, _results;
                    if (angular_1.isArray(b.children)) {
                        _ref = b.children;
                        _results = [];
                        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                            child = _ref[_i];
                            _results.push((child.parent_uid = b.uid));
                        }
                        return _results;
                    }
                });
                scope.tree_rows = [];
                for_each_branch(function (branch) {
                    var child, f;
                    if (branch.children) {
                        if (branch.children.length > 0) {
                            f = function (e) {
                                if (typeof e === "string") {
                                    return {
                                        label: e,
                                        children: [],
                                    };
                                }
                                else {
                                    return e;
                                }
                            };
                            return (branch.children = (function () {
                                var _i, _len, _ref, _results;
                                _ref = branch.children;
                                _results = [];
                                for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                                    child = _ref[_i];
                                    _results.push(f(child));
                                }
                                return _results;
                            })());
                        }
                    }
                    else {
                        return (branch.children = []);
                    }
                });
                add_branch_to_list = function (level, branch, visible) {
                    var child, child_visible, tree_icon, _i, _len, _ref, _results;
                    if (branch.expanded == null) {
                        branch.expanded = false;
                    }
                    if (!branch.children || branch.children.length === 0) {
                        tree_icon = attrs.iconLeaf;
                    }
                    else {
                        if (branch.expanded) {
                            tree_icon = attrs.iconCollapse;
                        }
                        else {
                            tree_icon = attrs.iconExpand;
                        }
                    }
                    branch.level = level;
                    scope.tree_rows.push({
                        level: level,
                        branch: branch,
                        label: branch[expandingProperty],
                        tree_icon: tree_icon,
                        visible: visible,
                    });
                    if (branch.children != null) {
                        _ref = branch.children;
                        _results = [];
                        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                            child = _ref[_i];
                            child_visible = visible && branch.expanded;
                            _results.push(add_branch_to_list(level + 1, child, child_visible));
                        }
                        return _results;
                    }
                };
                _ref = scope.treeData;
                _results = [];
                for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                    root_branch = _ref[_i];
                    _results.push(add_branch_to_list(1, root_branch, true));
                }
                return _results;
            };
            scope.$watch("treeData", on_treeData_change, true);
            if (attrs.initialSelection != null) {
                for_each_branch(function (b) {
                    if (b.label === attrs.initialSelection) {
                        return $timeout(function () {
                            return select_branch(b);
                        });
                    }
                });
            }
            n = scope.treeData.length;
            for_each_branch(function (b, level) {
                b.level = level;
                return (b.expanded = b.level < expand_level);
            });
            if (scope.treeControl != null) {
                if (angular_1.isObject(scope.treeControl)) {
                    tree = scope.treeControl;
                    tree.expand_all = function () {
                        return for_each_branch(function (b, level) {
                            return (b.expanded = true);
                        });
                    };
                    tree.collapse_all = function () {
                        return for_each_branch(function (b, level) {
                            return (b.expanded = false);
                        });
                    };
                    tree.get_first_branch = function () {
                        n = scope.treeData.length;
                        if (n > 0) {
                            return scope.treeData[0];
                        }
                    };
                    tree.select_first_branch = function () {
                        var b;
                        b = tree.get_first_branch();
                        return tree.select_branch(b);
                    };
                    tree.get_selected_branch = function () {
                        return selected_branch;
                    };
                    tree.get_parent_branch = function (b) {
                        return get_parent(b);
                    };
                    tree.select_branch = function (b) {
                        select_branch(b);
                        return b;
                    };
                    tree.get_children = function (b) {
                        return b.children;
                    };
                    tree.select_parent_branch = function (b) {
                        var p;
                        if (b == null) {
                            b = tree.get_selected_branch();
                        }
                        if (b != null) {
                            p = tree.get_parent_branch(b);
                            if (p != null) {
                                tree.select_branch(p);
                                return p;
                            }
                        }
                    };
                    tree.add_branch = function (parent, new_branch) {
                        if (parent != null) {
                            parent.children.push(new_branch);
                            parent.expanded = true;
                        }
                        else {
                            scope.treeData.push(new_branch);
                        }
                        return new_branch;
                    };
                    tree.add_root_branch = function (new_branch) {
                        tree.add_branch(null, new_branch);
                        return new_branch;
                    };
                    tree.expand_branch = function (b) {
                        if (b == null) {
                            b = tree.get_selected_branch();
                        }
                        if (b != null) {
                            b.expanded = true;
                            return b;
                        }
                    };
                    tree.collapse_branch = function (b) {
                        if (b == null) {
                            b = selected_branch;
                        }
                        if (b != null) {
                            b.expanded = false;
                            return b;
                        }
                    };
                    tree.get_siblings = function (b) {
                        var p, siblings;
                        if (b == null) {
                            b = selected_branch;
                        }
                        if (b != null) {
                            p = tree.get_parent_branch(b);
                            if (p) {
                                siblings = p.children;
                            }
                            else {
                                siblings = scope.treeData;
                            }
                            return siblings;
                        }
                    };
                    tree.get_next_sibling = function (b) {
                        var i, siblings;
                        if (b == null) {
                            b = selected_branch;
                        }
                        if (b != null) {
                            siblings = tree.get_siblings(b);
                            n = siblings.length;
                            i = siblings.indexOf(b);
                            if (i < n) {
                                return siblings[i + 1];
                            }
                        }
                    };
                    tree.get_prev_sibling = function (b) {
                        var i, siblings;
                        if (b == null) {
                            b = selected_branch;
                        }
                        siblings = tree.get_siblings(b);
                        n = siblings.length;
                        i = siblings.indexOf(b);
                        if (i > 0) {
                            return siblings[i - 1];
                        }
                    };
                    tree.select_next_sibling = function (b) {
                        var next;
                        if (b == null) {
                            b = selected_branch;
                        }
                        if (b != null) {
                            next = tree.get_next_sibling(b);
                            if (next != null) {
                                return tree.select_branch(next);
                            }
                        }
                    };
                    tree.select_prev_sibling = function (b) {
                        var prev;
                        if (b == null) {
                            b = selected_branch;
                        }
                        if (b != null) {
                            prev = tree.get_prev_sibling(b);
                            if (prev != null) {
                                return tree.select_branch(prev);
                            }
                        }
                    };
                    tree.get_first_child = function (b) {
                        var _ref;
                        if (b == null) {
                            b = selected_branch;
                        }
                        if (b != null) {
                            if (((_ref = b.children) != null ? _ref.length : void 0) > 0) {
                                return b.children[0];
                            }
                        }
                    };
                    tree.get_closest_ancestor_next_sibling = function (b) {
                        var next, parent;
                        next = tree.get_next_sibling(b);
                        if (next != null) {
                            return next;
                        }
                        else {
                            parent = tree.get_parent_branch(b);
                            return tree.get_closest_ancestor_next_sibling(parent);
                        }
                    };
                    tree.get_next_branch = function (b) {
                        var next;
                        if (b == null) {
                            b = selected_branch;
                        }
                        if (b != null) {
                            next = tree.get_first_child(b);
                            if (next != null) {
                                return next;
                            }
                            else {
                                next = tree.get_closest_ancestor_next_sibling(b);
                                return next;
                            }
                        }
                    };
                    tree.select_next_branch = function (b) {
                        var next;
                        if (b == null) {
                            b = selected_branch;
                        }
                        if (b != null) {
                            next = tree.get_next_branch(b);
                            if (next != null) {
                                tree.select_branch(next);
                                return next;
                            }
                        }
                    };
                    tree.last_descendant = function (b) {
                        var last_child;
                        if (b == null) {
                            debugger;
                        }
                        n = b.children.length;
                        if (n === 0) {
                            return b;
                        }
                        else {
                            last_child = b.children[n - 1];
                            return tree.last_descendant(last_child);
                        }
                    };
                    tree.get_prev_branch = function (b) {
                        var parent, prev_sibling;
                        if (b == null) {
                            b = selected_branch;
                        }
                        if (b != null) {
                            prev_sibling = tree.get_prev_sibling(b);
                            if (prev_sibling != null) {
                                return tree.last_descendant(prev_sibling);
                            }
                            else {
                                parent = tree.get_parent_branch(b);
                                return parent;
                            }
                        }
                    };
                    return (tree.select_prev_branch = function (b) {
                        var prev;
                        if (b == null) {
                            b = selected_branch;
                        }
                        if (b != null) {
                            prev = tree.get_prev_branch(b);
                            if (prev != null) {
                                tree.select_branch(prev);
                                return prev;
                            }
                        }
                    });
                }
            }
        },
    };
};


/***/ }),

/***/ "./app/view-menu/alarm/alarm-active/tree-grid/tree-grid.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var tree_grid_directive_1 = __webpack_require__("./app/view-menu/alarm/alarm-active/tree-grid/tree-grid.directive.ts");
var tree_grid_compile_directive_1 = __webpack_require__("./app/view-menu/alarm/alarm-active/tree-grid/tree-grid-compile.directive.ts");
var search_for_filter_1 = __webpack_require__("./app/view-menu/alarm/alarm-active/tree-grid/search-for.filter.ts");
angular_1.module("treeGridMod", [])
    .directive("compile", tree_grid_compile_directive_1.TreeGridCompileDirective)
    .directive("treeGrid", tree_grid_directive_1.TreeGridDirective)
    .filter("searchFor", search_for_filter_1.SearchForFilter);


/***/ }),

/***/ "./app/view-menu/alarm/alarm-active/tree-grid/tree-grid.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/alarm/alarm-active/tree-grid/tree-grid.template.html?3470296cd807481b698ad8802ecda0c5";

/***/ }),

/***/ "./app/view-menu/alarm/alarm-cfg/alarm-cfg.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var alarm_cfg_controller_1 = __webpack_require__("./app/view-menu/alarm/alarm-cfg/alarm-cfg.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/alarm/alarm-cfg/alarm-cfg.template.html");
exports.AlarmConfigComponent = {
    // scope: true,
    // restrict:"E",// E = Element, A = Attribute, C = Class, M = Comment
    templateUrl: templateUrl,
    controller: alarm_cfg_controller_1.AlarmConfigController,
};


/***/ }),

/***/ "./app/view-menu/alarm/alarm-cfg/alarm-cfg.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var AlarmConfigController = (function () {
    function AlarmConfigController($scope, $interval, fmeListSrv, alarmListSrv, userManagerSrv, CELL_TEMPLATES) {
        var _this = this;
        $scope.selectedRow = null;
        $scope.fmeList = fmeListSrv.getAllElements();
        $scope.select = {
            FME: ""
        };
        $scope.alarmCfgLoading = false;
        $scope.alarmDisplayCfgList = [];
        $scope.alarmCfgList = [];
        $scope.priorityList = [10, 9, 8, 7, 6, 5, 4, 3, 2, 1];
        // tree grid data
        $scope.filterString = "";
        $scope.alarmDisplayCfgTree = [];
        $scope.treeGrid = {
            colDefs: [
                {
                    field: "Enable",
                    displayName: "Enable/Disable",
                    sortable: true,
                    sortingType: "custom",
                    sortingFunc: function (a, b) {
                        return Number(a.Enable > b.Enable) - Number(b.Enable > a.Enable) * 1;
                    },
                    cellTemplate: CELL_TEMPLATES.enable,
                    cellTemplateScope: {
                        alarmEnable: function (enable) {
                            if (enable === true || enable === false) {
                                return enable ? "Enable" : "Disable";
                            }
                            return;
                        },
                        alarmOptions: [
                            {
                                label: "Enable",
                                value: true
                            },
                            {
                                label: "Disable",
                                value: false
                            }
                        ],
                    },
                },
                {
                    field: "Priority",
                    displayName: "Priority (1~4: Minor, 5~10: Major)",
                    sortable: true,
                    sortingType: "number",
                    cellTemplate: CELL_TEMPLATES.priority,
                    cellTemplateScope: {
                        priorityOptions: $scope.priorityList
                    }
                },
                {
                    field: "Raise_delay",
                    displayName: "Raise Delay (sec)",
                    sortable: true,
                    sortingType: "number",
                    cellTemplate: CELL_TEMPLATES.delay,
                },
                {
                    field: "Clear_delay",
                    displayName: "Clear Delay (sec)",
                    sortable: true,
                    sortingType: "number",
                    cellTemplate: CELL_TEMPLATES.delay,
                }
            ],
            expandOn: {
                field: "Name",
                sortable: true,
                filterable: true
            },
            treeControl: {
                getChangedClass: function (row) {
                    if (_isLeafNode(row)) {
                        return $scope.getCfgClass(row);
                    }
                    return;
                },
                isLeafNode: function (data) { return (_isLeafNode(data)); },
                isEditMode: function () { return ($scope.editMode); },
                addChangedRows: function (row) {
                    $scope.changeAlarmCfg(row, false);
                },
                changeFiltered: function () {
                    $scope.changeFilteredAlarmCfg();
                },
                totalAlarmCnt: 0,
                filteredAlarmCnt: 0,
                filteredCfg: {
                    Enable: undefined
                },
                ENABLE_OPTIONS: [
                    {
                        label: "Enable",
                        value: true
                    },
                    {
                        label: "Disable",
                        value: false
                    }
                ]
            },
            expandLevel: 1,
            MAX_LEVEL: 3 // max level to expand to
        };
        $scope.editMode = false;
        $scope.editing = false;
        $scope.alarmDisplayCfgTreeSave = [];
        var section = {
            program: [
                [],
                [],
                [],
                []
            ]
        };
        var processor = {
            section: [angular_1.copy(section), angular_1.copy(section),
                {
                    program: [
                        []
                    ]
                }]
        };
        var newCfg = {
            processor: [angular_1.copy(processor), angular_1.copy(processor), angular_1.copy(processor), angular_1.copy(processor)],
            system: [],
            empty: true
        };
        function setFirstElement() {
            var firstElement = $scope.fmeList.find(function (e) { return (e.state.indexOf('connected') === 0 || e.state.indexOf('sync') === 0); });
            if (firstElement) {
                $scope.select.FME = firstElement.ip;
                $scope.selectFME();
            }
        }
        var init = function () {
            setFirstElement();
            // alarmListSrv.updateAlarmCfgList();
            alarmListSrv.registerCallback({
                fn: _updateTree,
                scope: _this,
                // scope: alarmCfgCtrl,
                name: 'alarmCfgCtrl'
            });
        };
        var intervalId;
        $scope.$watch('select.FME', function (newValue, oldValue) {
            if (!newValue) {
                intervalId = $interval(setFirstElement, 500);
            }
            else {
                $interval.cancel(intervalId);
            }
        });
        $scope.selectFME = function () {
            if (!!$scope.select.FME) {
                _updateTree(true);
                if (!newCfg.empty) {
                    newCfg.system = [];
                    for (var processorIdx = 0; processorIdx < 4; processorIdx++) {
                        for (var sectionIdx = 0; sectionIdx < 3; sectionIdx++) {
                            var numProg = (sectionIdx === 2) ? 1 : 4;
                            for (var programIdx = 0; programIdx < numProg; programIdx++) {
                                newCfg.processor[processorIdx].section[sectionIdx].program[programIdx] = [];
                            }
                        }
                    }
                    newCfg.empty = true;
                }
            }
        };
        var _updateTree = function (clean) {
            if (clean === void 0) { clean = false; }
            // update $scope.alarmDisplayCfgTree from flat list
            if (clean) {
                // clear the tree and start fresh
                $scope.alarmDisplayCfgTree = [];
            }
            else {
                // update the tree with curent $scope.alarmCfgList
                $scope.alarmDisplayCfgTree.forEach(_cleanTree);
            }
            $scope.alarmCfgLoading = false;
            $scope.alarmCfgList = alarmListSrv.getCfgList($scope.select.FME);
            $scope.alarmDisplayCfgList = $scope.alarmCfgList;
            $scope.alarmDisplayCfgList
                .sort(function (a, b) {
                // sort all alarms by name by default
                var getLocationName = function (e) {
                    var tempLocation = e.Location.filter(function (e, idx) { return (idx < $scope.treeGrid.MAX_LEVEL); });
                    return (JSON.stringify(tempLocation) + e.Name).toLowerCase();
                };
                var A = getLocationName(a);
                var B = getLocationName(b);
                return (Number(A > B) - Number(B > A));
            })
                .forEach(function (alarm) {
                if (angular_1.isArray(alarm.Location) && alarm.Location.length > 0) {
                    // alarm has location array, add it to the right level
                    _addTreeNode($scope.alarmDisplayCfgTree, alarm, 0);
                }
                else {
                    // no location array, leave it at level 0
                    var found = $scope.alarmDisplayCfgTree.find(function (e) { return (e.ID === alarm.ID && angular_1.equals(e.Location, alarm.Location)); });
                    if (!found) {
                        $scope.alarmDisplayCfgTree.push(alarm);
                    }
                    else {
                        // update existing node
                        found.Enable = alarm.Enable;
                        found.Priority = alarm.Priority;
                        found.Raise_delay = alarm.Raise_delay;
                        found.Clear_delay = alarm.Clear_delay;
                    }
                }
            });
            _updateAlarmCnt();
        };
        var _cleanTree = function (node) {
            // traverse the tree and remove nodes not in alarmCfgList or empty nodes
            if (angular_1.isArray(node.children)) {
                for (var i = node.children.length - 1; i >= 0; i--) {
                    if (_isLeafNode(node.children[i])) {
                        var found = $scope.alarmCfgList.some(function (e) { return (e.ID === node.children[i].ID && angular_1.equals(e.Location, node.children[i].Location)); });
                        if (!found) {
                            // remove old leaf nodes
                            node.children.splice(i, 1);
                        }
                    }
                    else {
                        // clean next level
                        _cleanTree(node.children[i]);
                        if (node.children[i].children.length[0]) {
                            // remove empty parent nodes
                            node.children.splice(i, 1);
                        }
                    }
                }
            }
        };
        var _addTreeNode = function (parentArr, node, level) {
            // function to add objects defined by array to parentArr node
            var tempParent;
            if (!!node.Location && level < node.Location.length) {
                tempParent = parentArr.find(function (e) { return (e.Name === node.Location[level]); });
                if (!tempParent) {
                    // make new parentArr node if doesn't exist
                    parentArr.push({
                        Name: node.Location[level],
                        children: []
                    });
                    tempParent = parentArr.find(function (e) { return (e.Name === node.Location[level]); });
                }
                if (level === (node.Location.length - 1) || level === ($scope.treeGrid.MAX_LEVEL - 1)) {
                    // end of node, insert alarm into tempParent.children
                    if (angular_1.isArray(tempParent.children)) {
                        var found = tempParent.children.find(function (e) { return (e.ID === node.ID && angular_1.equals(e.Location, node.Location)); });
                        if (!found) {
                            tempParent.children.push(node);
                        }
                        else {
                            // update existing node
                            found.Enable = node.Enable;
                            found.Priority = node.Priority;
                            found.Raise_delay = node.Raise_delay;
                            found.Clear_delay = node.Clear_delay;
                        }
                    }
                    else {
                        tempParent.children = [node];
                    }
                }
                else {
                    // go 1 level deeper
                    _addTreeNode(tempParent.children, node, ++level);
                }
            }
        };
        var _isLeafNode = function (data) {
            return data.children.length == 0; // && !_isNodeModified(data);
        };
        var _resetNewCfg = function () {
            newCfg.system = [];
            for (var processorIdx = 0; processorIdx < 4; processorIdx++) {
                for (var sectionIdx = 0; sectionIdx < 3; sectionIdx++) {
                    var numProg = (sectionIdx === 2) ? 1 : 4;
                    for (var programIdx = 0; programIdx < numProg; programIdx++) {
                        newCfg.processor[processorIdx].section[sectionIdx].program[programIdx] = [];
                    }
                }
            }
            newCfg.empty = true;
        };
        $scope.alarmLevel = function (priority) {
            if (priority >= 5) {
                return "Major";
            }
            else {
                return "Minor";
            }
        };
        $scope.alarmEnable = function (Enable) {
            return (Enable === "1") ? "Enable" : "Disable";
        };
        $scope.loadingMessage = function () {
            //test
            return $scope.alarmCfgLoading;
        };
        $scope.fmeFilter = function (item) {
            if (!!item.state && (item.state == 'connected' || item.state.indexOf('sync') == 0)) {
                item.label = item.name.length > 0 ? item.name + " (" + item.ip + ")" : item.ip;
                return item;
            }
        };
        $scope.apply = function () {
            var error = false;
            if ($scope.editing) {
                if (!!$scope.select.FME) {
                    if (!newCfg.empty) {
                        var alarms = [];
                        for (var processorIdx = 0; processorIdx < 4; processorIdx++) {
                            for (var sectionIdx = 0; sectionIdx < 3; sectionIdx++) {
                                var numProg = (sectionIdx === 2) ? 1 : 4;
                                for (var programIdx = 0; programIdx < numProg; programIdx++) {
                                    newCfg.processor[processorIdx].section[sectionIdx].program[programIdx].forEach(function (alarm) {
                                        if (alarm.Raise_delay === undefined || alarm.Clear_delay === undefined ||
                                            alarm.Raise_delay < 0 || alarm.Raise_delay > 2147483647 ||
                                            alarm.Clear_delay < 0 || alarm.Clear_delay > 2147483647)
                                            error = true;
                                        alarms.push({
                                            "number": parseInt(alarm.ID, 10),
                                            "enable": alarm.Enable || false,
                                            "priority": parseInt(alarm.Priority, 10),
                                            "raiseDelay": alarm.Raise_delay,
                                            "clearDelay": alarm.Clear_delay,
                                            "location": alarm.Location
                                        });
                                    });
                                }
                            }
                        }
                        newCfg.system.forEach(function (alarm) {
                            if (alarm.Raise_delay === undefined || alarm.Clear_delay === undefined ||
                                alarm.Raise_delay < 0 || alarm.Raise_delay > 2147483647 ||
                                alarm.Clear_delay < 0 || alarm.Clear_delay > 2147483647)
                                error = true;
                            alarms.push({
                                "number": parseInt(alarm.ID, 10),
                                "enable": alarm.Enable || false,
                                "priority": parseInt(alarm.Priority, 10),
                                "raiseDelay": alarm.Raise_delay,
                                "clearDelay": alarm.Clear_delay,
                                "location": alarm.Location
                            });
                        });
                        alarmListSrv.UpdateAlarmCfg($scope.select.FME, alarms, error);
                        if (!error)
                            $scope.alarmCfgLoading = true;
                    }
                    if (!error)
                        _resetNewCfg();
                }
                if (!error) {
                    $scope.editing = false;
                    $scope.editMode = false;
                }
            }
            if (!error)
                _resetParentNodes();
        };
        $scope.cancel = function () {
            _resetNewCfg();
            $scope.editMode = false;
            $scope.editing = false;
            $scope.alarmDisplayCfgTree = angular_1.copy($scope.alarmDisplayCfgTreeSave);
            _resetParentNodes();
        };
        $scope.edit = function () {
            $scope.editMode = true;
            $scope.editing = true;
            $scope.alarmDisplayCfgTreeSave = angular_1.copy($scope.alarmDisplayCfgTree);
        };
        var _resetParentNodes = function (nodeArray) {
            if (!nodeArray) {
                // reset enable for all filtered
                delete $scope.treeGrid.treeControl.filteredCfg.Enable;
                nodeArray = $scope.alarmDisplayCfgTree;
            }
            // reset enable dropdown on all non-leaf nodes
            for (var i = nodeArray.length - 1; i >= 0; i--) {
                if (!_isLeafNode(nodeArray[i])) {
                    delete nodeArray[i].Enable;
                    // propagate 1 level down
                    if (nodeArray[i].level < $scope.treeGrid.MAX_LEVEL) {
                        _resetParentNodes(nodeArray[i].children);
                    }
                }
            }
        };
        var _updateAlarmCnt = function () {
            // update total and filtered alarm cnt
            $scope.treeGrid.treeControl.totalAlarmCnt = $scope.alarmCfgList.length;
            if ($scope.filterString.length < 3) {
                $scope.treeGrid.treeControl.filteredAlarmCnt = $scope.treeGrid.treeControl.totalAlarmCnt;
            }
            else {
                $scope.treeGrid.treeControl.filteredAlarmCnt = $scope.alarmCfgList.filter(function (e) {
                    var filterStringLow = $scope.filterString.toLowerCase();
                    // match expandable column first
                    if ($scope.treeGrid.expandOn.filterable &&
                        e[$scope.treeGrid.expandOn.field].toLowerCase().includes(filterStringLow)) {
                        return true;
                    }
                    // match any col marked filterable
                    $scope.treeGrid.colDefs.forEach(function (col) {
                        if (col.filterable && e[col.field].toLowerCase().includes(filterStringLow)) {
                            return true;
                        }
                    });
                    // no match
                    return false;
                }).length;
            }
        };
        $scope.resetParentEnable = function () {
            // reset parent nodes' config when filter string changes
            _updateAlarmCnt();
            if ($scope.editMode) {
                _resetParentNodes();
            }
        };
        var _stringFilter = function (str) {
            //filter to check str against alarm columns marked filterable (case-insensitive)
            var strLow = str.toLowerCase();
            return function (cfg) {
                if (strLow.length < 3 || !_isLeafNode(cfg)) {
                    return true;
                }
                if ($scope.treeGrid.expandOn.filterable &&
                    cfg[$scope.treeGrid.expandOn.field].toLowerCase().includes(strLow)) {
                    return true;
                }
                $scope.treeGrid.colDefs.forEach(function (col) {
                    if (col.filterable && cfg[col.field].toLowerCase().includes(strLow)) {
                        return true;
                    }
                });
                return false;
            };
        };
        $scope.changeFilteredAlarmCfg = function () {
            // change all filtered alarms
            if (typeof $scope.treeGrid.treeControl.filteredCfg !== 'undefined') {
                var tempCfg = angular_1.copy($scope.treeGrid.treeControl.filteredCfg);
                $scope.alarmDisplayCfgTree.filter(_stringFilter($scope.filterString))
                    .forEach(function (e) {
                    e.Enable = tempCfg.Enable;
                    $scope.changeAlarmCfg(e, false);
                });
                $scope.treeGrid.treeControl.filteredCfg = tempCfg;
            }
        };
        $scope.changeAlarmCfg = function (alarmCfg, resetParentCfg) {
            if (resetParentCfg === void 0) { resetParentCfg = true; }
            if (_isLeafNode(alarmCfg)) {
                // change single alarm
                _changeSingleAlarmCfg(alarmCfg);
            }
            else {
                // if not a leaf node, find all its decendants and change all at once
                var tempCfg = angular_1.copy(alarmCfg);
                var changeLeafNodes = function (nodes, cfg) {
                    nodes.filter(_stringFilter($scope.filterString))
                        .forEach(function (e) {
                        e.Enable = cfg.Enable;
                        if (_isLeafNode(e)) {
                            _changeSingleAlarmCfg(e);
                        }
                        else {
                            changeLeafNodes(e.children, cfg);
                        }
                    });
                };
                // reset all other parent nodes except the one being changed
                if (resetParentCfg) {
                    _resetParentNodes();
                    alarmCfg.Enable = tempCfg.Enable;
                }
                changeLeafNodes(alarmCfg.children, alarmCfg);
            }
        };
        var _changeSingleAlarmCfg = function (alarmCfg) {
            // Reverse Enable value until response from SNP received
            var location = alarmCfg.Location;
            if (location.length === 3) {
                var processorIdx = location[0].charCodeAt(location[0].length - 1) - 65;
                var sectionIdx = parseInt(location[1].slice(-1)) - 1;
                var programIdx = parseInt(location[2].slice(-1)) - 1;
                newCfg.processor[processorIdx].section[sectionIdx].program[programIdx][alarmCfg.ID] = angular_1.copy(alarmCfg);
                newCfg.empty = false;
            }
            else if (location.length === 2) {
                newCfg.system[alarmCfg.ID] = angular_1.copy(alarmCfg);
                newCfg.empty = false;
            }
        };
        $scope.initEnableValue = function (enable) {
            return enable;
        };
        $scope.initPriorityValue = function (priority) {
            return priority;
        };
        $scope.getCfgClass = function (alarmCfg) {
            // return correct color class for the alarmCfg
            if (alarmCfg.Raise_delay === undefined || alarmCfg.Clear_delay === undefined ||
                alarmCfg.Raise_delay < 0 || alarmCfg.Raise_delay > 2147483647 ||
                alarmCfg.Clear_delay < 0 || alarmCfg.Clear_delay > 2147483647)
                return {
                    alarmErrorColor: true
                };
            var location = alarmCfg.Location;
            var alarms;
            if (location.length === 3) {
                var processorIdx = location[0].charCodeAt(location[0].length - 1) - 65;
                var sectionIdx = parseInt(location[1].slice(-1)) - 1;
                var programIdx = parseInt(location[2].slice(-1)) - 1;
                alarms = newCfg.processor[processorIdx].section[sectionIdx].program[programIdx];
            }
            else if (location.length === 2) {
                alarms = newCfg.system;
            }
            if (alarms[alarmCfg.ID]) {
                return {
                    selected: true
                };
            }
            else {
                return {
                    alarmLogColor: true
                };
            }
        };
        $scope.IsAllowOper = function () {
            return userManagerSrv.IsAllowOper();
        };
        $scope.$on('$destroy', function () {
            alarmListSrv.unregisterCallback({
                fn: _updateTree,
                scope: _this,
                //   scope: alarmCfgCtrl,
                name: 'alarmCfgCtrl'
            });
        });
        init();
    }
    return AlarmConfigController;
}());
exports.AlarmConfigController = AlarmConfigController;


/***/ }),

/***/ "./app/view-menu/alarm/alarm-cfg/alarm-cfg.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var alarm_cfg_component_1 = __webpack_require__("./app/view-menu/alarm/alarm-cfg/alarm-cfg.component.ts");
exports.AlarmConfigModule = angular_1.module("AlarmConfigModule", [])
    .component("alarmCfg", alarm_cfg_component_1.AlarmConfigComponent)
    .value("CELL_TEMPLATES", {
    enable: '<span ng-if="!treeControl.isEditMode()">' +
        "{{cellTemplateScope.alarmEnable(row.branch[col.field])}}" +
        "</span>" +
        '<select ng-if="treeControl.isEditMode()"' +
        'ng-model="row.branch[col.field]"' +
        'ng-change="treeControl.addChangedRows(row.branch)"' +
        'ng-options="x.value as x.label for x in cellTemplateScope.alarmOptions">' +
        '<option ng-if="!treeControl.isLeafNode(row.branch)" value="" disabled>as-is</option>' +
        "</select>",
    priority: '<span ng-if="treeControl.isLeafNode(row.branch)">' +
        '<span ng-if="!treeControl.isEditMode()">' +
        "{{row.branch[col.field]}}" +
        "</span>" +
        '<select ng-if="treeControl.isEditMode()"' +
        'ng-model="row.branch[col.field]"' +
        'ng-change="treeControl.addChangedRows(row.branch)"' +
        'ng-options="x for x in cellTemplateScope.priorityOptions">' +
        "</select>" +
        "</span>",
    delay: '<span ng-if="treeControl.isLeafNode(row.branch)">' +
        '<span ng-if="!treeControl.isEditMode()">' +
        "{{row.branch[col.field]}}" +
        "</span>" +
        '<input ng-if="treeControl.isEditMode()" class="delay-input"' +
        'type="number" min="0" max="2147483647" step="1"' +
        'ng-model="row.branch[col.field]"' +
        'ng-change="treeControl.addChangedRows(row.branch)"' +
        "</span>",
});


/***/ }),

/***/ "./app/view-menu/alarm/alarm-cfg/alarm-cfg.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/alarm/alarm-cfg/alarm-cfg.template.html?55bae172ca7567d09e94fba2ae9c39b5";

/***/ }),

/***/ "./app/view-menu/alarm/alarm-log/alarm-log.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var alarm_log_controller_1 = __webpack_require__("./app/view-menu/alarm/alarm-log/alarm-log.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/alarm/alarm-log/alarm-log.template.html");
exports.AlarmLogComponent = {
    controller: alarm_log_controller_1.AlarmLogController,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/alarm/alarm-log/alarm-log.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {
Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var AlarmLogController = (function () {
    function AlarmLogController($scope, $window, $timeout, $q, fmeListSrv, alarmListSrv, userManagerSrv, commonUtils) {
        $scope.selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        $scope.search = {
            FME: ""
        };
        $scope.orderByField = "Time_Issued";
        $scope.reverseSort = "-";
        var w_adder = !$scope.selfHost ? 0 : 2;
        var SNP_COL_DEFS = [
            {
                field: "Time_Issued",
                displayName: "Time Issued",
                sort: "date",
                width: 15 + w_adder,
            },
            {
                field: "Location",
                displayName: "Location",
                width: 15 + w_adder,
            },
            {
                field: "Name",
                displayName: "Alarm",
                width: 15 + w_adder,
            },
            {
                field: "Reason",
                displayName: "Reason",
                width: 23 + w_adder,
            },
            {
                field: "Priority",
                displayName: "Priority",
                width: 6 + w_adder,
                style: {
                    "text-align": "left"
                },
            },
            {
                field: "Count",
                displayName: "Count",
                width: 6 + w_adder,
                style: {
                    "text-align": "left"
                },
            },
            {
                field: "Triggered",
                displayName: "Raise",
                width: 6 + w_adder,
                style: {
                    "text-align": "left"
                },
            },
        ];
        if (!$scope.selfHost)
            SNP_COL_DEFS.unshift({
                field: "FME",
                displayName: "Element",
                width: 14,
            });
        $scope.col_defs = SNP_COL_DEFS;
        var _updateLog = function () {
            alarmListSrv.refreshAlarmLogs().finally(function () {
                $scope.alarmLogList = alarmListSrv.allAlarmLogs();
            });
            $scope.fmeList = alarmListSrv.alarmLogFMEList();
            _resetSearch();
        };
        var _resetSearch = function () {
            // use jQuery as a workaround to reset FME selector in st-table
            var tempModel = $("[st-search='FME']");
            if (angular_1.isDefined(tempModel[0])) {
                tempModel.val("").trigger("input");
                $scope.search.FME = "";
            }
        };
        $scope.alarmLogColor = function (alarmLogInfo) {
            if (alarmLogInfo.Triggered === "Yes") {
                if (alarmLogInfo.Priority >= 5) {
                    return {
                        alarmLogRedColor: true
                    };
                }
                else if (alarmLogInfo.Priority >= 1 && alarmLogInfo.Priority <= 4) {
                    return {
                        alarmLogYellowColor: true
                    };
                }
            }
            return {
                alarmLogColor: true
            };
        };
        $scope.getFmeName = function (fme_ip) {
            var fme_name = fme_ip;
            if (!!fme_ip) {
                fme_name = !!fmeListSrv.getElement(fme_ip) &&
                    !!fmeListSrv.getElement(fme_ip).name ?
                    fmeListSrv.getElement(fme_ip).name + " (" + fme_ip + ")" :
                    fme_name;
            }
            return fme_name;
        };
        $scope.refreshAlarmLog = function () {
            _updateLog();
        };
        $scope.exportAlarmLog = function () {
            alarmListSrv.generateAlarmLogFile();
        };
        $scope.clearAlarmLog = function () {
            var fme_ip = !!$scope.search && !!$scope.search.FME ? $scope.search.FME : "";
            alarmListSrv.rmvAlarmLog(fme_ip).finally(_updateLog);
        };
        $scope.IsAllowOper = function () {
            return userManagerSrv.IsAllowOper();
        };
        _updateLog();
        $timeout(function () {
            var tempModel = $("[st-search='FME']");
            tempModel.val("").trigger("input");
            $scope.search.FME = "";
        }, 10);
    }
    return AlarmLogController;
}());
exports.AlarmLogController = AlarmLogController;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__("./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./app/view-menu/alarm/alarm-log/alarm-log.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
__webpack_require__("./node_modules/angular-smart-table/index.js");
// ui_fmm/public/packages/uifmm/app/external/ui-bootstrap-2.1.2/ui-bootstrap-tpls-2.1.2.js:      $scope.selectPage = function(page, evt) {
// ui_fmm/public/packages/uifmm/app/external/smart-table/smart-table.js
// FMM]$ git --no-pager grep "selectPage =" $(git rev-list --all)
__webpack_require__("./app/view-menu/alarm/alarm-log/pagination/pagination.module.ts");
var alarm_log_component_1 = __webpack_require__("./app/view-menu/alarm/alarm-log/alarm-log.component.ts");
var st_ratio_directive_1 = __webpack_require__("./app/view-menu/alarm/alarm-log/st-ratio.directive.ts");
exports.AlarmLogModule = angular_1.module("AlarmLogModule", [
    "smart-table",
    "PaginationMod",
])
    .component("alarmLog", alarm_log_component_1.AlarmLogComponent)
    .directive("stRatio", st_ratio_directive_1.StRatioDirective);


/***/ }),

/***/ "./app/view-menu/alarm/alarm-log/alarm-log.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/alarm/alarm-log/alarm-log.template.html?fa7a0a80346983ea6c629e02af3688c2";

/***/ }),

/***/ "./app/view-menu/alarm/alarm-log/pagination/page-select.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.PageSelectDirective = function () {
    return {
        restrict: 'E',
        template: '<input type="text" class="select-page" ng-model="inputPage" ng-change="selectPage(inputPage)">',
        link: function (scope, element, attrs) {
            scope.$watch('currentPage', function (c) {
                scope.inputPage = c;
            });
        }
    };
};


/***/ }),

/***/ "./app/view-menu/alarm/alarm-log/pagination/pagination.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var templateUrl = __webpack_require__("./app/view-menu/alarm/alarm-log/pagination/pagination.template.html");
exports.PaginationDirective = function () {
    return {
        restrict: 'E',
        templateUrl: templateUrl,
    };
};


/***/ }),

/***/ "./app/view-menu/alarm/alarm-log/pagination/pagination.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var page_select_directive_1 = __webpack_require__("./app/view-menu/alarm/alarm-log/pagination/page-select.directive.ts");
var pagination_directive_1 = __webpack_require__("./app/view-menu/alarm/alarm-log/pagination/pagination.directive.ts");
angular_1.module("PaginationMod", [])
    .directive("pageSelect", page_select_directive_1.PageSelectDirective)
    .directive("pagination", pagination_directive_1.PaginationDirective); // NOT WORKED BEFORE


/***/ }),

/***/ "./app/view-menu/alarm/alarm-log/pagination/pagination.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/alarm/alarm-log/pagination/pagination.template.html?58c6b700e7f10ef3735d3a71f0e7abd2";

/***/ }),

/***/ "./app/view-menu/alarm/alarm-log/st-ratio.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.StRatioDirective = function () {
    return {
        link: function (scope, element, attr) {
            var ratio = +attr.stRatio;
            element.css("width", ratio + "%");
        },
    };
};


/***/ }),

/***/ "./app/view-menu/alarm/alarm-overlay/active-alarms/active-alarms.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var active_alarms_controller_1 = __webpack_require__("./app/view-menu/alarm/alarm-overlay/active-alarms/active-alarms.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/alarm/alarm-overlay/active-alarms/active-alarms.template.html");
exports.AlarmAlarmsComponent = {
    templateUrl: templateUrl,
    controller: active_alarms_controller_1.ActiveAlarmsController,
    bindings: {
        onResize: '&'
    }
};


/***/ }),

/***/ "./app/view-menu/alarm/alarm-overlay/active-alarms/active-alarms.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function($) {
Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var ActiveAlarmsController = (function () {
    function ActiveAlarmsController($scope, $timeout) {
        var _this = this;
        this.$scope = $scope;
        this.$timeout = $timeout;
        this.togglePanel = function () {
            var vm = _this;
            var height = $('#activeAlarmPage').height();
            if (height > angular_1.element(document).height() * 0.15 + 1) {
                $('#activeAlarmPage').css('height', '15%');
            }
            else {
                $('#activeAlarmPage').css('height', '70%');
            }
            _this.$timeout(function () { return vm.onResize(); }, 310);
        };
        this.toggleElementsGroup = function () {
            _this.$scope.$broadcast('regroup-alarms');
        };
        var vm = this;
        this.$scope.$on("angular-resizable.resizing", function (event, args) {
            vm.onResize();
        });
        this.$timeout(function () { return vm.onResize(); });
    }
    return ActiveAlarmsController;
}());
exports.ActiveAlarmsController = ActiveAlarmsController;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__("./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./app/view-menu/alarm/alarm-overlay/active-alarms/active-alarms.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/alarm/alarm-overlay/active-alarms/active-alarms.template.html?925ac0d0300540a88c87f6b80b10235b";

/***/ }),

/***/ "./app/view-menu/alarm/alarm-overlay/alarm-overlay.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var alarm_overlay_controller_1 = __webpack_require__("./app/view-menu/alarm/alarm-overlay/alarm-overlay.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/alarm/alarm-overlay/alarm-overlay.template.html");
exports.AlarmOverlayComponent = {
    templateUrl: templateUrl,
    controller: alarm_overlay_controller_1.AlarmOverlayController
};


/***/ }),

/***/ "./app/view-menu/alarm/alarm-overlay/alarm-overlay.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var $ = __webpack_require__("./node_modules/jquery/dist/jquery.js"); // TDL: replace
var AlarmOverlayController = (function () {
    function AlarmOverlayController($route, $rootScope, commonUtils) {
        var _this = this;
        this.$route = $route;
        this.$rootScope = $rootScope;
        this.commonUtils = commonUtils;
        this.showAlarmOverlay = false;
        this.resizePanel = function () {
            _this.commonUtils.resizeWindow(_this.showAlarmOverlay);
        };
        var vm = this;
        var _getAlarmOverlay = function () {
            vm.showAlarmOverlay = !!$route.current.$$route ? $route.current.$$route.showAlarmOverlay || false : false;
        };
        $rootScope.$on("$routeChangeSuccess", function (event, next, current) {
            _getAlarmOverlay();
            vm.resizePanel();
        });
        $(window).resize(this.resizePanel);
        _getAlarmOverlay();
    }
    AlarmOverlayController.$inject = ['$route', '$rootScope', 'commonUtils'];
    return AlarmOverlayController;
}());
exports.AlarmOverlayController = AlarmOverlayController;


/***/ }),

/***/ "./app/view-menu/alarm/alarm-overlay/alarm-overlay.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/alarm/alarm-overlay/alarm-overlay.template.html?46862702edc6afb3fa237b992b80fd9e";

/***/ }),

/***/ "./app/view-menu/alarm/alarm-overlay/resize-option.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
__webpack_require__("./node_modules/angular-resizable/angular-resizable.min.js");
__webpack_require__("./node_modules/angular-resizable/angular-resizable.min.css");
exports.ResizeOptionModule = angular_1.module("ResizeOptionModule", [
    "angularResizable",
]);


/***/ }),

/***/ "./app/view-menu/alarm/alarm.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var resize_option_module_1 = __webpack_require__("./app/view-menu/alarm/alarm-overlay/resize-option.module.ts");
var alarm_log_module_1 = __webpack_require__("./app/view-menu/alarm/alarm-log/alarm-log.module.ts");
var alarm_cfg_module_1 = __webpack_require__("./app/view-menu/alarm/alarm-cfg/alarm-cfg.module.ts");
var alarm_active_module_1 = __webpack_require__("./app/view-menu/alarm/alarm-active/alarm-active.module.ts");
var alarm_list_module_1 = __webpack_require__("./app/view-menu/alarm/services/alarm-list/alarm-list.module.ts");
var alarm_service_1 = __webpack_require__("./app/view-menu/alarm/alarm.service.ts");
var alarm_overlay_component_1 = __webpack_require__("./app/view-menu/alarm/alarm-overlay/alarm-overlay.component.ts");
var active_alarms_component_1 = __webpack_require__("./app/view-menu/alarm/alarm-overlay/active-alarms/active-alarms.component.ts");
exports.AlarmModule = angular_1.module("AlarmModule", [
    alarm_list_module_1.AlarmListModule.name,
    alarm_active_module_1.AlarmActiveModule.name,
    alarm_log_module_1.AlarmLogModule.name,
    alarm_cfg_module_1.AlarmConfigModule.name,
    resize_option_module_1.ResizeOptionModule.name,
])
    .factory("AlarmSrv", alarm_service_1.AlarmService)
    .component("alarmOverlay", alarm_overlay_component_1.AlarmOverlayComponent)
    .component("activeAlarms", active_alarms_component_1.AlarmAlarmsComponent);


/***/ }),

/***/ "./app/view-menu/alarm/alarm.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.AlarmService = function () {
    return {
        branches: {},
        grouped: false,
        sortCol: null,
        sortDir: "",
    };
};


/***/ }),

/***/ "./app/view-menu/alarm/services/alarm-list/alarm-list.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var alarm_list_service_1 = __webpack_require__("./app/view-menu/alarm/services/alarm-list/alarm-list.service.ts");
exports.AlarmListModule = angular_1.module("AlarmListModule", [])
    .factory("alarmListSrv", alarm_list_service_1.AlarmListService);


/***/ }),

/***/ "./app/view-menu/alarm/services/alarm-list/alarm-list.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular = __webpack_require__("./node_modules/angular/index.js");
var AlarmListService = (function () {
    function AlarmListService($http, $filter, $q, fmeListSrv, requestStatusSrv, commonUtils, REST_ENDPOINT) {
        var myFactory = {};
        var alarmLogList = [];
        var alarmMap = [];
        var alarmMapFlaten = [];
        var alarmCountMsg = "";
        var alarmsCfgList = {}; // alarm config hashmap
        var alarmsCfgMap = {}; // alarm configuration map for each element
        var alarmLogFMEList = [];
        var sortCriteria = {
            field: "Time_Issued",
            sortingType: "date",
            sortDirection: "desc",
        };
        var selfHost = commonUtils.smmParam("SMM_SELF_HOST", "false") === "true";
        var alarmCfgCallbacks = []; // array for callbacks when alarmCfg is updated
        function getActiveAlarms(response) {
            var parsedResponse = response;
            var newCount = 0;
            // function fo find element in parsedResponce
            var _elementFound = function (element) {
                return parsedResponse.some(function (e) { return e.fme_ip_address === element.FME; });
            };
            // function to find alarm in parsedResponce
            var _alarmFound = function (oldAlarm) {
                return parsedResponse.some(function (e) {
                    return e.id === oldAlarm.ID &&
                        e.fme_ip_address === oldAlarm.FME &&
                        e.object_id.toUpperCase() === oldAlarm.ObjectID.toUpperCase() &&
                        (!e.location || e.location == oldAlarm.Location);
                });
            };
            // function to insert new element in alarmMap using parsed alarm
            var _insertElement = function (parsedAlarm) {
                var tempElement = {
                    FME: parsedAlarm.fme_ip_address,
                    FMELabel: getFmeName(parsedAlarm.fme_ip_address),
                    Name: "",
                    children: [],
                };
                alarmMap.push(tempElement);
                newCount++;
            };
            // function to insert/update alarm in alarmMap
            var _insertAlarm = function (element, alarm, alarmProperties) {
                var tempAlarm = {
                    FME: alarm.fme_ip_address,
                    FMELabel: getFmeName(alarm.fme_ip_address),
                    Name: alarmProperties.Name,
                    Time_Issued: $filter("date")(new Date(alarm.time_stamp), "MM/dd/yyyy hh:mm:ss a"),
                    Description: alarmProperties.Description,
                    Reason: alarm.reason,
                    Priority: alarmProperties.Priority,
                    ObjectID: alarm.object_id,
                    ID: alarm.id,
                    obj_name: fmeListSrv.getObjectName(alarm.fme_ip_address, alarm.object_id),
                    obj_type: fmeListSrv.getObjectType(alarm.object_id),
                    Location: angular.isDefined(alarm.location) ? alarm.location : "",
                };
                var alarmFound = element.children.find(function (oldAlarm) {
                    return oldAlarm.ID === tempAlarm.ID &&
                        oldAlarm.ObjectID.toUpperCase() ===
                            tempAlarm.ObjectID.toUpperCase() &&
                        oldAlarm.Location === tempAlarm.Location;
                });
                if (!alarmFound) {
                    // remove old alarms
                    element.children.push(tempAlarm);
                    newCount++;
                }
                else if (alarmFound.Time_Issued !== tempAlarm.Time_Issued ||
                    alarmFound.Priority !== tempAlarm.Priority ||
                    alarmFound.FMELabel !== tempAlarm.FMELabel) {
                    // update alarm if needed
                    delete alarmFound.uid;
                    delete alarmFound.parent_uid;
                    angular.copy(tempAlarm, alarmFound);
                    newCount++;
                }
            };
            if (!angular.isArray(parsedResponse)) {
                // only proceed if parsedResponse is an array
                console.log("getActiveAlarms: parsedResponse not an array");
                return;
            }
            if (fmeListSrv.getDbg()) {
                console.log("getActiveAlarms", parsedResponse);
            }
            // go through the alarms and look for elements with alarm ID > 9000
            var elementToSuppress = parsedResponse
                .filter(function (alarm) { return alarm.id >= 9000; })
                .reduce(function (elementList, alarm) {
                if (elementList.indexOf(alarm.fme_ip_address) === -1) {
                    elementList.push(alarm.fme_ip_address);
                }
                return elementList;
            }, []);
            // if element needs to be supressed, remove alarms with ID < 9000
            if (elementToSuppress.length > 0) {
                parsedResponse = parsedResponse.filter(function (alarm) {
                    if (elementToSuppress.indexOf(alarm.fme_ip_address) !== -1 &&
                        alarm.id < 9000) {
                        newCount++;
                        return false;
                    }
                    return true;
                });
            }
            // remove unused elements
            for (var i = alarmMap.length - 1; i >= 0; i--) {
                if (!_elementFound(alarmMap[i])) {
                    alarmMap.splice(i, 1);
                    newCount++;
                }
                else {
                    // make sure element name is up to date
                    alarmMap[i].FMELabel = getFmeName(alarmMap[i].FME);
                }
            }
            //remove cleared alarms under each element and update counts
            alarmMap.forEach(function (e) {
                for (var i = e.children.length - 1; i >= 0; i--) {
                    if (!_alarmFound(e.children[i])) {
                        e.children.splice(i, 1);
                        newCount++;
                    }
                }
            });
            // go through response and map them into alarmMap
            parsedResponse.forEach(function (alarm) {
                var alarmProperties = getAlarmProperties(alarm.fme_ip_address, alarm.id, alarm.location);
                if (alarmProperties.Name !== "") {
                    var tempElement = alarmMap.find(function (e) { return e.FME === alarm.fme_ip_address; });
                    if (!tempElement) {
                        // insert new element into alarmMap
                        _insertElement(alarm);
                        tempElement = alarmMap.find(function (e) { return e.FME === alarm.fme_ip_address; });
                    }
                    // update alarmMap with this alarm
                    _insertAlarm(tempElement, alarm, alarmProperties);
                }
            });
            if (newCount > 0) {
                // update the major and minor alarm counts
                var majorTotal_1 = 0, minorTotal_1 = 0;
                alarmMap.forEach(function (e) {
                    var majorCount = 0, minorCount = 0;
                    e.children.forEach(function (child) {
                        child.Priority >= 5 ? majorCount++ : minorCount++;
                    });
                    e.Name = "{ " + majorCount + " Major, " + minorCount + " Minor }";
                    majorTotal_1 += majorCount;
                    minorTotal_1 += minorCount;
                });
                // resort alarm list when there is new alarms added
                for (var i = 0; i < alarmMap.length; i++) {
                    alarmMap[i].children.sort(_sortAlarm);
                }
                alarmCountMsg =
                    "{ " + majorTotal_1 + " Major, " + minorTotal_1 + " Minor }";
                // update flat list
                angular.copy(alarmMap.reduce(function (a, b) {
                    return a.concat(b.children);
                }, []), alarmMapFlaten);
            }
        }
        var _sortAlarm = function (a, b) {
            var direction = sortCriteria.sortDirection == "asc" ? 1 : -1;
            var key = function (x) {
                return !x[sortCriteria.field] ?
                    "" :
                    x[sortCriteria.field].toString().toLowerCase();
            };
            switch (sortCriteria.sortingType) {
                case "date":
                    key = function (x) {
                        return new Date(x[sortCriteria.field]);
                    };
                    break;
                case "number":
                    key = function (x) {
                        return parseFloat(x[sortCriteria.field]);
                    };
                    break;
            }
            var aD = key(a);
            var bD = key(b);
            return direction * (Number(aD > bD) - Number(bD > aD));
        };
        function getFmeName(fme_ip) {
            var tempFme;
            if (fme_ip != "") {
                tempFme = fmeListSrv.getElement(fme_ip);
            }
            if (angular.isDefined(tempFme)) {
                return (tempFme.guiLabel +
                    (tempFme.guiSecondaryLabel ? " " + tempFme.guiSecondaryLabel : ""));
            }
            else {
                return fme_ip;
            }
        }
        function getAlarmLogList() {
            var deferred = $q.defer();
            $http
                .get(REST_ENDPOINT.URI + "elements/alarm_logs/csv", {
                IsExport: true
            }, {
                headers: {
                    "Content-Type": "text/csv;charset=utf8"
                },
            })
                .then(function (response) {
                var alarmLog;
                var parsedResponse = [];
                var allAlarmLogs = response.data.split(/\r\n|\n/);
                var headers = splitStringWithComma(allAlarmLogs[0]);
                for (var i = 1; i < allAlarmLogs.length; i++) {
                    if (allAlarmLogs[i].length > 0) {
                        var data = splitStringWithComma(allAlarmLogs[i]);
                        if (data.length === headers.length) {
                            var alarmProperties = !!data[4] ?
                                getAlarmProperties(data[3], data[5], data[4]) :
                                getAlarmProperties(data[3], data[5]);
                            if (alarmProperties.Name === "") {
                                continue;
                            }
                            parsedResponse.push({
                                FME: data[3],
                                Name: alarmProperties.Name,
                                ID: data[5],
                                Time_Issued: new Date(data[6]),
                                Reason: data[7],
                                Object_Type: data[0],
                                Object_ID: data[2],
                                // Priority: parseInt(alarmProperties.Priority, 10),
                                // Count: parseInt(alarmProperties.Count, 10),
                                Priority: Number(alarmProperties.Priority),
                                Count: Number(alarmProperties.Count),
                                Triggered: data[1] === "true" ? "Yes" : "No",
                                obj_name: fmeListSrv.getObjectName(data[3], data[2]),
                                obj_type: fmeListSrv.getObjectType(data[2]),
                                Location: data[4],
                            });
                        }
                    }
                }
                // SNP-6374 sort alarm log in time desc order
                alarmLogList = parsedResponse;
                getAlarmLogFMEList();
                deferred.resolve();
            }, function (response) {
                if (fmeListSrv.getDbg()) {
                    console.log("updateAlarmLogList error:" + response);
                }
            });
            return deferred.promise;
        }
        function refreshAlarmConfigMap(parsedConfig) {
            // clear alarmCfgMap
            alarmsCfgList = {};
            alarmsCfgMap = {};
            if (parsedConfig.length > 0) {
                for (var i = 0; i < parsedConfig.length; i++) {
                    var alarmCfg = parsedConfig[i];
                    // create alarmCfg hashmap for managed elements
                    var key = alarmCfg.fme_ip_address + "_" + alarmCfg.id;
                    if (!!alarmCfg.location) {
                        try {
                            alarmCfg.location = JSON.parse(alarmCfg.location);
                        }
                        catch (e) {
                            alarmCfg.location = [];
                        }
                        alarmCfg.location.forEach(function (e, idx, arr) {
                            if (idx === 0) {
                                key += "_";
                            }
                            else {
                                key += " ";
                            }
                            key += e;
                        });
                    }
                    alarmsCfgList[key] = alarmCfg;
                    var tempAlarmCfg = {
                        ID: parseInt(alarmCfg.id, 10),
                        FME: alarmCfg.fme_ip_address,
                        Name: alarmCfg.identifier,
                        Description: alarmCfg.description,
                        Priority: parseInt(alarmCfg.priority, 10),
                        Enable: alarmCfg.enable,
                        Raise_delay: parseInt(alarmCfg.raiseDelay, 10),
                        Clear_delay: parseInt(alarmCfg.clearDelay, 10),
                        Count: parseInt(alarmCfg.count, 10),
                        Location: []
                    };
                    // set alarm location to empty array if not set
                    if (angular.isArray(alarmCfg.location)) {
                        tempAlarmCfg.Location = alarmCfg.location;
                    }
                    // add element to alarmsCfgMap if it doesn't exist
                    if (!alarmsCfgMap[alarmCfg.fme_ip_address]) {
                        alarmsCfgMap[alarmCfg.fme_ip_address] = {
                            FME: alarmCfg.fme_ip_address,
                            children: [],
                        };
                    }
                    // assume all the temp alarms are unique and push into element in alarmCfgMap
                    alarmsCfgMap[alarmCfg.fme_ip_address].children.push(tempAlarmCfg);
                }
            }
            runExternalCallbacks();
        }
        function splitStringWithComma(splitStr) {
            var newstr = "";
            var splitList = [];
            var isSplice = false;
            var list = splitStr.split(",");
            for (var i = 0; i < list.length; i++) {
                var str = list[i];
                if (!!str && str.length > 0 && str.indexOf('"') > -1) {
                    var firstchar = str.charAt(0);
                    var lastchar = "";
                    if (str.length > 0) {
                        lastchar = str.charAt(str.length - 1);
                    }
                    if (firstchar === '"' && lastchar !== '"') {
                        isSplice = true;
                    }
                    if (lastchar === '"') {
                        if (!isSplice) {
                            newstr += str.substr(0, str.length - 1);
                        }
                        else {
                            newstr = newstr + "," + str.substr(0, str.length - 1);
                        }
                        isSplice = false;
                    }
                }
                else {
                    if (!newstr && newstr.length === 0) {
                        newstr += str;
                    }
                }
                if (isSplice) {
                    if (!newstr && newstr.length === 0) {
                        newstr += str;
                    }
                    else {
                        newstr = newstr + "," + str;
                    }
                }
                else {
                    splitList.push(newstr.replace('"', "").trim());
                    newstr = "";
                }
            }
            return splitList;
        }
        function getAlarmObejct(objectID) {
            var object = "";
            var fmeList = fmeListSrv.getAllElements();
            for (var fme = 0; fme < fmeList.length; fme++) {
                if (fmeList[fme].state === "connected" &&
                    fmeList[fme].inputs !== undefined &&
                    fmeList[fme].linear !== undefined &&
                    fmeList[fme].muxGroup !== undefined &&
                    fmeList[fme].muxService !== undefined) {
                    for (var i = 0; i < fmeList[fme].inputs.length; i++) {
                        if (fmeList[fme].inputs[i].object_ID.toUpperCase() ===
                            objectID.toUpperCase()) {
                            object =
                                fmeList[fme].inputs[i].type + "-" + fmeList[fme].inputs[i].name;
                            return object;
                        }
                    }
                    for (var i = 0; i < fmeList[fme].linear.length; i++) {
                        if (fmeList[fme].linear[i].object_ID.toUpperCase() ===
                            objectID.toUpperCase()) {
                            object =
                                fmeList[fme].linear[i].type + "-" + fmeList[fme].linear[i].name;
                            return object;
                        }
                    }
                    for (var i = 0; i < fmeList[fme].muxGroup.length; i++) {
                        if (fmeList[fme].muxGroup[i].object_ID.toUpperCase() ===
                            objectID.toUpperCase()) {
                            object =
                                fmeList[fme].muxGroup[i].type +
                                    "-" +
                                    fmeList[fme].muxGroup[i].name;
                            return object;
                        }
                    }
                    for (var i = 0; i < fmeList[fme].muxService.length; i++) {
                        if (fmeList[fme].muxService[i].object_ID.toUpperCase() ===
                            objectID.toUpperCase()) {
                            object =
                                fmeList[fme].muxService[i].type +
                                    "-" +
                                    fmeList[fme].muxService[i].name;
                            return object;
                        }
                    }
                }
            }
            return object;
        }
        function getAlarmProperties(fme, id, location, fullProperties) {
            if (location === void 0) { location = ""; }
            if (fullProperties === void 0) { fullProperties = false; }
            var alarmP = {
                Name: "",
                Priority: -1,
                Description: "",
                Count: -1,
                Raise_delay: 0,
                Clear_delay: 0,
                Location: ""
            };
            // generate key for alarmCfgMap
            var key = fme + "_" + id;
            if (location.length > 0) {
                key += "_" + location;
            }
            if (!!alarmsCfgList[key]) {
                alarmP.Name = alarmsCfgList[key].identifier;
                alarmP.Priority = alarmsCfgList[key].priority;
                alarmP.Description = alarmsCfgList[key].description;
                alarmP.Count = alarmsCfgList[key].count;
                if (fullProperties) {
                    alarmP.Raise_delay = alarmsCfgList[key].raiseDelay;
                    alarmP.Clear_delay = alarmsCfgList[key].clearDelay;
                    alarmP.Location = alarmsCfgList[key].location;
                }
                return alarmP;
            }
            return alarmP;
        }
        myFactory.allAlarms = function () {
            return alarmMap;
        };
        myFactory.allAlarmsFlaten = function () {
            return {
                alarms: alarmMapFlaten,
                count: alarmCountMsg
            };
        };
        myFactory.hasAlarm = function (fme_ip, threshold, object_locations) {
            if (threshold === void 0) { threshold = 1; }
            if (object_locations === void 0) { object_locations = []; }
            // returns whether or not the specified element has alarm above threshold
            // optional: check against list of object_locations
            var found = false;
            var fme = alarmMap.find(function (element) { return element.FME === fme_ip; });
            if (!!fme) {
                found = fme.children.some(function (child) {
                    if (parseInt(child.Priority, 10) >= threshold) {
                        if (object_locations.length === 0) {
                            return true;
                        }
                        else {
                            return object_locations.some(function (e) { return e === child.Location; });
                        }
                    }
                    return false;
                });
            }
            return found;
        };
        myFactory.allAlarmLogs = function () {
            return alarmLogList;
        };
        myFactory.refreshAlarmLogs = function () {
            return getAlarmLogList();
        };
        var prep = function (s) { return s.replace('"', "'"); };
        myFactory.generateAlarmLogFile = function () {
            var alarmLogCsv = "";
            if (!selfHost)
                alarmLogCsv += "Element,";
            alarmLogCsv += '"Object ID","Location",';
            alarmLogCsv +=
                '"Time Issued","Alarm","Reason","Priority","Count","Raise"';
            alarmLogCsv += "\r\n";
            for (var i = 0; i < alarmLogList.length; i++) {
                if (!selfHost)
                    alarmLogCsv += "\"" + prep(alarmLogList[i].FME + "") + "\",";
                alarmLogCsv += "\"" + prep(alarmLogList[i].Object_ID + "") + "\",\"" + prep(alarmLogList[i].Location + "") + "\",";
                alarmLogCsv += "\"" + prep(alarmLogList[i].Time_Issued + "") + "\",\"" + prep(alarmLogList[i].Name + "") + "\",\"" + prep(alarmLogList[i].Reason + "") + "\",";
                alarmLogCsv += "\"" + prep(alarmLogList[i].Priority + "") + "\",\"" + prep(alarmLogList[i].Count + "") + "\",\"" + prep(alarmLogList[i].Triggered + "") + "\"";
                alarmLogCsv += "\r\n";
            }
            var link = document.createElement("a");
            var blob = new Blob([alarmLogCsv], {
                type: "text/csv"
            });
            link.style.display = "none";
            link.setAttribute("href", window.URL.createObjectURL(blob));
            link.download = "alarmLog.csv";
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        };
        function getAlarmLogFMEList() {
            angular.copy(Array.from(new Set(alarmLogList.map(function (x) {
                return x.FME;
            }))), alarmLogFMEList);
        }
        myFactory.alarmLogFMEList = function () {
            return alarmLogFMEList;
        };
        myFactory.rmvAlarmLog = function (fme_ip) {
            return $q(function (resolve, reject) {
                var del_url = fme_ip ?
                    REST_ENDPOINT.URI + "elements/alarm_logs/" + fme_ip :
                    REST_ENDPOINT.URI + "elements/alarm_logs/delAll";
                $http
                    .delete(del_url, {}, {
                    headers: {
                        "Content-Type": "application/x-www-form-urlencoded;charset=utf-8",
                    },
                    data: {},
                    transformRequest: function (data, parameters) {
                        return "fme_ip=" + fme_ip;
                    },
                })
                    .then(function (response) {
                    //read updated list from FMM
                    if (fmeListSrv.getDbg()) {
                        console.log("rmvFme", response);
                    }
                    getAlarmLogList().then(resolve);
                }, function (response) {
                    if (fmeListSrv.getDbg()) {
                        console.log("error:" + response);
                    }
                    var failedObject = {
                        fme_ip: "",
                        name: "rmvAlarmLog",
                        msg_type: "rmvAlarmLog",
                    };
                    var failedResponse = response.data.error || response.data;
                    if (response.statusText.length) {
                        failedResponse = response.statusText + ": " + failedResponse;
                    }
                    requestStatusSrv.addFaildRequest(failedObject, failedResponse);
                    reject(response);
                });
            });
        };
        myFactory.objectAlarm = function (object_id, fme_ip) {
            var objectAlarm = {
                isHaveAlarm: false,
                isHaveMajor: false
            };
            var maxPriority = -1;
            for (var i = 0; i < alarmMap.length; i++) {
                if (fme_ip === alarmMap[i].FME) {
                    for (var j = 0; j < alarmMap[i].children.length; j++) {
                        if (object_id.toUpperCase() ===
                            alarmMap[i].children[j].ObjectID.toUpperCase()) {
                            objectAlarm.isHaveAlarm = true;
                            if (maxPriority < parseInt(alarmMap[i].children[j].Priority)) {
                                maxPriority = parseInt(alarmMap[i].children[j].Priority);
                            }
                        }
                    }
                    break;
                }
            }
            if (objectAlarm.isHaveAlarm && maxPriority > 4) {
                objectAlarm.isHaveMajor = true;
            }
            return objectAlarm;
        };
        myFactory.fmeAlarm = function (fme_ip, item) {
            var fmeAlarm = {
                isHaveAlarm: false,
                isHaveMajor: false
            };
            var maxPriority = -1;
            var fme = fmeListSrv.getElement(fme_ip);
            if (!!fme) {
                for (var i = 0; i < alarmMap.length; i++) {
                    if (fme_ip === alarmMap[i].FME) {
                        if (alarmMap[i].children.length > 0) {
                            for (var j = 0; j < alarmMap[i].children.length; j++) {
                                if (item == "input") {
                                    if (!!fme.inputs) {
                                        for (var k = 0; k < fme.inputs.length; k++) {
                                            if (alarmMap[i].children[j].ObjectID.toUpperCase() ==
                                                fme.inputs[k].object_ID.toUpperCase()) {
                                                fmeAlarm.isHaveAlarm = true;
                                                if (maxPriority <
                                                    parseInt(alarmMap[i].children[j].Priority, 10)) {
                                                    maxPriority = parseInt(alarmMap[i].children[j].Priority, 10);
                                                }
                                            }
                                        }
                                    }
                                }
                                else if (item == "linear") {
                                    if (!!fme.linear) {
                                        for (var k = 0; k < fme.linear.length; k++) {
                                            if (alarmMap[i].children[j].ObjectID.toUpperCase() ==
                                                fme.linear[k].object_ID.toUpperCase()) {
                                                fmeAlarm.isHaveAlarm = true;
                                                if (maxPriority <
                                                    parseInt(alarmMap[i].children[j].Priority, 10)) {
                                                    maxPriority = parseInt(alarmMap[i].children[j].Priority, 10);
                                                }
                                            }
                                        }
                                    }
                                }
                                else if (item == "output") {
                                    if (!!fme.linear) {
                                        for (var k = 0; k < fme.linear.length; k++) {
                                            if (alarmMap[i].children[j].ObjectID.toUpperCase() ==
                                                fme.linear[k].object_ID.toUpperCase()) {
                                                fmeAlarm.isHaveAlarm = true;
                                                if (maxPriority <
                                                    parseInt(alarmMap[i].children[j].Priority, 10)) {
                                                    maxPriority = parseInt(alarmMap[i].children[j].Priority, 10);
                                                }
                                            }
                                        }
                                    }
                                    if (!!fme.muxGroup) {
                                        for (var k = 0; k < fme.muxGroup.length; k++) {
                                            if (alarmMap[i].children[j].ObjectID.toUpperCase() ==
                                                fme.muxGroup[k].object_ID.toUpperCase()) {
                                                fmeAlarm.isHaveAlarm = true;
                                                if (maxPriority <
                                                    parseInt(alarmMap[i].children[j].Priority, 10)) {
                                                    maxPriority = parseInt(alarmMap[i].children[j].Priority, 10);
                                                }
                                            }
                                        }
                                    }
                                    if (!!fme.muxService) {
                                        for (var k = 0; k < fme.muxService.length; k++) {
                                            if (alarmMap[i].children[j].ObjectID.toUpperCase() ==
                                                fme.muxService[k].object_ID.toUpperCase()) {
                                                fmeAlarm.isHaveAlarm = true;
                                                if (maxPriority <
                                                    parseInt(alarmMap[i].children[j].Priority, 10)) {
                                                    maxPriority = parseInt(alarmMap[i].children[j].Priority, 10);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            break;
                        }
                    }
                }
                if (fmeAlarm.isHaveAlarm && maxPriority > 4) {
                    fmeAlarm.isHaveMajor = true;
                }
            }
            return fmeAlarm;
        };
        myFactory.getCfgList = function (fme_ip) {
            return !alarmsCfgMap[fme_ip] ? [] : alarmsCfgMap[fme_ip].children;
        };
        myFactory.UpdateAlarmCfg = function (ip, alarms, error) {
            if (error === void 0) { error = false; }
            // set alarm configuration using jsonFile
            return $q(function (resolve, reject) {
                if (error) {
                    requestStatusSrv.addFaildRequest({
                        fme_ip: ip,
                        name: "SetAlarmConfig",
                        msg_type: "SetAlarmConfig",
                    }, "Delay value(s) out of range.");
                    reject();
                }
                else {
                    $http({
                        url: REST_ENDPOINT.URI + "elements/" + ip + "/alarms/config",
                        data: alarms,
                        method: "PUT",
                        dataType: "json",
                        headers: {
                            "Content-Type": "application/json",
                        },
                    }).then(function (response) {
                        resolve(response);
                    }, function (response) {
                        if (fmeListSrv.getDbg()) {
                            console.log("error:" + response);
                        }
                        var failedObject = {
                            fme_ip: ip,
                            name: "SetAlarmConfig",
                            msg_type: "SetAlarmConfig",
                        };
                        var failedResponse = response.data.error || response.data;
                        if (response.statusText.length) {
                            var reason = "";
                            if (typeof failedResponse === "string")
                                reason = failedResponse;
                            else if (failedResponse && failedResponse.reason)
                                reason = failedResponse.reason;
                            if (reason.includes("is not defined"))
                                failedResponse = "Alarm already disabled.";
                            else
                                failedResponse = response.statusText + ": " + reason;
                        }
                        requestStatusSrv.addFaildRequest(failedObject, failedResponse);
                        reject(response);
                    });
                }
            });
        };
        myFactory.getAlarmProperties = getAlarmProperties;
        myFactory.registerCallback = function (callback) {
            // register callback functions to specified array (polling array by default)
            var callbackArray = alarmCfgCallbacks;
            var functionExist = callbackArray.some(function (obj) {
                return angular.equals(obj, callback);
            });
            if (!functionExist) {
                callbackArray.push(callback);
            }
        };
        myFactory.unregisterCallback = function (callback) {
            // unregister callback function from specified array (polling array by defualt)
            var callbackArray = alarmCfgCallbacks;
            for (var i = callbackArray.length - 1; i >= 0; i--) {
                if (angular.equals(callbackArray[i], callback)) {
                    callbackArray.splice(i, 1);
                }
            }
        };
        var runExternalCallbacks = function () {
            // run each callback function in callbacks array (use polling array by default)
            angular.forEach(alarmCfgCallbacks, function (callback) {
                callback.fn.call(callback.scope);
            });
        };
        myFactory.refreshActiveAlarms = function (alarms) {
            if (fmeListSrv.getDbg()) {
                console.log("refreshActiveAlarms", alarms);
            }
            getActiveAlarms(alarms);
        };
        myFactory.refreshAlarmConfig = function (alarms) {
            if (fmeListSrv.getDbg()) {
                console.log("refreshAlarmConfig", alarms);
            }
            refreshAlarmConfigMap(alarms);
        };
        myFactory.setSortCriteria = function (criteria) {
            // set sorting criteria and resort active alarms
            if (!!criteria) {
                sortCriteria = {
                    field: !!criteria.field ? criteria.field : sortCriteria.field,
                    sortingType: !!criteria.sortingType ?
                        criteria.sortingType : sortCriteria.sortingType,
                    sortDirection: !!criteria.sortDirection ?
                        criteria.sortDirection : sortCriteria.sortDirection,
                };
                // resort alarm list
                for (var i = 0; i < alarmMap.length; i++) {
                    alarmMap[i].children.sort(_sortAlarm);
                }
            }
        };
        var init = function () {
            // Register alarm callback
            fmeListSrv.registerAlarmCallback({
                fn: myFactory.refreshActiveAlarms,
            });
            fmeListSrv.registerAlarmConfigCallback({
                fn: myFactory.refreshAlarmConfig,
            });
        };
        init();
        // myFactory.startService();
        return myFactory;
    }
    return AlarmListService;
}());
exports.AlarmListService = AlarmListService;


/***/ }),

/***/ "./app/view-menu/common.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (immutable) */ __webpack_exports__["snpSDNOIndexes"] = snpSDNOIndexes;
/* harmony export (immutable) */ __webpack_exports__["snpProcessorIdx"] = snpProcessorIdx;
/* harmony export (immutable) */ __webpack_exports__["snpProcessorLetter"] = snpProcessorLetter;
/* harmony export (immutable) */ __webpack_exports__["snpChannelConfigObjectId"] = snpChannelConfigObjectId;
/* harmony export (immutable) */ __webpack_exports__["snpChannelConfigLocation"] = snpChannelConfigLocation;
/* harmony export (immutable) */ __webpack_exports__["snpChannelConfigObjectIdForOpMode"] = snpChannelConfigObjectIdForOpMode;
/* harmony export (immutable) */ __webpack_exports__["snpChannelIPConfigIdx"] = snpChannelIPConfigIdx;
/* harmony export (immutable) */ __webpack_exports__["snpChannelAudChIdx"] = snpChannelAudChIdx;
/* harmony export (immutable) */ __webpack_exports__["snpAudProgramCtrlIdx"] = snpAudProgramCtrlIdx;
/* harmony export (immutable) */ __webpack_exports__["snpChannelBNCObjectIds"] = snpChannelBNCObjectIds;
/* harmony export (immutable) */ __webpack_exports__["snpBNCId"] = snpBNCId;
/* harmony export (immutable) */ __webpack_exports__["snpSFPId"] = snpSFPId;
/* harmony export (immutable) */ __webpack_exports__["snpSFPIds"] = snpSFPIds;
/* harmony export (immutable) */ __webpack_exports__["snpProcessorId"] = snpProcessorId;
/* harmony export (immutable) */ __webpack_exports__["snpAudProcessorId"] = snpAudProcessorId;
/* harmony export (immutable) */ __webpack_exports__["snpSectionId"] = snpSectionId;
/* harmony export (immutable) */ __webpack_exports__["snpChannelId"] = snpChannelId;
/* harmony export (immutable) */ __webpack_exports__["snpProgIdxInProc"] = snpProgIdxInProc;
/* harmony export (immutable) */ __webpack_exports__["snpAapProgramIdx"] = snpAapProgramIdx;
/* harmony export (immutable) */ __webpack_exports__["snpMCLId"] = snpMCLId;
/* harmony export (immutable) */ __webpack_exports__["snpSparseArrayIdx"] = snpSparseArrayIdx;
/* harmony export (immutable) */ __webpack_exports__["snpFilterDiffElements"] = snpFilterDiffElements;
/* harmony export (immutable) */ __webpack_exports__["snpCopyObjHeader"] = snpCopyObjHeader;
/* harmony export (immutable) */ __webpack_exports__["snpInOneOfPersonalities"] = snpInOneOfPersonalities;
/* harmony export (immutable) */ __webpack_exports__["sortAapSessionArray"] = sortAapSessionArray;
/* harmony export (immutable) */ __webpack_exports__["algorithmIdToString"] = algorithmIdToString;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular__ = __webpack_require__("./node_modules/angular/index.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_angular___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_angular__);


const SNP_PERSONALITY_SYNC = "Sync";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_SYNC"] = SNP_PERSONALITY_SYNC;

const SNP_PERSONALITY_CONVERT = "Conv";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_CONVERT"] = SNP_PERSONALITY_CONVERT;

const SNP_PERSONALITY_REMAP = "Remap";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_REMAP"] = SNP_PERSONALITY_REMAP;

const SNP_PERSONALITY_MV = "Multiviewer";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_MV"] = SNP_PERSONALITY_MV;

const SNP_PERSONALITY_CONV4 = "Quad Conversion";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_CONV4"] = SNP_PERSONALITY_CONV4;

const SNP_PERSONALITY_MVP = "Multiviewer Portrait";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_MVP"] = SNP_PERSONALITY_MVP;

const SNP_PERSONALITY_JXSD = "JPEG-XS Decoder";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_JXSD"] = SNP_PERSONALITY_JXSD;

const SNP_PERSONALITY_JXSE = "JPEG-XS Encoder";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_JXSE"] = SNP_PERSONALITY_JXSE;

const SNP_PERSONALITY_STAT = "STAT";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_STAT"] = SNP_PERSONALITY_STAT;

const SNP_PERSONALITY_MCL = "Master Control Lite";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_MCL"] = SNP_PERSONALITY_MCL;

const SNP_PERSONALITY_TR7E = "JPEG-XS Encoder (TR-07)";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_TR7E"] = SNP_PERSONALITY_TR7E;

const SNP_PERSONALITY_TR7D = "JPEG-XS Decoder (TR-07)";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_TR7D"] = SNP_PERSONALITY_TR7D;

const SNP_PERSONALITY_TR7EU = "JPEG-XS Encoder UHD (TR-07)";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_TR7EU"] = SNP_PERSONALITY_TR7EU;

const SNP_PERSONALITY_TR7DU = "JPEG-XS Decoder UHD (TR-07)";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_TR7DU"] = SNP_PERSONALITY_TR7DU;

const SNP_PERSONALITY_GW88 = "Dual Gateway";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_GW88"] = SNP_PERSONALITY_GW88;

const SNP_PERSONALITY_APROC = "Audio Routing";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_APROC"] = SNP_PERSONALITY_APROC;

const SNP_PERSONALITY_FX = "Effects / Squeezeback";
/* harmony export (immutable) */ __webpack_exports__["SNP_PERSONALITY_FX"] = SNP_PERSONALITY_FX;


const SNP_FPGA_SWITCH_STARTING = "Initializing";
/* harmony export (immutable) */ __webpack_exports__["SNP_FPGA_SWITCH_STARTING"] = SNP_FPGA_SWITCH_STARTING;

const SNP_FPGA_READY = "Ready";
/* harmony export (immutable) */ __webpack_exports__["SNP_FPGA_READY"] = SNP_FPGA_READY;

const SNP_FPGA_LOADING = "Loading";
/* harmony export (immutable) */ __webpack_exports__["SNP_FPGA_LOADING"] = SNP_FPGA_LOADING;

const SNP_FPGA_LOADING_FAILED = "Loading Failed";
/* harmony export (immutable) */ __webpack_exports__["SNP_FPGA_LOADING_FAILED"] = SNP_FPGA_LOADING_FAILED;

const SNP_OP_MODE_HD = "HD";
/* harmony export (immutable) */ __webpack_exports__["SNP_OP_MODE_HD"] = SNP_OP_MODE_HD;

const SNP_OP_MODE_UHD = "UHD";
/* harmony export (immutable) */ __webpack_exports__["SNP_OP_MODE_UHD"] = SNP_OP_MODE_UHD;

const SNP_MV_MODE_BASE = "Base";
/* harmony export (immutable) */ __webpack_exports__["SNP_MV_MODE_BASE"] = SNP_MV_MODE_BASE;

const SNP_MV_MODE_EXTENDED = "Extended";
/* harmony export (immutable) */ __webpack_exports__["SNP_MV_MODE_EXTENDED"] = SNP_MV_MODE_EXTENDED;

const SNP_MV_MODE_BASE_ID = 0;
/* harmony export (immutable) */ __webpack_exports__["SNP_MV_MODE_BASE_ID"] = SNP_MV_MODE_BASE_ID;

const SNP_MV_MODE_EXTENDED_ID = 1;
/* harmony export (immutable) */ __webpack_exports__["SNP_MV_MODE_EXTENDED_ID"] = SNP_MV_MODE_EXTENDED_ID;

const SNP_PROC_MODE_BASE = "Base";
/* harmony export (immutable) */ __webpack_exports__["SNP_PROC_MODE_BASE"] = SNP_PROC_MODE_BASE;

const SNP_PROC_MODE_EXTENDED = "Extended";
/* harmony export (immutable) */ __webpack_exports__["SNP_PROC_MODE_EXTENDED"] = SNP_PROC_MODE_EXTENDED;

const SNP_PROC_MODE_BASE_ID = 0;
/* harmony export (immutable) */ __webpack_exports__["SNP_PROC_MODE_BASE_ID"] = SNP_PROC_MODE_BASE_ID;

const SNP_PROC_MODE_EXTENDED_ID = 1;
/* harmony export (immutable) */ __webpack_exports__["SNP_PROC_MODE_EXTENDED_ID"] = SNP_PROC_MODE_EXTENDED_ID;

const SNP_ROT_SEL_CW = "CW";
/* harmony export (immutable) */ __webpack_exports__["SNP_ROT_SEL_CW"] = SNP_ROT_SEL_CW;

const SNP_ROT_SEL_CCW = "CCW";
/* harmony export (immutable) */ __webpack_exports__["SNP_ROT_SEL_CCW"] = SNP_ROT_SEL_CCW;

const SNP_ROT_SEL_CW_ID = 0;
/* harmony export (immutable) */ __webpack_exports__["SNP_ROT_SEL_CW_ID"] = SNP_ROT_SEL_CW_ID;

const SNP_ROT_SEL_CCW_ID = 1;
/* harmony export (immutable) */ __webpack_exports__["SNP_ROT_SEL_CCW_ID"] = SNP_ROT_SEL_CCW_ID;

const SNP_IOTYPE_SDI = "BNC";
/* harmony export (immutable) */ __webpack_exports__["SNP_IOTYPE_SDI"] = SNP_IOTYPE_SDI;

const SNP_IOTYPE_SDI_ALT = "BNC_ALT";
/* harmony export (immutable) */ __webpack_exports__["SNP_IOTYPE_SDI_ALT"] = SNP_IOTYPE_SDI_ALT;

const SNP_IOTYPE_IP = "IP";
/* harmony export (immutable) */ __webpack_exports__["SNP_IOTYPE_IP"] = SNP_IOTYPE_IP;

const SNP_IOTYPE_SFP = "SFP";
/* harmony export (immutable) */ __webpack_exports__["SNP_IOTYPE_SFP"] = SNP_IOTYPE_SFP;

const SNP_BNC_DIR_IN = "Input";
/* harmony export (immutable) */ __webpack_exports__["SNP_BNC_DIR_IN"] = SNP_BNC_DIR_IN;

const SNP_BNC_DIR_OUT = "Output";
/* harmony export (immutable) */ __webpack_exports__["SNP_BNC_DIR_OUT"] = SNP_BNC_DIR_OUT;


const SNP_OBJTYPE_CH_HD = "procChannelHD";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_CH_HD"] = SNP_OBJTYPE_CH_HD;

const SNP_OBJTYPE_CH_UHD = "procChannelUHD";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_CH_UHD"] = SNP_OBJTYPE_CH_UHD;

const SNP_OBJTYPE_PROC_AUD = "procAudio";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_PROC_AUD"] = SNP_OBJTYPE_PROC_AUD;

const SNP_OBJTYPE_BNC = "videoIn";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_BNC"] = SNP_OBJTYPE_BNC;

const SNP_OBJTYPE_IP_RX = "ipVidRx";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_IP_RX"] = SNP_OBJTYPE_IP_RX;

const SNP_OBJTYPE_IP_TX = "ipVidTx";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_IP_TX"] = SNP_OBJTYPE_IP_TX;

const SNP_OBJTYPE_IP_AUD_RX = "ipAudRx";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_IP_AUD_RX"] = SNP_OBJTYPE_IP_AUD_RX;

const SNP_OBJTYPE_IP_AUD_TX = "ipAudTx";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_IP_AUD_TX"] = SNP_OBJTYPE_IP_AUD_TX;

const SNP_OBJTYPE_IP_ANC_RX = "ipAncRx";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_IP_ANC_RX"] = SNP_OBJTYPE_IP_ANC_RX;

const SNP_OBJTYPE_IP_ANC_TX = "ipAncTx";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_IP_ANC_TX"] = SNP_OBJTYPE_IP_ANC_TX;

const SNP_OBJTYPE_GENLOCK = "videoGenLock";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_GENLOCK"] = SNP_OBJTYPE_GENLOCK;

const SNP_OBJTYPE_PTP = "ptp";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_PTP"] = SNP_OBJTYPE_PTP;

const SNP_OBJTYPE_WAN = "ipWan";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_WAN"] = SNP_OBJTYPE_WAN;

const SNP_OBJID_GENLOCK = "GenLock";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJID_GENLOCK"] = SNP_OBJID_GENLOCK;

const SNP_OBJTYPE_IP_RX_SETUP = "ipRxSetup";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_IP_RX_SETUP"] = SNP_OBJTYPE_IP_RX_SETUP;

const SNP_OBJTYPE_SYSTEM = "system";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_SYSTEM"] = SNP_OBJTYPE_SYSTEM;

const SNP_OBJTYPE_SQM = "SQM";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_SQM"] = SNP_OBJTYPE_SQM;

const SNP_OBJTYPE_PROCESSOR = "processor";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_PROCESSOR"] = SNP_OBJTYPE_PROCESSOR;

const SNP_OBJTYPE_MCL = "MasterControl";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_MCL"] = SNP_OBJTYPE_MCL;

const SNP_OBJTYPE_PCS = "PanelControlService";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_PCS"] = SNP_OBJTYPE_PCS;

const SNP_OBJTYPE_GPI = "GPI";
/* harmony export (immutable) */ __webpack_exports__["SNP_OBJTYPE_GPI"] = SNP_OBJTYPE_GPI;

const SNP_CONFIG_LOCATIONS = ["Processor", "Section", "Program"];
/* harmony export (immutable) */ __webpack_exports__["SNP_CONFIG_LOCATIONS"] = SNP_CONFIG_LOCATIONS;

const propType = {
  CONFIG: 'config',
  STATUS: 'status'
};
/* harmony export (immutable) */ __webpack_exports__["propType"] = propType;

const SNP_IP_AUD_PER_CH = 16;
/* harmony export (immutable) */ __webpack_exports__["SNP_IP_AUD_PER_CH"] = SNP_IP_AUD_PER_CH;

const SNP_IP_ANC_PER_CH = 4;
/* harmony export (immutable) */ __webpack_exports__["SNP_IP_ANC_PER_CH"] = SNP_IP_ANC_PER_CH;

const SNP_CH_PER_SEC = 4;
/* harmony export (immutable) */ __webpack_exports__["SNP_CH_PER_SEC"] = SNP_CH_PER_SEC;


const SNP_VPHASE_TABLE = {
  "1080":
  {
    "max": 1124
  },
  "720":
  {
    "max": 749
  },
  "525":
  {
    "max": 524
  },
  "625":
  {
    "max": 624
  },
  "Unknown":
  {
    "max": 1124
  }
};
/* harmony export (immutable) */ __webpack_exports__["SNP_VPHASE_TABLE"] = SNP_VPHASE_TABLE;


const SNP_AUD_PROC_INPUT_SELECT_TYPE = {
  APIN: 0,
  EXP: 1,
  AAP: 2,
  TONES: 3,
  DMB: 4,
  IP: 5
};
/* harmony export (immutable) */ __webpack_exports__["SNP_AUD_PROC_INPUT_SELECT_TYPE"] = SNP_AUD_PROC_INPUT_SELECT_TYPE;


const SNP_AUD_PROC_MAX_CH_DELAY = {
  "Reduced":
  {
    "max": 680000
  },
  "Normal":
  {
    "max": 1000000
  },
  "Extended":
  {
    "max": 2500000
  },
  "GW88":
  {
    "max": 10000000
  }
};
/* harmony export (immutable) */ __webpack_exports__["SNP_AUD_PROC_MAX_CH_DELAY"] = SNP_AUD_PROC_MAX_CH_DELAY;


const SNP_HPHASE_TABLE = {
  // each value duplicated for video standard formatted in different ways
  "1080i50":
  {
    "max": 2639,
    "coefficient": 74.25
  },
  "1080i/50":
  {
    "max": 2639,
    "coefficient": 74.25
  },

  "1080p50":
  {
    "max": 2639,
    "coefficient": 148.5
  },
  "1080p/50":
  {
    "max": 2639,
    "coefficient": 148.5
  },

  "1080i59":
  {
    "max": 2199,
    "coefficient": 74.17582
  },
  "1080i/59":
  {
    "max": 2199,
    "coefficient": 74.17582
  },
  "1080i59.94":
  {
    "max": 2199,
    "coefficient": 74.17582
  },
  "1080i/59.94":
  {
    "max": 2199,
    "coefficient": 74.17582
  },

  "1080p59":
  {
    "max": 2199,
    "coefficient": 148.35165
  },
  "1080p/59":
  {
    "max": 2199,
    "coefficient": 148.35165
  },
  "1080p59.94":
  {
    "max": 2199,
    "coefficient": 148.35165
  },
  "1080p/59.94":
  {
    "max": 2199,
    "coefficient": 148.35165
  },

  "1080p25":
  {
    "max": 2639,
    "coefficient": 74.25
  },
  "1080p/25":
  {
    "max": 2639,
    "coefficient": 74.25
  },

  "1080p29":
  {
    "max": 2199,
    "coefficient": 74.17582
  },
  "1080p/29":
  {
    "max": 2199,
    "coefficient": 74.17582
  },
  "1080p29.97":
  {
    "max": 2199,
    "coefficient": 74.17582
  },
  "1080p/29.97":
  {
    "max": 2199,
    "coefficient": 74.17582
  },

  "1080p24":
  {
    "max": 2749,
    "coefficient": 74.25
  },
  "1080p/24":
  {
    "max": 2749,
    "coefficient": 74.25
  },
  "1080psf24":
  {
    "max": 2749,
    "coefficient": 74.25
  },
  "1080psf/24":
  {
    "max": 2749,
    "coefficient": 74.25
  },

  "1080p23.98":
  {
    "max": 2749,
    "coefficient": 74.17582
  },
  "1080p/23.98":
  {
    "max": 2749,
    "coefficient": 74.17582
  },
  "1080psf23.98":
  {
    "max": 2749,
    "coefficient": 74.17582
  },
  "1080psf/23.98":
  {
    "max": 2749,
    "coefficient": 74.17582
  },

  "720p50":
  {
    "max": 1979,
    "coefficient": 74.25
  },
  "720p/50":
  {
    "max": 1979,
    "coefficient": 74.25
  },

  "720p59":
  {
    "max": 1649,
    "coefficient": 74.17582
  },
  "720p/59":
  {
    "max": 1649,
    "coefficient": 74.17582
  },
  "720p59.94":
  {
    "max": 1649,
    "coefficient": 74.17582
  },
  "720p/59.94":
  {
    "max": 1649,
    "coefficient": 74.17582
  },

  // SNP-24407 fix - add division by 2 to calibrate SD H-Phase
  "625i50":
  {
    "max": 1727,
    "coefficient": 27
  },
  "625i/50":
  {
    "max": 1727,
    "coefficient": 27
  },
  "525i59.94":
  {
    "max": 1715,
    "coefficient": 27
  },
  "525i/59.94":
  {
    "max": 1715,
    "coefficient": 27
  },

  "Unknown":
  {
    "max": 2639,
    "coefficient": 74.25
  }
};
/* harmony export (immutable) */ __webpack_exports__["SNP_HPHASE_TABLE"] = SNP_HPHASE_TABLE;


function snpSDNOIndexes (processorObjectId, sectionIdx, channelIdx)
{
  return {
    "processor": snpProcessorIdx(processorObjectId) + 1,
    "section": sectionIdx + 1,
    "program": channelIdx + 1,
  };
}

function snpProcessorIdx (processorObjectId)
{
  // 65 is the ASCII code for 'A'
  var processorIdx = processorObjectId.charCodeAt(processorObjectId.length - 1) - 65;
  return (processorIdx < 0 || processorIdx > 3 ? undefined : processorIdx);
}

function snpProcessorLetter (processorObjectId)
{
  return processorObjectId[processorObjectId.length - 1];
}

function snpChannelConfigObjectId (processor, sectionIdx, channelIdx)
{
  var sectionArrayIdx = snpSparseArrayIdx(processor.sections, sectionIdx + 1);
  var channelMode = 'HD';
  var channelsPerSection = 4;
  if (((processor.general.personality === SNP_PERSONALITY_SYNC ||
        processor.general.personality === SNP_PERSONALITY_JXSD ||
        processor.general.personality === SNP_PERSONALITY_JXSE ||
        processor.general.personality === SNP_PERSONALITY_STAT ||
        processor.general.personality === SNP_PERSONALITY_MCL ||
        processor.general.personality === SNP_PERSONALITY_MV ||
        processor.general.personality === SNP_PERSONALITY_MVP ||
        processor.general.personality === SNP_PERSONALITY_GW88 ||
        processor.general.personality === SNP_PERSONALITY_APROC ||
        processor.general.personality === SNP_PERSONALITY_FX) &&
      sectionIdx !== 2 && processor.sections[sectionArrayIdx].opMode == SNP_OP_MODE_UHD) ||
    processor.general.personality === SNP_PERSONALITY_REMAP ||
    processor.general.personality === SNP_PERSONALITY_TR7EU ||
    processor.general.personality === SNP_PERSONALITY_TR7DU ||
    processor.general.personality === SNP_PERSONALITY_CONVERT)
  {
    channelMode = 'UHD';
    channelsPerSection = 1;
  }
  else if (processor.general.personality === SNP_PERSONALITY_FX)
  {
    channelsPerSection = 1;
  }
  return snpProcessorLetter(processor.object_ID) + '-' + channelMode + '-' + (sectionIdx * channelsPerSection + channelIdx + 1);
}

function snpChannelConfigLocation (processor, sectionIdx, channelIdx)
{
  // var sectionArrayIdx = snpSparseArrayIdx(processor.sections, sectionIdx + 1);
  // var channelMode = 'HD';
  // var channelsPerSection = 4;
  // if (((processor.general.personality === SNP_PERSONALITY_SYNC || processor.general.personality === SNP_PERSONALITY_MV)
  // && processor.sections[sectionArrayIdx].opMode == SNP_OP_MODE_UHD)
  //   || processor.general.personality === SNP_PERSONALITY_REMAP
  //   || processor.general.personality === SNP_PERSONALITY_CONVERT) {
  //   channelMode = 'UHD';
  // }
  return SNP_CONFIG_LOCATIONS[0] + snpProcessorLetter(processor.object_ID) + ' ' +
    SNP_CONFIG_LOCATIONS[1] + (sectionIdx + 1).toString() + ' ' +
    SNP_CONFIG_LOCATIONS[2] + (channelIdx + 1).toString();
}

function snpChannelConfigObjectIdForOpMode (opMode, processor, sectionIdx, channelIdx)
{
  var channelMode = 'HD';
  var channelsPerSection = 4;
  if (opMode == SNP_OP_MODE_UHD)
  {
    channelMode = 'UHD';
    channelsPerSection = 1;
  }
  return snpProcessorLetter(processor.object_ID) + '-' + channelMode + '-' + (sectionIdx * channelsPerSection + channelIdx + 1);
}

function snpChannelIPConfigIdx (processor, sectionIdx, channelIdx)
{
  if (sectionIdx === 2)
  {
    return 8 * 4 + snpProcessorIdx(processor.object_ID) + 1;
  }
  else return snpProcessorIdx(processor.object_ID) * 8 + sectionIdx * 4 + channelIdx + 1;
}

function snpChannelAudChIdx (sectionIdx, channelIdx, audPerChannel, audPerSection)
{
  if (typeof audPerChannel === 'undefined')
  {
    audPerChannel = SNP_IP_AUD_PER_CH;
  }
  if (typeof audPerSection === 'undefined')
  {
    audPerSection = audPerChannel * 4;
  }
  return (sectionIdx * audPerSection) + (channelIdx * audPerChannel) + 1;
}

function snpAudProgramCtrlIdx (sectionIdx, channelIdx)
{
  return sectionIdx * 4 + channelIdx + 1;
}

function snpChannelBNCObjectIds (processor, sectionIdx, channelIdx, inputType)
{
  var sectionArrayIdx = snpSparseArrayIdx(processor.sections, sectionIdx + 1);
  var numOfBNCs = 1;
  if ((processor.general.personality === SNP_PERSONALITY_MV || processor.general.personality === SNP_PERSONALITY_MVP) && sectionIdx === 2)
  {
    return ['BNC-' + (8 * 4 + snpProcessorIdx(processor.object_ID) + 1)];
  }
  else if (processor.general.personality === SNP_PERSONALITY_SYNC || processor.general.personality === SNP_PERSONALITY_JXSE ||
    processor.general.personality === SNP_PERSONALITY_JXSD || processor.general.personality === SNP_PERSONALITY_STAT ||
    processor.general.personality === SNP_PERSONALITY_TR7E || processor.general.personality === SNP_PERSONALITY_TR7D ||
    processor.general.personality === SNP_PERSONALITY_MV || processor.general.personality === SNP_PERSONALITY_MVP ||
    processor.general.personality === SNP_PERSONALITY_MCL || processor.general.personality === SNP_PERSONALITY_GW88 ||
    processor.general.personality === SNP_PERSONALITY_APROC || processor.general.personality === SNP_PERSONALITY_FX)
  {
    numOfBNCs = (processor.sections[sectionArrayIdx].opMode == SNP_OP_MODE_UHD ? 4 : 1);
  }
  else if (processor.general.personality === SNP_PERSONALITY_REMAP || processor.general.personality === SNP_PERSONALITY_CONVERT ||
    processor.general.personality === SNP_PERSONALITY_TR7EU || processor.general.personality === SNP_PERSONALITY_TR7DU)
  {
    numOfBNCs = 4;
  }

  //SNP-24579 begin (taken from snpBNCId)
  var selectedSDIvalueORsectionIdx = sectionIdx;
  if (processor.general.personality === SNP_PERSONALITY_SYNC)
  {
    if (inputType === SNP_IOTYPE_SDI_ALT)
      selectedSDIvalueORsectionIdx = processor.sections[sectionArrayIdx].idx == 2 ? 0 : 1;
    else
      selectedSDIvalueORsectionIdx = processor.sections[sectionArrayIdx].idx == 2 ? 1 : 0;
  }
  else if (processor.general.personality !== SNP_PERSONALITY_MV && processor.general.personality !== SNP_PERSONALITY_MVP)
  {
    selectedSDIvalueORsectionIdx = inputType === SNP_IOTYPE_SDI_ALT ? ((selectedSDIvalueORsectionIdx + 1) % 2) : selectedSDIvalueORsectionIdx;
  }
  //SNP-24579 end

  var bncObjectIds = [];
  for (var i = 0; i < numOfBNCs; ++i)
  {
    bncObjectIds.push("BNC-" + (snpProcessorIdx(processor.object_ID) * 8 + selectedSDIvalueORsectionIdx * 4 + channelIdx + 1 + i)); //SNP-24579
  }
  return bncObjectIds;
}

function snpBNCId (processor, sectionIdx, channelIdx, isInput, inputType, convSDIInputSelect, convOutputVideoStandard, uhdSdiSelect)
{
  var sectionArrayIdx = snpSparseArrayIdx(processor.sections, sectionIdx + 1);
  var numOfBNCs = 1;
  var firstBNCOffset = 0;

  var selectedSDIvalueORsectionIdx = sectionIdx; //SNP-24467 and SNP-24459: selected value from SDI (1 section (0 = SDI 1-4, 1 = SDI 5-8), 2 section (1 = SDI 1-4, 0 = SDI 5-8));
  //SNP-24261: this variable = sectionIdx

  if (processor.general.personality === SNP_PERSONALITY_SYNC ||
    processor.general.personality === SNP_PERSONALITY_JXSD ||
    processor.general.personality === SNP_PERSONALITY_JXSE ||
    processor.general.personality === SNP_PERSONALITY_STAT ||
    processor.general.personality === SNP_PERSONALITY_TR7E ||
    processor.general.personality === SNP_PERSONALITY_TR7D ||
    processor.general.personality === SNP_PERSONALITY_TR7EU ||
    processor.general.personality === SNP_PERSONALITY_TR7DU ||
    processor.general.personality === SNP_PERSONALITY_GW88 ||
    processor.general.personality === SNP_PERSONALITY_MCL ||
    processor.general.personality === SNP_PERSONALITY_APROC ||
    processor.general.personality === SNP_PERSONALITY_FX)
  { //SNP-24467 and SNP-24459
    if (inputType === SNP_IOTYPE_SDI_ALT && isInput)
    {
      selectedSDIvalueORsectionIdx = processor.sections[sectionArrayIdx].idx == 2 ? 0 : 1;
    }
    else
    {
      selectedSDIvalueORsectionIdx = processor.sections[sectionArrayIdx].idx == 2 ? 1 : 0;
    }
  }
  else if (processor.general.personality === SNP_PERSONALITY_CONV4)
  { //SNP-24530
    if (inputType === SNP_IOTYPE_SDI_ALT)
    {
      selectedSDIvalueORsectionIdx = isInput ? 1 : 0;
    }
    else if (inputType === SNP_IOTYPE_IP && !isInput)
    {
      //selectedSDIvalueORsectionIdx = sectionIdx;
    }
    else
    {
      selectedSDIvalueORsectionIdx = isInput ? 0 : 1;
    }
  }
  else if (processor.general.personality !== SNP_PERSONALITY_MV && processor.general.personality !== SNP_PERSONALITY_MVP)
  { //SNP-24261
    selectedSDIvalueORsectionIdx = inputType === SNP_IOTYPE_SDI_ALT && isInput ? ((selectedSDIvalueORsectionIdx + 1) % 2) : selectedSDIvalueORsectionIdx;
  }

  // SNP-8592: new option to specify UHD 12G in/out. uhdSdiSelect = { 0: UHD (Quad link), 1: UHD (12G) }
  if (processor.general.personality === SNP_PERSONALITY_SYNC || processor.general.personality === SNP_PERSONALITY_JXSE ||
    processor.general.personality === SNP_PERSONALITY_MCL || processor.general.personality === SNP_PERSONALITY_MV ||
    processor.general.personality === SNP_PERSONALITY_MVP || processor.general.personality === SNP_PERSONALITY_TR7E ||
    processor.general.personality === SNP_PERSONALITY_TR7D || processor.general.personality === SNP_PERSONALITY_TR7EU ||
    processor.general.personality === SNP_PERSONALITY_TR7DU || processor.general.personality === SNP_PERSONALITY_GW88 ||
    processor.general.personality === SNP_PERSONALITY_APROC || processor.general.personality === SNP_PERSONALITY_FX)
  { // -MT- NOT UHD IN MCL
    numOfBNCs = (processor.sections[sectionArrayIdx].opMode == SNP_OP_MODE_UHD && uhdSdiSelect != 1) ? 4 : 1;
  }
  else if (processor.general.personality === SNP_PERSONALITY_REMAP)
  {
    numOfBNCs = (uhdSdiSelect != 1) ? 4 : 1;
  }
  else if (processor.general.personality === SNP_PERSONALITY_CONVERT)
  {
    if (isInput)
    {
      firstBNCOffset = convSDIInputSelect;
      // SNP-8592: convSDIInputSelect = {0: 1st Link, 1: 2nd Link, 2: 3rd Link, 3: 4th Link, 4: UHD (Quad Link), 5: UHD (12G)}
      if (firstBNCOffset > 3)
      {
        firstBNCOffset = 0;
        // only use 1 BNC if UHD (12G) is selected
        numOfBNCs = (convSDIInputSelect == 5) ? 1 : 4;
      }
      else
      {
        numOfBNCs = 1;
      }
    }
    else
    {
      numOfBNCs = ((convOutputVideoStandard.indexOf("2160p") !== -1 && uhdSdiSelect != 1) ? 4 : 1);
    }
  }

  var startBNC = snpProcessorIdx(processor.object_ID) * 8 + selectedSDIvalueORsectionIdx * 4 + channelIdx + firstBNCOffset + 1;
  var endBNC = startBNC + numOfBNCs - 1;
  return "BNC-" + startBNC + (numOfBNCs > 1 ? "-" + endBNC : "");
}

function snpSFPId (processor, sectionIdx, channelIdx)
{
  return "SFP-" + snpProcessorLetter(processor.object_ID) + "-" + (sectionIdx + (!!channelIdx ? channelIdx : 0) === 0 ? "1" : "2");
}

function snpSFPIds (processor)
{
  return [1, 2].map(i => `SFP-${snpProcessorLetter(processor.object_ID)}-${i}`);
}

function snpProcessorId (processor)
{
  return "Processor " + snpProcessorLetter(processor.object_ID);
}

function snpAudProcessorId (processor)
{
  return snpProcessorLetter(processor.object_ID) + "-" + SNP_OBJTYPE_PROC_AUD;
}

function snpSectionId (processor, sectionIdx)
{
  return "Section " + (sectionIdx + 1);
}

function snpChannelId (processor, sectionIdx, channelIdx)
{
  return "Program " + (channelIdx + 1);
}

function snpProgIdxInProc (sectionIdx, channelIdx)
{
  return sectionIdx * 4 + (channelIdx + 1);
}

function snpAapProgramIdx (processor, sectionIdx, channelIdx)
{
  return snpProcessorIdx(processor.object_ID) * 8 + sectionIdx * 4 + (channelIdx + 1);
}

function snpMCLId (processor)
{
  return "MasterControl-" + snpProcessorLetter(processor.object_ID);
}

function snpSparseArrayIdx (array, itemIdx)
{
  if (__WEBPACK_IMPORTED_MODULE_0_angular__["isArray"](array))
  {
    itemIdx = Number(itemIdx);
    for (var i = 0; i < array.length; ++i)
    {
      if (Number(array[i].idx) === itemIdx)
      {
        return i;
      }
    }
  }
  return -1;
}

function snpFilterDiffElements (modifiedObj, comparisonObj, arrayPropName)
{
  var indexMap = [];
  modifiedObj[arrayPropName] = modifiedObj[arrayPropName].filter(function (e, index)
  {
    if (!__WEBPACK_IMPORTED_MODULE_0_angular__["equals"](e, comparisonObj[arrayPropName][index]))
    {
      indexMap.push(index);
      return true;
    }
    return false;
  });
  return indexMap;
}

function snpCopyObjHeader (o, ip)
{
  var ret = {
    type: o.type,
    name: o.name,
    object_ID: o.object_ID,
  }
  if (__WEBPACK_IMPORTED_MODULE_0_angular__["isDefined"](ip))
  {
    ret.fme_ip = ip;
  }
  return ret;
}

function snpInOneOfPersonalities (processor, list)
{
  let isIn = false;
  for (const elem of list)
  {
    if (processor.general.personality === elem)
    {
      isIn = true;
      break;
    }
  }
  return isIn;
}

function sortAapSessionArray (sessionArray)
{
  return sessionArray.sort((a, b) =>
  {
    const a_procNum = Number(a.session.split('-')[0].charCodeAt() - 65);
    const a_sessionIdx = Number(a.session.split('-')[1]);
    const b_procNum = Number(b.session.split('-')[0].charCodeAt() - 65);
    const b_sessionIdx = Number(b.session.split('-')[1]);
    return (a_procNum - b_procNum) ? (a_procNum - b_procNum) : (a_sessionIdx - b_sessionIdx);
  });
}

const toneLabels = ["400Hz", "1kHz", "2kHz", "Mute"];
/* harmony export (immutable) */ __webpack_exports__["toneLabels"] = toneLabels;


const ALGORITHM_UNKNOWN = 0;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_UNKNOWN"] = ALGORITHM_UNKNOWN;

const ALGORITHM_UPMIX = 1;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_UPMIX"] = ALGORITHM_UPMIX;

const ALGORITHM_DOWNMIX = 2;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_DOWNMIX"] = ALGORITHM_DOWNMIX;

const ALGORITHM_MULTIMERGE = 3;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_MULTIMERGE"] = ALGORITHM_MULTIMERGE;

const ALGORITHM_UM_LOUDNESS = 4;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_UM_LOUDNESS"] = ALGORITHM_UM_LOUDNESS;

const ALGORITHM_DM_LOUDNESS = 5;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_DM_LOUDNESS"] = ALGORITHM_DM_LOUDNESS;

const ALGORITHM_MM_LOUDNESS = 6;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_MM_LOUDNESS"] = ALGORITHM_MM_LOUDNESS;

const ALGORITHM_LOUDNESS_1 = 7;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_LOUDNESS_1"] = ALGORITHM_LOUDNESS_1;

const ALGORITHM_LOUDNESS_2 = 8;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_LOUDNESS_2"] = ALGORITHM_LOUDNESS_2;

const ALGORITHM_LOUDNESS_5 = 9;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_LOUDNESS_5"] = ALGORITHM_LOUDNESS_5;

const ALGORITHM_LOUDNESS_7 = 10;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_LOUDNESS_7"] = ALGORITHM_LOUDNESS_7;

const ALGORITHM_LOUDNESS_2X1 = 11;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_LOUDNESS_2X1"] = ALGORITHM_LOUDNESS_2X1;

const ALGORITHM_LOUDNESS_8X1 = 12;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_LOUDNESS_8X1"] = ALGORITHM_LOUDNESS_8X1;

const ALGORITHM_LOUDNESS_4X2 = 13;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_LOUDNESS_4X2"] = ALGORITHM_LOUDNESS_4X2;

const ALGORITHM_LOUDNESS_5_2 = 14;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_LOUDNESS_5_2"] = ALGORITHM_LOUDNESS_5_2;

const ALGORITHM_DOLBY_E_ENC = 15;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_DOLBY_E_ENC"] = ALGORITHM_DOLBY_E_ENC;

const ALGORITHM_DOLBY_E_DEC = 16;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_DOLBY_E_DEC"] = ALGORITHM_DOLBY_E_DEC;

/*@if (@ENABLE_DEE_COMBO)
export const ALGORITHM_DOLBY_E_ENC_LOUDNESS = 17;
@end*/
const ALGORITHM_MIN = ALGORITHM_UPMIX;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_MIN"] = ALGORITHM_MIN;

const ALGORITHM_MAX = ALGORITHM_DOLBY_E_DEC;
/* harmony export (immutable) */ __webpack_exports__["ALGORITHM_MAX"] = ALGORITHM_MAX;


const UPMIX_INPUT_NUMBER = 2;
/* harmony export (immutable) */ __webpack_exports__["UPMIX_INPUT_NUMBER"] = UPMIX_INPUT_NUMBER;

const DEF_AAP_INPUT_NUMBER = 8;
/* harmony export (immutable) */ __webpack_exports__["DEF_AAP_INPUT_NUMBER"] = DEF_AAP_INPUT_NUMBER;


const aapAudAlgoLabels = ["Unknown", "Upmix", "Downmix", "Multimerge", "UM+Loudness", "DM+Loudness", "MM+Loudness",
  "Loudness 1.0", "Loudness 2.0", "Loudness 5.1", "Loudness 7.1", "Loudness 2x1.0", "Loudness 8x1.0",
  "Loudness 4x2.0", "Loudness 5.1 + 2.0", "Dolby E Encoder", "Dolby E Decoder" /* , "Dolby E Encoder+Loudness" */
];
/* harmony export (immutable) */ __webpack_exports__["aapAudAlgoLabels"] = aapAudAlgoLabels;

const aapSurroundChanLabels = ["1(L)", "2(R)", "3(C)", "4(LFE)", "5(Ls)", "6(Rs)", "7(Lb/Cb)", "8(Rb)"];
/* harmony export (immutable) */ __webpack_exports__["aapSurroundChanLabels"] = aapSurroundChanLabels;

const aapMMChanLabels = ["1(L)", "2(R)", "3(C)", "4(LFE)", "5(Ls)", "6(Rs)", "7(Stereo L)", "8(Stereo R)"];
/* harmony export (immutable) */ __webpack_exports__["aapMMChanLabels"] = aapMMChanLabels;

const aapLoudMonoChanLabels = ["1(Mono)", "2(Mono)", "3(Mono)", "4(Mono)", "5(Mono)", "6(Mono)", "7(Mono)", "8(Mono)"];
/* harmony export (immutable) */ __webpack_exports__["aapLoudMonoChanLabels"] = aapLoudMonoChanLabels;

const aapLoud4x2ChanLabels = ["1(1L)", "2(1R)", "3(2L)", "4(2R)", "5(3L)", "6(3R)", "7(4L)", "8(4R)"];
/* harmony export (immutable) */ __webpack_exports__["aapLoud4x2ChanLabels"] = aapLoud4x2ChanLabels;

const aapLoud5_2ChanLabels = ["1(1L)", "2(1R)", "3(1C)", "4(1LFE)", "5(1Ls)", "6(1Rs)", "7(2L)", "8(2R)"];
/* harmony export (immutable) */ __webpack_exports__["aapLoud5_2ChanLabels"] = aapLoud5_2ChanLabels;

const aapDolbyeEncChanLabels = ["1", "2"];
/* harmony export (immutable) */ __webpack_exports__["aapDolbyeEncChanLabels"] = aapDolbyeEncChanLabels;

const aapDolbyeDecChanLabels = ["1", "2", "3", "4", "5", "6", "7", "8"];
/* harmony export (immutable) */ __webpack_exports__["aapDolbyeDecChanLabels"] = aapDolbyeDecChanLabels;


function algorithmIdToString (id)
{
  if ((ALGORITHM_MIN <= id) && (id <= ALGORITHM_MAX))
  {
    return aapAudAlgoLabels[id];
  }
  else
  {
    return aapAudAlgoLabels[ALGORITHM_UNKNOWN];
  }
}

// SFP types (from processor_schema.json)
const SFP_TYPE_UNUSED = 0;
/* harmony export (immutable) */ __webpack_exports__["SFP_TYPE_UNUSED"] = SFP_TYPE_UNUSED;

const SFP_TYPE_2RX_3G = 1;
/* harmony export (immutable) */ __webpack_exports__["SFP_TYPE_2RX_3G"] = SFP_TYPE_2RX_3G;

const SFP_TYPE_2RX_12G = 2;
/* harmony export (immutable) */ __webpack_exports__["SFP_TYPE_2RX_12G"] = SFP_TYPE_2RX_12G;

const SFP_TYPE_RX_HDMI = 3;
/* harmony export (immutable) */ __webpack_exports__["SFP_TYPE_RX_HDMI"] = SFP_TYPE_RX_HDMI;

const SFP_TYPE_2RX_MADI = 4;
/* harmony export (immutable) */ __webpack_exports__["SFP_TYPE_2RX_MADI"] = SFP_TYPE_2RX_MADI;

const SFP_TYPE_2TX_3G = 5;
/* harmony export (immutable) */ __webpack_exports__["SFP_TYPE_2TX_3G"] = SFP_TYPE_2TX_3G;

const SFP_TYPE_2TX_12G = 6;
/* harmony export (immutable) */ __webpack_exports__["SFP_TYPE_2TX_12G"] = SFP_TYPE_2TX_12G;

const SFP_TYPE_TX_12G_HDMI = 7;
/* harmony export (immutable) */ __webpack_exports__["SFP_TYPE_TX_12G_HDMI"] = SFP_TYPE_TX_12G_HDMI;

const SFP_TYPE_2TX_MADI = 8;
/* harmony export (immutable) */ __webpack_exports__["SFP_TYPE_2TX_MADI"] = SFP_TYPE_2TX_MADI;

const SFP_TYPE_UNKNOWN = 9;
/* harmony export (immutable) */ __webpack_exports__["SFP_TYPE_UNKNOWN"] = SFP_TYPE_UNKNOWN;

const SFP_TYPE_NOT_PRESENT = 10;
/* harmony export (immutable) */ __webpack_exports__["SFP_TYPE_NOT_PRESENT"] = SFP_TYPE_NOT_PRESENT;


const AAP_CONFIG_IDX_UM = 1;
/* harmony export (immutable) */ __webpack_exports__["AAP_CONFIG_IDX_UM"] = AAP_CONFIG_IDX_UM;

const AAP_CONFIG_IDX_DM = 2;
/* harmony export (immutable) */ __webpack_exports__["AAP_CONFIG_IDX_DM"] = AAP_CONFIG_IDX_DM;

const AAP_CONFIG_IDX_MM = 3;
/* harmony export (immutable) */ __webpack_exports__["AAP_CONFIG_IDX_MM"] = AAP_CONFIG_IDX_MM;

const AAP_CONFIG_IDX_LC = 4;
/* harmony export (immutable) */ __webpack_exports__["AAP_CONFIG_IDX_LC"] = AAP_CONFIG_IDX_LC;

const AAP_CONFIG_IDX_UMLC = 5;
/* harmony export (immutable) */ __webpack_exports__["AAP_CONFIG_IDX_UMLC"] = AAP_CONFIG_IDX_UMLC;

const AAP_CONFIG_IDX_DMLC = 6;
/* harmony export (immutable) */ __webpack_exports__["AAP_CONFIG_IDX_DMLC"] = AAP_CONFIG_IDX_DMLC;

const AAP_CONFIG_IDX_MMLC = 7;
/* harmony export (immutable) */ __webpack_exports__["AAP_CONFIG_IDX_MMLC"] = AAP_CONFIG_IDX_MMLC;

const AAP_CONFIG_IDX_DEE = 8;
/* harmony export (immutable) */ __webpack_exports__["AAP_CONFIG_IDX_DEE"] = AAP_CONFIG_IDX_DEE;

const AAP_CONFIG_IDX_DED = 9;
/* harmony export (immutable) */ __webpack_exports__["AAP_CONFIG_IDX_DED"] = AAP_CONFIG_IDX_DED;

/*@if (@ENABLE_DEE_COMBO)
export const AAP_CONFIG_IDX_DEELC = 10;
@end*/

// Chassis types (from SystemStatus_schema.json)
const SNP_CLASSIC = 0;
/* harmony export (immutable) */ __webpack_exports__["SNP_CLASSIC"] = SNP_CLASSIC;

const SNP_DELUXE = 1;
/* harmony export (immutable) */ __webpack_exports__["SNP_DELUXE"] = SNP_DELUXE;

const SNP_XL = 2;
/* harmony export (immutable) */ __webpack_exports__["SNP_XL"] = SNP_XL;


// Feature Flags (Use Names from snp_globals.h)
const FFLAG_MCL_FX_ENABLED = 0;
/* harmony export (immutable) */ __webpack_exports__["FFLAG_MCL_FX_ENABLED"] = FFLAG_MCL_FX_ENABLED;



/***/ }),

/***/ "./app/view-menu/console/cfg-console.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular = __webpack_require__("./node_modules/angular/index.js");
var cfgConsoleService = (function () {
    function cfgConsoleService($http, $q, commonUtils, REST_ENDPOINT) {
        this.$http = $http;
        this.$q = $q;
        this.commonUtils = commonUtils;
        this.REST_ENDPOINT = REST_ENDPOINT;
        this.myFactory = {};
        this.uploadConfigs = function (fd) {
            return this.$http({
                url: this.REST_ENDPOINT.URI + 'console/configsImport',
                data: fd,
                method: 'POST',
                transformRequest: angular.identity,
                headers: {
                    'Content-Type': undefined
                }
            }).then(function (response) {
                return response.data.data;
            }, function (response) {
                return this.$q.reject(response.statusText);
            });
        };
        this.getConfigs = function (options) {
            return this.$http({
                url: this.REST_ENDPOINT.URI + 'console/configs',
                method: "POST",
                data: options,
                transformResponse: [
                    this.commonUtils.plainResponse,
                ]
            }).then(null, function (response) {
                return this.$q.reject(response.statusText);
            });
        };
        this.applyConfigs = function (options) {
            return this.$http({
                url: this.REST_ENDPOINT.URI + 'console/configsApply',
                method: "POST",
                data: options,
                transformResponse: [
                    this.commonUtils.plainResponse,
                ]
            }).then(null, function (response) {
                return this.$q.reject(response.statusText);
            });
        };
        this.downloadConfigs = function () {
            return this.$http({
                url: this.REST_ENDPOINT.URI + 'console/configFile',
                method: "GET",
                responseType: 'arraybuffer'
            }).then(function (response) {
                return response;
            }, function (response) {
                return this.$q.reject(response.statusText);
            });
        };
    }
    cfgConsoleService.prototype.$onInit = function () {
        this.myFactory = {
            toggleSsh: this.toggleSsh,
            getStatus: this.getStatus,
            setConfig: this.setConfig,
            upgrade: this.upgrade,
            uploadConfigs: this.uploadConfigs,
            getDebugLogs: this.getDebugLogs,
            downloadDebugLogs: this.downloadDebugLogs,
            getConfigs: this.getConfigs,
            applyConfigs: this.applyConfigs,
            downloadConfigs: this.downloadConfigs,
            //importConfigs: this.importConfigs,
            reboot: this.reboot,
            configReset: this.configReset,
            factoryReset: this.factoryReset,
            setLogLevel: this.setLogLevel,
        };
    };
    cfgConsoleService.prototype.toggleSsh = function () {
        return this.$http({
            url: this.REST_ENDPOINT.URI + "console/togglessh",
            method: "POST",
            transformResponse: [this.commonUtils.plainResponse],
        })
            .success(function (response) {
            return JSON.parse(response);
        })
            .error(function (response) {
            return {
                status: "failed!"
            };
        });
    };
    cfgConsoleService.prototype.getStatus = function () {
        var _this = this;
        return this.$http({
            url: this.REST_ENDPOINT.URI + "console/status",
            method: "GET",
            transformResponse: [this.commonUtils.plainResponse],
        }).then(function (response) {
            return response.data;
        }, function (response) {
            return _this.$q.reject(response.statusText);
        });
    };
    cfgConsoleService.prototype.setConfig = function (config) {
        var _this = this;
        return this.$http({
            url: this.REST_ENDPOINT.URI + "console/setconfig",
            method: "POST",
            data: config,
            transformResponse: [this.commonUtils.plainResponse],
        }).then(null, function (response) {
            return _this.$q.reject(response.statusText);
        });
    };
    cfgConsoleService.prototype.upgrade = function (firmwareUserPath) {
        var _this = this;
        var fd = new FormData();
        fd.append("firmwareUpload", firmwareUserPath);
        return this.$http({
            url: this.REST_ENDPOINT.URI + "console/upgrade",
            data: fd,
            method: "POST",
            transformRequest: angular.identity,
            headers: {
                "Content-Type": undefined,
            },
        }).then(function (response) {
            return response.data.data;
        }, function (response) {
            return _this.$q.reject(response.statusText);
        });
    };
    cfgConsoleService.prototype.getDebugLogs = function () {
        var _this = this;
        return this.$http({
            url: this.REST_ENDPOINT.URI + "console/logs",
            method: "GET",
            transformResponse: [this.commonUtils.plainResponse],
        }).then(null, function (response) {
            return _this.$q.reject(response.statusText);
        });
    };
    cfgConsoleService.prototype.downloadDebugLogs = function () {
        var _this = this;
        return this.$http({
            url: this.REST_ENDPOINT.URI + "console/logfile",
            method: "GET",
            responseType: "arraybuffer",
        }).then(function (response) {
            return response;
        }, function (response) {
            return _this.$q.reject(response.statusText);
        });
    };
    //importConfigs = function () {
    //  var fd = new FormData();
    //  fd.append('firmwareUpload', firmwareUserPath);
    //  return this.$http({
    //    url: this.REST_ENDPOINT.URI + 'console/upgrade',
    //    data: fd,
    //    method: 'POST',
    //    transformRequest: angular.identity,
    //    headers: {
    //      'Content-Type': undefined
    //    }
    //  }).then(
    //    function (response) {
    //      return response.data.data;
    //    }, function (response) {
    //      return this.$q.reject(response.statusText);
    //    });
    //}
    cfgConsoleService.prototype.reboot = function () {
        var _this = this;
        return this.$http({
            url: this.REST_ENDPOINT.URI + "console/reboot",
            method: "POST",
            transformResponse: [this.commonUtils.plainResponse],
        }).then(null, function (response) {
            return _this.$q.reject(response.statusText);
        });
    };
    cfgConsoleService.prototype.configReset = function () {
        var _this = this;
        return this.$http({
            url: this.REST_ENDPOINT.URI + "console/confreset",
            method: "POST",
            transformResponse: [this.commonUtils.plainResponse],
        }).then(null, function (response) {
            return _this.$q.reject(response.statusText);
        });
    };
    cfgConsoleService.prototype.factoryReset = function () {
        var _this = this;
        return this.$http({
            url: this.REST_ENDPOINT.URI + "console/factreset",
            method: "POST",
            transformResponse: [this.commonUtils.plainResponse],
        }).then(null, function (response) {
            return _this.$q.reject(response.statusText);
        });
    };
    cfgConsoleService.prototype.setLogLevel = function (level) {
        var _this = this;
        return this.$http({
            url: this.REST_ENDPOINT.URI + "console/loglevel",
            method: "POST",
            data: level,
            transformResponse: [this.commonUtils.plainResponse],
        }).then(null, function (response) {
            return _this.$q.reject(response.statusText);
        });
    };
    return cfgConsoleService;
}());
exports.cfgConsoleService = cfgConsoleService;


/***/ }),

/***/ "./app/view-menu/console/cfg-ctrl-link-bonding/cfg-ctrl-link-bonding.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var cfg_ctrl_link_bonding_controller_1 = __webpack_require__("./app/view-menu/console/cfg-ctrl-link-bonding/cfg-ctrl-link-bonding.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/console/cfg-ctrl-link-bonding/cfg-ctrl-link-bonding.template.html");
exports.CtrlLinkBondingComponent = {
    bindings: {
        status: "<",
    },
    controller: cfg_ctrl_link_bonding_controller_1.CtrlLinkBondingController,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/console/cfg-ctrl-link-bonding/cfg-ctrl-link-bonding.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var CtrlLinkBondingController = (function () {
    function CtrlLinkBondingController(cfgConsoleSrv, userManagerSrv, $scope) {
        this.cfgConsoleSrv = cfgConsoleSrv;
        this.userManagerSrv = userManagerSrv;
        this.$scope = $scope;
        this.status = {};
        this.netModeLabel = 'Retrieving...';
        this.netModes = ['bondedActiveBackup', 'bondedLACP', 'dual'];
        this.selectedNetMode = undefined;
        this.applyInProgress = false;
        this.msg = '';
        this.isErrorMsg = false;
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
    }
    CtrlLinkBondingController.prototype.$onInit = function () {
        this.updateNetModeLabel();
    };
    CtrlLinkBondingController.prototype.$onChanges = function (changes) {
        if (angular_1.isDefined(changes.status)) {
            this.updateNetModeLabel();
        }
    };
    CtrlLinkBondingController.prototype.updateNetModeLabel = function () {
        if (angular_1.isUndefined(this.status)) {
            return;
        }
        this.netModeLabel = this.getNetModeLabel(this.status.netMode);
    };
    CtrlLinkBondingController.prototype.getNetModeLabel = function (mode) {
        if (mode === 'bondedActiveBackup') {
            return 'Bonded Active/Backup';
        }
        else if (mode === 'bondedLACP') {
            return 'Bonded LACP';
        }
        else if (mode === 'dual') {
            return 'Dual Addresses';
        }
        else {
            return mode;
        }
    };
    CtrlLinkBondingController.prototype.apply = function () {
        this.applyInProgress = true;
        this.msg = '';
        this.isErrorMsg = false;
        this.cfgConsoleSrv.setConfig({
            'operation': 'set',
            'data': {
                'netMode': this.selectedNetMode
            }
        }).catch(function (errorMsg) {
            this.msg = 'Applying mode failed: ' + errorMsg;
            this.isErrorMsg = true;
        }).finally(function () {
            this.applyInProgress = false;
        });
    };
    return CtrlLinkBondingController;
}());
exports.CtrlLinkBondingController = CtrlLinkBondingController;


/***/ }),

/***/ "./app/view-menu/console/cfg-ctrl-link-bonding/cfg-ctrl-link-bonding.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/console/cfg-ctrl-link-bonding/cfg-ctrl-link-bonding.template.html?45fbcb9e76fb1361cce498128aee16b8";

/***/ }),

/***/ "./app/view-menu/console/cfg-ctrl-link-config/cfg-ctrl-link-config.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var cfg_ctrl_link_config_controller_1 = __webpack_require__("./app/view-menu/console/cfg-ctrl-link-config/cfg-ctrl-link-config.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/console/cfg-ctrl-link-config/cfg-ctrl-link-config.template.html");
exports.CtrlLinkConfigComponent = {
    bindings: {
        status: "<",
    },
    controller: cfg_ctrl_link_config_controller_1.CtrlLinkConfigController,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/console/cfg-ctrl-link-config/cfg-ctrl-link-config.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var CtrlLinkConfigController = (function () {
    function CtrlLinkConfigController(cfgConsoleSrv, userManagerSrv, $scope) {
        this.cfgConsoleSrv = cfgConsoleSrv;
        this.userManagerSrv = userManagerSrv;
        this.$scope = $scope;
        this.status = {};
        this.selectableIds = [];
        this.applyInProgress = false;
        this.msg = '';
        this.isErrorMsg = false;
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
    }
    // lifecycle
    CtrlLinkConfigController.prototype.$onInit = function () {
        this.resetDisplay();
    };
    CtrlLinkConfigController.prototype.$onChanges = function (changes) {
        if (angular_1.isDefined(changes.status)) {
            this.updateCurrentConfig();
        }
    };
    // own
    CtrlLinkConfigController.prototype.resetDisplay = function () {
        this.newConfig = {};
        this.msg = '';
        this.isErrorMsg = false;
        this.updateCurrentConfig();
    };
    CtrlLinkConfigController.prototype.updateCurrentConfig = function () {
        if (angular_1.isUndefined(this.status) || !this.status.interfaces) {
            return;
        }
        if (this.status.netMode !== 'dual') {
            this.selectableIds = ['ctrl1'];
        }
        else {
            this.selectableIds = ['ctrl1', 'ctrl2'];
        }
        if (this.selectableIds.indexOf(this.selectedId) < 0) {
            this.selectedId = "";
        }
        for (var i = 0; i < this.status.interfaces.length; ++i) {
            if (this.status.interfaces[i].id === this.selectedId) {
                this.currentConfig = this.status.interfaces[i];
                this.dhcpLabel = this.getDHCPLabel(this.currentConfig.dhcp);
                return;
            }
        }
        this.currentConfig; // for correct hiding in ng-if
        this.dhcpLabel;
    };
    CtrlLinkConfigController.prototype.onSelectId = function () {
        this.resetDisplay();
    };
    CtrlLinkConfigController.prototype.getInterfaceLabel = function (id) {
        if (id === 'ctrl1') {
            return 'Control A';
        }
        else if (id === 'ctrl2') {
            return 'Control B';
        }
        else {
            return id;
        }
    };
    CtrlLinkConfigController.prototype.getDHCPLabel = function (mode) {
        if (!!mode) {
            return 'On';
        }
        else {
            return 'Off';
        }
    };
    CtrlLinkConfigController.prototype.setDHCP = function (dhcpEnabled) {
        var _this = this;
        this.applyInProgress = true;
        this.msg = '';
        this.isErrorMsg = false;
        this.cfgConsoleSrv.setConfig({
            'operation': 'set',
            'data': {
                'interfaces': [
                    {
                        'id': this.selectedId,
                        'dhcp': !!dhcpEnabled,
                    }
                ]
            }
        }).then(function () {
            _this.msg = 'Completed setting DHCP';
            _this.isErrorMsg = false;
        }, function (errorMsg) {
            _this.msg = 'Setting DHCP failed: ' + errorMsg;
            _this.isErrorMsg = true;
        }).finally(function () {
            _this.applyInProgress = false;
        });
    };
    CtrlLinkConfigController.prototype.apply = function () {
        var _this = this;
        this.applyInProgress = true;
        this.msg = '';
        this.isErrorMsg = false;
        this.newConfig.id = this.selectedId;
        var oldIP = this.currentConfig.ip;
        var newIP = this.newConfig.ip;
        this.cfgConsoleSrv.setConfig({
            'operation': 'set',
            'data': {
                'interfaces': [this.newConfig]
            }
        }).then(function () {
            _this.msg = 'Completed applying configuration';
            _this.isErrorMsg = false;
            if (window.location.hostname === oldIP) {
                window.location.assign(window.location.href.replace(oldIP, newIP));
            }
        }, function (errorMsg) {
            _this.msg = 'Applying configuration failed: ' + errorMsg;
            _this.isErrorMsg = true;
        }).finally(function () {
            _this.applyInProgress = false;
        });
    };
    return CtrlLinkConfigController;
}());
exports.CtrlLinkConfigController = CtrlLinkConfigController;


/***/ }),

/***/ "./app/view-menu/console/cfg-ctrl-link-config/cfg-ctrl-link-config.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/console/cfg-ctrl-link-config/cfg-ctrl-link-config.template.html?3f0e39793c066032bfd7aed3c47d9353";

/***/ }),

/***/ "./app/view-menu/console/cfg-debug-logs/cfg-debug-logs.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var cfg_debug_logs_controller_1 = __webpack_require__("./app/view-menu/console/cfg-debug-logs/cfg-debug-logs.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/console/cfg-debug-logs/cfg-debug-logs.template.html");
exports.DebugLogsComponent = {
    bindings: {
        status: "<",
    },
    controller: cfg_debug_logs_controller_1.DebugLogsController,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/console/cfg-debug-logs/cfg-debug-logs.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var DebugLogsController = (function () {
    function DebugLogsController(cfgConsoleSrv, userManagerSrv, $scope) {
        this.cfgConsoleSrv = cfgConsoleSrv;
        this.userManagerSrv = userManagerSrv;
        this.$scope = $scope;
        this.usrMgrSrv = undefined;
        this.callInProgress = false;
        this.msg = '';
        this.isErrorMsg = false;
        this.usrMgrSrv = userManagerSrv;
    }
    DebugLogsController.prototype.isAdminOrOper = function () {
        var rtv = false;
        var groupName = this.usrMgrSrv.getCurUserGroup().name;
        if (groupName !== undefined) {
            rtv = (groupName === "Administrator" || groupName === "Operator");
        }
        return rtv;
    };
    DebugLogsController.prototype.collect = function () {
        var _this = this;
        this.callInProgress = true;
        this.msg = '';
        this.isErrorMsg = false;
        this.cfgConsoleSrv.getDebugLogs().catch(function (errorMsg) {
            _this.msg = 'Log collection failed: ' + errorMsg;
            _this.isErrorMsg = true;
        }).finally(function () {
            _this.callInProgress = false;
        });
    };
    DebugLogsController.prototype.downloadLogs = function () {
        var _this = this;
        this.cfgConsoleSrv.downloadDebugLogs().then(function (res) {
            var link = document.createElement('a');
            var blob = new Blob([res.data], {
                type: "application/octet-stream"
            });
            link.style.display = 'none';
            link.setAttribute('href', window.URL.createObjectURL(blob));
            link.download = _this.status.debugLogs.archiveName;
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        });
    };
    return DebugLogsController;
}());
exports.DebugLogsController = DebugLogsController;


/***/ }),

/***/ "./app/view-menu/console/cfg-debug-logs/cfg-debug-logs.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/console/cfg-debug-logs/cfg-debug-logs.template.html?5d3e6376838bfb810b7392affbf92019";

/***/ }),

/***/ "./app/view-menu/console/cfg-export/cfg-export.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var cfg_export_controller_1 = __webpack_require__("./app/view-menu/console/cfg-export/cfg-export.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/console/cfg-export/cfg-export.template.html");
exports.ConfigsExportComponent = {
    bindings: {
        status: "<",
    },
    controller: cfg_export_controller_1.ConfigsExportCtrl,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/console/cfg-export/cfg-export.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ConfigsExportCtrl = (function () {
    function ConfigsExportCtrl(cfgConsoleSrv, userManagerSrv, $scope) {
        this.cfgConsoleSrv = cfgConsoleSrv;
        this.userManagerSrv = userManagerSrv;
        this.$scope = $scope;
        this.ctrl = this;
        this.callInProgress = false;
        this.exportCtrlProgress = false;
        this.msg = '';
        this.isErrorMsg = false;
        this.options = [
            {
                "name": "configs",
                "label": "Parameter & Alarm Settings",
                "selected": false
            },
            {
                "name": "luts",
                "label": "HDR LUTs",
                "selected": false
            },
            {
                "name": "layouts",
                "label": "MV Layouts",
                "selected": false
            },
            {
                "name": "presets",
                "label": "Saved Presets",
                "selected": false
            },
            {
                "name": "lsmm",
                "label": "Local User Database",
                "selected": false
            },
            {
                "name": "ipsettings",
                "label": "Control Network IP Settings",
                "selected": false
            }
        ];
        this.downloadConfigs = function () {
            var _this = this;
            this.cfgConsoleSrv.downloadConfigs().then(function (res) {
                var link = document.createElement('a');
                var blob = new Blob([res.data], {
                    type: "application/octet-stream"
                });
                link.style.display = 'none';
                link.setAttribute('href', window.URL.createObjectURL(blob));
                link.download = _this.status.configsExport.archiveName;
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
            });
        };
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
    }
    ConfigsExportCtrl.prototype.collectConfigs = function () {
        var _this = this;
        this.callInProgress = this.exportCtrlProgress = true;
        setTimeout(function () {
            _this.exportCtrlProgress = false;
        }, 3000);
        this.msg = '';
        this.isErrorMsg = false;
        this.cfgConsoleSrv.getConfigs(this.options).catch(function (errorMsg) {
            _this.msg = 'Settings & data collection failed: ' + errorMsg;
            _this.isErrorMsg = true;
        }).finally(function () {
            _this.callInProgress = false;
        });
    };
    return ConfigsExportCtrl;
}());
exports.ConfigsExportCtrl = ConfigsExportCtrl;


/***/ }),

/***/ "./app/view-menu/console/cfg-export/cfg-export.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/console/cfg-export/cfg-export.template.html?38998abdb4c1c5cb270f69c9a496238b";

/***/ }),

/***/ "./app/view-menu/console/cfg-import/cfg-import.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var cfg_import_controller_1 = __webpack_require__("./app/view-menu/console/cfg-import/cfg-import.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/console/cfg-import/cfg-import.template.html");
exports.ConfigsImportComponent = {
    bindings: {
        status: "<",
    },
    controller: cfg_import_controller_1.ConfigsImportCtrl,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/console/cfg-import/cfg-import.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ConfigsImportCtrl = (function () {
    function ConfigsImportCtrl(cfgConsoleSrv, uiModalsSrv, userManagerSrv, $scope) {
        var _this = this;
        this.cfgConsoleSrv = cfgConsoleSrv;
        this.uiModalsSrv = uiModalsSrv;
        this.userManagerSrv = userManagerSrv;
        this.$scope = $scope;
        this.ctrl = this;
        this.uploadInProgress = false;
        this.callInProgress = false;
        this.importCtrlProgress = false;
        this.applyCtrlProgress = false;
        this.msg = '';
        this.isErrorMsg = false;
        this.configsArchive = undefined;
        this.options = [
            {
                "name": "configs",
                "label": "Parameter & Alarm Settings",
                "selected": false
            },
            {
                "name": "luts",
                "label": "HDR LUTs",
                "selected": false
            },
            {
                "name": "layouts",
                "label": "MV Layouts",
                "selected": false
            },
            {
                "name": "presets",
                "label": "Saved Presets",
                "selected": false
            },
            {
                "name": "lsmm",
                "label": "Local User Database",
                "selected": false
            },
            {
                "name": "ipsettings",
                "label": "Control Network IP Settings",
                "selected": false
            }
        ];
        this.upload = function () {
            var _this = this;
            this.uploadInProgress = this.importCtrlProgress = true;
            this.isErrMsg = false;
            this.msg = '';
            setTimeout(function () {
                _this.importCtrlProgress = false;
            }, 3000);
            var fd = new FormData();
            fd.append("configsArchive", this.configsArchive);
            this.cfgConsoleSrv.uploadConfigs(fd).finally(function () {
                this.uploadInProgress = false;
            });
        };
        this.onImportReboot = function () {
            _this.cfgConsoleSrv.applyConfigs(_this.options).catch(function (errorMsg) {
                _this.isErrorMsg = true;
            }).finally(function () {
                setTimeout(function () {
                    _this.callInProgress = false;
                    _this.applyCtrlProgress = false;
                    _this.isErrorMsg = false;
                }, 2000);
            });
        };
        this.cancelledImport = function () {
            _this.callInProgress = false;
            _this.msg = '';
            _this.isErrorMsg = false;
            _this.applyCtrlProgress = false;
        };
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
    }
    ConfigsImportCtrl.prototype.onApplyConfigsReboot = function () {
        this.callInProgress = this.applyCtrlProgress = true;
        //setTimeout(() => { this.applyCtrlProgress = false }, 3000)
        this.msg = '';
        this.isErrorMsg = false;
        this.uiModalsSrv.openConfirmModal({
            title: "Reboot",
            msg: "Note: Imported data will remove & replace existing data for each of 'Parameter & Alarm Settings', 'Local User Database; and 'Saved Presets'.  Are you sure you want to apply settings & data and reboot? ",
            buttons: [
                {
                    label: "Yes",
                    callback: this.onImportReboot,
                },
                {
                    label: "No",
                    callback: this.cancelledImport,
                },
            ],
        });
    };
    return ConfigsImportCtrl;
}());
exports.ConfigsImportCtrl = ConfigsImportCtrl;


/***/ }),

/***/ "./app/view-menu/console/cfg-import/cfg-import.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/console/cfg-import/cfg-import.template.html?4f6df22d9c105b07f95a4a735515e72a";

/***/ }),

/***/ "./app/view-menu/console/cfg-import/config-tar-file-input.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigsTarFileInputDirective = function ($parse) {
    return {
        restrict: "A",
        link: function (scope, elm, attrs) {
            var getter = $parse(attrs.configTarFile);
            var setter = getter.assign;
            elm.bind("change", function (event) {
                scope.$apply(function () {
                    //     object with prop
                    //            new-value
                    setter(scope, elm[0].files[0]);
                });
            });
        }
    };
};


/***/ }),

/***/ "./app/view-menu/console/cfg-password/cfg-password.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var cfg_password_controller_1 = __webpack_require__("./app/view-menu/console/cfg-password/cfg-password.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/console/cfg-password/cfg-password.template.html");
exports.CfgPasswordConfigComponent = {
    bindings: {
        status: "<",
    },
    controller: cfg_password_controller_1.CfgPasswordConfigController,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/console/cfg-password/cfg-password.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var CfgPasswordConfigController = (function () {
    function CfgPasswordConfigController(passwordConfigSrv, uiModalsSrv, userManagerSrv, $scope) {
        this.passwordConfigSrv = passwordConfigSrv;
        this.uiModalsSrv = uiModalsSrv;
        this.userManagerSrv = userManagerSrv;
        this.$scope = $scope;
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
    }
    CfgPasswordConfigController.prototype.$onInit = function () {
        var initials = {
            isInProgress: false,
            msg: "",
            isErrorMsg: false,
        };
        this.root = Object.assign({}, initials);
        this.user = Object.assign({}, initials);
        this.resetPassword = Object.assign({}, initials);
        this.onSetUserPassword = this.handlerFactory("user");
        this.onSetRootPassword = this.handlerFactory("root");
    };
    CfgPasswordConfigController.prototype.clearMsg = function (target) {
        var _this = this;
        setTimeout(function () {
            _this[target].isErrorMsg = false;
            _this[target].msg = "";
        }, 10000);
    };
    CfgPasswordConfigController.prototype.handlerFactory = function (userType) {
        var _this = this;
        var targetUserCapital = userType.charAt(0).toUpperCase() + userType.slice(1);
        return function () {
            if (!_this["old" + targetUserCapital + "Password"] ||
                !_this["new" + targetUserCapital + "Password"] ||
                !_this["new" + targetUserCapital + "Password2"]) {
                _this[userType].isErrorMsg = true;
                _this[userType].msg = "Please fill required field(s).";
                _this.clearMsg(userType);
            }
            else if (_this["new" + targetUserCapital + "Password"] !==
                _this["new" + targetUserCapital + "Password2"]) {
                _this[userType].isErrorMsg = true;
                _this[userType].msg = "Passwords do not match.";
                _this.clearMsg(userType);
            }
            else {
                _this.uiModalsSrv.openConfirmModal({
                    title: "Set " + userType + " password",
                    msg: "Password for " + userType + " will be set. Proceed?",
                    buttons: [
                        {
                            label: "Yes",
                            callback: function () {
                                _this[userType].isInProgress = true;
                                _this.passwordConfigSrv["set" + targetUserCapital + "Password"](_this["old" + targetUserCapital + "Password"], _this["new" + targetUserCapital + "Password"])
                                    .then(function (response) {
                                    if (response.data.status === "ok") {
                                        _this[userType].isErrorMsg = false;
                                        _this[userType].msg = "Password set successfully";
                                        _this["old" + targetUserCapital + "Password"] = "";
                                        _this["new" + targetUserCapital + "Password"] = "";
                                        _this["new" + targetUserCapital + "Password2"] = "";
                                        _this.clearMsg(userType);
                                    }
                                    else {
                                        _this[userType].isErrorMsg = true;
                                        _this[userType].msg =
                                            response.data.status === "wrong_password" ?
                                                "Current password is wrong" :
                                                "Failed to set new password";
                                        _this.clearMsg(userType);
                                    }
                                }, function () {
                                    _this[userType].isErrorMsg = true;
                                    _this[userType].msg = "Failed to set new password";
                                    _this.clearMsg(userType);
                                })
                                    .finally(function () {
                                    _this[userType].isInProgress = false;
                                });
                            },
                        },
                        {
                            label: "No",
                        },
                    ],
                });
            }
        };
    };
    CfgPasswordConfigController.prototype.startPasswordReset = function () {
        var _this = this;
        this.resetPassword.isInProgress = true;
        this.passwordConfigSrv
            .resetPassword()
            .then(function (response) {
            if (JSON.parse(response.data).status === "password reset done") {
                _this.resetPassword.isErrorMsg = false;
                _this.resetPassword.msg = "Passwords reset successfully";
                _this.clearMsg("resetPassword");
            }
            else {
                _this.resetPassword.isErrorMsg = true;
                _this.resetPassword.msg = "Failed to reset passwords";
                _this.clearMsg("resetPassword");
            }
        }, function () {
            _this.resetPassword.isErrorMsg = true;
            _this.resetPassword.msg = "Failed to reset passwords";
            _this.clearMsg("resetPassword");
        })
            .finally(function () {
            _this.resetPassword.isInProgress = false;
        });
    };
    CfgPasswordConfigController.prototype.onResetPasswords = function () {
        var _this = this;
        this.uiModalsSrv.openConfirmModal({
            title: "Reset passwords",
            msg: "Passwords for root and user will be reset. Proceed?",
            buttons: [
                {
                    label: "Yes",
                    callback: function () {
                        _this.startPasswordReset();
                    }
                },
                {
                    label: "No",
                },
            ],
        });
    };
    return CfgPasswordConfigController;
}());
exports.CfgPasswordConfigController = CfgPasswordConfigController;


/***/ }),

/***/ "./app/view-menu/console/cfg-password/cfg-password.service.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var CfgPasswordConfigService = (function () {
    function CfgPasswordConfigService($http, commonUtils, REST_ENDPOINT) {
        var _this = this;
        this.$http = $http;
        this.commonUtils = commonUtils;
        this.REST_ENDPOINT = REST_ENDPOINT;
        this.myFactory = {};
        this.setUserPassword = function (old_password, password) {
            return _this.$http.post(_this.url + "console/userpassword", {
                old_password: old_password,
                password: password,
            });
        };
        this.setRootPassword = function (old_password, password) {
            return _this.$http.post(_this.url + "console/rootpassword", {
                old_password: old_password,
                password: password,
            });
        };
        this.url = this.REST_ENDPOINT.URI;
    }
    CfgPasswordConfigService.prototype.$onInit = function () {
        this.myFactory = {
            setUserPassword: this.setUserPassword,
            setRootPassword: this.setRootPassword,
            resetPassword: this.resetPassword,
        };
    };
    CfgPasswordConfigService.prototype.resetPassword = function () {
        return this.$http({
            url: this.url + "console/resetpass",
            method: "POST",
            transformResponse: [this.commonUtils.plainResponse],
        })
            .success(function (response) {
            return JSON.parse(response);
        })
            .error(function (response) {
            return {
                status: "password reset failed!"
            };
        });
    };
    ;
    return CfgPasswordConfigService;
}());
exports.CfgPasswordConfigService = CfgPasswordConfigService;


/***/ }),

/***/ "./app/view-menu/console/cfg-password/cfg-password.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/console/cfg-password/cfg-password.template.html?a6d9e9a8dd3e58ddfb2d751aa689a9a3";

/***/ }),

/***/ "./app/view-menu/console/cfg-services-control/cfg-services-control.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var templateUrl = __webpack_require__("./app/view-menu/console/cfg-services-control/cfg-services-control.template.html");
exports.ServicesControlComponent = {
    bindings: {
        status: "<",
    },
    controller: function () { },
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/console/cfg-services-control/cfg-services-control.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/console/cfg-services-control/cfg-services-control.template.html?abf4a2d190fdc66987e47e8883e573af";

/***/ }),

/***/ "./app/view-menu/console/cfg-services-control/service-toggle-switch/service-toggle-switch.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var service_toggle_switch_controller_1 = __webpack_require__("./app/view-menu/console/cfg-services-control/service-toggle-switch/service-toggle-switch.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/console/cfg-services-control/service-toggle-switch/service-toggle-switch.template.html");
exports.ServiceToggleSwitchComponent = {
    bindings: {
        status: '<',
        uiName: '@',
        service: '@',
    },
    controller: service_toggle_switch_controller_1.ServiceToggleSwitchController,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/console/cfg-services-control/service-toggle-switch/service-toggle-switch.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ServiceToggleSwitchController = (function () {
    function ServiceToggleSwitchController(cfgConsoleSrv, userManagerSrv, $scope) {
        this.cfgConsoleSrv = cfgConsoleSrv;
        this.userManagerSrv = userManagerSrv;
        this.$scope = $scope;
        this.uiServiceNames = {
            ssh: "SSH",
            telnet: "Telnet",
            inetd: "FTP",
        };
        this.toggleState = {
            isInProgress: false,
            msg: "",
            isErrorMsg: false,
        };
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
    }
    // lifecycle
    ServiceToggleSwitchController.prototype.$onInit = function () { };
    // own
    ServiceToggleSwitchController.prototype.onToggle = function (service) {
        this.handleServiceToggle(service);
    };
    ServiceToggleSwitchController.prototype.clearMsg = function () {
        var _this = this;
        setTimeout(function () {
            _this.toggleState.msg = "";
            _this.toggleState.isErrorMsg = false;
        }, 10000);
    };
    ServiceToggleSwitchController.prototype.handleServiceToggle = function (service) {
        var _this = this;
        this.toggleState.isInProgress = true;
        var methodToCall = "toggle" + service.charAt(0).toUpperCase() + service.slice(1);
        this.cfgConsoleSrv[methodToCall]()
            .then(function (response) {
            if (JSON.parse(response.data).status === "ok") {
                _this.toggleState.msg = "Operation succeeded";
                _this.toggleState.isErrorMsg = false;
                _this.status.services[service].isRunning = !_this.status.services[service].isRunning;
                _this.clearMsg();
            }
            else {
                _this.toggleState.msg = "Operation failed";
                _this.toggleState.isErrorMsg = true;
                _this.clearMsg();
            }
        }, function () {
            _this.toggleState.msg = "Operation failed";
            _this.toggleState.isErrorMsg = true;
            _this.clearMsg();
        })
            .finally(function () {
            _this.toggleState.isInProgress = false;
        });
    };
    return ServiceToggleSwitchController;
}());
exports.ServiceToggleSwitchController = ServiceToggleSwitchController;


/***/ }),

/***/ "./app/view-menu/console/cfg-services-control/service-toggle-switch/service-toggle-switch.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/console/cfg-services-control/service-toggle-switch/service-toggle-switch.template.html?7ed431a6076758d13bd74e792697e6d7";

/***/ }),

/***/ "./app/view-menu/console/cfg-sys-control/cfg-sys-control.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var cfg_sys_control_controller_1 = __webpack_require__("./app/view-menu/console/cfg-sys-control/cfg-sys-control.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/console/cfg-sys-control/cfg-sys-control.template.html");
exports.SysControlComponent = {
    bindings: {
        status: "<",
        isReconnected: "<",
    },
    controller: cfg_sys_control_controller_1.SysControlConrtoller,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/console/cfg-sys-control/cfg-sys-control.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var SysControlConrtoller = (function () {
    function SysControlConrtoller(cfgConsoleSrv, uiModalsSrv, userManagerSrv, $scope) {
        var _this = this;
        this.cfgConsoleSrv = cfgConsoleSrv;
        this.uiModalsSrv = uiModalsSrv;
        this.userManagerSrv = userManagerSrv;
        this.$scope = $scope;
        this.IDLE = "IDLE";
        this.CALLING_REBOOT = "CALLING_REBOOT";
        this.STARTED_REBOOT = "STARTED_REBOOT";
        this.CALLING_CONFIG_RESET = "CALLING_CONFIG_RESET";
        this.STARTED_CONFIG_RESET = "STARTED_CONFIG_RESET";
        this.CALLING_FACTORY_RESET = "CALLING_FACTORY_RESET";
        this.STARTED_FACTORY_RESET = "STARTED_FACTORY_RESET";
        this.disableResetButtons = false;
        this.state = this.IDLE;
        this.waitDialogConfig = {
            msg: "",
            isErrorMsg: false,
            isInProgress: false
        };
        this.toIdle = function () {
            _this.state = _this.IDLE;
            _this.closeWaitDialog();
            _this.updateView();
        };
        this.rebootCallback = function () {
            _this.state = _this.CALLING_REBOOT;
            _this.cfgConsoleSrv.reboot().then(_this.rebootCallbackSuccess, _this.rebootCallbackFail);
            _this.updateView();
        };
        this.rebootCallbackSuccess = function () {
            _this.state = _this.STARTED_REBOOT;
            _this.showRebootWaitDialog();
            _this.updateView();
        };
        this.rebootCallbackFail = function (errorMsg) {
            _this.showRebootWaitDialog();
            _this.waitDialogConfig.msg = "Reboot failure: " + errorMsg;
            _this.waitDialogConfig.isErrorMsg = true;
            _this.waitDialogConfig.isInProgress = false;
        };
        this.configResetCallback = function () {
            _this.state = _this.CALLING_CONFIG_RESET;
            _this.showResetWaitDialog();
            _this.cfgConsoleSrv
                .configReset()
                .then(_this.configResetCallbackSuccess, _this.configResetCallbackFail);
            _this.updateView();
        };
        this.configResetCallbackSuccess = function () {
            _this.state = _this.STARTED_CONFIG_RESET;
            _this.showResetWaitDialog();
            _this.updateView();
        };
        this.configResetCallbackFail = function (errorMsg) {
            _this.waitDialogConfig.msg = "Failure restoring defaults: " + errorMsg;
            _this.waitDialogConfig.isErrorMsg = true;
            _this.waitDialogConfig.isInProgress = false;
        };
        this.factoryResetCallback = function () {
            _this.state = _this.CALLING_FACTORY_RESET;
            _this.showFactoryResetWaitDialog();
            _this.cfgConsoleSrv
                .factoryReset()
                .then(_this.factoryResetCallbackSuccess, _this.factoryResetCallbackFail);
            _this.updateView();
        };
        this.factoryResetCallbackSuccess = function () {
            _this.state = _this.STARTED_FACTORY_RESET;
            _this.showFactoryResetWaitDialog();
            _this.updateView();
        };
        this.factoryResetCallbackFail = function (errorMsg) {
            _this.waitDialogConfig.msg = "Factory reset failed: " + errorMsg;
            _this.waitDialogConfig.isErrorMsg = true;
            _this.waitDialogConfig.isInProgress = false;
        };
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
    }
    // lifecycle
    SysControlConrtoller.prototype.$onInit = function () {
        this.updateView();
    };
    SysControlConrtoller.prototype.$onChanges = function (changes) {
        this.updateState();
        this.updateView();
    };
    // own
    SysControlConrtoller.prototype.updateState = function () {
        if (angular_1.isUndefined(this.status)) {
            return;
        }
        if (this.state === this.IDLE) {
            if (this.status &&
                this.status.factoryReset &&
                this.status.factoryReset.isInProgress) {
                this.factoryResetCallbackSuccess();
            }
            else if (this.status &&
                this.status.configReset &&
                this.status.configReset.isInProgress) {
                this.configResetCallbackSuccess;
            }
        }
        if (this.state === this.STARTED_REBOOT ||
            this.state === this.STARTED_CONFIG_RESET ||
            this.state === this.STARTED_FACTORY_RESET) {
            if (this.isReconnected) {
                this.toIdle();
                window.location.reload();
            }
        }
    };
    SysControlConrtoller.prototype.updateView = function () {
        if (this.state === this.STARTED_CONFIG_RESET) {
            this.waitDialogConfig.isInProgress = this.status.configReset.isInProgress;
            if (this.status.configReset.isErrorMsg) {
                this.waitDialogConfig.msg = this.status.configReset.msg;
                this.waitDialogConfig.isErrorMsg = this.status.configReset.isErrorMsg;
            }
        }
        if (this.state === this.STARTED_FACTORY_RESET) {
            this.waitDialogConfig.isInProgress =
                this.status.factoryReset.isInProgress;
            if (this.status.factoryReset.isErrorMsg) {
                this.waitDialogConfig.msg = this.status.factoryReset.msg;
                this.waitDialogConfig.isErrorMsg = this.status.factoryReset.isErrorMsg;
            }
        }
        this.disableResetButtons =
            this.state !== this.IDLE || this.status.upgrade.isInProgress;
    };
    SysControlConrtoller.prototype.showWaitDialog = function (waitDialogConfig) {
        angular_1.copy(waitDialogConfig, this.waitDialogConfig);
        if (!angular_1.isDefined(this.waitDialog)) {
            this.waitDialog = this.uiModalsSrv.openWaitModal(this.waitDialogConfig);
        }
    };
    SysControlConrtoller.prototype.closeWaitDialog = function () {
        if (angular_1.isDefined(this.waitDialog)) {
            this.waitDialog.close();
            this.waitDialog = undefined;
        }
    };
    // REBOOT handlers section starts
    SysControlConrtoller.prototype.onReboot = function () {
        this.uiModalsSrv.openConfirmModal({
            title: "Reboot",
            msg: "The system will be rebooted. Proceed?",
            buttons: [
                {
                    label: "Yes",
                    callback: this.rebootCallback,
                },
                {
                    label: "No",
                },
            ],
        });
    };
    SysControlConrtoller.prototype.showRebootWaitDialog = function () {
        this.showWaitDialog({
            title: "Reboot",
            msg: "Rebooting...",
            isInProgress: true,
            isErrorMsg: false,
            isCompleteButtons: [
                {
                    label: "Close",
                    callback: this.toIdle,
                },
            ],
        });
    };
    // REBOOT handlers section ends
    // CONFIG RESET handlers section starts
    SysControlConrtoller.prototype.onConfigReset = function () {
        this.uiModalsSrv.openConfirmModal({
            title: "Restore Defaults",
            msg: "The current configuration will be replaced with defaults and the system will reboot. Proceed?",
            buttons: [
                {
                    label: "Yes",
                    callback: this.configResetCallback,
                },
                {
                    label: "No",
                },
            ],
        });
    };
    SysControlConrtoller.prototype.showResetWaitDialog = function () {
        this.showWaitDialog({
            title: "Restore Defaults",
            msg: "Restoring defaults...",
            isInProgress: true,
            isErrorMsg: false,
            isCompleteButtons: [
                {
                    label: "Close",
                    callback: this.toIdle,
                },
            ],
        });
    };
    // CONFIG RESET handlers section ends
    // FACTORY RESET handlers section starts
    SysControlConrtoller.prototype.onFactoryReset = function () {
        this.uiModalsSrv.openConfirmModal({
            title: "Factory Reset",
            msg: "The system will be reset to factory configuration. All current settings will be lost. Proceed?",
            buttons: [
                {
                    label: "Yes",
                    callback: this.factoryResetCallback,
                },
                {
                    label: "No",
                },
            ],
        });
    };
    SysControlConrtoller.prototype.showFactoryResetWaitDialog = function () {
        this.showWaitDialog({
            title: "Factory Reset",
            msg: "Performing factory reset...",
            isInProgress: true,
            isErrorMsg: false,
            isCompleteButtons: [
                {
                    label: "Close",
                    callback: this.toIdle,
                },
            ],
        });
    };
    return SysControlConrtoller;
}());
exports.SysControlConrtoller = SysControlConrtoller;


/***/ }),

/***/ "./app/view-menu/console/cfg-sys-control/cfg-sys-control.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/console/cfg-sys-control/cfg-sys-control.template.html?7a79c2890440a407ea7e3612d9fdf6e4";

/***/ }),

/***/ "./app/view-menu/console/cfg-sys-info/cfg-sys-info.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var cfg_sys_info_controller_1 = __webpack_require__("./app/view-menu/console/cfg-sys-info/cfg-sys-info.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/console/cfg-sys-info/cfg-sys-info.template.html");
exports.SystemInfoComponent = {
    bindings: {
        status: "<",
    },
    controller: cfg_sys_info_controller_1.SysInfoController,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/console/cfg-sys-info/cfg-sys-info.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var SysInfoController = (function () {
    function SysInfoController() {
        this.status = {};
        this.FPGA_LOADING_FAILED_MESSAGE = "FPGA loading has failed!";
        this.XL_CHASSIS = "SNP-XL Chassis";
        this.combinedRevs = {};
    }
    SysInfoController.prototype.$onChanges = function (changes) {
        if (angular_1.isDefined(changes.status)) {
            this.updateCombinedRevs();
        }
    };
    SysInfoController.prototype.updateCombinedRevs = function () {
        var _this = this;
        var setFormatedVersion = function (of) {
            if (angular_1.isDefined(_this.status[of])) {
                if (_this.status[of].hwRev === "N/A" || _this.status[of].swRev === "N/A") {
                    _this.combinedRevs[of] = _this.FPGA_LOADING_FAILED_MESSAGE;
                }
                else {
                    _this.combinedRevs[of] = "HW-" + _this.status[of].hwRev + "/SW-" + _this.status[of].swRev;
                    if (!angular_1.isUndefined(_this.status[of].smRev) && _this.status[of].smRev !== "") {
                        _this.combinedRevs[of] += "/SM-" + _this.status[of].smRev;
                    }
                    if (_this.status[of].personality) {
                        _this.combinedRevs[of] += " " + _this.status[of].personality;
                    }
                }
            }
            else {
                _this.combinedRevs[of] = "N/A";
            }
        };
        if (angular_1.isUndefined(this.status)) {
            return;
        }
        setFormatedVersion("fpgaRevIP");
        setFormatedVersion("fpgaRevBB1");
        setFormatedVersion("fpgaRevBB2");
        setFormatedVersion("fpgaRevBB3");
        setFormatedVersion("fpgaRevBB4");
        setFormatedVersion("fpgaRevSync");
        setFormatedVersion("fpgaRevConv");
        setFormatedVersion("fpgaRevConv4");
        setFormatedVersion("fpgaRevRemap");
        setFormatedVersion("fpgaRevMv");
        setFormatedVersion("fpgaRevMvp");
        setFormatedVersion("fpgaRevJxsd");
        setFormatedVersion("fpgaRevJxse");
        setFormatedVersion("fpgaRevStat");
        setFormatedVersion("fpgaRevMcl");
        setFormatedVersion("fpgaRevTr7e");
        setFormatedVersion("fpgaRevTr7d");
        setFormatedVersion("fpgaRevTr7eu");
        setFormatedVersion("fpgaRevTr7du");
        setFormatedVersion("fpgaRevGw88");
    };
    return SysInfoController;
}());
exports.SysInfoController = SysInfoController;


/***/ }),

/***/ "./app/view-menu/console/cfg-sys-info/cfg-sys-info.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/console/cfg-sys-info/cfg-sys-info.template.html?d0daa9f7c41427cfd19df17e8a9eadec";

/***/ }),

/***/ "./app/view-menu/console/cfg-sys-logging/cfg-sys-logging.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var cfg_sys_logging_controller_1 = __webpack_require__("./app/view-menu/console/cfg-sys-logging/cfg-sys-logging.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/console/cfg-sys-logging/cfg-sys-logging.template.html");
exports.SysLoggingComponent = {
    bindings: {
        status: "<",
    },
    controller: cfg_sys_logging_controller_1.SysLoggingController,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/console/cfg-sys-logging/cfg-sys-logging.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular = __webpack_require__("./node_modules/angular/index.js");
var SysLoggingController = (function () {
    function SysLoggingController(cfgConsoleSrv, userManagerSrv, $scope) {
        this.cfgConsoleSrv = cfgConsoleSrv;
        this.userManagerSrv = userManagerSrv;
        this.$scope = $scope;
        this.logLevelLabel = "Retrieving...";
        this.remoteLoggerLabel = "Retrieving...";
        this.logLevels = ["1", "2", "3", "4", "5", "6", "7", "8"];
        this.selectedLogLevel = undefined;
        this.selectedRemoteLogger = undefined;
        this.applyLevelInProgress = false;
        this.applyRemoteInProgress = false;
        this.levelMsg = "";
        this.remoteMsg = "";
        this.isErrorLevelMsg = false;
        this.isErrorRemoteMsg = false;
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
    }
    // lifecycle
    SysLoggingController.prototype.$onInit = function () {
        this.updateLogLevelLabel();
        this.updateRemoteLoggerLabel();
    };
    SysLoggingController.prototype.$onChanges = function (changes) {
        if (angular.isDefined(changes.status)) {
            this.updateLogLevelLabel();
            this.updateRemoteLoggerLabel();
        }
    };
    // own
    SysLoggingController.prototype.updateLogLevelLabel = function () {
        if (angular.isUndefined(this.status)) {
            return;
        }
        this.logLevelLabel = this.getLogLevelLabel(this.status.logLevel);
    };
    ;
    SysLoggingController.prototype.updateRemoteLoggerLabel = function () {
        if (angular.isUndefined(this.status)) {
            return;
        }
        this.remoteLoggerLabel = this.status.remoteLogger;
    };
    ;
    SysLoggingController.prototype.getLogLevelLabel = function (level) {
        if (level === "1") {
            return "EMERGENCY";
        }
        else if (level === "2") {
            return "ALERT";
        }
        else if (level === "3") {
            return "CRITICAL";
        }
        else if (level === "4") {
            return "ERROR";
        }
        else if (level === "5") {
            return "WARNING";
        }
        else if (level === "6") {
            return "NOTICE";
        }
        else if (level === "7") {
            return "INFORMATION";
        }
        else if (level === "8") {
            return "DEBUG";
        }
        else {
            return level;
        }
    };
    ;
    SysLoggingController.prototype.apply_level = function () {
        var _this = this;
        this.applyLevelInProgress = true;
        this.levelMsg = "";
        this.isErrorLevelMsg = false;
        this.cfgConsoleSrv
            .setConfig({
            operation: "set",
            data: {
                logLevel: this.selectedLogLevel,
            },
        })
            .catch(function (errorMsg) {
            _this.levelMsg = "Applying Log Level failed: " + errorMsg;
            _this.isErrorLevelMsg = true;
        })
            .finally(function () {
            _this.applyLevelInProgress = false;
        });
    };
    ;
    SysLoggingController.prototype.apply_remote = function () {
        var _this = this;
        this.remoteMsg = "";
        this.isErrorRemoteMsg = false;
        var fields = this.selectedRemoteLogger.split(':');
        if (fields.length != 2) {
            this.remoteMsg =
                "Failed: Invalid input";
            this.isErrorRemoteMsg = true;
            this.selectedRemoteLogger = "";
            return;
        }
        var address = fields[0];
        var port = fields[1];
        if (address == "127.0.0.1" || (address == "0.0.0.0" && port != "0")) {
            this.remoteMsg =
                "Failed: Loopback not allowed";
            this.isErrorRemoteMsg = true;
            this.selectedRemoteLogger = "";
            return;
        }
        this.applyRemoteInProgress = true;
        this.cfgConsoleSrv
            .setConfig({
            operation: "set",
            data: {
                remoteLogger: this.selectedRemoteLogger,
            },
        })
            .catch(function (errorMsg) {
            _this.remoteMsg =
                "Applying Remote Logger configuration failed: " + errorMsg;
            _this.isErrorRemoteMsg = true;
        })
            .finally(function () {
            _this.applyRemoteInProgress = false;
        });
    };
    ;
    return SysLoggingController;
}());
exports.SysLoggingController = SysLoggingController;


/***/ }),

/***/ "./app/view-menu/console/cfg-sys-logging/cfg-sys-logging.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/console/cfg-sys-logging/cfg-sys-logging.template.html?59a7cfcae5e340d0202c5967b1d0cc3d";

/***/ }),

/***/ "./app/view-menu/console/cfg-upgrade/cfg-upgrade.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var cfg_upgrade_controller_1 = __webpack_require__("./app/view-menu/console/cfg-upgrade/cfg-upgrade.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/console/cfg-upgrade/cfg-upgrade.template.html");
exports.UpgradeComponent = {
    bindings: {
        status: '<',
        isReconnected: '<',
        isDisconnected: '<',
    },
    controller: cfg_upgrade_controller_1.UpgradeController,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/console/cfg-upgrade/cfg-upgrade.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var UpgradeController = (function () {
    function UpgradeController(cfgConsoleSrv, uiModalsSrv, userManagerSrv, $scope) {
        var _this = this;
        this.cfgConsoleSrv = cfgConsoleSrv;
        this.uiModalsSrv = uiModalsSrv;
        this.userManagerSrv = userManagerSrv;
        this.$scope = $scope;
        this.IDLE = "IDLE";
        this.UPLOADING = "UPLOADING";
        this.AWAITING_UPGRADE = "AWAITING_UPGRADE";
        this.STARTED_UPGRADE = "STARTED_UPGRADE";
        this.AWAITING_REBOOT = "AWAITING_REBOOT";
        this.STARTED_REBOOT = "STARTED_REBOOT";
        this.TIMEOUT = 60000;
        this.disableButtons = false;
        this.firmwareUserPath = undefined;
        this.state = this.IDLE;
        this.updatemsgtext = "Software Update";
        this.upload = function () {
            _this.state = _this.UPLOADING;
            _this.showUploadWaitDialog();
            _this.cfgConsoleSrv
                .upgrade(_this.firmwareUserPath)
                .then(_this.awaitUpgrade, function (errorMsg) {
                _this.waitDialogConfig.msg = "Uploading firmware failed: " + errorMsg;
                _this.waitDialogConfig.isErrorMsg = true;
                _this.waitDialogConfig.isInProgress = false;
            });
            _this.updateView();
        };
        this.awaitUpgrade = function () {
            _this.state = _this.AWAITING_UPGRADE;
            _this.waitingSince = Date.now();
            _this.showAwaitUpgradeWaitDialog();
            _this.updateView();
        };
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
    }
    // lifecycle
    UpgradeController.prototype.$onInit = function () {
        this.updateView();
    };
    UpgradeController.prototype.$onChanges = function (changes) {
        this.updateState();
        this.updateView();
    };
    // own
    UpgradeController.prototype.updateState = function () {
        if (angular_1.isUndefined(this.status)) {
            return;
        }
        if (this.state === this.IDLE) {
            if (this.status.upgrade.isInProgress) {
                this.startedUpgrade();
            }
        }
        if (this.state === this.AWAITING_UPGRADE) {
            if (this.status.upgrade.isInProgress) {
                this.startedUpgrade();
            }
            else if (this.status.upgrade.isErrorMsg) {
                this.waitDialogConfig.msg = this.status.upgrade.msg;
                this.waitDialogConfig.isErrorMsg = this.status.upgrade.isErrorMsg;
                this.waitDialogConfig.isInProgress = false;
            }
            else if (this.waitingSince + this.TIMEOUT < Date.now()) {
                this.waitDialogConfig.msg = "Timeout starting upgrade";
                this.waitDialogConfig.isErrorMsg = true;
                this.waitDialogConfig.isInProgress = false;
            }
        }
        if (this.state === this.STARTED_UPGRADE) {
            if (this.status.upgrade.isErrorMsg) {
                this.waitDialogConfig.msg = this.status.upgrade.msg;
                this.waitDialogConfig.isErrorMsg = this.status.upgrade.isErrorMsg;
                this.waitDialogConfig.isInProgress = false;
            }
            else if (!this.status.upgrade.isInProgress) {
                this.awaitReboot();
            }
            if (this.isDisconnected) {
                this.startedReboot();
            }
        }
        if (this.state === this.AWAITING_REBOOT) {
            if (this.isDisconnected) {
                this.startedReboot();
            }
            else if (this.waitingSince + this.TIMEOUT < Date.now()) {
                this.waitDialogConfig.msg = "Timeout rebooting system";
                this.waitDialogConfig.isErrorMsg = true;
                this.waitDialogConfig.isInProgress = false;
            }
        }
        if (this.state === this.STARTED_REBOOT) {
            if (this.isReconnected) {
                this.toIdle();
                window.location.reload();
            }
        }
    };
    UpgradeController.prototype.updateView = function () {
        if (this.state === this.STARTED_UPGRADE) {
            this.waitDialogConfig.isInProgress = this.status.upgrade.isInProgress;
            if (this.status.upgrade.msg) {
                this.waitDialogConfig.msg = this.status.upgrade.msg;
                this.waitDialogConfig.isErrorMsg = this.status.upgrade.isErrorMsg;
            }
        }
        this.disableButtons = this.state !== this.IDLE;
    };
    UpgradeController.prototype.toIdle = function () {
        this.state = this.IDLE;
        this.closeWaitDialog();
        this.updateView();
    };
    UpgradeController.prototype.onUpgrade = function () {
        this.uiModalsSrv.openConfirmModal({
            title: "System Upgrade",
            msg: "The system will be upgraded with the selected firmware package. Proceed?",
            buttons: [
                {
                    label: "Yes",
                    callback: this.upload,
                },
                {
                    label: "No",
                },
            ],
        });
    };
    UpgradeController.prototype.showUploadWaitDialog = function () {
        this.showWaitDialog({
            title: "System Upgrade",
            msg: "Uploading firmware...",
            isInProgress: true,
            isErrorMsg: false,
            isCompleteButtons: [
                {
                    label: "Close",
                    callback: this.toIdle,
                },
            ],
        });
    };
    UpgradeController.prototype.showAwaitUpgradeWaitDialog = function () {
        this.showWaitDialog({
            title: "System Upgrade",
            msg: "Completed uploading firmware. Starting upgrade...",
            isInProgress: true,
            isErrorMsg: false,
            isCompleteButtons: [
                {
                    label: "Close",
                    callback: this.toIdle,
                },
            ],
        });
    };
    UpgradeController.prototype.startedUpgrade = function () {
        this.state = this.STARTED_UPGRADE;
        this.showUpgradeWaitDialog();
        this.updateView();
    };
    UpgradeController.prototype.showUpgradeWaitDialog = function () {
        this.showWaitDialog({
            title: "System Upgrade",
            msg: "Upgrading...",
            isInProgress: true,
            isErrorMsg: false,
            isCompleteButtons: [
                {
                    label: "Close",
                    callback: this.toIdle,
                },
            ],
        });
    };
    UpgradeController.prototype.awaitReboot = function () {
        this.state = this.AWAITING_REBOOT;
        this.waitingSince = Date.now();
        this.showAwaitRebootWaitDialog();
        this.updateView();
    };
    UpgradeController.prototype.showAwaitRebootWaitDialog = function () {
        this.showWaitDialog({
            title: "System Upgrade",
            msg: "Upgrade complete. Waiting for reboot...",
            isInProgress: true,
            isErrorMsg: false,
            isCompleteButtons: [
                {
                    label: "Close",
                    callback: this.toIdle,
                },
            ],
        });
    };
    UpgradeController.prototype.startedReboot = function () {
        this.state = this.STARTED_REBOOT;
        this.showRebootWaitDialog();
        this.updateView();
    };
    UpgradeController.prototype.showRebootWaitDialog = function () {
        this.showWaitDialog({
            title: "System Upgrade",
            msg: "Rebooting...",
            isInProgress: true,
            isErrorMsg: false,
            isCompleteButtons: [
                {
                    label: "Close",
                    callback: this.toIdle,
                },
            ],
        });
    };
    UpgradeController.prototype.showWaitDialog = function (waitDialogConfig) {
        // copy(waitDialogConfig, this.waitDialogConfig);
        this.waitDialogConfig = waitDialogConfig;
        console.log("showWaitDialog", this.waitDialogConfig);
        if (!angular_1.isDefined(this.waitDialog)) {
            this.waitDialog = this.uiModalsSrv.openWaitModal(this.waitDialogConfig);
        }
    };
    UpgradeController.prototype.closeWaitDialog = function () {
        if (angular_1.isDefined(this.waitDialog)) {
            this.waitDialog.close();
            this.waitDialog = undefined;
        }
    };
    return UpgradeController;
}());
exports.UpgradeController = UpgradeController;


/***/ }),

/***/ "./app/view-menu/console/cfg-upgrade/cfg-upgrade.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/console/cfg-upgrade/cfg-upgrade.template.html?0a10e748e13a07d071e2e2148342eee4";

/***/ }),

/***/ "./app/view-menu/console/cfg-upgrade/tar-file-input/tar-file-input.directive.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.TarFileInputDirective = function ($parse) {
    return {
        restrict: "A",
        link: function (scope, elm, attrs) {
            var getter = $parse(attrs.tarFile);
            var setter = getter.assign;
            elm.bind("change", function (event) {
                scope.$apply(function () {
                    //     object with prop
                    //            new-value
                    setter(scope, elm[0].files[0]);
                });
            });
        }
    };
};


/***/ }),

/***/ "./app/view-menu/console/console.module.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var cfg_console_service_1 = __webpack_require__("./app/view-menu/console/cfg-console.service.ts");
var cfg_sys_info_component_1 = __webpack_require__("./app/view-menu/console/cfg-sys-info/cfg-sys-info.component.ts");
var cfg_ctrl_link_bonding_component_1 = __webpack_require__("./app/view-menu/console/cfg-ctrl-link-bonding/cfg-ctrl-link-bonding.component.ts");
var cfg_ctrl_link_config_component_1 = __webpack_require__("./app/view-menu/console/cfg-ctrl-link-config/cfg-ctrl-link-config.component.ts");
var tar_file_input_directive_1 = __webpack_require__("./app/view-menu/console/cfg-upgrade/tar-file-input/tar-file-input.directive.ts");
var config_tar_file_input_directive_1 = __webpack_require__("./app/view-menu/console/cfg-import/config-tar-file-input.directive.ts");
var cfg_upgrade_component_1 = __webpack_require__("./app/view-menu/console/cfg-upgrade/cfg-upgrade.component.ts");
var cfg_debug_logs_component_1 = __webpack_require__("./app/view-menu/console/cfg-debug-logs/cfg-debug-logs.component.ts");
var cfg_export_component_1 = __webpack_require__("./app/view-menu/console/cfg-export/cfg-export.component.ts");
var cfg_import_component_1 = __webpack_require__("./app/view-menu/console/cfg-import/cfg-import.component.ts");
var cfg_password_service_1 = __webpack_require__("./app/view-menu/console/cfg-password/cfg-password.service.ts");
var cfg_password_component_1 = __webpack_require__("./app/view-menu/console/cfg-password/cfg-password.component.ts");
var cfg_sys_logging_component_1 = __webpack_require__("./app/view-menu/console/cfg-sys-logging/cfg-sys-logging.component.ts");
var cfg_sys_control_component_1 = __webpack_require__("./app/view-menu/console/cfg-sys-control/cfg-sys-control.component.ts");
var service_toggle_switch_component_1 = __webpack_require__("./app/view-menu/console/cfg-services-control/service-toggle-switch/service-toggle-switch.component.ts");
var cfg_services_control_component_1 = __webpack_require__("./app/view-menu/console/cfg-services-control/cfg-services-control.component.ts");
exports.ConsoleModule = angular_1.module("ConsoleModule", [])
    .service('cfgConsoleSrv', cfg_console_service_1.cfgConsoleService)
    .component('cfgSysInfo', cfg_sys_info_component_1.SystemInfoComponent)
    .component('cfgCtrlLinkBonding', cfg_ctrl_link_bonding_component_1.CtrlLinkBondingComponent)
    .component('cfgCtrlLinkConfig', cfg_ctrl_link_config_component_1.CtrlLinkConfigComponent)
    .directive('tarFile', tar_file_input_directive_1.TarFileInputDirective) // tar-file
    .component('cfgUpgrade', cfg_upgrade_component_1.UpgradeComponent)
    .component('cfgDebugLogs', cfg_debug_logs_component_1.DebugLogsComponent)
    .component('cfgConfigsExport', cfg_export_component_1.ConfigsExportComponent)
    .directive('configTarFile', config_tar_file_input_directive_1.ConfigsTarFileInputDirective)
    .component('cfgConfigsImport', cfg_import_component_1.ConfigsImportComponent)
    .service('passwordConfigSrv', cfg_password_service_1.CfgPasswordConfigService)
    .component('cfgPassword', cfg_password_component_1.CfgPasswordConfigComponent)
    .component('cfgSysLogging', cfg_sys_logging_component_1.SysLoggingComponent)
    .component('cfgSysControl', cfg_sys_control_component_1.SysControlComponent)
    .component('serviceToggleSwitch', service_toggle_switch_component_1.ServiceToggleSwitchComponent)
    .component('cfgServicesControl', cfg_services_control_component_1.ServicesControlComponent);


/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/configuration/configuration.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var configuration_contoller_1 = __webpack_require__("./app/view-menu/processor/processor-modal-window/configuration/configuration.contoller.ts");
var templateUrl = __webpack_require__("./app/view-menu/processor/processor-modal-window/configuration/configuration.template.html");
exports.SnpProcessorConfigurationComponent = {
    bindings: {
        fmeIp: '<',
        processor: '=',
        license: '=',
        licenseTokens: '=',
        processorMeta: '<',
        tabState: '=',
        applyButtons: '=',
        liveCallback: '<',
        userViewOnly: '<'
    },
    templateUrl: templateUrl,
    controller: configuration_contoller_1.SnpProcessorConfigurationCtrl,
};


/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/configuration/configuration.contoller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 Copyright (c) 2018-2025 Imagine Communications Corp.
 All rights reserved.

 filename: app/view-menu/processor/processor-modal-window/configuration/configuration.contoller.ts
 */
Object.defineProperty(exports, "__esModule", { value: true });
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var common_1 = __webpack_require__("./app/view-menu/common.js");
var SnpProcessorConfigurationCtrl = (function () {
    function SnpProcessorConfigurationCtrl(fmeListSrv, snpListSrv, errorSrv, userManagerSrv, $scope) {
        var _this = this;
        this.fmeListSrv = fmeListSrv;
        this.snpListSrv = snpListSrv;
        this.errorSrv = errorSrv;
        this.userManagerSrv = userManagerSrv;
        this.$scope = $scope;
        // it's planned to add in 2.1 GA
        // // it will be used in ng-repeat
        // SNP_SYNC_ADV_MODE = [
        //   {title: "None", value: 0},
        //   {title: "ACO",  value: 1},
        //   {title: "MCL",  value: 2}
        // ];
        this.SNP_PERSONALITY_SYNC = common_1.SNP_PERSONALITY_SYNC;
        this.SNP_PERSONALITY_CONVERT = common_1.SNP_PERSONALITY_CONVERT;
        this.SNP_PERSONALITY_MV = common_1.SNP_PERSONALITY_MV;
        this.SNP_PERSONALITY_CONV4 = common_1.SNP_PERSONALITY_CONV4;
        this.SNP_PERSONALITY_MVP = common_1.SNP_PERSONALITY_MVP;
        this.SNP_PERSONALITY_JXSD = common_1.SNP_PERSONALITY_JXSD;
        this.SNP_PERSONALITY_JXSE = common_1.SNP_PERSONALITY_JXSE;
        this.SNP_PERSONALITY_STAT = common_1.SNP_PERSONALITY_STAT;
        this.SNP_PERSONALITY_MCL = common_1.SNP_PERSONALITY_MCL;
        this.SNP_PERSONALITY_TR7E = common_1.SNP_PERSONALITY_TR7E;
        this.SNP_PERSONALITY_TR7D = common_1.SNP_PERSONALITY_TR7D;
        this.SNP_PERSONALITY_TR7EU = common_1.SNP_PERSONALITY_TR7EU;
        this.SNP_PERSONALITY_TR7DU = common_1.SNP_PERSONALITY_TR7DU;
        this.SNP_PERSONALITY_GW88 = common_1.SNP_PERSONALITY_GW88;
        this.SNP_PERSONALITY_REMAP = common_1.SNP_PERSONALITY_REMAP;
        this.SNP_PERSONALITY_FX = common_1.SNP_PERSONALITY_FX;
        this.SNP_OP_MODE_HD = common_1.SNP_OP_MODE_HD;
        this.SNP_OP_MODE_UHD = common_1.SNP_OP_MODE_UHD;
        this.SNP_MV_MODE_BASE = common_1.SNP_MV_MODE_BASE;
        this.SNP_MV_MODE_EXTENDED = common_1.SNP_MV_MODE_EXTENDED;
        this.SNP_MV_MODE_BASE_ID = common_1.SNP_MV_MODE_BASE_ID;
        this.SNP_MV_MODE_EXTENDED_ID = common_1.SNP_MV_MODE_EXTENDED_ID;
        this.SNP_PROC_MODE_BASE = common_1.SNP_PROC_MODE_BASE;
        this.SNP_PROC_MODE_EXTENDED = common_1.SNP_PROC_MODE_EXTENDED;
        this.SNP_PROC_MODE_BASE_ID = common_1.SNP_PROC_MODE_BASE_ID;
        this.SNP_PROC_MODE_EXTENDED_ID = common_1.SNP_PROC_MODE_EXTENDED_ID;
        this.SNP_ROT_SEL_CW = common_1.SNP_ROT_SEL_CW;
        this.SNP_ROT_SEL_CCW = common_1.SNP_ROT_SEL_CCW;
        this.SNP_ROT_SEL_CW_ID = common_1.SNP_ROT_SEL_CW_ID;
        this.SNP_ROT_SEL_CCW_ID = common_1.SNP_ROT_SEL_CCW_ID;
        this.report = undefined;
        this.reportError = {
            processor: false,
            opMode: [false, false],
        };
        this.sys_status = {
            SNP_HW_Stats: {
                Chassis: 0
            }
        };
        this.delayPoolValid = [true, true];
        this.isSNPXL = function () {
            // --- Check chassis === 2 (SNP XL)
            var isChassisXL = _this.sys_status.SNP_HW_Stats.Chassis === common_1.SNP_XL;
            return isChassisXL;
        };
        this.getPreviousProcessor = function (processorId) {
            if (processorId === "processorB") {
                return "processorA";
            }
            else if (processorId === "processorC") {
                return "processorB";
            }
            else if (processorId === "processorD") {
                return "processorC";
            }
            else {
                return null;
            }
        };
        this.isProcessorInMclChain = function (processor) {
            var isMCLUHD = processor.general.personality === common_1.SNP_PERSONALITY_MCL &&
                (processor.general.mclOutputVideoStandard === "2160p/50" || processor.general.mclOutputVideoStandard === "2160p/59.94");
            var isExtended = (processor.general.personality === common_1.SNP_PERSONALITY_SYNC || processor.general.personality === common_1.SNP_PERSONALITY_CONVERT ||
                processor.general.personality === common_1.SNP_PERSONALITY_FX) && processor.general.processorMode === 1;
            if (isMCLUHD && processor.object_ID !== "processorB") {
                _this.showMclExtendedOption = true;
            }
            else if (isExtended) {
                var prevObjId_1 = _this.getPreviousProcessor(processor.object_ID);
                if (prevObjId_1 !== null && prevObjId_1 !== undefined) {
                    _this.snpListSrv.getObjects(_this.fmeIp, [
                        {
                            type: common_1.SNP_OBJTYPE_PROCESSOR,
                            object_ID: prevObjId_1,
                            getStatus: false
                        }
                    ]).then(function (resolve) {
                        var previousProc = resolve[prevObjId_1].config;
                        if (previousProc !== null && previousProc !== undefined) {
                            _this.isProcessorInMclChain(previousProc);
                        }
                    }, function (reject) {
                        console.log(reject);
                    });
                }
            }
        };
        this.handleOpModeSwitch = function (section) {
            if (_this.processor.sections[section].opMode === "UHD") {
                _this.processor.delayPool.section[section].sdiToIpDelayPoolUHD = 2;
                _this.processor.delayPool.section[section].ipToSdiDelayPoolUHD = 2;
            }
            else if (_this.processor.sections[section].opMode === "HD") {
                for (var program = 0; program < 4; program++) {
                    _this.processor.delayPool.section[program + section * 4].sdiToIpDelayPoolHD = 2;
                    _this.processor.delayPool.section[program + section * 4].ipToSdiDelayPoolHD = 2;
                }
            }
        };
        // the only allowed configurations:
        //    Proc A          Proc B          Proc C          Proc D
        // MCL HD|UHD     FX HD|UHD       MCL HD|UHD      FX HD|UHD
        // MCL UHD        SYNC|CONV UHD   FX UHD
        // MCL UHD        SYNC|CONV UHD   SYNC HD|UHD     FX UHD
        this.updateMclExtendedVisibility = function () {
            _this.showMclExtendedOption = false;
            var isUHD = true;
            _this.processor.sections.forEach(function (section, i) {
                if (section.opMode !== "UHD") {
                    isUHD = false;
                }
            });
            if (_this.processor.general.personality === common_1.SNP_PERSONALITY_SYNC ||
                _this.processor.general.personality === common_1.SNP_PERSONALITY_CONVERT ||
                (_this.processor.general.personality === common_1.SNP_PERSONALITY_FX && isUHD)) {
                if (isUHD === true) {
                    var previousProc_1 = _this.getPreviousProcessor(_this.processor.object_ID);
                    if (previousProc_1 !== null && previousProc_1 !== undefined) {
                        _this.snpListSrv.getObjects(_this.fmeIp, [
                            {
                                type: common_1.SNP_OBJTYPE_PROCESSOR,
                                object_ID: previousProc_1,
                                getStatus: false
                            }
                        ]).then(function (resolve) {
                            var prevCfg = resolve[previousProc_1].config;
                            _this.isProcessorInMclChain(prevCfg);
                        }, function (reject) {
                            console.log(reject);
                        });
                    }
                }
            }
            else if (_this.processor.general.personality === common_1.SNP_PERSONALITY_FX) {
                var previousProc_2 = _this.getPreviousProcessor(_this.processor.object_ID);
                if (previousProc_2 !== null && previousProc_2 !== undefined) {
                    _this.snpListSrv.getObjects(_this.fmeIp, [
                        {
                            type: common_1.SNP_OBJTYPE_PROCESSOR,
                            object_ID: previousProc_2,
                            getStatus: false
                        }
                    ]).then(function (resolve) {
                        var prevCfg = resolve[previousProc_2].config;
                        if (prevCfg.general.personality === common_1.SNP_PERSONALITY_MCL) {
                            _this.showMclExtendedOption = true;
                        }
                    }, function (reject) {
                        console.log(reject);
                    });
                }
            }
        };
        this.updateOrigConfig = function () {
            _this.origProcessor = angular_1.copy(_this.processor);
        };
        this.opModeRadioGroup = function (sectionIdx) {
            return 'opMode-' + _this.processor.object_ID + '-' + sectionIdx;
        };
        this.showOpModeControls = function (personality) {
            return (_this.processor.general.personality === _this.SNP_PERSONALITY_JXSD ||
                _this.processor.general.personality === _this.SNP_PERSONALITY_JXSE ||
                _this.processor.general.personality === _this.SNP_PERSONALITY_STAT ||
                _this.processor.general.personality === _this.SNP_PERSONALITY_SYNC ||
                _this.processor.general.personality === _this.SNP_PERSONALITY_TR7E ||
                _this.processor.general.personality === _this.SNP_PERSONALITY_TR7D ||
                _this.processor.general.personality === _this.SNP_PERSONALITY_TR7EU ||
                _this.processor.general.personality === _this.SNP_PERSONALITY_TR7DU ||
                (_this.processor.general.personality === _this.SNP_PERSONALITY_GW88 && _this.isSNPXL()) ||
                _this.areMultiviewers ||
                _this.isMCLUenabled);
        };
        this.sectionId = function (sectionIdx) {
            return common_1.snpSectionId(_this.processor, sectionIdx);
        };
        this.onApply = function () {
            //set clock/timer device --------------------------------------------------
            if (_this.processor.general.clockDevice == -1) {
                _this.processor.general.pluraDevice = -1;
                _this.processor.general.masterclockDevice = -1;
            }
            else if (_this.processor.general.clockDevice > 0 && _this.processor.general.clockDevice < 1000) {
                _this.processor.general.pluraDevice = _this.processor.general.clockDevice;
                _this.processor.general.masterclockDevice = -1;
            }
            else if (_this.processor.general.clockDevice == 1000) {
                _this.processor.general.pluraDevice = -1;
                _this.processor.general.masterclockDevice = 1000;
            }
            //--------------------------------------------------------------------------
            var partial = angular_1.copy(_this.processor);
            delete (partial.general.personality);
            delete (partial.general.SelectLayoutDisplay1);
            delete (partial.general.SelectLayoutDisplay2);
            if (!_this.matchOrigConfig('general')) {
                for (var key in partial.general) {
                    if (partial.general.hasOwnProperty(key)) {
                        if (_this.matchOrigConfig('general', key)) {
                            delete partial.general[key];
                        }
                    }
                }
            }
            else {
                delete (partial.general);
            }
            if (!_this.matchOrigConfig('sections')) {
                partial.sections.forEach(function (section, i) {
                    if (_this.matchOrigConfig('sections', i)) {
                        partial.sections.splice(i, 1);
                    }
                });
            }
            else {
                delete (partial.sections);
            }
            return _this.snpListSrv.applyPartialUpdate(partial, function (report) {
                _this.report = report;
                _this.updateOrigConfig();
                _this.updateTabValidity();
                _this.updateMclExtendedVisibility();
            }, _this.sectionsForm);
        };
        this.liveControlCallback = function (param, value) {
            if (_this.liveCallback) {
                _this.liveCallback(param, value);
            }
        };
        this.updateAudPacketModesAvail = function () {
            switch (_this.processor.general.audioPacketTimeModesAvail) {
                case "4":
                case "6":
                case "4 6":
                    {
                        var newDropDownList = [4, 6];
                        var defaultSelectedDropDownOption = ["125 us", "500 us"];
                        _this.processorMeta.properties.general.properties.audioPacketTime.enum = newDropDownList;
                        _this.processorMeta.properties.general.properties.audioPacketTime.enumLabels = defaultSelectedDropDownOption;
                        _this.$scope.$broadcast('adjustedMetadata', {
                            property: '/general/audioPacketTime'
                        });
                        if (_this.processor.general.audioPacketTime !== _this.processorMeta.properties.general.properties.audioPacketTime.enum[0]) {
                            _this.processor.general.audioPacketTime = _this.processorMeta.properties.general.properties.audioPacketTime.enum[0];
                            _this.onApply();
                        }
                        break;
                    }
                case "2":
                    {
                        var newDropDownList = [2];
                        var defaultSelectedDropDownOption = ["1 ms"];
                        _this.processorMeta.properties.general.properties.audioPacketTime.enum = newDropDownList;
                        _this.processorMeta.properties.general.properties.audioPacketTime.enumLabels = defaultSelectedDropDownOption;
                        _this.$scope.$broadcast('adjustedMetadata', {
                            property: '/general/audioPacketTime'
                        });
                        if (_this.processor.general.audioPacketTime !== _this.processorMeta.properties.general.properties.audioPacketTime.enum[0]) {
                            _this.processor.general.audioPacketTime = _this.processorMeta.properties.general.properties.audioPacketTime.enum[0];
                            _this.onApply();
                        }
                        break;
                    }
                case "2 4 6":
                    {
                        var newDropDownList = [2, 4, 6];
                        var defaultSelectedDropDownOption = ["1 ms", "125 us", "500 us"];
                        _this.processorMeta.properties.general.properties.audioPacketTime.enum = newDropDownList;
                        _this.processorMeta.properties.general.properties.audioPacketTime.enumLabels = defaultSelectedDropDownOption;
                        _this.$scope.$broadcast('adjustedMetadata', {
                            property: '/general/audioPacketTime'
                        });
                        break;
                    }
            }
        };
        this.onReceiveStatusHandler = function (status) {
            if (status.object_ID === _this.processor.object_ID) {
                if (status.general.audioPacketTimeModesAvail !== _this.processor.general.audioPacketTimeModesAvail) {
                    _this.processor.general.audioPacketTimeModesAvail = status.general.audioPacketTimeModesAvail;
                    _this.updateAudPacketModesAvail();
                }
            }
            else if (status.object_ID === common_1.SNP_OBJTYPE_SYSTEM) {
                _this.sys_status = status;
            }
            else if (status.object_ID === "MVPROC") {
                console.log(status);
                var procIdx = common_1.snpProcessorIdx(_this.processor.object_ID);
                if (status.Proc_Stats[procIdx].display1.hasOwnProperty("num_outputs_used") && _this.processorMeta.properties.general.properties.hasOwnProperty("FullscreenPipDisplay1")) {
                    _this.processorMeta.properties.general.properties.FullscreenPipDisplay1.enum = ["Show Layout"];
                    for (var i = 0; i < status.Proc_Stats[procIdx].display1.num_outputs_used; ++i) {
                        _this.processorMeta.properties.general.properties.FullscreenPipDisplay1.enum.push("Pip " + (i + 1));
                    }
                    _this.$scope.$broadcast('adjustedMetadata', {
                        property: '/general/FullscreenPipDisplay1'
                    });
                }
                if (status.Proc_Stats[procIdx].display2.hasOwnProperty("num_outputs_used") && _this.processorMeta.properties.general.properties.hasOwnProperty("FullscreenPipDisplay2")) {
                    _this.processorMeta.properties.general.properties.FullscreenPipDisplay2.enum = ["Show Layout"];
                    for (var i = 0; i < status.Proc_Stats[procIdx].display2.num_outputs_used; ++i) {
                        _this.processorMeta.properties.general.properties.FullscreenPipDisplay2.enum.push("Pip " + (i + 1));
                    }
                    _this.$scope.$broadcast('adjustedMetadata', {
                        property: '/general/FullscreenPipDisplay2'
                    });
                }
                if (status.Proc_Stats[procIdx].display1.hasOwnProperty("num_outputs_used") && _this.processorMeta.properties.general.properties.hasOwnProperty("SelectDisplay1AudOut")) {
                    _this.processorMeta.properties.general.properties.SelectDisplay1AudOut.enum = ["Mute"];
                    for (var i = 0; i < status.Proc_Stats[procIdx].display1.num_outputs_used; ++i) {
                        _this.processorMeta.properties.general.properties.SelectDisplay1AudOut.enum.push("PiP " + (i + 1));
                    }
                    _this.$scope.$broadcast('adjustedMetadata', {
                        property: '/general/SelectDisplay1AudOut'
                    });
                }
                if (status.Proc_Stats[procIdx].display2.hasOwnProperty("num_outputs_used") && _this.processorMeta.properties.general.properties.hasOwnProperty("SelectDisplay2AudOut")) {
                    _this.processorMeta.properties.general.properties.SelectDisplay2AudOut.enum = ["Mute"];
                    for (var i = 0; i < status.Proc_Stats[procIdx].display2.num_outputs_used; ++i) {
                        _this.processorMeta.properties.general.properties.SelectDisplay2AudOut.enum.push("PiP " + (i + 1));
                    }
                    _this.$scope.$broadcast('adjustedMetadata', {
                        property: '/general/SelectDisplay2AudOut'
                    });
                }
            }
        };
        this.mapFrameToBuf = function (numFrames) {
            // --- Map numFrames to numBuffers required
            // ---   From SNP-49576:
            // ---     NumFrames    NumBuffers
            // ---          2             4
            // ---         30            32
            // ---         58            60
            // ---         76            78
            // ---        114           116
            // ---        226           228
            // ---
            // --- It appears the amount of buffers required to support numFrames is always "numFrames + 2"
            // --- Thus, to keep things simplier, just return "numFrames + 2" insted of having a dictionary
            return numFrames + 2;
        };
        this.validateDelayPool = function (isIpSdiPath) {
            var buffers = 0;
            var isValid = true;
            for (var section = 0; section < 2; section++) {
                if (_this.processor.sections[section].opMode === "HD") {
                    for (var program = 0; program < 4; program++) {
                        if (isIpSdiPath) {
                            buffers = buffers + _this.mapFrameToBuf(_this.processor.delayPool.programs[section * 4 + program].ipToSdiPoolHD);
                        }
                        else {
                            buffers = buffers + _this.mapFrameToBuf(_this.processor.delayPool.programs[section * 4 + program].sdiToIpPoolHD);
                        }
                    }
                }
                else {
                    if (isIpSdiPath) {
                        buffers = buffers + _this.mapFrameToBuf(_this.processor.delayPool.sections[section].ipToSdiPoolUHD) * 4;
                    }
                    else {
                        buffers = buffers + _this.mapFrameToBuf(_this.processor.delayPool.sections[section].sdiToIpPoolUHD) * 4;
                    }
                }
            }
            if (buffers > 256) {
                isValid = false;
            }
            if (isValid != _this.delayPoolValid[isIpSdiPath]) {
                _this.delayPoolValid[isIpSdiPath] = isValid;
                _this.updateTabValidity();
            }
            return isValid;
        };
        this.updateTabValidity = function () {
            var isFormValid = angular_1.isUndefined(_this.sectionsForm) || _this.sectionsForm.$valid;
            var isReportError = angular_1.isDefined(_this.report) && angular_1.isDefined(_this.report.hasErrorMsg) && !!_this.report.hasErrorMsg;
            _this.tabState.valid = isFormValid && !isReportError && _this.delayPoolValid[0] && _this.delayPoolValid[1];
        };
        this.onBlackLevelChange = function () {
            if (_this.processor.general.videoBlackLevel >= _this.processor.general.videoWhiteLevel) {
                _this.blackLevelWarning = true;
                _this.tabState.valid = false;
            }
            else {
                _this.blackLevelWarning = false;
                _this.whiteLevelWarning = false;
                _this.tabState.valid = true;
            }
            return [];
        };
        this.onWhiteLevelChange = function () {
            if (_this.processor.general.videoWhiteLevel <= _this.processor.general.videoBlackLevel) {
                _this.whiteLevelWarning = true;
                _this.tabState.valid = false;
            }
            else {
                _this.whiteLevelWarning = false;
                _this.blackLevelWarning = false;
                _this.tabState.valid = true;
            }
            return [];
        };
        this.deleteItemsFromDropdown = function (deletedItemsArr, jsonPath) {
            var enums = [], labels = [];
            var removedRootSlash = jsonPath.slice(1);
            var propArr = removedRootSlash.split('/');
            var propGroup = propArr[0], propKey = propArr[1];
            _this.processorMeta.properties[propGroup].properties[propKey].enumLabels.forEach(function (label, i) {
                var isValid = true;
                for (var i_1 = 0; i_1 < deletedItemsArr.length; i_1++) {
                    var deletedItem = deletedItemsArr[i_1];
                    if (label.toLowerCase().indexOf(deletedItem) !== -1)
                        isValid = false;
                }
                if (isValid) {
                    enums.push(_this.processorMeta.properties[propGroup].properties[propKey].enum[i]);
                    labels.push(label);
                }
            });
            _this.processorMeta.properties[propGroup].properties[propKey].enum = enums;
            _this.processorMeta.properties[propGroup].properties[propKey].enumLabels = labels;
            _this.$scope.$broadcast('adjustedMetadata', {
                property: "/" + propGroup + "/" + propKey,
            });
        };
        this.isSfpMadi = function (param) {
            return (_this.processor.general[param] == common_1.SFP_TYPE_2RX_MADI) || (_this.processor.general[param] == common_1.SFP_TYPE_2TX_MADI);
        };
        this.$doCheck = function () {
            _this.tabState.dirty = _this.sectionsForm && _this.sectionsForm.$dirty;
            if (_this.tabState.dirty &&
                ((_this.prevSfpRole !== _this.processor.general.sfpSelect && _this.isSfpMadi('sfpSelect') && !_this.isSNPXL()) ||
                    (_this.isSNPXL() && ((_this.prevRxSfpRole !== _this.processor.general.sfpRxSelect && _this.isSfpMadi('sfpRxSelect')) ||
                        (_this.prevTxSfpRole !== _this.processor.general.sfpTxSelect && _this.isSfpMadi('sfpTxSelect')))))) {
                _this.snpListSrv.checkLicense(_this.license, _this.licenseTokens, 'SNP-SK-DUAL-MADI', 'MADI', 'mute_audio', _this.processor.object_ID);
            }
            _this.prevSfpRole = _this.processor.general.sfpSelect;
            _this.prevRxSfpRole = _this.processor.general.sfpRxSelect;
            _this.prevTxSfpRole = _this.processor.general.sfpTxSelect;
            _this.showCascadeLevel = (_this.showCascadeOutput === true && _this.processor.general.cascadeOutputSelect !== 0); // Unused
            _this.isMCLUenabled = (_this.processor.general.personality === common_1.SNP_PERSONALITY_MCL) && _this.snpListSrv.isLicenseExists(_this.license, _this.licenseTokens, 'SNP-SK-MCLU', _this.processor.object_ID);
            var curDisplayColorimetryTCS = _this.processor.general.DisplayColorimetryTCS;
            if (_this.prevDisplayColorimetryTCS !== curDisplayColorimetryTCS && !curDisplayColorimetryTCS.startsWith("SDR")) {
                _this.snpListSrv.checkLicense(_this.license, _this.licenseTokens, "SNP-SK-HDR", "Display Colorimetry and TCS", "default_output", _this.processor.object_ID);
            }
            _this.prevDisplayColorimetryTCS = curDisplayColorimetryTCS;
        };
        this.$onDestroy = function () {
            _this.fmeListSrv.msgStatusUnsubscribe(_this.onReceiveStatusHandler, _this.statusHeader);
        };
        this.isTr78Enc = function () {
            var isTrEnc = _this.isJXSEnc || _this.isTR7Enc;
            return isTrEnc;
        };
        this.isTr78Dec = function () {
            var isTrDec = _this.isJXSDec || _this.isTR7Dec;
            return isTrDec;
        };
        this.isGw88SnpXL = function () {
            return _this.isGw88 && _this.isSNPXL();
        };
        this.restoreSdiToIpPoolDefaults = function () {
            for (var program = 0; program < _this.processor.delayPool.sections.length; program++) {
                _this.processor.delayPool.sections[program].sdiToIpPoolUHD = _this.processorMeta.properties.delayPool.properties.sections.items.properties["sdiToIpPoolUHD"].default;
            }
            for (var program = 0; program < _this.processor.delayPool.programs.length; program++) {
                _this.processor.delayPool.programs[program].sdiToIpPoolHD = _this.processorMeta.properties.delayPool.properties.programs.items.properties["sdiToIpPoolHD"].default;
            }
            _this.onApply();
        };
        this.restoreIpToSdiPoolDefaults = function () {
            for (var program = 0; program < _this.processor.delayPool.sections.length; program++) {
                _this.processor.delayPool.sections[program].ipToSdiPoolUHD = _this.processorMeta.properties.delayPool.properties.sections.items.properties["ipToSdiPoolUHD"].default;
            }
            for (var program = 0; program < _this.processor.delayPool.programs.length; program++) {
                _this.processor.delayPool.programs[program].ipToSdiPoolHD = _this.processorMeta.properties.delayPool.properties.programs.items.properties["ipToSdiPoolHD"].default;
            }
            _this.onApply();
        };
        $scope.element = fmeListSrv.getElement(this.fmeIp);
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
        this.prevDisplayColorimetryTCS = this.processor.general.DisplayColorimetryTCS;
        this.areMultiviewers = this.processor.general.personality === common_1.SNP_PERSONALITY_MV || this.processor.general.personality === common_1.SNP_PERSONALITY_MVP;
        this.baseModeDisabled = this.processor.general.personality === common_1.SNP_PERSONALITY_FX || this.userViewOnly;
        this.areConversions = this.processor.general.personality === common_1.SNP_PERSONALITY_CONVERT || this.processor.general.personality === common_1.SNP_PERSONALITY_CONV4;
        this.isGw88 = this.processor.general.personality === common_1.SNP_PERSONALITY_GW88;
        this.isJXSEnc = this.processor.general.personality === common_1.SNP_PERSONALITY_JXSE;
        this.isJXSDec = this.processor.general.personality === common_1.SNP_PERSONALITY_JXSD;
        this.isTR7Enc = this.processor.general.personality === common_1.SNP_PERSONALITY_TR7E || this.processor.general.personality === common_1.SNP_PERSONALITY_TR7EU;
        this.isTR7Dec = this.processor.general.personality === common_1.SNP_PERSONALITY_TR7D || this.processor.general.personality === common_1.SNP_PERSONALITY_TR7DU;
        this.processor.general.clockDevice = -1;
        if (this.processor.general.pluraDevice !== -1 && this.processor.general.masterclockDevice == -1) {
            this.processor.general.clockDevice = this.processor.general.pluraDevice;
        }
        else if (this.processor.general.pluraDevice == -1 && this.processor.general.masterclockDevice !== -1) {
            this.processor.general.clockDevice = 1000;
        }
        this.showCascadeOutput = common_1.snpProcessorLetter(this.processor.object_ID) == 'A';
        this.showCascadeInput = common_1.snpProcessorLetter(this.processor.object_ID) == 'D';
        this.updateMclExtendedVisibility();
        this.blackLevelWarningText = "The black level must be less than the white level.";
        this.whiteLevelWarningText = "The white level must be higher than the black level.";
        this.updateOrigConfig();
        this.applyButtons.length = 0;
        this.applyButtons.push({
            label: 'Apply Config',
            isDisabled: function () {
                return _this.sectionsForm.$pristine;
            },
            click: this.onApply,
        });
        this.isInOneOfPersonalities = function (list) {
            return common_1.snpInOneOfPersonalities(_this.processor, list);
        };
        this.delayPoolIndex = function (section, program) {
            return (section * 4) + program - 1;
        };
        this.selectLayoutTitleForProcessor = function (objectID, display) {
            var procIdx = common_1.snpProcessorIdx(objectID);
            return "Display " + String((procIdx * 2) + display) + " layout";
        };
        this.selectFullscreenTitleForProcessor = function (objectID, display) {
            var procIdx = common_1.snpProcessorIdx(objectID);
            return "Display " + String((procIdx * 2) + display) + " Fullscreen Pip";
        };
        this.selectAudioTitleForProcessor = function (objectID, display) {
            var procIdx = common_1.snpProcessorIdx(objectID);
            return "Display " + String((procIdx * 2) + display) + " Audio";
        };
        this.prevSfpRole = this.processor.general.sfpSelect;
        this.prevRxSfpRole = this.processor.general.sfpRxSelect;
        this.prevTxSfpRole = this.processor.general.sfpTxSelect;
        this.updateSfpRole();
        if (this.processorMeta.properties.general.properties.hasOwnProperty('SelectLayoutDisplay1') &&
            this.processorMeta.properties.general.properties.hasOwnProperty('SelectLayoutDisplay2')) {
            this.processorMeta.properties.general.properties.SelectLayoutDisplay1.enum = [];
            this.$scope.$broadcast('adjustedMetadata', {
                property: '/general/SelectLayoutDisplay1'
            });
            this.processorMeta.properties.general.properties.SelectLayoutDisplay2.enum = [];
            this.$scope.$broadcast('adjustedMetadata', {
                property: '/general/SelectLayoutDisplay2'
            });
            fmeListSrv.getLayouts(this.fmeIp).then(function (response) {
                var sortedLayouts = response.data.sort();
                var layoutLabels = sortedLayouts.map(function (layout) { return layout.replace(/\.[^/.]+$/, ""); });
                _this.processorMeta.properties.general.properties.SelectLayoutDisplay1.enum = sortedLayouts;
                _this.processorMeta.properties.general.properties.SelectLayoutDisplay1.enumLabels = layoutLabels;
                _this.processorMeta.properties.general.properties.SelectLayoutDisplay1.title = _this.selectLayoutTitleForProcessor(_this.processor.object_ID, 1);
                _this.$scope.$broadcast('adjustedMetadata', {
                    property: '/general/SelectLayoutDisplay1'
                });
                _this.processorMeta.properties.general.properties.SelectLayoutDisplay2.enum = sortedLayouts;
                _this.processorMeta.properties.general.properties.SelectLayoutDisplay2.enumLabels = layoutLabels;
                _this.processorMeta.properties.general.properties.SelectLayoutDisplay2.title = _this.selectLayoutTitleForProcessor(_this.processor.object_ID, 2);
                _this.$scope.$broadcast('adjustedMetadata', {
                    property: '/general/SelectLayoutDisplay2'
                });
            });
        }
        if (this.processorMeta.properties.general.properties.hasOwnProperty('FullscreenPipDisplay1') &&
            this.processorMeta.properties.general.properties.hasOwnProperty('FullscreenPipDisplay2')) {
            this.processorMeta.properties.general.properties.FullscreenPipDisplay1.title = this.selectFullscreenTitleForProcessor(this.processor.object_ID, 1);
            this.$scope.$broadcast('adjustedMetadata', {
                property: '/general/FullscreenPipDisplay1'
            });
            this.processorMeta.properties.general.properties.FullscreenPipDisplay2.title = this.selectFullscreenTitleForProcessor(this.processor.object_ID, 2);
            this.$scope.$broadcast('adjustedMetadata', {
                property: '/general/FullscreenPipDisplay2'
            });
        }
        if (this.processorMeta.properties.general.properties.hasOwnProperty('SelectDisplay1AudOut') &&
            this.processorMeta.properties.general.properties.hasOwnProperty('SelectDisplay2AudOut')) {
            this.processorMeta.properties.general.properties.SelectDisplay1AudOut.title = this.selectAudioTitleForProcessor(this.processor.object_ID, 1);
            this.$scope.$broadcast('adjustedMetadata', {
                property: '/general/SelectDisplay1AudOut'
            });
            this.processorMeta.properties.general.properties.SelectDisplay2AudOut.title = this.selectAudioTitleForProcessor(this.processor.object_ID, 2);
            this.$scope.$broadcast('adjustedMetadata', {
                property: '/general/SelectDisplay2AudOut'
            });
        }
        if (this.processor.general.personality === common_1.SNP_PERSONALITY_MVP) {
            this.personalityName = "Multiviewer (Portrait)";
        }
        else {
            this.personalityName = this.processor.general.personality;
        }
        this.statusHeader = [
            {
                fme_ip: this.fmeIp,
                type: common_1.SNP_OBJTYPE_PROCESSOR,
                object_ID: this.processor.object_ID,
            },
            {
                fme_ip: this.fmeIp,
                type: common_1.SNP_OBJTYPE_SYSTEM,
                object_ID: common_1.SNP_OBJTYPE_SYSTEM
            },
            {
                fme_ip: this.fmeIp,
                type: "procMV",
                object_ID: "MVPROC"
            }
        ];
        fmeListSrv.msgStatusSubscribe(this.onReceiveStatusHandler, this.statusHeader);
        this.updateAudPacketModesAvail();
        var hasTsl, hasPlura, hasClocks, hasDakRtd;
        if (this.processorMeta.properties.general.properties.hasOwnProperty('tslDevice')) {
            hasTsl = true;
            this.processorMeta.properties.general.properties.tslDevice.enum = [-1];
            this.processorMeta.properties.general.properties.tslDevice.enumLabels = ['Unused'];
            this.$scope.$broadcast('adjustedMetadata', {
                property: '/general/tslDevice',
            });
        }
        if (this.processorMeta.properties.general.properties.hasOwnProperty('pluraDevice')) {
            hasPlura = true;
            this.processorMeta.properties.general.properties.pluraDevice.enum = [-1];
            this.processorMeta.properties.general.properties.pluraDevice.enumLabels = ['Unused'];
            this.$scope.$broadcast('adjustedMetadata', {
                property: '/general/pluraDevice',
            });
        }
        if (this.processorMeta.properties.general.properties.hasOwnProperty('clockDevice')) {
            hasClocks = true;
            this.processorMeta.properties.general.properties.clockDevice.enum = [-1];
            this.processorMeta.properties.general.properties.clockDevice.enumLabels = ['Unused'];
            this.$scope.$broadcast('adjustedMetadata', {
                property: '/general/clockDevice',
            });
        }
        if (this.processorMeta.properties.general.properties.hasOwnProperty('dakRtdDevice')) {
            hasDakRtd = true;
            this.processorMeta.properties.general.properties.dakRtdDevice.enum = [-1];
            this.processorMeta.properties.general.properties.dakRtdDevice.enumLabels = ['Unused'];
            this.$scope.$broadcast('adjustedMetadata', {
                property: '/general/dakRtdDevice',
            });
        }
        if (hasTsl || hasPlura || hasClocks || hasDakRtd) {
            this.snpListSrv.getObjects(this.fmeIp, [
                {
                    type: common_1.SNP_OBJTYPE_WAN,
                    object_ID: common_1.SNP_OBJTYPE_WAN,
                }
            ]).then(function (objects) {
                if (!!objects && objects.ipWan && objects.ipWan.config) {
                    if (hasTsl && objects.ipWan.config.tslDevice instanceof Array && objects.ipWan.config.tslDevice.length > 0) {
                        var enums_1 = [-1];
                        var enumLabels_1 = ['Unused'];
                        objects.ipWan.config.tslDevice.forEach(function (item) {
                            enums_1.push(item.idx);
                            enumLabels_1.push(item.name + ' (' + item.tslIpAddress + ':' + item.tslIpPort + ')');
                        });
                        _this.processorMeta.properties.general.properties.tslDevice.enum = enums_1;
                        _this.processorMeta.properties.general.properties.tslDevice.enumLabels = enumLabels_1;
                        _this.$scope.$broadcast('adjustedMetadata', {
                            property: '/general/tslDevice',
                        });
                    }
                    if (hasPlura && objects.ipWan.config.pluraDevice instanceof Array && objects.ipWan.config.pluraDevice.length > 0) {
                        var enums_2 = [-1];
                        var enumLabels_2 = ['Unused'];
                        objects.ipWan.config.pluraDevice.forEach(function (item) {
                            enums_2.push(item.idx);
                            enumLabels_2.push(item.name + ' (' + item.pluraIpAddress + ':' + item.pluraIpPort + ')');
                        });
                        _this.processorMeta.properties.general.properties.pluraDevice.enum = enums_2;
                        _this.processorMeta.properties.general.properties.pluraDevice.enumLabels = enumLabels_2;
                        _this.$scope.$broadcast('adjustedMetadata', {
                            property: '/general/pluraDevice',
                        });
                    }
                    if (hasClocks) {
                        var enums_3 = [-1, 1000];
                        var enumLabels_3 = ['Unused', 'Masterclock'];
                        if (objects.ipWan.config.pluraDevice instanceof Array && objects.ipWan.config.pluraDevice.length > 0) {
                            objects.ipWan.config.pluraDevice.forEach(function (item) {
                                enums_3.push(item.idx);
                                enumLabels_3.push(item.name + ' (' + item.pluraIpAddress + ':' + item.pluraIpPort + ')');
                            });
                        }
                        _this.processorMeta.properties.general.properties.clockDevice.enum = enums_3;
                        _this.processorMeta.properties.general.properties.clockDevice.enumLabels = enumLabels_3;
                        _this.$scope.$broadcast('adjustedMetadata', {
                            property: '/general/clockDevice',
                        });
                    }
                    if (hasDakRtd && objects.ipWan.config.dakRtdDevice instanceof Array && objects.ipWan.config.dakRtdDevice.length > 0) {
                        var enums_4 = [-1];
                        var enumLabels_4 = ['Unused'];
                        objects.ipWan.config.dakRtdDevice.forEach(function (item) {
                            enums_4.push(item.idx);
                            enumLabels_4.push(item.name + ' (' + item.dakIpAddress + ':' + item.dakIpPort + ')');
                        });
                        _this.processorMeta.properties.general.properties.dakRtdDevice.enum = enums_4;
                        _this.processorMeta.properties.general.properties.dakRtdDevice.enumLabels = enumLabels_4;
                        _this.$scope.$broadcast('adjustedMetadata', {
                            property: '/general/dakRtdDevice',
                        });
                    }
                }
            });
        }
    }
    SnpProcessorConfigurationCtrl.prototype.isSyncBase = function () {
        return this.processor.general.personality === common_1.SNP_PERSONALITY_SYNC && this.processor.general.processorMode === 0;
    };
    SnpProcessorConfigurationCtrl.prototype.matchOrigConfig = function (param, param2) {
        if (angular_1.isUndefined(param2)) {
            return angular_1.equals(this.processor[param], this.origProcessor[param]);
        }
        else {
            return angular_1.equals(this.processor[param][param2], this.origProcessor[param][param2]);
        }
    };
    SnpProcessorConfigurationCtrl.prototype.updateSfpRole = function () {
        // /general/sfpSelect ["Unused", "2RX 3G", "2RX 12G", "RX HDMI",     "2RX MADI",
        //                               "2TX 3G", "2TX 12G", "TX 12G HDMI", "2TX MADI"]
        if (this.areMultiviewers || this.processor.general.personality === this.SNP_PERSONALITY_CONVERT) {
            this.deleteItemsFromDropdown(['madi'], '/general/sfpSelect');
            this.deleteItemsFromDropdown(['madi'], '/general/sfpRxSelect');
            this.deleteItemsFromDropdown(['madi'], '/general/sfpTxSelect');
        }
        if (this.processor.general.personality === this.SNP_PERSONALITY_CONV4) {
            this.deleteItemsFromDropdown(['madi', 'hdmi', '12g'], '/general/sfpSelect');
            this.deleteItemsFromDropdown(['madi', 'hdmi', '12g'], '/general/sfpRxSelect');
            this.deleteItemsFromDropdown(['madi', 'hdmi', '12g'], '/general/sfpTxSelect');
        }
        if (this.processor.general.personality === this.SNP_PERSONALITY_STAT) {
            this.deleteItemsFromDropdown(['madi', 'hdmi', '12g'], '/general/sfpSelect');
            this.deleteItemsFromDropdown(['madi', 'hdmi', '12g'], '/general/sfpRxSelect');
            this.deleteItemsFromDropdown(['madi', 'hdmi', '12g'], '/general/sfpTxSelect');
        }
        if (this.isJXSEnc || this.isTR7Enc) {
            this.deleteItemsFromDropdown(['madi', 'tx'], '/general/sfpSelect');
            this.deleteItemsFromDropdown(['madi'], '/general/sfpRxSelect');
        }
        if (this.isJXSDec || this.isTR7Dec) {
            this.deleteItemsFromDropdown(['madi', 'rx'], '/general/sfpSelect');
            this.deleteItemsFromDropdown(['madi'], '/general/sfpTxSelect');
        }
        if (this.processor.general.personality === this.SNP_PERSONALITY_GW88) {
            // --- Limit to "12G Tx" only for Non-SNP XL chassis
            // --- (No need to worry about Rx/Tx SFP params as they are SNP XL only)
            this.deleteItemsFromDropdown(['rx', 'madi', 'hdmi', '3g'], '/general/sfpSelect');
        }
    };
    SnpProcessorConfigurationCtrl.$inject = ['fmeListSrv', 'snpListSrv', 'errorSrv', 'userManagerSrv', '$scope'];
    return SnpProcessorConfigurationCtrl;
}());
exports.SnpProcessorConfigurationCtrl = SnpProcessorConfigurationCtrl;


/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/configuration/configuration.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/processor/processor-modal-window/configuration/configuration.template.html?a61f045487154fb797c4b805908be853";

/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/gen_audio/gen_audio.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var gen_audio_controller_1 = __webpack_require__("./app/view-menu/processor/processor-modal-window/gen_audio/gen_audio.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/processor/processor-modal-window/gen_audio/gen_audio.template.html"); // TDL: replace for import statement
exports.SnpProcessorGenAudioComponent = {
    bindings: {
        fmeIp: '<',
        processor: '=',
        procAudio: '=',
        switchState: '=',
        tabState: '=',
        applyButtons: '=',
        userViewOnly: '<'
    },
    controller: gen_audio_controller_1.SnpProcessorGenAudioCtrl,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/gen_audio/gen_audio.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var common_1 = __webpack_require__("./app/view-menu/common.js");
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var SnpProcessorGenAudioCtrl = (function () {
    //
    // Constructor
    //
    function SnpProcessorGenAudioCtrl(snpListSrv, userManagerSrv, $scope) {
        var _this = this;
        this.snpListSrv = snpListSrv;
        this.userManagerSrv = userManagerSrv;
        this.$scope = $scope;
        this.SNP_PERSONALITY_MV = common_1.SNP_PERSONALITY_MV;
        this.SNP_PERSONALITY_MVP = common_1.SNP_PERSONALITY_MVP;
        this.disp1AudRoutingIdx = 0;
        this.disp2AudRoutingIdx = 0;
        this.isDolbyEnabled = false;
        this.isGenAudioEnabled = false;
        this.report = undefined;
        this.reportError = false;
        this.disp2ChSelectFormStatusArray = [];
        this.disp1ChSelectFormStatusArray = [];
        this.isReady = false;
        this.init = function () {
            _this.applyButtons.length = 0;
            _this.applyButtons.push({
                label: 'Apply Audio Settings',
                isDisabled: function () {
                    return _this.genAudioForm.$pristine;
                },
                click: _this.onApply,
            });
            _this.isGenAudioEnabled = (_this.processor.general.personality != common_1.SNP_PERSONALITY_FX);
            _this.isDolbyEnabled = (_this.processor.general.personality != common_1.SNP_PERSONALITY_JXSE);
            _this.procAudio.config.AudChCtrlMVdisp1.forEach(function (element, idx) {
                element.labelIdx = "APOUT 1-1 : " + (idx + 1);
            });
            _this.procAudio.config.AudChCtrlMVdisp2.forEach(function (element, idx) {
                element.labelIdx = "APOUT 2-1 : " + (idx + 1);
            });
        };
        this.onReady = function () {
            _this.isReady = true;
        };
        this.onStatusUpdate = function (status) { };
        this.onApply = function () {
            var partial = {};
            partial = {
                cacheKey: _this.procAudio.config.cacheKey,
                fme_ip: _this.procAudio.config.fme_ip,
                name: _this.procAudio.config.name,
                object_ID: _this.procAudio.config.object_ID,
                type: _this.procAudio.config.type,
                DolbyEControl: _this.procAudio.config.DolbyEControl,
                AudProcAmpGeneralCtrl: _this.procAudio.config.AudProcAmpGeneralCtrl,
                AudChCtrlMVdisp1: _this.procAudio.config.AudChCtrlMVdisp1,
                AudChCtrlMVdisp2: _this.procAudio.config.AudChCtrlMVdisp2,
            };
            return _this.snpListSrv.applyPartialUpdate(partial, function (report) {
                _this.report = report;
                _this.updateTabValidity();
            }, _this.genAudioForm);
        };
        this.updateTabValidity = function () {
            var isFormValid = angular_1.isUndefined(_this.genAudioForm) || _this.genAudioForm.$valid;
            var isReportError = angular_1.isDefined(_this.report) && angular_1.isDefined(_this.report.hasErrorMsg) && !!_this.report.hasErrorMsg;
            _this.tabState.valid = isFormValid && !isReportError;
        };
        this.onDisp1IndexChange = function (newIndex, oldIndex) {
            _this.disp1ChSelectFormStatusArray[parseInt(oldIndex)] = _this.disp1ChSelectForm.$pristine;
            _this.disp1ChSelectForm.$setPristine();
            if (_this.disp1ChSelectFormStatusArray[newIndex] !== undefined && _this.disp1ChSelectFormStatusArray[newIndex] !== true) {
                _this.disp1ChSelectForm.$setDirty();
            }
        };
        this.onDisp2IndexChange = function (newIndex, oldIndex) {
            _this.disp2ChSelectFormStatusArray[parseInt(oldIndex)] = _this.disp2ChSelectForm.$pristine;
            _this.disp2ChSelectForm.$setPristine();
            if (_this.disp2ChSelectFormStatusArray[newIndex] !== undefined && _this.disp2ChSelectFormStatusArray[newIndex] !== true) {
                _this.disp2ChSelectForm.$setDirty();
            }
        };
        this.dispChSelectLabel = function (index) {
            var procIdx = common_1.snpProcessorIdx(_this.processor.object_ID);
            return "Display " + ((procIdx * 2) + index) + " Audio Output Routing";
        };
        this.$doCheck = function () {
            _this.tabState.dirty = _this.genAudioForm && _this.genAudioForm.$dirty;
        };
        this.$onDestroy = function () { };
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
        this.isMV = this.processor.general.personality === common_1.SNP_PERSONALITY_MV;
        this.isMVP = this.processor.general.personality === common_1.SNP_PERSONALITY_MVP;
        this.init();
    }
    SnpProcessorGenAudioCtrl.$inject = ['snpListSrv', 'userManagerSrv', '$scope'];
    return SnpProcessorGenAudioCtrl;
}());
exports.SnpProcessorGenAudioCtrl = SnpProcessorGenAudioCtrl;


/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/gen_audio/gen_audio.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/processor/processor-modal-window/gen_audio/gen_audio.template.html?a04609253a2f69ec000e2232ee1d0a19";

/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/madi/madi.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var madi_controller_1 = __webpack_require__("./app/view-menu/processor/processor-modal-window/madi/madi.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/processor/processor-modal-window/madi/madi.template.html"); // TDL: replace for import statement
exports.SnpProcessorMadiComponent = {
    bindings: {
        fmeIp: '<',
        processor: '=',
        system: '=',
        procAudio: '=',
        switchState: '=',
        tabState: '=',
        applyButtons: '=',
        userViewOnly: '<'
    },
    controller: madi_controller_1.SnpProcessorMadiCtrl,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/madi/madi.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 Copyright (c) 2018 Imagine Communications Corp.
 All rights reserved.
 */
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var common_1 = __webpack_require__("./app/view-menu/common.js");
var SnpProcessorMadiCtrl = (function () {
    function SnpProcessorMadiCtrl(snpListSrv, userManagerSrv, $scope) {
        var _this = this;
        this.snpListSrv = snpListSrv;
        this.userManagerSrv = userManagerSrv;
        this.$scope = $scope;
        this.madiTxControlIdx = 0;
        this.audTxMadiRoutingIdx = 0;
        this.madiRxStatusIdx = 0;
        this.madiRxStatusIdxArray = [
            {
                label: '1',
                value: 0
            },
            {
                label: '2',
                value: 1
            }
        ];
        this.audExpInPairIdx = 0;
        this.audExpInPairIdxArray = [
            {
                label: '1',
                value: 0
            }
        ];
        this.report = undefined;
        this.reportError = false;
        this.madiTxChSelectFormStatusArray = [];
        this.audSRCFormStatusArray = [];
        this.isMADIControlEnabled = true;
        this.init = function () {
            _this.applyButtons.length = 0;
            _this.applyButtons.push({
                label: 'Apply Audio Expansion',
                isDisabled: function () {
                    return _this.madiForm.$pristine;
                },
                click: _this.onApply,
            });
            if (_this.procAudio.config.AudExpInputPairSRC) {
                _this.audExpInPairIdxArray = [];
                _this.audSRCFormStatusArray = [];
                for (var i = 0; i < _this.procAudio.config.AudExpInputPairSRC.length; i++) {
                    _this.audExpInPairIdxArray.push({
                        label: '' + (i + 1),
                        value: i
                    });
                    _this.audSRCFormStatusArray.push(true);
                }
            }
            if (_this.procAudio.status.MadiRxStatus) {
                _this.madiRxStatusIdxArray = [];
                _this.procAudio.status.MadiRxStatus.forEach(function (s, i) {
                    _this.madiRxStatusIdxArray.push({
                        label: '' + (i + 1),
                        value: i
                    });
                });
            }
            // if SFP Type is MADI, replace EXP labels.
            if (_this.getSfpRxState() === common_1.SFP_TYPE_2RX_MADI) {
                if (_this.procAudio.configMetadata.properties) {
                    var meta = _this.procAudio.configMetadata.properties.AudTxMadiRouting.items.properties;
                    for (var chIdx in meta) {
                        if (meta[chIdx].enumLabels) {
                            for (var labelIdx in meta[chIdx].enumLabels) {
                                var label = meta[chIdx].enumLabels[labelIdx];
                                if (label.includes('EXP')) {
                                    var index = label.split(' ')[1];
                                    var section = Math.floor((index - 1) / 64) + 1;
                                    var channel = ((index - 1) % 64);
                                    meta[chIdx].enumLabels[labelIdx] = label.replace(/EXP.*\d/, "MADI RX " + section.toString() + " : " + channel.toString());
                                }
                            }
                        }
                    }
                }
            }
            else {
                if (_this.procAudio.configMetadata.properties) {
                    var meta = _this.procAudio.configMetadata.properties.AudTxMadiRouting.items.properties;
                    for (var chIdx in meta) {
                        if (meta[chIdx].enumLabels) {
                            for (var labelIdx in meta[chIdx].enumLabels) {
                                var label = meta[chIdx].enumLabels[labelIdx];
                                if (label.includes('MADI')) {
                                    var index = parseInt(labelIdx) - 255;
                                    meta[chIdx].enumLabels[labelIdx] = "EXP " + index.toString();
                                }
                            }
                        }
                    }
                }
            }
            if (_this.procAudio.config.AudTxMadiRouting) {
                _this.madiTxChSelectFormStatusArray = [];
                _this.procAudio.config.AudTxMadiRouting.forEach(function (s, i) {
                    _this.madiTxChSelectFormStatusArray.push(true);
                    _this.$scope.$broadcast('adjustedMetadata', {
                        property: '/AudTxMadiRouting/' + (s.idx - 1) + '/MadiTxChSelect'
                    });
                    s.labelIdx = 'MADI ' + (~~((s.idx - 1) / 64) + 1).toString() + " : " + (((s.idx - 1) % 64)).toString();
                });
            }
            if (_this.processor.general.personality === common_1.SNP_PERSONALITY_MV || _this.processor.general.personality === common_1.SNP_PERSONALITY_MVP ||
                _this.processor.general.personality === common_1.SNP_PERSONALITY_CONVERT || _this.processor.general.personality === common_1.SNP_PERSONALITY_CONV4)
                _this.isMADIControlEnabled = false;
        };
        this.onApply = function () {
            var partial = {};
            partial = {
                active: _this.procAudio.config.active,
                cacheKey: _this.procAudio.config.cacheKey,
                fme_ip: _this.procAudio.config.fme_ip,
                name: _this.procAudio.config.name,
                object_ID: _this.procAudio.config.object_ID,
                type: _this.procAudio.config.type,
                AudExpInputPairSRC: _this.procAudio.config.AudExpInputPairSRC
            };
            if (_this.sfpTxRole === 8) {
                partial = __assign({}, partial, { MadiTxControl: _this.procAudio.config.MadiTxControl, AudTxMadiRouting: _this.procAudio.config.AudTxMadiRouting });
            }
            return _this.snpListSrv.applyPartialUpdate(partial, function (report) {
                _this.report = report;
                _this.updateTabValidity();
            }, _this.madiForm);
        };
        this.updateTabValidity = function () {
            var isFormValid = angular_1.isUndefined(_this.madiForm) || _this.madiForm.$valid;
            var isReportError = angular_1.isDefined(_this.report) && angular_1.isDefined(_this.report.hasErrorMsg) && !!_this.report.hasErrorMsg;
            _this.tabState.valid = isFormValid && !isReportError;
        };
        this.onIndexChange = function (newIndex, oldIndex) {
            _this.madiTxChSelectFormStatusArray[parseInt(oldIndex)] = _this.madiTxChSelectForm.$pristine;
            _this.madiTxChSelectForm.$setPristine();
            if (_this.madiTxChSelectFormStatusArray[newIndex] !== true) {
                _this.madiTxChSelectForm.$setDirty();
            }
        };
        this.onAudExpInputIndexChange = function (newIndex, oldIndex) {
            console.log(newIndex);
            _this.audSRCFormStatusArray[parseInt(oldIndex)] = _this.audSRCForm.$pristine;
            _this.audSRCForm.$setPristine();
            if (_this.audSRCFormStatusArray[newIndex] !== true) {
                _this.audSRCForm.$setDirty();
            }
        };
        this.$doCheck = function () {
            if (_this.sfpTxRole !== _this.getSfpTxState() || _this.sfpRxRole !== _this.getSfpRxState()) {
                _this.sfpTxRole = _this.getSfpTxState();
                _this.sfpRxRole = _this.getSfpRxState();
                _this.init();
            }
            _this.tabState.dirty = _this.madiForm && _this.madiForm.$dirty;
        };
        this.getSfpRxState = function () {
            if (_this.system.status.SNP_HW_Stats.Chassis === common_1.SNP_XL) {
                return _this.processor.general.sfpRxSelect;
            }
            return _this.processor.general.sfpSelect;
        };
        this.getSfpTxState = function () {
            if (_this.system.status.SNP_HW_Stats.Chassis === common_1.SNP_XL) {
                return _this.processor.general.sfpTxSelect;
            }
            return _this.processor.general.sfpSelect;
        };
        this.$onDestroy = function () { };
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
        this.init();
    }
    SnpProcessorMadiCtrl.$inject = ['snpListSrv', 'userManagerSrv', '$scope'];
    return SnpProcessorMadiCtrl;
}());
exports.SnpProcessorMadiCtrl = SnpProcessorMadiCtrl;


/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/madi/madi.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/processor/processor-modal-window/madi/madi.template.html?8f8699d155a9fd9a8ad3d045cdb8e8ff";

/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/mcl/mcl.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var mcl_controller_1 = __webpack_require__("./app/view-menu/processor/processor-modal-window/mcl/mcl.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/processor/processor-modal-window/mcl/mcl.template.html");
exports.SnpProcessorMclComponent = {
    bindings: {
        fmeIp: '<',
        processor: '=',
        license: '=',
        licenseTokens: '=',
        switchState: '=',
        tabState: '=',
        applyButtons: '=',
        userViewOnly: '<',
        liveCallback: '<'
    },
    controller: mcl_controller_1.SnpProcessorMclCtrl,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/mcl/mcl.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 Copyright (c) 2018 Imagine Communications Corp.
 All rights reserved.
 */
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var common_1 = __webpack_require__("./app/view-menu/common.js");
var SnpProcessorMclCtrl = (function () {
    function SnpProcessorMclCtrl(fmeListSrv, snpListSrv, commonUtils, $scope, liveParamsSrv, uiModalsSrv) {
        var _this = this;
        this.fmeListSrv = fmeListSrv;
        this.snpListSrv = snpListSrv;
        this.commonUtils = commonUtils;
        this.$scope = $scope;
        this.liveParamsSrv = liveParamsSrv;
        this.uiModalsSrv = uiModalsSrv;
        this.report = undefined;
        this.reportError = false;
        this.isMclControlEnabled = false;
        this.isDualDSK = false;
        this.currentMclMode = 0;
        this.originalTriggerActionList = [
            {
                value: "None",
                label: "None"
            },
            {
                value: "PGM1 Take",
                label: "PGM/PGM1 Take"
            },
            {
                value: "PGM2 Take",
                label: "PGM2 Take"
            },
            {
                value: "PGM1 FTB",
                label: "PGM/PGM1 FTB"
            },
            {
                value: "PGM2 FTB",
                label: "PGM2 FTB"
            },
            {
                value: "BKGD",
                label: "BKGD"
            },
            {
                value: "PGM1 Key",
                label: "PGM/PGM1 Key"
            },
            {
                value: "PGM2 Key",
                label: "PST/PGM2 Key"
            },
            {
                value: "PGM1 Audio Over",
                label: "PGM/PGM1 Audio Over"
            },
            {
                value: "PGM2 Audio Over",
                label: "PST/PGM2 Audio Over"
            },
            {
                value: "PGM1 Auto Hold",
                label: "PGM/PGM1 Auto Hold"
            },
            {
                value: "PGM2 Auto Hold",
                label: "PGM2 Auto Hold"
            },
            {
                value: "PGM1 Source Select",
                label: "PGM/PGM1 Source Select"
            },
            {
                value: "PGM2 Source Select",
                label: "PST/PGM2 Source Select"
            },
            {
                value: "MCL.TxnType Cut",
                label: "MCL.Set Transition Type to Cut"
            },
            {
                value: "MCL.TxnType VFade",
                label: "MCL.Set Transition Type to V-Fade"
            },
            {
                value: "MCL.TxnType CutFade",
                label: "MCL.Set Transition Type to Cut-Fade"
            },
            {
                value: "MCL.TxnType FadeCut",
                label: "MCL.Set Transition Type to Fade-Cut"
            },
            {
                value: "MCL.TxnType XFade",
                label: "MCL.Set Transition Type to X-Fade"
            },
            {
                value: "MCL.TxnSpd Fast",
                label: "MCL.Set Transition Speed to Fast"
            },
            {
                value: "MCL.TxnSpd Medium",
                label: "MCL.Set Transition Speed to Medium"
            },
            {
                value: "MCL.TxnSpd Slow",
                label: "MCL.Set Transition Speed to Slow"
            }
        ];
        // List of EAS protocols that may support multiple text encodings
        this.multiEncodingProtocols = new Set([
            4,
        ]);
        // List of EAS protocols that can provide message appearance in the alert
        this.appearanceIncludedProtocols = new Set([
            1,
        ]);
        this.srcNameIdxArray = [];
        this.audioLayerIdxArray = [];
        this.audioChannelIdxArray = [];
        this.gpiIndexArray = [];
        this.gpoIndexArray = [];
        this.easWindowIndexArray = [];
        this.checkIfKeyerDisabled = function (keyerNum) {
            if (_this.configs.mcl.config.KeyerControl[keyerNum].SrcSelect === "No Key") {
                return true;
            }
            else if ((_this.processor.general.mclOutputVideoStandard === "2160p/50" || _this.processor.general.mclOutputVideoStandard === "2160p/59.94") && (_this.configs.mcl.config.KeyerControl[keyerNum].SrcSelect === "External")) {
                if (_this.configs.mcl.config.MclConfiguration.UHD_InputRoutingConfiguration === "AB") {
                    return true;
                }
                if (keyerNum > 0 && (_this.configs.mcl.config.MclConfiguration.UHD_InputRoutingConfiguration === "ABKF" || _this.configs.mcl.config.MclConfiguration.UHD_InputRoutingConfiguration === "KFAB")) {
                    return true;
                }
                if (keyerNum > 1 && (_this.configs.mcl.config.MclConfiguration.UHD_InputRoutingConfiguration === "ABKFKF" || _this.configs.mcl.config.MclConfiguration.UHD_InputRoutingConfiguration === "KFABKF")) {
                    return true;
                }
                if (keyerNum > 2) {
                    return true;
                }
                return false;
            }
            else {
                return false;
            }
        };
        this.isMixAssignmentEnabled = function (idx) {
            return _this.configs.mcl.config.AudioChannelConfiguration[idx].MixerDuckBehavior === 'Duck and Mix';
        };
        this.getGraphicsListForKeyer = function () {
            _this.lastGfxList = _this.configs.mcl.config.KeyerControl[0].SrcSelect_optList;
            _this.lastGfxOnlineList = _this.statuses.mcl.status.LogoStatus.onlineLogos;
            _this.lastGfxCachedList = _this.statuses.mcl.status.LogoStatus.cachedLogos;
            var gfxEnum = ["No Key", "External"];
            var gfxEnumLabels = ["No Key", "External"];
            var gfxList = _this.lastGfxList.split(':');
            var onlineList = _this.lastGfxOnlineList.split(':');
            var cachedList = _this.lastGfxCachedList.split(':');
            for (var index in gfxList) {
                if (gfxEnum.indexOf(gfxList[index]) == -1) {
                    var gfxLabel = gfxList[index];
                    gfxEnum = gfxEnum.concat(gfxLabel);
                    if (onlineList.indexOf(gfxLabel) != -1) {
                        gfxEnumLabels = gfxEnumLabels.concat(gfxLabel + " [Online]");
                    }
                    else if (cachedList.indexOf(gfxLabel) != -1) {
                        gfxEnumLabels = gfxEnumLabels.concat(gfxLabel + " [Cached]");
                    }
                    else {
                        gfxEnumLabels = gfxEnumLabels.concat(gfxLabel + " [Offline]");
                    }
                }
            }
            _this.configs.mcl.meta.properties.KeyerControl.items.properties.SrcSelect.enum = gfxEnum;
            _this.configs.mcl.meta.properties.KeyerControl.items.properties.SrcSelect.enumLabels = gfxEnumLabels;
            for (var i = 0; i < 4; i++) {
                _this.$scope.$broadcast('adjustedMetadata', {
                    property: '/KeyerControl/' + i + '/SrcSelect'
                });
            }
        };
        this.getSourceListForRouting = function () {
            _this.lastSrcNameList = _this.configs.mcl.config.RoutingControl.PgmSrcSelect_optList;
            var srcEnum = _this.lastSrcNameList.split(":");
            _this.configs.mcl.meta.properties.RoutingControl.properties.PgmSrcSelect.enum = srcEnum;
            _this.$scope.$broadcast('adjustedMetadata', {
                property: '/RoutingControl/PgmSrcSelect'
            });
            _this.configs.mcl.meta.properties.RoutingControl.properties.PstSrcSelect.enum = srcEnum;
            _this.$scope.$broadcast('adjustedMetadata', {
                property: '/RoutingControl/PstSrcSelect'
            });
            _this.configs.mcl.meta.properties.RoutingControl.properties.AuxSrcSelect.enum = srcEnum;
            _this.$scope.$broadcast('adjustedMetadata', {
                property: '/RoutingControl/AuxSrcSelect'
            });
        };
        this.getFXList = function () {
            _this.lastFxList = _this.configs.mcl.config.TransitionControls.Pgm1_FXSelect_optList;
            var fxEnum = _this.lastFxList.split(":");
            _this.configs.mcl.meta.properties.TransitionControls.properties.Pgm1_FXSelect.enum = fxEnum;
            _this.$scope.$broadcast('adjustedMetadata', {
                property: '/TransitionControls/Pgm1_FXSelect'
            });
            _this.configs.mcl.meta.properties.TransitionControls.properties.Pgm2_FXSelect.enum = fxEnum;
            _this.$scope.$broadcast('adjustedMetadata', {
                property: '/TransitionControls/Pgm2_FXSelect'
            });
        };
        this.getSection2CleanFeedList = function () {
            _this.lastCleanFeedList = _this.configs.mcl.config.CleanFeedConfiguration.CleanFeedOutput2_optList;
            var srcEnum = _this.lastCleanFeedList.split(":");
            _this.configs.mcl.meta.properties.CleanFeedConfiguration.properties.CleanFeedOutput2.enum = srcEnum;
            _this.$scope.$broadcast('adjustedMetadata', {
                property: '/CleanFeedConfiguration/CleanFeedOutput2'
            });
            _this.configs.mcl.meta.properties.CleanFeedConfiguration.properties.CleanFeedOutput4.enum = srcEnum;
            _this.$scope.$broadcast('adjustedMetadata', {
                property: '/CleanFeedConfiguration/CleanFeedOutput4'
            });
            _this.configs.mcl.meta.properties.CleanFeedConfiguration.properties.CleanFeedOutput6.enum = srcEnum;
            _this.$scope.$broadcast('adjustedMetadata', {
                property: '/CleanFeedConfiguration/CleanFeedOutput6'
            });
        };
        this.preventAngularjsAssigningTheNextNgclickAsKeypressHandlerByDefault = function () {
            console.log('Grounding keyPress handler');
        };
        this.updateTriggerActionDropdownLabels = function () {
            _this.lastTriggerActionList = _this.configs.mcl.config.GPIConfiguration[0].triggerAction_optList;
            var triggerActionEnumList = _this.lastTriggerActionList.split(":");
            _this.configs.mcl.meta.properties.GPIConfiguration.items.properties.triggerAction.enum = _this.originalTriggerActionList.filter(function (item) { return triggerActionEnumList.indexOf(item.value) !== -1; });
            _this.configs.mcl.meta.properties.GPIConfiguration.items.properties.triggerAction.enumLabels = undefined;
            _this.configs.mcl.meta.properties.GPIConfiguration.items.properties.triggerAction.disabledIsHidden = true;
            _this.$scope.$broadcast('adjustedMetadata', {
                property: "/GPIConfiguration/" + (_this.gpiIndex - 1) + "/triggerAction"
            });
        };
        this.updateRoutingConfigNames = function () {
            if (_this.processor.general.personality === common_1.SNP_PERSONALITY_MCL) {
                if (_this.statuses.mcl.meta.properties.mclStatus.properties.hasOwnProperty("RoutingPgmSrcStatus")) {
                    if (_this.isDualDSK) {
                        _this.statuses.mcl.meta.properties.mclStatus.properties.RoutingPgmSrcStatus.title = "PGM1 Status";
                    }
                    else {
                        _this.statuses.mcl.meta.properties.mclStatus.properties.RoutingPgmSrcStatus.title = "Program Status";
                    }
                    _this.$scope.$broadcast('adjustedMetadata', {
                        property: '/mclStatus/RoutingPgmSrcStatus'
                    });
                }
                if (_this.statuses.mcl.meta.properties.mclStatus.properties.hasOwnProperty("RoutingPstSrcStatus")) {
                    if (_this.isDualDSK) {
                        _this.statuses.mcl.meta.properties.mclStatus.properties.RoutingPstSrcStatus.title = "PGM2 Status";
                    }
                    else {
                        _this.statuses.mcl.meta.properties.mclStatus.properties.RoutingPstSrcStatus.title = "Preset Status";
                    }
                    _this.$scope.$broadcast('adjustedMetadata', {
                        property: '/mclStatus/RoutingPstSrcStatus'
                    });
                }
                if (_this.configs.mcl.meta.properties.RoutingControl.properties.hasOwnProperty("PgmSrcSelect")) {
                    if (_this.isDualDSK) {
                        _this.configs.mcl.meta.properties.RoutingControl.properties.PgmSrcSelect.title = "PGM1 Source Select";
                    }
                    else {
                        _this.configs.mcl.meta.properties.RoutingControl.properties.PgmSrcSelect.title = "Program Source Select";
                    }
                    _this.$scope.$broadcast('adjustedMetadata', {
                        property: '/RoutingControl/PgmSrcSelect'
                    });
                }
                if (_this.configs.mcl.meta.properties.RoutingControl.properties.hasOwnProperty("PstSrcSelect")) {
                    if (_this.isDualDSK) {
                        _this.configs.mcl.meta.properties.RoutingControl.properties.PstSrcSelect.title = "PGM2 Source Select";
                    }
                    else {
                        _this.configs.mcl.meta.properties.RoutingControl.properties.PstSrcSelect.title = "Preset Source Select";
                    }
                    _this.$scope.$broadcast('adjustedMetadata', {
                        property: '/RoutingControl/PstSrcSelect'
                    });
                }
                if (_this.configs.mcl.meta.properties.RoutingControl.properties.hasOwnProperty("PgmFollow")) {
                    if (_this.isDualDSK) {
                        _this.configs.mcl.meta.properties.RoutingControl.properties.PgmFollow.title = "PGM1 Follow";
                    }
                    else {
                        _this.configs.mcl.meta.properties.RoutingControl.properties.PgmFollow.title = "Program Follow";
                    }
                    _this.$scope.$broadcast('adjustedMetadata', {
                        property: '/RoutingControl/PgmFollow'
                    });
                }
                if (_this.configs.mcl.meta.properties.RoutingControl.properties.hasOwnProperty("PstFollow")) {
                    if (_this.isDualDSK) {
                        _this.configs.mcl.meta.properties.RoutingControl.properties.PstFollow.title = "PGM2 Follow";
                    }
                    else {
                        _this.configs.mcl.meta.properties.RoutingControl.properties.PstFollow.title = "Preset Follow";
                    }
                    _this.$scope.$broadcast('adjustedMetadata', {
                        property: '/RoutingControl/PstFollow'
                    });
                }
            }
        };
        this.init = function () {
            if (_this.processor.general.personality === common_1.SNP_PERSONALITY_MCL) {
                _this.applyButtons = [
                    {
                        label: 'Apply MCL',
                        isDisabled: function () {
                            return _this.mclForm.$pristine;
                        },
                        click: _this.onApply,
                    }
                ];
                _this.isMclControlEnabled = true;
                _this.currentMclMode = _this.processor.general.mclMode;
                if (_this.processor.general.mclMode === 0) {
                    _this.isDualDSK = true;
                }
                else {
                    _this.isDualDSK = false;
                }
                if (_this.isDualDSK && _this.isHotPunchChecked) {
                    _this.hidePostTransitionEnable = true;
                }
                else {
                    _this.hidePostTransitionEnable = false;
                }
            }
        };
        this.updateOrigConfig = function () {
            _this.origMcl = angular_1.copy(_this.configs.mcl.config);
        };
        this.onApply = function () {
            var partial = angular_1.copy(_this.configs.mcl.config);
            for (var key1 in partial) {
                if (partial.hasOwnProperty(key1)) {
                    if (_this.matchOrigConfig(key1)) {
                        delete partial[key1];
                    }
                    else if (typeof (partial[key1]) === 'object') {
                        for (var key2 in partial[key1]) {
                            if (partial[key1].hasOwnProperty(key2)) {
                                if (_this.matchOrigConfig(key1, key2)) {
                                    delete partial[key1][key2];
                                }
                                else if (typeof (partial[key1][key2]) === 'object') {
                                    for (var key3 in partial[key1][key2]) {
                                        if (partial[key1][key2].hasOwnProperty(key3)) {
                                            if (_this.matchOrigConfig(key1, key2, key3)) {
                                                delete partial[key1][key2][key3];
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            partial = __assign({}, partial, { cacheKey: _this.configs.mcl.config.cacheKey, fme_ip: _this.configs.mcl.config.fme_ip, name: _this.configs.mcl.config.name, object_ID: _this.configs.mcl.config.object_ID, type: _this.configs.mcl.config.type });
            return _this.snpListSrv.applyPartialUpdate(partial, function (report) {
                _this.report = report;
                if (_this.report) {
                    _this.report.partial = partial;
                }
                _this.updateOrigConfig();
                _this.updateTabValidity();
            }, _this.mclForm).then(function () {
                _this.isHotPunchChecked = _this.configs.mcl.config.MclConfiguration.HotPunch === true;
                if (_this.isDualDSK && _this.isHotPunchChecked) {
                    _this.hidePostTransitionEnable = true;
                }
                else {
                    _this.hidePostTransitionEnable = false;
                }
            });
        };
        this.liveControlCallback = function (param, value) {
            if (_this.liveUpdater) {
                _this.liveUpdater.onUserInteraction(param, value);
            }
        };
        this.liveControlCallbackEASEnabled = function (param, value) {
            if (value === true) {
                _this.snpListSrv.checkLicense(_this.license, _this.licenseTokens, 'SNP-SK-EAS', 'Emergency Alert System', "", _this.processor.object_ID);
            }
            _this.liveControlCallback(param, value);
        };
        this.keyerControlCallback = function (param, value) {
            var partial = {
                KeyerControl: angular_1.copy(_this.configs.mcl.config.KeyerControl),
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            partial.KeyerControl.forEach(function (elem) {
                for (var key in elem) {
                    if (key !== 'idx') {
                        delete elem[key];
                    }
                }
            });
            _this.setKeyerControlPropToPartial(partial, param, value);
            _this.fmeListSrv.updatePartialObject(partial).then(function () {
                _this.updateOrigConfig();
            });
        };
        this.srcNameTableCallback = function (param, value) {
            var partial = {
                SrcNameTable: angular_1.copy(_this.configs.mcl.config.SrcNameTable),
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            partial.SrcNameTable.forEach(function (elem) {
                for (var key in elem) {
                    if (key !== 'idx') {
                        delete elem[key];
                    }
                }
            });
            _this.setSrcNameTablePropToPartial(partial, param, value);
            _this.fmeListSrv.updatePartialObject(partial).then(function () {
                _this.updateOrigConfig();
            });
        };
        this.toggleProgram1Key = function (idx) {
            var currentValue = _this.configs.mcl.config.KeyerControl[idx].Pgm1_Key;
            var toggledValue = !currentValue;
            var bHotPunch = _this.configs.mcl.config.MclConfiguration.HotPunch;
            var partial = {
                KeyerControl: [
                    {
                        idx: -1,
                        Pgm1_Key: false
                    }
                ],
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            var idxAdjustedToSendInNative = idx + 1; // on native side indices are expected from 1
            partial.KeyerControl = [
                {
                    idx: idxAdjustedToSendInNative,
                    Pgm1_Key: toggledValue
                }
            ];
            _this.snpListSrv
                .applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.mclForm)
                .then(function () {
                // updated value will be used in liveCallback and html
                if (_this.isDualDSK && !bHotPunch) {
                    _this.configs.mcl.config.KeyerControl[idx].Pgm1_Key = toggledValue;
                }
                else {
                    _this.configs.mcl.config.KeyerControl[idx].Pgm1_Key = false;
                }
            });
        };
        this.toggleFTB = function (pgm) {
            var currentValue;
            if (pgm === 2) {
                currentValue = _this.configs.mcl.config.FadeToBlackControls.Pgm2_FadeToBlackTake;
            }
            else {
                currentValue = _this.configs.mcl.config.FadeToBlackControls.Pgm1_FadeToBlackTake;
            }
            var toggledValue = !currentValue;
            var partial = {
                FadeToBlackControls: {},
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            if (pgm == 2) {
                partial.FadeToBlackControls = {
                    Pgm2_FadeToBlackTake: toggledValue
                };
            }
            else {
                partial.FadeToBlackControls = {
                    Pgm1_FadeToBlackTake: toggledValue
                };
            }
            _this.snpListSrv
                .applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.mclForm)
                .then(function () {
                // updated value will be used in liveCallback and html
                if (pgm === 2) {
                    _this.configs.mcl.config.FadeToBlackControls.Pgm2_FadeToBlackTake = toggledValue;
                }
                else {
                    _this.configs.mcl.config.FadeToBlackControls.Pgm1_FadeToBlackTake = toggledValue;
                }
            });
        };
        this.toggleAudioOver = function (pgm) {
            var currentValue;
            if (pgm === 2) {
                currentValue = _this.configs.mcl.config.TransitionControls.Pgm2_AudioOver;
            }
            else {
                currentValue = _this.configs.mcl.config.TransitionControls.Pgm1_AudioOver;
            }
            var toggledValue = !currentValue;
            var bHotPunch = _this.configs.mcl.config.MclConfiguration.HotPunch;
            var partial = {
                TransitionControls: {},
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            if (pgm == 2) {
                partial.TransitionControls = {
                    Pgm2_AudioOver: toggledValue
                };
            }
            else {
                partial.TransitionControls = {
                    Pgm1_AudioOver: toggledValue
                };
            }
            _this.snpListSrv
                .applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.mclForm)
                .then(function () {
                // updated value will be used in liveCallback and html
                var newValue;
                if (pgm === 2) {
                    if ((!_this.isDualDSK) || (_this.isDualDSK && !bHotPunch)) {
                        newValue = toggledValue;
                    }
                    else {
                        newValue = false;
                    }
                    _this.configs.mcl.config.TransitionControls.Pgm2_AudioOver = newValue;
                }
                else {
                    if (_this.isDualDSK && !bHotPunch) {
                        newValue = toggledValue;
                    }
                    else {
                        newValue = false;
                    }
                    _this.configs.mcl.config.TransitionControls.Pgm1_AudioOver = newValue;
                }
            });
        };
        this.toggleAutoHold = function (pgm) {
            var currentValue;
            if (pgm === 2) {
                currentValue = _this.configs.mcl.config.TransitionControls.Pgm2_AutoHold;
            }
            else {
                currentValue = _this.configs.mcl.config.TransitionControls.Pgm1_AutoHold;
            }
            var toggledValue = !currentValue;
            var partial = {
                TransitionControls: {},
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            if (pgm == 2) {
                partial.TransitionControls = {
                    Pgm2_AutoHold: toggledValue
                };
            }
            else {
                partial.TransitionControls = {
                    Pgm1_AutoHold: toggledValue
                };
            }
            _this.snpListSrv
                .applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.mclForm)
                .then(function () {
                // updated value will be used in liveCallback and html
                if (pgm === 2) {
                    _this.configs.mcl.config.TransitionControls.Pgm2_AutoHold = toggledValue;
                }
                else {
                    _this.configs.mcl.config.TransitionControls.Pgm1_AutoHold = toggledValue;
                }
            });
        };
        this.toggleProgram2Key = function (idx) {
            var currentValue = _this.configs.mcl.config.KeyerControl[idx].Pgm2_Key;
            var toggledValue = !currentValue;
            var bHotPunch = _this.configs.mcl.config.MclConfiguration.HotPunch;
            var partial = {
                KeyerControl: [
                    {
                        idx: -1,
                        Pgm2_Key: false
                    }
                ],
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            var idxAdjustedToSendInNative = idx + 1; // on native side indices are expected from 1
            partial.KeyerControl = [
                {
                    idx: idxAdjustedToSendInNative,
                    Pgm2_Key: toggledValue
                }
            ];
            _this.snpListSrv
                .applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.mclForm)
                .then(function () {
                // updated value will be used in liveCallback and html
                if ((!_this.isDualDSK) || (_this.isDualDSK && !bHotPunch)) {
                    _this.configs.mcl.config.KeyerControl[idx].Pgm2_Key = toggledValue;
                }
                else {
                    _this.configs.mcl.config.KeyerControl[idx].Pgm2_Key = false;
                }
            });
        };
        this.toggleBackground = function (idx) {
            var currentValue = _this.configs.mcl.config.TransitionControls.Background;
            var toggledValue = !currentValue;
            var partial = {
                TransitionControls: {},
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            partial.TransitionControls = {
                Background: toggledValue
            };
            _this.snpListSrv
                .applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.mclForm)
                .then(function () {
                // updated value will be used in liveCallback and html
                _this.configs.mcl.config.TransitionControls.Background = toggledValue;
            });
        };
        this.toggleProgram1Take = function () {
            var currentValue = _this.configs.mcl.config.TransitionControls.Pgm1_TAKE;
            var toggledValue = !currentValue;
            var partial = {
                TransitionControls: {},
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            partial.TransitionControls = {
                Pgm1_TAKE: toggledValue
            };
            _this.snpListSrv
                .applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.mclForm)
                .then(function () {
                // updated value will be used in liveCallback and html
                _this.configs.mcl.config.TransitionControls.Pgm1_TAKE = false;
            });
        };
        this.toggleProgram2Take = function () {
            var currentValue = _this.configs.mcl.config.TransitionControls.Pgm2_TAKE;
            var toggledValue = !currentValue;
            var partial = {
                TransitionControls: {},
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            partial.TransitionControls = {
                Pgm2_TAKE: toggledValue
            };
            _this.snpListSrv
                .applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.mclForm)
                .then(function () {
                // updated value will be used in liveCallback and html
                _this.configs.mcl.config.TransitionControls.Pgm2_TAKE = false;
            });
        };
        this.onSrcNameIndexChange = function (newIndex, oldIndex) {
            _this.arrayIndexes.SrcNameTable = common_1.snpSparseArrayIdx(_this.configs.mcl.config.SrcNameTable, newIndex);
        };
        this.onAudioLayerIndexChange = function (newIndex, oldIndex) {
            _this.audioLayerIdx = newIndex;
            _this.arrayIndexes.AudioChannelConfiguration = common_1.snpSparseArrayIdx(_this.configs.mcl.config.AudioChannelConfiguration, (_this.audioLayerIdx * 16) + _this.audioChannelIdx);
        };
        this.onAudioChannelIndexChange = function (newIndex, oldIndex) {
            _this.audioChannelIdx = newIndex;
            _this.arrayIndexes.AudioChannelConfiguration = common_1.snpSparseArrayIdx(_this.configs.mcl.config.AudioChannelConfiguration, (_this.audioLayerIdx * 16) + _this.audioChannelIdx);
        };
        this.onGPIIndexChange = function (newIndex, oldIndex) {
            _this.gpiIndex = newIndex;
            _this.arrayIndexes.GPIConfig = common_1.snpSparseArrayIdx(_this.configs.mcl.config.GPIConfiguration, newIndex);
        };
        this.onGPOIndexChange = function (newIndex, oldIndex) {
            _this.gpoIndex = newIndex;
            _this.arrayIndexes.GPOConfig = common_1.snpSparseArrayIdx(_this.configs.mcl.config.GPOConfiguration, newIndex);
        };
        this.onEASWindowIndexChange = function (newIndex, oldIndex) {
            _this.easWindowIndex = newIndex;
            _this.arrayIndexes.EASWindows = common_1.snpSparseArrayIdx(_this.configs.mcl.config.EASWindows, newIndex);
        };
        this.toggleProgram1MasterGainReset = function () {
            var toggledValue = true;
            var partial = {
                AudioControls: {},
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            partial.AudioControls = {
                Pgm1_MasterGainReset: toggledValue
            };
            _this.snpListSrv
                .applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.mclForm)
                .then(function () {
                // updated value will be used in liveCallback and html
                _this.configs.mcl.config.AudioControls.Pgm1_MasterGainReset = toggledValue;
            });
        };
        this.toggleProgram2MasterGainReset = function () {
            var toggledValue = true;
            var partial = {
                AudioControls: {},
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            partial.AudioControls = {
                Pgm2_MasterGainReset: toggledValue
            };
            _this.snpListSrv
                .applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.mclForm)
                .then(function () {
                // updated value will be used in liveCallback and html
                _this.configs.mcl.config.AudioControls.Pgm2_MasterGainReset = toggledValue;
            });
        };
        this.toggleAudioGainReset = function (idx) {
            var toggledValue = true;
            var partial = {
                KeyerControl: [
                    {
                        idx: -1,
                        AudioGainReset: false
                    }
                ],
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            var idxAdjustedToSendInNative = idx + 1; // on native side indices are expected from 1
            partial.KeyerControl = [
                {
                    idx: idxAdjustedToSendInNative,
                    AudioGainReset: toggledValue
                }
            ];
            _this.snpListSrv
                .applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.mclForm)
                .then(function () {
                // updated value will be used in liveCallback and html
                _this.configs.mcl.config.KeyerControl[idx].AudioGainReset = toggledValue;
            });
        };
        this.toggleAudioOverGainReset = function () {
            var toggledValue = true;
            var partial = {
                AudioControls: {},
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            partial.AudioControls = {
                AudioOverGainReset: toggledValue
            };
            _this.snpListSrv
                .applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.mclForm)
                .then(function () {
                // updated value will be used in liveCallback and html
                _this.configs.mcl.config.AudioControls.AudioOverGainReset = toggledValue;
            });
        };
        this.toggleEASGainReset = function () {
            var toggledValue = true;
            var partial = {
                AudioControls: {},
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            partial.AudioControls = {
                EASGainReset: toggledValue
            };
            console.log('[BEFORE] EASGain', _this.configs.mcl.config.AudioControls.EASGain);
            _this.snpListSrv
                .applyPartialUpdate(partial, function (report) {
                _this.report = report;
                console.log('[REPORT]', report);
            }, _this.mclForm)
                .then(function () {
                console.log("Before reset:", _this.configs.mcl.config.AudioControls.EASGain);
                // updated value will be used in liveCallback and html
                _this.configs.mcl.config.AudioControls.EASGainReset = toggledValue;
                console.log("Reset triggered:", _this.configs.mcl.config.AudioControls.EASGainReset);
                console.log("after reset: toggledValue", toggledValue);
                console.log('[AFTER] EASGainReset flag set to true');
                console.log('[AFTER] EASGain (local)', _this.configs.mcl.config.AudioControls.EASGain);
            });
        };
        this.getUHDRoutingConfigList = function (mclID) {
            switch (mclID) {
                case "MasterControl-A":
                    if (common_1.FFLAG_MCL_FX_ENABLED)
                        return ["AB", "ABKF", "KFAB", "ABKFKF", "KFABKF", "ABKFKFKF", "KFABKFKF", "ABFX", "ABKFFX", "KFABFX", "ABKFKFFX", "KFABKFFX"];
                    else
                        return ["AB", "ABKF", "KFAB", "ABKFKF", "KFABKF", "ABKFKFKF", "KFABKFKF"];
                case "MasterControl-B":
                    return ["AB"];
                case "MasterControl-C":
                    if (common_1.FFLAG_MCL_FX_ENABLED)
                        return ["AB", "ABKF", "KFAB", "ABFX"];
                    else
                        return ["AB", "ABKF", "KFAB"];
                case "MasterControl-D":
                    return ["AB"];
            }
        };
        this.getTransitionTypeConfigList = function (mclID, channel) {
            switch (channel) {
                case 0:
                    switch (mclID) {
                        case "MasterControl-A":
                        case "MasterControl-C":
                            if (common_1.FFLAG_MCL_FX_ENABLED)
                                return ["Cut", "V-Fade", "Cut-Fade", "Fade-Cut", "X-Fade", "Effects (FX)"];
                            else
                                return ["Cut", "V-Fade", "Cut-Fade", "Fade-Cut", "X-Fade"];
                        case "MasterControl-B":
                        case "MasterControl-D":
                            return ["Cut", "V-Fade", "Cut-Fade", "Fade-Cut", "X-Fade"];
                    }
                case 1:
                    switch (mclID) {
                        case "MasterControl-A":
                        case "MasterControl-C":
                            if (common_1.FFLAG_MCL_FX_ENABLED)
                                return ["Cut", "X-Fade", "Effects (FX)"];
                            else
                                return ["Cut", "X-Fade"];
                        case "MasterControl-B":
                        case "MasterControl-D":
                            return ["Cut", "X-Fade"];
                    }
            }
        };
        this.updateTabValidity = function () {
            var isFormValid = angular_1.isUndefined(_this.mclForm) || _this.mclForm.$valid;
            var isReportError = _this.report && _this.report.hasErrorMsg && !!_this.report.hasErrorMsg;
            // var isReportError = isDefined(this.report) && isDefined(this.report.hasErrorMsg) && !!this.report.hasErrorMsg;
            _this.tabState.valid = isFormValid && !isReportError;
        };
        this.onAirIndicatorState = function (status) {
            if (status === 'On') {
                return 'red';
            }
            else if (status === 'Fade to Black' || status === 'Fade to Silence') {
                return 'mclstatusblink';
            }
        };
        this.keyOnStatusState = function (status) {
            if (status === 1) {
                return 'red';
            }
            else if (status === 17) {
                return 'mclstatusblink';
            }
        };
        this.isGPIInputSourceVisible = function () {
            var inputFunction = _this.configs.mcl.config.GPIConfiguration[_this.gpiIndex - 1].triggerAction;
            return (inputFunction == "PGM1 Source Select") ||
                (inputFunction == "PGM2 Source Select");
        };
        this.isGPIInputKeyerVisible = function () {
            var inputFunction = _this.configs.mcl.config.GPIConfiguration[_this.gpiIndex - 1].triggerAction;
            return (inputFunction == "PGM1 Key") ||
                (inputFunction == "PGM2 Key");
        };
        this.isGPIOutputSourceVisible = function () {
            var outputFunction = _this.configs.mcl.config.GPOConfiguration[_this.gpoIndex - 1].triggerCondition;
            return (outputFunction == "PGM1 Source Number") ||
                (outputFunction == "PGM2 Source Number");
        };
        this.isGPIOutputKeyerVisible = function () {
            var outputFunction = _this.configs.mcl.config.GPOConfiguration[_this.gpoIndex - 1].triggerCondition;
            return (outputFunction == "PGM1 Key") ||
                (outputFunction == "PGM2 Key");
        };
        this.isTextEncodingVisible = function () {
            return _this.multiEncodingProtocols.has(_this.configs.mcl.config.EASConfiguration.DecoderProtocol);
        };
        this.isAppearanceSourceVisible = function () {
            return _this.appearanceIncludedProtocols.has(_this.configs.mcl.config.EASConfiguration.DecoderProtocol);
        };
        this.isFXVisible = function (channel) {
            if (!common_1.FFLAG_MCL_FX_ENABLED)
                return false;
            var procIdx = common_1.snpProcessorIdx(_this.processor.object_ID);
            var transType = (channel == 0) ? _this.configs.mcl.config.TransitionControls.Pgm1_TransitionType : _this.configs.mcl.config.TransitionControls.Pgm2_TransitionType;
            return transType == "Effects (FX)" && (procIdx == 0 || procIdx == 2);
        };
        this.triggerTestMessage = function () {
            var partial = {
                TextGenerator: {
                    TestMessage: _this.configs.mcl.config.TextGenerator.TestMessage,
                    TestSeverity: _this.configs.mcl.config.TextGenerator.TestSeverity,
                    TriggerTestMessage: true
                },
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            _this.snpListSrv
                .applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.mclForm)
                .then(function () {
                // updated value will be used in liveCallback and html
                _this.configs.mcl.config.TextGenerator.TriggerTestMessage = false;
                _this.showTestStopButton = !_this.showTestStopButton;
            });
        };
        this.onTriggerTestMessage = function () {
            if (!_this.showTestStopButton) {
                _this.uiModalsSrv.openConfirmModal({
                    title: "Start Test Message",
                    msg: "Are you sure you want to start the test message? This will effect live program outputs.",
                    buttons: [
                        {
                            label: "Yes",
                            callback: _this.triggerTestMessage
                        },
                        {
                            label: "No",
                        },
                    ],
                });
            }
            else {
                _this.triggerTestMessage();
            }
        };
        this.onGPIInputFunctionChange = function (value) {
            console.log(value);
        };
        this.onGPIOutputFunctionChange = function (value) {
            console.log(value);
        };
        this.onReceiveStatusHandler = function (status) {
            if (status.object_ID === common_1.snpMCLId(_this.processor)) {
                _this.statuses.mcl.status = status;
            }
            _this.showTestStopButton = !!(status.EasStatus.LastMessagePlayoutStatus === 'Currently Playing');
        };
        this.updateLogoPositionLimits = function () {
            if (_this.configs.mcl.meta.properties.KeyerControl.items.properties.hasOwnProperty("SrcInternalOffsetX") &&
                _this.configs.mcl.meta.properties.KeyerControl.items.properties.hasOwnProperty("SrcInternalOffsetY")) {
                if (_this.processor.general.mclOutputVideoStandard.startsWith("720")) {
                    _this.configs.mcl.meta.properties.KeyerControl.items.properties.SrcInternalOffsetX.maximum = 1280;
                    _this.configs.mcl.meta.properties.KeyerControl.items.properties.SrcInternalOffsetY.maximum = 720;
                }
                else if (_this.processor.general.mclOutputVideoStandard.startsWith("1080")) {
                    _this.configs.mcl.meta.properties.KeyerControl.items.properties.SrcInternalOffsetX.maximum = 1920;
                    _this.configs.mcl.meta.properties.KeyerControl.items.properties.SrcInternalOffsetY.maximum = 1080;
                }
                else {
                    _this.configs.mcl.meta.properties.KeyerControl.items.properties.SrcInternalOffsetX.maximum = 3840;
                    _this.configs.mcl.meta.properties.KeyerControl.items.properties.SrcInternalOffsetY.maximum = 2160;
                }
                for (var i = 0; i < _this.configs.mcl.config.KeyerControl.length; i++) {
                    _this.$scope.$broadcast('adjustedMetadata', {
                        property: '/KeyerControl/' + i + '/SrcInternalOffsetX'
                    });
                    _this.$scope.$broadcast('adjustedMetadata', {
                        property: '/KeyerControl/' + i + '/SrcInternalOffsetY'
                    });
                }
            }
            if (_this.configs.mcl.meta.properties.EASWindows.items.properties.hasOwnProperty("BgWidth")) {
                if (_this.processor.general.mclOutputVideoStandard.startsWith("720")) {
                    _this.configs.mcl.meta.properties.EASWindows.items.properties.BgWidth.maximum = 1280;
                }
                else if (_this.processor.general.mclOutputVideoStandard.startsWith("1080")) {
                    _this.configs.mcl.meta.properties.EASWindows.items.properties.BgWidth.maximum = 1920;
                }
                else {
                    _this.configs.mcl.meta.properties.EASWindows.items.properties.BgWidth.maximum = 3840;
                }
                for (var i = 0; i < _this.configs.mcl.config.EASWindows.length; i++) {
                    _this.$scope.$broadcast('adjustedMetadata', {
                        property: '/EASWindows/' + i + '/BgWidth'
                    });
                }
            }
        };
        this.onResetTextAppearance = function () {
            _this.uiModalsSrv.openConfirmModal({
                title: "Reset Text Appearance",
                msg: "Are you sure you want to reset the appearance of the text for this message severity?",
                buttons: [
                    {
                        label: "Yes",
                        callback: _this.resetTextAppearance,
                    },
                    {
                        label: "No",
                    },
                ],
            });
        };
        this.resetTextAppearance = function () {
            var partial = {
                EASWindows: [
                    {
                        idx: 1,
                        ResetTextAppearance: false
                    },
                    {
                        idx: 2,
                        ResetTextAppearance: false
                    },
                    {
                        idx: 3,
                        ResetTextAppearance: false
                    },
                    {
                        idx: 4,
                        ResetTextAppearance: false
                    }
                ],
                cacheKey: _this.configs.mcl.config.cacheKey,
                fme_ip: _this.configs.mcl.config.fme_ip,
                name: _this.configs.mcl.config.name,
                object_ID: _this.configs.mcl.config.object_ID,
                type: _this.configs.mcl.config.type
            };
            partial.EASWindows[_this.easWindowIndex - 1].ResetTextAppearance = true;
            _this.snpListSrv
                .applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.mclForm)
                .then(function () {
                var mclId = common_1.snpMCLId(_this.processor);
                // Refresh configuration
                _this.snpListSrv.getObjects(_this.fmeIp, [
                    {
                        type: common_1.SNP_OBJTYPE_MCL,
                        object_ID: mclId,
                        getConfig: true,
                        getStatus: true,
                    }
                ]).then(function (objects) {
                    _this.configs = {
                        mcl: {
                            config: objects[mclId].config,
                            meta: objects[mclId].configMetadata
                        }
                    };
                    _this.statuses = {
                        mcl: {
                            status: objects[mclId].status,
                            meta: objects[mclId].statusMetadata
                        }
                    };
                });
                // updated value will be used in liveCallback and html
                _this.configs.mcl.config.EASWindows[_this.easWindowIndex].ResetTextAppearance = false;
            });
        };
        this.$doCheck = function () {
            if (_this.report && _this.report.partial) {
                if (_this.report.partial.SrcNameTable) {
                    var adjustedIdx = _this.srcNameIdx - 1;
                    var changedValue = _this.configs.mcl.config.SrcNameTable[adjustedIdx].LogicalSrcName;
                    var SrcNameTable = _this.report.partial.SrcNameTable;
                    var wrongValue = SrcNameTable[adjustedIdx].LogicalSrcName;
                    if (SrcNameTable && changedValue !== wrongValue) {
                        _this.report = undefined;
                    }
                }
                else if (_this.report.partial.RoutingControl) {
                    var _a = _this.report.partial.RoutingControl, DstNameBusA = _a.DstNameBusA, DstNameBusB = _a.DstNameBusB, PgmFollow = _a.PgmFollow, PstFollow = _a.PstFollow, DstNameAux = _a.DstNameAux;
                    if (DstNameBusA && _this.configs.mcl.config.RoutingControl.DstNameBusA !== DstNameBusA) {
                        _this.report = undefined;
                    }
                    if (DstNameBusB && _this.configs.mcl.config.RoutingControl.DstNameBusB !== DstNameBusB) {
                        _this.report = undefined;
                    }
                    if (PgmFollow && _this.configs.mcl.config.RoutingControl.PgmFollow !== PgmFollow) {
                        _this.report = undefined;
                    }
                    if (PstFollow && _this.configs.mcl.config.RoutingControl.PstFollow !== PstFollow) {
                        _this.report = undefined;
                    }
                    if (DstNameAux && _this.configs.mcl.config.RoutingControl.DstNameAux !== DstNameAux) {
                        _this.report = undefined;
                    }
                }
            }
            if (_this.currentMclMode !== _this.processor.general.mclMode) {
                _this.init();
                _this.updateRoutingConfigNames();
            }
            if (_this.lastMclVidStd !== undefined && _this.lastMclVidStd !== _this.processor.general.mclOutputVideoStandard) {
                _this.updateLogoPositionLimits();
                _this.lastMclVidStd = _this.processor.general.mclOutputVideoStandard;
            }
            if (_this.lastGfxList !== undefined &&
                (_this.lastGfxList !== _this.configs.mcl.config.KeyerControl[0].SrcSelect_optList ||
                    _this.lastGfxOnlineList !== _this.statuses.mcl.status.LogoStatus.onlineLogos ||
                    _this.lastGfxCachedList !== _this.statuses.mcl.status.LogoStatus.cachedLogos)) {
                _this.getGraphicsListForKeyer();
            }
            if (_this.lastSrcNameList !== undefined && _this.lastSrcNameList !== _this.configs.mcl.config.RoutingControl.PgmSrcSelect_optList) {
                _this.getSourceListForRouting();
            }
            if (_this.lastCleanFeedList !== undefined && _this.lastCleanFeedList !== _this.configs.mcl.config.CleanFeedConfiguration.CleanFeedOutput2_optList) {
                _this.getSection2CleanFeedList();
            }
            if (_this.lastFxList !== undefined && _this.lastFxList !== _this.configs.mcl.config.TransitionControls.Pgm1_FXSelect_optList) {
                _this.getFXList();
            }
            if (_this.lastTriggerActionList !== undefined && _this.lastTriggerActionList !== _this.configs.mcl.config.GPIConfiguration[0].triggerAction_optList) {
                _this.updateTriggerActionDropdownLabels();
            }
            _this.tabState.dirty = _this.mclForm && _this.mclForm.$dirty;
            _this.tabState.valid = !_this.report;
        };
        this.$onDestroy = function () {
            console.log('MCL > onDestroy');
            if (_this.liveUpdater) {
                _this.liveUpdater.release();
            }
            _this.fmeListSrv.msgStatusUnsubscribe(_this.onReceiveStatusHandler, _this.statusHeaders);
        };
        this.isHotPunchChecked;
        var mclId = common_1.snpMCLId(this.processor);
        this.statusHeaders = [
            {
                fme_ip: this.fmeIp,
                type: common_1.SNP_OBJTYPE_MCL,
                object_ID: mclId,
            }
        ];
        this.snpListSrv.getObjects(this.fmeIp, [
            {
                type: common_1.SNP_OBJTYPE_MCL,
                object_ID: mclId,
                getConfig: true,
                getStatus: true,
            }
        ]).then(function (objects) {
            _this.configs = {
                mcl: {
                    config: objects[mclId].config,
                    meta: objects[mclId].configMetadata
                }
            };
            _this.statuses = {
                mcl: {
                    status: objects[mclId].status,
                    meta: objects[mclId].statusMetadata
                }
            };
            // Add custom titles
            for (var i in _this.configs.mcl.config.ProgramKeyerControl) {
                var idx = Number.parseInt(i) + 1;
                var metaIdx = "metaPgm" + idx;
                var meta = angular_1.copy(objects[mclId].configMetadata);
                meta.properties.ProgramKeyerControl.items.properties.PgmKey.title += (" " + idx);
                _this.configs.mcl = __assign({}, _this.configs.mcl, (_a = {}, _a[metaIdx] = meta, _a));
            }
            fmeListSrv.msgStatusSubscribe(_this.onReceiveStatusHandler, _this.statusHeaders);
            _this.updateRoutingConfigNames();
            if (_this.configs.mcl.meta.properties.KeyerControl.items.properties.hasOwnProperty("SrcSelect")) {
                _this.configs.mcl.meta.properties.KeyerControl.items.properties.SrcSelect.enum = [];
                _this.configs.mcl.meta.properties.KeyerControl.items.properties.SrcSelect.enumLabels = [];
                for (var i_1 = 0; i_1 < 4; i_1++) {
                    _this.$scope.$broadcast('adjustedMetadata', {
                        property: '/KeyerControl/' + i_1 + '/SrcSelect'
                    });
                }
                _this.getGraphicsListForKeyer();
            }
            if (_this.configs.mcl.meta.properties.RoutingControl.properties.hasOwnProperty("PgmSrcSelect")) {
                _this.getSourceListForRouting();
            }
            if (_this.configs.mcl.meta.properties.CleanFeedConfiguration.properties.hasOwnProperty("CleanFeedOutput2")) {
                _this.getSection2CleanFeedList();
            }
            if (_this.configs.mcl.meta.properties.TransitionControls.properties.hasOwnProperty("Pgm1_FXSelect")) {
                _this.getFXList();
            }
            if (_this.configs.mcl.meta.properties.MclConfiguration.properties.hasOwnProperty("UHD_InputRoutingConfiguration")) {
                _this.configs.mcl.meta.properties.MclConfiguration.properties.UHD_InputRoutingConfiguration.enum = _this.getUHDRoutingConfigList(mclId);
                _this.$scope.$broadcast('adjustedMetadata', {
                    property: '/MclConfiguration/UHD_InputRoutingConfiguration'
                });
            }
            if (_this.configs.mcl.meta.properties.TransitionControls.properties.hasOwnProperty("Pgm1_TransitionType")) {
                _this.configs.mcl.meta.properties.TransitionControls.properties.Pgm1_TransitionType.enum = _this.getTransitionTypeConfigList(mclId, 0);
                _this.$scope.$broadcast('adjustedMetadata', {
                    property: '/TransitionControls/Pgm1_TransitionType'
                });
            }
            if (_this.configs.mcl.meta.properties.TransitionControls.properties.hasOwnProperty("Pgm2_TransitionType")) {
                _this.configs.mcl.meta.properties.TransitionControls.properties.Pgm2_TransitionType.enum = _this.getTransitionTypeConfigList(mclId, 1);
                _this.$scope.$broadcast('adjustedMetadata', {
                    property: '/TransitionControls/Pgm2_TransitionType'
                });
            }
            _this.lastMclVidStd = _this.processor.general.mclOutputVideoStandard;
            _this.updateLogoPositionLimits();
            // Disable some GPI action indexes based on the MCL Type
            _this.updateTriggerActionDropdownLabels();
            _this.liveUpdater = _this.liveParamsSrv.liveParamsUpdater(_this.configs.mcl.config, _this.configs.mcl.meta);
            _this.updateOrigConfig();
            _this.isHotPunchChecked = _this.configs.mcl.config.MclConfiguration.HotPunch === true;
            for (var i_2 = 0; i_2 < 32; ++i_2) {
                _this.srcNameIdxArray.push({
                    label: (i_2 + 1).toString(),
                    value: i_2 + 1
                });
            }
            var audioLayerLabels = ["Keyer 1", "Keyer 2", "Keyer 3", "Keyer 4", "Audio Over", "EAS Keyer"];
            for (var i_3 = 0; i_3 < audioLayerLabels.length; ++i_3) {
                _this.audioLayerIdxArray.push({
                    label: audioLayerLabels[i_3],
                    value: i_3
                });
            }
            for (var i_4 = 0; i_4 < 16; ++i_4) {
                _this.audioChannelIdxArray.push({
                    label: (i_4 + 1).toString(),
                    value: i_4 + 1
                });
            }
            for (var i_5 = 0; i_5 < 24; ++i_5) {
                _this.gpiIndexArray.push({
                    label: (i_5 + 1).toString(),
                    value: i_5 + 1
                });
                _this.gpoIndexArray.push({
                    label: (i_5 + 1).toString(),
                    value: i_5 + 1
                });
            }
            var easWindowLabels = ["Severity 1", "Severity 2", "Severity 3", "SNP Test Message"];
            for (var i_6 = 0; i_6 < 4; ++i_6) {
                _this.easWindowIndexArray.push({
                    label: easWindowLabels[i_6],
                    value: i_6 + 1
                });
            }
            _this.arrayIndexes = {
                SrcNameTable: common_1.snpSparseArrayIdx(_this.configs.mcl.config.SrcNameTable, _this.srcNameIdxArray[0].value),
                AudioChannelConfiguration: common_1.snpSparseArrayIdx(_this.configs.mcl.config.AudioChannelConfiguration, (_this.audioLayerIdxArray[0].value * 16) + _this.audioChannelIdxArray[0].value),
                GPIConfig: common_1.snpSparseArrayIdx(_this.configs.mcl.config.GPIConfiguration, _this.gpiIndexArray[0].value),
                GPOConfig: common_1.snpSparseArrayIdx(_this.configs.mcl.config.GPOConfiguration, _this.gpoIndexArray[0].value),
                EASWindows: common_1.snpSparseArrayIdx(_this.configs.mcl.config.EASWindows, _this.easWindowIndexArray[0].value)
            };
            var easMeta = _this.configs.mcl.meta.properties.EASConfiguration.properties;
            var easWindowsMeta = _this.configs.mcl.meta.properties.EASWindows.items.properties;
            // Only Sage Digital ENDEC is supported for now
            easMeta.DecoderProtocol.disabledIndexes = [1, 2, 3, 4];
            // Not supporting GPI + EAS features for now, only TCP/IP
            easMeta.DataSource.disabledIndexes = [1];
            // Only supporting Scrolling Text for now
            easWindowsMeta.Speed.disabledIndexes = [0];
            // Audio Clip source is not supported yet
            _this.configs.mcl.meta.properties.AudioControls.properties.AudioOverSrcSelect.disabledIndexes = [12];
            _this.configs.mcl.meta.properties.AudioControls.properties.EASSrcSelect.disabledIndexes = [12];
            _this.showTestStopButton = false;
            _this.metaRedButton = angular_1.copy(_this.configs.mcl.meta);
            _this.metaRedButton.properties.TextGenerator.properties.TriggerTestMessage.title = "Stop Test Message";
            var _a;
        });
        this.init();
    }
    SnpProcessorMclCtrl.prototype.checkIfFtbButtonDisabled = function (num) {
        var val;
        switch (num) {
            case 1:
                val = this.configs.mcl.config.FadeToBlackControls.Pgm1_FadeToBlackConfig;
                break;
            case 2:
                val = this.configs.mcl.config.FadeToBlackControls.Pgm2_FadeToBlackConfig;
                break;
            default:
                break;
        }
        if (val === "Disabled") {
            return true;
        }
        else {
            return false;
        }
    };
    SnpProcessorMclCtrl.prototype.matchOrigConfig = function (param1, param2, param3) {
        if (angular_1.isUndefined(param2)) {
            return angular_1.equals(this.configs.mcl.config[param1], this.origMcl[param1]);
        }
        else if (angular_1.isUndefined(param3)) {
            return Array.isArray(this.configs.mcl.config[param1]) ? false : angular_1.equals(this.configs.mcl.config[param1][param2], this.origMcl[param1][param2]);
        }
        else {
            return param3 === 'idx' ? false : angular_1.equals(this.configs.mcl.config[param1][param2][param3], this.origMcl[param1][param2][param3]);
        }
    };
    SnpProcessorMclCtrl.prototype.setKeyerControlPropToPartial = function (partial_link, param, value) {
        var keyerControlParts = param.split("/").slice(1);
        var keyerControl = keyerControlParts[0], keyerControlIdx = keyerControlParts[1], keyerControlProperty = keyerControlParts[2];
        partial_link[keyerControl][keyerControlIdx][keyerControlProperty] = value;
    };
    SnpProcessorMclCtrl.prototype.setSrcNameTablePropToPartial = function (partial_link, param, value) {
        var srcNameTableParts = param.split("/").slice(1);
        var srcNameTable = srcNameTableParts[0], srcNameTableIdx = srcNameTableParts[1], srcNameTableProperty = srcNameTableParts[2];
        partial_link[srcNameTable][srcNameTableIdx][srcNameTableProperty] = value;
    };
    return SnpProcessorMclCtrl;
}());
exports.SnpProcessorMclCtrl = SnpProcessorMclCtrl;


/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/mcl/mcl.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/processor/processor-modal-window/mcl/mcl.template.html?af269ea7039784599fbff8d46f0d0aff";

/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/personality/personality.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var personality_controller_1 = __webpack_require__("./app/view-menu/processor/processor-modal-window/personality/personality.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/processor/processor-modal-window/personality/personality.template.html");
exports.SnpProcessorPersonalityComponent = {
    bindings: {
        fmeIp: '<',
        processor: '=',
        license: '=',
        licenseTokens: '=',
        switchState: '=',
        status: '<',
        tabState: '=',
        applyButtons: '=',
        userViewOnly: '<'
    },
    controller: personality_controller_1.SnpProcessorPersonalityCtrl,
    templateUrl: templateUrl,
};


/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/personality/personality.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
/**
 Copyright (c) 2018 Imagine Communications Corp.
 All rights reserved.
 */
var angular_1 = __webpack_require__("./node_modules/angular/index.js");
var common_1 = __webpack_require__("./app/view-menu/common.js");
var SnpProcessorPersonalityCtrl = (function () {
    // static $inject = ['snpListSrv'];
    function SnpProcessorPersonalityCtrl(snpListSrv, userManagerSrv, $scope) {
        var _this = this;
        this.snpListSrv = snpListSrv;
        this.userManagerSrv = userManagerSrv;
        this.$scope = $scope;
        this.prevPersonality = null;
        this.appliedPersonality = null;
        this.personalityList = [
            {
                'label': 'Sync',
                'value': common_1.SNP_PERSONALITY_SYNC,
                'license': 'SNP-SK-SYNC',
                'isPreview': false
            },
            {
                'label': 'Remap',
                'value': common_1.SNP_PERSONALITY_REMAP,
                'license': 'SNP-SK-SYNC',
                'isPreview': false
            },
            {
                'label': 'Conversion',
                'value': common_1.SNP_PERSONALITY_CONVERT,
                'license': 'SNP-SK-DUAL-CONV',
                'isPreview': false
            },
            {
                'label': 'Quad Conversion',
                'value': common_1.SNP_PERSONALITY_CONV4,
                'license': 'SNP-SK-QUAD-3GCONV',
                'isPreview': false
            },
            {
                'label': 'Multiviewer',
                'value': common_1.SNP_PERSONALITY_MV,
                'license': 'SNP-SK-MV',
                'isPreview': false
            },
            {
                'label': 'Multiviewer (Portrait)',
                'value': common_1.SNP_PERSONALITY_MVP,
                'license': 'SNP-SK-MV',
                'isPreview': false
            },
            {
                'label': 'JPEG-XS Decoder (TR-08)',
                'value': common_1.SNP_PERSONALITY_JXSD,
                'license': 'SNP-SK-JXS-DEC',
                'isPreview': false
            },
            {
                'label': 'JPEG-XS Encoder (TR-08)',
                'value': common_1.SNP_PERSONALITY_JXSE,
                'license': 'SNP-SK-JXS-ENC',
                'isPreview': false
            },
            {
                'label': 'Master Control Lite',
                'value': common_1.SNP_PERSONALITY_MCL,
                'license': 'SNP-SK-MCL',
                'isPreview': false
            },
            {
                'label': 'STAT (Asynchronous Transport)',
                'value': common_1.SNP_PERSONALITY_STAT,
                'license': 'SNP-SK-SYNC',
                'isPreview': false
            },
            {
                'label': 'JPEG-XS Encoder (TR-07)',
                'value': common_1.SNP_PERSONALITY_TR7E,
                'license': 'SNP-SK-JXS-ENC',
                'isPreview': false
            },
            {
                'label': 'JPEG-XS Decoder (TR-07)',
                'value': common_1.SNP_PERSONALITY_TR7D,
                'license': 'SNP-SK-JXS-DEC',
                'isPreview': false
            },
            {
                'label': 'JPEG-XS Encoder UHD (TR-07)',
                'value': common_1.SNP_PERSONALITY_TR7EU,
                'license': 'SNP-SK-JXS-ENC',
                'isPreview': false
            },
            {
                'label': 'JPEG-XS Decoder UHD (TR-07)',
                'value': common_1.SNP_PERSONALITY_TR7DU,
                'license': 'SNP-SK-JXS-DEC',
                'isPreview': false
            },
            {
                'label': 'Dual Gateway',
                'value': common_1.SNP_PERSONALITY_GW88,
                'license': 'SNP-SK-GW88',
                'isPreview': false
            },
            //  {
            //    'label': 'APROC',
            //    'value': SNP_PERSONALITY_APROC,
            //    'license': 'SNP-SK-AMTX',
            //    'isPreview': false
            //  },
            {
                'label': 'Effects / Squeezeback',
                'value': common_1.SNP_PERSONALITY_FX,
                'license': 'SNP-SK-MCLFX',
                'isPreview': !common_1.FFLAG_MCL_FX_ENABLED
            }
        ];
        this.SNP_FPGA_SWITCH_STARTING = common_1.SNP_FPGA_SWITCH_STARTING;
        this.SNP_FPGA_LOADING_FAILED = common_1.SNP_FPGA_LOADING_FAILED;
        this.report = undefined;
        this.reportError = false;
        this.isSfpMadi = function (param) {
            return (_this.processor.general[param] === common_1.SFP_TYPE_2RX_MADI) || (_this.processor.general[param] === common_1.SFP_TYPE_2TX_MADI);
        };
        this.onApply = function () {
            //SNP-27281 ----------------------------------------------------------------
            if ((_this.processor.general.personality === common_1.SNP_PERSONALITY_MV || _this.processor.general.personality === common_1.SNP_PERSONALITY_MVP ||
                _this.processor.general.personality === common_1.SNP_PERSONALITY_CONVERT || _this.processor.general.personality === common_1.SNP_PERSONALITY_CONV4)) {
                if (_this.isSfpMadi('sfpSelect')) {
                    _this.processor.general.sfpSelect = common_1.SFP_TYPE_UNUSED;
                }
                if (_this.isSfpMadi('sfpRxSelect')) {
                    _this.processor.general.sfpRxSelect = common_1.SFP_TYPE_UNUSED;
                }
                if (_this.isSfpMadi('sfpTxSelect')) {
                    _this.processor.general.sfpTxSelect = common_1.SFP_TYPE_UNUSED;
                }
            }
            //--------------------------------------------------------------------------
            var partial = common_1.snpCopyObjHeader(_this.processor, _this.fmeIp);
            partial.general = {};
            if (_this.appliedPersonality === common_1.SNP_PERSONALITY_MV || _this.appliedPersonality === common_1.SNP_PERSONALITY_MVP) {
                partial.general.enable9thReceiver = false;
                _this.snpListSrv.applyPartialUpdate(partial);
                delete partial.general.enable9thReceiver;
            }
            if (_this.processor.general.personality !== common_1.SNP_PERSONALITY_SYNC && _this.processor.general.personality !== common_1.SNP_PERSONALITY_CONVERT) {
                partial.general.processorMode = 0;
                _this.snpListSrv.applyPartialUpdate(partial);
                delete partial.general.processorMode;
            }
            partial.general.personality = _this.processor.general.personality;
            partial.general.sfpSelect = _this.processor.general.sfpSelect;
            partial.general.sfpRxSelect = _this.processor.general.sfpRxSelect;
            partial.general.sfpTxSelect = _this.processor.general.sfpTxSelect;
            if (_this.processor.general.personality === common_1.SNP_PERSONALITY_STAT) {
                // force switching section to HD because UHD is not supported in 2.0 GA
                // const sections = this.processor.sections.map(elem=>{
                //   if (elem.opMode === 'UHD') {
                //     return {
                //       idx: elem.idx,
                //       opMode: 'HD',
                //       inputMode: elem.inputMode
                //     }
                //   }
                // })
                var sections = [];
                for (var _i = 0, _a = _this.processor.sections; _i < _a.length; _i++) {
                    var secion = _a[_i];
                    if (secion.opMode === 'UHD') {
                        sections.push({
                            idx: secion.idx,
                            opMode: 'HD',
                            inputMode: secion.inputMode
                        });
                    }
                }
                if (sections.length > 0) {
                    partial.sections = sections;
                }
            }
            return _this.snpListSrv.applyPartialUpdate(partial, function (report) {
                _this.report = report;
            }, _this.personalityForm).then(function () {
                _this.appliedPersonality = _this.processor.general.personality;
                _this.switchState.starting = true;
                _this.switchState.startingStatus = _this.status.fpgaLoadingStatus;
                _this.switchState.timeoutId = setTimeout(function (switchState) {
                    return function () {
                        switchState.starting = false;
                    };
                }(_this.switchState), 5000);
            });
        };
        this.isSelectable = function (personality) {
            var retVal = !personality.isPreview || _this.snpListSrv.isLicenseExists(_this.license, _this.licenseTokens, personality.license, _this.processor.object_ID);
            if (!retVal && (personality.value == common_1.SNP_PERSONALITY_MCL)) {
                retVal = _this.snpListSrv.isLicenseExists(_this.license, _this.licenseTokens, 'SNP-SK-MCLU', _this.processor.object_ID); // MCLU Feature should enable MCL personality as well
            }
            return retVal;
        };
        this.$doCheck = function () {
            _this.tabState.dirty = _this.personalityForm && _this.personalityForm.$dirty;
            var isFormValid = angular_1.isUndefined(_this.personalityForm) || _this.personalityForm.$valid;
            var isReportError = angular_1.isDefined(_this.report) && angular_1.isDefined(_this.report.hasErrorMsg) && !!_this.report.hasErrorMsg;
            _this.tabState.valid = isFormValid && !isReportError && _this.status.fpgaLoadingStatus !== common_1.SNP_FPGA_LOADING_FAILED;
            if (_this.tabState.dirty && _this.prevPersonality !== _this.processor.general.personality) {
                var _a = _this.personalityList.find(function (e) { return (e.value == _this.processor.general.personality); }), label = _a.label, license_1 = _a.license;
                if (license_1) {
                    if (_this.processor.general.personality === common_1.SNP_PERSONALITY_CONV4) {
                        var procId_1 = "proc" + _this.processor.object_ID.slice(-1);
                        var featureLicensed = _this.licenseTokens.filter(function (t) { return (t.keyName === license_1) && t[procId_1]; }).length > 0;
                        if (!_this.license.is_valid || !featureLicensed) {
                            _this.snpListSrv.checkLicense(_this.license, _this.licenseTokens, 'SNP-SK-DUAL-CONV', label, 'disable_output', _this.processor.object_ID);
                        }
                    }
                    else if (_this.processor.general.personality === common_1.SNP_PERSONALITY_MCL) {
                        var procId_2 = "proc" + _this.processor.object_ID.slice(-1);
                        var featureLicensed = _this.licenseTokens.filter(function (t) { return (t.keyName === license_1) && t[procId_2]; }).length > 0;
                        if (!_this.license.is_valid || !featureLicensed) {
                            _this.snpListSrv.checkLicense(_this.license, _this.licenseTokens, 'SNP-SK-MCLU', label, 'disable_output', _this.processor.object_ID);
                        }
                    }
                    else if ((_this.processor.general.personality === common_1.SNP_PERSONALITY_SYNC) ||
                        (_this.processor.general.personality === common_1.SNP_PERSONALITY_REMAP) ||
                        (_this.processor.general.personality === common_1.SNP_PERSONALITY_STAT)) {
                        var procId_3 = "proc" + _this.processor.object_ID.slice(-1);
                        var featureLicensed = _this.licenseTokens.filter(function (t) { return (t.keyName === license_1) && t[procId_3]; }).length > 0;
                        if (!_this.license.is_valid || !featureLicensed) {
                            _this.snpListSrv.checkLicense(_this.license, _this.licenseTokens, 'SNP-SK-GW88', label, 'disable_output', _this.processor.object_ID);
                        }
                    }
                    else {
                        _this.snpListSrv.checkLicense(_this.license, _this.licenseTokens, license_1, label, 'disable_output', _this.processor.object_ID);
                    }
                }
            }
            _this.prevPersonality = _this.processor.general.personality;
        };
        this.$onDestroy = function () { };
        $scope.isAdmin = false;
        var getUserGroup = function () {
            var groupName = userManagerSrv.getCurUserGroup().name;
            if (groupName !== undefined) {
                $scope.isAdmin = groupName === "Administrator";
            }
        };
        getUserGroup();
        this.applyButtons.length = 0;
        this.applyButtons.push({
            label: 'Apply Personality',
            isDisabled: function () {
                return _this.personalityForm.$pristine;
            },
            click: this.onApply,
        });
        this.prevPersonality = this.processor.general.personality;
        this.appliedPersonality = this.processor.general.personality;
    }
    return SnpProcessorPersonalityCtrl;
}());
exports.SnpProcessorPersonalityCtrl = SnpProcessorPersonalityCtrl;


/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/personality/personality.template.html":
/***/ (function(module, exports) {

module.exports = "packages/uifmm/dist/app/view-menu/processor/processor-modal-window/personality/personality.template.html?a70d3e7b7f959d765c9103f10b026f4f";

/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/processor-modal-window.component.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var processor_modal_window_controller_1 = __webpack_require__("./app/view-menu/processor/processor-modal-window/processor-modal-window.controller.ts");
var templateUrl = __webpack_require__("./app/view-menu/processor/processor-modal-window/processor-modal-window.template.html");
exports.createProcessorModalWindowComponent = function (library, passedProps) {
    return library.open({
        animation: true,
        backdrop: "static",
        // size:'wide',
        templateUrl: templateUrl,
        controller: processor_modal_window_controller_1.SnpProcessorModalWindowController,
        controllerAs: "$ctrl",
        resolve: {
            receivedProps: passedProps,
        },
    });
};


/***/ }),

/***/ "./app/view-menu/processor/processor-modal-window/processor-modal-window.controller.ts":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var angular = __webpack_require__("./node_modules/angular/index.js");
var common_1 = __webpack_require__("./app/view-menu/common.js");
var SnpProcessorModalWindowController = (function () {
    function SnpProcessorModalWindowController($scope, $uibModalInstance, receivedProps, fmeListSrv, snpListSrv, liveParamsSrv) {
        $scope.processor = angular.copy(receivedProps.processor);
        $scope.licenseTokens = receivedProps.licenseTokens;
        $scope.switchState = receivedProps.switchState;
        $scope.userViewOnly = fmeListSrv.isUserViewerOnly();
        $scope.fmeIp = fmeListSrv.getLastUsedElement().ip;
        $scope.isMADIenabled = false;
        $scope.isMclEnabled = false;
        $scope.status = {};
        $scope.license = undefined;
        fmeListSrv.getCommonLicense($scope.fmeIp).then(function (data) {
            $scope.license = data;
            var isMadiAllowedInPersonality = $scope.processor.general.personality === common_1.SNP_PERSONALITY_SYNC ||
                $scope.processor.general.personality === common_1.SNP_PERSONALITY_REMAP ||
                $scope.processor.general.personality === common_1.SNP_PERSONALITY_GW88 ||
                $scope.processor.general.personality === common_1.SNP_PERSONALITY_MCL;
            $scope.isMADIenabled = isMadiAllowedInPersonality && snpListSrv.isLicenseExists($scope.license, $scope.licenseTokens, 'SNP-SK-DUAL-MADI', $scope.processor.object_ID);
        });
        $scope.tabState = {
            sections: {
                valid: true
            },
            personality: {
                valid: true
            },